// services/viz/public/mojom/gpu.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  MjpegDecodeAcceleratorRemote as chromeosCamera_mojom_MjpegDecodeAcceleratorRemote,
  MjpegDecodeAcceleratorPendingReceiver as chromeosCamera_mojom_MjpegDecodeAcceleratorPendingReceiver
} from '../../../../components/chromeos_camera/common/mjpeg_decode_accelerator.mojom.m.js';

import {
  GpuFeatureInfo as gpu_mojom_GpuFeatureInfo,
  GpuFeatureInfoSpec as gpu_mojom_GpuFeatureInfoSpec
} from '../../../../gpu/ipc/common/gpu_feature_info.mojom.m.js';

import {
  GpuInfo as gpu_mojom_GpuInfo,
  GpuInfoSpec as gpu_mojom_GpuInfoSpec
} from '../../../../gpu/ipc/common/gpu_info.mojom.m.js';

import {
  SharedImageCapabilities as gpu_mojom_SharedImageCapabilities,
  SharedImageCapabilitiesSpec as gpu_mojom_SharedImageCapabilitiesSpec
} from '../../../../gpu/ipc/common/shared_image_capabilities.mojom.m.js';

import {
  VideoEncodeAcceleratorProviderRemote as media_mojom_VideoEncodeAcceleratorProviderRemote,
  VideoEncodeAcceleratorProviderPendingReceiver as media_mojom_VideoEncodeAcceleratorProviderPendingReceiver
} from '../../../../media/mojo/mojom/video_encode_accelerator.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GpuPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.Gpu', scope);
  }
}

/** @interface */
export class GpuInterface {
  
  /**
   * @return {!Promise<{
        clientId: !number,
        channelHandle: ?MojoHandle,
        gpuInfo: !gpu_mojom_GpuInfo,
        gpuFeatureInfo: !gpu_mojom_GpuFeatureInfo,
        sharedImageCapabilities: !gpu_mojom_SharedImageCapabilities,
   *  }>}
   */

  establishGpuChannel() {}
  
  /**
   * @param { !chromeosCamera_mojom_MjpegDecodeAcceleratorPendingReceiver } jda
   */

  createJpegDecodeAccelerator(jda) {}
  
  /**
   * @param { !media_mojom_VideoEncodeAcceleratorProviderPendingReceiver } veaProvider
   */

  createVideoEncodeAcceleratorProvider(veaProvider) {}
}

/**
 * @implements { GpuInterface }
 */
export class GpuRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GpuPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GpuPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GpuPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        clientId: !number,
        channelHandle: ?MojoHandle,
        gpuInfo: !gpu_mojom_GpuInfo,
        gpuFeatureInfo: !gpu_mojom_GpuFeatureInfo,
        sharedImageCapabilities: !gpu_mojom_SharedImageCapabilities,
   *  }>}
   */

  establishGpuChannel() {
    return this.proxy.sendMessage(
        0,
        Gpu_EstablishGpuChannel_ParamsSpec.$,
        Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !chromeosCamera_mojom_MjpegDecodeAcceleratorPendingReceiver } jda
   */

  createJpegDecodeAccelerator(
      jda) {
    this.proxy.sendMessage(
        1,
        Gpu_CreateJpegDecodeAccelerator_ParamsSpec.$,
        null,
        [
          jda
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoEncodeAcceleratorProviderPendingReceiver } veaProvider
   */

  createVideoEncodeAcceleratorProvider(
      veaProvider) {
    this.proxy.sendMessage(
        2,
        Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        [
          veaProvider
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Gpu
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GpuReceiver {
  /**
   * @param {!GpuInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GpuRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GpuRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GpuRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Gpu_EstablishGpuChannel_ParamsSpec.$,
        Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        impl.establishGpuChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Gpu_CreateJpegDecodeAccelerator_ParamsSpec.$,
        null,
        impl.createJpegDecodeAccelerator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        impl.createVideoEncodeAcceleratorProvider.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Gpu {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.Gpu";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GpuRemote}
   */
  static getRemote() {
    let remote = new GpuRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Gpu
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GpuCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GpuRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GpuRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.establishGpuChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Gpu_EstablishGpuChannel_ParamsSpec.$,
        Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        this.establishGpuChannel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createJpegDecodeAccelerator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Gpu_CreateJpegDecodeAccelerator_ParamsSpec.$,
        null,
        this.createJpegDecodeAccelerator.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoEncodeAcceleratorProvider =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        this.createVideoEncodeAcceleratorProvider.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Gpu_EstablishGpuChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Gpu_EstablishGpuChannel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Gpu_CreateJpegDecodeAccelerator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    Gpu_EstablishGpuChannel_ParamsSpec.$,
    'Gpu_EstablishGpuChannel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Gpu_EstablishGpuChannel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
    'Gpu_EstablishGpuChannel_ResponseParams',
    [
      mojo.internal.StructField(
        'clientId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelHandle', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpuInfo', 8,
        0,
        gpu_mojom_GpuInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpuFeatureInfo', 16,
        0,
        gpu_mojom_GpuFeatureInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedImageCapabilities', 24,
        0,
        gpu_mojom_SharedImageCapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Gpu_EstablishGpuChannel_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.clientId;
    /** @type { (MojoHandle|undefined) } */
    this.channelHandle;
    /** @type { !gpu_mojom_GpuInfo } */
    this.gpuInfo;
    /** @type { !gpu_mojom_GpuFeatureInfo } */
    this.gpuFeatureInfo;
    /** @type { !gpu_mojom_SharedImageCapabilities } */
    this.sharedImageCapabilities;
  }
}



mojo.internal.Struct(
    Gpu_CreateJpegDecodeAccelerator_ParamsSpec.$,
    'Gpu_CreateJpegDecodeAccelerator_Params',
    [
      mojo.internal.StructField(
        'jda', 0,
        0,
        mojo.internal.InterfaceRequest(chromeosCamera_mojom_MjpegDecodeAcceleratorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Gpu_CreateJpegDecodeAccelerator_Params {
  constructor() {
    /** @type { !chromeosCamera_mojom_MjpegDecodeAcceleratorPendingReceiver } */
    this.jda;
  }
}



mojo.internal.Struct(
    Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
    'Gpu_CreateVideoEncodeAcceleratorProvider_Params',
    [
      mojo.internal.StructField(
        'veaProvider', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_VideoEncodeAcceleratorProviderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Gpu_CreateVideoEncodeAcceleratorProvider_Params {
  constructor() {
    /** @type { !media_mojom_VideoEncodeAcceleratorProviderPendingReceiver } */
    this.veaProvider;
  }
}

