// services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var frame_sink_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_sink_id.mojom', '../compositing/frame_sink_id.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }



  function AggregatedHitTestRegion(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AggregatedHitTestRegion.prototype.initDefaults_ = function() {
    this.frameSinkId = null;
    this.flags = 0;
    this.asyncHitTestReasons = 0;
    this.rect = null;
    this.childCount = 0;
    this.transform = null;
  };
  AggregatedHitTestRegion.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AggregatedHitTestRegion.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AggregatedHitTestRegion.frameSinkId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_sink_id$.FrameSinkId, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AggregatedHitTestRegion.rect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AggregatedHitTestRegion.transform
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AggregatedHitTestRegion.encodedSize = codec.kStructHeaderSize + 40;

  AggregatedHitTestRegion.decode = function(decoder) {
    var packed;
    var val = new AggregatedHitTestRegion();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameSinkId =
        decoder.decodeStructPointer(frame_sink_id$.FrameSinkId);
    val.flags =
        decoder.decodeStruct(codec.Uint32);
    val.asyncHitTestReasons =
        decoder.decodeStruct(codec.Uint32);
    val.rect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.childCount =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.transform =
        decoder.decodeStructPointer(transform$.Transform);
    return val;
  };

  AggregatedHitTestRegion.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AggregatedHitTestRegion.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_sink_id$.FrameSinkId, val.frameSinkId);
    encoder.encodeStruct(codec.Uint32, val.flags);
    encoder.encodeStruct(codec.Uint32, val.asyncHitTestReasons);
    encoder.encodeStructPointer(geometry$.Rect, val.rect);
    encoder.encodeStruct(codec.Uint32, val.childCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(transform$.Transform, val.transform);
  };
  exports.AggregatedHitTestRegion = AggregatedHitTestRegion;
})();