// skia/public/mojom/bitmap.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'skia/public/mojom/bitmap.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('skia.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var image_info$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/image_info.mojom', 'image_info.mojom.js');
  }



  function BitmapN32(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitmapN32.prototype.initDefaults_ = function() {
    this.imageInfo = null;
    this.pixelData = null;
  };
  BitmapN32.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitmapN32.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapN32.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_info$.BitmapN32ImageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapN32.pixelData
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitmapN32.encodedSize = codec.kStructHeaderSize + 24;

  BitmapN32.decode = function(decoder) {
    var packed;
    var val = new BitmapN32();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageInfo =
        decoder.decodeStructPointer(image_info$.BitmapN32ImageInfo);
    val.pixelData =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  BitmapN32.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitmapN32.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_info$.BitmapN32ImageInfo, val.imageInfo);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.pixelData);
  };
  function BitmapWithArbitraryBpp(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitmapWithArbitraryBpp.prototype.initDefaults_ = function() {
    this.imageInfo = null;
    this.uNUSEDRowBytes = 0;
    this.pixelData = null;
  };
  BitmapWithArbitraryBpp.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitmapWithArbitraryBpp.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapWithArbitraryBpp.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_info$.ImageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BitmapWithArbitraryBpp.pixelData
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitmapWithArbitraryBpp.encodedSize = codec.kStructHeaderSize + 32;

  BitmapWithArbitraryBpp.decode = function(decoder) {
    var packed;
    var val = new BitmapWithArbitraryBpp();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageInfo =
        decoder.decodeStructPointer(image_info$.ImageInfo);
    val.uNUSEDRowBytes =
        decoder.decodeStruct(codec.Uint64);
    val.pixelData =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  BitmapWithArbitraryBpp.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitmapWithArbitraryBpp.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_info$.ImageInfo, val.imageInfo);
    encoder.encodeStruct(codec.Uint64, val.uNUSEDRowBytes);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.pixelData);
  };
  function BitmapMappedFromTrustedProcess(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitmapMappedFromTrustedProcess.prototype.initDefaults_ = function() {
    this.imageInfo = null;
    this.uNUSEDRowBytes = 0;
    this.pixelData = null;
  };
  BitmapMappedFromTrustedProcess.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitmapMappedFromTrustedProcess.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapMappedFromTrustedProcess.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_info$.ImageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BitmapMappedFromTrustedProcess.pixelData
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitmapMappedFromTrustedProcess.encodedSize = codec.kStructHeaderSize + 32;

  BitmapMappedFromTrustedProcess.decode = function(decoder) {
    var packed;
    var val = new BitmapMappedFromTrustedProcess();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageInfo =
        decoder.decodeStructPointer(image_info$.ImageInfo);
    val.uNUSEDRowBytes =
        decoder.decodeStruct(codec.Uint64);
    val.pixelData =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  BitmapMappedFromTrustedProcess.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitmapMappedFromTrustedProcess.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_info$.ImageInfo, val.imageInfo);
    encoder.encodeStruct(codec.Uint64, val.uNUSEDRowBytes);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.pixelData);
  };
  function InlineBitmap(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InlineBitmap.prototype.initDefaults_ = function() {
    this.imageInfo = null;
    this.pixelData = null;
  };
  InlineBitmap.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InlineBitmap.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InlineBitmap.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, image_info$.BitmapN32ImageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InlineBitmap.pixelData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InlineBitmap.encodedSize = codec.kStructHeaderSize + 16;

  InlineBitmap.decode = function(decoder) {
    var packed;
    var val = new InlineBitmap();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageInfo =
        decoder.decodeStructPointer(image_info$.BitmapN32ImageInfo);
    val.pixelData =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  InlineBitmap.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InlineBitmap.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(image_info$.BitmapN32ImageInfo, val.imageInfo);
    encoder.encodeArrayPointer(codec.Uint8, val.pixelData);
  };
  exports.BitmapN32 = BitmapN32;
  exports.BitmapWithArbitraryBpp = BitmapWithArbitraryBpp;
  exports.BitmapMappedFromTrustedProcess = BitmapMappedFromTrustedProcess;
  exports.InlineBitmap = InlineBitmap;
})();