// third_party/blink/public/mojom/ai/ai_language_model.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AudioData as onDeviceModel_mojom_AudioData,
  AudioDataSpec as onDeviceModel_mojom_AudioDataSpec,
  ResponseConstraint as onDeviceModel_mojom_ResponseConstraint,
  ResponseConstraintSpec as onDeviceModel_mojom_ResponseConstraintSpec
} from '../../../../../services/on_device_model/public/mojom/on_device_model.mojom.m.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  AIManagerCreateClientError as blink_mojom_AIManagerCreateClientError,
  AIManagerCreateClientErrorSpec as blink_mojom_AIManagerCreateClientErrorSpec,
  AILanguageCode as blink_mojom_AILanguageCode,
  AILanguageCodeSpec as blink_mojom_AILanguageCodeSpec,
  QuotaErrorInfo as blink_mojom_QuotaErrorInfo,
  QuotaErrorInfoSpec as blink_mojom_QuotaErrorInfoSpec
} from './ai_common.mojom.m.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from './model_streaming_responder.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AILanguageModelPromptRoleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AILanguageModelPromptRole = {
  
  kSystem: 0,
  kUser: 1,
  kAssistant: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AILanguageModelPromptTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AILanguageModelPromptType = {
  
  kText: 0,
  kImage: 1,
  kAudio: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerCreateLanguageModelClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManagerCreateLanguageModelClient', scope);
  }
}

/** @interface */
export class AIManagerCreateLanguageModelClientInterface {
  
  /**
   * @param { !AILanguageModelRemote } languageModelRemote
   * @param { !AILanguageModelInstanceInfo } info
   */

  onResult(languageModelRemote, info) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
}

/**
 * @implements { AIManagerCreateLanguageModelClientInterface }
 */
export class AIManagerCreateLanguageModelClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerCreateLanguageModelClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerCreateLanguageModelClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerCreateLanguageModelClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AILanguageModelRemote } languageModelRemote
   * @param { !AILanguageModelInstanceInfo } info
   */

  onResult(
      languageModelRemote,
      info) {
    this.proxy.sendMessage(
        0,
        AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        [
          languageModelRemote,
          info
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManagerCreateLanguageModelClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerCreateLanguageModelClientReceiver {
  /**
   * @param {!AIManagerCreateLanguageModelClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerCreateLanguageModelClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerCreateLanguageModelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateLanguageModelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManagerCreateLanguageModelClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateLanguageModelClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerCreateLanguageModelClientRemote}
   */
  static getRemote() {
    let remote = new AIManagerCreateLanguageModelClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManagerCreateLanguageModelClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCreateLanguageModelClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerCreateLanguageModelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateLanguageModelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AILanguageModelPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AILanguageModel', scope);
  }
}

/** @interface */
export class AILanguageModelInterface {
  
  /**
   * @param { !Array<!AILanguageModelPrompt> } prompts
   * @param { ?onDeviceModel_mojom_ResponseConstraint } constraint
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  prompt(prompts, constraint, pendingResponder) {}
  
  /**
   * @param { !Array<!AILanguageModelPrompt> } prompts
   * @param { !blink_mojom_ModelStreamingResponderRemote } client
   */

  append(prompts, client) {}
  
  /**
   * @param { !AIManagerCreateLanguageModelClientRemote } client
   */

  fork(client) {}
  
  /**
   */

  destroy() {}
  
  /**
   * @param { !Array<!AILanguageModelPrompt> } input
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureInputUsage(input) {}
}

/**
 * @implements { AILanguageModelInterface }
 */
export class AILanguageModelRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AILanguageModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AILanguageModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AILanguageModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!AILanguageModelPrompt> } prompts
   * @param { ?onDeviceModel_mojom_ResponseConstraint } constraint
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  prompt(
      prompts,
      constraint,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        AILanguageModel_Prompt_ParamsSpec.$,
        null,
        [
          prompts,
          constraint,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !Array<!AILanguageModelPrompt> } prompts
   * @param { !blink_mojom_ModelStreamingResponderRemote } client
   */

  append(
      prompts,
      client) {
    this.proxy.sendMessage(
        1,
        AILanguageModel_Append_ParamsSpec.$,
        null,
        [
          prompts,
          client
        ],
        false);
  }

  
  /**
   * @param { !AIManagerCreateLanguageModelClientRemote } client
   */

  fork(
      client) {
    this.proxy.sendMessage(
        2,
        AILanguageModel_Fork_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   */

  destroy() {
    this.proxy.sendMessage(
        3,
        AILanguageModel_Destroy_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!AILanguageModelPrompt> } input
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureInputUsage(
      input) {
    return this.proxy.sendMessage(
        4,
        AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AILanguageModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AILanguageModelReceiver {
  /**
   * @param {!AILanguageModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AILanguageModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AILanguageModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AILanguageModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AILanguageModel_Prompt_ParamsSpec.$,
        null,
        impl.prompt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AILanguageModel_Append_ParamsSpec.$,
        null,
        impl.append.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AILanguageModel_Fork_ParamsSpec.$,
        null,
        impl.fork.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AILanguageModel_Destroy_ParamsSpec.$,
        null,
        impl.destroy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        impl.measureInputUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AILanguageModel {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AILanguageModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AILanguageModelRemote}
   */
  static getRemote() {
    let remote = new AILanguageModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AILanguageModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AILanguageModelCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AILanguageModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AILanguageModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prompt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AILanguageModel_Prompt_ParamsSpec.$,
        null,
        this.prompt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.append =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AILanguageModel_Append_ParamsSpec.$,
        null,
        this.append.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AILanguageModel_Fork_ParamsSpec.$,
        null,
        this.fork.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AILanguageModel_Destroy_ParamsSpec.$,
        null,
        this.destroy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureInputUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        this.measureInputUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelSamplingParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelInstanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelExpectedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelPromptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModelCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateLanguageModelClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateLanguageModelClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_Prompt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_Append_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_Fork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_Destroy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_MeasureInputUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AILanguageModel_MeasureInputUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AILanguageModelPromptContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AILanguageModelSamplingParamsSpec.$,
    'AILanguageModelSamplingParams',
    [
      mojo.internal.StructField(
        'topK', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'temperature', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AILanguageModelSamplingParams {
  constructor() {
    /** @type { !number } */
    this.topK;
    /** @type { !number } */
    this.temperature;
  }
}



mojo.internal.Struct(
    AILanguageModelParamsSpec.$,
    'AILanguageModelParams',
    [
      mojo.internal.StructField(
        'defaultSamplingParams', 0,
        0,
        AILanguageModelSamplingParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSamplingParams', 8,
        0,
        AILanguageModelSamplingParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AILanguageModelParams {
  constructor() {
    /** @type { !AILanguageModelSamplingParams } */
    this.defaultSamplingParams;
    /** @type { !AILanguageModelSamplingParams } */
    this.maxSamplingParams;
  }
}



mojo.internal.Struct(
    AILanguageModelInstanceInfoSpec.$,
    'AILanguageModelInstanceInfo',
    [
      mojo.internal.StructField(
        'inputQuota', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputUsage', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'samplingParams', 16,
        0,
        AILanguageModelSamplingParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputTypes', 24,
        0,
        mojo.internal.Array(AILanguageModelPromptTypeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AILanguageModelInstanceInfo {
  constructor() {
    /** @type { !bigint } */
    this.inputQuota;
    /** @type { !bigint } */
    this.inputUsage;
    /** @type { !AILanguageModelSamplingParams } */
    this.samplingParams;
    /** @type { (Array<!AILanguageModelPromptType>|undefined) } */
    this.inputTypes;
  }
}



mojo.internal.Struct(
    AILanguageModelExpectedSpec.$,
    'AILanguageModelExpected',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        AILanguageModelPromptTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'languages', 8,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AILanguageModelExpected {
  constructor() {
    /** @type { !AILanguageModelPromptType } */
    this.type;
    /** @type { (Array<!blink_mojom_AILanguageCode>|undefined) } */
    this.languages;
  }
}



mojo.internal.Struct(
    AILanguageModelPromptSpec.$,
    'AILanguageModelPrompt',
    [
      mojo.internal.StructField(
        'role', 0,
        0,
        AILanguageModelPromptRoleSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'content', 8,
        0,
        mojo.internal.Array(AILanguageModelPromptContentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPrefix', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AILanguageModelPrompt {
  constructor() {
    /** @type { !AILanguageModelPromptRole } */
    this.role;
    /** @type { !Array<!AILanguageModelPromptContent> } */
    this.content;
    /** @type { !boolean } */
    this.isPrefix;
  }
}



mojo.internal.Struct(
    AILanguageModelCreateOptionsSpec.$,
    'AILanguageModelCreateOptions',
    [
      mojo.internal.StructField(
        'samplingParams', 0,
        0,
        AILanguageModelSamplingParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialPrompts', 8,
        0,
        mojo.internal.Array(AILanguageModelPromptSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedInputs', 16,
        0,
        mojo.internal.Array(AILanguageModelExpectedSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedOutputs', 24,
        0,
        mojo.internal.Array(AILanguageModelExpectedSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AILanguageModelCreateOptions {
  constructor() {
    /** @type { (AILanguageModelSamplingParams|undefined) } */
    this.samplingParams;
    /** @type { !Array<!AILanguageModelPrompt> } */
    this.initialPrompts;
    /** @type { (Array<!AILanguageModelExpected>|undefined) } */
    this.expectedInputs;
    /** @type { (Array<!AILanguageModelExpected>|undefined) } */
    this.expectedOutputs;
  }
}



mojo.internal.Struct(
    AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
    'AIManagerCreateLanguageModelClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'languageModelRemote', 0,
        0,
        mojo.internal.InterfaceProxy(AILanguageModelRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'info', 8,
        0,
        AILanguageModelInstanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateLanguageModelClient_OnResult_Params {
  constructor() {
    /** @type { !AILanguageModelRemote } */
    this.languageModelRemote;
    /** @type { !AILanguageModelInstanceInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
    'AIManagerCreateLanguageModelClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_AIManagerCreateClientErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateLanguageModelClient_OnError_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateClientError } */
    this.error;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    AILanguageModel_Prompt_ParamsSpec.$,
    'AILanguageModel_Prompt_Params',
    [
      mojo.internal.StructField(
        'prompts', 0,
        0,
        mojo.internal.Array(AILanguageModelPromptSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'constraint', 8,
        0,
        onDeviceModel_mojom_ResponseConstraintSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 24,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AILanguageModel_Prompt_Params {
  constructor() {
    /** @type { !Array<!AILanguageModelPrompt> } */
    this.prompts;
    /** @type { (onDeviceModel_mojom_ResponseConstraint|undefined) } */
    this.constraint;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    AILanguageModel_Append_ParamsSpec.$,
    'AILanguageModel_Append_Params',
    [
      mojo.internal.StructField(
        'prompts', 0,
        0,
        mojo.internal.Array(AILanguageModelPromptSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AILanguageModel_Append_Params {
  constructor() {
    /** @type { !Array<!AILanguageModelPrompt> } */
    this.prompts;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    AILanguageModel_Fork_ParamsSpec.$,
    'AILanguageModel_Fork_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(AIManagerCreateLanguageModelClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AILanguageModel_Fork_Params {
  constructor() {
    /** @type { !AIManagerCreateLanguageModelClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    AILanguageModel_Destroy_ParamsSpec.$,
    'AILanguageModel_Destroy_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AILanguageModel_Destroy_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AILanguageModel_MeasureInputUsage_ParamsSpec.$,
    'AILanguageModel_MeasureInputUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.Array(AILanguageModelPromptSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AILanguageModel_MeasureInputUsage_Params {
  constructor() {
    /** @type { !Array<!AILanguageModelPrompt> } */
    this.input;
  }
}



mojo.internal.Struct(
    AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
    'AILanguageModel_MeasureInputUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AILanguageModel_MeasureInputUsage_ResponseParams {
  constructor() {
    /** @type { (number|undefined) } */
    this.numberOfTokens;
  }
}

mojo.internal.Union(
    AILanguageModelPromptContentSpec.$, 'AILanguageModelPromptContent',
    {
      'text': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'bitmap': {
        'ordinal': 1,
        'type': skia_mojom_BitmapN32Spec.$,
      },
      'audio': {
        'ordinal': 2,
        'type': onDeviceModel_mojom_AudioDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   text: (!string|undefined),
 *   bitmap: (!skia_mojom_BitmapN32|undefined),
 *   audio: (!onDeviceModel_mojom_AudioData|undefined),
 * } }
 */
export const AILanguageModelPromptContent = {};
