// third_party/blink/public/mojom/ai/ai_writer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AILanguageCode as blink_mojom_AILanguageCode,
  AILanguageCodeSpec as blink_mojom_AILanguageCodeSpec
} from './ai_common.mojom.m.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from './model_streaming_responder.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIWriterToneSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIWriterTone = {
  
  kFormal: 0,
  kNeutral: 1,
  kCasual: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIWriterFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIWriterFormat = {
  
  kPlainText: 0,
  kMarkdown: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIWriterLengthSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIWriterLength = {
  
  kShort: 0,
  kMedium: 1,
  kLong: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIWriterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIWriter', scope);
  }
}

/** @interface */
export class AIWriterInterface {
  
  /**
   * @param { !string } input
   * @param { ?string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  write(input, context, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(input, context) {}
}

/**
 * @implements { AIWriterInterface }
 */
export class AIWriterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIWriterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIWriterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIWriterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { ?string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  write(
      input,
      context,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        AIWriter_Write_ParamsSpec.$,
        null,
        [
          input,
          context,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(
      input,
      context) {
    return this.proxy.sendMessage(
        1,
        AIWriter_MeasureUsage_ParamsSpec.$,
        AIWriter_MeasureUsage_ResponseParamsSpec.$,
        [
          input,
          context
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIWriter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIWriterReceiver {
  /**
   * @param {!AIWriterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIWriterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIWriter_Write_ParamsSpec.$,
        null,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIWriter_MeasureUsage_ParamsSpec.$,
        AIWriter_MeasureUsage_ResponseParamsSpec.$,
        impl.measureUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIWriter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIWriter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIWriterRemote}
   */
  static getRemote() {
    let remote = new AIWriterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIWriter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIWriterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIWriter_Write_ParamsSpec.$,
        null,
        this.write.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIWriter_MeasureUsage_ParamsSpec.$,
        AIWriter_MeasureUsage_ResponseParamsSpec.$,
        this.measureUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIWriterCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIWriter_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIWriter_MeasureUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIWriter_MeasureUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AIWriterCreateOptionsSpec.$,
    'AIWriterCreateOptions',
    [
      mojo.internal.StructField(
        'sharedContext', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tone', 8,
        0,
        AIWriterToneSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'format', 12,
        0,
        AIWriterFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        AIWriterLengthSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 24,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedContextLanguages', 32,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputLanguage', 40,
        0,
        blink_mojom_AILanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AIWriterCreateOptions {
  constructor() {
    /** @type { (string|undefined) } */
    this.sharedContext;
    /** @type { !AIWriterTone } */
    this.tone;
    /** @type { !AIWriterFormat } */
    this.format;
    /** @type { !AIWriterLength } */
    this.length;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedInputLanguages;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedContextLanguages;
    /** @type { !blink_mojom_AILanguageCode } */
    this.outputLanguage;
  }
}



mojo.internal.Struct(
    AIWriter_Write_ParamsSpec.$,
    'AIWriter_Write_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 16,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIWriter_Write_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { (string|undefined) } */
    this.context;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    AIWriter_MeasureUsage_ParamsSpec.$,
    'AIWriter_MeasureUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIWriter_MeasureUsage_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !string } */
    this.context;
  }
}



mojo.internal.Struct(
    AIWriter_MeasureUsage_ResponseParamsSpec.$,
    'AIWriter_MeasureUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIWriter_MeasureUsage_ResponseParams {
  constructor() {
    /** @type { (number|undefined) } */
    this.numberOfTokens;
  }
}

