// third_party/blink/public/mojom/ai/model_download_progress_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ModelDownloadProgressObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ModelDownloadProgressObserver', scope);
  }
}

/** @interface */
export class ModelDownloadProgressObserverInterface {
  
  /**
   * @param { !bigint } downloadedBytes
   * @param { !bigint } totalBytes
   */

  onDownloadProgressUpdate(downloadedBytes, totalBytes) {}
}

/**
 * @implements { ModelDownloadProgressObserverInterface }
 */
export class ModelDownloadProgressObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ModelDownloadProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ModelDownloadProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ModelDownloadProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } downloadedBytes
   * @param { !bigint } totalBytes
   */

  onDownloadProgressUpdate(
      downloadedBytes,
      totalBytes) {
    this.proxy.sendMessage(
        0,
        ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        [
          downloadedBytes,
          totalBytes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ModelDownloadProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ModelDownloadProgressObserverReceiver {
  /**
   * @param {!ModelDownloadProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ModelDownloadProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ModelDownloadProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelDownloadProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        impl.onDownloadProgressUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ModelDownloadProgressObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ModelDownloadProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ModelDownloadProgressObserverRemote}
   */
  static getRemote() {
    let remote = new ModelDownloadProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ModelDownloadProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ModelDownloadProgressObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ModelDownloadProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ModelDownloadProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDownloadProgressUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        this.onDownloadProgressUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
    'ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params',
    [
      mojo.internal.StructField(
        'downloadedBytes', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'totalBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params {
  constructor() {
    /** @type { !bigint } */
    this.downloadedBytes;
    /** @type { !bigint } */
    this.totalBytes;
  }
}

