// third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.ReadOnlyFile');






goog.provide('blink.mojom.AndroidFontLookup');
goog.provide('blink.mojom.AndroidFontLookupReceiver');
goog.provide('blink.mojom.AndroidFontLookupCallbackRouter');
goog.provide('blink.mojom.AndroidFontLookupInterface');
goog.provide('blink.mojom.AndroidFontLookupRemote');
goog.provide('blink.mojom.AndroidFontLookupPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AndroidFontLookupPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AndroidFontLookup.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AndroidFontLookupInterface = class {
  
  /**
   * @return {!Promise<{
        uniqueFontNames: !Array<!string>,
   *  }>}
   */

  getUniqueNameLookupTable() {}
  
  /**
   * @param { !string } fontUniqueName
   * @return {!Promise<{
        fontFileHandle: ?mojoBase.mojom.ReadOnlyFile,
   *  }>}
   */

  matchLocalFontByUniqueName(fontUniqueName) {}
  
  /**
   * @return {!Promise<{
        fontFiles: !Object<!string, !mojoBase.mojom.ReadOnlyFile>,
   *  }>}
   */

  fetchAllFontFiles() {}
};

/**
 * @export
 * @implements { blink.mojom.AndroidFontLookupInterface }
 */
blink.mojom.AndroidFontLookupRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AndroidFontLookupPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AndroidFontLookupPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AndroidFontLookupPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        uniqueFontNames: !Array<!string>,
   *  }>}
   */

  getUniqueNameLookupTable() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } fontUniqueName
   * @return {!Promise<{
        fontFileHandle: ?mojoBase.mojom.ReadOnlyFile,
   *  }>}
   */

  matchLocalFontByUniqueName(
      fontUniqueName) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        [
          fontUniqueName
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        fontFiles: !Object<!string, !mojoBase.mojom.ReadOnlyFile>,
   *  }>}
   */

  fetchAllFontFiles() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AndroidFontLookup
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AndroidFontLookupReceiver = class {
  /**
   * @param {!blink.mojom.AndroidFontLookupInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AndroidFontLookupRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AndroidFontLookupRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AndroidFontLookupRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        impl.getUniqueNameLookupTable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        impl.matchLocalFontByUniqueName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        impl.fetchAllFontFiles.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AndroidFontLookup = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AndroidFontLookup";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AndroidFontLookupRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AndroidFontLookupRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AndroidFontLookup
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AndroidFontLookupCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AndroidFontLookupRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AndroidFontLookupRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueNameLookupTable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        this.getUniqueNameLookupTable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchLocalFontByUniqueName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        this.matchLocalFontByUniqueName.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchAllFontFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        this.fetchAllFontFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
    'AndroidFontLookup_GetUniqueNameLookupTable_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_Params');

/** @record */
blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
    'AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams',
    [
      mojo.internal.StructField(
        'uniqueFontNames', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams');

/** @record */
blink.mojom.AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.uniqueFontNames;
  }
};



mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
    'AndroidFontLookup_MatchLocalFontByUniqueName_Params',
    [
      mojo.internal.StructField(
        'fontUniqueName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_Params');

/** @record */
blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_Params = class {
  constructor() {
    /** @export { !string } */
    this.fontUniqueName;
  }
};



mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
    'AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams',
    [
      mojo.internal.StructField(
        'fontFileHandle', 0,
        0,
        mojoBase.mojom.ReadOnlyFileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams');

/** @record */
blink.mojom.AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.ReadOnlyFile|undefined) } */
    this.fontFileHandle;
  }
};



mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
    'AndroidFontLookup_FetchAllFontFiles_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AndroidFontLookup_FetchAllFontFiles_Params');

/** @record */
blink.mojom.AndroidFontLookup_FetchAllFontFiles_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
    'AndroidFontLookup_FetchAllFontFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'fontFiles', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase.mojom.ReadOnlyFileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParams');

/** @record */
blink.mojom.AndroidFontLookup_FetchAllFontFiles_ResponseParams = class {
  constructor() {
    /** @export { !Object<!string, !mojoBase.mojom.ReadOnlyFile> } */
    this.fontFiles;
  }
};

