// third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyFile as mojoBase_mojom_ReadOnlyFile,
  ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec
} from '../../../../../mojo/public/mojom/base/file.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AndroidFontLookupPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AndroidFontLookup', scope);
  }
}

/** @interface */
export class AndroidFontLookupInterface {
  
  /**
   * @return {!Promise<{
        uniqueFontNames: !Array<!string>,
   *  }>}
   */

  getUniqueNameLookupTable() {}
  
  /**
   * @param { !string } fontUniqueName
   * @return {!Promise<{
        fontFileHandle: ?mojoBase_mojom_ReadOnlyFile,
   *  }>}
   */

  matchLocalFontByUniqueName(fontUniqueName) {}
  
  /**
   * @return {!Promise<{
        fontFiles: !Object<!string, !mojoBase_mojom_ReadOnlyFile>,
   *  }>}
   */

  fetchAllFontFiles() {}
}

/**
 * @implements { AndroidFontLookupInterface }
 */
export class AndroidFontLookupRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AndroidFontLookupPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AndroidFontLookupPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AndroidFontLookupPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        uniqueFontNames: !Array<!string>,
   *  }>}
   */

  getUniqueNameLookupTable() {
    return this.proxy.sendMessage(
        0,
        AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } fontUniqueName
   * @return {!Promise<{
        fontFileHandle: ?mojoBase_mojom_ReadOnlyFile,
   *  }>}
   */

  matchLocalFontByUniqueName(
      fontUniqueName) {
    return this.proxy.sendMessage(
        1,
        AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        [
          fontUniqueName
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        fontFiles: !Object<!string, !mojoBase_mojom_ReadOnlyFile>,
   *  }>}
   */

  fetchAllFontFiles() {
    return this.proxy.sendMessage(
        2,
        AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AndroidFontLookup
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AndroidFontLookupReceiver {
  /**
   * @param {!AndroidFontLookupInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AndroidFontLookupRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AndroidFontLookupRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AndroidFontLookupRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        impl.getUniqueNameLookupTable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        impl.matchLocalFontByUniqueName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        impl.fetchAllFontFiles.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AndroidFontLookup {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AndroidFontLookup";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AndroidFontLookupRemote}
   */
  static getRemote() {
    let remote = new AndroidFontLookupRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AndroidFontLookup
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AndroidFontLookupCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AndroidFontLookupRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AndroidFontLookupRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueNameLookupTable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
        AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
        this.getUniqueNameLookupTable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchLocalFontByUniqueName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
        AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
        this.matchLocalFontByUniqueName.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchAllFontFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
        AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
        this.fetchAllFontFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_FetchAllFontFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AndroidFontLookup_GetUniqueNameLookupTable_ParamsSpec.$,
    'AndroidFontLookup_GetUniqueNameLookupTable_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AndroidFontLookup_GetUniqueNameLookupTable_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AndroidFontLookup_GetUniqueNameLookupTable_ResponseParamsSpec.$,
    'AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams',
    [
      mojo.internal.StructField(
        'uniqueFontNames', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AndroidFontLookup_GetUniqueNameLookupTable_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.uniqueFontNames;
  }
}



mojo.internal.Struct(
    AndroidFontLookup_MatchLocalFontByUniqueName_ParamsSpec.$,
    'AndroidFontLookup_MatchLocalFontByUniqueName_Params',
    [
      mojo.internal.StructField(
        'fontUniqueName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AndroidFontLookup_MatchLocalFontByUniqueName_Params {
  constructor() {
    /** @type { !string } */
    this.fontUniqueName;
  }
}



mojo.internal.Struct(
    AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParamsSpec.$,
    'AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams',
    [
      mojo.internal.StructField(
        'fontFileHandle', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AndroidFontLookup_MatchLocalFontByUniqueName_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_ReadOnlyFile|undefined) } */
    this.fontFileHandle;
  }
}



mojo.internal.Struct(
    AndroidFontLookup_FetchAllFontFiles_ParamsSpec.$,
    'AndroidFontLookup_FetchAllFontFiles_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AndroidFontLookup_FetchAllFontFiles_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AndroidFontLookup_FetchAllFontFiles_ResponseParamsSpec.$,
    'AndroidFontLookup_FetchAllFontFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'fontFiles', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase_mojom_ReadOnlyFileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AndroidFontLookup_FetchAllFontFiles_ResponseParams {
  constructor() {
    /** @type { !Object<!string, !mojoBase_mojom_ReadOnlyFile> } */
    this.fontFiles;
  }
}

