// third_party/blink/public/mojom/background_sync/background_sync.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/background_sync/background_sync.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var BackgroundSyncError = {};
  BackgroundSyncError.NONE = 0;
  BackgroundSyncError.STORAGE = 1;
  BackgroundSyncError.NOT_FOUND = 2;
  BackgroundSyncError.NO_SERVICE_WORKER = 3;
  BackgroundSyncError.NOT_ALLOWED = 4;
  BackgroundSyncError.PERMISSION_DENIED = 5;
  BackgroundSyncError.MAX = 5;
  BackgroundSyncError.MIN_VALUE = 0;
  BackgroundSyncError.MAX_VALUE = 5;

  BackgroundSyncError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  BackgroundSyncError.toKnownEnumValue = function(value) {
    return value;
  };

  BackgroundSyncError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BackgroundSyncState = {};
  BackgroundSyncState.PENDING = 0;
  BackgroundSyncState.FIRING = 1;
  BackgroundSyncState.REREGISTERED_WHILE_FIRING = 2;
  BackgroundSyncState.MIN_VALUE = 0;
  BackgroundSyncState.MAX_VALUE = 2;

  BackgroundSyncState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  BackgroundSyncState.toKnownEnumValue = function(value) {
    return value;
  };

  BackgroundSyncState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BackgroundSyncEventLastChance = {};
  BackgroundSyncEventLastChance.IS_NOT_LAST_CHANCE = 0;
  BackgroundSyncEventLastChance.IS_LAST_CHANCE = 1;
  BackgroundSyncEventLastChance.MIN_VALUE = 0;
  BackgroundSyncEventLastChance.MAX_VALUE = 1;

  BackgroundSyncEventLastChance.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  BackgroundSyncEventLastChance.toKnownEnumValue = function(value) {
    return value;
  };

  BackgroundSyncEventLastChance.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BackgroundSyncType = {};
  BackgroundSyncType.ONE_SHOT = 0;
  BackgroundSyncType.PERIODIC = 1;
  BackgroundSyncType.MIN_VALUE = 0;
  BackgroundSyncType.MAX_VALUE = 1;

  BackgroundSyncType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  BackgroundSyncType.toKnownEnumValue = function(value) {
    return value;
  };

  BackgroundSyncType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SyncRegistrationOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SyncRegistrationOptions.prototype.initDefaults_ = function() {
    this.tag = "";
    this.minInterval = -1;
  };
  SyncRegistrationOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SyncRegistrationOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SyncRegistrationOptions.tag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SyncRegistrationOptions.encodedSize = codec.kStructHeaderSize + 16;

  SyncRegistrationOptions.decode = function(decoder) {
    var packed;
    var val = new SyncRegistrationOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tag =
        decoder.decodeStruct(codec.String);
    val.minInterval =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  SyncRegistrationOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SyncRegistrationOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.tag);
    encoder.encodeStruct(codec.Int64, val.minInterval);
  };
  function BackgroundSyncRegistrationInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BackgroundSyncRegistrationInfo.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = -1;
    this.tag = null;
    this.syncType = 0;
  };
  BackgroundSyncRegistrationInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BackgroundSyncRegistrationInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BackgroundSyncRegistrationInfo.tag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BackgroundSyncRegistrationInfo.syncType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, BackgroundSyncType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BackgroundSyncRegistrationInfo.encodedSize = codec.kStructHeaderSize + 24;

  BackgroundSyncRegistrationInfo.decode = function(decoder) {
    var packed;
    var val = new BackgroundSyncRegistrationInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    val.tag =
        decoder.decodeStruct(codec.String);
    val.syncType =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BackgroundSyncRegistrationInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BackgroundSyncRegistrationInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
    encoder.encodeStruct(codec.String, val.tag);
    encoder.encodeStruct(codec.Int32, val.syncType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OneShotBackgroundSyncService_Register_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OneShotBackgroundSyncService_Register_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.serviceWorkerRegistrationId = 0;
  };
  OneShotBackgroundSyncService_Register_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OneShotBackgroundSyncService_Register_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_Register_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SyncRegistrationOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OneShotBackgroundSyncService_Register_Params.encodedSize = codec.kStructHeaderSize + 16;

  OneShotBackgroundSyncService_Register_Params.decode = function(decoder) {
    var packed;
    var val = new OneShotBackgroundSyncService_Register_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(SyncRegistrationOptions);
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  OneShotBackgroundSyncService_Register_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OneShotBackgroundSyncService_Register_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SyncRegistrationOptions, val.options);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
  };
  function OneShotBackgroundSyncService_Register_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OneShotBackgroundSyncService_Register_ResponseParams.prototype.initDefaults_ = function() {
    this.err = 0;
    this.options = null;
  };
  OneShotBackgroundSyncService_Register_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OneShotBackgroundSyncService_Register_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_Register_ResponseParams.err
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundSyncError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_Register_ResponseParams.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SyncRegistrationOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OneShotBackgroundSyncService_Register_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  OneShotBackgroundSyncService_Register_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OneShotBackgroundSyncService_Register_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.err =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(SyncRegistrationOptions);
    return val;
  };

  OneShotBackgroundSyncService_Register_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OneShotBackgroundSyncService_Register_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.err);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SyncRegistrationOptions, val.options);
  };
  function OneShotBackgroundSyncService_DidResolveRegistration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OneShotBackgroundSyncService_DidResolveRegistration_Params.prototype.initDefaults_ = function() {
    this.registrationInfo = null;
  };
  OneShotBackgroundSyncService_DidResolveRegistration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OneShotBackgroundSyncService_DidResolveRegistration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_DidResolveRegistration_Params.registrationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, BackgroundSyncRegistrationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OneShotBackgroundSyncService_DidResolveRegistration_Params.encodedSize = codec.kStructHeaderSize + 8;

  OneShotBackgroundSyncService_DidResolveRegistration_Params.decode = function(decoder) {
    var packed;
    var val = new OneShotBackgroundSyncService_DidResolveRegistration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.registrationInfo =
        decoder.decodeStructPointer(BackgroundSyncRegistrationInfo);
    return val;
  };

  OneShotBackgroundSyncService_DidResolveRegistration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OneShotBackgroundSyncService_DidResolveRegistration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(BackgroundSyncRegistrationInfo, val.registrationInfo);
  };
  function OneShotBackgroundSyncService_GetRegistrations_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OneShotBackgroundSyncService_GetRegistrations_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
  };
  OneShotBackgroundSyncService_GetRegistrations_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OneShotBackgroundSyncService_GetRegistrations_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OneShotBackgroundSyncService_GetRegistrations_Params.encodedSize = codec.kStructHeaderSize + 8;

  OneShotBackgroundSyncService_GetRegistrations_Params.decode = function(decoder) {
    var packed;
    var val = new OneShotBackgroundSyncService_GetRegistrations_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  OneShotBackgroundSyncService_GetRegistrations_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OneShotBackgroundSyncService_GetRegistrations_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
  };
  function OneShotBackgroundSyncService_GetRegistrations_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.prototype.initDefaults_ = function() {
    this.err = 0;
    this.registrations = null;
  };
  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_GetRegistrations_ResponseParams.err
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundSyncError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OneShotBackgroundSyncService_GetRegistrations_ResponseParams.registrations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SyncRegistrationOptions), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OneShotBackgroundSyncService_GetRegistrations_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.err =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.registrations =
        decoder.decodeArrayPointer(new codec.PointerTo(SyncRegistrationOptions));
    return val;
  };

  OneShotBackgroundSyncService_GetRegistrations_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OneShotBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.err);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(SyncRegistrationOptions), val.registrations);
  };
  function PeriodicBackgroundSyncService_Register_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_Register_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.serviceWorkerRegistrationId = 0;
  };
  PeriodicBackgroundSyncService_Register_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_Register_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_Register_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SyncRegistrationOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_Register_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeriodicBackgroundSyncService_Register_Params.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_Register_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(SyncRegistrationOptions);
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  PeriodicBackgroundSyncService_Register_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_Register_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SyncRegistrationOptions, val.options);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
  };
  function PeriodicBackgroundSyncService_Register_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_Register_ResponseParams.prototype.initDefaults_ = function() {
    this.err = 0;
    this.options = null;
  };
  PeriodicBackgroundSyncService_Register_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_Register_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_Register_ResponseParams.err
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundSyncError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_Register_ResponseParams.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SyncRegistrationOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_Register_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  PeriodicBackgroundSyncService_Register_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_Register_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.err =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(SyncRegistrationOptions);
    return val;
  };

  PeriodicBackgroundSyncService_Register_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_Register_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.err);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SyncRegistrationOptions, val.options);
  };
  function PeriodicBackgroundSyncService_Unregister_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_Unregister_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
    this.tag = null;
  };
  PeriodicBackgroundSyncService_Unregister_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_Unregister_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeriodicBackgroundSyncService_Unregister_Params.tag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_Unregister_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeriodicBackgroundSyncService_Unregister_Params.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_Unregister_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    val.tag =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeriodicBackgroundSyncService_Unregister_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_Unregister_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
    encoder.encodeStruct(codec.String, val.tag);
  };
  function PeriodicBackgroundSyncService_Unregister_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_Unregister_ResponseParams.prototype.initDefaults_ = function() {
    this.err = 0;
  };
  PeriodicBackgroundSyncService_Unregister_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_Unregister_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_Unregister_ResponseParams.err
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundSyncError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_Unregister_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PeriodicBackgroundSyncService_Unregister_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_Unregister_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.err =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeriodicBackgroundSyncService_Unregister_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_Unregister_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.err);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeriodicBackgroundSyncService_GetRegistrations_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_GetRegistrations_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
  };
  PeriodicBackgroundSyncService_GetRegistrations_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_GetRegistrations_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_GetRegistrations_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeriodicBackgroundSyncService_GetRegistrations_Params.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_GetRegistrations_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  PeriodicBackgroundSyncService_GetRegistrations_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_GetRegistrations_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
  };
  function PeriodicBackgroundSyncService_GetRegistrations_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.prototype.initDefaults_ = function() {
    this.err = 0;
    this.registrations = null;
  };
  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.err
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, BackgroundSyncError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.registrations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SyncRegistrationOptions), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PeriodicBackgroundSyncService_GetRegistrations_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.err =
        decoder.decodeStruct(new codec.Enum(BackgroundSyncError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.registrations =
        decoder.decodeArrayPointer(new codec.PointerTo(SyncRegistrationOptions));
    return val;
  };

  PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.err);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(SyncRegistrationOptions), val.registrations);
  };
  var kOneShotBackgroundSyncService_Register_Name = 0;
  var kOneShotBackgroundSyncService_DidResolveRegistration_Name = 1;
  var kOneShotBackgroundSyncService_GetRegistrations_Name = 2;

  function OneShotBackgroundSyncServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OneShotBackgroundSyncService,
                                                   handleOrPtrInfo);
  }

  function OneShotBackgroundSyncServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OneShotBackgroundSyncService, associatedInterfacePtrInfo);
  }

  OneShotBackgroundSyncServiceAssociatedPtr.prototype =
      Object.create(OneShotBackgroundSyncServicePtr.prototype);
  OneShotBackgroundSyncServiceAssociatedPtr.prototype.constructor =
      OneShotBackgroundSyncServiceAssociatedPtr;

  function OneShotBackgroundSyncServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  OneShotBackgroundSyncServicePtr.prototype.register = function() {
    return OneShotBackgroundSyncServiceProxy.prototype.register
        .apply(this.ptr.getProxy(), arguments);
  };

  OneShotBackgroundSyncServiceProxy.prototype.register = function(options, serviceWorkerRegistrationId) {
    var params_ = new OneShotBackgroundSyncService_Register_Params();
    params_.options = options;
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOneShotBackgroundSyncService_Register_Name,
          codec.align(OneShotBackgroundSyncService_Register_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OneShotBackgroundSyncService_Register_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OneShotBackgroundSyncService_Register_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OneShotBackgroundSyncServicePtr.prototype.didResolveRegistration = function() {
    return OneShotBackgroundSyncServiceProxy.prototype.didResolveRegistration
        .apply(this.ptr.getProxy(), arguments);
  };

  OneShotBackgroundSyncServiceProxy.prototype.didResolveRegistration = function(registrationInfo) {
    var params_ = new OneShotBackgroundSyncService_DidResolveRegistration_Params();
    params_.registrationInfo = registrationInfo;
    var builder = new codec.MessageV0Builder(
        kOneShotBackgroundSyncService_DidResolveRegistration_Name,
        codec.align(OneShotBackgroundSyncService_DidResolveRegistration_Params.encodedSize));
    builder.encodeStruct(OneShotBackgroundSyncService_DidResolveRegistration_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  OneShotBackgroundSyncServicePtr.prototype.getRegistrations = function() {
    return OneShotBackgroundSyncServiceProxy.prototype.getRegistrations
        .apply(this.ptr.getProxy(), arguments);
  };

  OneShotBackgroundSyncServiceProxy.prototype.getRegistrations = function(serviceWorkerRegistrationId) {
    var params_ = new OneShotBackgroundSyncService_GetRegistrations_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOneShotBackgroundSyncService_GetRegistrations_Name,
          codec.align(OneShotBackgroundSyncService_GetRegistrations_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OneShotBackgroundSyncService_GetRegistrations_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OneShotBackgroundSyncService_GetRegistrations_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function OneShotBackgroundSyncServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  OneShotBackgroundSyncServiceStub.prototype.register = function(options, serviceWorkerRegistrationId) {
    return this.delegate_ && this.delegate_.register && this.delegate_.register(options, serviceWorkerRegistrationId);
  }
  OneShotBackgroundSyncServiceStub.prototype.didResolveRegistration = function(registrationInfo) {
    return this.delegate_ && this.delegate_.didResolveRegistration && this.delegate_.didResolveRegistration(registrationInfo);
  }
  OneShotBackgroundSyncServiceStub.prototype.getRegistrations = function(serviceWorkerRegistrationId) {
    return this.delegate_ && this.delegate_.getRegistrations && this.delegate_.getRegistrations(serviceWorkerRegistrationId);
  }

  OneShotBackgroundSyncServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOneShotBackgroundSyncService_DidResolveRegistration_Name:
      var params = reader.decodeStruct(OneShotBackgroundSyncService_DidResolveRegistration_Params);
      this.didResolveRegistration(params.registrationInfo);
      return true;
    default:
      return false;
    }
  };

  OneShotBackgroundSyncServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOneShotBackgroundSyncService_Register_Name:
      var params = reader.decodeStruct(OneShotBackgroundSyncService_Register_Params);
      this.register(params.options, params.serviceWorkerRegistrationId).then(function(response) {
        var responseParams =
            new OneShotBackgroundSyncService_Register_ResponseParams();
        responseParams.err = response.err;
        responseParams.options = response.options;
        var builder = new codec.MessageV1Builder(
            kOneShotBackgroundSyncService_Register_Name,
            codec.align(OneShotBackgroundSyncService_Register_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OneShotBackgroundSyncService_Register_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOneShotBackgroundSyncService_GetRegistrations_Name:
      var params = reader.decodeStruct(OneShotBackgroundSyncService_GetRegistrations_Params);
      this.getRegistrations(params.serviceWorkerRegistrationId).then(function(response) {
        var responseParams =
            new OneShotBackgroundSyncService_GetRegistrations_ResponseParams();
        responseParams.err = response.err;
        responseParams.registrations = response.registrations;
        var builder = new codec.MessageV1Builder(
            kOneShotBackgroundSyncService_GetRegistrations_Name,
            codec.align(OneShotBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OneShotBackgroundSyncService_GetRegistrations_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateOneShotBackgroundSyncServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOneShotBackgroundSyncService_Register_Name:
        if (message.expectsResponse())
          paramsClass = OneShotBackgroundSyncService_Register_Params;
      break;
      case kOneShotBackgroundSyncService_DidResolveRegistration_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OneShotBackgroundSyncService_DidResolveRegistration_Params;
      break;
      case kOneShotBackgroundSyncService_GetRegistrations_Name:
        if (message.expectsResponse())
          paramsClass = OneShotBackgroundSyncService_GetRegistrations_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOneShotBackgroundSyncServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kOneShotBackgroundSyncService_Register_Name:
        if (message.isResponse())
          paramsClass = OneShotBackgroundSyncService_Register_ResponseParams;
        break;
      case kOneShotBackgroundSyncService_GetRegistrations_Name:
        if (message.isResponse())
          paramsClass = OneShotBackgroundSyncService_GetRegistrations_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var OneShotBackgroundSyncService = {
    name: 'blink.mojom.OneShotBackgroundSyncService',
    kVersion: 0,
    ptrClass: OneShotBackgroundSyncServicePtr,
    proxyClass: OneShotBackgroundSyncServiceProxy,
    stubClass: OneShotBackgroundSyncServiceStub,
    validateRequest: validateOneShotBackgroundSyncServiceRequest,
    validateResponse: validateOneShotBackgroundSyncServiceResponse,
  };
  OneShotBackgroundSyncServiceStub.prototype.validator = validateOneShotBackgroundSyncServiceRequest;
  OneShotBackgroundSyncServiceProxy.prototype.validator = validateOneShotBackgroundSyncServiceResponse;
  var kPeriodicBackgroundSyncService_Register_Name = 0;
  var kPeriodicBackgroundSyncService_Unregister_Name = 1;
  var kPeriodicBackgroundSyncService_GetRegistrations_Name = 2;

  function PeriodicBackgroundSyncServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PeriodicBackgroundSyncService,
                                                   handleOrPtrInfo);
  }

  function PeriodicBackgroundSyncServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PeriodicBackgroundSyncService, associatedInterfacePtrInfo);
  }

  PeriodicBackgroundSyncServiceAssociatedPtr.prototype =
      Object.create(PeriodicBackgroundSyncServicePtr.prototype);
  PeriodicBackgroundSyncServiceAssociatedPtr.prototype.constructor =
      PeriodicBackgroundSyncServiceAssociatedPtr;

  function PeriodicBackgroundSyncServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  PeriodicBackgroundSyncServicePtr.prototype.register = function() {
    return PeriodicBackgroundSyncServiceProxy.prototype.register
        .apply(this.ptr.getProxy(), arguments);
  };

  PeriodicBackgroundSyncServiceProxy.prototype.register = function(options, serviceWorkerRegistrationId) {
    var params_ = new PeriodicBackgroundSyncService_Register_Params();
    params_.options = options;
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPeriodicBackgroundSyncService_Register_Name,
          codec.align(PeriodicBackgroundSyncService_Register_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PeriodicBackgroundSyncService_Register_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PeriodicBackgroundSyncService_Register_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PeriodicBackgroundSyncServicePtr.prototype.unregister = function() {
    return PeriodicBackgroundSyncServiceProxy.prototype.unregister
        .apply(this.ptr.getProxy(), arguments);
  };

  PeriodicBackgroundSyncServiceProxy.prototype.unregister = function(serviceWorkerRegistrationId, tag) {
    var params_ = new PeriodicBackgroundSyncService_Unregister_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    params_.tag = tag;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPeriodicBackgroundSyncService_Unregister_Name,
          codec.align(PeriodicBackgroundSyncService_Unregister_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PeriodicBackgroundSyncService_Unregister_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PeriodicBackgroundSyncService_Unregister_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PeriodicBackgroundSyncServicePtr.prototype.getRegistrations = function() {
    return PeriodicBackgroundSyncServiceProxy.prototype.getRegistrations
        .apply(this.ptr.getProxy(), arguments);
  };

  PeriodicBackgroundSyncServiceProxy.prototype.getRegistrations = function(serviceWorkerRegistrationId) {
    var params_ = new PeriodicBackgroundSyncService_GetRegistrations_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPeriodicBackgroundSyncService_GetRegistrations_Name,
          codec.align(PeriodicBackgroundSyncService_GetRegistrations_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PeriodicBackgroundSyncService_GetRegistrations_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PeriodicBackgroundSyncService_GetRegistrations_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PeriodicBackgroundSyncServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  PeriodicBackgroundSyncServiceStub.prototype.register = function(options, serviceWorkerRegistrationId) {
    return this.delegate_ && this.delegate_.register && this.delegate_.register(options, serviceWorkerRegistrationId);
  }
  PeriodicBackgroundSyncServiceStub.prototype.unregister = function(serviceWorkerRegistrationId, tag) {
    return this.delegate_ && this.delegate_.unregister && this.delegate_.unregister(serviceWorkerRegistrationId, tag);
  }
  PeriodicBackgroundSyncServiceStub.prototype.getRegistrations = function(serviceWorkerRegistrationId) {
    return this.delegate_ && this.delegate_.getRegistrations && this.delegate_.getRegistrations(serviceWorkerRegistrationId);
  }

  PeriodicBackgroundSyncServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PeriodicBackgroundSyncServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPeriodicBackgroundSyncService_Register_Name:
      var params = reader.decodeStruct(PeriodicBackgroundSyncService_Register_Params);
      this.register(params.options, params.serviceWorkerRegistrationId).then(function(response) {
        var responseParams =
            new PeriodicBackgroundSyncService_Register_ResponseParams();
        responseParams.err = response.err;
        responseParams.options = response.options;
        var builder = new codec.MessageV1Builder(
            kPeriodicBackgroundSyncService_Register_Name,
            codec.align(PeriodicBackgroundSyncService_Register_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PeriodicBackgroundSyncService_Register_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPeriodicBackgroundSyncService_Unregister_Name:
      var params = reader.decodeStruct(PeriodicBackgroundSyncService_Unregister_Params);
      this.unregister(params.serviceWorkerRegistrationId, params.tag).then(function(response) {
        var responseParams =
            new PeriodicBackgroundSyncService_Unregister_ResponseParams();
        responseParams.err = response.err;
        var builder = new codec.MessageV1Builder(
            kPeriodicBackgroundSyncService_Unregister_Name,
            codec.align(PeriodicBackgroundSyncService_Unregister_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PeriodicBackgroundSyncService_Unregister_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPeriodicBackgroundSyncService_GetRegistrations_Name:
      var params = reader.decodeStruct(PeriodicBackgroundSyncService_GetRegistrations_Params);
      this.getRegistrations(params.serviceWorkerRegistrationId).then(function(response) {
        var responseParams =
            new PeriodicBackgroundSyncService_GetRegistrations_ResponseParams();
        responseParams.err = response.err;
        responseParams.registrations = response.registrations;
        var builder = new codec.MessageV1Builder(
            kPeriodicBackgroundSyncService_GetRegistrations_Name,
            codec.align(PeriodicBackgroundSyncService_GetRegistrations_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PeriodicBackgroundSyncService_GetRegistrations_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePeriodicBackgroundSyncServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPeriodicBackgroundSyncService_Register_Name:
        if (message.expectsResponse())
          paramsClass = PeriodicBackgroundSyncService_Register_Params;
      break;
      case kPeriodicBackgroundSyncService_Unregister_Name:
        if (message.expectsResponse())
          paramsClass = PeriodicBackgroundSyncService_Unregister_Params;
      break;
      case kPeriodicBackgroundSyncService_GetRegistrations_Name:
        if (message.expectsResponse())
          paramsClass = PeriodicBackgroundSyncService_GetRegistrations_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePeriodicBackgroundSyncServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPeriodicBackgroundSyncService_Register_Name:
        if (message.isResponse())
          paramsClass = PeriodicBackgroundSyncService_Register_ResponseParams;
        break;
      case kPeriodicBackgroundSyncService_Unregister_Name:
        if (message.isResponse())
          paramsClass = PeriodicBackgroundSyncService_Unregister_ResponseParams;
        break;
      case kPeriodicBackgroundSyncService_GetRegistrations_Name:
        if (message.isResponse())
          paramsClass = PeriodicBackgroundSyncService_GetRegistrations_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PeriodicBackgroundSyncService = {
    name: 'blink.mojom.PeriodicBackgroundSyncService',
    kVersion: 0,
    ptrClass: PeriodicBackgroundSyncServicePtr,
    proxyClass: PeriodicBackgroundSyncServiceProxy,
    stubClass: PeriodicBackgroundSyncServiceStub,
    validateRequest: validatePeriodicBackgroundSyncServiceRequest,
    validateResponse: validatePeriodicBackgroundSyncServiceResponse,
  };
  PeriodicBackgroundSyncServiceStub.prototype.validator = validatePeriodicBackgroundSyncServiceRequest;
  PeriodicBackgroundSyncServiceProxy.prototype.validator = validatePeriodicBackgroundSyncServiceResponse;
  exports.BackgroundSyncError = BackgroundSyncError;
  exports.BackgroundSyncState = BackgroundSyncState;
  exports.BackgroundSyncEventLastChance = BackgroundSyncEventLastChance;
  exports.BackgroundSyncType = BackgroundSyncType;
  exports.SyncRegistrationOptions = SyncRegistrationOptions;
  exports.BackgroundSyncRegistrationInfo = BackgroundSyncRegistrationInfo;
  exports.OneShotBackgroundSyncService = OneShotBackgroundSyncService;
  exports.OneShotBackgroundSyncServicePtr = OneShotBackgroundSyncServicePtr;
  exports.OneShotBackgroundSyncServiceAssociatedPtr = OneShotBackgroundSyncServiceAssociatedPtr;
  exports.PeriodicBackgroundSyncService = PeriodicBackgroundSyncService;
  exports.PeriodicBackgroundSyncServicePtr = PeriodicBackgroundSyncServicePtr;
  exports.PeriodicBackgroundSyncServiceAssociatedPtr = PeriodicBackgroundSyncServiceAssociatedPtr;
})();