// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/buckets/bucket_manager_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var cache_storage$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/cache_storage/cache_storage.mojom', '../cache_storage/cache_storage.mojom.js');
  }
  var file_system_access_directory_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom', '../file_system_access/file_system_access_directory_handle.mojom.js');
  }
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', '../file_system_access/file_system_access_error.mojom.js');
  }
  var indexeddb$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/indexeddb/indexeddb.mojom', '../indexeddb/indexeddb.mojom.js');
  }
  var lock_manager$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/locks/lock_manager.mojom', '../locks/lock_manager.mojom.js');
  }
  var quota_types$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/quota/quota_types.mojom', '../quota/quota_types.mojom.js');
  }


  var BucketError = {};
  BucketError.kUnknown = 0;
  BucketError.kQuotaExceeded = 1;
  BucketError.kInvalidExpiration = 2;
  BucketError.MIN_VALUE = 0;
  BucketError.MAX_VALUE = 2;

  BucketError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  BucketError.toKnownEnumValue = function(value) {
    return value;
  };

  BucketError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function BucketPolicies(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketPolicies.prototype.initDefaults_ = function() {
    this.persisted = false;
    this.hasPersisted = false;
    this.hasDurability = false;
    this.hasQuota = false;
    this.durability = 0;
    this.quota = 0;
    this.expires = null;
  };
  BucketPolicies.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketPolicies.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BucketPolicies.durability
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, quota_types$.BucketDurability);
    if (err !== validator.validationError.NONE)
        return err;





    // validate BucketPolicies.expires
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketPolicies.encodedSize = codec.kStructHeaderSize + 24;

  BucketPolicies.decode = function(decoder) {
    var packed;
    var val = new BucketPolicies();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.persisted = (packed >> 0) & 1 ? true : false;
    val.hasPersisted = (packed >> 1) & 1 ? true : false;
    val.hasDurability = (packed >> 2) & 1 ? true : false;
    val.hasQuota = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.durability =
        decoder.decodeStruct(new codec.Enum(quota_types$.BucketDurability));
    val.quota =
        decoder.decodeStruct(codec.Int64);
    val.expires =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  BucketPolicies.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketPolicies.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.persisted & 1) << 0
    packed |= (val.hasPersisted & 1) << 1
    packed |= (val.hasDurability & 1) << 2
    packed |= (val.hasQuota & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.durability);
    encoder.encodeStruct(codec.Int64, val.quota);
    encoder.encodeStructPointer(time$.Time, val.expires);
  };
  function BucketHost_Persist_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Persist_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_Persist_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Persist_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_Persist_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_Persist_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Persist_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_Persist_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Persist_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_Persist_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Persist_ResponseParams.prototype.initDefaults_ = function() {
    this.persisted = false;
    this.success = false;
  };
  BucketHost_Persist_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Persist_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  BucketHost_Persist_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_Persist_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Persist_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.persisted = (packed >> 0) & 1 ? true : false;
    val.success = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_Persist_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Persist_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.persisted & 1) << 0
    packed |= (val.success & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_Persisted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Persisted_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_Persisted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Persisted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_Persisted_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_Persisted_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Persisted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_Persisted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Persisted_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_Persisted_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Persisted_ResponseParams.prototype.initDefaults_ = function() {
    this.persisted = false;
    this.success = false;
  };
  BucketHost_Persisted_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Persisted_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  BucketHost_Persisted_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_Persisted_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Persisted_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.persisted = (packed >> 0) & 1 ? true : false;
    val.success = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_Persisted_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Persisted_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.persisted & 1) << 0
    packed |= (val.success & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_Estimate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Estimate_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_Estimate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Estimate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_Estimate_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_Estimate_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Estimate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_Estimate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Estimate_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_Estimate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Estimate_ResponseParams.prototype.initDefaults_ = function() {
    this.currentUsage = 0;
    this.currentQuota = 0;
    this.success = false;
  };
  BucketHost_Estimate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Estimate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  BucketHost_Estimate_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  BucketHost_Estimate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Estimate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentUsage =
        decoder.decodeStruct(codec.Int64);
    val.currentQuota =
        decoder.decodeStruct(codec.Int64);
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_Estimate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Estimate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.currentUsage);
    encoder.encodeStruct(codec.Int64, val.currentQuota);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_Durability_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Durability_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_Durability_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Durability_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_Durability_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_Durability_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Durability_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_Durability_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Durability_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_Durability_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Durability_ResponseParams.prototype.initDefaults_ = function() {
    this.durability = 0;
    this.success = false;
  };
  BucketHost_Durability_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Durability_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_Durability_ResponseParams.durability
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, quota_types$.BucketDurability);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BucketHost_Durability_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_Durability_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Durability_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.durability =
        decoder.decodeStruct(new codec.Enum(quota_types$.BucketDurability));
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_Durability_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Durability_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.durability);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_SetExpires_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_SetExpires_Params.prototype.initDefaults_ = function() {
    this.expires = null;
  };
  BucketHost_SetExpires_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_SetExpires_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_SetExpires_Params.expires
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_SetExpires_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_SetExpires_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_SetExpires_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.expires =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  BucketHost_SetExpires_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_SetExpires_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.expires);
  };
  function BucketHost_SetExpires_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_SetExpires_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  BucketHost_SetExpires_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_SetExpires_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BucketHost_SetExpires_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_SetExpires_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_SetExpires_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_SetExpires_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_SetExpires_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_Expires_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Expires_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_Expires_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Expires_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_Expires_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_Expires_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Expires_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_Expires_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Expires_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_Expires_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_Expires_ResponseParams.prototype.initDefaults_ = function() {
    this.expires = null;
    this.success = false;
  };
  BucketHost_Expires_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_Expires_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_Expires_ResponseParams.expires
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BucketHost_Expires_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BucketHost_Expires_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_Expires_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.expires =
        decoder.decodeStructPointer(time$.Time);
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_Expires_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_Expires_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.expires);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_GetIdbFactory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetIdbFactory_Params.prototype.initDefaults_ = function() {
    this.idbFactory = new bindings.InterfaceRequest();
  };
  BucketHost_GetIdbFactory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetIdbFactory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetIdbFactory_Params.idbFactory
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetIdbFactory_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_GetIdbFactory_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetIdbFactory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.idbFactory =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_GetIdbFactory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetIdbFactory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.idbFactory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_GetLockManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetLockManager_Params.prototype.initDefaults_ = function() {
    this.lockManager = new bindings.InterfaceRequest();
  };
  BucketHost_GetLockManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetLockManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetLockManager_Params.lockManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetLockManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_GetLockManager_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetLockManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lockManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_GetLockManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetLockManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.lockManager);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_GetCaches_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetCaches_Params.prototype.initDefaults_ = function() {
    this.cacheStorage = new bindings.InterfaceRequest();
  };
  BucketHost_GetCaches_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetCaches_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetCaches_Params.cacheStorage
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetCaches_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_GetCaches_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetCaches_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheStorage =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketHost_GetCaches_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetCaches_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.cacheStorage);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketHost_GetDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetDirectory_Params.prototype.initDefaults_ = function() {
  };
  BucketHost_GetDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetDirectory_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketHost_GetDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketHost_GetDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetDirectory_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketHost_GetDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr();
  };
  BucketHost_GetDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetDirectory_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetDirectory_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BucketHost_GetDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  BucketHost_GetDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function BucketHost_GetDirectoryForDevtools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetDirectoryForDevtools_Params.prototype.initDefaults_ = function() {
    this.directoryPathComponents = null;
  };
  BucketHost_GetDirectoryForDevtools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetDirectoryForDevtools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetDirectoryForDevtools_Params.directoryPathComponents
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetDirectoryForDevtools_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketHost_GetDirectoryForDevtools_Params.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetDirectoryForDevtools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.directoryPathComponents =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  BucketHost_GetDirectoryForDevtools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetDirectoryForDevtools_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.directoryPathComponents);
  };
  function BucketHost_GetDirectoryForDevtools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketHost_GetDirectoryForDevtools_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr();
  };
  BucketHost_GetDirectoryForDevtools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketHost_GetDirectoryForDevtools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetDirectoryForDevtools_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketHost_GetDirectoryForDevtools_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketHost_GetDirectoryForDevtools_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BucketHost_GetDirectoryForDevtools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketHost_GetDirectoryForDevtools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  BucketHost_GetDirectoryForDevtools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketHost_GetDirectoryForDevtools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function BucketManagerHost_OpenBucket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_OpenBucket_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.policy = null;
  };
  BucketManagerHost_OpenBucket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_OpenBucket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_OpenBucket_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_OpenBucket_Params.policy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, BucketPolicies, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketManagerHost_OpenBucket_Params.encodedSize = codec.kStructHeaderSize + 16;

  BucketManagerHost_OpenBucket_Params.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_OpenBucket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.policy =
        decoder.decodeStructPointer(BucketPolicies);
    return val;
  };

  BucketManagerHost_OpenBucket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_OpenBucket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(BucketPolicies, val.policy);
  };
  function BucketManagerHost_OpenBucket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_OpenBucket_ResponseParams.prototype.initDefaults_ = function() {
    this.remote = new BucketHostPtr();
    this.error = 0;
  };
  BucketManagerHost_OpenBucket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_OpenBucket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_OpenBucket_ResponseParams.remote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_OpenBucket_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, BucketError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketManagerHost_OpenBucket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BucketManagerHost_OpenBucket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_OpenBucket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remote =
        decoder.decodeStruct(new codec.NullableInterface(BucketHostPtr));
    val.error =
        decoder.decodeStruct(new codec.Enum(BucketError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketManagerHost_OpenBucket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_OpenBucket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(BucketHostPtr), val.remote);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketManagerHost_GetBucketForDevtools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_GetBucketForDevtools_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  BucketManagerHost_GetBucketForDevtools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_GetBucketForDevtools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_GetBucketForDevtools_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_GetBucketForDevtools_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketManagerHost_GetBucketForDevtools_Params.encodedSize = codec.kStructHeaderSize + 16;

  BucketManagerHost_GetBucketForDevtools_Params.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_GetBucketForDevtools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketManagerHost_GetBucketForDevtools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_GetBucketForDevtools_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketManagerHost_Keys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_Keys_Params.prototype.initDefaults_ = function() {
  };
  BucketManagerHost_Keys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_Keys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketManagerHost_Keys_Params.encodedSize = codec.kStructHeaderSize + 0;

  BucketManagerHost_Keys_Params.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_Keys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BucketManagerHost_Keys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_Keys_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BucketManagerHost_Keys_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_Keys_ResponseParams.prototype.initDefaults_ = function() {
    this.buckets = null;
    this.success = false;
  };
  BucketManagerHost_Keys_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_Keys_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_Keys_ResponseParams.buckets
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BucketManagerHost_Keys_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BucketManagerHost_Keys_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_Keys_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buckets =
        decoder.decodeArrayPointer(codec.String);
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketManagerHost_Keys_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_Keys_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.buckets);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BucketManagerHost_DeleteBucket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_DeleteBucket_Params.prototype.initDefaults_ = function() {
    this.name = null;
  };
  BucketManagerHost_DeleteBucket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_DeleteBucket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketManagerHost_DeleteBucket_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BucketManagerHost_DeleteBucket_Params.encodedSize = codec.kStructHeaderSize + 8;

  BucketManagerHost_DeleteBucket_Params.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_DeleteBucket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  BucketManagerHost_DeleteBucket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_DeleteBucket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
  };
  function BucketManagerHost_DeleteBucket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketManagerHost_DeleteBucket_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  BucketManagerHost_DeleteBucket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketManagerHost_DeleteBucket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BucketManagerHost_DeleteBucket_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BucketManagerHost_DeleteBucket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BucketManagerHost_DeleteBucket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketManagerHost_DeleteBucket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketManagerHost_DeleteBucket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kBucketHost_Persist_Name = 0;
  var kBucketHost_Persisted_Name = 1;
  var kBucketHost_Estimate_Name = 2;
  var kBucketHost_Durability_Name = 3;
  var kBucketHost_SetExpires_Name = 4;
  var kBucketHost_Expires_Name = 5;
  var kBucketHost_GetIdbFactory_Name = 6;
  var kBucketHost_GetLockManager_Name = 7;
  var kBucketHost_GetCaches_Name = 8;
  var kBucketHost_GetDirectory_Name = 9;
  var kBucketHost_GetDirectoryForDevtools_Name = 10;

  function BucketHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BucketHost,
                                                   handleOrPtrInfo);
  }

  function BucketHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BucketHost, associatedInterfacePtrInfo);
  }

  BucketHostAssociatedPtr.prototype =
      Object.create(BucketHostPtr.prototype);
  BucketHostAssociatedPtr.prototype.constructor =
      BucketHostAssociatedPtr;

  function BucketHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  BucketHostPtr.prototype.persist = function() {
    return BucketHostProxy.prototype.persist
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.persist = function() {
    var params_ = new BucketHost_Persist_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_Persist_Name,
          codec.align(BucketHost_Persist_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_Persist_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_Persist_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.persisted = function() {
    return BucketHostProxy.prototype.persisted
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.persisted = function() {
    var params_ = new BucketHost_Persisted_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_Persisted_Name,
          codec.align(BucketHost_Persisted_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_Persisted_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_Persisted_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.estimate = function() {
    return BucketHostProxy.prototype.estimate
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.estimate = function() {
    var params_ = new BucketHost_Estimate_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_Estimate_Name,
          codec.align(BucketHost_Estimate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_Estimate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_Estimate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.durability = function() {
    return BucketHostProxy.prototype.durability
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.durability = function() {
    var params_ = new BucketHost_Durability_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_Durability_Name,
          codec.align(BucketHost_Durability_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_Durability_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_Durability_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.setExpires = function() {
    return BucketHostProxy.prototype.setExpires
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.setExpires = function(expires) {
    var params_ = new BucketHost_SetExpires_Params();
    params_.expires = expires;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_SetExpires_Name,
          codec.align(BucketHost_SetExpires_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_SetExpires_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_SetExpires_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.expires = function() {
    return BucketHostProxy.prototype.expires
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.expires = function() {
    var params_ = new BucketHost_Expires_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_Expires_Name,
          codec.align(BucketHost_Expires_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_Expires_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_Expires_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.getIdbFactory = function() {
    return BucketHostProxy.prototype.getIdbFactory
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.getIdbFactory = function(idbFactory) {
    var params_ = new BucketHost_GetIdbFactory_Params();
    params_.idbFactory = idbFactory;
    var builder = new codec.MessageV0Builder(
        kBucketHost_GetIdbFactory_Name,
        codec.align(BucketHost_GetIdbFactory_Params.encodedSize));
    builder.encodeStruct(BucketHost_GetIdbFactory_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BucketHostPtr.prototype.getLockManager = function() {
    return BucketHostProxy.prototype.getLockManager
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.getLockManager = function(lockManager) {
    var params_ = new BucketHost_GetLockManager_Params();
    params_.lockManager = lockManager;
    var builder = new codec.MessageV0Builder(
        kBucketHost_GetLockManager_Name,
        codec.align(BucketHost_GetLockManager_Params.encodedSize));
    builder.encodeStruct(BucketHost_GetLockManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BucketHostPtr.prototype.getCaches = function() {
    return BucketHostProxy.prototype.getCaches
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.getCaches = function(cacheStorage) {
    var params_ = new BucketHost_GetCaches_Params();
    params_.cacheStorage = cacheStorage;
    var builder = new codec.MessageV0Builder(
        kBucketHost_GetCaches_Name,
        codec.align(BucketHost_GetCaches_Params.encodedSize));
    builder.encodeStruct(BucketHost_GetCaches_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BucketHostPtr.prototype.getDirectory = function() {
    return BucketHostProxy.prototype.getDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.getDirectory = function() {
    var params_ = new BucketHost_GetDirectory_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_GetDirectory_Name,
          codec.align(BucketHost_GetDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_GetDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_GetDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketHostPtr.prototype.getDirectoryForDevtools = function() {
    return BucketHostProxy.prototype.getDirectoryForDevtools
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketHostProxy.prototype.getDirectoryForDevtools = function(directoryPathComponents) {
    var params_ = new BucketHost_GetDirectoryForDevtools_Params();
    params_.directoryPathComponents = directoryPathComponents;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketHost_GetDirectoryForDevtools_Name,
          codec.align(BucketHost_GetDirectoryForDevtools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketHost_GetDirectoryForDevtools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketHost_GetDirectoryForDevtools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function BucketHostStub(delegate) {
    this.delegate_ = delegate;
  }
  BucketHostStub.prototype.persist = function() {
    return this.delegate_ && this.delegate_.persist && this.delegate_.persist();
  }
  BucketHostStub.prototype.persisted = function() {
    return this.delegate_ && this.delegate_.persisted && this.delegate_.persisted();
  }
  BucketHostStub.prototype.estimate = function() {
    return this.delegate_ && this.delegate_.estimate && this.delegate_.estimate();
  }
  BucketHostStub.prototype.durability = function() {
    return this.delegate_ && this.delegate_.durability && this.delegate_.durability();
  }
  BucketHostStub.prototype.setExpires = function(expires) {
    return this.delegate_ && this.delegate_.setExpires && this.delegate_.setExpires(expires);
  }
  BucketHostStub.prototype.expires = function() {
    return this.delegate_ && this.delegate_.expires && this.delegate_.expires();
  }
  BucketHostStub.prototype.getIdbFactory = function(idbFactory) {
    return this.delegate_ && this.delegate_.getIdbFactory && this.delegate_.getIdbFactory(idbFactory);
  }
  BucketHostStub.prototype.getLockManager = function(lockManager) {
    return this.delegate_ && this.delegate_.getLockManager && this.delegate_.getLockManager(lockManager);
  }
  BucketHostStub.prototype.getCaches = function(cacheStorage) {
    return this.delegate_ && this.delegate_.getCaches && this.delegate_.getCaches(cacheStorage);
  }
  BucketHostStub.prototype.getDirectory = function() {
    return this.delegate_ && this.delegate_.getDirectory && this.delegate_.getDirectory();
  }
  BucketHostStub.prototype.getDirectoryForDevtools = function(directoryPathComponents) {
    return this.delegate_ && this.delegate_.getDirectoryForDevtools && this.delegate_.getDirectoryForDevtools(directoryPathComponents);
  }

  BucketHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBucketHost_GetIdbFactory_Name:
      var params = reader.decodeStruct(BucketHost_GetIdbFactory_Params);
      this.getIdbFactory(params.idbFactory);
      return true;
    case kBucketHost_GetLockManager_Name:
      var params = reader.decodeStruct(BucketHost_GetLockManager_Params);
      this.getLockManager(params.lockManager);
      return true;
    case kBucketHost_GetCaches_Name:
      var params = reader.decodeStruct(BucketHost_GetCaches_Params);
      this.getCaches(params.cacheStorage);
      return true;
    default:
      return false;
    }
  };

  BucketHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBucketHost_Persist_Name:
      var params = reader.decodeStruct(BucketHost_Persist_Params);
      this.persist().then(function(response) {
        var responseParams =
            new BucketHost_Persist_ResponseParams();
        responseParams.persisted = response.persisted;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_Persist_Name,
            codec.align(BucketHost_Persist_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_Persist_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_Persisted_Name:
      var params = reader.decodeStruct(BucketHost_Persisted_Params);
      this.persisted().then(function(response) {
        var responseParams =
            new BucketHost_Persisted_ResponseParams();
        responseParams.persisted = response.persisted;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_Persisted_Name,
            codec.align(BucketHost_Persisted_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_Persisted_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_Estimate_Name:
      var params = reader.decodeStruct(BucketHost_Estimate_Params);
      this.estimate().then(function(response) {
        var responseParams =
            new BucketHost_Estimate_ResponseParams();
        responseParams.currentUsage = response.currentUsage;
        responseParams.currentQuota = response.currentQuota;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_Estimate_Name,
            codec.align(BucketHost_Estimate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_Estimate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_Durability_Name:
      var params = reader.decodeStruct(BucketHost_Durability_Params);
      this.durability().then(function(response) {
        var responseParams =
            new BucketHost_Durability_ResponseParams();
        responseParams.durability = response.durability;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_Durability_Name,
            codec.align(BucketHost_Durability_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_Durability_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_SetExpires_Name:
      var params = reader.decodeStruct(BucketHost_SetExpires_Params);
      this.setExpires(params.expires).then(function(response) {
        var responseParams =
            new BucketHost_SetExpires_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_SetExpires_Name,
            codec.align(BucketHost_SetExpires_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_SetExpires_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_Expires_Name:
      var params = reader.decodeStruct(BucketHost_Expires_Params);
      this.expires().then(function(response) {
        var responseParams =
            new BucketHost_Expires_ResponseParams();
        responseParams.expires = response.expires;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketHost_Expires_Name,
            codec.align(BucketHost_Expires_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_Expires_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_GetDirectory_Name:
      var params = reader.decodeStruct(BucketHost_GetDirectory_Params);
      this.getDirectory().then(function(response) {
        var responseParams =
            new BucketHost_GetDirectory_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kBucketHost_GetDirectory_Name,
            codec.align(BucketHost_GetDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_GetDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketHost_GetDirectoryForDevtools_Name:
      var params = reader.decodeStruct(BucketHost_GetDirectoryForDevtools_Params);
      this.getDirectoryForDevtools(params.directoryPathComponents).then(function(response) {
        var responseParams =
            new BucketHost_GetDirectoryForDevtools_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kBucketHost_GetDirectoryForDevtools_Name,
            codec.align(BucketHost_GetDirectoryForDevtools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketHost_GetDirectoryForDevtools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateBucketHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBucketHost_Persist_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_Persist_Params;
      break;
      case kBucketHost_Persisted_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_Persisted_Params;
      break;
      case kBucketHost_Estimate_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_Estimate_Params;
      break;
      case kBucketHost_Durability_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_Durability_Params;
      break;
      case kBucketHost_SetExpires_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_SetExpires_Params;
      break;
      case kBucketHost_Expires_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_Expires_Params;
      break;
      case kBucketHost_GetIdbFactory_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BucketHost_GetIdbFactory_Params;
      break;
      case kBucketHost_GetLockManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BucketHost_GetLockManager_Params;
      break;
      case kBucketHost_GetCaches_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BucketHost_GetCaches_Params;
      break;
      case kBucketHost_GetDirectory_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_GetDirectory_Params;
      break;
      case kBucketHost_GetDirectoryForDevtools_Name:
        if (message.expectsResponse())
          paramsClass = BucketHost_GetDirectoryForDevtools_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBucketHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kBucketHost_Persist_Name:
        if (message.isResponse())
          paramsClass = BucketHost_Persist_ResponseParams;
        break;
      case kBucketHost_Persisted_Name:
        if (message.isResponse())
          paramsClass = BucketHost_Persisted_ResponseParams;
        break;
      case kBucketHost_Estimate_Name:
        if (message.isResponse())
          paramsClass = BucketHost_Estimate_ResponseParams;
        break;
      case kBucketHost_Durability_Name:
        if (message.isResponse())
          paramsClass = BucketHost_Durability_ResponseParams;
        break;
      case kBucketHost_SetExpires_Name:
        if (message.isResponse())
          paramsClass = BucketHost_SetExpires_ResponseParams;
        break;
      case kBucketHost_Expires_Name:
        if (message.isResponse())
          paramsClass = BucketHost_Expires_ResponseParams;
        break;
      case kBucketHost_GetDirectory_Name:
        if (message.isResponse())
          paramsClass = BucketHost_GetDirectory_ResponseParams;
        break;
      case kBucketHost_GetDirectoryForDevtools_Name:
        if (message.isResponse())
          paramsClass = BucketHost_GetDirectoryForDevtools_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var BucketHost = {
    name: 'blink.mojom.BucketHost',
    kVersion: 0,
    ptrClass: BucketHostPtr,
    proxyClass: BucketHostProxy,
    stubClass: BucketHostStub,
    validateRequest: validateBucketHostRequest,
    validateResponse: validateBucketHostResponse,
  };
  BucketHostStub.prototype.validator = validateBucketHostRequest;
  BucketHostProxy.prototype.validator = validateBucketHostResponse;
  var kBucketManagerHost_OpenBucket_Name = 0;
  var kBucketManagerHost_GetBucketForDevtools_Name = 1;
  var kBucketManagerHost_Keys_Name = 2;
  var kBucketManagerHost_DeleteBucket_Name = 3;

  function BucketManagerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BucketManagerHost,
                                                   handleOrPtrInfo);
  }

  function BucketManagerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BucketManagerHost, associatedInterfacePtrInfo);
  }

  BucketManagerHostAssociatedPtr.prototype =
      Object.create(BucketManagerHostPtr.prototype);
  BucketManagerHostAssociatedPtr.prototype.constructor =
      BucketManagerHostAssociatedPtr;

  function BucketManagerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  BucketManagerHostPtr.prototype.openBucket = function() {
    return BucketManagerHostProxy.prototype.openBucket
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketManagerHostProxy.prototype.openBucket = function(name, policy) {
    var params_ = new BucketManagerHost_OpenBucket_Params();
    params_.name = name;
    params_.policy = policy;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketManagerHost_OpenBucket_Name,
          codec.align(BucketManagerHost_OpenBucket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketManagerHost_OpenBucket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketManagerHost_OpenBucket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketManagerHostPtr.prototype.getBucketForDevtools = function() {
    return BucketManagerHostProxy.prototype.getBucketForDevtools
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketManagerHostProxy.prototype.getBucketForDevtools = function(name, receiver) {
    var params_ = new BucketManagerHost_GetBucketForDevtools_Params();
    params_.name = name;
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kBucketManagerHost_GetBucketForDevtools_Name,
        codec.align(BucketManagerHost_GetBucketForDevtools_Params.encodedSize));
    builder.encodeStruct(BucketManagerHost_GetBucketForDevtools_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BucketManagerHostPtr.prototype.keys = function() {
    return BucketManagerHostProxy.prototype.keys
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketManagerHostProxy.prototype.keys = function() {
    var params_ = new BucketManagerHost_Keys_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketManagerHost_Keys_Name,
          codec.align(BucketManagerHost_Keys_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketManagerHost_Keys_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketManagerHost_Keys_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BucketManagerHostPtr.prototype.deleteBucket = function() {
    return BucketManagerHostProxy.prototype.deleteBucket
        .apply(this.ptr.getProxy(), arguments);
  };

  BucketManagerHostProxy.prototype.deleteBucket = function(name) {
    var params_ = new BucketManagerHost_DeleteBucket_Params();
    params_.name = name;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBucketManagerHost_DeleteBucket_Name,
          codec.align(BucketManagerHost_DeleteBucket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BucketManagerHost_DeleteBucket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BucketManagerHost_DeleteBucket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function BucketManagerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  BucketManagerHostStub.prototype.openBucket = function(name, policy) {
    return this.delegate_ && this.delegate_.openBucket && this.delegate_.openBucket(name, policy);
  }
  BucketManagerHostStub.prototype.getBucketForDevtools = function(name, receiver) {
    return this.delegate_ && this.delegate_.getBucketForDevtools && this.delegate_.getBucketForDevtools(name, receiver);
  }
  BucketManagerHostStub.prototype.keys = function() {
    return this.delegate_ && this.delegate_.keys && this.delegate_.keys();
  }
  BucketManagerHostStub.prototype.deleteBucket = function(name) {
    return this.delegate_ && this.delegate_.deleteBucket && this.delegate_.deleteBucket(name);
  }

  BucketManagerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBucketManagerHost_GetBucketForDevtools_Name:
      var params = reader.decodeStruct(BucketManagerHost_GetBucketForDevtools_Params);
      this.getBucketForDevtools(params.name, params.receiver);
      return true;
    default:
      return false;
    }
  };

  BucketManagerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBucketManagerHost_OpenBucket_Name:
      var params = reader.decodeStruct(BucketManagerHost_OpenBucket_Params);
      this.openBucket(params.name, params.policy).then(function(response) {
        var responseParams =
            new BucketManagerHost_OpenBucket_ResponseParams();
        responseParams.remote = response.remote;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kBucketManagerHost_OpenBucket_Name,
            codec.align(BucketManagerHost_OpenBucket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketManagerHost_OpenBucket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketManagerHost_Keys_Name:
      var params = reader.decodeStruct(BucketManagerHost_Keys_Params);
      this.keys().then(function(response) {
        var responseParams =
            new BucketManagerHost_Keys_ResponseParams();
        responseParams.buckets = response.buckets;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketManagerHost_Keys_Name,
            codec.align(BucketManagerHost_Keys_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketManagerHost_Keys_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBucketManagerHost_DeleteBucket_Name:
      var params = reader.decodeStruct(BucketManagerHost_DeleteBucket_Params);
      this.deleteBucket(params.name).then(function(response) {
        var responseParams =
            new BucketManagerHost_DeleteBucket_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kBucketManagerHost_DeleteBucket_Name,
            codec.align(BucketManagerHost_DeleteBucket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BucketManagerHost_DeleteBucket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateBucketManagerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBucketManagerHost_OpenBucket_Name:
        if (message.expectsResponse())
          paramsClass = BucketManagerHost_OpenBucket_Params;
      break;
      case kBucketManagerHost_GetBucketForDevtools_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BucketManagerHost_GetBucketForDevtools_Params;
      break;
      case kBucketManagerHost_Keys_Name:
        if (message.expectsResponse())
          paramsClass = BucketManagerHost_Keys_Params;
      break;
      case kBucketManagerHost_DeleteBucket_Name:
        if (message.expectsResponse())
          paramsClass = BucketManagerHost_DeleteBucket_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBucketManagerHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kBucketManagerHost_OpenBucket_Name:
        if (message.isResponse())
          paramsClass = BucketManagerHost_OpenBucket_ResponseParams;
        break;
      case kBucketManagerHost_Keys_Name:
        if (message.isResponse())
          paramsClass = BucketManagerHost_Keys_ResponseParams;
        break;
      case kBucketManagerHost_DeleteBucket_Name:
        if (message.isResponse())
          paramsClass = BucketManagerHost_DeleteBucket_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var BucketManagerHost = {
    name: 'blink.mojom.BucketManagerHost',
    kVersion: 0,
    ptrClass: BucketManagerHostPtr,
    proxyClass: BucketManagerHostProxy,
    stubClass: BucketManagerHostStub,
    validateRequest: validateBucketManagerHostRequest,
    validateResponse: validateBucketManagerHostResponse,
  };
  BucketManagerHostStub.prototype.validator = validateBucketManagerHostRequest;
  BucketManagerHostProxy.prototype.validator = validateBucketManagerHostResponse;
  exports.BucketError = BucketError;
  exports.BucketPolicies = BucketPolicies;
  exports.BucketHost = BucketHost;
  exports.BucketHostPtr = BucketHostPtr;
  exports.BucketHostAssociatedPtr = BucketHostAssociatedPtr;
  exports.BucketManagerHost = BucketManagerHost;
  exports.BucketManagerHostPtr = BucketManagerHostPtr;
  exports.BucketManagerHostAssociatedPtr = BucketManagerHostAssociatedPtr;
})();