// third_party/blink/public/mojom/clipboard/clipboard.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  BigString as mojoBase_mojom_BigString,
  BigStringSpec as mojoBase_mojom_BigStringSpec
} from '../../../../../mojo/public/mojom/base/big_string.mojom.m.js';

import {
  Uint128 as mojoBase_mojom_Uint128,
  Uint128Spec as mojoBase_mojom_Uint128Spec
} from '../../../../../mojo/public/mojom/base/int128.mojom.m.js';

import {
  BigString16 as mojoBase_mojom_BigString16,
  BigString16Spec as mojoBase_mojom_BigString16Spec,
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  DataTransferFile as blink_mojom_DataTransferFile,
  DataTransferFileSpec as blink_mojom_DataTransferFileSpec
} from '../data_transfer/data_transfer.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ClipboardFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ClipboardFormat = {
  
  kPlaintext: 0,
  kHtml: 1,
  kSmartPaste: 2,
  kBookmark: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ClipboardBufferSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ClipboardBuffer = {
  
  kStandard: 0,
  kSelection: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ClipboardListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ClipboardListener', scope);
  }
}

/** @interface */
export class ClipboardListenerInterface {
  
  /**
   */

  onClipboardDataChanged() {}
}

/**
 * @implements { ClipboardListenerInterface }
 */
export class ClipboardListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ClipboardListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ClipboardListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ClipboardListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onClipboardDataChanged() {
    this.proxy.sendMessage(
        0,
        ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ClipboardListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ClipboardListenerReceiver {
  /**
   * @param {!ClipboardListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ClipboardListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ClipboardListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClipboardListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        impl.onClipboardDataChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ClipboardListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ClipboardListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ClipboardListenerRemote}
   */
  static getRemote() {
    let remote = new ClipboardListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ClipboardListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ClipboardListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ClipboardListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClipboardListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClipboardDataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        this.onClipboardDataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ClipboardHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ClipboardHost', scope);
  }
}

/** @interface */
export class ClipboardHostInterface {
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_Uint128,
   *  }>}
   */

  getSequenceNumber(buffer) {}
  
  /**
   * @param { !ClipboardFormat } format
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFormatAvailable(format, buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        types: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  readAvailableTypes(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readText(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        markup: !mojoBase_mojom_BigString16,
        url: !url_mojom_Url,
        fragmentStart: !number,
        fragmentEnd: !number,
   *  }>}
   */

  readHtml(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readSvg(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString,
   *  }>}
   */

  readRtf(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        png: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readPng(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !ClipboardFiles,
   *  }>}
   */

  readFiles(buffer) {}
  
  /**
   * @param { !ClipboardBuffer } buffer
   * @param { !mojoBase_mojom_String16 } type
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readDataTransferCustomData(buffer, type) {}
  
  /**
   * @return {!Promise<{
        formatTypes: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  readAvailableCustomAndStandardFormats() {}
  
  /**
   * @param { !mojoBase_mojom_String16 } format
   * @return {!Promise<{
        data: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readUnsanitizedCustomFormat(format) {}
  
  /**
   * @param { !mojoBase_mojom_BigString16 } text
   */

  writeText(text) {}
  
  /**
   * @param { !mojoBase_mojom_BigString16 } markup
   * @param { !url_mojom_Url } url
   */

  writeHtml(markup, url) {}
  
  /**
   * @param { !mojoBase_mojom_BigString16 } markup
   */

  writeSvg(markup) {}
  
  /**
   */

  writeSmartPasteMarker() {}
  
  /**
   * @param { !Map<!mojoBase_mojom_String16, !mojoBase_mojom_BigString16> } data
   */

  writeDataTransferCustomData(data) {}
  
  /**
   * @param { !string } url
   * @param { !mojoBase_mojom_String16 } title
   */

  writeBookmark(url, title) {}
  
  /**
   * @param { !skia_mojom_BitmapN32 } image
   */

  writeImage(image) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } format
   * @param { !mojoBase_mojom_BigBuffer } data
   */

  writeUnsanitizedCustomFormat(format, data) {}
  
  /**
   */

  commitWrite() {}
  
  /**
   * @param { !ClipboardListenerRemote } listener
   */

  registerClipboardListener(listener) {}
}

/**
 * @implements { ClipboardHostInterface }
 */
export class ClipboardHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ClipboardHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ClipboardHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ClipboardHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_Uint128,
   *  }>}
   */

  getSequenceNumber(
      buffer) {
    return this.proxy.sendMessage(
        0,
        ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardFormat } format
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFormatAvailable(
      format,
      buffer) {
    return this.proxy.sendMessage(
        1,
        ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        [
          format,
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        types: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  readAvailableTypes(
      buffer) {
    return this.proxy.sendMessage(
        2,
        ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readText(
      buffer) {
    return this.proxy.sendMessage(
        3,
        ClipboardHost_ReadText_ParamsSpec.$,
        ClipboardHost_ReadText_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        markup: !mojoBase_mojom_BigString16,
        url: !url_mojom_Url,
        fragmentStart: !number,
        fragmentEnd: !number,
   *  }>}
   */

  readHtml(
      buffer) {
    return this.proxy.sendMessage(
        4,
        ClipboardHost_ReadHtml_ParamsSpec.$,
        ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readSvg(
      buffer) {
    return this.proxy.sendMessage(
        5,
        ClipboardHost_ReadSvg_ParamsSpec.$,
        ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString,
   *  }>}
   */

  readRtf(
      buffer) {
    return this.proxy.sendMessage(
        6,
        ClipboardHost_ReadRtf_ParamsSpec.$,
        ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        png: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readPng(
      buffer) {
    return this.proxy.sendMessage(
        7,
        ClipboardHost_ReadPng_ParamsSpec.$,
        ClipboardHost_ReadPng_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !ClipboardFiles,
   *  }>}
   */

  readFiles(
      buffer) {
    return this.proxy.sendMessage(
        8,
        ClipboardHost_ReadFiles_ParamsSpec.$,
        ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !ClipboardBuffer } buffer
   * @param { !mojoBase_mojom_String16 } type
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString16,
   *  }>}
   */

  readDataTransferCustomData(
      buffer,
      type) {
    return this.proxy.sendMessage(
        9,
        ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        [
          buffer,
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        formatTypes: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  readAvailableCustomAndStandardFormats() {
    return this.proxy.sendMessage(
        10,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } format
   * @return {!Promise<{
        data: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readUnsanitizedCustomFormat(
      format) {
    return this.proxy.sendMessage(
        11,
        ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        [
          format
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_BigString16 } text
   */

  writeText(
      text) {
    this.proxy.sendMessage(
        12,
        ClipboardHost_WriteText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_BigString16 } markup
   * @param { !url_mojom_Url } url
   */

  writeHtml(
      markup,
      url) {
    this.proxy.sendMessage(
        13,
        ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        [
          markup,
          url
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_BigString16 } markup
   */

  writeSvg(
      markup) {
    this.proxy.sendMessage(
        14,
        ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        [
          markup
        ],
        false);
  }

  
  /**
   */

  writeSmartPasteMarker() {
    this.proxy.sendMessage(
        15,
        ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Map<!mojoBase_mojom_String16, !mojoBase_mojom_BigString16> } data
   */

  writeDataTransferCustomData(
      data) {
    this.proxy.sendMessage(
        16,
        ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !string } url
   * @param { !mojoBase_mojom_String16 } title
   */

  writeBookmark(
      url,
      title) {
    this.proxy.sendMessage(
        17,
        ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        [
          url,
          title
        ],
        false);
  }

  
  /**
   * @param { !skia_mojom_BitmapN32 } image
   */

  writeImage(
      image) {
    this.proxy.sendMessage(
        18,
        ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        [
          image
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } format
   * @param { !mojoBase_mojom_BigBuffer } data
   */

  writeUnsanitizedCustomFormat(
      format,
      data) {
    this.proxy.sendMessage(
        19,
        ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        [
          format,
          data
        ],
        false);
  }

  
  /**
   */

  commitWrite() {
    this.proxy.sendMessage(
        20,
        ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ClipboardListenerRemote } listener
   */

  registerClipboardListener(
      listener) {
    this.proxy.sendMessage(
        21,
        ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ClipboardHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ClipboardHostReceiver {
  /**
   * @param {!ClipboardHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ClipboardHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ClipboardHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClipboardHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        impl.getSequenceNumber.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        impl.isFormatAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        impl.readAvailableTypes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ClipboardHost_ReadText_ParamsSpec.$,
        ClipboardHost_ReadText_ResponseParamsSpec.$,
        impl.readText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ClipboardHost_ReadHtml_ParamsSpec.$,
        ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        impl.readHtml.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ClipboardHost_ReadSvg_ParamsSpec.$,
        ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        impl.readSvg.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ClipboardHost_ReadRtf_ParamsSpec.$,
        ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        impl.readRtf.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ClipboardHost_ReadPng_ParamsSpec.$,
        ClipboardHost_ReadPng_ResponseParamsSpec.$,
        impl.readPng.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ClipboardHost_ReadFiles_ParamsSpec.$,
        ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        impl.readFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        impl.readDataTransferCustomData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        impl.readAvailableCustomAndStandardFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        impl.readUnsanitizedCustomFormat.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ClipboardHost_WriteText_ParamsSpec.$,
        null,
        impl.writeText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        impl.writeHtml.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        impl.writeSvg.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        impl.writeSmartPasteMarker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        impl.writeDataTransferCustomData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        impl.writeBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        impl.writeImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        impl.writeUnsanitizedCustomFormat.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        impl.commitWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        impl.registerClipboardListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ClipboardHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ClipboardHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ClipboardHostRemote}
   */
  static getRemote() {
    let remote = new ClipboardHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ClipboardHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ClipboardHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ClipboardHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClipboardHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSequenceNumber =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        this.getSequenceNumber.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFormatAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        this.isFormatAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAvailableTypes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        this.readAvailableTypes.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ClipboardHost_ReadText_ParamsSpec.$,
        ClipboardHost_ReadText_ResponseParamsSpec.$,
        this.readText.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readHtml =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ClipboardHost_ReadHtml_ParamsSpec.$,
        ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        this.readHtml.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSvg =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ClipboardHost_ReadSvg_ParamsSpec.$,
        ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        this.readSvg.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readRtf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ClipboardHost_ReadRtf_ParamsSpec.$,
        ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        this.readRtf.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readPng =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ClipboardHost_ReadPng_ParamsSpec.$,
        ClipboardHost_ReadPng_ResponseParamsSpec.$,
        this.readPng.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ClipboardHost_ReadFiles_ParamsSpec.$,
        ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        this.readFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDataTransferCustomData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        this.readDataTransferCustomData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAvailableCustomAndStandardFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        this.readAvailableCustomAndStandardFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readUnsanitizedCustomFormat =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        this.readUnsanitizedCustomFormat.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ClipboardHost_WriteText_ParamsSpec.$,
        null,
        this.writeText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeHtml =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        this.writeHtml.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSvg =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        this.writeSvg.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSmartPasteMarker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        this.writeSmartPasteMarker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeDataTransferCustomData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        this.writeDataTransferCustomData.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        this.writeBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        this.writeImage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeUnsanitizedCustomFormat =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        this.writeUnsanitizedCustomFormat.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        this.commitWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerClipboardListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        this.registerClipboardListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardFilesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardListener_OnClipboardDataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_GetSequenceNumber_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_GetSequenceNumber_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_IsFormatAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_IsFormatAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadAvailableTypes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadAvailableTypes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadHtml_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadHtml_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadSvg_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadSvg_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadRtf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadRtf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadPng_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadPng_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadDataTransferCustomData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteHtml_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteSvg_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteSmartPasteMarker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteDataTransferCustomData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteBookmark_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_CommitWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClipboardHost_RegisterClipboardListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ClipboardFilesSpec.$,
    'ClipboardFiles',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(blink_mojom_DataTransferFileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileSystemId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardFiles {
  constructor() {
    /** @type { !Array<!blink_mojom_DataTransferFile> } */
    this.files;
    /** @type { (string|undefined) } */
    this.fileSystemId;
  }
}



mojo.internal.Struct(
    ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
    'ClipboardListener_OnClipboardDataChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClipboardListener_OnClipboardDataChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ClipboardHost_GetSequenceNumber_ParamsSpec.$,
    'ClipboardHost_GetSequenceNumber_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_GetSequenceNumber_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
    'ClipboardHost_GetSequenceNumber_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_Uint128Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_GetSequenceNumber_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_Uint128 } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_IsFormatAvailable_ParamsSpec.$,
    'ClipboardHost_IsFormatAvailable_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        ClipboardFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 4,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_IsFormatAvailable_Params {
  constructor() {
    /** @type { !ClipboardFormat } */
    this.format;
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
    'ClipboardHost_IsFormatAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_IsFormatAvailable_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
    'ClipboardHost_ReadAvailableTypes_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadAvailableTypes_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
    'ClipboardHost_ReadAvailableTypes_ResponseParams',
    [
      mojo.internal.StructField(
        'types', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadAvailableTypes_ResponseParams {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.types;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadText_ParamsSpec.$,
    'ClipboardHost_ReadText_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadText_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadText_ResponseParamsSpec.$,
    'ClipboardHost_ReadText_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadText_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadHtml_ParamsSpec.$,
    'ClipboardHost_ReadHtml_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadHtml_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadHtml_ResponseParamsSpec.$,
    'ClipboardHost_ReadHtml_ResponseParams',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fragmentStart', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fragmentEnd', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ClipboardHost_ReadHtml_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.markup;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !number } */
    this.fragmentStart;
    /** @type { !number } */
    this.fragmentEnd;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadSvg_ParamsSpec.$,
    'ClipboardHost_ReadSvg_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadSvg_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadSvg_ResponseParamsSpec.$,
    'ClipboardHost_ReadSvg_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadSvg_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadRtf_ParamsSpec.$,
    'ClipboardHost_ReadRtf_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadRtf_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadRtf_ResponseParamsSpec.$,
    'ClipboardHost_ReadRtf_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_BigStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadRtf_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadPng_ParamsSpec.$,
    'ClipboardHost_ReadPng_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadPng_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadPng_ResponseParamsSpec.$,
    'ClipboardHost_ReadPng_ResponseParams',
    [
      mojo.internal.StructField(
        'png', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardHost_ReadPng_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.png;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadFiles_ParamsSpec.$,
    'ClipboardHost_ReadFiles_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadFiles_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadFiles_ResponseParamsSpec.$,
    'ClipboardHost_ReadFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ClipboardFilesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadFiles_ResponseParams {
  constructor() {
    /** @type { !ClipboardFiles } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
    'ClipboardHost_ReadDataTransferCustomData_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        ClipboardBufferSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardHost_ReadDataTransferCustomData_Params {
  constructor() {
    /** @type { !ClipboardBuffer } */
    this.buffer;
    /** @type { !mojoBase_mojom_String16 } */
    this.type;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
    'ClipboardHost_ReadDataTransferCustomData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadDataTransferCustomData_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.result;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
    'ClipboardHost_ReadAvailableCustomAndStandardFormats_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClipboardHost_ReadAvailableCustomAndStandardFormats_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
    'ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formatTypes', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.formatTypes;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
    'ClipboardHost_ReadUnsanitizedCustomFormat_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_ReadUnsanitizedCustomFormat_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.format;
  }
}



mojo.internal.Struct(
    ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
    'ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteText_ParamsSpec.$,
    'ClipboardHost_WriteText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_WriteText_Params {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.text;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteHtml_ParamsSpec.$,
    'ClipboardHost_WriteHtml_Params',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardHost_WriteHtml_Params {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.markup;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteSvg_ParamsSpec.$,
    'ClipboardHost_WriteSvg_Params',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_WriteSvg_Params {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.markup;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
    'ClipboardHost_WriteSmartPasteMarker_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClipboardHost_WriteSmartPasteMarker_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
    'ClipboardHost_WriteDataTransferCustomData_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Map(mojoBase_mojom_String16Spec.$, mojoBase_mojom_BigString16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_WriteDataTransferCustomData_Params {
  constructor() {
    /** @type { !Map<!mojoBase_mojom_String16, !mojoBase_mojom_BigString16> } */
    this.data;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteBookmark_ParamsSpec.$,
    'ClipboardHost_WriteBookmark_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClipboardHost_WriteBookmark_Params {
  constructor() {
    /** @type { !string } */
    this.url;
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteImage_ParamsSpec.$,
    'ClipboardHost_WriteImage_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_WriteImage_Params {
  constructor() {
    /** @type { !skia_mojom_BitmapN32 } */
    this.image;
  }
}



mojo.internal.Struct(
    ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
    'ClipboardHost_WriteUnsanitizedCustomFormat_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ClipboardHost_WriteUnsanitizedCustomFormat_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.format;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    ClipboardHost_CommitWrite_ParamsSpec.$,
    'ClipboardHost_CommitWrite_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ClipboardHost_CommitWrite_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
    'ClipboardHost_RegisterClipboardListener_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(ClipboardListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClipboardHost_RegisterClipboardListener_Params {
  constructor() {
    /** @type { !ClipboardListenerRemote } */
    this.listener;
  }
}

