// third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var pressure_manager$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/pressure_manager.mojom', '../../../../../services/device/public/mojom/pressure_manager.mojom.js');
  }
  var pressure_update$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/pressure_update.mojom', '../../../../../services/device/public/mojom/pressure_update.mojom.js');
  }
  var web_pressure_update$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom', 'web_pressure_update.mojom.js');
  }



  function WebPressureManager_AddClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPressureManager_AddClient_Params.prototype.initDefaults_ = function() {
    this.source = 0;
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  WebPressureManager_AddClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPressureManager_AddClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureManager_AddClient_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureManager_AddClient_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPressureManager_AddClient_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebPressureManager_AddClient_Params.decode = function(decoder) {
    var packed;
    var val = new WebPressureManager_AddClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebPressureManager_AddClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPressureManager_AddClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebPressureManager_AddClient_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPressureManager_AddClient_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  WebPressureManager_AddClient_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPressureManager_AddClient_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureManager_AddClient_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pressure_manager$.PressureManagerAddClientResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPressureManager_AddClient_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebPressureManager_AddClient_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebPressureManager_AddClient_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(pressure_manager$.PressureManagerAddClientResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebPressureManager_AddClient_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPressureManager_AddClient_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebPressureClient_OnPressureUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPressureClient_OnPressureUpdated_Params.prototype.initDefaults_ = function() {
    this.update = null;
  };
  WebPressureClient_OnPressureUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPressureClient_OnPressureUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureClient_OnPressureUpdated_Params.update
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, web_pressure_update$.WebPressureUpdate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPressureClient_OnPressureUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebPressureClient_OnPressureUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new WebPressureClient_OnPressureUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.update =
        decoder.decodeStructPointer(web_pressure_update$.WebPressureUpdate);
    return val;
  };

  WebPressureClient_OnPressureUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPressureClient_OnPressureUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(web_pressure_update$.WebPressureUpdate, val.update);
  };
  var kWebPressureManager_AddClient_Name = 0;

  function WebPressureManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPressureManager,
                                                   handleOrPtrInfo);
  }

  function WebPressureManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPressureManager, associatedInterfacePtrInfo);
  }

  WebPressureManagerAssociatedPtr.prototype =
      Object.create(WebPressureManagerPtr.prototype);
  WebPressureManagerAssociatedPtr.prototype.constructor =
      WebPressureManagerAssociatedPtr;

  function WebPressureManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPressureManagerPtr.prototype.addClient = function() {
    return WebPressureManagerProxy.prototype.addClient
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPressureManagerProxy.prototype.addClient = function(source, client) {
    var params_ = new WebPressureManager_AddClient_Params();
    params_.source = source;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kWebPressureManager_AddClient_Name,
          codec.align(WebPressureManager_AddClient_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(WebPressureManager_AddClient_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebPressureManager_AddClient_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebPressureManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPressureManagerStub.prototype.addClient = function(source, client) {
    return this.delegate_ && this.delegate_.addClient && this.delegate_.addClient(source, client);
  }

  WebPressureManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebPressureManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPressureManager_AddClient_Name:
      var params = reader.decodeStruct(WebPressureManager_AddClient_Params);
      this.addClient(params.source, params.client).then(function(response) {
        var responseParams =
            new WebPressureManager_AddClient_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kWebPressureManager_AddClient_Name,
            codec.align(WebPressureManager_AddClient_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(WebPressureManager_AddClient_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebPressureManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPressureManager_AddClient_Name:
        if (message.expectsResponse())
          paramsClass = WebPressureManager_AddClient_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPressureManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebPressureManager_AddClient_Name:
        if (message.isResponse())
          paramsClass = WebPressureManager_AddClient_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebPressureManager = {
    name: 'blink.mojom.WebPressureManager',
    kVersion: 0,
    ptrClass: WebPressureManagerPtr,
    proxyClass: WebPressureManagerProxy,
    stubClass: WebPressureManagerStub,
    validateRequest: validateWebPressureManagerRequest,
    validateResponse: validateWebPressureManagerResponse,
  };
  WebPressureManagerStub.prototype.validator = validateWebPressureManagerRequest;
  WebPressureManagerProxy.prototype.validator = validateWebPressureManagerResponse;
  var kWebPressureClient_OnPressureUpdated_Name = 0;

  function WebPressureClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPressureClient,
                                                   handleOrPtrInfo);
  }

  function WebPressureClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPressureClient, associatedInterfacePtrInfo);
  }

  WebPressureClientAssociatedPtr.prototype =
      Object.create(WebPressureClientPtr.prototype);
  WebPressureClientAssociatedPtr.prototype.constructor =
      WebPressureClientAssociatedPtr;

  function WebPressureClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPressureClientPtr.prototype.onPressureUpdated = function() {
    return WebPressureClientProxy.prototype.onPressureUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPressureClientProxy.prototype.onPressureUpdated = function(update) {
    var params_ = new WebPressureClient_OnPressureUpdated_Params();
    params_.update = update;
    var builder = new codec.MessageV0Builder(
        kWebPressureClient_OnPressureUpdated_Name,
        codec.align(WebPressureClient_OnPressureUpdated_Params.encodedSize));
    builder.encodeStruct(WebPressureClient_OnPressureUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebPressureClientStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPressureClientStub.prototype.onPressureUpdated = function(update) {
    return this.delegate_ && this.delegate_.onPressureUpdated && this.delegate_.onPressureUpdated(update);
  }

  WebPressureClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPressureClient_OnPressureUpdated_Name:
      var params = reader.decodeStruct(WebPressureClient_OnPressureUpdated_Params);
      this.onPressureUpdated(params.update);
      return true;
    default:
      return false;
    }
  };

  WebPressureClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebPressureClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPressureClient_OnPressureUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebPressureClient_OnPressureUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPressureClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebPressureClient = {
    name: 'blink.mojom.WebPressureClient',
    kVersion: 0,
    ptrClass: WebPressureClientPtr,
    proxyClass: WebPressureClientProxy,
    stubClass: WebPressureClientStub,
    validateRequest: validateWebPressureClientRequest,
    validateResponse: null,
  };
  WebPressureClientStub.prototype.validator = validateWebPressureClientRequest;
  WebPressureClientProxy.prototype.validator = null;
  exports.WebPressureManager = WebPressureManager;
  exports.WebPressureManagerPtr = WebPressureManagerPtr;
  exports.WebPressureManagerAssociatedPtr = WebPressureManagerAssociatedPtr;
  exports.WebPressureClient = WebPressureClient;
  exports.WebPressureClientPtr = WebPressureClientPtr;
  exports.WebPressureClientAssociatedPtr = WebPressureClientAssociatedPtr;
})();