// third_party/blink/public/mojom/content_extraction/inner_text.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.NodeLocationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.NodeLocationType = {
  
  kStart: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.InnerTextAgentPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.InnerTextAgent.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.InnerTextAgentInterface }
 */
blink.mojom.InnerTextAgentRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.InnerTextAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.InnerTextAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.InnerTextAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.InnerTextParams } params
   * @return {!Promise<{
        frame: !blink.mojom.InnerTextFrame,
   *  }>}
   */

  getInnerText(
      params) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.InnerTextAgent_GetInnerText_ParamsSpec.$,
        blink.mojom.InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InnerTextAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.InnerTextAgentReceiver = class {
  /**
   * @param {!blink.mojom.InnerTextAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.InnerTextAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.InnerTextAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.InnerTextAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.InnerTextAgent_GetInnerText_ParamsSpec.$,
        blink.mojom.InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        impl.getInnerText.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.InnerTextAgent = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.InnerTextAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.InnerTextAgentRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.InnerTextAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InnerTextAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.InnerTextAgentCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.InnerTextAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.InnerTextAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInnerText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.InnerTextAgent_GetInnerText_ParamsSpec.$,
        blink.mojom.InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        this.getInnerText.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InnerTextFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InnerTextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InnerTextAgent_GetInnerText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InnerTextAgent_GetInnerText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.InnerTextSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.InnerTextFrameSpec.$,
    'InnerTextFrame',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'segments', 8,
        0,
        mojo.internal.Array(blink.mojom.InnerTextSegmentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.InnerTextFrame = class {
  constructor() {
    /** @export { !blink.mojom.LocalFrameToken } */
    this.token;
    /** @export { !Array<!blink.mojom.InnerTextSegment> } */
    this.segments;
  }
};



mojo.internal.Struct(
    blink.mojom.InnerTextParamsSpec.$,
    'InnerTextParams',
    [
      mojo.internal.StructField(
        'node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "node_id_$value",
          originalFieldName: "nodeId",
        }
      ),
      mojo.internal.StructField(
        'node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "nodeId",
        }
      ),
      mojo.internal.StructField(
        'max_words_per_aggregate_passage_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "max_words_per_aggregate_passage_$value",
          originalFieldName: "maxWordsPerAggregatePassage",
        }
      ),
      mojo.internal.StructField(
        'max_words_per_aggregate_passage_$value', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "maxWordsPerAggregatePassage",
        }
      ),
      mojo.internal.StructField(
        'greedily_aggregate_sibling_nodes_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "greedily_aggregate_sibling_nodes_$value",
          originalFieldName: "greedilyAggregateSiblingNodes",
        }
      ),
      mojo.internal.StructField(
        'greedily_aggregate_sibling_nodes_$value', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "greedilyAggregateSiblingNodes",
        }
      ),
      mojo.internal.StructField(
        'maxPassages', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'min_words_per_passage_$flag', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "min_words_per_passage_$value",
          originalFieldName: "minWordsPerPassage",
        }
      ),
      mojo.internal.StructField(
        'min_words_per_passage_$value', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "minWordsPerPassage",
        }
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.InnerTextParams = class {
  constructor() {
    /** @export { (number|undefined) } */
    this.nodeId;
    /** @export { (number|undefined) } */
    this.maxWordsPerAggregatePassage;
    /** @export { (boolean|undefined) } */
    this.greedilyAggregateSiblingNodes;
    /** @export { !number } */
    this.maxPassages;
    /** @export { (number|undefined) } */
    this.minWordsPerPassage;
  }
};



mojo.internal.Struct(
    blink.mojom.InnerTextAgent_GetInnerText_ParamsSpec.$,
    'InnerTextAgent_GetInnerText_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.InnerTextParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.InnerTextAgent_GetInnerText_Params = class {
  constructor() {
    /** @export { !blink.mojom.InnerTextParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
    'InnerTextAgent_GetInnerText_ResponseParams',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        blink.mojom.InnerTextFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.InnerTextAgent_GetInnerText_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.InnerTextFrame } */
    this.frame;
  }
};



mojo.internal.Union(
    blink.mojom.InnerTextSegmentSpec.$, 'InnerTextSegment',
    {
      'nodeLocation': {
        'ordinal': 0,
        'type': blink.mojom.NodeLocationTypeSpec.$,
      },
      'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'frame': {
        'ordinal': 2,
        'type': blink.mojom.InnerTextFrameSpec.$,
      },
    });

/**
 * @typedef { {
 *   nodeLocation: (!blink.mojom.NodeLocationType|undefined),
 *   text: (!string|undefined),
 *   frame: (!blink.mojom.InnerTextFrame|undefined),
 * } }
 */
blink.mojom.InnerTextSegment;
