// third_party/blink/public/mojom/context_menu/context_menu.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  ReferrerPolicy as network_mojom_ReferrerPolicy,
  ReferrerPolicySpec as network_mojom_ReferrerPolicySpec
} from '../../../../../services/network/public/mojom/referrer_policy.mojom.m.js';

import {
  MenuSourceType as ui_mojom_MenuSourceType,
  MenuSourceTypeSpec as ui_mojom_MenuSourceTypeSpec
} from '../../../../../ui/base/mojom/menu_source_type.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  AnnotationType as blink_mojom_AnnotationType,
  AnnotationTypeSpec as blink_mojom_AnnotationTypeSpec
} from '../annotation/annotation.mojom.m.js';

import {
  Impression as blink_mojom_Impression,
  ImpressionSpec as blink_mojom_ImpressionSpec
} from '../conversions/conversions.mojom.m.js';

import {
  FormControlType as blink_mojom_FormControlType,
  FormControlTypeSpec as blink_mojom_FormControlTypeSpec
} from '../forms/form_control_type.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContextMenuDataMediaTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContextMenuDataMediaType = {
  
  kNone: 0,
  kImage: 1,
  kVideo: 2,
  kAudio: 3,
  kCanvas: 4,
  kFile: 5,
  kPlugin: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CustomContextMenuItemTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CustomContextMenuItemType = {
  
  kOption: 0,
  kCheckableOption: 1,
  kGroup: 2,
  kSeparator: 3,
  kSubMenu: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContextMenuClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ContextMenuClient', scope);
  }
}

/** @interface */
export class ContextMenuClientInterface {
  
  /**
   * @param { !number } action
   */

  customContextMenuAction(action) {}
  
  /**
   * @param { !url_mojom_Url } linkFollowed
   * @param { ?blink_mojom_Impression } impression
   */

  contextMenuClosed(linkFollowed, impression) {}
}

/**
 * @implements { ContextMenuClientInterface }
 */
export class ContextMenuClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContextMenuClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContextMenuClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContextMenuClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } action
   */

  customContextMenuAction(
      action) {
    this.proxy.sendMessage(
        0,
        ContextMenuClient_CustomContextMenuAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } linkFollowed
   * @param { ?blink_mojom_Impression } impression
   */

  contextMenuClosed(
      linkFollowed,
      impression) {
    this.proxy.sendMessage(
        1,
        ContextMenuClient_ContextMenuClosed_ParamsSpec.$,
        null,
        [
          linkFollowed,
          impression
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ContextMenuClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContextMenuClientReceiver {
  /**
   * @param {!ContextMenuClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContextMenuClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContextMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContextMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContextMenuClient_CustomContextMenuAction_ParamsSpec.$,
        null,
        impl.customContextMenuAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ContextMenuClient_ContextMenuClosed_ParamsSpec.$,
        null,
        impl.contextMenuClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContextMenuClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContextMenuClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContextMenuClientRemote}
   */
  static getRemote() {
    let remote = new ContextMenuClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContextMenuClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContextMenuClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContextMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContextMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.customContextMenuAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContextMenuClient_CustomContextMenuAction_ParamsSpec.$,
        null,
        this.customContextMenuAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contextMenuClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ContextMenuClient_ContextMenuClosed_ParamsSpec.$,
        null,
        this.contextMenuClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceleratorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FormRendererIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FieldRendererIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomContextMenuItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustworthyContextMenuParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContextMenuClient_CustomContextMenuAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContextMenuClient_ContextMenuClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AcceleratorSpec.$,
    'Accelerator',
    [
      mojo.internal.StructField(
        'keyCode', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Accelerator {
  constructor() {
    /** @type { !number } */
    this.keyCode;
    /** @type { !number } */
    this.modifiers;
  }
}



mojo.internal.Struct(
    FormRendererIdSpec.$,
    'FormRendererId',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FormRendererId {
  constructor() {
    /** @type { !bigint } */
    this.id;
  }
}



mojo.internal.Struct(
    FieldRendererIdSpec.$,
    'FieldRendererId',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FieldRendererId {
  constructor() {
    /** @type { !bigint } */
    this.id;
  }
}



mojo.internal.Struct(
    CustomContextMenuItemSpec.$,
    'CustomContextMenuItem',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accelerator', 8,
        0,
        AcceleratorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'toolTip', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 32,
        0,
        CustomContextMenuItemTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'action', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'featureName', 40,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isExperimentalFeature', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rtl', 48,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDirectionalOverride', 48,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enabled', 48,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'checked', 48,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceShowAcceleratorForItem', 48,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'submenu', 56,
        0,
        mojo.internal.Array(CustomContextMenuItemSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class CustomContextMenuItem {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.label;
    /** @type { (Accelerator|undefined) } */
    this.accelerator;
    /** @type { !mojoBase_mojom_String16 } */
    this.icon;
    /** @type { !mojoBase_mojom_String16 } */
    this.toolTip;
    /** @type { !CustomContextMenuItemType } */
    this.type;
    /** @type { !number } */
    this.action;
    /** @type { !mojoBase_mojom_String16 } */
    this.featureName;
    /** @type { !boolean } */
    this.isExperimentalFeature;
    /** @type { !boolean } */
    this.rtl;
    /** @type { !boolean } */
    this.hasDirectionalOverride;
    /** @type { !boolean } */
    this.enabled;
    /** @type { !boolean } */
    this.checked;
    /** @type { !boolean } */
    this.forceShowAcceleratorForItem;
    /** @type { !Array<!CustomContextMenuItem> } */
    this.submenu;
  }
}



mojo.internal.Struct(
    UntrustworthyContextMenuParamsSpec.$,
    'UntrustworthyContextMenuParams',
    [
      mojo.internal.StructField(
        'mediaType', 0,
        0,
        ContextMenuDataMediaTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'x', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'y', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'linkUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'linkText', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'impression', 32,
        0,
        blink_mojom_ImpressionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unfilteredLinkUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcUrl', 48,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasImageContents', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isImageMediaPluginDocument', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaFlags', 56,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectionText', 64,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'titleText', 72,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'altText', 80,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestedFilename', 88,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'misspelledWord', 96,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dictionarySuggestions', 104,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spellcheckEnabled', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isEditable', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writingDirectionDefault', 60,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writingDirectionLeftToRight', 112,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writingDirectionRightToLeft', 116,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'editFlags', 120,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameCharset', 128,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 124,
        0,
        network_mojom_ReferrerPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'linkFollowed', 136,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'customItems', 144,
        0,
        mojo.internal.Array(CustomContextMenuItemSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceType', 152,
        0,
        ui_mojom_MenuSourceTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectionRect', 160,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectionStartOffset', 156,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotation_type_$flag', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "annotation_type_$value",
          originalFieldName: "annotationType",
        }
      ),
      mojo.internal.StructField(
        'annotation_type_$value', 168,
        0,
        blink_mojom_AnnotationTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "annotationType",
        }
      ),
      mojo.internal.StructField(
        'openedFromInterestFor', 12,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interestForNodeId', 172,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'form_control_type_$flag', 12,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "form_control_type_$value",
          originalFieldName: "formControlType",
        }
      ),
      mojo.internal.StructField(
        'form_control_type_$value', 176,
        0,
        blink_mojom_FormControlTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "formControlType",
        }
      ),
      mojo.internal.StructField(
        'isContentEditableForAutofill', 12,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fieldRendererId', 184,
        0,
        FieldRendererIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'formRendererId', 192,
        0,
        FormRendererIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 208],]);



/**
 * @record
 */
export class UntrustworthyContextMenuParams {
  constructor() {
    /** @type { !ContextMenuDataMediaType } */
    this.mediaType;
    /** @type { !number } */
    this.x;
    /** @type { !number } */
    this.y;
    /** @type { !url_mojom_Url } */
    this.linkUrl;
    /** @type { !mojoBase_mojom_String16 } */
    this.linkText;
    /** @type { (blink_mojom_Impression|undefined) } */
    this.impression;
    /** @type { !url_mojom_Url } */
    this.unfilteredLinkUrl;
    /** @type { !url_mojom_Url } */
    this.srcUrl;
    /** @type { !boolean } */
    this.hasImageContents;
    /** @type { !boolean } */
    this.isImageMediaPluginDocument;
    /** @type { !number } */
    this.mediaFlags;
    /** @type { !mojoBase_mojom_String16 } */
    this.selectionText;
    /** @type { !mojoBase_mojom_String16 } */
    this.titleText;
    /** @type { !mojoBase_mojom_String16 } */
    this.altText;
    /** @type { !mojoBase_mojom_String16 } */
    this.suggestedFilename;
    /** @type { !mojoBase_mojom_String16 } */
    this.misspelledWord;
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.dictionarySuggestions;
    /** @type { !boolean } */
    this.spellcheckEnabled;
    /** @type { !boolean } */
    this.isEditable;
    /** @type { !number } */
    this.writingDirectionDefault;
    /** @type { !number } */
    this.writingDirectionLeftToRight;
    /** @type { !number } */
    this.writingDirectionRightToLeft;
    /** @type { !number } */
    this.editFlags;
    /** @type { !string } */
    this.frameCharset;
    /** @type { !network_mojom_ReferrerPolicy } */
    this.referrerPolicy;
    /** @type { !url_mojom_Url } */
    this.linkFollowed;
    /** @type { !Array<!CustomContextMenuItem> } */
    this.customItems;
    /** @type { !ui_mojom_MenuSourceType } */
    this.sourceType;
    /** @type { !gfx_mojom_Rect } */
    this.selectionRect;
    /** @type { !number } */
    this.selectionStartOffset;
    /** @type { (blink_mojom_AnnotationType|undefined) } */
    this.annotationType;
    /** @type { !boolean } */
    this.openedFromInterestFor;
    /** @type { !number } */
    this.interestForNodeId;
    /** @type { (blink_mojom_FormControlType|undefined) } */
    this.formControlType;
    /** @type { !boolean } */
    this.isContentEditableForAutofill;
    /** @type { !FieldRendererId } */
    this.fieldRendererId;
    /** @type { !FormRendererId } */
    this.formRendererId;
  }
}



mojo.internal.Struct(
    ContextMenuClient_CustomContextMenuAction_ParamsSpec.$,
    'ContextMenuClient_CustomContextMenuAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContextMenuClient_CustomContextMenuAction_Params {
  constructor() {
    /** @type { !number } */
    this.action;
  }
}



mojo.internal.Struct(
    ContextMenuClient_ContextMenuClosed_ParamsSpec.$,
    'ContextMenuClient_ContextMenuClosed_Params',
    [
      mojo.internal.StructField(
        'linkFollowed', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'impression', 8,
        0,
        blink_mojom_ImpressionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContextMenuClient_ContextMenuClosed_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.linkFollowed;
    /** @type { (blink_mojom_Impression|undefined) } */
    this.impression;
  }
}

