// third_party/blink/public/mojom/document_metadata/document_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/document_metadata/document_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var metadata$ =
      mojo.internal.exposeNamespace('schemaOrg.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/schema_org/common/metadata.mojom', '../../../../../components/schema_org/common/metadata.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function WebPage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPage.prototype.initDefaults_ = function() {
    this.url = null;
    this.title = null;
    this.entities = null;
  };
  WebPage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPage.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPage.title
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPage.entities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(metadata$.Entity), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPage.encodedSize = codec.kStructHeaderSize + 24;

  WebPage.decode = function(decoder) {
    var packed;
    var val = new WebPage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.title =
        decoder.decodeStruct(codec.String);
    val.entities =
        decoder.decodeArrayPointer(new codec.PointerTo(metadata$.Entity));
    return val;
  };

  WebPage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.title);
    encoder.encodeArrayPointer(new codec.PointerTo(metadata$.Entity), val.entities);
  };
  function DocumentMetadata_GetEntities_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentMetadata_GetEntities_Params.prototype.initDefaults_ = function() {
  };
  DocumentMetadata_GetEntities_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentMetadata_GetEntities_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentMetadata_GetEntities_Params.encodedSize = codec.kStructHeaderSize + 0;

  DocumentMetadata_GetEntities_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentMetadata_GetEntities_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DocumentMetadata_GetEntities_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentMetadata_GetEntities_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DocumentMetadata_GetEntities_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentMetadata_GetEntities_ResponseParams.prototype.initDefaults_ = function() {
    this.page = null;
  };
  DocumentMetadata_GetEntities_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentMetadata_GetEntities_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentMetadata_GetEntities_ResponseParams.page
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebPage, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentMetadata_GetEntities_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DocumentMetadata_GetEntities_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DocumentMetadata_GetEntities_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.page =
        decoder.decodeStructPointer(WebPage);
    return val;
  };

  DocumentMetadata_GetEntities_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentMetadata_GetEntities_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebPage, val.page);
  };
  var kDocumentMetadata_GetEntities_Name = 0;

  function DocumentMetadataPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DocumentMetadata,
                                                   handleOrPtrInfo);
  }

  function DocumentMetadataAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DocumentMetadata, associatedInterfacePtrInfo);
  }

  DocumentMetadataAssociatedPtr.prototype =
      Object.create(DocumentMetadataPtr.prototype);
  DocumentMetadataAssociatedPtr.prototype.constructor =
      DocumentMetadataAssociatedPtr;

  function DocumentMetadataProxy(receiver) {
    this.receiver_ = receiver;
  }
  DocumentMetadataPtr.prototype.getEntities = function() {
    return DocumentMetadataProxy.prototype.getEntities
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentMetadataProxy.prototype.getEntities = function() {
    var params_ = new DocumentMetadata_GetEntities_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDocumentMetadata_GetEntities_Name,
          codec.align(DocumentMetadata_GetEntities_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DocumentMetadata_GetEntities_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DocumentMetadata_GetEntities_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DocumentMetadataStub(delegate) {
    this.delegate_ = delegate;
  }
  DocumentMetadataStub.prototype.getEntities = function() {
    return this.delegate_ && this.delegate_.getEntities && this.delegate_.getEntities();
  }

  DocumentMetadataStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  DocumentMetadataStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDocumentMetadata_GetEntities_Name:
      var params = reader.decodeStruct(DocumentMetadata_GetEntities_Params);
      this.getEntities().then(function(response) {
        var responseParams =
            new DocumentMetadata_GetEntities_ResponseParams();
        responseParams.page = response.page;
        var builder = new codec.MessageV1Builder(
            kDocumentMetadata_GetEntities_Name,
            codec.align(DocumentMetadata_GetEntities_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DocumentMetadata_GetEntities_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDocumentMetadataRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDocumentMetadata_GetEntities_Name:
        if (message.expectsResponse())
          paramsClass = DocumentMetadata_GetEntities_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDocumentMetadataResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDocumentMetadata_GetEntities_Name:
        if (message.isResponse())
          paramsClass = DocumentMetadata_GetEntities_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DocumentMetadata = {
    name: 'blink.mojom.DocumentMetadata',
    kVersion: 0,
    ptrClass: DocumentMetadataPtr,
    proxyClass: DocumentMetadataProxy,
    stubClass: DocumentMetadataStub,
    validateRequest: validateDocumentMetadataRequest,
    validateResponse: validateDocumentMetadataResponse,
  };
  DocumentMetadataStub.prototype.validator = validateDocumentMetadataRequest;
  DocumentMetadataProxy.prototype.validator = validateDocumentMetadataResponse;
  exports.WebPage = WebPage;
  exports.DocumentMetadata = DocumentMetadata;
  exports.DocumentMetadataPtr = DocumentMetadataPtr;
  exports.DocumentMetadataAssociatedPtr = DocumentMetadataAssociatedPtr;
})();