// third_party/blink/public/mojom/dom_storage/dom_storage.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.SessionStorageNamespace');
goog.require('blink.mojom.StorageArea');
goog.require('blink.mojom.LocalFrameToken');
goog.require('blink.mojom.StorageKey');






goog.provide('blink.mojom.DomStorageProvider');
goog.provide('blink.mojom.DomStorageProviderReceiver');
goog.provide('blink.mojom.DomStorageProviderCallbackRouter');
goog.provide('blink.mojom.DomStorageProviderInterface');
goog.provide('blink.mojom.DomStorageProviderRemote');
goog.provide('blink.mojom.DomStorageProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DomStorageProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DomStorageProvider.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DomStorageProviderInterface = class {
  
  /**
   * @param { !blink.mojom.DomStoragePendingReceiver } receiver
   * @param { !blink.mojom.DomStorageClientRemote } client
   */

  bindDomStorage(receiver, client) {}
};

/**
 * @export
 * @implements { blink.mojom.DomStorageProviderInterface }
 */
blink.mojom.DomStorageProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DomStorageProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DomStorageProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DomStorageProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DomStoragePendingReceiver } receiver
   * @param { !blink.mojom.DomStorageClientRemote } client
   */

  bindDomStorage(
      receiver,
      client) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        [
          receiver,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DomStorageProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DomStorageProviderReceiver = class {
  /**
   * @param {!blink.mojom.DomStorageProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DomStorageProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DomStorageProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        impl.bindDomStorage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DomStorageProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorageProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DomStorageProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DomStorageProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DomStorageProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DomStorageProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DomStorageProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindDomStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        this.bindDomStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DomStorage');
goog.provide('blink.mojom.DomStorageReceiver');
goog.provide('blink.mojom.DomStorageCallbackRouter');
goog.provide('blink.mojom.DomStorageInterface');
goog.provide('blink.mojom.DomStorageRemote');
goog.provide('blink.mojom.DomStoragePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DomStoragePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DomStorage.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DomStorageInterface = class {
  
  /**
   * @param { !blink.mojom.StorageKey } storageKey
   * @param { !blink.mojom.LocalFrameToken } localFrameToken
   * @param { !blink.mojom.StorageAreaPendingReceiver } area
   */

  openLocalStorage(storageKey, localFrameToken, area) {}
  
  /**
   * @param { !string } namespaceId
   * @param { !blink.mojom.SessionStorageNamespacePendingReceiver } receiver
   */

  bindSessionStorageNamespace(namespaceId, receiver) {}
  
  /**
   * @param { !blink.mojom.StorageKey } storageKey
   * @param { !blink.mojom.LocalFrameToken } localFrameToken
   * @param { !string } namespaceId
   * @param { !blink.mojom.StorageAreaPendingReceiver } sessionNamespace
   */

  bindSessionStorageArea(storageKey, localFrameToken, namespaceId, sessionNamespace) {}
};

/**
 * @export
 * @implements { blink.mojom.DomStorageInterface }
 */
blink.mojom.DomStorageRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DomStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DomStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DomStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.StorageKey } storageKey
   * @param { !blink.mojom.LocalFrameToken } localFrameToken
   * @param { !blink.mojom.StorageAreaPendingReceiver } area
   */

  openLocalStorage(
      storageKey,
      localFrameToken,
      area) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        [
          storageKey,
          localFrameToken,
          area
        ],
        false);
  }

  
  /**
   * @param { !string } namespaceId
   * @param { !blink.mojom.SessionStorageNamespacePendingReceiver } receiver
   */

  bindSessionStorageNamespace(
      namespaceId,
      receiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        [
          namespaceId,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.StorageKey } storageKey
   * @param { !blink.mojom.LocalFrameToken } localFrameToken
   * @param { !string } namespaceId
   * @param { !blink.mojom.StorageAreaPendingReceiver } sessionNamespace
   */

  bindSessionStorageArea(
      storageKey,
      localFrameToken,
      namespaceId,
      sessionNamespace) {
    this.proxy.sendMessage(
        2,
        blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        [
          storageKey,
          localFrameToken,
          namespaceId,
          sessionNamespace
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DomStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DomStorageReceiver = class {
  /**
   * @param {!blink.mojom.DomStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DomStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DomStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        impl.openLocalStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        impl.bindSessionStorageNamespace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        impl.bindSessionStorageArea.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DomStorage = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DomStorageRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DomStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DomStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DomStorageCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DomStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openLocalStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        this.openLocalStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSessionStorageNamespace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        this.bindSessionStorageNamespace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSessionStorageArea =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        this.bindSessionStorageArea.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DomStorageClient');
goog.provide('blink.mojom.DomStorageClientReceiver');
goog.provide('blink.mojom.DomStorageClientCallbackRouter');
goog.provide('blink.mojom.DomStorageClientInterface');
goog.provide('blink.mojom.DomStorageClientRemote');
goog.provide('blink.mojom.DomStorageClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DomStorageClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DomStorageClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DomStorageClientInterface = class {
  
  /**
   */

  resetSessionStorageConnections() {}
  
  /**
   */

  resetLocalStorageConnections() {}
};

/**
 * @export
 * @implements { blink.mojom.DomStorageClientInterface }
 */
blink.mojom.DomStorageClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DomStorageClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DomStorageClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DomStorageClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  resetSessionStorageConnections() {
    this.proxy.sendMessage(
        0,
        blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resetLocalStorageConnections() {
    this.proxy.sendMessage(
        1,
        blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DomStorageClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DomStorageClientReceiver = class {
  /**
   * @param {!blink.mojom.DomStorageClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DomStorageClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DomStorageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        impl.resetSessionStorageConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        impl.resetLocalStorageConnections.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DomStorageClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorageClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DomStorageClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DomStorageClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DomStorageClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DomStorageClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DomStorageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DomStorageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetSessionStorageConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        this.resetSessionStorageConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetLocalStorageConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        this.resetLocalStorageConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DomStorageProvider_BindDomStorage_ParamsSpec.$,
    'DomStorageProvider_BindDomStorage_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DomStoragePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DomStorageClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DomStorageProvider_BindDomStorage_Params');

/** @record */
blink.mojom.DomStorageProvider_BindDomStorage_Params = class {
  constructor() {
    /** @export { !blink.mojom.DomStoragePendingReceiver } */
    this.receiver;
    /** @export { !blink.mojom.DomStorageClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.DomStorage_OpenLocalStorage_ParamsSpec.$,
    'DomStorage_OpenLocalStorage_Params',
    [
      mojo.internal.StructField(
        'storageKey', 0,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localFrameToken', 8,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'area', 16,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.StorageAreaPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.DomStorage_OpenLocalStorage_Params');

/** @record */
blink.mojom.DomStorage_OpenLocalStorage_Params = class {
  constructor() {
    /** @export { !blink.mojom.StorageKey } */
    this.storageKey;
    /** @export { !blink.mojom.LocalFrameToken } */
    this.localFrameToken;
    /** @export { !blink.mojom.StorageAreaPendingReceiver } */
    this.area;
  }
};



mojo.internal.Struct(
    blink.mojom.DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
    'DomStorage_BindSessionStorageNamespace_Params',
    [
      mojo.internal.StructField(
        'namespaceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.SessionStorageNamespacePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DomStorage_BindSessionStorageNamespace_Params');

/** @record */
blink.mojom.DomStorage_BindSessionStorageNamespace_Params = class {
  constructor() {
    /** @export { !string } */
    this.namespaceId;
    /** @export { !blink.mojom.SessionStorageNamespacePendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.DomStorage_BindSessionStorageArea_ParamsSpec.$,
    'DomStorage_BindSessionStorageArea_Params',
    [
      mojo.internal.StructField(
        'storageKey', 0,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localFrameToken', 8,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'namespaceId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionNamespace', 24,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.StorageAreaPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.DomStorage_BindSessionStorageArea_Params');

/** @record */
blink.mojom.DomStorage_BindSessionStorageArea_Params = class {
  constructor() {
    /** @export { !blink.mojom.StorageKey } */
    this.storageKey;
    /** @export { !blink.mojom.LocalFrameToken } */
    this.localFrameToken;
    /** @export { !string } */
    this.namespaceId;
    /** @export { !blink.mojom.StorageAreaPendingReceiver } */
    this.sessionNamespace;
  }
};



mojo.internal.Struct(
    blink.mojom.DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
    'DomStorageClient_ResetSessionStorageConnections_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DomStorageClient_ResetSessionStorageConnections_Params');

/** @record */
blink.mojom.DomStorageClient_ResetSessionStorageConnections_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
    'DomStorageClient_ResetLocalStorageConnections_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DomStorageClient_ResetLocalStorageConnections_Params');

/** @record */
blink.mojom.DomStorageClient_ResetLocalStorageConnections_Params = class {
  constructor() {
  }
};

