// third_party/blink/public/mojom/drag/drag.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  BigString16 as mojoBase_mojom_BigString16,
  BigString16Spec as mojoBase_mojom_BigString16Spec,
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  ReferrerPolicy as network_mojom_ReferrerPolicy,
  ReferrerPolicySpec as network_mojom_ReferrerPolicySpec
} from '../../../../../services/network/public/mojom/referrer_policy.mojom.m.js';

import {
  DragEventSource as ui_mojom_DragEventSource,
  DragEventSourceSpec as ui_mojom_DragEventSourceSpec
} from '../../../../../ui/base/dragdrop/mojom/drag_drop_types.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from '../blob/serialized_blob.mojom.m.js';

import {
  DataTransferFile as blink_mojom_DataTransferFile,
  DataTransferFileSpec as blink_mojom_DataTransferFileSpec
} from '../data_transfer/data_transfer.mojom.m.js';



/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AllowedDragOperationsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DragItemStringSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DragItemBinarySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DragItemFileSystemFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DragDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DragEventSourceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const DragItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AllowedDragOperationsSpec.$,
    'AllowedDragOperations',
    [
      mojo.internal.StructField(
        'allowCopy', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowLink', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowMove', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AllowedDragOperations {
  constructor() {
    /** @type { !boolean } */
    this.allowCopy;
    /** @type { !boolean } */
    this.allowLink;
    /** @type { !boolean } */
    this.allowMove;
  }
}



mojo.internal.Struct(
    DragItemStringSpec.$,
    'DragItemString',
    [
      mojo.internal.StructField(
        'stringType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringData', 8,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'baseUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DragItemString {
  constructor() {
    /** @type { !string } */
    this.stringType;
    /** @type { !mojoBase_mojom_BigString16 } */
    this.stringData;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.title;
    /** @type { (url_mojom_Url|undefined) } */
    this.baseUrl;
  }
}



mojo.internal.Struct(
    DragItemBinarySpec.$,
    'DragItemBinary',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isImageAccessible', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filenameExtension', 32,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentDisposition', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DragItemBinary {
  constructor() {
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
    /** @type { !boolean } */
    this.isImageAccessible;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
    /** @type { !mojoBase_mojom_FilePath } */
    this.filenameExtension;
    /** @type { (string|undefined) } */
    this.contentDisposition;
  }
}



mojo.internal.Struct(
    DragItemFileSystemFileSpec.$,
    'DragItemFileSystemFile',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileSystemId', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedBlob', 24,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DragItemFileSystemFile {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !bigint } */
    this.size;
    /** @type { (string|undefined) } */
    this.fileSystemId;
    /** @type { (blink_mojom_SerializedBlob|undefined) } */
    this.serializedBlob;
  }
}



mojo.internal.Struct(
    DragDataSpec.$,
    'DragData',
    [
      mojo.internal.StructField(
        'items', 0,
        0,
        mojo.internal.Array(DragItemSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileSystemId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceDefaultAction', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 20,
        0,
        network_mojom_ReferrerPolicySpec.$,
        network_mojom_ReferrerPolicy.kDefault,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DragData {
  constructor() {
    /** @type { !Array<!DragItem> } */
    this.items;
    /** @type { (string|undefined) } */
    this.fileSystemId;
    /** @type { !boolean } */
    this.forceDefaultAction;
    /** @type { !network_mojom_ReferrerPolicy } */
    this.referrerPolicy;
  }
}



mojo.internal.Struct(
    DragEventSourceInfoSpec.$,
    'DragEventSourceInfo',
    [
      mojo.internal.StructField(
        'location', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        ui_mojom_DragEventSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DragEventSourceInfo {
  constructor() {
    /** @type { !gfx_mojom_Point } */
    this.location;
    /** @type { !ui_mojom_DragEventSource } */
    this.source;
  }
}

mojo.internal.Union(
    DragItemSpec.$, 'DragItem',
    {
      'string': {
        'ordinal': 0,
        'type': DragItemStringSpec.$,
      },
      'file': {
        'ordinal': 1,
        'type': blink_mojom_DataTransferFileSpec.$,
      },
      'binary': {
        'ordinal': 2,
        'type': DragItemBinarySpec.$,
      },
      'fileSystemFile': {
        'ordinal': 3,
        'type': DragItemFileSystemFileSpec.$,
      },
    });

/**
 * @typedef { {
 *   string: (!DragItemString|undefined),
 *   file: (!blink_mojom_DataTransferFile|undefined),
 *   binary: (!DragItemBinary|undefined),
 *   fileSystemFile: (!DragItemFileSystemFile|undefined),
 * } }
 */
export const DragItem = {};
