// third_party/blink/public/mojom/facilitated_payments/payment_link_handler.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/facilitated_payments/payment_link_handler.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('payments.facilitated.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function PaymentLinkHandler_HandlePaymentLink_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaymentLinkHandler_HandlePaymentLink_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  PaymentLinkHandler_HandlePaymentLink_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaymentLinkHandler_HandlePaymentLink_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentLinkHandler_HandlePaymentLink_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PaymentLinkHandler_HandlePaymentLink_Params.encodedSize = codec.kStructHeaderSize + 8;

  PaymentLinkHandler_HandlePaymentLink_Params.decode = function(decoder) {
    var packed;
    var val = new PaymentLinkHandler_HandlePaymentLink_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  PaymentLinkHandler_HandlePaymentLink_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaymentLinkHandler_HandlePaymentLink_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  var kPaymentLinkHandler_HandlePaymentLink_Name = 0;

  function PaymentLinkHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PaymentLinkHandler,
                                                   handleOrPtrInfo);
  }

  function PaymentLinkHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PaymentLinkHandler, associatedInterfacePtrInfo);
  }

  PaymentLinkHandlerAssociatedPtr.prototype =
      Object.create(PaymentLinkHandlerPtr.prototype);
  PaymentLinkHandlerAssociatedPtr.prototype.constructor =
      PaymentLinkHandlerAssociatedPtr;

  function PaymentLinkHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  PaymentLinkHandlerPtr.prototype.handlePaymentLink = function() {
    return PaymentLinkHandlerProxy.prototype.handlePaymentLink
        .apply(this.ptr.getProxy(), arguments);
  };

  PaymentLinkHandlerProxy.prototype.handlePaymentLink = function(url) {
    var params_ = new PaymentLinkHandler_HandlePaymentLink_Params();
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kPaymentLinkHandler_HandlePaymentLink_Name,
        codec.align(PaymentLinkHandler_HandlePaymentLink_Params.encodedSize));
    builder.encodeStruct(PaymentLinkHandler_HandlePaymentLink_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PaymentLinkHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  PaymentLinkHandlerStub.prototype.handlePaymentLink = function(url) {
    return this.delegate_ && this.delegate_.handlePaymentLink && this.delegate_.handlePaymentLink(url);
  }

  PaymentLinkHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPaymentLinkHandler_HandlePaymentLink_Name:
      var params = reader.decodeStruct(PaymentLinkHandler_HandlePaymentLink_Params);
      this.handlePaymentLink(params.url);
      return true;
    default:
      return false;
    }
  };

  PaymentLinkHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePaymentLinkHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPaymentLinkHandler_HandlePaymentLink_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PaymentLinkHandler_HandlePaymentLink_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePaymentLinkHandlerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PaymentLinkHandler = {
    name: 'payments.facilitated.mojom.PaymentLinkHandler',
    kVersion: 0,
    ptrClass: PaymentLinkHandlerPtr,
    proxyClass: PaymentLinkHandlerProxy,
    stubClass: PaymentLinkHandlerStub,
    validateRequest: validatePaymentLinkHandlerRequest,
    validateResponse: null,
  };
  PaymentLinkHandlerStub.prototype.validator = validatePaymentLinkHandlerRequest;
  PaymentLinkHandlerProxy.prototype.validator = null;
  exports.PaymentLinkHandler = PaymentLinkHandler;
  exports.PaymentLinkHandlerPtr = PaymentLinkHandlerPtr;
  exports.PaymentLinkHandlerAssociatedPtr = PaymentLinkHandlerAssociatedPtr;
})();