// third_party/blink/public/mojom/fetch/fetch_api_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/fetch/fetch_api_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var attribution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/attribution.mojom', '../../../../../services/network/public/mojom/attribution.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', '../../../../../services/network/public/mojom/ip_address_space.mojom.js');
  }
  var chunked_data_pipe_getter$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/chunked_data_pipe_getter.mojom', '../../../../../services/network/public/mojom/chunked_data_pipe_getter.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', '../../../../../services/network/public/mojom/request_priority.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', '../../../../../services/network/public/mojom/trust_tokens.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', '../../../../../services/network/public/mojom/url_request.mojom.js');
  }
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', '../blob/serialized_blob.mojom.js');
  }
  var request_context_frame_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/request_context_frame_type.mojom', '../loader/request_context_frame_type.mojom.js');
  }
  var referrer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/referrer.mojom', '../loader/referrer.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var RequestContextType = {};
  RequestContextType.UNSPECIFIED = 0;
  RequestContextType.ATTRIBUTION_SRC = 1;
  RequestContextType.AUDIO = 2;
  RequestContextType.BEACON = 3;
  RequestContextType.CSP_REPORT = 4;
  RequestContextType.DOWNLOAD = 5;
  RequestContextType.EMBED = 6;
  RequestContextType.EVENT_SOURCE = 7;
  RequestContextType.FAVICON = 8;
  RequestContextType.FETCH = 9;
  RequestContextType.FONT = 10;
  RequestContextType.FORM = 11;
  RequestContextType.FRAME = 12;
  RequestContextType.HYPERLINK = 13;
  RequestContextType.IFRAME = 14;
  RequestContextType.IMAGE = 15;
  RequestContextType.IMAGE_SET = 16;
  RequestContextType.INTERNAL = 17;
  RequestContextType.JSON = 18;
  RequestContextType.LOCATION = 19;
  RequestContextType.MANIFEST = 20;
  RequestContextType.OBJECT = 21;
  RequestContextType.PING = 22;
  RequestContextType.PLUGIN = 23;
  RequestContextType.PREFETCH = 24;
  RequestContextType.SCRIPT = 25;
  RequestContextType.SERVICE_WORKER = 26;
  RequestContextType.SHARED_WORKER = 27;
  RequestContextType.SPECULATION_RULES = 28;
  RequestContextType.SUBRESOURCE = 29;
  RequestContextType.SUBRESOURCE_WEBBUNDLE = 30;
  RequestContextType.STYLE = 31;
  RequestContextType.TRACK = 32;
  RequestContextType.VIDEO = 33;
  RequestContextType.WORKER = 34;
  RequestContextType.XML_HTTP_REQUEST = 35;
  RequestContextType.XSLT = 36;
  RequestContextType.MIN_VALUE = 0;
  RequestContextType.MAX_VALUE = 36;

  RequestContextType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
      return true;
    }
    return false;
  };

  RequestContextType.toKnownEnumValue = function(value) {
    return value;
  };

  RequestContextType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FetchCacheMode = {};
  FetchCacheMode.kDefault = 0;
  FetchCacheMode.kNoStore = 1;
  FetchCacheMode.kBypassCache = 2;
  FetchCacheMode.kValidateCache = 3;
  FetchCacheMode.kForceCache = 4;
  FetchCacheMode.kOnlyIfCached = 5;
  FetchCacheMode.kUnspecifiedOnlyIfCachedStrict = 6;
  FetchCacheMode.kUnspecifiedForceCacheMiss = 7;
  FetchCacheMode.MIN_VALUE = 0;
  FetchCacheMode.MAX_VALUE = 7;

  FetchCacheMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  FetchCacheMode.toKnownEnumValue = function(value) {
    return value;
  };

  FetchCacheMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FetchPriorityHint = {};
  FetchPriorityHint.kLow = 0;
  FetchPriorityHint.kAuto = 1;
  FetchPriorityHint.kHigh = 2;
  FetchPriorityHint.MIN_VALUE = 0;
  FetchPriorityHint.MAX_VALUE = 2;

  FetchPriorityHint.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  FetchPriorityHint.toKnownEnumValue = function(value) {
    return value;
  };

  FetchPriorityHint.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FetchAPIRequestHeaders(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchAPIRequestHeaders.prototype.initDefaults_ = function() {
    this.headers = null;
  };
  FetchAPIRequestHeaders.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchAPIRequestHeaders.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequestHeaders.headers
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchAPIRequestHeaders.encodedSize = codec.kStructHeaderSize + 8;

  FetchAPIRequestHeaders.decode = function(decoder) {
    var packed;
    var val = new FetchAPIRequestHeaders();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.headers =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  FetchAPIRequestHeaders.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchAPIRequestHeaders.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, codec.String, val.headers);
  };
  function FetchAPIRequestBody(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchAPIRequestBody.prototype.initDefaults_ = function() {
    this.elements = null;
    this.identifier = 0;
    this.containsSensitiveInfo = false;
  };
  FetchAPIRequestBody.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchAPIRequestBody.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequestBody.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 16, url_request$.DataElement, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FetchAPIRequestBody.encodedSize = codec.kStructHeaderSize + 24;

  FetchAPIRequestBody.decode = function(decoder) {
    var packed;
    var val = new FetchAPIRequestBody();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(url_request$.DataElement);
    val.identifier =
        decoder.decodeStruct(codec.Uint64);
    packed = decoder.readUint8();
    val.containsSensitiveInfo = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FetchAPIRequestBody.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchAPIRequestBody.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(url_request$.DataElement, val.elements);
    encoder.encodeStruct(codec.Uint64, val.identifier);
    packed = 0;
    packed |= (val.containsSensitiveInfo & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FetchAPIRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchAPIRequest.prototype.initDefaults_ = function() {
    this.mode = fetch_api$.RequestMode.kNoCors;
    this.isMainResourceLoad = false;
    this.keepalive = false;
    this.isReload = false;
    this.isHistoryNavigation = false;
    this.destination = fetch_api$.RequestDestination.kEmpty;
    this.frameType = request_context_frame_type$.RequestContextFrameType.kNone;
    this.url = null;
    this.method = null;
    this.headers = null;
    this.blob = null;
    this.body = null;
    this.requestInitiator = null;
    this.navigationRedirectChain = null;
    this.referrer = null;
    this.credentialsMode = fetch_api$.CredentialsMode.kOmit;
    this.cacheMode = FetchCacheMode.kDefault;
    this.redirectMode = fetch_api$.RedirectMode.kFollow;
    this.priority = request_priority$.RequestPriority.kIdle;
    this.integrity = null;
    this.fetchWindowId = null;
    this.devtoolsStackId = null;
    this.trustTokenParams = null;
    this.targetAddressSpace = ip_address_space$.IPAddressSpace.kUnknown;
    this.attributionReportingEligibility = attribution$.AttributionReportingEligibility.kUnset;
    this.attributionReportingSupport = attribution$.AttributionSupport.kUnset;
    this.serviceWorkerRaceNetworkRequestToken = null;
  };
  FetchAPIRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchAPIRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 160}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, fetch_api$.RequestMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FetchAPIRequest.destination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.frameType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, request_context_frame_type$.RequestContextFrameType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, FetchAPIRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.blob
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, serialized_blob$.SerializedBlob, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.body
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, FetchAPIRequestBody, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.requestInitiator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.navigationRedirectChain
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 64, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, referrer$.Referrer, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.credentialsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 80, fetch_api$.CredentialsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.cacheMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 84, FetchCacheMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.redirectMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 88, fetch_api$.RedirectMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.integrity
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 96, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 92, request_priority$.RequestPriority);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.fetchWindowId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate FetchAPIRequest.devtoolsStackId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 112, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.trustTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, trust_tokens$.TrustTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.targetAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 128, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.attributionReportingEligibility
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 132, attribution$.AttributionReportingEligibility);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.attributionReportingSupport
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 136, attribution$.AttributionSupport);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FetchAPIRequest.serviceWorkerRaceNetworkRequestToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FetchAPIRequest.encodedSize = codec.kStructHeaderSize + 152;

  FetchAPIRequest.decode = function(decoder) {
    var packed;
    var val = new FetchAPIRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestMode));
    packed = decoder.readUint8();
    val.isMainResourceLoad = (packed >> 0) & 1 ? true : false;
    val.keepalive = (packed >> 1) & 1 ? true : false;
    val.isReload = (packed >> 2) & 1 ? true : false;
    val.isHistoryNavigation = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.destination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    val.frameType =
        decoder.decodeStruct(new codec.Enum(request_context_frame_type$.RequestContextFrameType));
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.method =
        decoder.decodeStruct(codec.String);
    val.headers =
        decoder.decodeStructPointer(FetchAPIRequestHeaders);
    val.blob =
        decoder.decodeStructPointer(serialized_blob$.SerializedBlob);
    val.body =
        decoder.decodeStructPointer(FetchAPIRequestBody);
    val.requestInitiator =
        decoder.decodeStructPointer(origin$.Origin);
    val.navigationRedirectChain =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.referrer =
        decoder.decodeStructPointer(referrer$.Referrer);
    val.credentialsMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.CredentialsMode));
    val.cacheMode =
        decoder.decodeStruct(new codec.Enum(FetchCacheMode));
    val.redirectMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RedirectMode));
    val.priority =
        decoder.decodeStruct(new codec.Enum(request_priority$.RequestPriority));
    val.integrity =
        decoder.decodeStruct(codec.String);
    val.fetchWindowId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.devtoolsStackId =
        decoder.decodeStruct(codec.String);
    val.trustTokenParams =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenParams);
    val.targetAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.attributionReportingEligibility =
        decoder.decodeStruct(new codec.Enum(attribution$.AttributionReportingEligibility));
    val.attributionReportingSupport =
        decoder.decodeStruct(new codec.Enum(attribution$.AttributionSupport));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.serviceWorkerRaceNetworkRequestToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  FetchAPIRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchAPIRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    packed = 0;
    packed |= (val.isMainResourceLoad & 1) << 0
    packed |= (val.keepalive & 1) << 1
    packed |= (val.isReload & 1) << 2
    packed |= (val.isHistoryNavigation & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.destination);
    encoder.encodeStruct(codec.Int32, val.frameType);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(FetchAPIRequestHeaders, val.headers);
    encoder.encodeStructPointer(serialized_blob$.SerializedBlob, val.blob);
    encoder.encodeStructPointer(FetchAPIRequestBody, val.body);
    encoder.encodeStructPointer(origin$.Origin, val.requestInitiator);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.navigationRedirectChain);
    encoder.encodeStructPointer(referrer$.Referrer, val.referrer);
    encoder.encodeStruct(codec.Int32, val.credentialsMode);
    encoder.encodeStruct(codec.Int32, val.cacheMode);
    encoder.encodeStruct(codec.Int32, val.redirectMode);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.String, val.integrity);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.fetchWindowId);
    encoder.encodeStruct(codec.String, val.devtoolsStackId);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenParams, val.trustTokenParams);
    encoder.encodeStruct(codec.Int32, val.targetAddressSpace);
    encoder.encodeStruct(codec.Int32, val.attributionReportingEligibility);
    encoder.encodeStruct(codec.Int32, val.attributionReportingSupport);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.serviceWorkerRaceNetworkRequestToken);
  };
  exports.RequestContextType = RequestContextType;
  exports.FetchCacheMode = FetchCacheMode;
  exports.FetchPriorityHint = FetchPriorityHint;
  exports.FetchAPIRequestHeaders = FetchAPIRequestHeaders;
  exports.FetchAPIRequestBody = FetchAPIRequestBody;
  exports.FetchAPIRequest = FetchAPIRequest;
})();