// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessError');






goog.provide('blink.mojom.FileSystemAccessFileWriter');
goog.provide('blink.mojom.FileSystemAccessFileWriterReceiver');
goog.provide('blink.mojom.FileSystemAccessFileWriterCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessFileWriterInterface');
goog.provide('blink.mojom.FileSystemAccessFileWriterRemote');
goog.provide('blink.mojom.FileSystemAccessFileWriterPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessFileWriterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessFileWriter.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessFileWriterInterface = class {
  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } stream
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        bytesWritten: !bigint,
   *  }>}
   */

  write(offset, stream) {}
  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  truncate(length) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  close() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  abort() {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessFileWriterInterface }
 */
blink.mojom.FileSystemAccessFileWriterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessFileWriterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessFileWriterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessFileWriterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } stream
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        bytesWritten: !bigint,
   *  }>}
   */

  write(
      offset,
      stream) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        [
          offset,
          stream
        ],
        false);
  }

  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  truncate(
      length) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        [
          length
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  close() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  abort() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessFileWriter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileWriterReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessFileWriterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessFileWriterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessFileWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        impl.truncate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessFileWriter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileWriter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessFileWriterRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessFileWriterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessFileWriter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileWriterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessFileWriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileWriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.truncate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
        this.truncate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
        this.abort.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Write_ParamsSpec.$,
    'FileSystemAccessFileWriter_Write_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stream', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Write_Params');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Write_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.offset;
    /** @export { !MojoHandle } */
    this.stream;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Write_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytesWritten', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Write_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Write_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !bigint } */
    this.bytesWritten;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Truncate_ParamsSpec.$,
    'FileSystemAccessFileWriter_Truncate_Params',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Truncate_Params');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Truncate_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Truncate_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Truncate_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Close_ParamsSpec.$,
    'FileSystemAccessFileWriter_Close_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Close_Params');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Close_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Close_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Close_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Close_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Close_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Abort_ParamsSpec.$,
    'FileSystemAccessFileWriter_Abort_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Abort_Params');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Abort_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParamsSpec.$,
    'FileSystemAccessFileWriter_Abort_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileWriter_Abort_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};

