// third_party/blink/public/mojom/frame/remote_frame.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.NavigationStateKeepAliveHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.NavigationStateKeepAliveHandle.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.NavigationStateKeepAliveHandleInterface }
 */
blink.mojom.NavigationStateKeepAliveHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.NavigationStateKeepAliveHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.NavigationStateKeepAliveHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.NavigationStateKeepAliveHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the NavigationStateKeepAliveHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.NavigationStateKeepAliveHandleReceiver = class {
  /**
   * @param {!blink.mojom.NavigationStateKeepAliveHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.NavigationStateKeepAliveHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.NavigationStateKeepAliveHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NavigationStateKeepAliveHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.NavigationStateKeepAliveHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NavigationStateKeepAliveHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.NavigationStateKeepAliveHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.NavigationStateKeepAliveHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NavigationStateKeepAliveHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.NavigationStateKeepAliveHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.NavigationStateKeepAliveHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NavigationStateKeepAliveHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RemoteFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RemoteFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RemoteFrameHostInterface }
 */
blink.mojom.RemoteFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RemoteFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RemoteFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RemoteFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !cc.mojom.TouchAction } touchAction
   */

  setInheritedEffectiveTouchAction(
      touchAction) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        [
          touchAction
        ],
        false);
  }

  
  /**
   * @param { !boolean } isThrottled
   * @param { !boolean } subtreeThrottled
   * @param { !boolean } displayLocked
   */

  updateRenderThrottlingStatus(
      isThrottled,
      subtreeThrottled,
      displayLocked) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        [
          isThrottled,
          subtreeThrottled,
          displayLocked
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameVisibility } visibility
   */

  visibilityChanged(
      visibility) {
    this.proxy.sendMessage(
        2,
        blink.mojom.RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        [
          visibility
        ],
        false);
  }

  
  /**
   */

  didFocusFrame() {
    this.proxy.sendMessage(
        3,
        blink.mojom.RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  checkCompleted() {
    this.proxy.sendMessage(
        4,
        blink.mojom.RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } clipRect
   * @param { !mojoBase.mojom.UnguessableToken } guid
   */

  capturePaintPreviewOfCrossProcessSubframe(
      clipRect,
      guid) {
    this.proxy.sendMessage(
        5,
        blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        [
          clipRect,
          guid
        ],
        false);
  }

  
  /**
   * @param { !boolean } inert
   */

  setIsInert(
      inert) {
    this.proxy.sendMessage(
        6,
        blink.mojom.RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        [
          inert
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.LocalFrameToken } openerFrame
   */

  didChangeOpener(
      openerFrame) {
    this.proxy.sendMessage(
        7,
        blink.mojom.RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        [
          openerFrame
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FocusType } focusType
   * @param { !blink.mojom.LocalFrameToken } sourceFrameToken
   */

  advanceFocus(
      focusType,
      sourceFrameToken) {
    this.proxy.sendMessage(
        8,
        blink.mojom.RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        [
          focusType,
          sourceFrameToken
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.LocalFrameToken } sourceFrameToken
   * @param { !url.mojom.Origin } sourceOrigin
   * @param { ?url.mojom.Origin } targetOrigin
   * @param { !blink.mojom.TransferableMessage } message
   */

  routeMessageEvent(
      sourceFrameToken,
      sourceOrigin,
      targetOrigin,
      message) {
    this.proxy.sendMessage(
        9,
        blink.mojom.RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        [
          sourceFrameToken,
          sourceOrigin,
          targetOrigin,
          message
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } frameContentRect
   * @param { !number } documentCookie
   */

  printCrossProcessSubframe(
      frameContentRect,
      documentCookie) {
    this.proxy.sendMessage(
        10,
        blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        [
          frameContentRect,
          documentCookie
        ],
        false);
  }

  
  /**
   */

  detach() {
    this.proxy.sendMessage(
        11,
        blink.mojom.RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ViewportIntersectionState } intersectionState
   * @param { ?blink.mojom.FrameVisualProperties } visualProperties
   */

  updateViewportIntersection(
      intersectionState,
      visualProperties) {
    this.proxy.sendMessage(
        12,
        blink.mojom.RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        [
          intersectionState,
          visualProperties
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameVisualProperties } properties
   */

  synchronizeVisualProperties(
      properties) {
    this.proxy.sendMessage(
        13,
        blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        [
          properties
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.OpenURLParams } params
   */

  openURL(
      params) {
    this.proxy.sendMessage(
        14,
        blink.mojom.RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RemoteFrameHostReceiver = class {
  /**
   * @param {!blink.mojom.RemoteFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RemoteFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RemoteFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        impl.setInheritedEffectiveTouchAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        impl.updateRenderThrottlingStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        impl.visibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        impl.didFocusFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        impl.checkCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        impl.capturePaintPreviewOfCrossProcessSubframe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        impl.setIsInert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        impl.didChangeOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        impl.advanceFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        impl.routeMessageEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        impl.printCrossProcessSubframe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        impl.detach.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        impl.updateViewportIntersection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        impl.synchronizeVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        impl.openURL.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RemoteFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RemoteFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RemoteFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RemoteFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RemoteFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInheritedEffectiveTouchAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
        null,
        this.setInheritedEffectiveTouchAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRenderThrottlingStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
        null,
        this.updateRenderThrottlingStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.visibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
        null,
        this.visibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFocusFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
        null,
        this.didFocusFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RemoteFrameHost_CheckCompleted_ParamsSpec.$,
        null,
        this.checkCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.capturePaintPreviewOfCrossProcessSubframe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
        null,
        this.capturePaintPreviewOfCrossProcessSubframe.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsInert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.RemoteFrameHost_SetIsInert_ParamsSpec.$,
        null,
        this.setIsInert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
        null,
        this.didChangeOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advanceFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
        null,
        this.advanceFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.routeMessageEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
        null,
        this.routeMessageEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printCrossProcessSubframe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
        null,
        this.printCrossProcessSubframe.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detach =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.RemoteFrameHost_Detach_ParamsSpec.$,
        null,
        this.detach.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateViewportIntersection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
        null,
        this.updateViewportIntersection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.synchronizeVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
        null,
        this.synchronizeVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.RemoteFrameHost_OpenURL_ParamsSpec.$,
        null,
        this.openURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RemoteFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RemoteFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RemoteFrameInterface }
 */
blink.mojom.RemoteFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RemoteFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RemoteFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RemoteFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FullscreenOptions } options
   */

  willEnterFullscreen(
      options) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } set
   */

  enforceInsecureNavigationsSet(
      set) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        [
          set
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FrameOwnerProperties } properties
   */

  setFrameOwnerProperties(
      properties) {
    this.proxy.sendMessage(
        2,
        blink.mojom.RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        [
          properties
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.InsecureRequestPolicy } policy
   */

  enforceInsecureRequestPolicy(
      policy) {
    this.proxy.sendMessage(
        3,
        blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        [
          policy
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !boolean } isPotentiallyTrustworthyUniqueOrigin
   */

  setReplicatedOrigin(
      origin,
      isPotentiallyTrustworthyUniqueOrigin) {
    this.proxy.sendMessage(
        4,
        blink.mojom.RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        [
          origin,
          isPotentiallyTrustworthyUniqueOrigin
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAdFrame
   */

  setReplicatedIsAdFrame(
      isAdFrame) {
    this.proxy.sendMessage(
        5,
        blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        [
          isAdFrame
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !string } uniqueName
   */

  setReplicatedName(
      name,
      uniqueName) {
    this.proxy.sendMessage(
        6,
        blink.mojom.RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        [
          name,
          uniqueName
        ],
        false);
  }

  
  /**
   */

  dispatchLoadEventForFrameOwner() {
    this.proxy.sendMessage(
        7,
        blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } needsTracking
   */

  setNeedsOcclusionTracking(
      needsTracking) {
    this.proxy.sendMessage(
        8,
        blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        [
          needsTracking
        ],
        false);
  }

  
  /**
   * @param { !boolean } collapsed
   */

  collapse(
      collapsed) {
    this.proxy.sendMessage(
        9,
        blink.mojom.RemoteFrame_Collapse_ParamsSpec.$,
        null,
        [
          collapsed
        ],
        false);
  }

  
  /**
   */

  focus() {
    this.proxy.sendMessage(
        10,
        blink.mojom.RemoteFrame_Focus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } hasGesture
   */

  setHadStickyUserActivationBeforeNavigation(
      hasGesture) {
    this.proxy.sendMessage(
        11,
        blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        [
          hasGesture
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ScrollDirection } direction
   * @param { !ui.mojom.ScrollGranularity } granularity
   */

  bubbleLogicalScroll(
      direction,
      granularity) {
    this.proxy.sendMessage(
        12,
        blink.mojom.RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        [
          direction,
          granularity
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.UserActivationUpdateType } stateUpdateType
   * @param { !blink.mojom.UserActivationNotificationType } notificationType
   */

  updateUserActivationState(
      stateUpdateType,
      notificationType) {
    this.proxy.sendMessage(
        13,
        blink.mojom.RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        [
          stateUpdateType,
          notificationType
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } embeddingToken
   */

  setEmbeddingToken(
      embeddingToken) {
    this.proxy.sendMessage(
        14,
        blink.mojom.RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        [
          embeddingToken
        ],
        false);
  }

  
  /**
   * @param { !boolean } isFocused
   */

  setPageFocus(
      isFocused) {
    this.proxy.sendMessage(
        15,
        blink.mojom.RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        [
          isFocused
        ],
        false);
  }

  
  /**
   */

  renderFallbackContent() {
    this.proxy.sendMessage(
        16,
        blink.mojom.RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ResourceTimingInfo } timing
   */

  addResourceTimingFromChild(
      timing) {
    this.proxy.sendMessage(
        17,
        blink.mojom.RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        [
          timing
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.RectF } rect
   * @param { !blink.mojom.ScrollIntoViewParams } params
   */

  scrollRectToVisible(
      rect,
      params) {
    this.proxy.sendMessage(
        18,
        blink.mojom.RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        [
          rect,
          params
        ],
        false);
  }

  
  /**
   */

  didStartLoading() {
    this.proxy.sendMessage(
        19,
        blink.mojom.RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didStopLoading() {
    this.proxy.sendMessage(
        20,
        blink.mojom.RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IntrinsicSizingInfo } sizingInfo
   */

  intrinsicSizingInfoOfChildChanged(
      sizingInfo) {
    this.proxy.sendMessage(
        21,
        blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        [
          sizingInfo
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.WebSandboxFlags } sandboxFlags
   * @param { !Array<!network.mojom.ParsedPermissionsPolicyDeclaration> } parsedPermissionsPolicy
   */

  didSetFramePolicyHeaders(
      sandboxFlags,
      parsedPermissionsPolicy) {
    this.proxy.sendMessage(
        22,
        blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        [
          sandboxFlags,
          parsedPermissionsPolicy
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FramePolicy } framePolicy
   */

  didUpdateFramePolicy(
      framePolicy) {
    this.proxy.sendMessage(
        23,
        blink.mojom.RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        [
          framePolicy
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.FrameToken } openerFrameToken
   */

  updateOpener(
      openerFrameToken) {
    this.proxy.sendMessage(
        24,
        blink.mojom.RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        [
          openerFrameToken
        ],
        false);
  }

  
  /**
   */

  detachAndDispose() {
    this.proxy.sendMessage(
        25,
        blink.mojom.RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } minSize
   * @param { !gfx.mojom.Size } maxSize
   */

  enableAutoResize(
      minSize,
      maxSize) {
    this.proxy.sendMessage(
        26,
        blink.mojom.RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        [
          minSize,
          maxSize
        ],
        false);
  }

  
  /**
   */

  disableAutoResize() {
    this.proxy.sendMessage(
        27,
        blink.mojom.RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !cc.mojom.RenderFrameMetadata } metadata
   */

  didUpdateVisualProperties(
      metadata) {
    this.proxy.sendMessage(
        28,
        blink.mojom.RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.FrameSinkId } frameSinkId
   * @param { !boolean } allowPaintHolding
   */

  setFrameSinkId(
      frameSinkId,
      allowPaintHolding) {
    this.proxy.sendMessage(
        29,
        blink.mojom.RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        [
          frameSinkId,
          allowPaintHolding
        ],
        false);
  }

  
  /**
   */

  childProcessGone() {
    this.proxy.sendMessage(
        30,
        blink.mojom.RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.RemoteFrameToken } token
   * @param { ?blink.mojom.FrameToken } openerFrameToken
   * @param { !blink.mojom.TreeScopeType } treeScopeType
   * @param { !blink.mojom.FrameReplicationState } replicationState
   * @param { !blink.mojom.FrameOwnerProperties } ownerProperties
   * @param { !boolean } isLoading
   * @param { !mojoBase.mojom.UnguessableToken } devtoolsFrameToken
   * @param { !blink.mojom.RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   */

  createRemoteChild(
      token,
      openerFrameToken,
      treeScopeType,
      replicationState,
      ownerProperties,
      isLoading,
      devtoolsFrameToken,
      remoteFrameInterfaces) {
    this.proxy.sendMessage(
        31,
        blink.mojom.RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        [
          token,
          openerFrameToken,
          treeScopeType,
          replicationState,
          ownerProperties,
          isLoading,
          devtoolsFrameToken,
          remoteFrameInterfaces
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.CreateRemoteChildParams> } params
   * @param { ?mojoBase.mojom.UnguessableToken } navigationMetricsToken
   */

  createRemoteChildren(
      params,
      navigationMetricsToken) {
    this.proxy.sendMessage(
        32,
        blink.mojom.RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        [
          params,
          navigationMetricsToken
        ],
        false);
  }

  
  /**
   * @param { !string } eventType
   */

  forwardFencedFrameEventToEmbedder(
      eventType) {
    this.proxy.sendMessage(
        33,
        blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        [
          eventType
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RemoteFrameReceiver = class {
  /**
   * @param {!blink.mojom.RemoteFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RemoteFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RemoteFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        impl.willEnterFullscreen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        impl.enforceInsecureNavigationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        impl.setFrameOwnerProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        impl.enforceInsecureRequestPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        impl.setReplicatedOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        impl.setReplicatedIsAdFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        impl.setReplicatedName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        impl.dispatchLoadEventForFrameOwner.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        impl.setNeedsOcclusionTracking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.RemoteFrame_Collapse_ParamsSpec.$,
        null,
        impl.collapse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.RemoteFrame_Focus_ParamsSpec.$,
        null,
        impl.focus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        impl.setHadStickyUserActivationBeforeNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        impl.bubbleLogicalScroll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        impl.updateUserActivationState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        impl.setEmbeddingToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        impl.setPageFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        impl.renderFallbackContent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        impl.addResourceTimingFromChild.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        impl.scrollRectToVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        impl.didStartLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        impl.didStopLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        impl.intrinsicSizingInfoOfChildChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        impl.didSetFramePolicyHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        impl.didUpdateFramePolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        blink.mojom.RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        impl.updateOpener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        blink.mojom.RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        impl.detachAndDispose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        blink.mojom.RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        impl.enableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        blink.mojom.RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        impl.disableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        blink.mojom.RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        impl.didUpdateVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        blink.mojom.RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        impl.setFrameSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        blink.mojom.RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        impl.childProcessGone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        blink.mojom.RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        impl.createRemoteChild.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        blink.mojom.RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        impl.createRemoteChildren.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        impl.forwardFencedFrameEventToEmbedder.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RemoteFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RemoteFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RemoteFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RemoteFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RemoteFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.willEnterFullscreen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
        null,
        this.willEnterFullscreen.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureNavigationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
        null,
        this.enforceInsecureNavigationsSet.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameOwnerProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
        null,
        this.setFrameOwnerProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enforceInsecureRequestPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
        null,
        this.enforceInsecureRequestPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
        null,
        this.setReplicatedOrigin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedIsAdFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
        null,
        this.setReplicatedIsAdFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReplicatedName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.RemoteFrame_SetReplicatedName_ParamsSpec.$,
        null,
        this.setReplicatedName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchLoadEventForFrameOwner =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
        null,
        this.dispatchLoadEventForFrameOwner.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsOcclusionTracking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
        null,
        this.setNeedsOcclusionTracking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collapse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.RemoteFrame_Collapse_ParamsSpec.$,
        null,
        this.collapse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.RemoteFrame_Focus_ParamsSpec.$,
        null,
        this.focus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHadStickyUserActivationBeforeNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
        null,
        this.setHadStickyUserActivationBeforeNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bubbleLogicalScroll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
        null,
        this.bubbleLogicalScroll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserActivationState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
        null,
        this.updateUserActivationState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEmbeddingToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
        null,
        this.setEmbeddingToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.RemoteFrame_SetPageFocus_ParamsSpec.$,
        null,
        this.setPageFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renderFallbackContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.RemoteFrame_RenderFallbackContent_ParamsSpec.$,
        null,
        this.renderFallbackContent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addResourceTimingFromChild =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
        null,
        this.addResourceTimingFromChild.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollRectToVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
        null,
        this.scrollRectToVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.RemoteFrame_DidStartLoading_ParamsSpec.$,
        null,
        this.didStartLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.RemoteFrame_DidStopLoading_ParamsSpec.$,
        null,
        this.didStopLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.intrinsicSizingInfoOfChildChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
        null,
        this.intrinsicSizingInfoOfChildChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didSetFramePolicyHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
        null,
        this.didSetFramePolicyHeaders.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didUpdateFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
        null,
        this.didUpdateFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateOpener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        blink.mojom.RemoteFrame_UpdateOpener_ParamsSpec.$,
        null,
        this.updateOpener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detachAndDispose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        blink.mojom.RemoteFrame_DetachAndDispose_ParamsSpec.$,
        null,
        this.detachAndDispose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        blink.mojom.RemoteFrame_EnableAutoResize_ParamsSpec.$,
        null,
        this.enableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        blink.mojom.RemoteFrame_DisableAutoResize_ParamsSpec.$,
        null,
        this.disableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didUpdateVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        blink.mojom.RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
        null,
        this.didUpdateVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        blink.mojom.RemoteFrame_SetFrameSinkId_ParamsSpec.$,
        null,
        this.setFrameSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.childProcessGone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        blink.mojom.RemoteFrame_ChildProcessGone_ParamsSpec.$,
        null,
        this.childProcessGone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteChild =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        blink.mojom.RemoteFrame_CreateRemoteChild_ParamsSpec.$,
        null,
        this.createRemoteChild.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteChildren =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        blink.mojom.RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
        null,
        this.createRemoteChildren.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forwardFencedFrameEventToEmbedder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
        null,
        this.forwardFencedFrameEventToEmbedder.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RemoteMainFramePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RemoteMainFrame.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RemoteMainFrameInterface }
 */
blink.mojom.RemoteMainFrameRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RemoteMainFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RemoteMainFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RemoteMainFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.TextAutosizerPageInfo } pageInfo
   */

  updateTextAutosizerPageInfo(
      pageInfo) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        [
          pageInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteMainFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RemoteMainFrameReceiver = class {
  /**
   * @param {!blink.mojom.RemoteMainFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RemoteMainFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RemoteMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        impl.updateTextAutosizerPageInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RemoteMainFrame = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteMainFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RemoteMainFrameRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RemoteMainFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteMainFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RemoteMainFrameCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RemoteMainFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteMainFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTextAutosizerPageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
        null,
        this.updateTextAutosizerPageInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RemoteMainFrameHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RemoteMainFrameHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.RemoteMainFrameHostInterface }
 */
blink.mojom.RemoteMainFrameHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RemoteMainFrameHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RemoteMainFrameHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RemoteMainFrameHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  focusPage() {
    this.proxy.sendMessage(
        0,
        blink.mojom.RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } reverse
   */

  takeFocus(
      reverse) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        [
          reverse
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise}
   */

  updateTargetURL(
      url) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   */

  routeCloseEvent() {
    this.proxy.sendMessage(
        3,
        blink.mojom.RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteMainFrameHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RemoteMainFrameHostReceiver = class {
  /**
   * @param {!blink.mojom.RemoteMainFrameHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RemoteMainFrameHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RemoteMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        impl.focusPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        impl.takeFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        impl.updateTargetURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        impl.routeCloseEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RemoteMainFrameHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RemoteMainFrameHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RemoteMainFrameHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RemoteMainFrameHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteMainFrameHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RemoteMainFrameHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RemoteMainFrameHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RemoteMainFrameHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RemoteMainFrameHost_FocusPage_ParamsSpec.$,
        null,
        this.focusPage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.takeFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
        null,
        this.takeFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTargetURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
        blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
        this.updateTargetURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.routeCloseEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
        null,
        this.routeCloseEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameInterfacesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameInterfacesFromRendererSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameInterfacesFromBrowserSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CreateRemoteChildParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OpenURLParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_VisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_DidFocusFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_CheckCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_SetIsInert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_DidChangeOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_AdvanceFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_RouteMessageEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_Detach_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_UpdateViewportIntersection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrameHost_OpenURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_WillEnterFullscreen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetFrameOwnerProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetReplicatedOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetReplicatedName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_Collapse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_Focus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_BubbleLogicalScroll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_UpdateUserActivationState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetEmbeddingToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetPageFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_RenderFallbackContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_AddResourceTimingFromChild_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_ScrollRectToVisible_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DidStartLoading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DidStopLoading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DidUpdateFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_UpdateOpener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DetachAndDispose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_EnableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DisableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_DidUpdateVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_SetFrameSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_ChildProcessGone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_CreateRemoteChild_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_CreateRemoteChildren_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameHost_FocusPage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameHost_TakeFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RemoteMainFrameHost_RouteCloseEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.RemoteMainFrameInterfacesSpec.$,
    'RemoteMainFrameInterfaces',
    [
      mojo.internal.StructField(
        'mainFrameHost', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.RemoteMainFrameHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainFrame', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.RemoteMainFramePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteMainFrameInterfaces = class {
  constructor() {
    /** @export { !Object } */
    this.mainFrameHost;
    /** @export { !Object } */
    this.mainFrame;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameInterfacesFromRendererSpec.$,
    'RemoteFrameInterfacesFromRenderer',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.RemoteFrameRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameHostReceiver', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.RemoteFrameHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameInterfacesFromRenderer = class {
  constructor() {
    /** @export { !Object } */
    this.frame;
    /** @export { !Object } */
    this.frameHostReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameInterfacesFromBrowserSpec.$,
    'RemoteFrameInterfacesFromBrowser',
    [
      mojo.internal.StructField(
        'frameReceiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.RemoteFramePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameHost', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.RemoteFrameHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameInterfacesFromBrowser = class {
  constructor() {
    /** @export { !Object } */
    this.frameReceiver;
    /** @export { !Object } */
    this.frameHost;
  }
};



mojo.internal.Struct(
    blink.mojom.CreateRemoteChildParamsSpec.$,
    'CreateRemoteChildParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'treeScopeType', 24,
        0,
        blink.mojom.TreeScopeTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replicationState', 32,
        0,
        blink.mojom.FrameReplicationStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ownerProperties', 40,
        0,
        blink.mojom.FrameOwnerPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isLoading', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 48,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameInterfaces', 56,
        0,
        blink.mojom.RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'childParams', 64,
        0,
        mojo.internal.Array(blink.mojom.CreateRemoteChildParamsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
blink.mojom.CreateRemoteChildParams = class {
  constructor() {
    /** @export { !blink.mojom.RemoteFrameToken } */
    this.token;
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.openerFrameToken;
    /** @export { !blink.mojom.TreeScopeType } */
    this.treeScopeType;
    /** @export { !blink.mojom.FrameReplicationState } */
    this.replicationState;
    /** @export { !blink.mojom.FrameOwnerProperties } */
    this.ownerProperties;
    /** @export { !boolean } */
    this.isLoading;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsFrameToken;
    /** @export { !blink.mojom.RemoteFrameInterfacesFromBrowser } */
    this.frameInterfaces;
    /** @export { !Array<!blink.mojom.CreateRemoteChildParams> } */
    this.childParams;
  }
};



mojo.internal.Struct(
    blink.mojom.OpenURLParamsSpec.$,
    'OpenURLParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorBaseUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 24,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorFrameToken', 32,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'postBody', 40,
        0,
        network.mojom.URLRequestBodySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraHeaders', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 56,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFormSubmission', 64,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 68,
        0,
        ui.mojom.WindowOpenDispositionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldReplaceCurrentEntry', 64,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 64,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isUnfencedTopNavigation', 64,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'triggeringEventInfo', 72,
        0,
        blink.mojom.TriggeringEventInfoSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 76,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobURLTokenRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hrefTranslate', 88,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'impression', 96,
        0,
        blink.mojom.ImpressionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadPolicy', 104,
        0,
        blink.mojom.NavigationDownloadPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLocation', 112,
        0,
        network.mojom.SourceLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorNavigationStateKeepAliveHandle', 120,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.NavigationStateKeepAliveHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorActivationAndAdStatus', 84,
        0,
        blink.mojom.NavigationInitiatorActivationAndAdStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isContainerInitiated', 64,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasRelOpener', 64,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 128,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        network.mojom.StorageAccessApiStatus.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 144],]);





/** @record */
blink.mojom.OpenURLParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !url.mojom.Origin } */
    this.initiatorOrigin;
    /** @export { (url.mojom.Url|undefined) } */
    this.initiatorBaseUrl;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.actualNavigationStart;
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.initiatorFrameToken;
    /** @export { (network.mojom.URLRequestBody|undefined) } */
    this.postBody;
    /** @export { !string } */
    this.extraHeaders;
    /** @export { !blink.mojom.Referrer } */
    this.referrer;
    /** @export { !boolean } */
    this.isFormSubmission;
    /** @export { !ui.mojom.WindowOpenDisposition } */
    this.disposition;
    /** @export { !boolean } */
    this.shouldReplaceCurrentEntry;
    /** @export { !boolean } */
    this.userGesture;
    /** @export { !boolean } */
    this.isUnfencedTopNavigation;
    /** @export { !blink.mojom.TriggeringEventInfo } */
    this.triggeringEventInfo;
    /** @export { (blink.mojom.BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
    /** @export { !string } */
    this.hrefTranslate;
    /** @export { (blink.mojom.Impression|undefined) } */
    this.impression;
    /** @export { !blink.mojom.NavigationDownloadPolicy } */
    this.downloadPolicy;
    /** @export { !network.mojom.SourceLocation } */
    this.sourceLocation;
    /** @export { (blink.mojom.NavigationStateKeepAliveHandleRemote|undefined) } */
    this.initiatorNavigationStateKeepAliveHandle;
    /** @export { !blink.mojom.NavigationInitiatorActivationAndAdStatus } */
    this.initiatorActivationAndAdStatus;
    /** @export { !boolean } */
    this.isContainerInitiated;
    /** @export { !boolean } */
    this.hasRelOpener;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsSpec.$,
    'RemoteFrameHost_SetInheritedEffectiveTouchAction_Params',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc.mojom.TouchActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_SetInheritedEffectiveTouchAction_Params = class {
  constructor() {
    /** @export { !cc.mojom.TouchAction } */
    this.touchAction;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsSpec.$,
    'RemoteFrameHost_UpdateRenderThrottlingStatus_Params',
    [
      mojo.internal.StructField(
        'isThrottled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subtreeThrottled', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayLocked', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_UpdateRenderThrottlingStatus_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isThrottled;
    /** @export { !boolean } */
    this.subtreeThrottled;
    /** @export { !boolean } */
    this.displayLocked;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_VisibilityChanged_ParamsSpec.$,
    'RemoteFrameHost_VisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visibility', 0,
        0,
        blink.mojom.FrameVisibilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_VisibilityChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameVisibility } */
    this.visibility;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_DidFocusFrame_ParamsSpec.$,
    'RemoteFrameHost_DidFocusFrame_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrameHost_DidFocusFrame_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_CheckCompleted_ParamsSpec.$,
    'RemoteFrameHost_CheckCompleted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrameHost_CheckCompleted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsSpec.$,
    'RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params',
    [
      mojo.internal.StructField(
        'clipRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'guid', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.clipRect;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.guid;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_SetIsInert_ParamsSpec.$,
    'RemoteFrameHost_SetIsInert_Params',
    [
      mojo.internal.StructField(
        'inert', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_SetIsInert_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.inert;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_DidChangeOpener_ParamsSpec.$,
    'RemoteFrameHost_DidChangeOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrame', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_DidChangeOpener_Params = class {
  constructor() {
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.openerFrame;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_AdvanceFocus_ParamsSpec.$,
    'RemoteFrameHost_AdvanceFocus_Params',
    [
      mojo.internal.StructField(
        'focusType', 0,
        0,
        blink.mojom.FocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFrameToken', 8,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameHost_AdvanceFocus_Params = class {
  constructor() {
    /** @export { !blink.mojom.FocusType } */
    this.focusType;
    /** @export { !blink.mojom.LocalFrameToken } */
    this.sourceFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_RouteMessageEvent_ParamsSpec.$,
    'RemoteFrameHost_RouteMessageEvent_Params',
    [
      mojo.internal.StructField(
        'sourceFrameToken', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 24,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.RemoteFrameHost_RouteMessageEvent_Params = class {
  constructor() {
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.sourceFrameToken;
    /** @export { !url.mojom.Origin } */
    this.sourceOrigin;
    /** @export { (url.mojom.Origin|undefined) } */
    this.targetOrigin;
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_ParamsSpec.$,
    'RemoteFrameHost_PrintCrossProcessSubframe_Params',
    [
      mojo.internal.StructField(
        'frameContentRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentCookie', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameHost_PrintCrossProcessSubframe_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.frameContentRect;
    /** @export { !number } */
    this.documentCookie;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_Detach_ParamsSpec.$,
    'RemoteFrameHost_Detach_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrameHost_Detach_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_UpdateViewportIntersection_ParamsSpec.$,
    'RemoteFrameHost_UpdateViewportIntersection_Params',
    [
      mojo.internal.StructField(
        'intersectionState', 0,
        0,
        blink.mojom.ViewportIntersectionStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visualProperties', 8,
        0,
        blink.mojom.FrameVisualPropertiesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrameHost_UpdateViewportIntersection_Params = class {
  constructor() {
    /** @export { !blink.mojom.ViewportIntersectionState } */
    this.intersectionState;
    /** @export { (blink.mojom.FrameVisualProperties|undefined) } */
    this.visualProperties;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_ParamsSpec.$,
    'RemoteFrameHost_SynchronizeVisualProperties_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        blink.mojom.FrameVisualPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_SynchronizeVisualProperties_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameVisualProperties } */
    this.properties;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrameHost_OpenURL_ParamsSpec.$,
    'RemoteFrameHost_OpenURL_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.OpenURLParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrameHost_OpenURL_Params = class {
  constructor() {
    /** @export { !blink.mojom.OpenURLParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_WillEnterFullscreen_ParamsSpec.$,
    'RemoteFrame_WillEnterFullscreen_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.FullscreenOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_WillEnterFullscreen_Params = class {
  constructor() {
    /** @export { !blink.mojom.FullscreenOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_ParamsSpec.$,
    'RemoteFrame_EnforceInsecureNavigationsSet_Params',
    [
      mojo.internal.StructField(
        'set', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_EnforceInsecureNavigationsSet_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.set;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetFrameOwnerProperties_ParamsSpec.$,
    'RemoteFrame_SetFrameOwnerProperties_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        blink.mojom.FrameOwnerPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetFrameOwnerProperties_Params = class {
  constructor() {
    /** @export { !blink.mojom.FrameOwnerProperties } */
    this.properties;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_ParamsSpec.$,
    'RemoteFrame_EnforceInsecureRequestPolicy_Params',
    [
      mojo.internal.StructField(
        'policy', 0,
        0,
        blink.mojom.InsecureRequestPolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_EnforceInsecureRequestPolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.InsecureRequestPolicy } */
    this.policy;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetReplicatedOrigin_ParamsSpec.$,
    'RemoteFrame_SetReplicatedOrigin_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPotentiallyTrustworthyUniqueOrigin', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_SetReplicatedOrigin_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !boolean } */
    this.isPotentiallyTrustworthyUniqueOrigin;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_ParamsSpec.$,
    'RemoteFrame_SetReplicatedIsAdFrame_Params',
    [
      mojo.internal.StructField(
        'isAdFrame', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetReplicatedIsAdFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isAdFrame;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetReplicatedName_ParamsSpec.$,
    'RemoteFrame_SetReplicatedName_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uniqueName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_SetReplicatedName_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.uniqueName;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_ParamsSpec.$,
    'RemoteFrame_DispatchLoadEventForFrameOwner_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_DispatchLoadEventForFrameOwner_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_ParamsSpec.$,
    'RemoteFrame_SetNeedsOcclusionTracking_Params',
    [
      mojo.internal.StructField(
        'needsTracking', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetNeedsOcclusionTracking_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.needsTracking;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_Collapse_ParamsSpec.$,
    'RemoteFrame_Collapse_Params',
    [
      mojo.internal.StructField(
        'collapsed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_Collapse_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.collapsed;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_Focus_ParamsSpec.$,
    'RemoteFrame_Focus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_Focus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsSpec.$,
    'RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params',
    [
      mojo.internal.StructField(
        'hasGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.hasGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_BubbleLogicalScroll_ParamsSpec.$,
    'RemoteFrame_BubbleLogicalScroll_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        blink.mojom.ScrollDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'granularity', 4,
        0,
        ui.mojom.ScrollGranularitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_BubbleLogicalScroll_Params = class {
  constructor() {
    /** @export { !blink.mojom.ScrollDirection } */
    this.direction;
    /** @export { !ui.mojom.ScrollGranularity } */
    this.granularity;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_UpdateUserActivationState_ParamsSpec.$,
    'RemoteFrame_UpdateUserActivationState_Params',
    [
      mojo.internal.StructField(
        'stateUpdateType', 0,
        0,
        blink.mojom.UserActivationUpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationType', 4,
        0,
        blink.mojom.UserActivationNotificationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_UpdateUserActivationState_Params = class {
  constructor() {
    /** @export { !blink.mojom.UserActivationUpdateType } */
    this.stateUpdateType;
    /** @export { !blink.mojom.UserActivationNotificationType } */
    this.notificationType;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetEmbeddingToken_ParamsSpec.$,
    'RemoteFrame_SetEmbeddingToken_Params',
    [
      mojo.internal.StructField(
        'embeddingToken', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetEmbeddingToken_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.embeddingToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetPageFocus_ParamsSpec.$,
    'RemoteFrame_SetPageFocus_Params',
    [
      mojo.internal.StructField(
        'isFocused', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_SetPageFocus_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isFocused;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_RenderFallbackContent_ParamsSpec.$,
    'RemoteFrame_RenderFallbackContent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_RenderFallbackContent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_AddResourceTimingFromChild_ParamsSpec.$,
    'RemoteFrame_AddResourceTimingFromChild_Params',
    [
      mojo.internal.StructField(
        'timing', 0,
        0,
        blink.mojom.ResourceTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_AddResourceTimingFromChild_Params = class {
  constructor() {
    /** @export { !blink.mojom.ResourceTimingInfo } */
    this.timing;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_ScrollRectToVisible_ParamsSpec.$,
    'RemoteFrame_ScrollRectToVisible_Params',
    [
      mojo.internal.StructField(
        'rect', 0,
        0,
        gfx.mojom.RectFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        blink.mojom.ScrollIntoViewParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_ScrollRectToVisible_Params = class {
  constructor() {
    /** @export { !gfx.mojom.RectF } */
    this.rect;
    /** @export { !blink.mojom.ScrollIntoViewParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DidStartLoading_ParamsSpec.$,
    'RemoteFrame_DidStartLoading_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_DidStartLoading_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DidStopLoading_ParamsSpec.$,
    'RemoteFrame_DidStopLoading_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_DidStopLoading_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsSpec.$,
    'RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params',
    [
      mojo.internal.StructField(
        'sizingInfo', 0,
        0,
        blink.mojom.IntrinsicSizingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.IntrinsicSizingInfo } */
    this.sizingInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_ParamsSpec.$,
    'RemoteFrame_DidSetFramePolicyHeaders_Params',
    [
      mojo.internal.StructField(
        'sandboxFlags', 0,
        0,
        network.mojom.WebSandboxFlagsSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parsedPermissionsPolicy', 8,
        0,
        mojo.internal.Array(network.mojom.ParsedPermissionsPolicyDeclarationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_DidSetFramePolicyHeaders_Params = class {
  constructor() {
    /** @export { !network.mojom.WebSandboxFlags } */
    this.sandboxFlags;
    /** @export { !Array<!network.mojom.ParsedPermissionsPolicyDeclaration> } */
    this.parsedPermissionsPolicy;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DidUpdateFramePolicy_ParamsSpec.$,
    'RemoteFrame_DidUpdateFramePolicy_Params',
    [
      mojo.internal.StructField(
        'framePolicy', 0,
        0,
        blink.mojom.FramePolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_DidUpdateFramePolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.FramePolicy } */
    this.framePolicy;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_UpdateOpener_ParamsSpec.$,
    'RemoteFrame_UpdateOpener_Params',
    [
      mojo.internal.StructField(
        'openerFrameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_UpdateOpener_Params = class {
  constructor() {
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.openerFrameToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DetachAndDispose_ParamsSpec.$,
    'RemoteFrame_DetachAndDispose_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_DetachAndDispose_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_EnableAutoResize_ParamsSpec.$,
    'RemoteFrame_EnableAutoResize_Params',
    [
      mojo.internal.StructField(
        'minSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_EnableAutoResize_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.minSize;
    /** @export { !gfx.mojom.Size } */
    this.maxSize;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DisableAutoResize_ParamsSpec.$,
    'RemoteFrame_DisableAutoResize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_DisableAutoResize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_DidUpdateVisualProperties_ParamsSpec.$,
    'RemoteFrame_DidUpdateVisualProperties_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        cc.mojom.RenderFrameMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_DidUpdateVisualProperties_Params = class {
  constructor() {
    /** @export { !cc.mojom.RenderFrameMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_SetFrameSinkId_ParamsSpec.$,
    'RemoteFrame_SetFrameSinkId_Params',
    [
      mojo.internal.StructField(
        'frameSinkId', 0,
        0,
        viz.mojom.FrameSinkIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowPaintHolding', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_SetFrameSinkId_Params = class {
  constructor() {
    /** @export { !viz.mojom.FrameSinkId } */
    this.frameSinkId;
    /** @export { !boolean } */
    this.allowPaintHolding;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_ChildProcessGone_ParamsSpec.$,
    'RemoteFrame_ChildProcessGone_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteFrame_ChildProcessGone_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_CreateRemoteChild_ParamsSpec.$,
    'RemoteFrame_CreateRemoteChild_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'treeScopeType', 24,
        0,
        blink.mojom.TreeScopeTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replicationState', 32,
        0,
        blink.mojom.FrameReplicationStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ownerProperties', 40,
        0,
        blink.mojom.FrameOwnerPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isLoading', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 48,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteFrameInterfaces', 56,
        0,
        blink.mojom.RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
blink.mojom.RemoteFrame_CreateRemoteChild_Params = class {
  constructor() {
    /** @export { !blink.mojom.RemoteFrameToken } */
    this.token;
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.openerFrameToken;
    /** @export { !blink.mojom.TreeScopeType } */
    this.treeScopeType;
    /** @export { !blink.mojom.FrameReplicationState } */
    this.replicationState;
    /** @export { !blink.mojom.FrameOwnerProperties } */
    this.ownerProperties;
    /** @export { !boolean } */
    this.isLoading;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsFrameToken;
    /** @export { !blink.mojom.RemoteFrameInterfacesFromBrowser } */
    this.remoteFrameInterfaces;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_CreateRemoteChildren_ParamsSpec.$,
    'RemoteFrame_CreateRemoteChildren_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        mojo.internal.Array(blink.mojom.CreateRemoteChildParamsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.RemoteFrame_CreateRemoteChildren_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.CreateRemoteChildParams> } */
    this.params;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.navigationMetricsToken;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsSpec.$,
    'RemoteFrame_ForwardFencedFrameEventToEmbedder_Params',
    [
      mojo.internal.StructField(
        'eventType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteFrame_ForwardFencedFrameEventToEmbedder_Params = class {
  constructor() {
    /** @export { !string } */
    this.eventType;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsSpec.$,
    'RemoteMainFrame_UpdateTextAutosizerPageInfo_Params',
    [
      mojo.internal.StructField(
        'pageInfo', 0,
        0,
        blink.mojom.TextAutosizerPageInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteMainFrame_UpdateTextAutosizerPageInfo_Params = class {
  constructor() {
    /** @export { !blink.mojom.TextAutosizerPageInfo } */
    this.pageInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrameHost_FocusPage_ParamsSpec.$,
    'RemoteMainFrameHost_FocusPage_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteMainFrameHost_FocusPage_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrameHost_TakeFocus_ParamsSpec.$,
    'RemoteMainFrameHost_TakeFocus_Params',
    [
      mojo.internal.StructField(
        'reverse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteMainFrameHost_TakeFocus_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.reverse;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ParamsSpec.$,
    'RemoteMainFrameHost_UpdateTargetURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.RemoteMainFrameHost_UpdateTargetURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParamsSpec.$,
    'RemoteMainFrameHost_UpdateTargetURL_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteMainFrameHost_UpdateTargetURL_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.RemoteMainFrameHost_RouteCloseEvent_ParamsSpec.$,
    'RemoteMainFrameHost_RouteCloseEvent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.RemoteMainFrameHost_RouteCloseEvent_Params = class {
  constructor() {
  }
};

