// third_party/blink/public/mojom/indexeddb/indexeddb.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/indexeddb/indexeddb.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string161$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var string161$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', '../blob/blob.mojom.js');
  }
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', '../file_system_access/file_system_access_transfer_token.mojom.js');
  }


  var IDB_MAX_MESSAGE_SIZE = 134217728;
  var IDB_MAX_MESSAGE_OVERHEAD = 1048576;
  var IDB_WRAP_THRESHOLD = 65536;
  var IDB_GET_ALL_CHUNK_SIZE = 1000;
  var IDBCursorDirection = {};
  IDBCursorDirection.Next = 0;
  IDBCursorDirection.NextNoDuplicate = 1;
  IDBCursorDirection.Prev = 2;
  IDBCursorDirection.PrevNoDuplicate = 3;
  IDBCursorDirection.MIN_VALUE = 0;
  IDBCursorDirection.MAX_VALUE = 3;

  IDBCursorDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  IDBCursorDirection.toKnownEnumValue = function(value) {
    return value;
  };

  IDBCursorDirection.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBDataLoss = {};
  IDBDataLoss.None = 0;
  IDBDataLoss.Total = 1;
  IDBDataLoss.MIN_VALUE = 0;
  IDBDataLoss.MAX_VALUE = 1;

  IDBDataLoss.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  IDBDataLoss.toKnownEnumValue = function(value) {
    return value;
  };

  IDBDataLoss.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBKeyType = {};
  IDBKeyType.Invalid = 0;
  IDBKeyType.Array = 1;
  IDBKeyType.Binary = 2;
  IDBKeyType.String = 3;
  IDBKeyType.Date = 4;
  IDBKeyType.Number = 5;
  IDBKeyType.None = 6;
  IDBKeyType.Min = 7;
  IDBKeyType.MIN_VALUE = 0;
  IDBKeyType.MAX_VALUE = 7;

  IDBKeyType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  IDBKeyType.toKnownEnumValue = function(value) {
    return value;
  };

  IDBKeyType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBTransactionDurability = {};
  IDBTransactionDurability.Default = 0;
  IDBTransactionDurability.Strict = 1;
  IDBTransactionDurability.Relaxed = 2;
  IDBTransactionDurability.MIN_VALUE = 0;
  IDBTransactionDurability.MAX_VALUE = 2;

  IDBTransactionDurability.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IDBTransactionDurability.toKnownEnumValue = function(value) {
    return value;
  };

  IDBTransactionDurability.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBGetAllResultType = {};
  IDBGetAllResultType.Keys = 0;
  IDBGetAllResultType.Values = 1;
  IDBGetAllResultType.Records = 2;
  IDBGetAllResultType.MIN_VALUE = 0;
  IDBGetAllResultType.MAX_VALUE = 2;

  IDBGetAllResultType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IDBGetAllResultType.toKnownEnumValue = function(value) {
    return value;
  };

  IDBGetAllResultType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBKeyPathType = {};
  IDBKeyPathType.Null = 0;
  IDBKeyPathType.String = 1;
  IDBKeyPathType.Array = 2;
  IDBKeyPathType.MIN_VALUE = 0;
  IDBKeyPathType.MAX_VALUE = 2;

  IDBKeyPathType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IDBKeyPathType.toKnownEnumValue = function(value) {
    return value;
  };

  IDBKeyPathType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBOperationType = {};
  IDBOperationType.Add = 0;
  IDBOperationType.Put = 1;
  IDBOperationType.Delete = 2;
  IDBOperationType.Clear = 3;
  IDBOperationType.MIN_VALUE = 0;
  IDBOperationType.MAX_VALUE = 3;

  IDBOperationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  IDBOperationType.toKnownEnumValue = function(value) {
    return value;
  };

  IDBOperationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBPutMode = {};
  IDBPutMode.AddOrUpdate = 0;
  IDBPutMode.AddOnly = 1;
  IDBPutMode.CursorUpdate = 2;
  IDBPutMode.MIN_VALUE = 0;
  IDBPutMode.MAX_VALUE = 2;

  IDBPutMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IDBPutMode.toKnownEnumValue = function(value) {
    return value;
  };

  IDBPutMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBTaskType = {};
  IDBTaskType.Normal = 0;
  IDBTaskType.Preemptive = 1;
  IDBTaskType.MIN_VALUE = 0;
  IDBTaskType.MAX_VALUE = 1;

  IDBTaskType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  IDBTaskType.toKnownEnumValue = function(value) {
    return value;
  };

  IDBTaskType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBTransactionMode = {};
  IDBTransactionMode.ReadOnly = 0;
  IDBTransactionMode.ReadWrite = 1;
  IDBTransactionMode.VersionChange = 2;
  IDBTransactionMode.MIN_VALUE = 0;
  IDBTransactionMode.MAX_VALUE = 2;

  IDBTransactionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IDBTransactionMode.toKnownEnumValue = function(value) {
    return value;
  };

  IDBTransactionMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IDBException = {};
  IDBException.kNoError = 0;
  IDBException.kUnknownError = 28;
  IDBException.kConstraintError = 29;
  IDBException.kDataError = 30;
  IDBException.kVersionError = 33;
  IDBException.kAbortError = 20;
  IDBException.kIgnorableAbortError = 11;
  IDBException.kQuotaError = 22;
  IDBException.kTimeoutError = 23;
  IDBException.MIN_VALUE = 0;
  IDBException.MAX_VALUE = 33;

  IDBException.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 11:
    case 20:
    case 22:
    case 23:
    case 28:
    case 29:
    case 30:
    case 33:
      return true;
    }
    return false;
  };

  IDBException.toKnownEnumValue = function(value) {
    return value;
  };

  IDBException.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function IDBKeyPath(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBKeyPath.prototype.initDefaults_ = function() {
    this.data = null;
  };
  IDBKeyPath.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBKeyPath.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBKeyPath.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBKeyPathData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBKeyPath.encodedSize = codec.kStructHeaderSize + 16;

  IDBKeyPath.decode = function(decoder) {
    var packed;
    var val = new IDBKeyPath();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(IDBKeyPathData);
    return val;
  };

  IDBKeyPath.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBKeyPath.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBKeyPathData, val.data);
  };
  function IDBKeyRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBKeyRange.prototype.initDefaults_ = function() {
    this.lower = null;
    this.upper = null;
    this.lowerOpen = false;
    this.upperOpen = false;
  };
  IDBKeyRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBKeyRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBKeyRange.lower
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBKeyRange.upper
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBKeyRange.encodedSize = codec.kStructHeaderSize + 40;

  IDBKeyRange.decode = function(decoder) {
    var packed;
    var val = new IDBKeyRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lower =
        decoder.decodeStruct(IDBKey);
    val.upper =
        decoder.decodeStruct(IDBKey);
    packed = decoder.readUint8();
    val.lowerOpen = (packed >> 0) & 1 ? true : false;
    val.upperOpen = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBKeyRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBKeyRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBKey, val.lower);
    encoder.encodeStruct(IDBKey, val.upper);
    packed = 0;
    packed |= (val.lowerOpen & 1) << 0
    packed |= (val.upperOpen & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBIndexMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBIndexMetadata.prototype.initDefaults_ = function() {
    this.id = 0;
    this.name = null;
    this.keyPath = null;
    this.unique = false;
    this.multiEntry = false;
  };
  IDBIndexMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBIndexMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBIndexMetadata.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBIndexMetadata.keyPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBKeyPath, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBIndexMetadata.encodedSize = codec.kStructHeaderSize + 32;

  IDBIndexMetadata.decode = function(decoder) {
    var packed;
    var val = new IDBIndexMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int64);
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.keyPath =
        decoder.decodeStructPointer(IDBKeyPath);
    packed = decoder.readUint8();
    val.unique = (packed >> 0) & 1 ? true : false;
    val.multiEntry = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBIndexMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBIndexMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.id);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStructPointer(IDBKeyPath, val.keyPath);
    packed = 0;
    packed |= (val.unique & 1) << 0
    packed |= (val.multiEntry & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBObjectStoreMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBObjectStoreMetadata.prototype.initDefaults_ = function() {
    this.id = 0;
    this.name = null;
    this.keyPath = null;
    this.autoIncrement = false;
    this.maxIndexId = 0;
    this.indexes = null;
  };
  IDBObjectStoreMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBObjectStoreMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBObjectStoreMetadata.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBObjectStoreMetadata.keyPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBKeyPath, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate IDBObjectStoreMetadata.indexes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, codec.Int64, new codec.PointerTo(IDBIndexMetadata), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBObjectStoreMetadata.encodedSize = codec.kStructHeaderSize + 48;

  IDBObjectStoreMetadata.decode = function(decoder) {
    var packed;
    var val = new IDBObjectStoreMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int64);
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.keyPath =
        decoder.decodeStructPointer(IDBKeyPath);
    packed = decoder.readUint8();
    val.autoIncrement = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.maxIndexId =
        decoder.decodeStruct(codec.Int64);
    val.indexes =
        decoder.decodeMapPointer(codec.Int64, new codec.PointerTo(IDBIndexMetadata));
    return val;
  };

  IDBObjectStoreMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBObjectStoreMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.id);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStructPointer(IDBKeyPath, val.keyPath);
    packed = 0;
    packed |= (val.autoIncrement & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.maxIndexId);
    encoder.encodeMapPointer(codec.Int64, new codec.PointerTo(IDBIndexMetadata), val.indexes);
  };
  function IDBDatabaseMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseMetadata.prototype.initDefaults_ = function() {
    this.name = null;
    this.version = 0;
    this.maxObjectStoreId = 0;
    this.objectStores = null;
    this.wasColdOpen = false;
  };
  IDBDatabaseMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseMetadata.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate IDBDatabaseMetadata.objectStores
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, codec.Int64, new codec.PointerTo(IDBObjectStoreMetadata), false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabaseMetadata.encodedSize = codec.kStructHeaderSize + 40;

  IDBDatabaseMetadata.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.version =
        decoder.decodeStruct(codec.Int64);
    val.maxObjectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.objectStores =
        decoder.decodeMapPointer(codec.Int64, new codec.PointerTo(IDBObjectStoreMetadata));
    packed = decoder.readUint8();
    val.wasColdOpen = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabaseMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStruct(codec.Int64, val.version);
    encoder.encodeStruct(codec.Int64, val.maxObjectStoreId);
    encoder.encodeMapPointer(codec.Int64, new codec.PointerTo(IDBObjectStoreMetadata), val.objectStores);
    packed = 0;
    packed |= (val.wasColdOpen & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBNameAndVersion(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBNameAndVersion.prototype.initDefaults_ = function() {
    this.name = null;
    this.version = 0;
  };
  IDBNameAndVersion.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBNameAndVersion.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBNameAndVersion.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBNameAndVersion.encodedSize = codec.kStructHeaderSize + 16;

  IDBNameAndVersion.decode = function(decoder) {
    var packed;
    var val = new IDBNameAndVersion();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.version =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBNameAndVersion.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBNameAndVersion.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStruct(codec.Int64, val.version);
  };
  function IDBIndexKeys(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBIndexKeys.prototype.initDefaults_ = function() {
    this.indexId = 0;
    this.indexKeys = null;
  };
  IDBIndexKeys.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBIndexKeys.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBIndexKeys.indexKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, IDBKey, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBIndexKeys.encodedSize = codec.kStructHeaderSize + 16;

  IDBIndexKeys.decode = function(decoder) {
    var packed;
    var val = new IDBIndexKeys();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.indexKeys =
        decoder.decodeArrayPointer(IDBKey);
    return val;
  };

  IDBIndexKeys.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBIndexKeys.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeArrayPointer(IDBKey, val.indexKeys);
  };
  function IDBFileInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFileInfo.prototype.initDefaults_ = function() {
    this.name = null;
    this.lastModified = null;
  };
  IDBFileInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFileInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFileInfo.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFileInfo.lastModified
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFileInfo.encodedSize = codec.kStructHeaderSize + 16;

  IDBFileInfo.decode = function(decoder) {
    var packed;
    var val = new IDBFileInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.lastModified =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  IDBFileInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFileInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStructPointer(time$.Time, val.lastModified);
  };
  function IDBBlobInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBBlobInfo.prototype.initDefaults_ = function() {
    this.blob = new blob$.BlobPtr();
    this.mimeType = null;
    this.size = 0;
    this.file = null;
  };
  IDBBlobInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBBlobInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBBlobInfo.blob
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBBlobInfo.mimeType
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBBlobInfo.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBFileInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBBlobInfo.encodedSize = codec.kStructHeaderSize + 32;

  IDBBlobInfo.decode = function(decoder) {
    var packed;
    var val = new IDBBlobInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStruct(new codec.Interface(blob$.BlobPtr));
    val.mimeType =
        decoder.decodeStructPointer(string161$.String16);
    val.size =
        decoder.decodeStruct(codec.Int64);
    val.file =
        decoder.decodeStructPointer(IDBFileInfo);
    return val;
  };

  IDBBlobInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBBlobInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(blob$.BlobPtr), val.blob);
    encoder.encodeStructPointer(string161$.String16, val.mimeType);
    encoder.encodeStruct(codec.Int64, val.size);
    encoder.encodeStructPointer(IDBFileInfo, val.file);
  };
  function IDBValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBValue.prototype.initDefaults_ = function() {
    this.bits = null;
    this.externalObjects = null;
  };
  IDBValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBValue.bits
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBValue.externalObjects
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, IDBExternalObject, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBValue.encodedSize = codec.kStructHeaderSize + 16;

  IDBValue.decode = function(decoder) {
    var packed;
    var val = new IDBValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bits =
        decoder.decodeArrayPointer(codec.Uint8);
    val.externalObjects =
        decoder.decodeArrayPointer(IDBExternalObject);
    return val;
  };

  IDBValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.bits);
    encoder.encodeArrayPointer(IDBExternalObject, val.externalObjects);
  };
  function IDBReturnValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBReturnValue.prototype.initDefaults_ = function() {
    this.value = null;
    this.primaryKey = null;
    this.keyPath = null;
  };
  IDBReturnValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBReturnValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBReturnValue.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IDBValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBReturnValue.primaryKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBReturnValue.keyPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBKeyPath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBReturnValue.encodedSize = codec.kStructHeaderSize + 32;

  IDBReturnValue.decode = function(decoder) {
    var packed;
    var val = new IDBReturnValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(IDBValue);
    val.primaryKey =
        decoder.decodeStruct(IDBKey);
    val.keyPath =
        decoder.decodeStructPointer(IDBKeyPath);
    return val;
  };

  IDBReturnValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBReturnValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IDBValue, val.value);
    encoder.encodeStruct(IDBKey, val.primaryKey);
    encoder.encodeStructPointer(IDBKeyPath, val.keyPath);
  };
  function IDBRecord(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBRecord.prototype.initDefaults_ = function() {
    this.primaryKey = null;
    this.returnValue = null;
    this.indexKey = null;
  };
  IDBRecord.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBRecord.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBRecord.primaryKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBKey, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBRecord.returnValue
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBReturnValue, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBRecord.indexKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, IDBKey, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBRecord.encodedSize = codec.kStructHeaderSize + 40;

  IDBRecord.decode = function(decoder) {
    var packed;
    var val = new IDBRecord();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.primaryKey =
        decoder.decodeStruct(IDBKey);
    val.returnValue =
        decoder.decodeStructPointer(IDBReturnValue);
    val.indexKey =
        decoder.decodeStruct(IDBKey);
    return val;
  };

  IDBRecord.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBRecord.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBKey, val.primaryKey);
    encoder.encodeStructPointer(IDBReturnValue, val.returnValue);
    encoder.encodeStruct(IDBKey, val.indexKey);
  };
  function IDBError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBError.prototype.initDefaults_ = function() {
    this.errorCode = 0;
    this.errorMessage = null;
  };
  IDBError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBError.errorCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, IDBException);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBError.errorMessage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBError.encodedSize = codec.kStructHeaderSize + 16;

  IDBError.decode = function(decoder) {
    var packed;
    var val = new IDBError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(new codec.Enum(IDBException));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStructPointer(string161$.String16);
    return val;
  };

  IDBError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string161$.String16, val.errorMessage);
  };
  function IDBCursorValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursorValue.prototype.initDefaults_ = function() {
    this.keys = null;
    this.primaryKeys = null;
    this.values = null;
  };
  IDBCursorValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursorValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursorValue.keys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 16, IDBKey, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursorValue.primaryKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, IDBKey, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursorValue.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(IDBValue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBCursorValue.encodedSize = codec.kStructHeaderSize + 24;

  IDBCursorValue.decode = function(decoder) {
    var packed;
    var val = new IDBCursorValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keys =
        decoder.decodeArrayPointer(IDBKey);
    val.primaryKeys =
        decoder.decodeArrayPointer(IDBKey);
    val.values =
        decoder.decodeArrayPointer(new codec.PointerTo(IDBValue));
    return val;
  };

  IDBCursorValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursorValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(IDBKey, val.keys);
    encoder.encodeArrayPointer(IDBKey, val.primaryKeys);
    encoder.encodeArrayPointer(new codec.PointerTo(IDBValue), val.values);
  };
  function IDBDatabaseOpenCursorValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseOpenCursorValue.prototype.initDefaults_ = function() {
    this.cursor = new associatedBindings.AssociatedInterfacePtrInfo();
    this.key = null;
    this.primaryKey = null;
    this.value = null;
  };
  IDBDatabaseOpenCursorValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseOpenCursorValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseOpenCursorValue.cursor
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseOpenCursorValue.key
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseOpenCursorValue.primaryKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseOpenCursorValue.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, IDBValue, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabaseOpenCursorValue.encodedSize = codec.kStructHeaderSize + 48;

  IDBDatabaseOpenCursorValue.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseOpenCursorValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cursor =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.key =
        decoder.decodeStruct(IDBKey);
    val.primaryKey =
        decoder.decodeStruct(IDBKey);
    val.value =
        decoder.decodeStructPointer(IDBValue);
    return val;
  };

  IDBDatabaseOpenCursorValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseOpenCursorValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.cursor);
    encoder.encodeStruct(IDBKey, val.key);
    encoder.encodeStruct(IDBKey, val.primaryKey);
    encoder.encodeStructPointer(IDBValue, val.value);
  };
  function IDBFactoryClient_Error_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactoryClient_Error_Params.prototype.initDefaults_ = function() {
    this.code = 0;
    this.message = null;
  };
  IDBFactoryClient_Error_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactoryClient_Error_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_Error_Params.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, IDBException);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_Error_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFactoryClient_Error_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBFactoryClient_Error_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactoryClient_Error_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(IDBException));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStructPointer(string161$.String16);
    return val;
  };

  IDBFactoryClient_Error_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactoryClient_Error_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string161$.String16, val.message);
  };
  function IDBFactoryClient_Blocked_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactoryClient_Blocked_Params.prototype.initDefaults_ = function() {
    this.existingVersion = 0;
  };
  IDBFactoryClient_Blocked_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactoryClient_Blocked_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBFactoryClient_Blocked_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBFactoryClient_Blocked_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactoryClient_Blocked_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.existingVersion =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBFactoryClient_Blocked_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactoryClient_Blocked_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.existingVersion);
  };
  function IDBFactoryClient_UpgradeNeeded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactoryClient_UpgradeNeeded_Params.prototype.initDefaults_ = function() {
    this.pendingDatabase = new associatedBindings.AssociatedInterfacePtrInfo();
    this.oldVersion = 0;
    this.dataLoss = 0;
    this.dataLossMessage = null;
    this.dbMetadata = null;
  };
  IDBFactoryClient_UpgradeNeeded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactoryClient_UpgradeNeeded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_UpgradeNeeded_Params.pendingDatabase
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBFactoryClient_UpgradeNeeded_Params.dataLoss
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, IDBDataLoss);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_UpgradeNeeded_Params.dataLossMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_UpgradeNeeded_Params.dbMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, IDBDatabaseMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFactoryClient_UpgradeNeeded_Params.encodedSize = codec.kStructHeaderSize + 40;

  IDBFactoryClient_UpgradeNeeded_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactoryClient_UpgradeNeeded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pendingDatabase =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.oldVersion =
        decoder.decodeStruct(codec.Int64);
    val.dataLoss =
        decoder.decodeStruct(new codec.Enum(IDBDataLoss));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dataLossMessage =
        decoder.decodeStruct(codec.String);
    val.dbMetadata =
        decoder.decodeStructPointer(IDBDatabaseMetadata);
    return val;
  };

  IDBFactoryClient_UpgradeNeeded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactoryClient_UpgradeNeeded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.pendingDatabase);
    encoder.encodeStruct(codec.Int64, val.oldVersion);
    encoder.encodeStruct(codec.Int32, val.dataLoss);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.dataLossMessage);
    encoder.encodeStructPointer(IDBDatabaseMetadata, val.dbMetadata);
  };
  function IDBFactoryClient_OpenSuccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactoryClient_OpenSuccess_Params.prototype.initDefaults_ = function() {
    this.pendingDatabase = new associatedBindings.AssociatedInterfacePtrInfo();
    this.metadata = null;
  };
  IDBFactoryClient_OpenSuccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactoryClient_OpenSuccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_OpenSuccess_Params.pendingDatabase
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactoryClient_OpenSuccess_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, IDBDatabaseMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFactoryClient_OpenSuccess_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBFactoryClient_OpenSuccess_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactoryClient_OpenSuccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pendingDatabase =
        decoder.decodeStruct(codec.NullableAssociatedInterfacePtrInfo);
    val.metadata =
        decoder.decodeStructPointer(IDBDatabaseMetadata);
    return val;
  };

  IDBFactoryClient_OpenSuccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactoryClient_OpenSuccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.NullableAssociatedInterfacePtrInfo, val.pendingDatabase);
    encoder.encodeStructPointer(IDBDatabaseMetadata, val.metadata);
  };
  function IDBFactoryClient_DeleteSuccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactoryClient_DeleteSuccess_Params.prototype.initDefaults_ = function() {
    this.oldVersion = 0;
  };
  IDBFactoryClient_DeleteSuccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactoryClient_DeleteSuccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBFactoryClient_DeleteSuccess_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBFactoryClient_DeleteSuccess_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactoryClient_DeleteSuccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.oldVersion =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBFactoryClient_DeleteSuccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactoryClient_DeleteSuccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.oldVersion);
  };
  function IDBDatabaseCallbacks_ForcedClose_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseCallbacks_ForcedClose_Params.prototype.initDefaults_ = function() {
  };
  IDBDatabaseCallbacks_ForcedClose_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseCallbacks_ForcedClose_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabaseCallbacks_ForcedClose_Params.encodedSize = codec.kStructHeaderSize + 0;

  IDBDatabaseCallbacks_ForcedClose_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseCallbacks_ForcedClose_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  IDBDatabaseCallbacks_ForcedClose_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseCallbacks_ForcedClose_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function IDBDatabaseCallbacks_VersionChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseCallbacks_VersionChange_Params.prototype.initDefaults_ = function() {
    this.oldVersion = 0;
    this.newVersion = 0;
  };
  IDBDatabaseCallbacks_VersionChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseCallbacks_VersionChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBDatabaseCallbacks_VersionChange_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabaseCallbacks_VersionChange_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseCallbacks_VersionChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.oldVersion =
        decoder.decodeStruct(codec.Int64);
    val.newVersion =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabaseCallbacks_VersionChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseCallbacks_VersionChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.oldVersion);
    encoder.encodeStruct(codec.Int64, val.newVersion);
  };
  function IDBDatabaseCallbacks_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseCallbacks_Abort_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.code = 0;
    this.message = null;
  };
  IDBDatabaseCallbacks_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseCallbacks_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBDatabaseCallbacks_Abort_Params.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, IDBException);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseCallbacks_Abort_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabaseCallbacks_Abort_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBDatabaseCallbacks_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseCallbacks_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.code =
        decoder.decodeStruct(new codec.Enum(IDBException));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStructPointer(string161$.String16);
    return val;
  };

  IDBDatabaseCallbacks_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseCallbacks_Abort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string161$.String16, val.message);
  };
  function IDBDatabaseCallbacks_Complete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseCallbacks_Complete_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
  };
  IDBDatabaseCallbacks_Complete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseCallbacks_Complete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabaseCallbacks_Complete_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabaseCallbacks_Complete_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseCallbacks_Complete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabaseCallbacks_Complete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseCallbacks_Complete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
  };
  function IDBCursor_Advance_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Advance_Params.prototype.initDefaults_ = function() {
    this.count = 0;
  };
  IDBCursor_Advance_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Advance_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBCursor_Advance_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBCursor_Advance_Params.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Advance_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.count =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBCursor_Advance_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Advance_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.count);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBCursor_Advance_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Advance_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBCursor_Advance_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Advance_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursor_Advance_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBCursorResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBCursor_Advance_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBCursor_Advance_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Advance_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBCursorResult);
    return val;
  };

  IDBCursor_Advance_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Advance_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBCursorResult, val.result);
  };
  function IDBCursor_Continue_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Continue_Params.prototype.initDefaults_ = function() {
    this.key = null;
    this.primaryKey = null;
  };
  IDBCursor_Continue_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Continue_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursor_Continue_Params.key
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursor_Continue_Params.primaryKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBCursor_Continue_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBCursor_Continue_Params.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Continue_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(IDBKey);
    val.primaryKey =
        decoder.decodeStruct(IDBKey);
    return val;
  };

  IDBCursor_Continue_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Continue_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBKey, val.key);
    encoder.encodeStruct(IDBKey, val.primaryKey);
  };
  function IDBCursor_Continue_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Continue_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBCursor_Continue_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Continue_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursor_Continue_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBCursorResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBCursor_Continue_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBCursor_Continue_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Continue_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBCursorResult);
    return val;
  };

  IDBCursor_Continue_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Continue_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBCursorResult, val.result);
  };
  function IDBCursor_Prefetch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Prefetch_Params.prototype.initDefaults_ = function() {
    this.count = 0;
  };
  IDBCursor_Prefetch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Prefetch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBCursor_Prefetch_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBCursor_Prefetch_Params.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Prefetch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.count =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBCursor_Prefetch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Prefetch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.count);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBCursor_Prefetch_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_Prefetch_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBCursor_Prefetch_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_Prefetch_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBCursor_Prefetch_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBCursorResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBCursor_Prefetch_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBCursor_Prefetch_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_Prefetch_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBCursorResult);
    return val;
  };

  IDBCursor_Prefetch_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_Prefetch_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBCursorResult, val.result);
  };
  function IDBCursor_PrefetchReset_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBCursor_PrefetchReset_Params.prototype.initDefaults_ = function() {
    this.usedPrefetches = 0;
  };
  IDBCursor_PrefetchReset_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBCursor_PrefetchReset_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBCursor_PrefetchReset_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBCursor_PrefetchReset_Params.decode = function(decoder) {
    var packed;
    var val = new IDBCursor_PrefetchReset_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.usedPrefetches =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBCursor_PrefetchReset_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBCursor_PrefetchReset_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.usedPrefetches);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBTransaction_CreateObjectStore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_CreateObjectStore_Params.prototype.initDefaults_ = function() {
    this.objectStoreId = 0;
    this.name = null;
    this.keyPath = null;
    this.autoIncrement = false;
  };
  IDBTransaction_CreateObjectStore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_CreateObjectStore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBTransaction_CreateObjectStore_Params.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_CreateObjectStore_Params.keyPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBKeyPath, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBTransaction_CreateObjectStore_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBTransaction_CreateObjectStore_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_CreateObjectStore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.keyPath =
        decoder.decodeStructPointer(IDBKeyPath);
    packed = decoder.readUint8();
    val.autoIncrement = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBTransaction_CreateObjectStore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_CreateObjectStore_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStructPointer(IDBKeyPath, val.keyPath);
    packed = 0;
    packed |= (val.autoIncrement & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBTransaction_DeleteObjectStore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_DeleteObjectStore_Params.prototype.initDefaults_ = function() {
    this.objectStoreId = 0;
  };
  IDBTransaction_DeleteObjectStore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_DeleteObjectStore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBTransaction_DeleteObjectStore_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBTransaction_DeleteObjectStore_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_DeleteObjectStore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBTransaction_DeleteObjectStore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_DeleteObjectStore_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
  };
  function IDBTransaction_Put_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_Put_Params.prototype.initDefaults_ = function() {
    this.objectStoreId = 0;
    this.value = null;
    this.key = null;
    this.mode = 0;
    this.indexKeys = null;
  };
  IDBTransaction_Put_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_Put_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBTransaction_Put_Params.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, IDBValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_Put_Params.key
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_Put_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, IDBPutMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_Put_Params.indexKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(IDBIndexKeys), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBTransaction_Put_Params.encodedSize = codec.kStructHeaderSize + 48;

  IDBTransaction_Put_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_Put_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.value =
        decoder.decodeStructPointer(IDBValue);
    val.key =
        decoder.decodeStruct(IDBKey);
    val.mode =
        decoder.decodeStruct(new codec.Enum(IDBPutMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.indexKeys =
        decoder.decodeArrayPointer(new codec.PointerTo(IDBIndexKeys));
    return val;
  };

  IDBTransaction_Put_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_Put_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStructPointer(IDBValue, val.value);
    encoder.encodeStruct(IDBKey, val.key);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(IDBIndexKeys), val.indexKeys);
  };
  function IDBTransaction_Put_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_Put_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBTransaction_Put_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_Put_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_Put_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBTransactionPutResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBTransaction_Put_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBTransaction_Put_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_Put_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBTransactionPutResult);
    return val;
  };

  IDBTransaction_Put_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_Put_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBTransactionPutResult, val.result);
  };
  function IDBTransaction_SetIndexKeys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_SetIndexKeys_Params.prototype.initDefaults_ = function() {
    this.objectStoreId = 0;
    this.primaryKey = null;
    this.indexKeys = null;
  };
  IDBTransaction_SetIndexKeys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_SetIndexKeys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBTransaction_SetIndexKeys_Params.primaryKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBTransaction_SetIndexKeys_Params.indexKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBIndexKeys, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBTransaction_SetIndexKeys_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBTransaction_SetIndexKeys_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_SetIndexKeys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.primaryKey =
        decoder.decodeStruct(IDBKey);
    val.indexKeys =
        decoder.decodeStructPointer(IDBIndexKeys);
    return val;
  };

  IDBTransaction_SetIndexKeys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_SetIndexKeys_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(IDBKey, val.primaryKey);
    encoder.encodeStructPointer(IDBIndexKeys, val.indexKeys);
  };
  function IDBTransaction_SetIndexKeysDone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_SetIndexKeysDone_Params.prototype.initDefaults_ = function() {
  };
  IDBTransaction_SetIndexKeysDone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_SetIndexKeysDone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBTransaction_SetIndexKeysDone_Params.encodedSize = codec.kStructHeaderSize + 0;

  IDBTransaction_SetIndexKeysDone_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_SetIndexKeysDone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  IDBTransaction_SetIndexKeysDone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_SetIndexKeysDone_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function IDBTransaction_Commit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBTransaction_Commit_Params.prototype.initDefaults_ = function() {
    this.numErrorsHandled = 0;
  };
  IDBTransaction_Commit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBTransaction_Commit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBTransaction_Commit_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBTransaction_Commit_Params.decode = function(decoder) {
    var packed;
    var val = new IDBTransaction_Commit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numErrorsHandled =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBTransaction_Commit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBTransaction_Commit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.numErrorsHandled);
  };
  function IDBDatabaseGetAllResultSink_ReceiveResults_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseGetAllResultSink_ReceiveResults_Params.prototype.initDefaults_ = function() {
    this.records = null;
    this.done = false;
  };
  IDBDatabaseGetAllResultSink_ReceiveResults_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseGetAllResultSink_ReceiveResults_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseGetAllResultSink_ReceiveResults_Params.records
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(IDBRecord), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabaseGetAllResultSink_ReceiveResults_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabaseGetAllResultSink_ReceiveResults_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseGetAllResultSink_ReceiveResults_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.records =
        decoder.decodeArrayPointer(new codec.PointerTo(IDBRecord));
    packed = decoder.readUint8();
    val.done = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabaseGetAllResultSink_ReceiveResults_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseGetAllResultSink_ReceiveResults_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(IDBRecord), val.records);
    packed = 0;
    packed |= (val.done & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabaseGetAllResultSink_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabaseGetAllResultSink_OnError_Params.prototype.initDefaults_ = function() {
    this.error = null;
  };
  IDBDatabaseGetAllResultSink_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabaseGetAllResultSink_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabaseGetAllResultSink_OnError_Params.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabaseGetAllResultSink_OnError_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabaseGetAllResultSink_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabaseGetAllResultSink_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(IDBError);
    return val;
  };

  IDBDatabaseGetAllResultSink_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabaseGetAllResultSink_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(IDBError, val.error);
  };
  function IDBDatabase_RenameObjectStore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_RenameObjectStore_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.newName = null;
  };
  IDBDatabase_RenameObjectStore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_RenameObjectStore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate IDBDatabase_RenameObjectStore_Params.newName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_RenameObjectStore_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBDatabase_RenameObjectStore_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_RenameObjectStore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.newName =
        decoder.decodeStructPointer(string161$.String16);
    return val;
  };

  IDBDatabase_RenameObjectStore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_RenameObjectStore_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStructPointer(string161$.String16, val.newName);
  };
  function IDBDatabase_CreateTransaction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_CreateTransaction_Params.prototype.initDefaults_ = function() {
    this.transactionReceiver = new associatedBindings.AssociatedInterfaceRequest();
    this.mode = 0;
    this.transactionId = 0;
    this.objectStoreIds = null;
    this.durability = 0;
  };
  IDBDatabase_CreateTransaction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_CreateTransaction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_CreateTransaction_Params.transactionReceiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBDatabase_CreateTransaction_Params.objectStoreIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.Int64, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_CreateTransaction_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, IDBTransactionMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_CreateTransaction_Params.durability
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, IDBTransactionDurability);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_CreateTransaction_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBDatabase_CreateTransaction_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_CreateTransaction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionReceiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.mode =
        decoder.decodeStruct(new codec.Enum(IDBTransactionMode));
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreIds =
        decoder.decodeArrayPointer(codec.Int64);
    val.durability =
        decoder.decodeStruct(new codec.Enum(IDBTransactionDurability));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_CreateTransaction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_CreateTransaction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.transactionReceiver);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeArrayPointer(codec.Int64, val.objectStoreIds);
    encoder.encodeStruct(codec.Int32, val.durability);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_VersionChangeIgnored_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_VersionChangeIgnored_Params.prototype.initDefaults_ = function() {
  };
  IDBDatabase_VersionChangeIgnored_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_VersionChangeIgnored_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_VersionChangeIgnored_Params.encodedSize = codec.kStructHeaderSize + 0;

  IDBDatabase_VersionChangeIgnored_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_VersionChangeIgnored_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  IDBDatabase_VersionChangeIgnored_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_VersionChangeIgnored_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function IDBDatabase_Get_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Get_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
    this.keyRange = null;
    this.keyOnly = false;
  };
  IDBDatabase_Get_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Get_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate IDBDatabase_Get_Params.keyRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBKeyRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabase_Get_Params.encodedSize = codec.kStructHeaderSize + 40;

  IDBDatabase_Get_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Get_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.keyRange =
        decoder.decodeStructPointer(IDBKeyRange);
    packed = decoder.readUint8();
    val.keyOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_Get_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Get_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeStructPointer(IDBKeyRange, val.keyRange);
    packed = 0;
    packed |= (val.keyOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_Get_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Get_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBDatabase_Get_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Get_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_Get_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBDatabaseGetResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_Get_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabase_Get_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Get_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBDatabaseGetResult);
    return val;
  };

  IDBDatabase_Get_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Get_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBDatabaseGetResult, val.result);
  };
  function IDBDatabase_GetAll_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_GetAll_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
    this.keyRange = null;
    this.resultType = 0;
    this.direction = 0;
    this.maxCount = 0;
  };
  IDBDatabase_GetAll_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_GetAll_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate IDBDatabase_GetAll_Params.keyRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBKeyRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_GetAll_Params.resultType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, IDBGetAllResultType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBDatabase_GetAll_Params.direction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, IDBCursorDirection);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_GetAll_Params.encodedSize = codec.kStructHeaderSize + 48;

  IDBDatabase_GetAll_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_GetAll_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.keyRange =
        decoder.decodeStructPointer(IDBKeyRange);
    val.resultType =
        decoder.decodeStruct(new codec.Enum(IDBGetAllResultType));
    val.direction =
        decoder.decodeStruct(new codec.Enum(IDBCursorDirection));
    val.maxCount =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabase_GetAll_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_GetAll_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeStructPointer(IDBKeyRange, val.keyRange);
    encoder.encodeStruct(codec.Int32, val.resultType);
    encoder.encodeStruct(codec.Int32, val.direction);
    encoder.encodeStruct(codec.Int64, val.maxCount);
  };
  function IDBDatabase_GetAll_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_GetAll_ResponseParams.prototype.initDefaults_ = function() {
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
  };
  IDBDatabase_GetAll_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_GetAll_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_GetAll_ResponseParams.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_GetAll_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_GetAll_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_GetAll_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_GetAll_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_GetAll_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_OpenCursor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_OpenCursor_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
    this.keyRange = null;
    this.direction = 0;
    this.keyOnly = false;
    this.taskType = 0;
  };
  IDBDatabase_OpenCursor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_OpenCursor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate IDBDatabase_OpenCursor_Params.keyRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBKeyRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_OpenCursor_Params.direction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, IDBCursorDirection);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBDatabase_OpenCursor_Params.taskType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, IDBTaskType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_OpenCursor_Params.encodedSize = codec.kStructHeaderSize + 48;

  IDBDatabase_OpenCursor_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_OpenCursor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.keyRange =
        decoder.decodeStructPointer(IDBKeyRange);
    val.direction =
        decoder.decodeStruct(new codec.Enum(IDBCursorDirection));
    packed = decoder.readUint8();
    val.keyOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.taskType =
        decoder.decodeStruct(new codec.Enum(IDBTaskType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_OpenCursor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_OpenCursor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeStructPointer(IDBKeyRange, val.keyRange);
    encoder.encodeStruct(codec.Int32, val.direction);
    packed = 0;
    packed |= (val.keyOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.taskType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_OpenCursor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_OpenCursor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  IDBDatabase_OpenCursor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_OpenCursor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBDatabase_OpenCursor_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, IDBDatabaseOpenCursorResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_OpenCursor_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabase_OpenCursor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_OpenCursor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(IDBDatabaseOpenCursorResult);
    return val;
  };

  IDBDatabase_OpenCursor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_OpenCursor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(IDBDatabaseOpenCursorResult, val.result);
  };
  function IDBDatabase_Count_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Count_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
    this.keyRange = null;
  };
  IDBDatabase_Count_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Count_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate IDBDatabase_Count_Params.keyRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, IDBKeyRange, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_Count_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBDatabase_Count_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Count_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.keyRange =
        decoder.decodeStructPointer(IDBKeyRange);
    return val;
  };

  IDBDatabase_Count_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Count_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeStructPointer(IDBKeyRange, val.keyRange);
  };
  function IDBDatabase_Count_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Count_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.count = 0;
  };
  IDBDatabase_Count_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Count_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBDatabase_Count_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_Count_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Count_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.count =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  IDBDatabase_Count_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Count_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.count);
  };
  function IDBDatabase_DeleteRange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_DeleteRange_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.keyRange = null;
  };
  IDBDatabase_DeleteRange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_DeleteRange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate IDBDatabase_DeleteRange_Params.keyRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBKeyRange, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_DeleteRange_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBDatabase_DeleteRange_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_DeleteRange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.keyRange =
        decoder.decodeStructPointer(IDBKeyRange);
    return val;
  };

  IDBDatabase_DeleteRange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_DeleteRange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStructPointer(IDBKeyRange, val.keyRange);
  };
  function IDBDatabase_DeleteRange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_DeleteRange_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  IDBDatabase_DeleteRange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_DeleteRange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabase_DeleteRange_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_DeleteRange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_DeleteRange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_DeleteRange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_DeleteRange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_GetKeyGeneratorCurrentNumber_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
  };
  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_GetKeyGeneratorCurrentNumber_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_GetKeyGeneratorCurrentNumber_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
  };
  function IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.error = null;
  };
  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, IDBError, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int64);
    val.error =
        decoder.decodeStructPointer(IDBError);
    return val;
  };

  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.result);
    encoder.encodeStructPointer(IDBError, val.error);
  };
  function IDBDatabase_Clear_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Clear_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
  };
  IDBDatabase_Clear_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Clear_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBDatabase_Clear_Params.encodedSize = codec.kStructHeaderSize + 16;

  IDBDatabase_Clear_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Clear_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabase_Clear_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Clear_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
  };
  function IDBDatabase_Clear_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Clear_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  IDBDatabase_Clear_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Clear_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabase_Clear_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_Clear_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Clear_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_Clear_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Clear_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBDatabase_CreateIndex_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_CreateIndex_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.index = null;
  };
  IDBDatabase_CreateIndex_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_CreateIndex_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate IDBDatabase_CreateIndex_Params.index
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, IDBIndexMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_CreateIndex_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBDatabase_CreateIndex_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_CreateIndex_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.index =
        decoder.decodeStructPointer(IDBIndexMetadata);
    return val;
  };

  IDBDatabase_CreateIndex_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_CreateIndex_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStructPointer(IDBIndexMetadata, val.index);
  };
  function IDBDatabase_DeleteIndex_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_DeleteIndex_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
  };
  IDBDatabase_DeleteIndex_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_DeleteIndex_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  IDBDatabase_DeleteIndex_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBDatabase_DeleteIndex_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_DeleteIndex_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabase_DeleteIndex_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_DeleteIndex_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
  };
  function IDBDatabase_RenameIndex_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_RenameIndex_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
    this.objectStoreId = 0;
    this.indexId = 0;
    this.newName = null;
  };
  IDBDatabase_RenameIndex_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_RenameIndex_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate IDBDatabase_RenameIndex_Params.newName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_RenameIndex_Params.encodedSize = codec.kStructHeaderSize + 32;

  IDBDatabase_RenameIndex_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_RenameIndex_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    val.objectStoreId =
        decoder.decodeStruct(codec.Int64);
    val.indexId =
        decoder.decodeStruct(codec.Int64);
    val.newName =
        decoder.decodeStructPointer(string161$.String16);
    return val;
  };

  IDBDatabase_RenameIndex_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_RenameIndex_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
    encoder.encodeStruct(codec.Int64, val.objectStoreId);
    encoder.encodeStruct(codec.Int64, val.indexId);
    encoder.encodeStructPointer(string161$.String16, val.newName);
  };
  function IDBDatabase_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_Abort_Params.prototype.initDefaults_ = function() {
    this.transactionId = 0;
  };
  IDBDatabase_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabase_Abort_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBDatabase_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_Abort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.transactionId);
  };
  function IDBDatabase_DidBecomeInactive_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_DidBecomeInactive_Params.prototype.initDefaults_ = function() {
  };
  IDBDatabase_DidBecomeInactive_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_DidBecomeInactive_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBDatabase_DidBecomeInactive_Params.encodedSize = codec.kStructHeaderSize + 0;

  IDBDatabase_DidBecomeInactive_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_DidBecomeInactive_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  IDBDatabase_DidBecomeInactive_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_DidBecomeInactive_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function IDBDatabase_UpdatePriority_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBDatabase_UpdatePriority_Params.prototype.initDefaults_ = function() {
    this.newPriority = 0;
  };
  IDBDatabase_UpdatePriority_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBDatabase_UpdatePriority_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBDatabase_UpdatePriority_Params.encodedSize = codec.kStructHeaderSize + 8;

  IDBDatabase_UpdatePriority_Params.decode = function(decoder) {
    var packed;
    var val = new IDBDatabase_UpdatePriority_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newPriority =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBDatabase_UpdatePriority_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBDatabase_UpdatePriority_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.newPriority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function IDBFactory_GetDatabaseInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactory_GetDatabaseInfo_Params.prototype.initDefaults_ = function() {
  };
  IDBFactory_GetDatabaseInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactory_GetDatabaseInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFactory_GetDatabaseInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  IDBFactory_GetDatabaseInfo_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactory_GetDatabaseInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  IDBFactory_GetDatabaseInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactory_GetDatabaseInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function IDBFactory_GetDatabaseInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactory_GetDatabaseInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.namesAndVersions = null;
    this.error = null;
  };
  IDBFactory_GetDatabaseInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactory_GetDatabaseInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_GetDatabaseInfo_ResponseParams.namesAndVersions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(IDBNameAndVersion), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_GetDatabaseInfo_ResponseParams.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IDBFactory_GetDatabaseInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  IDBFactory_GetDatabaseInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new IDBFactory_GetDatabaseInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.namesAndVersions =
        decoder.decodeArrayPointer(new codec.PointerTo(IDBNameAndVersion));
    val.error =
        decoder.decodeStructPointer(IDBError);
    return val;
  };

  IDBFactory_GetDatabaseInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactory_GetDatabaseInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(IDBNameAndVersion), val.namesAndVersions);
    encoder.encodeStructPointer(IDBError, val.error);
  };
  function IDBFactory_Open_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactory_Open_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
    this.databaseCallbacks = new associatedBindings.AssociatedInterfacePtrInfo();
    this.name = null;
    this.version = 0;
    this.versionChangeTransactionReceiver = new associatedBindings.AssociatedInterfaceRequest();
    this.priority = 0;
    this.transactionId = 0;
  };
  IDBFactory_Open_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactory_Open_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_Open_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_Open_Params.databaseCallbacks
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_Open_Params.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate IDBFactory_Open_Params.versionChangeTransactionReceiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  IDBFactory_Open_Params.encodedSize = codec.kStructHeaderSize + 48;

  IDBFactory_Open_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactory_Open_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.databaseCallbacks =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    val.version =
        decoder.decodeStruct(codec.Int64);
    val.versionChangeTransactionReceiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.priority =
        decoder.decodeStruct(codec.Int32);
    val.transactionId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  IDBFactory_Open_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactory_Open_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.databaseCallbacks);
    encoder.encodeStructPointer(string161$.String16, val.name);
    encoder.encodeStruct(codec.Int64, val.version);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.versionChangeTransactionReceiver);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int64, val.transactionId);
  };
  function IDBFactory_DeleteDatabase_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  IDBFactory_DeleteDatabase_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
    this.name = null;
    this.forceClose = false;
  };
  IDBFactory_DeleteDatabase_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IDBFactory_DeleteDatabase_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_DeleteDatabase_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IDBFactory_DeleteDatabase_Params.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  IDBFactory_DeleteDatabase_Params.encodedSize = codec.kStructHeaderSize + 24;

  IDBFactory_DeleteDatabase_Params.decode = function(decoder) {
    var packed;
    var val = new IDBFactory_DeleteDatabase_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.name =
        decoder.decodeStructPointer(string161$.String16);
    packed = decoder.readUint8();
    val.forceClose = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  IDBFactory_DeleteDatabase_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IDBFactory_DeleteDatabase_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.encodeStructPointer(string161$.String16, val.name);
    packed = 0;
    packed |= (val.forceClose & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function IDBKey(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBKey.Tags = {
    keyArray: 0,
    binary: 1,
    string: 2,
    date: 3,
    number: 4,
    otherNone: 5,
  };

  IDBKey.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBKey.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "keyArray",
        "binary",
        "string",
        "date",
        "number",
        "otherNone",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBKey member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBKey.prototype, "keyArray", {
    get: function() {
      if (this.$tag != IDBKey.Tags.keyArray) {
        throw new ReferenceError(
            "IDBKey.keyArray is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.keyArray;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKey.prototype, "binary", {
    get: function() {
      if (this.$tag != IDBKey.Tags.binary) {
        throw new ReferenceError(
            "IDBKey.binary is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.binary;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKey.prototype, "string", {
    get: function() {
      if (this.$tag != IDBKey.Tags.string) {
        throw new ReferenceError(
            "IDBKey.string is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.string;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKey.prototype, "date", {
    get: function() {
      if (this.$tag != IDBKey.Tags.date) {
        throw new ReferenceError(
            "IDBKey.date is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.date;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKey.prototype, "number", {
    get: function() {
      if (this.$tag != IDBKey.Tags.number) {
        throw new ReferenceError(
            "IDBKey.number is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.number;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKey.prototype, "otherNone", {
    get: function() {
      if (this.$tag != IDBKey.Tags.otherNone) {
        throw new ReferenceError(
            "IDBKey.otherNone is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKey.Tags.otherNone;
      this.$data = value;
    }
  });


    IDBKey.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBKey.Tags.keyArray:
          encoder.encodeArrayPointer(IDBKey, val.keyArray);
          break;
        case IDBKey.Tags.binary:
          encoder.encodeArrayPointer(codec.Uint8, val.binary);
          break;
        case IDBKey.Tags.string:
          encoder.encodeStructPointer(string161$.String16, val.string);
          break;
        case IDBKey.Tags.date:
          encoder.encodeStruct(codec.Double, val.date);
          break;
        case IDBKey.Tags.number:
          encoder.encodeStruct(codec.Double, val.number);
          break;
        case IDBKey.Tags.otherNone:
          encoder.writeUint8(val.otherNone ? 1 : 0);
          break;
      }
      encoder.align();
    };


    IDBKey.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBKey();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBKey.Tags.keyArray:
          result.keyArray = decoder.decodeArrayPointer(IDBKey);
          break;
        case IDBKey.Tags.binary:
          result.binary = decoder.decodeArrayPointer(codec.Uint8);
          break;
        case IDBKey.Tags.string:
          result.string = decoder.decodeStructPointer(string161$.String16);
          break;
        case IDBKey.Tags.date:
          result.date = decoder.decodeStruct(codec.Double);
          break;
        case IDBKey.Tags.number:
          result.number = decoder.decodeStruct(codec.Double);
          break;
        case IDBKey.Tags.otherNone:
          result.otherNone = decoder.readUint8() ? true : false;
          break;
      }
      decoder.align();

      return result;
    };


    IDBKey.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBKey.Tags.keyArray:
          

    // validate IDBKey.keyArray
    err = messageValidator.validateArrayPointer(data_offset, 16, IDBKey, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBKey.Tags.binary:
          

    // validate IDBKey.binary
    err = messageValidator.validateArrayPointer(data_offset, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBKey.Tags.string:
          

    // validate IDBKey.string
    err = messageValidator.validateStructPointer(data_offset, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBKey.Tags.date:
          

          break;
        case IDBKey.Tags.number:
          

          break;
        case IDBKey.Tags.otherNone:
          

          break;
      }

      return validator.validationError.NONE;
    };

  IDBKey.encodedSize = 16;

  function IDBKeyPathData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBKeyPathData.Tags = {
    string: 0,
    stringArray: 1,
  };

  IDBKeyPathData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBKeyPathData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "string",
        "stringArray",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBKeyPathData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBKeyPathData.prototype, "string", {
    get: function() {
      if (this.$tag != IDBKeyPathData.Tags.string) {
        throw new ReferenceError(
            "IDBKeyPathData.string is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKeyPathData.Tags.string;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBKeyPathData.prototype, "stringArray", {
    get: function() {
      if (this.$tag != IDBKeyPathData.Tags.stringArray) {
        throw new ReferenceError(
            "IDBKeyPathData.stringArray is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBKeyPathData.Tags.stringArray;
      this.$data = value;
    }
  });


    IDBKeyPathData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBKeyPathData.Tags.string:
          encoder.encodeStructPointer(string161$.String16, val.string);
          break;
        case IDBKeyPathData.Tags.stringArray:
          encoder.encodeArrayPointer(new codec.PointerTo(string161$.String16), val.stringArray);
          break;
      }
      encoder.align();
    };


    IDBKeyPathData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBKeyPathData();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBKeyPathData.Tags.string:
          result.string = decoder.decodeStructPointer(string161$.String16);
          break;
        case IDBKeyPathData.Tags.stringArray:
          result.stringArray = decoder.decodeArrayPointer(new codec.PointerTo(string161$.String16));
          break;
      }
      decoder.align();

      return result;
    };


    IDBKeyPathData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBKeyPathData.Tags.string:
          

    // validate IDBKeyPathData.string
    err = messageValidator.validateStructPointer(data_offset, string161$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBKeyPathData.Tags.stringArray:
          

    // validate IDBKeyPathData.stringArray
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(string161$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBKeyPathData.encodedSize = 16;

  function IDBExternalObject(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBExternalObject.Tags = {
    blobOrFile: 0,
    fileSystemAccessToken: 1,
  };

  IDBExternalObject.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBExternalObject.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "blobOrFile",
        "fileSystemAccessToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBExternalObject member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBExternalObject.prototype, "blobOrFile", {
    get: function() {
      if (this.$tag != IDBExternalObject.Tags.blobOrFile) {
        throw new ReferenceError(
            "IDBExternalObject.blobOrFile is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBExternalObject.Tags.blobOrFile;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBExternalObject.prototype, "fileSystemAccessToken", {
    get: function() {
      if (this.$tag != IDBExternalObject.Tags.fileSystemAccessToken) {
        throw new ReferenceError(
            "IDBExternalObject.fileSystemAccessToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBExternalObject.Tags.fileSystemAccessToken;
      this.$data = value;
    }
  });


    IDBExternalObject.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBExternalObject.Tags.blobOrFile:
          encoder.encodeStructPointer(IDBBlobInfo, val.blobOrFile);
          break;
        case IDBExternalObject.Tags.fileSystemAccessToken:
          encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.fileSystemAccessToken);
          break;
      }
      encoder.align();
    };


    IDBExternalObject.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBExternalObject();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBExternalObject.Tags.blobOrFile:
          result.blobOrFile = decoder.decodeStructPointer(IDBBlobInfo);
          break;
        case IDBExternalObject.Tags.fileSystemAccessToken:
          result.fileSystemAccessToken = decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
          break;
      }
      decoder.align();

      return result;
    };


    IDBExternalObject.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBExternalObject.Tags.blobOrFile:
          

    // validate IDBExternalObject.blobOrFile
    err = messageValidator.validateStructPointer(data_offset, IDBBlobInfo, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBExternalObject.Tags.fileSystemAccessToken:
          

    // validate IDBExternalObject.fileSystemAccessToken
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBExternalObject.encodedSize = 16;

  function IDBCursorResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBCursorResult.Tags = {
    errorResult: 0,
    empty: 1,
    values: 2,
  };

  IDBCursorResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBCursorResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorResult",
        "empty",
        "values",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBCursorResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBCursorResult.prototype, "errorResult", {
    get: function() {
      if (this.$tag != IDBCursorResult.Tags.errorResult) {
        throw new ReferenceError(
            "IDBCursorResult.errorResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBCursorResult.Tags.errorResult;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBCursorResult.prototype, "empty", {
    get: function() {
      if (this.$tag != IDBCursorResult.Tags.empty) {
        throw new ReferenceError(
            "IDBCursorResult.empty is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBCursorResult.Tags.empty;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBCursorResult.prototype, "values", {
    get: function() {
      if (this.$tag != IDBCursorResult.Tags.values) {
        throw new ReferenceError(
            "IDBCursorResult.values is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBCursorResult.Tags.values;
      this.$data = value;
    }
  });


    IDBCursorResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBCursorResult.Tags.errorResult:
          encoder.encodeStructPointer(IDBError, val.errorResult);
          break;
        case IDBCursorResult.Tags.empty:
          encoder.writeUint8(val.empty ? 1 : 0);
          break;
        case IDBCursorResult.Tags.values:
          encoder.encodeStructPointer(IDBCursorValue, val.values);
          break;
      }
      encoder.align();
    };


    IDBCursorResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBCursorResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBCursorResult.Tags.errorResult:
          result.errorResult = decoder.decodeStructPointer(IDBError);
          break;
        case IDBCursorResult.Tags.empty:
          result.empty = decoder.readUint8() ? true : false;
          break;
        case IDBCursorResult.Tags.values:
          result.values = decoder.decodeStructPointer(IDBCursorValue);
          break;
      }
      decoder.align();

      return result;
    };


    IDBCursorResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBCursorResult.Tags.errorResult:
          

    // validate IDBCursorResult.errorResult
    err = messageValidator.validateStructPointer(data_offset, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBCursorResult.Tags.empty:
          

          break;
        case IDBCursorResult.Tags.values:
          

    // validate IDBCursorResult.values
    err = messageValidator.validateStructPointer(data_offset, IDBCursorValue, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBCursorResult.encodedSize = 16;

  function IDBTransactionPutResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBTransactionPutResult.Tags = {
    errorResult: 0,
    key: 1,
  };

  IDBTransactionPutResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBTransactionPutResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorResult",
        "key",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBTransactionPutResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBTransactionPutResult.prototype, "errorResult", {
    get: function() {
      if (this.$tag != IDBTransactionPutResult.Tags.errorResult) {
        throw new ReferenceError(
            "IDBTransactionPutResult.errorResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBTransactionPutResult.Tags.errorResult;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBTransactionPutResult.prototype, "key", {
    get: function() {
      if (this.$tag != IDBTransactionPutResult.Tags.key) {
        throw new ReferenceError(
            "IDBTransactionPutResult.key is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBTransactionPutResult.Tags.key;
      this.$data = value;
    }
  });


    IDBTransactionPutResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBTransactionPutResult.Tags.errorResult:
          encoder.encodeStructPointer(IDBError, val.errorResult);
          break;
        case IDBTransactionPutResult.Tags.key:
          encoder.encodeStructPointer(IDBKey, val.key);
          break;
      }
      encoder.align();
    };


    IDBTransactionPutResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBTransactionPutResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBTransactionPutResult.Tags.errorResult:
          result.errorResult = decoder.decodeStructPointer(IDBError);
          break;
        case IDBTransactionPutResult.Tags.key:
          result.key = decoder.decodeStructPointer(IDBKey);
          break;
      }
      decoder.align();

      return result;
    };


    IDBTransactionPutResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBTransactionPutResult.Tags.errorResult:
          

    // validate IDBTransactionPutResult.errorResult
    err = messageValidator.validateStructPointer(data_offset, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBTransactionPutResult.Tags.key:
          
    // validate IDBTransactionPutResult.key
    err = messageValidator.validateNestedUnion(data_offset, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBTransactionPutResult.encodedSize = 16;

  function IDBDatabaseGetResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBDatabaseGetResult.Tags = {
    errorResult: 0,
    empty: 1,
    key: 2,
    value: 3,
  };

  IDBDatabaseGetResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBDatabaseGetResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorResult",
        "empty",
        "key",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBDatabaseGetResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBDatabaseGetResult.prototype, "errorResult", {
    get: function() {
      if (this.$tag != IDBDatabaseGetResult.Tags.errorResult) {
        throw new ReferenceError(
            "IDBDatabaseGetResult.errorResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseGetResult.Tags.errorResult;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBDatabaseGetResult.prototype, "empty", {
    get: function() {
      if (this.$tag != IDBDatabaseGetResult.Tags.empty) {
        throw new ReferenceError(
            "IDBDatabaseGetResult.empty is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseGetResult.Tags.empty;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBDatabaseGetResult.prototype, "key", {
    get: function() {
      if (this.$tag != IDBDatabaseGetResult.Tags.key) {
        throw new ReferenceError(
            "IDBDatabaseGetResult.key is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseGetResult.Tags.key;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBDatabaseGetResult.prototype, "value", {
    get: function() {
      if (this.$tag != IDBDatabaseGetResult.Tags.value) {
        throw new ReferenceError(
            "IDBDatabaseGetResult.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseGetResult.Tags.value;
      this.$data = value;
    }
  });


    IDBDatabaseGetResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBDatabaseGetResult.Tags.errorResult:
          encoder.encodeStructPointer(IDBError, val.errorResult);
          break;
        case IDBDatabaseGetResult.Tags.empty:
          encoder.writeUint8(val.empty ? 1 : 0);
          break;
        case IDBDatabaseGetResult.Tags.key:
          encoder.encodeStructPointer(IDBKey, val.key);
          break;
        case IDBDatabaseGetResult.Tags.value:
          encoder.encodeStructPointer(IDBReturnValue, val.value);
          break;
      }
      encoder.align();
    };


    IDBDatabaseGetResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBDatabaseGetResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBDatabaseGetResult.Tags.errorResult:
          result.errorResult = decoder.decodeStructPointer(IDBError);
          break;
        case IDBDatabaseGetResult.Tags.empty:
          result.empty = decoder.readUint8() ? true : false;
          break;
        case IDBDatabaseGetResult.Tags.key:
          result.key = decoder.decodeStructPointer(IDBKey);
          break;
        case IDBDatabaseGetResult.Tags.value:
          result.value = decoder.decodeStructPointer(IDBReturnValue);
          break;
      }
      decoder.align();

      return result;
    };


    IDBDatabaseGetResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBDatabaseGetResult.Tags.errorResult:
          

    // validate IDBDatabaseGetResult.errorResult
    err = messageValidator.validateStructPointer(data_offset, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBDatabaseGetResult.Tags.empty:
          

          break;
        case IDBDatabaseGetResult.Tags.key:
          
    // validate IDBDatabaseGetResult.key
    err = messageValidator.validateNestedUnion(data_offset, IDBKey, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBDatabaseGetResult.Tags.value:
          

    // validate IDBDatabaseGetResult.value
    err = messageValidator.validateStructPointer(data_offset, IDBReturnValue, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBDatabaseGetResult.encodedSize = 16;

  function IDBDatabaseOpenCursorResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  IDBDatabaseOpenCursorResult.Tags = {
    errorResult: 0,
    empty: 1,
    value: 2,
  };

  IDBDatabaseOpenCursorResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  IDBDatabaseOpenCursorResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorResult",
        "empty",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a IDBDatabaseOpenCursorResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(IDBDatabaseOpenCursorResult.prototype, "errorResult", {
    get: function() {
      if (this.$tag != IDBDatabaseOpenCursorResult.Tags.errorResult) {
        throw new ReferenceError(
            "IDBDatabaseOpenCursorResult.errorResult is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseOpenCursorResult.Tags.errorResult;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBDatabaseOpenCursorResult.prototype, "empty", {
    get: function() {
      if (this.$tag != IDBDatabaseOpenCursorResult.Tags.empty) {
        throw new ReferenceError(
            "IDBDatabaseOpenCursorResult.empty is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseOpenCursorResult.Tags.empty;
      this.$data = value;
    }
  });
  Object.defineProperty(IDBDatabaseOpenCursorResult.prototype, "value", {
    get: function() {
      if (this.$tag != IDBDatabaseOpenCursorResult.Tags.value) {
        throw new ReferenceError(
            "IDBDatabaseOpenCursorResult.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = IDBDatabaseOpenCursorResult.Tags.value;
      this.$data = value;
    }
  });


    IDBDatabaseOpenCursorResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case IDBDatabaseOpenCursorResult.Tags.errorResult:
          encoder.encodeStructPointer(IDBError, val.errorResult);
          break;
        case IDBDatabaseOpenCursorResult.Tags.empty:
          encoder.writeUint8(val.empty ? 1 : 0);
          break;
        case IDBDatabaseOpenCursorResult.Tags.value:
          encoder.encodeStructPointer(IDBDatabaseOpenCursorValue, val.value);
          break;
      }
      encoder.align();
    };


    IDBDatabaseOpenCursorResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new IDBDatabaseOpenCursorResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case IDBDatabaseOpenCursorResult.Tags.errorResult:
          result.errorResult = decoder.decodeStructPointer(IDBError);
          break;
        case IDBDatabaseOpenCursorResult.Tags.empty:
          result.empty = decoder.readUint8() ? true : false;
          break;
        case IDBDatabaseOpenCursorResult.Tags.value:
          result.value = decoder.decodeStructPointer(IDBDatabaseOpenCursorValue);
          break;
      }
      decoder.align();

      return result;
    };


    IDBDatabaseOpenCursorResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case IDBDatabaseOpenCursorResult.Tags.errorResult:
          

    // validate IDBDatabaseOpenCursorResult.errorResult
    err = messageValidator.validateStructPointer(data_offset, IDBError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case IDBDatabaseOpenCursorResult.Tags.empty:
          

          break;
        case IDBDatabaseOpenCursorResult.Tags.value:
          

    // validate IDBDatabaseOpenCursorResult.value
    err = messageValidator.validateStructPointer(data_offset, IDBDatabaseOpenCursorValue, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  IDBDatabaseOpenCursorResult.encodedSize = 16;
  var kIDBFactoryClient_Error_Name = 0;
  var kIDBFactoryClient_Blocked_Name = 1;
  var kIDBFactoryClient_UpgradeNeeded_Name = 2;
  var kIDBFactoryClient_OpenSuccess_Name = 3;
  var kIDBFactoryClient_DeleteSuccess_Name = 4;

  function IDBFactoryClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBFactoryClient,
                                                   handleOrPtrInfo);
  }

  function IDBFactoryClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBFactoryClient, associatedInterfacePtrInfo);
  }

  IDBFactoryClientAssociatedPtr.prototype =
      Object.create(IDBFactoryClientPtr.prototype);
  IDBFactoryClientAssociatedPtr.prototype.constructor =
      IDBFactoryClientAssociatedPtr;

  function IDBFactoryClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBFactoryClientPtr.prototype.error = function() {
    return IDBFactoryClientProxy.prototype.error
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryClientProxy.prototype.error = function(code, message) {
    var params_ = new IDBFactoryClient_Error_Params();
    params_.code = code;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kIDBFactoryClient_Error_Name,
        codec.align(IDBFactoryClient_Error_Params.encodedSize));
    builder.encodeStruct(IDBFactoryClient_Error_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBFactoryClientPtr.prototype.blocked = function() {
    return IDBFactoryClientProxy.prototype.blocked
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryClientProxy.prototype.blocked = function(existingVersion) {
    var params_ = new IDBFactoryClient_Blocked_Params();
    params_.existingVersion = existingVersion;
    var builder = new codec.MessageV0Builder(
        kIDBFactoryClient_Blocked_Name,
        codec.align(IDBFactoryClient_Blocked_Params.encodedSize));
    builder.encodeStruct(IDBFactoryClient_Blocked_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBFactoryClientPtr.prototype.upgradeNeeded = function() {
    return IDBFactoryClientProxy.prototype.upgradeNeeded
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryClientProxy.prototype.upgradeNeeded = function(pendingDatabase, oldVersion, dataLoss, dataLossMessage, dbMetadata) {
    var params_ = new IDBFactoryClient_UpgradeNeeded_Params();
    params_.pendingDatabase = pendingDatabase;
    params_.oldVersion = oldVersion;
    params_.dataLoss = dataLoss;
    params_.dataLossMessage = dataLossMessage;
    params_.dbMetadata = dbMetadata;
    var builder = new codec.MessageV2Builder(
        kIDBFactoryClient_UpgradeNeeded_Name,
        codec.align(IDBFactoryClient_UpgradeNeeded_Params.encodedSize));
    builder.setPayload(IDBFactoryClient_UpgradeNeeded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBFactoryClientPtr.prototype.openSuccess = function() {
    return IDBFactoryClientProxy.prototype.openSuccess
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryClientProxy.prototype.openSuccess = function(pendingDatabase, metadata) {
    var params_ = new IDBFactoryClient_OpenSuccess_Params();
    params_.pendingDatabase = pendingDatabase;
    params_.metadata = metadata;
    var builder = new codec.MessageV2Builder(
        kIDBFactoryClient_OpenSuccess_Name,
        codec.align(IDBFactoryClient_OpenSuccess_Params.encodedSize));
    builder.setPayload(IDBFactoryClient_OpenSuccess_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBFactoryClientPtr.prototype.deleteSuccess = function() {
    return IDBFactoryClientProxy.prototype.deleteSuccess
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryClientProxy.prototype.deleteSuccess = function(oldVersion) {
    var params_ = new IDBFactoryClient_DeleteSuccess_Params();
    params_.oldVersion = oldVersion;
    var builder = new codec.MessageV0Builder(
        kIDBFactoryClient_DeleteSuccess_Name,
        codec.align(IDBFactoryClient_DeleteSuccess_Params.encodedSize));
    builder.encodeStruct(IDBFactoryClient_DeleteSuccess_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBFactoryClientStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBFactoryClientStub.prototype.error = function(code, message) {
    return this.delegate_ && this.delegate_.error && this.delegate_.error(code, message);
  }
  IDBFactoryClientStub.prototype.blocked = function(existingVersion) {
    return this.delegate_ && this.delegate_.blocked && this.delegate_.blocked(existingVersion);
  }
  IDBFactoryClientStub.prototype.upgradeNeeded = function(pendingDatabase, oldVersion, dataLoss, dataLossMessage, dbMetadata) {
    return this.delegate_ && this.delegate_.upgradeNeeded && this.delegate_.upgradeNeeded(pendingDatabase, oldVersion, dataLoss, dataLossMessage, dbMetadata);
  }
  IDBFactoryClientStub.prototype.openSuccess = function(pendingDatabase, metadata) {
    return this.delegate_ && this.delegate_.openSuccess && this.delegate_.openSuccess(pendingDatabase, metadata);
  }
  IDBFactoryClientStub.prototype.deleteSuccess = function(oldVersion) {
    return this.delegate_ && this.delegate_.deleteSuccess && this.delegate_.deleteSuccess(oldVersion);
  }

  IDBFactoryClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBFactoryClient_Error_Name:
      var params = reader.decodeStruct(IDBFactoryClient_Error_Params);
      this.error(params.code, params.message);
      return true;
    case kIDBFactoryClient_Blocked_Name:
      var params = reader.decodeStruct(IDBFactoryClient_Blocked_Params);
      this.blocked(params.existingVersion);
      return true;
    case kIDBFactoryClient_UpgradeNeeded_Name:
      var params = reader.decodeStruct(IDBFactoryClient_UpgradeNeeded_Params);
      this.upgradeNeeded(params.pendingDatabase, params.oldVersion, params.dataLoss, params.dataLossMessage, params.dbMetadata);
      return true;
    case kIDBFactoryClient_OpenSuccess_Name:
      var params = reader.decodeStruct(IDBFactoryClient_OpenSuccess_Params);
      this.openSuccess(params.pendingDatabase, params.metadata);
      return true;
    case kIDBFactoryClient_DeleteSuccess_Name:
      var params = reader.decodeStruct(IDBFactoryClient_DeleteSuccess_Params);
      this.deleteSuccess(params.oldVersion);
      return true;
    default:
      return false;
    }
  };

  IDBFactoryClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateIDBFactoryClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBFactoryClient_Error_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactoryClient_Error_Params;
      break;
      case kIDBFactoryClient_Blocked_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactoryClient_Blocked_Params;
      break;
      case kIDBFactoryClient_UpgradeNeeded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactoryClient_UpgradeNeeded_Params;
      break;
      case kIDBFactoryClient_OpenSuccess_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactoryClient_OpenSuccess_Params;
      break;
      case kIDBFactoryClient_DeleteSuccess_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactoryClient_DeleteSuccess_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBFactoryClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var IDBFactoryClient = {
    name: 'blink.mojom.IDBFactoryClient',
    kVersion: 0,
    ptrClass: IDBFactoryClientPtr,
    proxyClass: IDBFactoryClientProxy,
    stubClass: IDBFactoryClientStub,
    validateRequest: validateIDBFactoryClientRequest,
    validateResponse: null,
  };
  IDBFactoryClientStub.prototype.validator = validateIDBFactoryClientRequest;
  IDBFactoryClientProxy.prototype.validator = null;
  var kIDBDatabaseCallbacks_ForcedClose_Name = 0;
  var kIDBDatabaseCallbacks_VersionChange_Name = 1;
  var kIDBDatabaseCallbacks_Abort_Name = 2;
  var kIDBDatabaseCallbacks_Complete_Name = 3;

  function IDBDatabaseCallbacksPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBDatabaseCallbacks,
                                                   handleOrPtrInfo);
  }

  function IDBDatabaseCallbacksAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBDatabaseCallbacks, associatedInterfacePtrInfo);
  }

  IDBDatabaseCallbacksAssociatedPtr.prototype =
      Object.create(IDBDatabaseCallbacksPtr.prototype);
  IDBDatabaseCallbacksAssociatedPtr.prototype.constructor =
      IDBDatabaseCallbacksAssociatedPtr;

  function IDBDatabaseCallbacksProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBDatabaseCallbacksPtr.prototype.forcedClose = function() {
    return IDBDatabaseCallbacksProxy.prototype.forcedClose
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseCallbacksProxy.prototype.forcedClose = function() {
    var params_ = new IDBDatabaseCallbacks_ForcedClose_Params();
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseCallbacks_ForcedClose_Name,
        codec.align(IDBDatabaseCallbacks_ForcedClose_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseCallbacks_ForcedClose_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabaseCallbacksPtr.prototype.versionChange = function() {
    return IDBDatabaseCallbacksProxy.prototype.versionChange
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseCallbacksProxy.prototype.versionChange = function(oldVersion, newVersion) {
    var params_ = new IDBDatabaseCallbacks_VersionChange_Params();
    params_.oldVersion = oldVersion;
    params_.newVersion = newVersion;
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseCallbacks_VersionChange_Name,
        codec.align(IDBDatabaseCallbacks_VersionChange_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseCallbacks_VersionChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabaseCallbacksPtr.prototype.abort = function() {
    return IDBDatabaseCallbacksProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseCallbacksProxy.prototype.abort = function(transactionId, code, message) {
    var params_ = new IDBDatabaseCallbacks_Abort_Params();
    params_.transactionId = transactionId;
    params_.code = code;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseCallbacks_Abort_Name,
        codec.align(IDBDatabaseCallbacks_Abort_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseCallbacks_Abort_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabaseCallbacksPtr.prototype.complete = function() {
    return IDBDatabaseCallbacksProxy.prototype.complete
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseCallbacksProxy.prototype.complete = function(transactionId) {
    var params_ = new IDBDatabaseCallbacks_Complete_Params();
    params_.transactionId = transactionId;
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseCallbacks_Complete_Name,
        codec.align(IDBDatabaseCallbacks_Complete_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseCallbacks_Complete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBDatabaseCallbacksStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBDatabaseCallbacksStub.prototype.forcedClose = function() {
    return this.delegate_ && this.delegate_.forcedClose && this.delegate_.forcedClose();
  }
  IDBDatabaseCallbacksStub.prototype.versionChange = function(oldVersion, newVersion) {
    return this.delegate_ && this.delegate_.versionChange && this.delegate_.versionChange(oldVersion, newVersion);
  }
  IDBDatabaseCallbacksStub.prototype.abort = function(transactionId, code, message) {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort(transactionId, code, message);
  }
  IDBDatabaseCallbacksStub.prototype.complete = function(transactionId) {
    return this.delegate_ && this.delegate_.complete && this.delegate_.complete(transactionId);
  }

  IDBDatabaseCallbacksStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBDatabaseCallbacks_ForcedClose_Name:
      var params = reader.decodeStruct(IDBDatabaseCallbacks_ForcedClose_Params);
      this.forcedClose();
      return true;
    case kIDBDatabaseCallbacks_VersionChange_Name:
      var params = reader.decodeStruct(IDBDatabaseCallbacks_VersionChange_Params);
      this.versionChange(params.oldVersion, params.newVersion);
      return true;
    case kIDBDatabaseCallbacks_Abort_Name:
      var params = reader.decodeStruct(IDBDatabaseCallbacks_Abort_Params);
      this.abort(params.transactionId, params.code, params.message);
      return true;
    case kIDBDatabaseCallbacks_Complete_Name:
      var params = reader.decodeStruct(IDBDatabaseCallbacks_Complete_Params);
      this.complete(params.transactionId);
      return true;
    default:
      return false;
    }
  };

  IDBDatabaseCallbacksStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateIDBDatabaseCallbacksRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBDatabaseCallbacks_ForcedClose_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseCallbacks_ForcedClose_Params;
      break;
      case kIDBDatabaseCallbacks_VersionChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseCallbacks_VersionChange_Params;
      break;
      case kIDBDatabaseCallbacks_Abort_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseCallbacks_Abort_Params;
      break;
      case kIDBDatabaseCallbacks_Complete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseCallbacks_Complete_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBDatabaseCallbacksResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var IDBDatabaseCallbacks = {
    name: 'blink.mojom.IDBDatabaseCallbacks',
    kVersion: 0,
    ptrClass: IDBDatabaseCallbacksPtr,
    proxyClass: IDBDatabaseCallbacksProxy,
    stubClass: IDBDatabaseCallbacksStub,
    validateRequest: validateIDBDatabaseCallbacksRequest,
    validateResponse: null,
  };
  IDBDatabaseCallbacksStub.prototype.validator = validateIDBDatabaseCallbacksRequest;
  IDBDatabaseCallbacksProxy.prototype.validator = null;
  var kIDBCursor_Advance_Name = 0;
  var kIDBCursor_Continue_Name = 1;
  var kIDBCursor_Prefetch_Name = 2;
  var kIDBCursor_PrefetchReset_Name = 3;

  function IDBCursorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBCursor,
                                                   handleOrPtrInfo);
  }

  function IDBCursorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBCursor, associatedInterfacePtrInfo);
  }

  IDBCursorAssociatedPtr.prototype =
      Object.create(IDBCursorPtr.prototype);
  IDBCursorAssociatedPtr.prototype.constructor =
      IDBCursorAssociatedPtr;

  function IDBCursorProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBCursorPtr.prototype.advance = function() {
    return IDBCursorProxy.prototype.advance
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBCursorProxy.prototype.advance = function(count) {
    var params_ = new IDBCursor_Advance_Params();
    params_.count = count;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBCursor_Advance_Name,
          codec.align(IDBCursor_Advance_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBCursor_Advance_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBCursor_Advance_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBCursorPtr.prototype.continue = function() {
    return IDBCursorProxy.prototype.continue
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBCursorProxy.prototype.continue = function(key, primaryKey) {
    var params_ = new IDBCursor_Continue_Params();
    params_.key = key;
    params_.primaryKey = primaryKey;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBCursor_Continue_Name,
          codec.align(IDBCursor_Continue_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBCursor_Continue_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBCursor_Continue_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBCursorPtr.prototype.prefetch = function() {
    return IDBCursorProxy.prototype.prefetch
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBCursorProxy.prototype.prefetch = function(count) {
    var params_ = new IDBCursor_Prefetch_Params();
    params_.count = count;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBCursor_Prefetch_Name,
          codec.align(IDBCursor_Prefetch_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBCursor_Prefetch_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBCursor_Prefetch_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBCursorPtr.prototype.prefetchReset = function() {
    return IDBCursorProxy.prototype.prefetchReset
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBCursorProxy.prototype.prefetchReset = function(usedPrefetches) {
    var params_ = new IDBCursor_PrefetchReset_Params();
    params_.usedPrefetches = usedPrefetches;
    var builder = new codec.MessageV0Builder(
        kIDBCursor_PrefetchReset_Name,
        codec.align(IDBCursor_PrefetchReset_Params.encodedSize));
    builder.encodeStruct(IDBCursor_PrefetchReset_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBCursorStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBCursorStub.prototype.advance = function(count) {
    return this.delegate_ && this.delegate_.advance && this.delegate_.advance(count);
  }
  IDBCursorStub.prototype.continue = function(key, primaryKey) {
    return this.delegate_ && this.delegate_.continue && this.delegate_.continue(key, primaryKey);
  }
  IDBCursorStub.prototype.prefetch = function(count) {
    return this.delegate_ && this.delegate_.prefetch && this.delegate_.prefetch(count);
  }
  IDBCursorStub.prototype.prefetchReset = function(usedPrefetches) {
    return this.delegate_ && this.delegate_.prefetchReset && this.delegate_.prefetchReset(usedPrefetches);
  }

  IDBCursorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBCursor_PrefetchReset_Name:
      var params = reader.decodeStruct(IDBCursor_PrefetchReset_Params);
      this.prefetchReset(params.usedPrefetches);
      return true;
    default:
      return false;
    }
  };

  IDBCursorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBCursor_Advance_Name:
      var params = reader.decodeStruct(IDBCursor_Advance_Params);
      this.advance(params.count).then(function(response) {
        var responseParams =
            new IDBCursor_Advance_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kIDBCursor_Advance_Name,
            codec.align(IDBCursor_Advance_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBCursor_Advance_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBCursor_Continue_Name:
      var params = reader.decodeStruct(IDBCursor_Continue_Params);
      this.continue(params.key, params.primaryKey).then(function(response) {
        var responseParams =
            new IDBCursor_Continue_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kIDBCursor_Continue_Name,
            codec.align(IDBCursor_Continue_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBCursor_Continue_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBCursor_Prefetch_Name:
      var params = reader.decodeStruct(IDBCursor_Prefetch_Params);
      this.prefetch(params.count).then(function(response) {
        var responseParams =
            new IDBCursor_Prefetch_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kIDBCursor_Prefetch_Name,
            codec.align(IDBCursor_Prefetch_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBCursor_Prefetch_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateIDBCursorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBCursor_Advance_Name:
        if (message.expectsResponse())
          paramsClass = IDBCursor_Advance_Params;
      break;
      case kIDBCursor_Continue_Name:
        if (message.expectsResponse())
          paramsClass = IDBCursor_Continue_Params;
      break;
      case kIDBCursor_Prefetch_Name:
        if (message.expectsResponse())
          paramsClass = IDBCursor_Prefetch_Params;
      break;
      case kIDBCursor_PrefetchReset_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBCursor_PrefetchReset_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBCursorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kIDBCursor_Advance_Name:
        if (message.isResponse())
          paramsClass = IDBCursor_Advance_ResponseParams;
        break;
      case kIDBCursor_Continue_Name:
        if (message.isResponse())
          paramsClass = IDBCursor_Continue_ResponseParams;
        break;
      case kIDBCursor_Prefetch_Name:
        if (message.isResponse())
          paramsClass = IDBCursor_Prefetch_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var IDBCursor = {
    name: 'blink.mojom.IDBCursor',
    kVersion: 0,
    ptrClass: IDBCursorPtr,
    proxyClass: IDBCursorProxy,
    stubClass: IDBCursorStub,
    validateRequest: validateIDBCursorRequest,
    validateResponse: validateIDBCursorResponse,
  };
  IDBCursorStub.prototype.validator = validateIDBCursorRequest;
  IDBCursorProxy.prototype.validator = validateIDBCursorResponse;
  var kIDBTransaction_CreateObjectStore_Name = 0;
  var kIDBTransaction_DeleteObjectStore_Name = 1;
  var kIDBTransaction_Put_Name = 2;
  var kIDBTransaction_SetIndexKeys_Name = 3;
  var kIDBTransaction_SetIndexKeysDone_Name = 4;
  var kIDBTransaction_Commit_Name = 5;

  function IDBTransactionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBTransaction,
                                                   handleOrPtrInfo);
  }

  function IDBTransactionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBTransaction, associatedInterfacePtrInfo);
  }

  IDBTransactionAssociatedPtr.prototype =
      Object.create(IDBTransactionPtr.prototype);
  IDBTransactionAssociatedPtr.prototype.constructor =
      IDBTransactionAssociatedPtr;

  function IDBTransactionProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBTransactionPtr.prototype.createObjectStore = function() {
    return IDBTransactionProxy.prototype.createObjectStore
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.createObjectStore = function(objectStoreId, name, keyPath, autoIncrement) {
    var params_ = new IDBTransaction_CreateObjectStore_Params();
    params_.objectStoreId = objectStoreId;
    params_.name = name;
    params_.keyPath = keyPath;
    params_.autoIncrement = autoIncrement;
    var builder = new codec.MessageV0Builder(
        kIDBTransaction_CreateObjectStore_Name,
        codec.align(IDBTransaction_CreateObjectStore_Params.encodedSize));
    builder.encodeStruct(IDBTransaction_CreateObjectStore_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBTransactionPtr.prototype.deleteObjectStore = function() {
    return IDBTransactionProxy.prototype.deleteObjectStore
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.deleteObjectStore = function(objectStoreId) {
    var params_ = new IDBTransaction_DeleteObjectStore_Params();
    params_.objectStoreId = objectStoreId;
    var builder = new codec.MessageV0Builder(
        kIDBTransaction_DeleteObjectStore_Name,
        codec.align(IDBTransaction_DeleteObjectStore_Params.encodedSize));
    builder.encodeStruct(IDBTransaction_DeleteObjectStore_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBTransactionPtr.prototype.put = function() {
    return IDBTransactionProxy.prototype.put
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.put = function(objectStoreId, value, key, mode, indexKeys) {
    var params_ = new IDBTransaction_Put_Params();
    params_.objectStoreId = objectStoreId;
    params_.value = value;
    params_.key = key;
    params_.mode = mode;
    params_.indexKeys = indexKeys;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBTransaction_Put_Name,
          codec.align(IDBTransaction_Put_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBTransaction_Put_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBTransaction_Put_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBTransactionPtr.prototype.setIndexKeys = function() {
    return IDBTransactionProxy.prototype.setIndexKeys
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.setIndexKeys = function(objectStoreId, primaryKey, indexKeys) {
    var params_ = new IDBTransaction_SetIndexKeys_Params();
    params_.objectStoreId = objectStoreId;
    params_.primaryKey = primaryKey;
    params_.indexKeys = indexKeys;
    var builder = new codec.MessageV0Builder(
        kIDBTransaction_SetIndexKeys_Name,
        codec.align(IDBTransaction_SetIndexKeys_Params.encodedSize));
    builder.encodeStruct(IDBTransaction_SetIndexKeys_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBTransactionPtr.prototype.setIndexKeysDone = function() {
    return IDBTransactionProxy.prototype.setIndexKeysDone
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.setIndexKeysDone = function() {
    var params_ = new IDBTransaction_SetIndexKeysDone_Params();
    var builder = new codec.MessageV0Builder(
        kIDBTransaction_SetIndexKeysDone_Name,
        codec.align(IDBTransaction_SetIndexKeysDone_Params.encodedSize));
    builder.encodeStruct(IDBTransaction_SetIndexKeysDone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBTransactionPtr.prototype.commit = function() {
    return IDBTransactionProxy.prototype.commit
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBTransactionProxy.prototype.commit = function(numErrorsHandled) {
    var params_ = new IDBTransaction_Commit_Params();
    params_.numErrorsHandled = numErrorsHandled;
    var builder = new codec.MessageV0Builder(
        kIDBTransaction_Commit_Name,
        codec.align(IDBTransaction_Commit_Params.encodedSize));
    builder.encodeStruct(IDBTransaction_Commit_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBTransactionStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBTransactionStub.prototype.createObjectStore = function(objectStoreId, name, keyPath, autoIncrement) {
    return this.delegate_ && this.delegate_.createObjectStore && this.delegate_.createObjectStore(objectStoreId, name, keyPath, autoIncrement);
  }
  IDBTransactionStub.prototype.deleteObjectStore = function(objectStoreId) {
    return this.delegate_ && this.delegate_.deleteObjectStore && this.delegate_.deleteObjectStore(objectStoreId);
  }
  IDBTransactionStub.prototype.put = function(objectStoreId, value, key, mode, indexKeys) {
    return this.delegate_ && this.delegate_.put && this.delegate_.put(objectStoreId, value, key, mode, indexKeys);
  }
  IDBTransactionStub.prototype.setIndexKeys = function(objectStoreId, primaryKey, indexKeys) {
    return this.delegate_ && this.delegate_.setIndexKeys && this.delegate_.setIndexKeys(objectStoreId, primaryKey, indexKeys);
  }
  IDBTransactionStub.prototype.setIndexKeysDone = function() {
    return this.delegate_ && this.delegate_.setIndexKeysDone && this.delegate_.setIndexKeysDone();
  }
  IDBTransactionStub.prototype.commit = function(numErrorsHandled) {
    return this.delegate_ && this.delegate_.commit && this.delegate_.commit(numErrorsHandled);
  }

  IDBTransactionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBTransaction_CreateObjectStore_Name:
      var params = reader.decodeStruct(IDBTransaction_CreateObjectStore_Params);
      this.createObjectStore(params.objectStoreId, params.name, params.keyPath, params.autoIncrement);
      return true;
    case kIDBTransaction_DeleteObjectStore_Name:
      var params = reader.decodeStruct(IDBTransaction_DeleteObjectStore_Params);
      this.deleteObjectStore(params.objectStoreId);
      return true;
    case kIDBTransaction_SetIndexKeys_Name:
      var params = reader.decodeStruct(IDBTransaction_SetIndexKeys_Params);
      this.setIndexKeys(params.objectStoreId, params.primaryKey, params.indexKeys);
      return true;
    case kIDBTransaction_SetIndexKeysDone_Name:
      var params = reader.decodeStruct(IDBTransaction_SetIndexKeysDone_Params);
      this.setIndexKeysDone();
      return true;
    case kIDBTransaction_Commit_Name:
      var params = reader.decodeStruct(IDBTransaction_Commit_Params);
      this.commit(params.numErrorsHandled);
      return true;
    default:
      return false;
    }
  };

  IDBTransactionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBTransaction_Put_Name:
      var params = reader.decodeStruct(IDBTransaction_Put_Params);
      this.put(params.objectStoreId, params.value, params.key, params.mode, params.indexKeys).then(function(response) {
        var responseParams =
            new IDBTransaction_Put_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kIDBTransaction_Put_Name,
            codec.align(IDBTransaction_Put_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBTransaction_Put_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateIDBTransactionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBTransaction_CreateObjectStore_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBTransaction_CreateObjectStore_Params;
      break;
      case kIDBTransaction_DeleteObjectStore_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBTransaction_DeleteObjectStore_Params;
      break;
      case kIDBTransaction_Put_Name:
        if (message.expectsResponse())
          paramsClass = IDBTransaction_Put_Params;
      break;
      case kIDBTransaction_SetIndexKeys_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBTransaction_SetIndexKeys_Params;
      break;
      case kIDBTransaction_SetIndexKeysDone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBTransaction_SetIndexKeysDone_Params;
      break;
      case kIDBTransaction_Commit_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBTransaction_Commit_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBTransactionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kIDBTransaction_Put_Name:
        if (message.isResponse())
          paramsClass = IDBTransaction_Put_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var IDBTransaction = {
    name: 'blink.mojom.IDBTransaction',
    kVersion: 0,
    ptrClass: IDBTransactionPtr,
    proxyClass: IDBTransactionProxy,
    stubClass: IDBTransactionStub,
    validateRequest: validateIDBTransactionRequest,
    validateResponse: validateIDBTransactionResponse,
  };
  IDBTransactionStub.prototype.validator = validateIDBTransactionRequest;
  IDBTransactionProxy.prototype.validator = validateIDBTransactionResponse;
  var kIDBDatabaseGetAllResultSink_ReceiveResults_Name = 0;
  var kIDBDatabaseGetAllResultSink_OnError_Name = 1;

  function IDBDatabaseGetAllResultSinkPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBDatabaseGetAllResultSink,
                                                   handleOrPtrInfo);
  }

  function IDBDatabaseGetAllResultSinkAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBDatabaseGetAllResultSink, associatedInterfacePtrInfo);
  }

  IDBDatabaseGetAllResultSinkAssociatedPtr.prototype =
      Object.create(IDBDatabaseGetAllResultSinkPtr.prototype);
  IDBDatabaseGetAllResultSinkAssociatedPtr.prototype.constructor =
      IDBDatabaseGetAllResultSinkAssociatedPtr;

  function IDBDatabaseGetAllResultSinkProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBDatabaseGetAllResultSinkPtr.prototype.receiveResults = function() {
    return IDBDatabaseGetAllResultSinkProxy.prototype.receiveResults
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseGetAllResultSinkProxy.prototype.receiveResults = function(records, done) {
    var params_ = new IDBDatabaseGetAllResultSink_ReceiveResults_Params();
    params_.records = records;
    params_.done = done;
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseGetAllResultSink_ReceiveResults_Name,
        codec.align(IDBDatabaseGetAllResultSink_ReceiveResults_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseGetAllResultSink_ReceiveResults_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabaseGetAllResultSinkPtr.prototype.onError = function() {
    return IDBDatabaseGetAllResultSinkProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseGetAllResultSinkProxy.prototype.onError = function(error) {
    var params_ = new IDBDatabaseGetAllResultSink_OnError_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kIDBDatabaseGetAllResultSink_OnError_Name,
        codec.align(IDBDatabaseGetAllResultSink_OnError_Params.encodedSize));
    builder.encodeStruct(IDBDatabaseGetAllResultSink_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBDatabaseGetAllResultSinkStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBDatabaseGetAllResultSinkStub.prototype.receiveResults = function(records, done) {
    return this.delegate_ && this.delegate_.receiveResults && this.delegate_.receiveResults(records, done);
  }
  IDBDatabaseGetAllResultSinkStub.prototype.onError = function(error) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error);
  }

  IDBDatabaseGetAllResultSinkStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBDatabaseGetAllResultSink_ReceiveResults_Name:
      var params = reader.decodeStruct(IDBDatabaseGetAllResultSink_ReceiveResults_Params);
      this.receiveResults(params.records, params.done);
      return true;
    case kIDBDatabaseGetAllResultSink_OnError_Name:
      var params = reader.decodeStruct(IDBDatabaseGetAllResultSink_OnError_Params);
      this.onError(params.error);
      return true;
    default:
      return false;
    }
  };

  IDBDatabaseGetAllResultSinkStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateIDBDatabaseGetAllResultSinkRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBDatabaseGetAllResultSink_ReceiveResults_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseGetAllResultSink_ReceiveResults_Params;
      break;
      case kIDBDatabaseGetAllResultSink_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabaseGetAllResultSink_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBDatabaseGetAllResultSinkResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var IDBDatabaseGetAllResultSink = {
    name: 'blink.mojom.IDBDatabaseGetAllResultSink',
    kVersion: 0,
    ptrClass: IDBDatabaseGetAllResultSinkPtr,
    proxyClass: IDBDatabaseGetAllResultSinkProxy,
    stubClass: IDBDatabaseGetAllResultSinkStub,
    validateRequest: validateIDBDatabaseGetAllResultSinkRequest,
    validateResponse: null,
  };
  IDBDatabaseGetAllResultSinkStub.prototype.validator = validateIDBDatabaseGetAllResultSinkRequest;
  IDBDatabaseGetAllResultSinkProxy.prototype.validator = null;
  var kIDBDatabase_RenameObjectStore_Name = 0;
  var kIDBDatabase_CreateTransaction_Name = 1;
  var kIDBDatabase_VersionChangeIgnored_Name = 2;
  var kIDBDatabase_Get_Name = 3;
  var kIDBDatabase_GetAll_Name = 4;
  var kIDBDatabase_OpenCursor_Name = 5;
  var kIDBDatabase_Count_Name = 6;
  var kIDBDatabase_DeleteRange_Name = 7;
  var kIDBDatabase_GetKeyGeneratorCurrentNumber_Name = 8;
  var kIDBDatabase_Clear_Name = 9;
  var kIDBDatabase_CreateIndex_Name = 10;
  var kIDBDatabase_DeleteIndex_Name = 11;
  var kIDBDatabase_RenameIndex_Name = 12;
  var kIDBDatabase_Abort_Name = 13;
  var kIDBDatabase_DidBecomeInactive_Name = 14;
  var kIDBDatabase_UpdatePriority_Name = 15;

  function IDBDatabasePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBDatabase,
                                                   handleOrPtrInfo);
  }

  function IDBDatabaseAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBDatabase, associatedInterfacePtrInfo);
  }

  IDBDatabaseAssociatedPtr.prototype =
      Object.create(IDBDatabasePtr.prototype);
  IDBDatabaseAssociatedPtr.prototype.constructor =
      IDBDatabaseAssociatedPtr;

  function IDBDatabaseProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBDatabasePtr.prototype.renameObjectStore = function() {
    return IDBDatabaseProxy.prototype.renameObjectStore
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.renameObjectStore = function(transactionId, objectStoreId, newName) {
    var params_ = new IDBDatabase_RenameObjectStore_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.newName = newName;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_RenameObjectStore_Name,
        codec.align(IDBDatabase_RenameObjectStore_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_RenameObjectStore_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.createTransaction = function() {
    return IDBDatabaseProxy.prototype.createTransaction
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.createTransaction = function(transactionReceiver, transactionId, objectStoreIds, mode, durability) {
    var params_ = new IDBDatabase_CreateTransaction_Params();
    params_.transactionReceiver = transactionReceiver;
    params_.transactionId = transactionId;
    params_.objectStoreIds = objectStoreIds;
    params_.mode = mode;
    params_.durability = durability;
    var builder = new codec.MessageV2Builder(
        kIDBDatabase_CreateTransaction_Name,
        codec.align(IDBDatabase_CreateTransaction_Params.encodedSize));
    builder.setPayload(IDBDatabase_CreateTransaction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.versionChangeIgnored = function() {
    return IDBDatabaseProxy.prototype.versionChangeIgnored
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.versionChangeIgnored = function() {
    var params_ = new IDBDatabase_VersionChangeIgnored_Params();
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_VersionChangeIgnored_Name,
        codec.align(IDBDatabase_VersionChangeIgnored_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_VersionChangeIgnored_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.get = function() {
    return IDBDatabaseProxy.prototype.get
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.get = function(transactionId, objectStoreId, indexId, keyRange, keyOnly) {
    var params_ = new IDBDatabase_Get_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    params_.keyRange = keyRange;
    params_.keyOnly = keyOnly;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBDatabase_Get_Name,
          codec.align(IDBDatabase_Get_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBDatabase_Get_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_Get_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.getAll = function() {
    return IDBDatabaseProxy.prototype.getAll
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.getAll = function(transactionId, objectStoreId, indexId, keyRange, resultType, maxCount, direction) {
    var params_ = new IDBDatabase_GetAll_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    params_.keyRange = keyRange;
    params_.resultType = resultType;
    params_.maxCount = maxCount;
    params_.direction = direction;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kIDBDatabase_GetAll_Name,
          codec.align(IDBDatabase_GetAll_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(IDBDatabase_GetAll_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_GetAll_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.openCursor = function() {
    return IDBDatabaseProxy.prototype.openCursor
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.openCursor = function(transactionId, objectStoreId, indexId, keyRange, direction, keyOnly, taskType) {
    var params_ = new IDBDatabase_OpenCursor_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    params_.keyRange = keyRange;
    params_.direction = direction;
    params_.keyOnly = keyOnly;
    params_.taskType = taskType;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kIDBDatabase_OpenCursor_Name,
          codec.align(IDBDatabase_OpenCursor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(IDBDatabase_OpenCursor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_OpenCursor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.count = function() {
    return IDBDatabaseProxy.prototype.count
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.count = function(transactionId, objectStoreId, indexId, keyRange) {
    var params_ = new IDBDatabase_Count_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    params_.keyRange = keyRange;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBDatabase_Count_Name,
          codec.align(IDBDatabase_Count_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBDatabase_Count_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_Count_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.deleteRange = function() {
    return IDBDatabaseProxy.prototype.deleteRange
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.deleteRange = function(transactionId, objectStoreId, keyRange) {
    var params_ = new IDBDatabase_DeleteRange_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.keyRange = keyRange;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBDatabase_DeleteRange_Name,
          codec.align(IDBDatabase_DeleteRange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBDatabase_DeleteRange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_DeleteRange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.getKeyGeneratorCurrentNumber = function() {
    return IDBDatabaseProxy.prototype.getKeyGeneratorCurrentNumber
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.getKeyGeneratorCurrentNumber = function(transactionId, objectStoreId) {
    var params_ = new IDBDatabase_GetKeyGeneratorCurrentNumber_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBDatabase_GetKeyGeneratorCurrentNumber_Name,
          codec.align(IDBDatabase_GetKeyGeneratorCurrentNumber_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBDatabase_GetKeyGeneratorCurrentNumber_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.clear = function() {
    return IDBDatabaseProxy.prototype.clear
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.clear = function(transactionId, objectStoreId) {
    var params_ = new IDBDatabase_Clear_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBDatabase_Clear_Name,
          codec.align(IDBDatabase_Clear_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBDatabase_Clear_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBDatabase_Clear_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBDatabasePtr.prototype.createIndex = function() {
    return IDBDatabaseProxy.prototype.createIndex
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.createIndex = function(transactionId, objectStoreId, index) {
    var params_ = new IDBDatabase_CreateIndex_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.index = index;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_CreateIndex_Name,
        codec.align(IDBDatabase_CreateIndex_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_CreateIndex_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.deleteIndex = function() {
    return IDBDatabaseProxy.prototype.deleteIndex
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.deleteIndex = function(transactionId, objectStoreId, indexId) {
    var params_ = new IDBDatabase_DeleteIndex_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_DeleteIndex_Name,
        codec.align(IDBDatabase_DeleteIndex_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_DeleteIndex_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.renameIndex = function() {
    return IDBDatabaseProxy.prototype.renameIndex
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.renameIndex = function(transactionId, objectStoreId, indexId, newName) {
    var params_ = new IDBDatabase_RenameIndex_Params();
    params_.transactionId = transactionId;
    params_.objectStoreId = objectStoreId;
    params_.indexId = indexId;
    params_.newName = newName;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_RenameIndex_Name,
        codec.align(IDBDatabase_RenameIndex_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_RenameIndex_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.abort = function() {
    return IDBDatabaseProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.abort = function(transactionId) {
    var params_ = new IDBDatabase_Abort_Params();
    params_.transactionId = transactionId;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_Abort_Name,
        codec.align(IDBDatabase_Abort_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_Abort_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.didBecomeInactive = function() {
    return IDBDatabaseProxy.prototype.didBecomeInactive
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.didBecomeInactive = function() {
    var params_ = new IDBDatabase_DidBecomeInactive_Params();
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_DidBecomeInactive_Name,
        codec.align(IDBDatabase_DidBecomeInactive_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_DidBecomeInactive_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBDatabasePtr.prototype.updatePriority = function() {
    return IDBDatabaseProxy.prototype.updatePriority
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBDatabaseProxy.prototype.updatePriority = function(newPriority) {
    var params_ = new IDBDatabase_UpdatePriority_Params();
    params_.newPriority = newPriority;
    var builder = new codec.MessageV0Builder(
        kIDBDatabase_UpdatePriority_Name,
        codec.align(IDBDatabase_UpdatePriority_Params.encodedSize));
    builder.encodeStruct(IDBDatabase_UpdatePriority_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBDatabaseStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBDatabaseStub.prototype.renameObjectStore = function(transactionId, objectStoreId, newName) {
    return this.delegate_ && this.delegate_.renameObjectStore && this.delegate_.renameObjectStore(transactionId, objectStoreId, newName);
  }
  IDBDatabaseStub.prototype.createTransaction = function(transactionReceiver, transactionId, objectStoreIds, mode, durability) {
    return this.delegate_ && this.delegate_.createTransaction && this.delegate_.createTransaction(transactionReceiver, transactionId, objectStoreIds, mode, durability);
  }
  IDBDatabaseStub.prototype.versionChangeIgnored = function() {
    return this.delegate_ && this.delegate_.versionChangeIgnored && this.delegate_.versionChangeIgnored();
  }
  IDBDatabaseStub.prototype.get = function(transactionId, objectStoreId, indexId, keyRange, keyOnly) {
    return this.delegate_ && this.delegate_.get && this.delegate_.get(transactionId, objectStoreId, indexId, keyRange, keyOnly);
  }
  IDBDatabaseStub.prototype.getAll = function(transactionId, objectStoreId, indexId, keyRange, resultType, maxCount, direction) {
    return this.delegate_ && this.delegate_.getAll && this.delegate_.getAll(transactionId, objectStoreId, indexId, keyRange, resultType, maxCount, direction);
  }
  IDBDatabaseStub.prototype.openCursor = function(transactionId, objectStoreId, indexId, keyRange, direction, keyOnly, taskType) {
    return this.delegate_ && this.delegate_.openCursor && this.delegate_.openCursor(transactionId, objectStoreId, indexId, keyRange, direction, keyOnly, taskType);
  }
  IDBDatabaseStub.prototype.count = function(transactionId, objectStoreId, indexId, keyRange) {
    return this.delegate_ && this.delegate_.count && this.delegate_.count(transactionId, objectStoreId, indexId, keyRange);
  }
  IDBDatabaseStub.prototype.deleteRange = function(transactionId, objectStoreId, keyRange) {
    return this.delegate_ && this.delegate_.deleteRange && this.delegate_.deleteRange(transactionId, objectStoreId, keyRange);
  }
  IDBDatabaseStub.prototype.getKeyGeneratorCurrentNumber = function(transactionId, objectStoreId) {
    return this.delegate_ && this.delegate_.getKeyGeneratorCurrentNumber && this.delegate_.getKeyGeneratorCurrentNumber(transactionId, objectStoreId);
  }
  IDBDatabaseStub.prototype.clear = function(transactionId, objectStoreId) {
    return this.delegate_ && this.delegate_.clear && this.delegate_.clear(transactionId, objectStoreId);
  }
  IDBDatabaseStub.prototype.createIndex = function(transactionId, objectStoreId, index) {
    return this.delegate_ && this.delegate_.createIndex && this.delegate_.createIndex(transactionId, objectStoreId, index);
  }
  IDBDatabaseStub.prototype.deleteIndex = function(transactionId, objectStoreId, indexId) {
    return this.delegate_ && this.delegate_.deleteIndex && this.delegate_.deleteIndex(transactionId, objectStoreId, indexId);
  }
  IDBDatabaseStub.prototype.renameIndex = function(transactionId, objectStoreId, indexId, newName) {
    return this.delegate_ && this.delegate_.renameIndex && this.delegate_.renameIndex(transactionId, objectStoreId, indexId, newName);
  }
  IDBDatabaseStub.prototype.abort = function(transactionId) {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort(transactionId);
  }
  IDBDatabaseStub.prototype.didBecomeInactive = function() {
    return this.delegate_ && this.delegate_.didBecomeInactive && this.delegate_.didBecomeInactive();
  }
  IDBDatabaseStub.prototype.updatePriority = function(newPriority) {
    return this.delegate_ && this.delegate_.updatePriority && this.delegate_.updatePriority(newPriority);
  }

  IDBDatabaseStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBDatabase_RenameObjectStore_Name:
      var params = reader.decodeStruct(IDBDatabase_RenameObjectStore_Params);
      this.renameObjectStore(params.transactionId, params.objectStoreId, params.newName);
      return true;
    case kIDBDatabase_CreateTransaction_Name:
      var params = reader.decodeStruct(IDBDatabase_CreateTransaction_Params);
      this.createTransaction(params.transactionReceiver, params.transactionId, params.objectStoreIds, params.mode, params.durability);
      return true;
    case kIDBDatabase_VersionChangeIgnored_Name:
      var params = reader.decodeStruct(IDBDatabase_VersionChangeIgnored_Params);
      this.versionChangeIgnored();
      return true;
    case kIDBDatabase_CreateIndex_Name:
      var params = reader.decodeStruct(IDBDatabase_CreateIndex_Params);
      this.createIndex(params.transactionId, params.objectStoreId, params.index);
      return true;
    case kIDBDatabase_DeleteIndex_Name:
      var params = reader.decodeStruct(IDBDatabase_DeleteIndex_Params);
      this.deleteIndex(params.transactionId, params.objectStoreId, params.indexId);
      return true;
    case kIDBDatabase_RenameIndex_Name:
      var params = reader.decodeStruct(IDBDatabase_RenameIndex_Params);
      this.renameIndex(params.transactionId, params.objectStoreId, params.indexId, params.newName);
      return true;
    case kIDBDatabase_Abort_Name:
      var params = reader.decodeStruct(IDBDatabase_Abort_Params);
      this.abort(params.transactionId);
      return true;
    case kIDBDatabase_DidBecomeInactive_Name:
      var params = reader.decodeStruct(IDBDatabase_DidBecomeInactive_Params);
      this.didBecomeInactive();
      return true;
    case kIDBDatabase_UpdatePriority_Name:
      var params = reader.decodeStruct(IDBDatabase_UpdatePriority_Params);
      this.updatePriority(params.newPriority);
      return true;
    default:
      return false;
    }
  };

  IDBDatabaseStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBDatabase_Get_Name:
      var params = reader.decodeStruct(IDBDatabase_Get_Params);
      this.get(params.transactionId, params.objectStoreId, params.indexId, params.keyRange, params.keyOnly).then(function(response) {
        var responseParams =
            new IDBDatabase_Get_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kIDBDatabase_Get_Name,
            codec.align(IDBDatabase_Get_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBDatabase_Get_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_GetAll_Name:
      var params = reader.decodeStruct(IDBDatabase_GetAll_Params);
      this.getAll(params.transactionId, params.objectStoreId, params.indexId, params.keyRange, params.resultType, params.maxCount, params.direction).then(function(response) {
        var responseParams =
            new IDBDatabase_GetAll_ResponseParams();
        responseParams.receiver = response.receiver;
        var builder = new codec.MessageV2Builder(
            kIDBDatabase_GetAll_Name,
            codec.align(IDBDatabase_GetAll_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(IDBDatabase_GetAll_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_OpenCursor_Name:
      var params = reader.decodeStruct(IDBDatabase_OpenCursor_Params);
      this.openCursor(params.transactionId, params.objectStoreId, params.indexId, params.keyRange, params.direction, params.keyOnly, params.taskType).then(function(response) {
        var responseParams =
            new IDBDatabase_OpenCursor_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kIDBDatabase_OpenCursor_Name,
            codec.align(IDBDatabase_OpenCursor_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(IDBDatabase_OpenCursor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_Count_Name:
      var params = reader.decodeStruct(IDBDatabase_Count_Params);
      this.count(params.transactionId, params.objectStoreId, params.indexId, params.keyRange).then(function(response) {
        var responseParams =
            new IDBDatabase_Count_ResponseParams();
        responseParams.success = response.success;
        responseParams.count = response.count;
        var builder = new codec.MessageV1Builder(
            kIDBDatabase_Count_Name,
            codec.align(IDBDatabase_Count_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBDatabase_Count_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_DeleteRange_Name:
      var params = reader.decodeStruct(IDBDatabase_DeleteRange_Params);
      this.deleteRange(params.transactionId, params.objectStoreId, params.keyRange).then(function(response) {
        var responseParams =
            new IDBDatabase_DeleteRange_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kIDBDatabase_DeleteRange_Name,
            codec.align(IDBDatabase_DeleteRange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBDatabase_DeleteRange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_GetKeyGeneratorCurrentNumber_Name:
      var params = reader.decodeStruct(IDBDatabase_GetKeyGeneratorCurrentNumber_Params);
      this.getKeyGeneratorCurrentNumber(params.transactionId, params.objectStoreId).then(function(response) {
        var responseParams =
            new IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams();
        responseParams.result = response.result;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kIDBDatabase_GetKeyGeneratorCurrentNumber_Name,
            codec.align(IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kIDBDatabase_Clear_Name:
      var params = reader.decodeStruct(IDBDatabase_Clear_Params);
      this.clear(params.transactionId, params.objectStoreId).then(function(response) {
        var responseParams =
            new IDBDatabase_Clear_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kIDBDatabase_Clear_Name,
            codec.align(IDBDatabase_Clear_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBDatabase_Clear_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateIDBDatabaseRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBDatabase_RenameObjectStore_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_RenameObjectStore_Params;
      break;
      case kIDBDatabase_CreateTransaction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_CreateTransaction_Params;
      break;
      case kIDBDatabase_VersionChangeIgnored_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_VersionChangeIgnored_Params;
      break;
      case kIDBDatabase_Get_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_Get_Params;
      break;
      case kIDBDatabase_GetAll_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_GetAll_Params;
      break;
      case kIDBDatabase_OpenCursor_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_OpenCursor_Params;
      break;
      case kIDBDatabase_Count_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_Count_Params;
      break;
      case kIDBDatabase_DeleteRange_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_DeleteRange_Params;
      break;
      case kIDBDatabase_GetKeyGeneratorCurrentNumber_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_GetKeyGeneratorCurrentNumber_Params;
      break;
      case kIDBDatabase_Clear_Name:
        if (message.expectsResponse())
          paramsClass = IDBDatabase_Clear_Params;
      break;
      case kIDBDatabase_CreateIndex_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_CreateIndex_Params;
      break;
      case kIDBDatabase_DeleteIndex_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_DeleteIndex_Params;
      break;
      case kIDBDatabase_RenameIndex_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_RenameIndex_Params;
      break;
      case kIDBDatabase_Abort_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_Abort_Params;
      break;
      case kIDBDatabase_DidBecomeInactive_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_DidBecomeInactive_Params;
      break;
      case kIDBDatabase_UpdatePriority_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBDatabase_UpdatePriority_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBDatabaseResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kIDBDatabase_Get_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_Get_ResponseParams;
        break;
      case kIDBDatabase_GetAll_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_GetAll_ResponseParams;
        break;
      case kIDBDatabase_OpenCursor_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_OpenCursor_ResponseParams;
        break;
      case kIDBDatabase_Count_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_Count_ResponseParams;
        break;
      case kIDBDatabase_DeleteRange_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_DeleteRange_ResponseParams;
        break;
      case kIDBDatabase_GetKeyGeneratorCurrentNumber_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams;
        break;
      case kIDBDatabase_Clear_Name:
        if (message.isResponse())
          paramsClass = IDBDatabase_Clear_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var IDBDatabase = {
    name: 'blink.mojom.IDBDatabase',
    kVersion: 0,
    ptrClass: IDBDatabasePtr,
    proxyClass: IDBDatabaseProxy,
    stubClass: IDBDatabaseStub,
    validateRequest: validateIDBDatabaseRequest,
    validateResponse: validateIDBDatabaseResponse,
  };
  IDBDatabaseStub.prototype.validator = validateIDBDatabaseRequest;
  IDBDatabaseProxy.prototype.validator = validateIDBDatabaseResponse;
  var kIDBFactory_GetDatabaseInfo_Name = 0;
  var kIDBFactory_Open_Name = 1;
  var kIDBFactory_DeleteDatabase_Name = 2;

  function IDBFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(IDBFactory,
                                                   handleOrPtrInfo);
  }

  function IDBFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        IDBFactory, associatedInterfacePtrInfo);
  }

  IDBFactoryAssociatedPtr.prototype =
      Object.create(IDBFactoryPtr.prototype);
  IDBFactoryAssociatedPtr.prototype.constructor =
      IDBFactoryAssociatedPtr;

  function IDBFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  IDBFactoryPtr.prototype.getDatabaseInfo = function() {
    return IDBFactoryProxy.prototype.getDatabaseInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryProxy.prototype.getDatabaseInfo = function() {
    var params_ = new IDBFactory_GetDatabaseInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kIDBFactory_GetDatabaseInfo_Name,
          codec.align(IDBFactory_GetDatabaseInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(IDBFactory_GetDatabaseInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(IDBFactory_GetDatabaseInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  IDBFactoryPtr.prototype.open = function() {
    return IDBFactoryProxy.prototype.open
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryProxy.prototype.open = function(client, databaseCallbacks, name, version, versionChangeTransactionReceiver, transactionId, priority) {
    var params_ = new IDBFactory_Open_Params();
    params_.client = client;
    params_.databaseCallbacks = databaseCallbacks;
    params_.name = name;
    params_.version = version;
    params_.versionChangeTransactionReceiver = versionChangeTransactionReceiver;
    params_.transactionId = transactionId;
    params_.priority = priority;
    var builder = new codec.MessageV2Builder(
        kIDBFactory_Open_Name,
        codec.align(IDBFactory_Open_Params.encodedSize));
    builder.setPayload(IDBFactory_Open_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  IDBFactoryPtr.prototype.deleteDatabase = function() {
    return IDBFactoryProxy.prototype.deleteDatabase
        .apply(this.ptr.getProxy(), arguments);
  };

  IDBFactoryProxy.prototype.deleteDatabase = function(client, name, forceClose) {
    var params_ = new IDBFactory_DeleteDatabase_Params();
    params_.client = client;
    params_.name = name;
    params_.forceClose = forceClose;
    var builder = new codec.MessageV2Builder(
        kIDBFactory_DeleteDatabase_Name,
        codec.align(IDBFactory_DeleteDatabase_Params.encodedSize));
    builder.setPayload(IDBFactory_DeleteDatabase_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function IDBFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  IDBFactoryStub.prototype.getDatabaseInfo = function() {
    return this.delegate_ && this.delegate_.getDatabaseInfo && this.delegate_.getDatabaseInfo();
  }
  IDBFactoryStub.prototype.open = function(client, databaseCallbacks, name, version, versionChangeTransactionReceiver, transactionId, priority) {
    return this.delegate_ && this.delegate_.open && this.delegate_.open(client, databaseCallbacks, name, version, versionChangeTransactionReceiver, transactionId, priority);
  }
  IDBFactoryStub.prototype.deleteDatabase = function(client, name, forceClose) {
    return this.delegate_ && this.delegate_.deleteDatabase && this.delegate_.deleteDatabase(client, name, forceClose);
  }

  IDBFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBFactory_Open_Name:
      var params = reader.decodeStruct(IDBFactory_Open_Params);
      this.open(params.client, params.databaseCallbacks, params.name, params.version, params.versionChangeTransactionReceiver, params.transactionId, params.priority);
      return true;
    case kIDBFactory_DeleteDatabase_Name:
      var params = reader.decodeStruct(IDBFactory_DeleteDatabase_Params);
      this.deleteDatabase(params.client, params.name, params.forceClose);
      return true;
    default:
      return false;
    }
  };

  IDBFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kIDBFactory_GetDatabaseInfo_Name:
      var params = reader.decodeStruct(IDBFactory_GetDatabaseInfo_Params);
      this.getDatabaseInfo().then(function(response) {
        var responseParams =
            new IDBFactory_GetDatabaseInfo_ResponseParams();
        responseParams.namesAndVersions = response.namesAndVersions;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kIDBFactory_GetDatabaseInfo_Name,
            codec.align(IDBFactory_GetDatabaseInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(IDBFactory_GetDatabaseInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateIDBFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kIDBFactory_GetDatabaseInfo_Name:
        if (message.expectsResponse())
          paramsClass = IDBFactory_GetDatabaseInfo_Params;
      break;
      case kIDBFactory_Open_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactory_Open_Params;
      break;
      case kIDBFactory_DeleteDatabase_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = IDBFactory_DeleteDatabase_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateIDBFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kIDBFactory_GetDatabaseInfo_Name:
        if (message.isResponse())
          paramsClass = IDBFactory_GetDatabaseInfo_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var IDBFactory = {
    name: 'blink.mojom.IDBFactory',
    kVersion: 0,
    ptrClass: IDBFactoryPtr,
    proxyClass: IDBFactoryProxy,
    stubClass: IDBFactoryStub,
    validateRequest: validateIDBFactoryRequest,
    validateResponse: validateIDBFactoryResponse,
  };
  IDBFactoryStub.prototype.validator = validateIDBFactoryRequest;
  IDBFactoryProxy.prototype.validator = validateIDBFactoryResponse;
  exports.IDB_MAX_MESSAGE_SIZE = IDB_MAX_MESSAGE_SIZE;
  exports.IDB_MAX_MESSAGE_OVERHEAD = IDB_MAX_MESSAGE_OVERHEAD;
  exports.IDB_WRAP_THRESHOLD = IDB_WRAP_THRESHOLD;
  exports.IDB_GET_ALL_CHUNK_SIZE = IDB_GET_ALL_CHUNK_SIZE;
  exports.IDBCursorDirection = IDBCursorDirection;
  exports.IDBDataLoss = IDBDataLoss;
  exports.IDBKeyType = IDBKeyType;
  exports.IDBTransactionDurability = IDBTransactionDurability;
  exports.IDBGetAllResultType = IDBGetAllResultType;
  exports.IDBKeyPathType = IDBKeyPathType;
  exports.IDBOperationType = IDBOperationType;
  exports.IDBPutMode = IDBPutMode;
  exports.IDBTaskType = IDBTaskType;
  exports.IDBTransactionMode = IDBTransactionMode;
  exports.IDBException = IDBException;
  exports.IDBKeyPath = IDBKeyPath;
  exports.IDBKeyRange = IDBKeyRange;
  exports.IDBIndexMetadata = IDBIndexMetadata;
  exports.IDBObjectStoreMetadata = IDBObjectStoreMetadata;
  exports.IDBDatabaseMetadata = IDBDatabaseMetadata;
  exports.IDBNameAndVersion = IDBNameAndVersion;
  exports.IDBIndexKeys = IDBIndexKeys;
  exports.IDBFileInfo = IDBFileInfo;
  exports.IDBBlobInfo = IDBBlobInfo;
  exports.IDBValue = IDBValue;
  exports.IDBReturnValue = IDBReturnValue;
  exports.IDBRecord = IDBRecord;
  exports.IDBError = IDBError;
  exports.IDBCursorValue = IDBCursorValue;
  exports.IDBDatabaseOpenCursorValue = IDBDatabaseOpenCursorValue;
  exports.IDBKey = IDBKey;
  exports.IDBKeyPathData = IDBKeyPathData;
  exports.IDBExternalObject = IDBExternalObject;
  exports.IDBCursorResult = IDBCursorResult;
  exports.IDBTransactionPutResult = IDBTransactionPutResult;
  exports.IDBDatabaseGetResult = IDBDatabaseGetResult;
  exports.IDBDatabaseOpenCursorResult = IDBDatabaseOpenCursorResult;
  exports.IDBFactoryClient = IDBFactoryClient;
  exports.IDBFactoryClientPtr = IDBFactoryClientPtr;
  exports.IDBFactoryClientAssociatedPtr = IDBFactoryClientAssociatedPtr;
  exports.IDBDatabaseCallbacks = IDBDatabaseCallbacks;
  exports.IDBDatabaseCallbacksPtr = IDBDatabaseCallbacksPtr;
  exports.IDBDatabaseCallbacksAssociatedPtr = IDBDatabaseCallbacksAssociatedPtr;
  exports.IDBCursor = IDBCursor;
  exports.IDBCursorPtr = IDBCursorPtr;
  exports.IDBCursorAssociatedPtr = IDBCursorAssociatedPtr;
  exports.IDBTransaction = IDBTransaction;
  exports.IDBTransactionPtr = IDBTransactionPtr;
  exports.IDBTransactionAssociatedPtr = IDBTransactionAssociatedPtr;
  exports.IDBDatabaseGetAllResultSink = IDBDatabaseGetAllResultSink;
  exports.IDBDatabaseGetAllResultSinkPtr = IDBDatabaseGetAllResultSinkPtr;
  exports.IDBDatabaseGetAllResultSinkAssociatedPtr = IDBDatabaseGetAllResultSinkAssociatedPtr;
  exports.IDBDatabase = IDBDatabase;
  exports.IDBDatabasePtr = IDBDatabasePtr;
  exports.IDBDatabaseAssociatedPtr = IDBDatabaseAssociatedPtr;
  exports.IDBFactory = IDBFactory;
  exports.IDBFactoryPtr = IDBFactoryPtr;
  exports.IDBFactoryAssociatedPtr = IDBFactoryAssociatedPtr;
})();