// third_party/blink/public/mojom/indexeddb/indexeddb.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from '../blob/blob.mojom.m.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from '../file_system_access/file_system_access_transfer_token.mojom.m.js';


/**
 * @const { !number }
 */
export const IDB_MAX_MESSAGE_SIZE = 134217728;


/**
 * @const { !number }
 */
export const IDB_MAX_MESSAGE_OVERHEAD = 1048576;


/**
 * @const { !number }
 */
export const IDB_WRAP_THRESHOLD = 65536;


/**
 * @const { !number }
 */
export const IDB_GET_ALL_CHUNK_SIZE = 1000;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBCursorDirectionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBCursorDirection = {
  
  Next: 0,
  NextNoDuplicate: 1,
  Prev: 2,
  PrevNoDuplicate: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBDataLossSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBDataLoss = {
  
  None: 0,
  Total: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBKeyTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBKeyType = {
  
  Invalid: 0,
  Array: 1,
  Binary: 2,
  String: 3,
  Date: 4,
  Number: 5,
  None: 6,
  Min: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBTransactionDurabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBTransactionDurability = {
  
  Default: 0,
  Strict: 1,
  Relaxed: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBGetAllResultTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBGetAllResultType = {
  
  Keys: 0,
  Values: 1,
  Records: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBKeyPathTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBKeyPathType = {
  
  Null: 0,
  String: 1,
  Array: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBOperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBOperationType = {
  
  Add: 0,
  Put: 1,
  Delete: 2,
  Clear: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBPutModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBPutMode = {
  
  AddOrUpdate: 0,
  AddOnly: 1,
  CursorUpdate: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBTaskTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBTaskType = {
  
  Normal: 0,
  Preemptive: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBTransactionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBTransactionMode = {
  
  ReadOnly: 0,
  ReadWrite: 1,
  VersionChange: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IDBExceptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IDBException = {
  
  kNoError: 0,
  kUnknownError: 28,
  kConstraintError: 29,
  kDataError: 30,
  kVersionError: 33,
  kAbortError: 20,
  kIgnorableAbortError: 11,
  kQuotaError: 22,
  kTimeoutError: 23,
  MIN_VALUE: 0,
  MAX_VALUE: 33,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBFactoryClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBFactoryClient', scope);
  }
}

/** @interface */
export class IDBFactoryClientInterface {
  
  /**
   * @param { !IDBException } code
   * @param { !mojoBase_mojom_String16 } message
   */

  error(code, message) {}
  
  /**
   * @param { !bigint } existingVersion
   */

  blocked(existingVersion) {}
  
  /**
   * @param { !Object } pendingDatabase
   * @param { !bigint } oldVersion
   * @param { !IDBDataLoss } dataLoss
   * @param { !string } dataLossMessage
   * @param { !IDBDatabaseMetadata } dbMetadata
   */

  upgradeNeeded(pendingDatabase, oldVersion, dataLoss, dataLossMessage, dbMetadata) {}
  
  /**
   * @param { ?Object } pendingDatabase
   * @param { !IDBDatabaseMetadata } metadata
   */

  openSuccess(pendingDatabase, metadata) {}
  
  /**
   * @param { !bigint } oldVersion
   */

  deleteSuccess(oldVersion) {}
}

/**
 * @implements { IDBFactoryClientInterface }
 */
export class IDBFactoryClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !IDBException } code
   * @param { !mojoBase_mojom_String16 } message
   */

  error(
      code,
      message) {
    this.proxy.sendMessage(
        0,
        IDBFactoryClient_Error_ParamsSpec.$,
        null,
        [
          code,
          message
        ],
        false);
  }

  
  /**
   * @param { !bigint } existingVersion
   */

  blocked(
      existingVersion) {
    this.proxy.sendMessage(
        1,
        IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        [
          existingVersion
        ],
        false);
  }

  
  /**
   * @param { !Object } pendingDatabase
   * @param { !bigint } oldVersion
   * @param { !IDBDataLoss } dataLoss
   * @param { !string } dataLossMessage
   * @param { !IDBDatabaseMetadata } dbMetadata
   */

  upgradeNeeded(
      pendingDatabase,
      oldVersion,
      dataLoss,
      dataLossMessage,
      dbMetadata) {
    this.proxy.sendMessage(
        2,
        IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        [
          pendingDatabase,
          oldVersion,
          dataLoss,
          dataLossMessage,
          dbMetadata
        ],
        false);
  }

  
  /**
   * @param { ?Object } pendingDatabase
   * @param { !IDBDatabaseMetadata } metadata
   */

  openSuccess(
      pendingDatabase,
      metadata) {
    this.proxy.sendMessage(
        3,
        IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        [
          pendingDatabase,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !bigint } oldVersion
   */

  deleteSuccess(
      oldVersion) {
    this.proxy.sendMessage(
        4,
        IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        [
          oldVersion
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBFactoryClientReceiver {
  /**
   * @param {!IDBFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBFactoryClient_Error_ParamsSpec.$,
        null,
        impl.error.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        impl.blocked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        impl.upgradeNeeded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        impl.openSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        impl.deleteSuccess.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBFactoryClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBFactoryClientRemote}
   */
  static getRemote() {
    let remote = new IDBFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBFactoryClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.error =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBFactoryClient_Error_ParamsSpec.$,
        null,
        this.error.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blocked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBFactoryClient_Blocked_ParamsSpec.$,
        null,
        this.blocked.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeNeeded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
        null,
        this.upgradeNeeded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IDBFactoryClient_OpenSuccess_ParamsSpec.$,
        null,
        this.openSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
        null,
        this.deleteSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBDatabaseCallbacksPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBDatabaseCallbacks', scope);
  }
}

/** @interface */
export class IDBDatabaseCallbacksInterface {
  
  /**
   */

  forcedClose() {}
  
  /**
   * @param { !bigint } oldVersion
   * @param { !bigint } newVersion
   */

  versionChange(oldVersion, newVersion) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !IDBException } code
   * @param { !mojoBase_mojom_String16 } message
   */

  abort(transactionId, code, message) {}
  
  /**
   * @param { !bigint } transactionId
   */

  complete(transactionId) {}
}

/**
 * @implements { IDBDatabaseCallbacksInterface }
 */
export class IDBDatabaseCallbacksRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBDatabaseCallbacksPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBDatabaseCallbacksPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBDatabaseCallbacksPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  forcedClose() {
    this.proxy.sendMessage(
        0,
        IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } oldVersion
   * @param { !bigint } newVersion
   */

  versionChange(
      oldVersion,
      newVersion) {
    this.proxy.sendMessage(
        1,
        IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        [
          oldVersion,
          newVersion
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !IDBException } code
   * @param { !mojoBase_mojom_String16 } message
   */

  abort(
      transactionId,
      code,
      message) {
    this.proxy.sendMessage(
        2,
        IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        [
          transactionId,
          code,
          message
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   */

  complete(
      transactionId) {
    this.proxy.sendMessage(
        3,
        IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        [
          transactionId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBDatabaseCallbacks
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBDatabaseCallbacksReceiver {
  /**
   * @param {!IDBDatabaseCallbacksInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBDatabaseCallbacksRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBDatabaseCallbacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseCallbacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        impl.forcedClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        impl.versionChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBDatabaseCallbacks {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabaseCallbacks";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBDatabaseCallbacksRemote}
   */
  static getRemote() {
    let remote = new IDBDatabaseCallbacksRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBDatabaseCallbacks
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBDatabaseCallbacksCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBDatabaseCallbacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseCallbacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forcedClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
        null,
        this.forcedClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.versionChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
        null,
        this.versionChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBDatabaseCallbacks_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IDBDatabaseCallbacks_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBCursorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBCursor', scope);
  }
}

/** @interface */
export class IDBCursorInterface {
  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  advance(count) {}
  
  /**
   * @param { !IDBKey } key
   * @param { !IDBKey } primaryKey
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  continue(key, primaryKey) {}
  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  prefetch(count) {}
  
  /**
   * @param { !number } usedPrefetches
   */

  prefetchReset(usedPrefetches) {}
}

/**
 * @implements { IDBCursorInterface }
 */
export class IDBCursorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBCursorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBCursorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBCursorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  advance(
      count) {
    return this.proxy.sendMessage(
        0,
        IDBCursor_Advance_ParamsSpec.$,
        IDBCursor_Advance_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !IDBKey } key
   * @param { !IDBKey } primaryKey
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  continue(
      key,
      primaryKey) {
    return this.proxy.sendMessage(
        1,
        IDBCursor_Continue_ParamsSpec.$,
        IDBCursor_Continue_ResponseParamsSpec.$,
        [
          key,
          primaryKey
        ],
        false);
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        result: !IDBCursorResult,
   *  }>}
   */

  prefetch(
      count) {
    return this.proxy.sendMessage(
        2,
        IDBCursor_Prefetch_ParamsSpec.$,
        IDBCursor_Prefetch_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !number } usedPrefetches
   */

  prefetchReset(
      usedPrefetches) {
    this.proxy.sendMessage(
        3,
        IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        [
          usedPrefetches
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBCursor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBCursorReceiver {
  /**
   * @param {!IDBCursorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBCursorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBCursorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBCursorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBCursor_Advance_ParamsSpec.$,
        IDBCursor_Advance_ResponseParamsSpec.$,
        impl.advance.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBCursor_Continue_ParamsSpec.$,
        IDBCursor_Continue_ResponseParamsSpec.$,
        impl.continue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBCursor_Prefetch_ParamsSpec.$,
        IDBCursor_Prefetch_ResponseParamsSpec.$,
        impl.prefetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        impl.prefetchReset.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBCursor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBCursor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBCursorRemote}
   */
  static getRemote() {
    let remote = new IDBCursorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBCursor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBCursorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBCursorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBCursorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.advance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBCursor_Advance_ParamsSpec.$,
        IDBCursor_Advance_ResponseParamsSpec.$,
        this.advance.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBCursor_Continue_ParamsSpec.$,
        IDBCursor_Continue_ResponseParamsSpec.$,
        this.continue.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBCursor_Prefetch_ParamsSpec.$,
        IDBCursor_Prefetch_ResponseParamsSpec.$,
        this.prefetch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetchReset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IDBCursor_PrefetchReset_ParamsSpec.$,
        null,
        this.prefetchReset.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBTransactionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBTransaction', scope);
  }
}

/** @interface */
export class IDBTransactionInterface {
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !mojoBase_mojom_String16 } name
   * @param { !IDBKeyPath } keyPath
   * @param { !boolean } autoIncrement
   */

  createObjectStore(objectStoreId, name, keyPath, autoIncrement) {}
  
  /**
   * @param { !bigint } objectStoreId
   */

  deleteObjectStore(objectStoreId) {}
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !IDBValue } value
   * @param { !IDBKey } key
   * @param { !IDBPutMode } mode
   * @param { !Array<!IDBIndexKeys> } indexKeys
   * @return {!Promise<{
        result: !IDBTransactionPutResult,
   *  }>}
   */

  put(objectStoreId, value, key, mode, indexKeys) {}
  
  /**
   * @param { !bigint } objectStoreId
   * @param { !IDBKey } primaryKey
   * @param { !IDBIndexKeys } indexKeys
   */

  setIndexKeys(objectStoreId, primaryKey, indexKeys) {}
  
  /**
   */

  setIndexKeysDone() {}
  
  /**
   * @param { !bigint } numErrorsHandled
   */

  commit(numErrorsHandled) {}
}

/**
 * @implements { IDBTransactionInterface }
 */
export class IDBTransactionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBTransactionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBTransactionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBTransactionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !mojoBase_mojom_String16 } name
   * @param { !IDBKeyPath } keyPath
   * @param { !boolean } autoIncrement
   */

  createObjectStore(
      objectStoreId,
      name,
      keyPath,
      autoIncrement) {
    this.proxy.sendMessage(
        0,
        IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        [
          objectStoreId,
          name,
          keyPath,
          autoIncrement
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   */

  deleteObjectStore(
      objectStoreId) {
    this.proxy.sendMessage(
        1,
        IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        [
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !IDBValue } value
   * @param { !IDBKey } key
   * @param { !IDBPutMode } mode
   * @param { !Array<!IDBIndexKeys> } indexKeys
   * @return {!Promise<{
        result: !IDBTransactionPutResult,
   *  }>}
   */

  put(
      objectStoreId,
      value,
      key,
      mode,
      indexKeys) {
    return this.proxy.sendMessage(
        2,
        IDBTransaction_Put_ParamsSpec.$,
        IDBTransaction_Put_ResponseParamsSpec.$,
        [
          objectStoreId,
          value,
          key,
          mode,
          indexKeys
        ],
        false);
  }

  
  /**
   * @param { !bigint } objectStoreId
   * @param { !IDBKey } primaryKey
   * @param { !IDBIndexKeys } indexKeys
   */

  setIndexKeys(
      objectStoreId,
      primaryKey,
      indexKeys) {
    this.proxy.sendMessage(
        3,
        IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        [
          objectStoreId,
          primaryKey,
          indexKeys
        ],
        false);
  }

  
  /**
   */

  setIndexKeysDone() {
    this.proxy.sendMessage(
        4,
        IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } numErrorsHandled
   */

  commit(
      numErrorsHandled) {
    this.proxy.sendMessage(
        5,
        IDBTransaction_Commit_ParamsSpec.$,
        null,
        [
          numErrorsHandled
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBTransaction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBTransactionReceiver {
  /**
   * @param {!IDBTransactionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBTransactionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        impl.createObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        impl.deleteObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBTransaction_Put_ParamsSpec.$,
        IDBTransaction_Put_ResponseParamsSpec.$,
        impl.put.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        impl.setIndexKeys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        impl.setIndexKeysDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        IDBTransaction_Commit_ParamsSpec.$,
        null,
        impl.commit.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBTransaction {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBTransaction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBTransactionRemote}
   */
  static getRemote() {
    let remote = new IDBTransactionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBTransaction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBTransactionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBTransaction_CreateObjectStore_ParamsSpec.$,
        null,
        this.createObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBTransaction_DeleteObjectStore_ParamsSpec.$,
        null,
        this.deleteObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.put =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBTransaction_Put_ParamsSpec.$,
        IDBTransaction_Put_ResponseParamsSpec.$,
        this.put.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIndexKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IDBTransaction_SetIndexKeys_ParamsSpec.$,
        null,
        this.setIndexKeys.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIndexKeysDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
        null,
        this.setIndexKeysDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        IDBTransaction_Commit_ParamsSpec.$,
        null,
        this.commit.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBDatabaseGetAllResultSinkPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBDatabaseGetAllResultSink', scope);
  }
}

/** @interface */
export class IDBDatabaseGetAllResultSinkInterface {
  
  /**
   * @param { !Array<!IDBRecord> } records
   * @param { !boolean } done
   */

  receiveResults(records, done) {}
  
  /**
   * @param { !IDBError } error
   */

  onError(error) {}
}

/**
 * @implements { IDBDatabaseGetAllResultSinkInterface }
 */
export class IDBDatabaseGetAllResultSinkRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBDatabaseGetAllResultSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBDatabaseGetAllResultSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBDatabaseGetAllResultSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!IDBRecord> } records
   * @param { !boolean } done
   */

  receiveResults(
      records,
      done) {
    this.proxy.sendMessage(
        0,
        IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        [
          records,
          done
        ],
        false);
  }

  
  /**
   * @param { !IDBError } error
   */

  onError(
      error) {
    this.proxy.sendMessage(
        1,
        IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBDatabaseGetAllResultSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBDatabaseGetAllResultSinkReceiver {
  /**
   * @param {!IDBDatabaseGetAllResultSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBDatabaseGetAllResultSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBDatabaseGetAllResultSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseGetAllResultSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        impl.receiveResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBDatabaseGetAllResultSink {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabaseGetAllResultSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBDatabaseGetAllResultSinkRemote}
   */
  static getRemote() {
    let remote = new IDBDatabaseGetAllResultSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBDatabaseGetAllResultSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBDatabaseGetAllResultSinkCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBDatabaseGetAllResultSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseGetAllResultSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
        null,
        this.receiveResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBDatabasePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBDatabase', scope);
  }
}

/** @interface */
export class IDBDatabaseInterface {
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !mojoBase_mojom_String16 } newName
   */

  renameObjectStore(transactionId, objectStoreId, newName) {}
  
  /**
   * @param { !Object } transactionReceiver
   * @param { !bigint } transactionId
   * @param { !Array<!bigint> } objectStoreIds
   * @param { !IDBTransactionMode } mode
   * @param { !IDBTransactionDurability } durability
   */

  createTransaction(transactionReceiver, transactionId, objectStoreIds, mode, durability) {}
  
  /**
   */

  versionChangeIgnored() {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !boolean } keyOnly
   * @return {!Promise<{
        result: !IDBDatabaseGetResult,
   *  }>}
   */

  get(transactionId, objectStoreId, indexId, keyRange, keyOnly) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !IDBGetAllResultType } resultType
   * @param { !bigint } maxCount
   * @param { !IDBCursorDirection } direction
   * @return {!Promise<{
        receiver: !Object,
   *  }>}
   */

  getAll(transactionId, objectStoreId, indexId, keyRange, resultType, maxCount, direction) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !IDBCursorDirection } direction
   * @param { !boolean } keyOnly
   * @param { !IDBTaskType } taskType
   * @return {!Promise<{
        result: !IDBDatabaseOpenCursorResult,
   *  }>}
   */

  openCursor(transactionId, objectStoreId, indexId, keyRange, direction, keyOnly, taskType) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
        count: !number,
   *  }>}
   */

  count(transactionId, objectStoreId, indexId, keyRange) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteRange(transactionId, objectStoreId, keyRange) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        result: !bigint,
        error: ?IDBError,
   *  }>}
   */

  getKeyGeneratorCurrentNumber(transactionId, objectStoreId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clear(transactionId, objectStoreId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !IDBIndexMetadata } index
   */

  createIndex(transactionId, objectStoreId, index) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   */

  deleteIndex(transactionId, objectStoreId, indexId) {}
  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !mojoBase_mojom_String16 } newName
   */

  renameIndex(transactionId, objectStoreId, indexId, newName) {}
  
  /**
   * @param { !bigint } transactionId
   */

  abort(transactionId) {}
  
  /**
   */

  didBecomeInactive() {}
  
  /**
   * @param { !number } newPriority
   */

  updatePriority(newPriority) {}
}

/**
 * @implements { IDBDatabaseInterface }
 */
export class IDBDatabaseRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBDatabasePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBDatabasePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBDatabasePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !mojoBase_mojom_String16 } newName
   */

  renameObjectStore(
      transactionId,
      objectStoreId,
      newName) {
    this.proxy.sendMessage(
        0,
        IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !Object } transactionReceiver
   * @param { !bigint } transactionId
   * @param { !Array<!bigint> } objectStoreIds
   * @param { !IDBTransactionMode } mode
   * @param { !IDBTransactionDurability } durability
   */

  createTransaction(
      transactionReceiver,
      transactionId,
      objectStoreIds,
      mode,
      durability) {
    this.proxy.sendMessage(
        1,
        IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        [
          transactionReceiver,
          transactionId,
          objectStoreIds,
          mode,
          durability
        ],
        false);
  }

  
  /**
   */

  versionChangeIgnored() {
    this.proxy.sendMessage(
        2,
        IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !boolean } keyOnly
   * @return {!Promise<{
        result: !IDBDatabaseGetResult,
   *  }>}
   */

  get(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      keyOnly) {
    return this.proxy.sendMessage(
        3,
        IDBDatabase_Get_ParamsSpec.$,
        IDBDatabase_Get_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          keyOnly
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !IDBGetAllResultType } resultType
   * @param { !bigint } maxCount
   * @param { !IDBCursorDirection } direction
   * @return {!Promise<{
        receiver: !Object,
   *  }>}
   */

  getAll(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      resultType,
      maxCount,
      direction) {
    return this.proxy.sendMessage(
        4,
        IDBDatabase_GetAll_ParamsSpec.$,
        IDBDatabase_GetAll_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          resultType,
          maxCount,
          direction
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @param { !IDBCursorDirection } direction
   * @param { !boolean } keyOnly
   * @param { !IDBTaskType } taskType
   * @return {!Promise<{
        result: !IDBDatabaseOpenCursorResult,
   *  }>}
   */

  openCursor(
      transactionId,
      objectStoreId,
      indexId,
      keyRange,
      direction,
      keyOnly,
      taskType) {
    return this.proxy.sendMessage(
        5,
        IDBDatabase_OpenCursor_ParamsSpec.$,
        IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange,
          direction,
          keyOnly,
          taskType
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
        count: !number,
   *  }>}
   */

  count(
      transactionId,
      objectStoreId,
      indexId,
      keyRange) {
    return this.proxy.sendMessage(
        6,
        IDBDatabase_Count_ParamsSpec.$,
        IDBDatabase_Count_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          indexId,
          keyRange
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !IDBKeyRange } keyRange
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteRange(
      transactionId,
      objectStoreId,
      keyRange) {
    return this.proxy.sendMessage(
        7,
        IDBDatabase_DeleteRange_ParamsSpec.$,
        IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId,
          keyRange
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        result: !bigint,
        error: ?IDBError,
   *  }>}
   */

  getKeyGeneratorCurrentNumber(
      transactionId,
      objectStoreId) {
    return this.proxy.sendMessage(
        8,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clear(
      transactionId,
      objectStoreId) {
    return this.proxy.sendMessage(
        9,
        IDBDatabase_Clear_ParamsSpec.$,
        IDBDatabase_Clear_ResponseParamsSpec.$,
        [
          transactionId,
          objectStoreId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !IDBIndexMetadata } index
   */

  createIndex(
      transactionId,
      objectStoreId,
      index) {
    this.proxy.sendMessage(
        10,
        IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          index
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   */

  deleteIndex(
      transactionId,
      objectStoreId,
      indexId) {
    this.proxy.sendMessage(
        11,
        IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          indexId
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   * @param { !bigint } objectStoreId
   * @param { !bigint } indexId
   * @param { !mojoBase_mojom_String16 } newName
   */

  renameIndex(
      transactionId,
      objectStoreId,
      indexId,
      newName) {
    this.proxy.sendMessage(
        12,
        IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        [
          transactionId,
          objectStoreId,
          indexId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !bigint } transactionId
   */

  abort(
      transactionId) {
    this.proxy.sendMessage(
        13,
        IDBDatabase_Abort_ParamsSpec.$,
        null,
        [
          transactionId
        ],
        false);
  }

  
  /**
   */

  didBecomeInactive() {
    this.proxy.sendMessage(
        14,
        IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } newPriority
   */

  updatePriority(
      newPriority) {
    this.proxy.sendMessage(
        15,
        IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        [
          newPriority
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBDatabase
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBDatabaseReceiver {
  /**
   * @param {!IDBDatabaseInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBDatabaseRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBDatabaseRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        impl.renameObjectStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        impl.createTransaction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        impl.versionChangeIgnored.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        IDBDatabase_Get_ParamsSpec.$,
        IDBDatabase_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        IDBDatabase_GetAll_ParamsSpec.$,
        IDBDatabase_GetAll_ResponseParamsSpec.$,
        impl.getAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        IDBDatabase_OpenCursor_ParamsSpec.$,
        IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        impl.openCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        IDBDatabase_Count_ParamsSpec.$,
        IDBDatabase_Count_ResponseParamsSpec.$,
        impl.count.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        IDBDatabase_DeleteRange_ParamsSpec.$,
        IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        impl.deleteRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        impl.getKeyGeneratorCurrentNumber.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        IDBDatabase_Clear_ParamsSpec.$,
        IDBDatabase_Clear_ResponseParamsSpec.$,
        impl.clear.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        impl.createIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        impl.deleteIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        impl.renameIndex.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        IDBDatabase_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        impl.didBecomeInactive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        impl.updatePriority.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBDatabase {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBDatabase";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBDatabaseRemote}
   */
  static getRemote() {
    let remote = new IDBDatabaseRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBDatabase
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBDatabaseCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBDatabaseRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBDatabaseRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameObjectStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBDatabase_RenameObjectStore_ParamsSpec.$,
        null,
        this.renameObjectStore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBDatabase_CreateTransaction_ParamsSpec.$,
        null,
        this.createTransaction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.versionChangeIgnored =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
        null,
        this.versionChangeIgnored.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        IDBDatabase_Get_ParamsSpec.$,
        IDBDatabase_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        IDBDatabase_GetAll_ParamsSpec.$,
        IDBDatabase_GetAll_ResponseParamsSpec.$,
        this.getAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        IDBDatabase_OpenCursor_ParamsSpec.$,
        IDBDatabase_OpenCursor_ResponseParamsSpec.$,
        this.openCursor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.count =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        IDBDatabase_Count_ParamsSpec.$,
        IDBDatabase_Count_ResponseParamsSpec.$,
        this.count.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        IDBDatabase_DeleteRange_ParamsSpec.$,
        IDBDatabase_DeleteRange_ResponseParamsSpec.$,
        this.deleteRange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getKeyGeneratorCurrentNumber =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
        IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
        this.getKeyGeneratorCurrentNumber.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clear =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        IDBDatabase_Clear_ParamsSpec.$,
        IDBDatabase_Clear_ResponseParamsSpec.$,
        this.clear.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        IDBDatabase_CreateIndex_ParamsSpec.$,
        null,
        this.createIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        IDBDatabase_DeleteIndex_ParamsSpec.$,
        null,
        this.deleteIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameIndex =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        IDBDatabase_RenameIndex_ParamsSpec.$,
        null,
        this.renameIndex.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        IDBDatabase_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didBecomeInactive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        IDBDatabase_DidBecomeInactive_ParamsSpec.$,
        null,
        this.didBecomeInactive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        IDBDatabase_UpdatePriority_ParamsSpec.$,
        null,
        this.updatePriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IDBFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IDBFactory', scope);
  }
}

/** @interface */
export class IDBFactoryInterface {
  
  /**
   * @return {!Promise<{
        namesAndVersions: !Array<!IDBNameAndVersion>,
        error: !IDBError,
   *  }>}
   */

  getDatabaseInfo() {}
  
  /**
   * @param { !Object } client
   * @param { !Object } databaseCallbacks
   * @param { !mojoBase_mojom_String16 } name
   * @param { !bigint } version
   * @param { !Object } versionChangeTransactionReceiver
   * @param { !bigint } transactionId
   * @param { !number } priority
   */

  open(client, databaseCallbacks, name, version, versionChangeTransactionReceiver, transactionId, priority) {}
  
  /**
   * @param { !Object } client
   * @param { !mojoBase_mojom_String16 } name
   * @param { !boolean } forceClose
   */

  deleteDatabase(client, name, forceClose) {}
}

/**
 * @implements { IDBFactoryInterface }
 */
export class IDBFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IDBFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IDBFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IDBFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        namesAndVersions: !Array<!IDBNameAndVersion>,
        error: !IDBError,
   *  }>}
   */

  getDatabaseInfo() {
    return this.proxy.sendMessage(
        0,
        IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !Object } databaseCallbacks
   * @param { !mojoBase_mojom_String16 } name
   * @param { !bigint } version
   * @param { !Object } versionChangeTransactionReceiver
   * @param { !bigint } transactionId
   * @param { !number } priority
   */

  open(
      client,
      databaseCallbacks,
      name,
      version,
      versionChangeTransactionReceiver,
      transactionId,
      priority) {
    this.proxy.sendMessage(
        1,
        IDBFactory_Open_ParamsSpec.$,
        null,
        [
          client,
          databaseCallbacks,
          name,
          version,
          versionChangeTransactionReceiver,
          transactionId,
          priority
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !mojoBase_mojom_String16 } name
   * @param { !boolean } forceClose
   */

  deleteDatabase(
      client,
      name,
      forceClose) {
    this.proxy.sendMessage(
        2,
        IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        [
          client,
          name,
          forceClose
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IDBFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IDBFactoryReceiver {
  /**
   * @param {!IDBFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IDBFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IDBFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        impl.getDatabaseInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        IDBFactory_Open_ParamsSpec.$,
        null,
        impl.open.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        impl.deleteDatabase.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IDBFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IDBFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IDBFactoryRemote}
   */
  static getRemote() {
    let remote = new IDBFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IDBFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IDBFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IDBFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IDBFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDatabaseInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IDBFactory_GetDatabaseInfo_ParamsSpec.$,
        IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
        this.getDatabaseInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        IDBFactory_Open_ParamsSpec.$,
        null,
        this.open.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteDatabase =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        IDBFactory_DeleteDatabase_ParamsSpec.$,
        null,
        this.deleteDatabase.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBKeyPathSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBKeyRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBIndexMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBObjectStoreMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBNameAndVersionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBIndexKeysSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBBlobInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBReturnValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursorValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseOpenCursorValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactoryClient_Error_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactoryClient_Blocked_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactoryClient_UpgradeNeeded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactoryClient_OpenSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactoryClient_DeleteSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseCallbacks_ForcedClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseCallbacks_VersionChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseCallbacks_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseCallbacks_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Advance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Advance_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Continue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Continue_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Prefetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_Prefetch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBCursor_PrefetchReset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_CreateObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_DeleteObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_Put_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_Put_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_SetIndexKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_SetIndexKeysDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBTransaction_Commit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabaseGetAllResultSink_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_RenameObjectStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_CreateTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_VersionChangeIgnored_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_GetAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_GetAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_OpenCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_OpenCursor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Count_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Count_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_DeleteRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_DeleteRange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Clear_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Clear_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_CreateIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_DeleteIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_RenameIndex_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_DidBecomeInactive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBDatabase_UpdatePriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactory_GetDatabaseInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactory_GetDatabaseInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactory_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IDBFactory_DeleteDatabase_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBKeyPathDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBExternalObjectSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBCursorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBTransactionPutResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBDatabaseGetResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const IDBDatabaseOpenCursorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    IDBKeyPathSpec.$,
    'IDBKeyPath',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        IDBKeyPathDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBKeyPath {
  constructor() {
    /** @type { (IDBKeyPathData|undefined) } */
    this.data;
  }
}



mojo.internal.Struct(
    IDBKeyRangeSpec.$,
    'IDBKeyRange',
    [
      mojo.internal.StructField(
        'lower', 0,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'upper', 16,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lowerOpen', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'upperOpen', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class IDBKeyRange {
  constructor() {
    /** @type { !IDBKey } */
    this.lower;
    /** @type { !IDBKey } */
    this.upper;
    /** @type { !boolean } */
    this.lowerOpen;
    /** @type { !boolean } */
    this.upperOpen;
  }
}



mojo.internal.Struct(
    IDBIndexMetadataSpec.$,
    'IDBIndexMetadata',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        IDBKeyPathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unique', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multiEntry', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBIndexMetadata {
  constructor() {
    /** @type { !bigint } */
    this.id;
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !IDBKeyPath } */
    this.keyPath;
    /** @type { !boolean } */
    this.unique;
    /** @type { !boolean } */
    this.multiEntry;
  }
}



mojo.internal.Struct(
    IDBObjectStoreMetadataSpec.$,
    'IDBObjectStoreMetadata',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        IDBKeyPathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'autoIncrement', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxIndexId', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexes', 40,
        0,
        mojo.internal.Map(mojo.internal.Int64, IDBIndexMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBObjectStoreMetadata {
  constructor() {
    /** @type { !bigint } */
    this.id;
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !IDBKeyPath } */
    this.keyPath;
    /** @type { !boolean } */
    this.autoIncrement;
    /** @type { !bigint } */
    this.maxIndexId;
    /** @type { !Map<!bigint, !IDBIndexMetadata> } */
    this.indexes;
  }
}



mojo.internal.Struct(
    IDBDatabaseMetadataSpec.$,
    'IDBDatabaseMetadata',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxObjectStoreId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStores', 24,
        0,
        mojo.internal.Map(mojo.internal.Int64, IDBObjectStoreMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasColdOpen', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class IDBDatabaseMetadata {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !bigint } */
    this.version;
    /** @type { !bigint } */
    this.maxObjectStoreId;
    /** @type { !Map<!bigint, !IDBObjectStoreMetadata> } */
    this.objectStores;
    /** @type { !boolean } */
    this.wasColdOpen;
  }
}



mojo.internal.Struct(
    IDBNameAndVersionSpec.$,
    'IDBNameAndVersion',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBNameAndVersion {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !bigint } */
    this.version;
  }
}



mojo.internal.Struct(
    IDBIndexKeysSpec.$,
    'IDBIndexKeys',
    [
      mojo.internal.StructField(
        'indexId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexKeys', 8,
        0,
        mojo.internal.Array(IDBKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBIndexKeys {
  constructor() {
    /** @type { !bigint } */
    this.indexId;
    /** @type { !Array<!IDBKey> } */
    this.indexKeys;
  }
}



mojo.internal.Struct(
    IDBFileInfoSpec.$,
    'IDBFileInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastModified', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBFileInfo {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !mojoBase_mojom_Time } */
    this.lastModified;
  }
}



mojo.internal.Struct(
    IDBBlobInfoSpec.$,
    'IDBBlobInfo',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeType', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        IDBFileInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBBlobInfo {
  constructor() {
    /** @type { !blink_mojom_BlobRemote } */
    this.blob;
    /** @type { !mojoBase_mojom_String16 } */
    this.mimeType;
    /** @type { !bigint } */
    this.size;
    /** @type { (IDBFileInfo|undefined) } */
    this.file;
  }
}



mojo.internal.Struct(
    IDBValueSpec.$,
    'IDBValue',
    [
      mojo.internal.StructField(
        'bits', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'externalObjects', 8,
        0,
        mojo.internal.Array(IDBExternalObjectSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBValue {
  constructor() {
    /** @type { !Array<!number> } */
    this.bits;
    /** @type { !Array<!IDBExternalObject> } */
    this.externalObjects;
  }
}



mojo.internal.Struct(
    IDBReturnValueSpec.$,
    'IDBReturnValue',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        IDBValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryKey', 8,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyPath', 24,
        0,
        IDBKeyPathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBReturnValue {
  constructor() {
    /** @type { !IDBValue } */
    this.value;
    /** @type { !IDBKey } */
    this.primaryKey;
    /** @type { !IDBKeyPath } */
    this.keyPath;
  }
}



mojo.internal.Struct(
    IDBRecordSpec.$,
    'IDBRecord',
    [
      mojo.internal.StructField(
        'primaryKey', 0,
        0,
        IDBKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'returnValue', 16,
        0,
        IDBReturnValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexKey', 24,
        0,
        IDBKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class IDBRecord {
  constructor() {
    /** @type { (IDBKey|undefined) } */
    this.primaryKey;
    /** @type { (IDBReturnValue|undefined) } */
    this.returnValue;
    /** @type { (IDBKey|undefined) } */
    this.indexKey;
  }
}



mojo.internal.Struct(
    IDBErrorSpec.$,
    'IDBError',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        IDBExceptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBError {
  constructor() {
    /** @type { !IDBException } */
    this.errorCode;
    /** @type { !mojoBase_mojom_String16 } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    IDBCursorValueSpec.$,
    'IDBCursorValue',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(IDBKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryKeys', 8,
        0,
        mojo.internal.Array(IDBKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'values', 16,
        0,
        mojo.internal.Array(IDBValueSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBCursorValue {
  constructor() {
    /** @type { !Array<!IDBKey> } */
    this.keys;
    /** @type { !Array<!IDBKey> } */
    this.primaryKeys;
    /** @type { !Array<!IDBValue> } */
    this.values;
  }
}



mojo.internal.Struct(
    IDBDatabaseOpenCursorValueSpec.$,
    'IDBDatabaseOpenCursorValue',
    [
      mojo.internal.StructField(
        'cursor', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBCursorRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryKey', 24,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 40,
        0,
        IDBValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBDatabaseOpenCursorValue {
  constructor() {
    /** @type { !Object } */
    this.cursor;
    /** @type { !IDBKey } */
    this.key;
    /** @type { !IDBKey } */
    this.primaryKey;
    /** @type { (IDBValue|undefined) } */
    this.value;
  }
}



mojo.internal.Struct(
    IDBFactoryClient_Error_ParamsSpec.$,
    'IDBFactoryClient_Error_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        IDBExceptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBFactoryClient_Error_Params {
  constructor() {
    /** @type { !IDBException } */
    this.code;
    /** @type { !mojoBase_mojom_String16 } */
    this.message;
  }
}



mojo.internal.Struct(
    IDBFactoryClient_Blocked_ParamsSpec.$,
    'IDBFactoryClient_Blocked_Params',
    [
      mojo.internal.StructField(
        'existingVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBFactoryClient_Blocked_Params {
  constructor() {
    /** @type { !bigint } */
    this.existingVersion;
  }
}



mojo.internal.Struct(
    IDBFactoryClient_UpgradeNeeded_ParamsSpec.$,
    'IDBFactoryClient_UpgradeNeeded_Params',
    [
      mojo.internal.StructField(
        'pendingDatabase', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBDatabaseRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'oldVersion', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataLoss', 16,
        0,
        IDBDataLossSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataLossMessage', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dbMetadata', 32,
        0,
        IDBDatabaseMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class IDBFactoryClient_UpgradeNeeded_Params {
  constructor() {
    /** @type { !Object } */
    this.pendingDatabase;
    /** @type { !bigint } */
    this.oldVersion;
    /** @type { !IDBDataLoss } */
    this.dataLoss;
    /** @type { !string } */
    this.dataLossMessage;
    /** @type { !IDBDatabaseMetadata } */
    this.dbMetadata;
  }
}



mojo.internal.Struct(
    IDBFactoryClient_OpenSuccess_ParamsSpec.$,
    'IDBFactoryClient_OpenSuccess_Params',
    [
      mojo.internal.StructField(
        'pendingDatabase', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBDatabaseRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        IDBDatabaseMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBFactoryClient_OpenSuccess_Params {
  constructor() {
    /** @type { (Object|undefined) } */
    this.pendingDatabase;
    /** @type { !IDBDatabaseMetadata } */
    this.metadata;
  }
}



mojo.internal.Struct(
    IDBFactoryClient_DeleteSuccess_ParamsSpec.$,
    'IDBFactoryClient_DeleteSuccess_Params',
    [
      mojo.internal.StructField(
        'oldVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBFactoryClient_DeleteSuccess_Params {
  constructor() {
    /** @type { !bigint } */
    this.oldVersion;
  }
}



mojo.internal.Struct(
    IDBDatabaseCallbacks_ForcedClose_ParamsSpec.$,
    'IDBDatabaseCallbacks_ForcedClose_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class IDBDatabaseCallbacks_ForcedClose_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    IDBDatabaseCallbacks_VersionChange_ParamsSpec.$,
    'IDBDatabaseCallbacks_VersionChange_Params',
    [
      mojo.internal.StructField(
        'oldVersion', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newVersion', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabaseCallbacks_VersionChange_Params {
  constructor() {
    /** @type { !bigint } */
    this.oldVersion;
    /** @type { !bigint } */
    this.newVersion;
  }
}



mojo.internal.Struct(
    IDBDatabaseCallbacks_Abort_ParamsSpec.$,
    'IDBDatabaseCallbacks_Abort_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 8,
        0,
        IDBExceptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBDatabaseCallbacks_Abort_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !IDBException } */
    this.code;
    /** @type { !mojoBase_mojom_String16 } */
    this.message;
  }
}



mojo.internal.Struct(
    IDBDatabaseCallbacks_Complete_ParamsSpec.$,
    'IDBDatabaseCallbacks_Complete_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabaseCallbacks_Complete_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
  }
}



mojo.internal.Struct(
    IDBCursor_Advance_ParamsSpec.$,
    'IDBCursor_Advance_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBCursor_Advance_Params {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    IDBCursor_Advance_ResponseParamsSpec.$,
    'IDBCursor_Advance_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBCursorResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBCursor_Advance_ResponseParams {
  constructor() {
    /** @type { !IDBCursorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBCursor_Continue_ParamsSpec.$,
    'IDBCursor_Continue_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryKey', 16,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBCursor_Continue_Params {
  constructor() {
    /** @type { !IDBKey } */
    this.key;
    /** @type { !IDBKey } */
    this.primaryKey;
  }
}



mojo.internal.Struct(
    IDBCursor_Continue_ResponseParamsSpec.$,
    'IDBCursor_Continue_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBCursorResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBCursor_Continue_ResponseParams {
  constructor() {
    /** @type { !IDBCursorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBCursor_Prefetch_ParamsSpec.$,
    'IDBCursor_Prefetch_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBCursor_Prefetch_Params {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    IDBCursor_Prefetch_ResponseParamsSpec.$,
    'IDBCursor_Prefetch_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBCursorResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBCursor_Prefetch_ResponseParams {
  constructor() {
    /** @type { !IDBCursorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBCursor_PrefetchReset_ParamsSpec.$,
    'IDBCursor_PrefetchReset_Params',
    [
      mojo.internal.StructField(
        'usedPrefetches', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBCursor_PrefetchReset_Params {
  constructor() {
    /** @type { !number } */
    this.usedPrefetches;
  }
}



mojo.internal.Struct(
    IDBTransaction_CreateObjectStore_ParamsSpec.$,
    'IDBTransaction_CreateObjectStore_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyPath', 16,
        0,
        IDBKeyPathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'autoIncrement', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBTransaction_CreateObjectStore_Params {
  constructor() {
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !IDBKeyPath } */
    this.keyPath;
    /** @type { !boolean } */
    this.autoIncrement;
  }
}



mojo.internal.Struct(
    IDBTransaction_DeleteObjectStore_ParamsSpec.$,
    'IDBTransaction_DeleteObjectStore_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBTransaction_DeleteObjectStore_Params {
  constructor() {
    /** @type { !bigint } */
    this.objectStoreId;
  }
}



mojo.internal.Struct(
    IDBTransaction_Put_ParamsSpec.$,
    'IDBTransaction_Put_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        IDBValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'key', 16,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 32,
        0,
        IDBPutModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexKeys', 40,
        0,
        mojo.internal.Array(IDBIndexKeysSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBTransaction_Put_Params {
  constructor() {
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !IDBValue } */
    this.value;
    /** @type { !IDBKey } */
    this.key;
    /** @type { !IDBPutMode } */
    this.mode;
    /** @type { !Array<!IDBIndexKeys> } */
    this.indexKeys;
  }
}



mojo.internal.Struct(
    IDBTransaction_Put_ResponseParamsSpec.$,
    'IDBTransaction_Put_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBTransactionPutResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBTransaction_Put_ResponseParams {
  constructor() {
    /** @type { !IDBTransactionPutResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBTransaction_SetIndexKeys_ParamsSpec.$,
    'IDBTransaction_SetIndexKeys_Params',
    [
      mojo.internal.StructField(
        'objectStoreId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryKey', 8,
        0,
        IDBKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexKeys', 24,
        0,
        IDBIndexKeysSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBTransaction_SetIndexKeys_Params {
  constructor() {
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !IDBKey } */
    this.primaryKey;
    /** @type { !IDBIndexKeys } */
    this.indexKeys;
  }
}



mojo.internal.Struct(
    IDBTransaction_SetIndexKeysDone_ParamsSpec.$,
    'IDBTransaction_SetIndexKeysDone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class IDBTransaction_SetIndexKeysDone_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    IDBTransaction_Commit_ParamsSpec.$,
    'IDBTransaction_Commit_Params',
    [
      mojo.internal.StructField(
        'numErrorsHandled', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBTransaction_Commit_Params {
  constructor() {
    /** @type { !bigint } */
    this.numErrorsHandled;
  }
}



mojo.internal.Struct(
    IDBDatabaseGetAllResultSink_ReceiveResults_ParamsSpec.$,
    'IDBDatabaseGetAllResultSink_ReceiveResults_Params',
    [
      mojo.internal.StructField(
        'records', 0,
        0,
        mojo.internal.Array(IDBRecordSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'done', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabaseGetAllResultSink_ReceiveResults_Params {
  constructor() {
    /** @type { !Array<!IDBRecord> } */
    this.records;
    /** @type { !boolean } */
    this.done;
  }
}



mojo.internal.Struct(
    IDBDatabaseGetAllResultSink_OnError_ParamsSpec.$,
    'IDBDatabaseGetAllResultSink_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        IDBErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabaseGetAllResultSink_OnError_Params {
  constructor() {
    /** @type { !IDBError } */
    this.error;
  }
}



mojo.internal.Struct(
    IDBDatabase_RenameObjectStore_ParamsSpec.$,
    'IDBDatabase_RenameObjectStore_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newName', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBDatabase_RenameObjectStore_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !mojoBase_mojom_String16 } */
    this.newName;
  }
}



mojo.internal.Struct(
    IDBDatabase_CreateTransaction_ParamsSpec.$,
    'IDBDatabase_CreateTransaction_Params',
    [
      mojo.internal.StructField(
        'transactionReceiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(IDBTransactionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transactionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreIds', 16,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 4,
        0,
        IDBTransactionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'durability', 24,
        0,
        IDBTransactionDurabilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBDatabase_CreateTransaction_Params {
  constructor() {
    /** @type { !Object } */
    this.transactionReceiver;
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !Array<!bigint> } */
    this.objectStoreIds;
    /** @type { !IDBTransactionMode } */
    this.mode;
    /** @type { !IDBTransactionDurability } */
    this.durability;
  }
}



mojo.internal.Struct(
    IDBDatabase_VersionChangeIgnored_ParamsSpec.$,
    'IDBDatabase_VersionChangeIgnored_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class IDBDatabase_VersionChangeIgnored_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    IDBDatabase_Get_ParamsSpec.$,
    'IDBDatabase_Get_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        IDBKeyRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyOnly', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class IDBDatabase_Get_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
    /** @type { !IDBKeyRange } */
    this.keyRange;
    /** @type { !boolean } */
    this.keyOnly;
  }
}



mojo.internal.Struct(
    IDBDatabase_Get_ResponseParamsSpec.$,
    'IDBDatabase_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBDatabaseGetResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabase_Get_ResponseParams {
  constructor() {
    /** @type { !IDBDatabaseGetResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBDatabase_GetAll_ParamsSpec.$,
    'IDBDatabase_GetAll_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        IDBKeyRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultType', 32,
        0,
        IDBGetAllResultTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxCount', 40,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'direction', 36,
        0,
        IDBCursorDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBDatabase_GetAll_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
    /** @type { !IDBKeyRange } */
    this.keyRange;
    /** @type { !IDBGetAllResultType } */
    this.resultType;
    /** @type { !bigint } */
    this.maxCount;
    /** @type { !IDBCursorDirection } */
    this.direction;
  }
}



mojo.internal.Struct(
    IDBDatabase_GetAll_ResponseParamsSpec.$,
    'IDBDatabase_GetAll_ResponseParams',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(IDBDatabaseGetAllResultSinkPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_GetAll_ResponseParams {
  constructor() {
    /** @type { !Object } */
    this.receiver;
  }
}



mojo.internal.Struct(
    IDBDatabase_OpenCursor_ParamsSpec.$,
    'IDBDatabase_OpenCursor_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        IDBKeyRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'direction', 32,
        0,
        IDBCursorDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyOnly', 36,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'taskType', 40,
        0,
        IDBTaskTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBDatabase_OpenCursor_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
    /** @type { !IDBKeyRange } */
    this.keyRange;
    /** @type { !IDBCursorDirection } */
    this.direction;
    /** @type { !boolean } */
    this.keyOnly;
    /** @type { !IDBTaskType } */
    this.taskType;
  }
}



mojo.internal.Struct(
    IDBDatabase_OpenCursor_ResponseParamsSpec.$,
    'IDBDatabase_OpenCursor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        IDBDatabaseOpenCursorResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabase_OpenCursor_ResponseParams {
  constructor() {
    /** @type { !IDBDatabaseOpenCursorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    IDBDatabase_Count_ParamsSpec.$,
    'IDBDatabase_Count_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyRange', 24,
        0,
        IDBKeyRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBDatabase_Count_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
    /** @type { !IDBKeyRange } */
    this.keyRange;
  }
}



mojo.internal.Struct(
    IDBDatabase_Count_ResponseParamsSpec.$,
    'IDBDatabase_Count_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'count', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_Count_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    IDBDatabase_DeleteRange_ParamsSpec.$,
    'IDBDatabase_DeleteRange_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyRange', 16,
        0,
        IDBKeyRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBDatabase_DeleteRange_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !IDBKeyRange } */
    this.keyRange;
  }
}



mojo.internal.Struct(
    IDBDatabase_DeleteRange_ResponseParamsSpec.$,
    'IDBDatabase_DeleteRange_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_DeleteRange_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsSpec.$,
    'IDBDatabase_GetKeyGeneratorCurrentNumber_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabase_GetKeyGeneratorCurrentNumber_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
  }
}



mojo.internal.Struct(
    IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsSpec.$,
    'IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        IDBErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams {
  constructor() {
    /** @type { !bigint } */
    this.result;
    /** @type { (IDBError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    IDBDatabase_Clear_ParamsSpec.$,
    'IDBDatabase_Clear_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBDatabase_Clear_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
  }
}



mojo.internal.Struct(
    IDBDatabase_Clear_ResponseParamsSpec.$,
    'IDBDatabase_Clear_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_Clear_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    IDBDatabase_CreateIndex_ParamsSpec.$,
    'IDBDatabase_CreateIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'index', 16,
        0,
        IDBIndexMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBDatabase_CreateIndex_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !IDBIndexMetadata } */
    this.index;
  }
}



mojo.internal.Struct(
    IDBDatabase_DeleteIndex_ParamsSpec.$,
    'IDBDatabase_DeleteIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBDatabase_DeleteIndex_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
  }
}



mojo.internal.Struct(
    IDBDatabase_RenameIndex_ParamsSpec.$,
    'IDBDatabase_RenameIndex_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectStoreId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'indexId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newName', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IDBDatabase_RenameIndex_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !bigint } */
    this.objectStoreId;
    /** @type { !bigint } */
    this.indexId;
    /** @type { !mojoBase_mojom_String16 } */
    this.newName;
  }
}



mojo.internal.Struct(
    IDBDatabase_Abort_ParamsSpec.$,
    'IDBDatabase_Abort_Params',
    [
      mojo.internal.StructField(
        'transactionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_Abort_Params {
  constructor() {
    /** @type { !bigint } */
    this.transactionId;
  }
}



mojo.internal.Struct(
    IDBDatabase_DidBecomeInactive_ParamsSpec.$,
    'IDBDatabase_DidBecomeInactive_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class IDBDatabase_DidBecomeInactive_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    IDBDatabase_UpdatePriority_ParamsSpec.$,
    'IDBDatabase_UpdatePriority_Params',
    [
      mojo.internal.StructField(
        'newPriority', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IDBDatabase_UpdatePriority_Params {
  constructor() {
    /** @type { !number } */
    this.newPriority;
  }
}



mojo.internal.Struct(
    IDBFactory_GetDatabaseInfo_ParamsSpec.$,
    'IDBFactory_GetDatabaseInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class IDBFactory_GetDatabaseInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    IDBFactory_GetDatabaseInfo_ResponseParamsSpec.$,
    'IDBFactory_GetDatabaseInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'namesAndVersions', 0,
        0,
        mojo.internal.Array(IDBNameAndVersionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        IDBErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IDBFactory_GetDatabaseInfo_ResponseParams {
  constructor() {
    /** @type { !Array<!IDBNameAndVersion> } */
    this.namesAndVersions;
    /** @type { !IDBError } */
    this.error;
  }
}



mojo.internal.Struct(
    IDBFactory_Open_ParamsSpec.$,
    'IDBFactory_Open_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBFactoryClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'databaseCallbacks', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBDatabaseCallbacksRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'versionChangeTransactionReceiver', 32,
        0,
        mojo.internal.AssociatedInterfaceRequest(IDBTransactionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transactionId', 40,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class IDBFactory_Open_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !Object } */
    this.databaseCallbacks;
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !bigint } */
    this.version;
    /** @type { !Object } */
    this.versionChangeTransactionReceiver;
    /** @type { !bigint } */
    this.transactionId;
    /** @type { !number } */
    this.priority;
  }
}



mojo.internal.Struct(
    IDBFactory_DeleteDatabase_ParamsSpec.$,
    'IDBFactory_DeleteDatabase_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(IDBFactoryClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceClose', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class IDBFactory_DeleteDatabase_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !boolean } */
    this.forceClose;
  }
}

mojo.internal.Union(
    IDBKeySpec.$, 'IDBKey',
    {
      'keyArray': {
        'ordinal': 0,
        'type': mojo.internal.Array(IDBKeySpec.$, false),
      },
      'binary': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'string': {
        'ordinal': 2,
        'type': mojoBase_mojom_String16Spec.$,
      },
      'date': {
        'ordinal': 3,
        'type': mojo.internal.Double,
      },
      'number': {
        'ordinal': 4,
        'type': mojo.internal.Double,
      },
      'otherNone': {
        'ordinal': 5,
        'type': mojo.internal.Bool,
      },
    });

/**
 * @typedef { {
 *   keyArray: (!Array<!IDBKey>|undefined),
 *   binary: (!Array<!number>|undefined),
 *   string: (!mojoBase_mojom_String16|undefined),
 *   date: (!number|undefined),
 *   number: (!number|undefined),
 *   otherNone: (!boolean|undefined),
 * } }
 */
export const IDBKey = {};
mojo.internal.Union(
    IDBKeyPathDataSpec.$, 'IDBKeyPathData',
    {
      'string': {
        'ordinal': 0,
        'type': mojoBase_mojom_String16Spec.$,
      },
      'stringArray': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
      },
    });

/**
 * @typedef { {
 *   string: (!mojoBase_mojom_String16|undefined),
 *   stringArray: (!Array<!mojoBase_mojom_String16>|undefined),
 * } }
 */
export const IDBKeyPathData = {};
mojo.internal.Union(
    IDBExternalObjectSpec.$, 'IDBExternalObject',
    {
      'blobOrFile': {
        'ordinal': 0,
        'type': IDBBlobInfoSpec.$,
      },
      'fileSystemAccessToken': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
      },
    });

/**
 * @typedef { {
 *   blobOrFile: (!IDBBlobInfo|undefined),
 *   fileSystemAccessToken: (!blink_mojom_FileSystemAccessTransferTokenRemote|undefined),
 * } }
 */
export const IDBExternalObject = {};
mojo.internal.Union(
    IDBCursorResultSpec.$, 'IDBCursorResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'values': {
        'ordinal': 2,
        'type': IDBCursorValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   values: (!IDBCursorValue|undefined),
 * } }
 */
export const IDBCursorResult = {};
mojo.internal.Union(
    IDBTransactionPutResultSpec.$, 'IDBTransactionPutResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': IDBErrorSpec.$,
      },
      'key': {
        'ordinal': 1,
        'type': IDBKeySpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!IDBError|undefined),
 *   key: (!IDBKey|undefined),
 * } }
 */
export const IDBTransactionPutResult = {};
mojo.internal.Union(
    IDBDatabaseGetResultSpec.$, 'IDBDatabaseGetResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'key': {
        'ordinal': 2,
        'type': IDBKeySpec.$,
      },
      'value': {
        'ordinal': 3,
        'type': IDBReturnValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   key: (!IDBKey|undefined),
 *   value: (!IDBReturnValue|undefined),
 * } }
 */
export const IDBDatabaseGetResult = {};
mojo.internal.Union(
    IDBDatabaseOpenCursorResultSpec.$, 'IDBDatabaseOpenCursorResult',
    {
      'errorResult': {
        'ordinal': 0,
        'type': IDBErrorSpec.$,
      },
      'empty': {
        'ordinal': 1,
        'type': mojo.internal.Bool,
      },
      'value': {
        'ordinal': 2,
        'type': IDBDatabaseOpenCursorValueSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorResult: (!IDBError|undefined),
 *   empty: (!boolean|undefined),
 *   value: (!IDBDatabaseOpenCursorValue|undefined),
 * } }
 */
export const IDBDatabaseOpenCursorResult = {};
