// third_party/blink/public/mojom/input/input_messages.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextSuggestionBackendPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.TextSuggestionBackend', scope);
  }
}

/** @interface */
export class TextSuggestionBackendInterface {
  
  /**
   * @param { !string } suggestion
   */

  applySpellCheckSuggestion(suggestion) {}
  
  /**
   * @param { !number } markerTag
   * @param { !number } suggestionIndex
   */

  applyTextSuggestion(markerTag, suggestionIndex) {}
  
  /**
   */

  deleteActiveSuggestionRange() {}
  
  /**
   * @param { !string } suggestion
   */

  onNewWordAddedToDictionary(suggestion) {}
  
  /**
   */

  onSuggestionMenuClosed() {}
  
  /**
   * @param { !number } maxNumberOfSuggestions
   */

  suggestionMenuTimeoutCallback(maxNumberOfSuggestions) {}
}

/**
 * @implements { TextSuggestionBackendInterface }
 */
export class TextSuggestionBackendRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextSuggestionBackendPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSuggestionBackendPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextSuggestionBackendPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } suggestion
   */

  applySpellCheckSuggestion(
      suggestion) {
    this.proxy.sendMessage(
        0,
        TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        [
          suggestion
        ],
        false);
  }

  
  /**
   * @param { !number } markerTag
   * @param { !number } suggestionIndex
   */

  applyTextSuggestion(
      markerTag,
      suggestionIndex) {
    this.proxy.sendMessage(
        1,
        TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        [
          markerTag,
          suggestionIndex
        ],
        false);
  }

  
  /**
   */

  deleteActiveSuggestionRange() {
    this.proxy.sendMessage(
        2,
        TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } suggestion
   */

  onNewWordAddedToDictionary(
      suggestion) {
    this.proxy.sendMessage(
        3,
        TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        [
          suggestion
        ],
        false);
  }

  
  /**
   */

  onSuggestionMenuClosed() {
    this.proxy.sendMessage(
        4,
        TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } maxNumberOfSuggestions
   */

  suggestionMenuTimeoutCallback(
      maxNumberOfSuggestions) {
    this.proxy.sendMessage(
        5,
        TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        [
          maxNumberOfSuggestions
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextSuggestionBackend
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSuggestionBackendReceiver {
  /**
   * @param {!TextSuggestionBackendInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextSuggestionBackendRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSuggestionBackendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSuggestionBackendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        impl.applySpellCheckSuggestion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        impl.applyTextSuggestion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        impl.deleteActiveSuggestionRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        impl.onNewWordAddedToDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        impl.onSuggestionMenuClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        impl.suggestionMenuTimeoutCallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSuggestionBackend {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextSuggestionBackend";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextSuggestionBackendRemote}
   */
  static getRemote() {
    let remote = new TextSuggestionBackendRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextSuggestionBackend
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSuggestionBackendCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSuggestionBackendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSuggestionBackendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applySpellCheckSuggestion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
        null,
        this.applySpellCheckSuggestion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applyTextSuggestion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
        null,
        this.applyTextSuggestion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteActiveSuggestionRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
        null,
        this.deleteActiveSuggestionRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewWordAddedToDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
        null,
        this.onNewWordAddedToDictionary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSuggestionMenuClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
        null,
        this.onSuggestionMenuClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suggestionMenuTimeoutCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
        null,
        this.suggestionMenuTimeoutCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsSpec.$,
    'TextSuggestionBackend_ApplySpellCheckSuggestion_Params',
    [
      mojo.internal.StructField(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggestionBackend_ApplySpellCheckSuggestion_Params {
  constructor() {
    /** @type { !string } */
    this.suggestion;
  }
}



mojo.internal.Struct(
    TextSuggestionBackend_ApplyTextSuggestion_ParamsSpec.$,
    'TextSuggestionBackend_ApplyTextSuggestion_Params',
    [
      mojo.internal.StructField(
        'markerTag', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestionIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggestionBackend_ApplyTextSuggestion_Params {
  constructor() {
    /** @type { !number } */
    this.markerTag;
    /** @type { !number } */
    this.suggestionIndex;
  }
}



mojo.internal.Struct(
    TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsSpec.$,
    'TextSuggestionBackend_DeleteActiveSuggestionRange_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextSuggestionBackend_DeleteActiveSuggestionRange_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsSpec.$,
    'TextSuggestionBackend_OnNewWordAddedToDictionary_Params',
    [
      mojo.internal.StructField(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggestionBackend_OnNewWordAddedToDictionary_Params {
  constructor() {
    /** @type { !string } */
    this.suggestion;
  }
}



mojo.internal.Struct(
    TextSuggestionBackend_OnSuggestionMenuClosed_ParamsSpec.$,
    'TextSuggestionBackend_OnSuggestionMenuClosed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class TextSuggestionBackend_OnSuggestionMenuClosed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsSpec.$,
    'TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params',
    [
      mojo.internal.StructField(
        'maxNumberOfSuggestions', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params {
  constructor() {
    /** @type { !number } */
    this.maxNumberOfSuggestions;
  }
}

