// third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioInputStream');
goog.require('media.mojom.AudioInputStreamClient');
goog.require('media.mojom.AudioParameters');
goog.require('media.mojom.AudioProcessingConfig');
goog.require('media.mojom.ReadWriteAudioDataPipe');
goog.require('mojoBase.mojom.UnguessableToken');






goog.provide('blink.mojom.RendererAudioInputStreamFactory');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryReceiver');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryCallbackRouter');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryInterface');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryRemote');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RendererAudioInputStreamFactory.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.RendererAudioInputStreamFactoryInterface = class {
  
  /**
   * @param { !blink.mojom.RendererAudioInputStreamFactoryClientRemote } client
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.AudioParameters } params
   * @param { !boolean } automaticGainControl
   * @param { !number } sharedMemoryCount
   * @param { ?media.mojom.AudioProcessingConfig } processingConfig
   */

  createStream(client, sessionId, params, automaticGainControl, sharedMemoryCount, processingConfig) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(inputStreamId, outputDeviceId) {}
};

/**
 * @export
 * @implements { blink.mojom.RendererAudioInputStreamFactoryInterface }
 */
blink.mojom.RendererAudioInputStreamFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RendererAudioInputStreamFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RendererAudioInputStreamFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RendererAudioInputStreamFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.RendererAudioInputStreamFactoryClientRemote } client
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.AudioParameters } params
   * @param { !boolean } automaticGainControl
   * @param { !number } sharedMemoryCount
   * @param { ?media.mojom.AudioProcessingConfig } processingConfig
   */

  createStream(
      client,
      sessionId,
      params,
      automaticGainControl,
      sharedMemoryCount,
      processingConfig) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        [
          client,
          sessionId,
          params,
          automaticGainControl,
          sharedMemoryCount,
          processingConfig
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(
      inputStreamId,
      outputDeviceId) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        [
          inputStreamId,
          outputDeviceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RendererAudioInputStreamFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryReceiver = class {
  /**
   * @param {!blink.mojom.RendererAudioInputStreamFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RendererAudioInputStreamFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RendererAudioInputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RendererAudioInputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        impl.createStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        impl.associateInputAndOutputForAec.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RendererAudioInputStreamFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererAudioInputStreamFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RendererAudioInputStreamFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RendererAudioInputStreamFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RendererAudioInputStreamFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RendererAudioInputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RendererAudioInputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
        null,
        this.createStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.associateInputAndOutputForAec =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        this.associateInputAndOutputForAec.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.RendererAudioInputStreamFactoryClient');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryClientReceiver');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryClientCallbackRouter');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryClientInterface');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryClientRemote');
goog.provide('blink.mojom.RendererAudioInputStreamFactoryClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RendererAudioInputStreamFactoryClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.RendererAudioInputStreamFactoryClientInterface = class {
  
  /**
   * @param { !media.mojom.AudioInputStreamRemote } stream
   * @param { !media.mojom.AudioInputStreamClientPendingReceiver } clientRequest
   * @param { !media.mojom.ReadWriteAudioDataPipe } dataPipe
   * @param { !boolean } initiallyMuted
   * @param { ?mojoBase.mojom.UnguessableToken } streamId
   */

  streamCreated(stream, clientRequest, dataPipe, initiallyMuted, streamId) {}
};

/**
 * @export
 * @implements { blink.mojom.RendererAudioInputStreamFactoryClientInterface }
 */
blink.mojom.RendererAudioInputStreamFactoryClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RendererAudioInputStreamFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RendererAudioInputStreamFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RendererAudioInputStreamFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioInputStreamRemote } stream
   * @param { !media.mojom.AudioInputStreamClientPendingReceiver } clientRequest
   * @param { !media.mojom.ReadWriteAudioDataPipe } dataPipe
   * @param { !boolean } initiallyMuted
   * @param { ?mojoBase.mojom.UnguessableToken } streamId
   */

  streamCreated(
      stream,
      clientRequest,
      dataPipe,
      initiallyMuted,
      streamId) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        [
          stream,
          clientRequest,
          dataPipe,
          initiallyMuted,
          streamId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RendererAudioInputStreamFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryClientReceiver = class {
  /**
   * @param {!blink.mojom.RendererAudioInputStreamFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RendererAudioInputStreamFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RendererAudioInputStreamFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RendererAudioInputStreamFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        impl.streamCreated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RendererAudioInputStreamFactoryClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererAudioInputStreamFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RendererAudioInputStreamFactoryClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RendererAudioInputStreamFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RendererAudioInputStreamFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RendererAudioInputStreamFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RendererAudioInputStreamFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.streamCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
        null,
        this.streamCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.RendererAudioInputStreamFactory_CreateStream_ParamsSpec.$,
    'RendererAudioInputStreamFactory_CreateStream_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.RendererAudioInputStreamFactoryClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'automaticGainControl', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedMemoryCount', 28,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'processingConfig', 32,
        0,
        media.mojom.AudioProcessingConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.RendererAudioInputStreamFactory_CreateStream_Params');

/** @record */
blink.mojom.RendererAudioInputStreamFactory_CreateStream_Params = class {
  constructor() {
    /** @export { !blink.mojom.RendererAudioInputStreamFactoryClientRemote } */
    this.client;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !media.mojom.AudioParameters } */
    this.params;
    /** @export { !boolean } */
    this.automaticGainControl;
    /** @export { !number } */
    this.sharedMemoryCount;
    /** @export { (media.mojom.AudioProcessingConfig|undefined) } */
    this.processingConfig;
  }
};



mojo.internal.Struct(
    blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
    'RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params',
    [
      mojo.internal.StructField(
        'inputStreamId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputDeviceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params');

/** @record */
blink.mojom.RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.inputStreamId;
    /** @export { !string } */
    this.outputDeviceId;
  }
};



mojo.internal.Struct(
    blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_ParamsSpec.$,
    'RendererAudioInputStreamFactoryClient_StreamCreated_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioInputStreamRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientRequest', 8,
        0,
        mojo.internal.InterfaceRequest(media.mojom.AudioInputStreamClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataPipe', 16,
        0,
        media.mojom.ReadWriteAudioDataPipeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiallyMuted', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamId', 24,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_Params');

/** @record */
blink.mojom.RendererAudioInputStreamFactoryClient_StreamCreated_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioInputStreamRemote } */
    this.stream;
    /** @export { !media.mojom.AudioInputStreamClientPendingReceiver } */
    this.clientRequest;
    /** @export { !media.mojom.ReadWriteAudioDataPipe } */
    this.dataPipe;
    /** @export { !boolean } */
    this.initiallyMuted;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.streamId;
  }
};

