// third_party/blink/public/mojom/navigation/renderer_content_settings.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/navigation/renderer_content_settings.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function RendererContentSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RendererContentSettings.prototype.initDefaults_ = function() {
    this.allowScript = false;
    this.allowImage = false;
    this.allowPopup = false;
    this.allowMixedContent = false;
    this.allowControlledFrame = false;
  };
  RendererContentSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RendererContentSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  RendererContentSettings.encodedSize = codec.kStructHeaderSize + 8;

  RendererContentSettings.decode = function(decoder) {
    var packed;
    var val = new RendererContentSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowScript = (packed >> 0) & 1 ? true : false;
    val.allowImage = (packed >> 1) & 1 ? true : false;
    val.allowPopup = (packed >> 2) & 1 ? true : false;
    val.allowMixedContent = (packed >> 3) & 1 ? true : false;
    val.allowControlledFrame = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RendererContentSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RendererContentSettings.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowScript & 1) << 0
    packed |= (val.allowImage & 1) << 1
    packed |= (val.allowPopup & 1) << 2
    packed |= (val.allowMixedContent & 1) << 3
    packed |= (val.allowControlledFrame & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.RendererContentSettings = RendererContentSettings;
})();