// third_party/blink/public/mojom/page/widget.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ui.mojom.DragOperation');
goog.require('mojoBase.mojom.TextDirection');
goog.require('cc.mojom.TouchAction');
goog.require('blink.mojom.WidgetCompositor');
goog.require('blink.mojom.AllowedDragOperations');
goog.require('blink.mojom.DeviceEmulationParams');
goog.require('blink.mojom.DragData');
goog.require('blink.mojom.IntrinsicSizingInfo');
goog.require('gfx.mojom.Point');
goog.require('gfx.mojom.PointF');
goog.require('gfx.mojom.Rect');
goog.require('blink.mojom.TouchEventConsumers');
goog.require('gfx.mojom.Vector2dF');
goog.require('blink.mojom.ViewportIntersectionState');
goog.require('blink.mojom.VisualProperties');




goog.provide('blink.mojom.DeviceEmulationCacheBehavior');
goog.provide('blink.mojom.DeviceEmulationCacheBehaviorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DeviceEmulationCacheBehaviorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DeviceEmulationCacheBehavior = {
  
  kClearCache: 0,
  kKeepCache: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.FrameWidget');
goog.provide('blink.mojom.FrameWidgetReceiver');
goog.provide('blink.mojom.FrameWidgetCallbackRouter');
goog.provide('blink.mojom.FrameWidgetInterface');
goog.provide('blink.mojom.FrameWidgetRemote');
goog.provide('blink.mojom.FrameWidgetPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FrameWidgetPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FrameWidget.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FrameWidgetInterface = class {
  
  /**
   * @param { !blink.mojom.DragData } dragData
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !blink.mojom.AllowedDragOperations } operationsAllowed
   * @param { !number } keyModifiers
   * @return {!Promise<{
        operation: !ui.mojom.DragOperation,
        documentIsHandlingDrag: !boolean,
   *  }>}
   */

  dragTargetDragEnter(dragData, pointInViewport, screenPoint, operationsAllowed, keyModifiers) {}
  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !blink.mojom.AllowedDragOperations } operationsAllowed
   * @param { !number } keyModifiers
   * @return {!Promise<{
        operation: !ui.mojom.DragOperation,
        documentIsHandlingDrag: !boolean,
   *  }>}
   */

  dragTargetDragOver(pointInViewport, screenPoint, operationsAllowed, keyModifiers) {}
  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   */

  dragTargetDragLeave(pointInViewport, screenPoint) {}
  
  /**
   * @param { !blink.mojom.DragData } dragData
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !number } keyModifiers
   * @return {!Promise}
   */

  dragTargetDrop(dragData, pointInViewport, screenPoint, keyModifiers) {}
  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !ui.mojom.DragOperation } dragOperation
   * @return {!Promise}
   */

  dragSourceEndedAt(pointInViewport, screenPoint, dragOperation) {}
  
  /**
   */

  dragSourceSystemDragEnded() {}
  
  /**
   * @return {!Promise<{
        focusResult: ?blink.mojom.StylusWritingFocusResult,
   *  }>}
   */

  onStartStylusWriting() {}
  
  /**
   * @param { !boolean } opaque
   */

  setBackgroundOpaque(opaque) {}
  
  /**
   * @param { !mojoBase.mojom.TextDirection } direction
   */

  setTextDirection(direction) {}
  
  /**
   * @param { !boolean } active
   */

  setActive(active) {}
  
  /**
   * @param { !cc.mojom.TouchAction } touchAction
   */

  setInheritedEffectiveTouchActionForSubFrame(touchAction) {}
  
  /**
   * @param { !boolean } isThrottled
   * @param { !boolean } subtreeThrottled
   * @param { !boolean } displayLocked
   */

  updateRenderThrottlingStatusForSubFrame(isThrottled, subtreeThrottled, displayLocked) {}
  
  /**
   * @param { !boolean } inert
   */

  setIsInertForSubFrame(inert) {}
  
  /**
   * @param { !blink.mojom.DeviceEmulationParams } parameters
   * @param { !blink.mojom.DeviceEmulationCacheBehavior } cacheBehavior
   */

  enableDeviceEmulation(parameters, cacheBehavior) {}
  
  /**
   */

  disableDeviceEmulation() {}
  
  /**
   * @param { !blink.mojom.WidgetCompositorPendingReceiver } host
   */

  bindWidgetCompositor(host) {}
  
  /**
   * @param { !blink.mojom.ViewportIntersectionState } intersectionState
   * @param { ?blink.mojom.VisualProperties } visualProperties
   */

  setViewportIntersection(intersectionState, visualProperties) {}
  
  /**
   */

  notifyClearedDisplayedGraphics() {}
};

/**
 * @export
 * @implements { blink.mojom.FrameWidgetInterface }
 */
blink.mojom.FrameWidgetRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FrameWidgetPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FrameWidgetPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FrameWidgetPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DragData } dragData
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !blink.mojom.AllowedDragOperations } operationsAllowed
   * @param { !number } keyModifiers
   * @return {!Promise<{
        operation: !ui.mojom.DragOperation,
        documentIsHandlingDrag: !boolean,
   *  }>}
   */

  dragTargetDragEnter(
      dragData,
      pointInViewport,
      screenPoint,
      operationsAllowed,
      keyModifiers) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec.$,
        [
          dragData,
          pointInViewport,
          screenPoint,
          operationsAllowed,
          keyModifiers
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !blink.mojom.AllowedDragOperations } operationsAllowed
   * @param { !number } keyModifiers
   * @return {!Promise<{
        operation: !ui.mojom.DragOperation,
        documentIsHandlingDrag: !boolean,
   *  }>}
   */

  dragTargetDragOver(
      pointInViewport,
      screenPoint,
      operationsAllowed,
      keyModifiers) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec.$,
        [
          pointInViewport,
          screenPoint,
          operationsAllowed,
          keyModifiers
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   */

  dragTargetDragLeave(
      pointInViewport,
      screenPoint) {
    this.proxy.sendMessage(
        2,
        blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec.$,
        null,
        [
          pointInViewport,
          screenPoint
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DragData } dragData
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !number } keyModifiers
   * @return {!Promise}
   */

  dragTargetDrop(
      dragData,
      pointInViewport,
      screenPoint,
      keyModifiers) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec.$,
        [
          dragData,
          pointInViewport,
          screenPoint,
          keyModifiers
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.PointF } pointInViewport
   * @param { !gfx.mojom.PointF } screenPoint
   * @param { !ui.mojom.DragOperation } dragOperation
   * @return {!Promise}
   */

  dragSourceEndedAt(
      pointInViewport,
      screenPoint,
      dragOperation) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec.$,
        blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec.$,
        [
          pointInViewport,
          screenPoint,
          dragOperation
        ],
        false);
  }

  
  /**
   */

  dragSourceSystemDragEnded() {
    this.proxy.sendMessage(
        5,
        blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        focusResult: ?blink.mojom.StylusWritingFocusResult,
   *  }>}
   */

  onStartStylusWriting() {
    return this.proxy.sendMessage(
        6,
        blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec.$,
        blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } opaque
   */

  setBackgroundOpaque(
      opaque) {
    this.proxy.sendMessage(
        7,
        blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec.$,
        null,
        [
          opaque
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TextDirection } direction
   */

  setTextDirection(
      direction) {
    this.proxy.sendMessage(
        8,
        blink.mojom.FrameWidget_SetTextDirection_ParamsSpec.$,
        null,
        [
          direction
        ],
        false);
  }

  
  /**
   * @param { !boolean } active
   */

  setActive(
      active) {
    this.proxy.sendMessage(
        9,
        blink.mojom.FrameWidget_SetActive_ParamsSpec.$,
        null,
        [
          active
        ],
        false);
  }

  
  /**
   * @param { !cc.mojom.TouchAction } touchAction
   */

  setInheritedEffectiveTouchActionForSubFrame(
      touchAction) {
    this.proxy.sendMessage(
        10,
        blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec.$,
        null,
        [
          touchAction
        ],
        false);
  }

  
  /**
   * @param { !boolean } isThrottled
   * @param { !boolean } subtreeThrottled
   * @param { !boolean } displayLocked
   */

  updateRenderThrottlingStatusForSubFrame(
      isThrottled,
      subtreeThrottled,
      displayLocked) {
    this.proxy.sendMessage(
        11,
        blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec.$,
        null,
        [
          isThrottled,
          subtreeThrottled,
          displayLocked
        ],
        false);
  }

  
  /**
   * @param { !boolean } inert
   */

  setIsInertForSubFrame(
      inert) {
    this.proxy.sendMessage(
        12,
        blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec.$,
        null,
        [
          inert
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DeviceEmulationParams } parameters
   * @param { !blink.mojom.DeviceEmulationCacheBehavior } cacheBehavior
   */

  enableDeviceEmulation(
      parameters,
      cacheBehavior) {
    this.proxy.sendMessage(
        13,
        blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec.$,
        null,
        [
          parameters,
          cacheBehavior
        ],
        false);
  }

  
  /**
   */

  disableDeviceEmulation() {
    this.proxy.sendMessage(
        14,
        blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WidgetCompositorPendingReceiver } host
   */

  bindWidgetCompositor(
      host) {
    this.proxy.sendMessage(
        15,
        blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ViewportIntersectionState } intersectionState
   * @param { ?blink.mojom.VisualProperties } visualProperties
   */

  setViewportIntersection(
      intersectionState,
      visualProperties) {
    this.proxy.sendMessage(
        16,
        blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec.$,
        null,
        [
          intersectionState,
          visualProperties
        ],
        false);
  }

  
  /**
   */

  notifyClearedDisplayedGraphics() {
    this.proxy.sendMessage(
        17,
        blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrameWidget
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FrameWidgetReceiver = class {
  /**
   * @param {!blink.mojom.FrameWidgetInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FrameWidgetRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FrameWidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec.$,
        impl.dragTargetDragEnter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec.$,
        impl.dragTargetDragOver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec.$,
        null,
        impl.dragTargetDragLeave.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec.$,
        impl.dragTargetDrop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec.$,
        blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec.$,
        impl.dragSourceEndedAt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec.$,
        null,
        impl.dragSourceSystemDragEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec.$,
        blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec.$,
        impl.onStartStylusWriting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec.$,
        null,
        impl.setBackgroundOpaque.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FrameWidget_SetTextDirection_ParamsSpec.$,
        null,
        impl.setTextDirection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FrameWidget_SetActive_ParamsSpec.$,
        null,
        impl.setActive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec.$,
        null,
        impl.setInheritedEffectiveTouchActionForSubFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec.$,
        null,
        impl.updateRenderThrottlingStatusForSubFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec.$,
        null,
        impl.setIsInertForSubFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec.$,
        null,
        impl.enableDeviceEmulation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec.$,
        null,
        impl.disableDeviceEmulation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec.$,
        null,
        impl.bindWidgetCompositor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec.$,
        null,
        impl.setViewportIntersection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec.$,
        null,
        impl.notifyClearedDisplayedGraphics.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FrameWidget = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameWidget";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FrameWidgetRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FrameWidgetRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameWidget
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FrameWidgetCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FrameWidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragTargetDragEnter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec.$,
        this.dragTargetDragEnter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragTargetDragOver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec.$,
        this.dragTargetDragOver.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragTargetDragLeave =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec.$,
        null,
        this.dragTargetDragLeave.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragTargetDrop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec.$,
        blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec.$,
        this.dragTargetDrop.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragSourceEndedAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec.$,
        blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec.$,
        this.dragSourceEndedAt.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dragSourceSystemDragEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec.$,
        null,
        this.dragSourceSystemDragEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStartStylusWriting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec.$,
        blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec.$,
        this.onStartStylusWriting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBackgroundOpaque =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec.$,
        null,
        this.setBackgroundOpaque.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTextDirection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FrameWidget_SetTextDirection_ParamsSpec.$,
        null,
        this.setTextDirection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setActive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FrameWidget_SetActive_ParamsSpec.$,
        null,
        this.setActive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInheritedEffectiveTouchActionForSubFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec.$,
        null,
        this.setInheritedEffectiveTouchActionForSubFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRenderThrottlingStatusForSubFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec.$,
        null,
        this.updateRenderThrottlingStatusForSubFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsInertForSubFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec.$,
        null,
        this.setIsInertForSubFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDeviceEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec.$,
        null,
        this.enableDeviceEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableDeviceEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec.$,
        null,
        this.disableDeviceEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindWidgetCompositor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec.$,
        null,
        this.bindWidgetCompositor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setViewportIntersection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec.$,
        null,
        this.setViewportIntersection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyClearedDisplayedGraphics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec.$,
        null,
        this.notifyClearedDisplayedGraphics.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FrameWidgetHost');
goog.provide('blink.mojom.FrameWidgetHostReceiver');
goog.provide('blink.mojom.FrameWidgetHostCallbackRouter');
goog.provide('blink.mojom.FrameWidgetHostInterface');
goog.provide('blink.mojom.FrameWidgetHostRemote');
goog.provide('blink.mojom.FrameWidgetHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FrameWidgetHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FrameWidgetHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FrameWidgetHostInterface = class {
  
  /**
   * @param { !gfx.mojom.Point } tapPoint
   * @param { !gfx.mojom.Rect } rectToZoom
   */

  animateDoubleTapZoomInMainFrame(tapPoint, rectToZoom) {}
  
  /**
   * @param { !gfx.mojom.Rect } rectToZoom
   */

  zoomToFindInPageRectInMainFrame(rectToZoom) {}
  
  /**
   * @param { !blink.mojom.TouchEventConsumers } touchEventConsumers
   */

  setHasTouchEventConsumers(touchEventConsumers) {}
  
  /**
   * @param { !blink.mojom.IntrinsicSizingInfo } sizingInfo
   */

  intrinsicSizingInfoChanged(sizingInfo) {}
  
  /**
   * @param { !gfx.mojom.PointF } position
   */

  autoscrollStart(position) {}
  
  /**
   * @param { !gfx.mojom.Vector2dF } velocity
   */

  autoscrollFling(velocity) {}
  
  /**
   */

  autoscrollEnd() {}
};

/**
 * @export
 * @implements { blink.mojom.FrameWidgetHostInterface }
 */
blink.mojom.FrameWidgetHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FrameWidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FrameWidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FrameWidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx.mojom.Point } tapPoint
   * @param { !gfx.mojom.Rect } rectToZoom
   */

  animateDoubleTapZoomInMainFrame(
      tapPoint,
      rectToZoom) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec.$,
        null,
        [
          tapPoint,
          rectToZoom
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } rectToZoom
   */

  zoomToFindInPageRectInMainFrame(
      rectToZoom) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec.$,
        null,
        [
          rectToZoom
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.TouchEventConsumers } touchEventConsumers
   */

  setHasTouchEventConsumers(
      touchEventConsumers) {
    this.proxy.sendMessage(
        2,
        blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec.$,
        null,
        [
          touchEventConsumers
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IntrinsicSizingInfo } sizingInfo
   */

  intrinsicSizingInfoChanged(
      sizingInfo) {
    this.proxy.sendMessage(
        3,
        blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec.$,
        null,
        [
          sizingInfo
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.PointF } position
   */

  autoscrollStart(
      position) {
    this.proxy.sendMessage(
        4,
        blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Vector2dF } velocity
   */

  autoscrollFling(
      velocity) {
    this.proxy.sendMessage(
        5,
        blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec.$,
        null,
        [
          velocity
        ],
        false);
  }

  
  /**
   */

  autoscrollEnd() {
    this.proxy.sendMessage(
        6,
        blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrameWidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FrameWidgetHostReceiver = class {
  /**
   * @param {!blink.mojom.FrameWidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FrameWidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FrameWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec.$,
        null,
        impl.animateDoubleTapZoomInMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec.$,
        null,
        impl.zoomToFindInPageRectInMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec.$,
        null,
        impl.setHasTouchEventConsumers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec.$,
        null,
        impl.intrinsicSizingInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec.$,
        null,
        impl.autoscrollStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec.$,
        null,
        impl.autoscrollFling.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec.$,
        null,
        impl.autoscrollEnd.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FrameWidgetHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameWidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FrameWidgetHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FrameWidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameWidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FrameWidgetHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FrameWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.animateDoubleTapZoomInMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec.$,
        null,
        this.animateDoubleTapZoomInMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.zoomToFindInPageRectInMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec.$,
        null,
        this.zoomToFindInPageRectInMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasTouchEventConsumers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec.$,
        null,
        this.setHasTouchEventConsumers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.intrinsicSizingInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec.$,
        null,
        this.intrinsicSizingInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.autoscrollStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec.$,
        null,
        this.autoscrollStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.autoscrollFling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec.$,
        null,
        this.autoscrollFling.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.autoscrollEnd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec.$,
        null,
        this.autoscrollEnd.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PopupWidgetHost');
goog.provide('blink.mojom.PopupWidgetHostReceiver');
goog.provide('blink.mojom.PopupWidgetHostCallbackRouter');
goog.provide('blink.mojom.PopupWidgetHostInterface');
goog.provide('blink.mojom.PopupWidgetHostRemote');
goog.provide('blink.mojom.PopupWidgetHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PopupWidgetHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PopupWidgetHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PopupWidgetHostInterface = class {
  
  /**
   */

  requestClosePopup() {}
  
  /**
   * @param { !gfx.mojom.Rect } initialRect
   * @param { !gfx.mojom.Rect } anchorRect
   * @return {!Promise}
   */

  showPopup(initialRect, anchorRect) {}
  
  /**
   * @param { !gfx.mojom.Rect } bounds
   * @return {!Promise}
   */

  setPopupBounds(bounds) {}
};

/**
 * @export
 * @implements { blink.mojom.PopupWidgetHostInterface }
 */
blink.mojom.PopupWidgetHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PopupWidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PopupWidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PopupWidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestClosePopup() {
    this.proxy.sendMessage(
        0,
        blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } initialRect
   * @param { !gfx.mojom.Rect } anchorRect
   * @return {!Promise}
   */

  showPopup(
      initialRect,
      anchorRect) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec.$,
        [
          initialRect,
          anchorRect
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } bounds
   * @return {!Promise}
   */

  setPopupBounds(
      bounds) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec.$,
        [
          bounds
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PopupWidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PopupWidgetHostReceiver = class {
  /**
   * @param {!blink.mojom.PopupWidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PopupWidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PopupWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PopupWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec.$,
        null,
        impl.requestClosePopup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec.$,
        impl.showPopup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec.$,
        impl.setPopupBounds.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PopupWidgetHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PopupWidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PopupWidgetHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PopupWidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PopupWidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PopupWidgetHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PopupWidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PopupWidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestClosePopup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec.$,
        null,
        this.requestClosePopup.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showPopup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec.$,
        this.showPopup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPopupBounds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec.$,
        blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec.$,
        this.setPopupBounds.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.StylusWritingFocusResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StylusWritingFocusResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetTextDirection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetTextDirection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetActive_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetActive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.StylusWritingFocusResultSpec.$,
    'StylusWritingFocusResult',
    [
      mojo.internal.StructField(
        'focusedEditBounds', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'caretBounds', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StylusWritingFocusResult');

/** @record */
blink.mojom.StylusWritingFocusResult = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.focusedEditBounds;
    /** @export { !gfx.mojom.Rect } */
    this.caretBounds;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDragEnter_ParamsSpec.$,
    'FrameWidget_DragTargetDragEnter_Params',
    [
      mojo.internal.StructField(
        'dragData', 0,
        0,
        blink.mojom.DragDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointInViewport', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPoint', 16,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operationsAllowed', 24,
        0,
        blink.mojom.AllowedDragOperationsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyModifiers', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDragEnter_Params');

/** @record */
blink.mojom.FrameWidget_DragTargetDragEnter_Params = class {
  constructor() {
    /** @export { !blink.mojom.DragData } */
    this.dragData;
    /** @export { !gfx.mojom.PointF } */
    this.pointInViewport;
    /** @export { !gfx.mojom.PointF } */
    this.screenPoint;
    /** @export { !blink.mojom.AllowedDragOperations } */
    this.operationsAllowed;
    /** @export { !number } */
    this.keyModifiers;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParamsSpec.$,
    'FrameWidget_DragTargetDragEnter_ResponseParams',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        ui.mojom.DragOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentIsHandlingDrag', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParams');

/** @record */
blink.mojom.FrameWidget_DragTargetDragEnter_ResponseParams = class {
  constructor() {
    /** @export { !ui.mojom.DragOperation } */
    this.operation;
    /** @export { !boolean } */
    this.documentIsHandlingDrag;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDragOver_ParamsSpec.$,
    'FrameWidget_DragTargetDragOver_Params',
    [
      mojo.internal.StructField(
        'pointInViewport', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPoint', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operationsAllowed', 16,
        0,
        blink.mojom.AllowedDragOperationsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyModifiers', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDragOver_Params');

/** @record */
blink.mojom.FrameWidget_DragTargetDragOver_Params = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.pointInViewport;
    /** @export { !gfx.mojom.PointF } */
    this.screenPoint;
    /** @export { !blink.mojom.AllowedDragOperations } */
    this.operationsAllowed;
    /** @export { !number } */
    this.keyModifiers;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDragOver_ResponseParamsSpec.$,
    'FrameWidget_DragTargetDragOver_ResponseParams',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        ui.mojom.DragOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentIsHandlingDrag', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDragOver_ResponseParams');

/** @record */
blink.mojom.FrameWidget_DragTargetDragOver_ResponseParams = class {
  constructor() {
    /** @export { !ui.mojom.DragOperation } */
    this.operation;
    /** @export { !boolean } */
    this.documentIsHandlingDrag;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDragLeave_ParamsSpec.$,
    'FrameWidget_DragTargetDragLeave_Params',
    [
      mojo.internal.StructField(
        'pointInViewport', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPoint', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDragLeave_Params');

/** @record */
blink.mojom.FrameWidget_DragTargetDragLeave_Params = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.pointInViewport;
    /** @export { !gfx.mojom.PointF } */
    this.screenPoint;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDrop_ParamsSpec.$,
    'FrameWidget_DragTargetDrop_Params',
    [
      mojo.internal.StructField(
        'dragData', 0,
        0,
        blink.mojom.DragDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointInViewport', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPoint', 16,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyModifiers', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDrop_Params');

/** @record */
blink.mojom.FrameWidget_DragTargetDrop_Params = class {
  constructor() {
    /** @export { !blink.mojom.DragData } */
    this.dragData;
    /** @export { !gfx.mojom.PointF } */
    this.pointInViewport;
    /** @export { !gfx.mojom.PointF } */
    this.screenPoint;
    /** @export { !number } */
    this.keyModifiers;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragTargetDrop_ResponseParamsSpec.$,
    'FrameWidget_DragTargetDrop_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_DragTargetDrop_ResponseParams');

/** @record */
blink.mojom.FrameWidget_DragTargetDrop_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragSourceEndedAt_ParamsSpec.$,
    'FrameWidget_DragSourceEndedAt_Params',
    [
      mojo.internal.StructField(
        'pointInViewport', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPoint', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dragOperation', 16,
        0,
        ui.mojom.DragOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FrameWidget_DragSourceEndedAt_Params');

/** @record */
blink.mojom.FrameWidget_DragSourceEndedAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.pointInViewport;
    /** @export { !gfx.mojom.PointF } */
    this.screenPoint;
    /** @export { !ui.mojom.DragOperation } */
    this.dragOperation;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParamsSpec.$,
    'FrameWidget_DragSourceEndedAt_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParams');

/** @record */
blink.mojom.FrameWidget_DragSourceEndedAt_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DragSourceSystemDragEnded_ParamsSpec.$,
    'FrameWidget_DragSourceSystemDragEnded_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_DragSourceSystemDragEnded_Params');

/** @record */
blink.mojom.FrameWidget_DragSourceSystemDragEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_OnStartStylusWriting_ParamsSpec.$,
    'FrameWidget_OnStartStylusWriting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_OnStartStylusWriting_Params');

/** @record */
blink.mojom.FrameWidget_OnStartStylusWriting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParamsSpec.$,
    'FrameWidget_OnStartStylusWriting_ResponseParams',
    [
      mojo.internal.StructField(
        'focusResult', 0,
        0,
        blink.mojom.StylusWritingFocusResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParams');

/** @record */
blink.mojom.FrameWidget_OnStartStylusWriting_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.StylusWritingFocusResult|undefined) } */
    this.focusResult;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetBackgroundOpaque_ParamsSpec.$,
    'FrameWidget_SetBackgroundOpaque_Params',
    [
      mojo.internal.StructField(
        'opaque', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_SetBackgroundOpaque_Params');

/** @record */
blink.mojom.FrameWidget_SetBackgroundOpaque_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.opaque;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetTextDirection_ParamsSpec.$,
    'FrameWidget_SetTextDirection_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_SetTextDirection_Params');

/** @record */
blink.mojom.FrameWidget_SetTextDirection_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TextDirection } */
    this.direction;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetActive_ParamsSpec.$,
    'FrameWidget_SetActive_Params',
    [
      mojo.internal.StructField(
        'active', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_SetActive_Params');

/** @record */
blink.mojom.FrameWidget_SetActive_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.active;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsSpec.$,
    'FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc.mojom.TouchActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params');

/** @record */
blink.mojom.FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params = class {
  constructor() {
    /** @export { !cc.mojom.TouchAction } */
    this.touchAction;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsSpec.$,
    'FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params',
    [
      mojo.internal.StructField(
        'isThrottled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subtreeThrottled', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayLocked', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params');

/** @record */
blink.mojom.FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isThrottled;
    /** @export { !boolean } */
    this.subtreeThrottled;
    /** @export { !boolean } */
    this.displayLocked;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetIsInertForSubFrame_ParamsSpec.$,
    'FrameWidget_SetIsInertForSubFrame_Params',
    [
      mojo.internal.StructField(
        'inert', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_SetIsInertForSubFrame_Params');

/** @record */
blink.mojom.FrameWidget_SetIsInertForSubFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.inert;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_EnableDeviceEmulation_ParamsSpec.$,
    'FrameWidget_EnableDeviceEmulation_Params',
    [
      mojo.internal.StructField(
        'parameters', 0,
        0,
        blink.mojom.DeviceEmulationParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheBehavior', 8,
        0,
        blink.mojom.DeviceEmulationCacheBehaviorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidget_EnableDeviceEmulation_Params');

/** @record */
blink.mojom.FrameWidget_EnableDeviceEmulation_Params = class {
  constructor() {
    /** @export { !blink.mojom.DeviceEmulationParams } */
    this.parameters;
    /** @export { !blink.mojom.DeviceEmulationCacheBehavior } */
    this.cacheBehavior;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_DisableDeviceEmulation_ParamsSpec.$,
    'FrameWidget_DisableDeviceEmulation_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_DisableDeviceEmulation_Params');

/** @record */
blink.mojom.FrameWidget_DisableDeviceEmulation_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_BindWidgetCompositor_ParamsSpec.$,
    'FrameWidget_BindWidgetCompositor_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.WidgetCompositorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidget_BindWidgetCompositor_Params');

/** @record */
blink.mojom.FrameWidget_BindWidgetCompositor_Params = class {
  constructor() {
    /** @export { !blink.mojom.WidgetCompositorPendingReceiver } */
    this.host;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_SetViewportIntersection_ParamsSpec.$,
    'FrameWidget_SetViewportIntersection_Params',
    [
      mojo.internal.StructField(
        'intersectionState', 0,
        0,
        blink.mojom.ViewportIntersectionStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visualProperties', 8,
        0,
        blink.mojom.VisualPropertiesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidget_SetViewportIntersection_Params');

/** @record */
blink.mojom.FrameWidget_SetViewportIntersection_Params = class {
  constructor() {
    /** @export { !blink.mojom.ViewportIntersectionState } */
    this.intersectionState;
    /** @export { (blink.mojom.VisualProperties|undefined) } */
    this.visualProperties;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_ParamsSpec.$,
    'FrameWidget_NotifyClearedDisplayedGraphics_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_Params');

/** @record */
blink.mojom.FrameWidget_NotifyClearedDisplayedGraphics_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsSpec.$,
    'FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params',
    [
      mojo.internal.StructField(
        'tapPoint', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rectToZoom', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params');

/** @record */
blink.mojom.FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.tapPoint;
    /** @export { !gfx.mojom.Rect } */
    this.rectToZoom;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsSpec.$,
    'FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params',
    [
      mojo.internal.StructField(
        'rectToZoom', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params');

/** @record */
blink.mojom.FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.rectToZoom;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_ParamsSpec.$,
    'FrameWidgetHost_SetHasTouchEventConsumers_Params',
    [
      mojo.internal.StructField(
        'touchEventConsumers', 0,
        0,
        blink.mojom.TouchEventConsumersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_Params');

/** @record */
blink.mojom.FrameWidgetHost_SetHasTouchEventConsumers_Params = class {
  constructor() {
    /** @export { !blink.mojom.TouchEventConsumers } */
    this.touchEventConsumers;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsSpec.$,
    'FrameWidgetHost_IntrinsicSizingInfoChanged_Params',
    [
      mojo.internal.StructField(
        'sizingInfo', 0,
        0,
        blink.mojom.IntrinsicSizingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_Params');

/** @record */
blink.mojom.FrameWidgetHost_IntrinsicSizingInfoChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.IntrinsicSizingInfo } */
    this.sizingInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_AutoscrollStart_ParamsSpec.$,
    'FrameWidgetHost_AutoscrollStart_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetHost_AutoscrollStart_Params');

/** @record */
blink.mojom.FrameWidgetHost_AutoscrollStart_Params = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.position;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_AutoscrollFling_ParamsSpec.$,
    'FrameWidgetHost_AutoscrollFling_Params',
    [
      mojo.internal.StructField(
        'velocity', 0,
        0,
        gfx.mojom.Vector2dFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetHost_AutoscrollFling_Params');

/** @record */
blink.mojom.FrameWidgetHost_AutoscrollFling_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Vector2dF } */
    this.velocity;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetHost_AutoscrollEnd_ParamsSpec.$,
    'FrameWidgetHost_AutoscrollEnd_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetHost_AutoscrollEnd_Params');

/** @record */
blink.mojom.FrameWidgetHost_AutoscrollEnd_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PopupWidgetHost_RequestClosePopup_ParamsSpec.$,
    'PopupWidgetHost_RequestClosePopup_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.PopupWidgetHost_RequestClosePopup_Params');

/** @record */
blink.mojom.PopupWidgetHost_RequestClosePopup_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PopupWidgetHost_ShowPopup_ParamsSpec.$,
    'PopupWidgetHost_ShowPopup_Params',
    [
      mojo.internal.StructField(
        'initialRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'anchorRect', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PopupWidgetHost_ShowPopup_Params');

/** @record */
blink.mojom.PopupWidgetHost_ShowPopup_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.initialRect;
    /** @export { !gfx.mojom.Rect } */
    this.anchorRect;
  }
};



mojo.internal.Struct(
    blink.mojom.PopupWidgetHost_ShowPopup_ResponseParamsSpec.$,
    'PopupWidgetHost_ShowPopup_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.PopupWidgetHost_ShowPopup_ResponseParams');

/** @record */
blink.mojom.PopupWidgetHost_ShowPopup_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PopupWidgetHost_SetPopupBounds_ParamsSpec.$,
    'PopupWidgetHost_SetPopupBounds_Params',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PopupWidgetHost_SetPopupBounds_Params');

/** @record */
blink.mojom.PopupWidgetHost_SetPopupBounds_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
  }
};



mojo.internal.Struct(
    blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParamsSpec.$,
    'PopupWidgetHost_SetPopupBounds_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParams');

/** @record */
blink.mojom.PopupWidgetHost_SetPopupBounds_ResponseParams = class {
  constructor() {
  }
};

