// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ByteCount as mojoBase_mojom_ByteCount,
  ByteCountSpec as mojoBase_mojom_ByteCountSpec
} from '../../../../../mojo/public/mojom/base/byte_count.mojom.m.js';

import {
  ExecutionContextToken as blink_mojom_ExecutionContextToken,
  ExecutionContextTokenSpec as blink_mojom_ExecutionContextTokenSpec
} from '../tokens/tokens.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class V8DetailedMemoryReporterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.V8DetailedMemoryReporter', scope);
  }
}

/** @interface */
export class V8DetailedMemoryReporterInterface {
  
  /**
   * @param { !V8DetailedMemoryReporter_Mode } mode
   * @return {!Promise<{
        memoryUsage: !PerProcessV8MemoryUsage,
   *  }>}
   */

  getV8MemoryUsage(mode) {}
}

/**
 * @implements { V8DetailedMemoryReporterInterface }
 */
export class V8DetailedMemoryReporterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!V8DetailedMemoryReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          V8DetailedMemoryReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!V8DetailedMemoryReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !V8DetailedMemoryReporter_Mode } mode
   * @return {!Promise<{
        memoryUsage: !PerProcessV8MemoryUsage,
   *  }>}
   */

  getV8MemoryUsage(
      mode) {
    return this.proxy.sendMessage(
        0,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }
}

/**
 * An object which receives request messages for the V8DetailedMemoryReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class V8DetailedMemoryReporterReceiver {
  /**
   * @param {!V8DetailedMemoryReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!V8DetailedMemoryReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        V8DetailedMemoryReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!V8DetailedMemoryReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        impl.getV8MemoryUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class V8DetailedMemoryReporter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.V8DetailedMemoryReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!V8DetailedMemoryReporterRemote}
   */
  static getRemote() {
    let remote = new V8DetailedMemoryReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const V8DetailedMemoryReporter_ModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const V8DetailedMemoryReporter_Mode = {
  
  DEFAULT: 0,
  EAGER: 1,
  LAZY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the V8DetailedMemoryReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class V8DetailedMemoryReporterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      V8DetailedMemoryReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!V8DetailedMemoryReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getV8MemoryUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
        V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
        this.getV8MemoryUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PerContextV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PerContextCanvasMemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PerIsolateV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PerProcessV8MemoryUsageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PerContextV8MemoryUsageSpec.$,
    'PerContextV8MemoryUsage',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_ExecutionContextTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'memoryUsed', 16,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PerContextV8MemoryUsage {
  constructor() {
    /** @type { !blink_mojom_ExecutionContextToken } */
    this.token;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.memoryUsed;
    /** @type { (string|undefined) } */
    this.url;
  }
}



mojo.internal.Struct(
    PerContextCanvasMemoryUsageSpec.$,
    'PerContextCanvasMemoryUsage',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_ExecutionContextTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'memoryUsed', 16,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PerContextCanvasMemoryUsage {
  constructor() {
    /** @type { !blink_mojom_ExecutionContextToken } */
    this.token;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.memoryUsed;
  }
}



mojo.internal.Struct(
    PerIsolateV8MemoryUsageSpec.$,
    'PerIsolateV8MemoryUsage',
    [
      mojo.internal.StructField(
        'numDetachedContexts', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'detachedMemoryUsed', 8,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedMemoryUsed', 16,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blinkMemoryUsed', 24,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contexts', 32,
        0,
        mojo.internal.Array(PerContextV8MemoryUsageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canvasContexts', 40,
        0,
        mojo.internal.Array(PerContextCanvasMemoryUsageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PerIsolateV8MemoryUsage {
  constructor() {
    /** @type { !bigint } */
    this.numDetachedContexts;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.detachedMemoryUsed;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.sharedMemoryUsed;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.blinkMemoryUsed;
    /** @type { !Array<!PerContextV8MemoryUsage> } */
    this.contexts;
    /** @type { !Array<!PerContextCanvasMemoryUsage> } */
    this.canvasContexts;
  }
}



mojo.internal.Struct(
    PerProcessV8MemoryUsageSpec.$,
    'PerProcessV8MemoryUsage',
    [
      mojo.internal.StructField(
        'isolates', 0,
        0,
        mojo.internal.Array(PerIsolateV8MemoryUsageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PerProcessV8MemoryUsage {
  constructor() {
    /** @type { !Array<!PerIsolateV8MemoryUsage> } */
    this.isolates;
  }
}



mojo.internal.Struct(
    V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsSpec.$,
    'V8DetailedMemoryReporter_GetV8MemoryUsage_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        V8DetailedMemoryReporter_ModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class V8DetailedMemoryReporter_GetV8MemoryUsage_Params {
  constructor() {
    /** @type { !V8DetailedMemoryReporter_Mode } */
    this.mode;
  }
}



mojo.internal.Struct(
    V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsSpec.$,
    'V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'memoryUsage', 0,
        0,
        PerProcessV8MemoryUsageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams {
  constructor() {
    /** @type { !PerProcessV8MemoryUsage } */
    this.memoryUsage;
  }
}

