// third_party/blink/public/mojom/plugins/plugin_registry.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PluginRegistryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PluginRegistry.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PluginRegistryInterface }
 */
blink.mojom.PluginRegistryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PluginRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PluginRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PluginRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } refresh
   * @return {!Promise<{
        plugins: !Array<!blink.mojom.PluginInfo>,
   *  }>}
   */

  getPlugins(
      refresh) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.PluginRegistry_GetPlugins_ParamsSpec.$,
        blink.mojom.PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        [
          refresh
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PluginRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PluginRegistryReceiver = class {
  /**
   * @param {!blink.mojom.PluginRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PluginRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PluginRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PluginRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PluginRegistry_GetPlugins_ParamsSpec.$,
        blink.mojom.PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        impl.getPlugins.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PluginRegistry = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PluginRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PluginRegistryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PluginRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PluginRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PluginRegistryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PluginRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PluginRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlugins =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PluginRegistry_GetPlugins_ParamsSpec.$,
        blink.mojom.PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        this.getPlugins.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PluginMimeTypeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PluginInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PluginRegistry_GetPlugins_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PluginRegistry_GetPlugins_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PluginMimeTypeSpec.$,
    'PluginMimeType',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileExtensions', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PluginMimeType = class {
  constructor() {
    /** @export { !string } */
    this.mimeType;
    /** @export { !mojoBase.mojom.String16 } */
    this.description;
    /** @export { !Array<!string> } */
    this.fileExtensions;
  }
};



mojo.internal.Struct(
    blink.mojom.PluginInfoSpec.$,
    'PluginInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filename', 16,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'backgroundColor', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeTypes', 32,
        0,
        mojo.internal.Array(blink.mojom.PluginMimeTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mayUseExternalHandler', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.PluginInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.name;
    /** @export { !mojoBase.mojom.String16 } */
    this.description;
    /** @export { !mojoBase.mojom.FilePath } */
    this.filename;
    /** @export { !number } */
    this.backgroundColor;
    /** @export { !Array<!blink.mojom.PluginMimeType> } */
    this.mimeTypes;
    /** @export { !boolean } */
    this.mayUseExternalHandler;
  }
};



mojo.internal.Struct(
    blink.mojom.PluginRegistry_GetPlugins_ParamsSpec.$,
    'PluginRegistry_GetPlugins_Params',
    [
      mojo.internal.StructField(
        'refresh', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PluginRegistry_GetPlugins_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.refresh;
  }
};



mojo.internal.Struct(
    blink.mojom.PluginRegistry_GetPlugins_ResponseParamsSpec.$,
    'PluginRegistry_GetPlugins_ResponseParams',
    [
      mojo.internal.StructField(
        'plugins', 0,
        0,
        mojo.internal.Array(blink.mojom.PluginInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PluginRegistry_GetPlugins_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PluginInfo> } */
    this.plugins;
  }
};

