// third_party/blink/public/mojom/printing/web_printing.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintingMultipleDocumentHandlingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintingMultipleDocumentHandling = {
  
  kSeparateDocumentsCollatedCopies: 0,
  kSeparateDocumentsUncollatedCopies: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintingSidesSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintingSides = {
  
  kOneSided: 0,
  kTwoSidedLongEdge: 1,
  kTwoSidedShortEdge: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintQualitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintQuality = {
  
  kDraft: 0,
  kNormal: 1,
  kHigh: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintColorModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintColorMode = {
  
  kColor: 0,
  kMonochrome: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintingOrientationRequestedSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintingOrientationRequested = {
  
  kPortrait: 0,
  kLandscape: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrinterStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrinterState = {
  
  kIdle: 0,
  kProcessing: 1,
  kStopped: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrinterStateReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrinterStateReason = {
  
  kNone: 0,
  kOther: 1,
  kConnectingToDevice: 2,
  kCoverOpen: 3,
  kDeveloperEmpty: 4,
  kDeveloperLow: 5,
  kDoorOpen: 6,
  kFuserOverTemp: 7,
  kFuserUnderTemp: 8,
  kInputTrayMissing: 9,
  kInterlockOpen: 10,
  kInterpreterResourceUnavailable: 11,
  kMarkerSupplyEmpty: 12,
  kMarkerSupplyLow: 13,
  kMarkerWasteAlmostFull: 14,
  kMarkerWasteFull: 15,
  kMediaEmpty: 16,
  kMediaJam: 17,
  kMediaLow: 18,
  kMediaNeeded: 19,
  kMovingToPaused: 20,
  kOpcLifeOver: 21,
  kOpcNearEol: 22,
  kOutputAreaAlmostFull: 23,
  kOutputAreaFull: 24,
  kOutputTrayMissing: 25,
  kPaused: 26,
  kShutdown: 27,
  kSpoolAreaFull: 28,
  kStoppedPartly: 29,
  kStopping: 30,
  kTimedOut: 31,
  kTonerEmpty: 32,
  kTonerLow: 33,
  kCupsPkiExpired: 34,
  MIN_VALUE: 0,
  MAX_VALUE: 34,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintJobStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintJobState = {
  
  kPending: 0,
  kProcessing: 1,
  kCompleted: 2,
  kCanceled: 3,
  kAborted: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GetPrintersErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.GetPrintersError = {
  
  kUserPermissionDenied: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrinterFetchErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrinterFetchError = {
  
  kPrinterUnreachable: 0,
  kUserPermissionDenied: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WebPrintError = {
  
  kPrinterUnreachable: 0,
  kDocumentMalformed: 1,
  kPrintJobTemplateAttributesMismatch: 2,
  kUserPermissionDenied: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebPrintJobStateObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebPrintJobStateObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebPrintJobStateObserverInterface }
 */
blink.mojom.WebPrintJobStateObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebPrintJobStateObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebPrintJobStateObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebPrintJobStateObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.WebPrintJobUpdate } update
   */

  onWebPrintJobUpdate(
      update) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebPrintJobStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebPrintJobStateObserverReceiver = class {
  /**
   * @param {!blink.mojom.WebPrintJobStateObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebPrintJobStateObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebPrintJobStateObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintJobStateObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        impl.onWebPrintJobUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebPrintJobStateObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintJobStateObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebPrintJobStateObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebPrintJobStateObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebPrintJobStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebPrintJobStateObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebPrintJobStateObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintJobStateObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebPrintJobUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
        null,
        this.onWebPrintJobUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebPrintJobControllerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebPrintJobController.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebPrintJobControllerInterface }
 */
blink.mojom.WebPrintJobControllerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebPrintJobControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebPrintJobControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebPrintJobControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        0,
        blink.mojom.WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebPrintJobController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebPrintJobControllerReceiver = class {
  /**
   * @param {!blink.mojom.WebPrintJobControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebPrintJobControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebPrintJobControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintJobControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebPrintJobController = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintJobController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebPrintJobControllerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebPrintJobControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebPrintJobController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebPrintJobControllerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebPrintJobControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintJobControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintJobController_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebPrinterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebPrinter.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebPrinterInterface }
 */
blink.mojom.WebPrinterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebPrinterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebPrinterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebPrinterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.WebPrinterFetchResult,
   *  }>}
   */

  fetchAttributes() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.WebPrinter_FetchAttributes_ParamsSpec.$,
        blink.mojom.WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BlobRemote } document
   * @param { !blink.mojom.WebPrintJobTemplateAttributes } attributes
   * @return {!Promise<{
        result: !blink.mojom.WebPrintResult,
   *  }>}
   */

  print(
      document,
      attributes) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.WebPrinter_Print_ParamsSpec.$,
        blink.mojom.WebPrinter_Print_ResponseParamsSpec.$,
        [
          document,
          attributes
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebPrinter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebPrinterReceiver = class {
  /**
   * @param {!blink.mojom.WebPrinterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebPrinterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebPrinterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrinterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrinter_FetchAttributes_ParamsSpec.$,
        blink.mojom.WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        impl.fetchAttributes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WebPrinter_Print_ParamsSpec.$,
        blink.mojom.WebPrinter_Print_ResponseParamsSpec.$,
        impl.print.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebPrinter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrinter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebPrinterRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebPrinterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebPrinter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebPrinterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebPrinterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrinterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchAttributes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrinter_FetchAttributes_ParamsSpec.$,
        blink.mojom.WebPrinter_FetchAttributes_ResponseParamsSpec.$,
        this.fetchAttributes.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.print =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WebPrinter_Print_ParamsSpec.$,
        blink.mojom.WebPrinter_Print_ResponseParamsSpec.$,
        this.print.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebPrintingServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebPrintingService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebPrintingServiceInterface }
 */
blink.mojom.WebPrintingServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebPrintingServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebPrintingServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebPrintingServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.GetPrintersResult,
   *  }>}
   */

  getPrinters() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.WebPrintingService_GetPrinters_ParamsSpec.$,
        blink.mojom.WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebPrintingService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebPrintingServiceReceiver = class {
  /**
   * @param {!blink.mojom.WebPrintingServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebPrintingServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebPrintingServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintingServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintingService_GetPrinters_ParamsSpec.$,
        blink.mojom.WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        impl.getPrinters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebPrintingService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebPrintingService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebPrintingServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebPrintingServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebPrintingService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebPrintingServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebPrintingServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebPrintingServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrinters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebPrintingService_GetPrinters_ParamsSpec.$,
        blink.mojom.WebPrintingService_GetPrinters_ResponseParamsSpec.$,
        this.getPrinters.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinterInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingMediaSizeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingMediaCollectionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinterAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingMediaCollectionRequestedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintJobTemplateAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintJobUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintJobInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintJobController_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinter_FetchAttributes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinter_FetchAttributes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinter_Print_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrinter_Print_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingService_GetPrinters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebPrintingService_GetPrinters_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintingMediaSizeDimensionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GetPrintersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrinterFetchResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WebPrintResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.WebPrinterInfoSpec.$,
    'WebPrinterInfo',
    [
      mojo.internal.StructField(
        'printerName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerRemote', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WebPrinterRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.WebPrinterInfo = class {
  constructor() {
    /** @export { !string } */
    this.printerName;
    /** @export { !string } */
    this.printerId;
    /** @export { !blink.mojom.WebPrinterRemote } */
    this.printerRemote;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingRangeSpec.$,
    'WebPrintingRange',
    [
      mojo.internal.StructField(
        'from', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'to', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebPrintingRange = class {
  constructor() {
    /** @export { !number } */
    this.from;
    /** @export { !number } */
    this.to;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingMediaSizeSpec.$,
    'WebPrintingMediaSize',
    [
      mojo.internal.StructField(
        'xDimension', 0,
        0,
        blink.mojom.WebPrintingMediaSizeDimensionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'yDimension', 16,
        0,
        blink.mojom.WebPrintingMediaSizeDimensionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.WebPrintingMediaSize = class {
  constructor() {
    /** @export { !blink.mojom.WebPrintingMediaSizeDimension } */
    this.xDimension;
    /** @export { !blink.mojom.WebPrintingMediaSizeDimension } */
    this.yDimension;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingMediaCollectionSpec.$,
    'WebPrintingMediaCollection',
    [
      mojo.internal.StructField(
        'mediaSize', 0,
        0,
        blink.mojom.WebPrintingMediaSizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaSizeName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebPrintingMediaCollection = class {
  constructor() {
    /** @export { !blink.mojom.WebPrintingMediaSize } */
    this.mediaSize;
    /** @export { !string } */
    this.mediaSizeName;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrinterAttributesSpec.$,
    'WebPrinterAttributes',
    [
      mojo.internal.StructField(
        'copiesDefault', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'copiesSupported', 8,
        0,
        blink.mojom.WebPrintingRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaColDefault', 16,
        0,
        blink.mojom.WebPrintingMediaCollectionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaColDatabase', 24,
        0,
        mojo.internal.Array(blink.mojom.WebPrintingMediaCollectionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaSourceDefault', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaSourceSupported', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multipleDocumentHandlingDefault', 4,
        0,
        blink.mojom.WebPrintingMultipleDocumentHandlingSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multipleDocumentHandlingSupported', 48,
        0,
        mojo.internal.Array(blink.mojom.WebPrintingMultipleDocumentHandlingSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'orientationRequestedDefault', 56,
        0,
        blink.mojom.WebPrintingOrientationRequestedSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'orientationRequestedSupported', 64,
        0,
        mojo.internal.Array(blink.mojom.WebPrintingOrientationRequestedSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerResolutionDefault', 72,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerResolutionSupported', 80,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printColorModeDefault', 60,
        0,
        blink.mojom.WebPrintColorModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printColorModeSupported', 88,
        0,
        mojo.internal.Array(blink.mojom.WebPrintColorModeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'print_quality_default_$flag', 96,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "print_quality_default_$value",
          originalFieldName: "printQualityDefault",
        }
      ),
      mojo.internal.StructField(
        'print_quality_default_$value', 100,
        0,
        blink.mojom.WebPrintQualitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "printQualityDefault",
        }
      ),
      mojo.internal.StructField(
        'printQualitySupported', 104,
        0,
        mojo.internal.Array(blink.mojom.WebPrintQualitySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerState', 112,
        0,
        blink.mojom.WebPrinterStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerStateMessage', 120,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerStateReasons', 128,
        0,
        mojo.internal.Array(blink.mojom.WebPrinterStateReasonSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sides_default_$flag', 96,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "sides_default_$value",
          originalFieldName: "sidesDefault",
        }
      ),
      mojo.internal.StructField(
        'sides_default_$value', 116,
        0,
        blink.mojom.WebPrintingSidesSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "sidesDefault",
        }
      ),
      mojo.internal.StructField(
        'sidesSupported', 136,
        0,
        mojo.internal.Array(blink.mojom.WebPrintingSidesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'printerId', 144,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 160],]);





/** @record */
blink.mojom.WebPrinterAttributes = class {
  constructor() {
    /** @export { !number } */
    this.copiesDefault;
    /** @export { !blink.mojom.WebPrintingRange } */
    this.copiesSupported;
    /** @export { !blink.mojom.WebPrintingMediaCollection } */
    this.mediaColDefault;
    /** @export { !Array<!blink.mojom.WebPrintingMediaCollection> } */
    this.mediaColDatabase;
    /** @export { (string|undefined) } */
    this.mediaSourceDefault;
    /** @export { !Array<!string> } */
    this.mediaSourceSupported;
    /** @export { !blink.mojom.WebPrintingMultipleDocumentHandling } */
    this.multipleDocumentHandlingDefault;
    /** @export { !Array<!blink.mojom.WebPrintingMultipleDocumentHandling> } */
    this.multipleDocumentHandlingSupported;
    /** @export { !blink.mojom.WebPrintingOrientationRequested } */
    this.orientationRequestedDefault;
    /** @export { !Array<!blink.mojom.WebPrintingOrientationRequested> } */
    this.orientationRequestedSupported;
    /** @export { !gfx.mojom.Size } */
    this.printerResolutionDefault;
    /** @export { !Array<!gfx.mojom.Size> } */
    this.printerResolutionSupported;
    /** @export { !blink.mojom.WebPrintColorMode } */
    this.printColorModeDefault;
    /** @export { !Array<!blink.mojom.WebPrintColorMode> } */
    this.printColorModeSupported;
    /** @export { (blink.mojom.WebPrintQuality|undefined) } */
    this.printQualityDefault;
    /** @export { !Array<!blink.mojom.WebPrintQuality> } */
    this.printQualitySupported;
    /** @export { !blink.mojom.WebPrinterState } */
    this.printerState;
    /** @export { !string } */
    this.printerStateMessage;
    /** @export { !Array<!blink.mojom.WebPrinterStateReason> } */
    this.printerStateReasons;
    /** @export { (blink.mojom.WebPrintingSides|undefined) } */
    this.sidesDefault;
    /** @export { !Array<!blink.mojom.WebPrintingSides> } */
    this.sidesSupported;
    /** @export { !string } */
    this.printerId;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingMediaCollectionRequestedSpec.$,
    'WebPrintingMediaCollectionRequested',
    [
      mojo.internal.StructField(
        'mediaSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebPrintingMediaCollectionRequested = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.mediaSize;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintJobTemplateAttributesSpec.$,
    'WebPrintJobTemplateAttributes',
    [
      mojo.internal.StructField(
        'jobName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'copies', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaCol', 16,
        0,
        blink.mojom.WebPrintingMediaCollectionRequestedSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaSource', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multiple_document_handling_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "multiple_document_handling_$value",
          originalFieldName: "multipleDocumentHandling",
        }
      ),
      mojo.internal.StructField(
        'multiple_document_handling_$value', 32,
        0,
        blink.mojom.WebPrintingMultipleDocumentHandlingSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "multipleDocumentHandling",
        }
      ),
      mojo.internal.StructField(
        'orientation_requested_$flag', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "orientation_requested_$value",
          originalFieldName: "orientationRequested",
        }
      ),
      mojo.internal.StructField(
        'orientation_requested_$value', 36,
        0,
        blink.mojom.WebPrintingOrientationRequestedSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "orientationRequested",
        }
      ),
      mojo.internal.StructField(
        'printerResolution', 40,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'print_color_mode_$flag', 12,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "print_color_mode_$value",
          originalFieldName: "printColorMode",
        }
      ),
      mojo.internal.StructField(
        'print_color_mode_$value', 48,
        0,
        blink.mojom.WebPrintColorModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "printColorMode",
        }
      ),
      mojo.internal.StructField(
        'print_quality_$flag', 12,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "print_quality_$value",
          originalFieldName: "printQuality",
        }
      ),
      mojo.internal.StructField(
        'print_quality_$value', 52,
        0,
        blink.mojom.WebPrintQualitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "printQuality",
        }
      ),
      mojo.internal.StructField(
        'sides_$flag', 12,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "sides_$value",
          originalFieldName: "sides",
        }
      ),
      mojo.internal.StructField(
        'sides_$value', 56,
        0,
        blink.mojom.WebPrintingSidesSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "sides",
        }
      ),
    ],
    [[0, 72],]);





/** @record */
blink.mojom.WebPrintJobTemplateAttributes = class {
  constructor() {
    /** @export { !string } */
    this.jobName;
    /** @export { !number } */
    this.copies;
    /** @export { (blink.mojom.WebPrintingMediaCollectionRequested|undefined) } */
    this.mediaCol;
    /** @export { (string|undefined) } */
    this.mediaSource;
    /** @export { (blink.mojom.WebPrintingMultipleDocumentHandling|undefined) } */
    this.multipleDocumentHandling;
    /** @export { (blink.mojom.WebPrintingOrientationRequested|undefined) } */
    this.orientationRequested;
    /** @export { (gfx.mojom.Size|undefined) } */
    this.printerResolution;
    /** @export { (blink.mojom.WebPrintColorMode|undefined) } */
    this.printColorMode;
    /** @export { (blink.mojom.WebPrintQuality|undefined) } */
    this.printQuality;
    /** @export { (blink.mojom.WebPrintingSides|undefined) } */
    this.sides;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintJobUpdateSpec.$,
    'WebPrintJobUpdate',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.WebPrintJobStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pagesPrinted', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebPrintJobUpdate = class {
  constructor() {
    /** @export { !blink.mojom.WebPrintJobState } */
    this.state;
    /** @export { !number } */
    this.pagesPrinted;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintJobInfoSpec.$,
    'WebPrintJobInfo',
    [
      mojo.internal.StructField(
        'jobName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'jobPages', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.WebPrintJobStateObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controller', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WebPrintJobControllerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.WebPrintJobInfo = class {
  constructor() {
    /** @export { !string } */
    this.jobName;
    /** @export { !number } */
    this.jobPages;
    /** @export { !blink.mojom.WebPrintJobStateObserverPendingReceiver } */
    this.observer;
    /** @export { !blink.mojom.WebPrintJobControllerRemote } */
    this.controller;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsSpec.$,
    'WebPrintJobStateObserver_OnWebPrintJobUpdate_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        blink.mojom.WebPrintJobUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebPrintJobStateObserver_OnWebPrintJobUpdate_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebPrintJobUpdate } */
    this.update;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintJobController_Cancel_ParamsSpec.$,
    'WebPrintJobController_Cancel_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.WebPrintJobController_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrinter_FetchAttributes_ParamsSpec.$,
    'WebPrinter_FetchAttributes_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.WebPrinter_FetchAttributes_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrinter_FetchAttributes_ResponseParamsSpec.$,
    'WebPrinter_FetchAttributes_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.WebPrinterFetchResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebPrinter_FetchAttributes_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.WebPrinterFetchResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrinter_Print_ParamsSpec.$,
    'WebPrinter_Print_Params',
    [
      mojo.internal.StructField(
        'document', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributes', 8,
        0,
        blink.mojom.WebPrintJobTemplateAttributesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebPrinter_Print_Params = class {
  constructor() {
    /** @export { !blink.mojom.BlobRemote } */
    this.document;
    /** @export { !blink.mojom.WebPrintJobTemplateAttributes } */
    this.attributes;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrinter_Print_ResponseParamsSpec.$,
    'WebPrinter_Print_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.WebPrintResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebPrinter_Print_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.WebPrintResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingService_GetPrinters_ParamsSpec.$,
    'WebPrintingService_GetPrinters_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.WebPrintingService_GetPrinters_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WebPrintingService_GetPrinters_ResponseParamsSpec.$,
    'WebPrintingService_GetPrinters_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.GetPrintersResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebPrintingService_GetPrinters_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.GetPrintersResult } */
    this.result;
  }
};



mojo.internal.Union(
    blink.mojom.WebPrintingMediaSizeDimensionSpec.$, 'WebPrintingMediaSizeDimension',
    {
      'range': {
        'ordinal': 0,
        'type': blink.mojom.WebPrintingRangeSpec.$,
      },
      'value': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   range: (!blink.mojom.WebPrintingRange|undefined),
 *   value: (!number|undefined),
 * } }
 */
blink.mojom.WebPrintingMediaSizeDimension;


mojo.internal.Union(
    blink.mojom.GetPrintersResultSpec.$, 'GetPrintersResult',
    {
      'printers': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink.mojom.WebPrinterInfoSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': blink.mojom.GetPrintersErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printers: (!Array<!blink.mojom.WebPrinterInfo>|undefined),
 *   error: (!blink.mojom.GetPrintersError|undefined),
 * } }
 */
blink.mojom.GetPrintersResult;


mojo.internal.Union(
    blink.mojom.WebPrinterFetchResultSpec.$, 'WebPrinterFetchResult',
    {
      'printerAttributes': {
        'ordinal': 0,
        'type': blink.mojom.WebPrinterAttributesSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': blink.mojom.WebPrinterFetchErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printerAttributes: (!blink.mojom.WebPrinterAttributes|undefined),
 *   error: (!blink.mojom.WebPrinterFetchError|undefined),
 * } }
 */
blink.mojom.WebPrinterFetchResult;


mojo.internal.Union(
    blink.mojom.WebPrintResultSpec.$, 'WebPrintResult',
    {
      'printJobInfo': {
        'ordinal': 0,
        'type': blink.mojom.WebPrintJobInfoSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': blink.mojom.WebPrintErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   printJobInfo: (!blink.mojom.WebPrintJobInfo|undefined),
 *   error: (!blink.mojom.WebPrintError|undefined),
 * } }
 */
blink.mojom.WebPrintResult;
