// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PrivateAggregationErrorEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PrivateAggregationErrorEvent = {
  
  kReportSuccess: 0,
  kTooManyContributions: 1,
  kEmptyReportDropped: 2,
  kPendingReportLimitReached: 3,
  kInsufficientBudget: 4,
  kContributionTimeoutReached: 5,
  kAlreadyTriggeredExternalError: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PrivateAggregationHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PrivateAggregationHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PrivateAggregationHostInterface }
 */
blink.mojom.PrivateAggregationHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PrivateAggregationHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PrivateAggregationHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PrivateAggregationHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogram(
      contributions) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        [
          contributions
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PrivateAggregationErrorEvent } errorEvent
   * @param { !Array<!blink.mojom.AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogramOnEvent(
      errorEvent,
      contributions) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        [
          errorEvent,
          contributions
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.DebugKey } debugKey
   */

  enableDebugMode(
      debugKey) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        [
          debugKey
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PrivateAggregationHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PrivateAggregationHostReceiver = class {
  /**
   * @param {!blink.mojom.PrivateAggregationHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PrivateAggregationHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PrivateAggregationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PrivateAggregationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        impl.contributeToHistogram.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        impl.contributeToHistogramOnEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        impl.enableDebugMode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PrivateAggregationHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PrivateAggregationHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PrivateAggregationHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PrivateAggregationHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PrivateAggregationHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PrivateAggregationHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PrivateAggregationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PrivateAggregationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contributeToHistogram =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        this.contributeToHistogram.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contributeToHistogramOnEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        this.contributeToHistogramOnEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDebugMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        this.enableDebugMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DebugKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DebugModeDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrivateAggregationHost_ContributeToHistogram_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrivateAggregationHost_EnableDebugMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DebugKeySpec.$,
    'DebugKey',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DebugKey = class {
  constructor() {
    /** @export { !bigint } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.DebugModeDetailsSpec.$,
    'DebugModeDetails',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'debugKey', 8,
        0,
        blink.mojom.DebugKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DebugModeDetails = class {
  constructor() {
    /** @export { !boolean } */
    this.isEnabled;
    /** @export { (blink.mojom.DebugKey|undefined) } */
    this.debugKey;
  }
};



mojo.internal.Struct(
    blink.mojom.PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
    'PrivateAggregationHost_ContributeToHistogram_Params',
    [
      mojo.internal.StructField(
        'contributions', 0,
        0,
        mojo.internal.Array(blink.mojom.AggregatableReportHistogramContributionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PrivateAggregationHost_ContributeToHistogram_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AggregatableReportHistogramContribution> } */
    this.contributions;
  }
};



mojo.internal.Struct(
    blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
    'PrivateAggregationHost_ContributeToHistogramOnEvent_Params',
    [
      mojo.internal.StructField(
        'errorEvent', 0,
        0,
        blink.mojom.PrivateAggregationErrorEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contributions', 8,
        0,
        mojo.internal.Array(blink.mojom.AggregatableReportHistogramContributionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PrivateAggregationHost_ContributeToHistogramOnEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.PrivateAggregationErrorEvent } */
    this.errorEvent;
    /** @export { !Array<!blink.mojom.AggregatableReportHistogramContribution> } */
    this.contributions;
  }
};



mojo.internal.Struct(
    blink.mojom.PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
    'PrivateAggregationHost_EnableDebugMode_Params',
    [
      mojo.internal.StructField(
        'debugKey', 0,
        0,
        blink.mojom.DebugKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PrivateAggregationHost_EnableDebugMode_Params = class {
  constructor() {
    /** @export { (blink.mojom.DebugKey|undefined) } */
    this.debugKey;
  }
};

