// third_party/blink/public/mojom/renderer_preferences.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/renderer_preferences.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var webrtc_ip_handling_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom', 'peerconnection/webrtc_ip_handling_policy.mojom.js');
  }
  var user_agent_metadata$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom', 'user_agent/user_agent_metadata.mojom.js');
  }
  var font_render_params$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/font_render_params.mojom', '../../../../ui/gfx/mojom/font_render_params.mojom.js');
  }
  var webrtc_ip_handling_url_entry$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom', 'peerconnection/webrtc_ip_handling_url_entry.mojom.js');
  }


  var DEFAULT_CARET_BLINK_INTERVAL_IN_MILLISECONDS = 500;

  function RendererPreferences(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RendererPreferences.prototype.initDefaults_ = function() {
    this.canAcceptLoadDrops = true;
    this.shouldAntialiasText = true;
    this.useAutohinter = false;
    this.useBitmaps = false;
    this.useSubpixelPositioning = false;
    this.browserHandlesAllTopLevelRequests = false;
    this.useCustomColors = true;
    this.useOverlayScrollbar = false;
    this.enableReferrers = true;
    this.allowCrossOriginAuthPrompt = false;
    this.enableDoNotTrack = false;
    this.enableEncryptedMedia = true;
    this.webrtc_post_quantum_key_agreement_$flag = false;
    this.webrtc_post_quantum_key_agreement_$value = false;
    this.sendSubresourceNotification = false;
    this.pluginFullscreenAllowed = true;
    this.webrtcUdpMinPort = 0;
    this.hinting = font_render_params$.Hinting.kMedium;
    this.subpixelRendering = font_render_params$.SubpixelRendering.kNone;
    this.focusRingColor = 0xFFE59700;
    this.activeSelectionBgColor = 0xFF1967D2;
    this.activeSelectionFgColor = 0xFFFFFFFF;
    this.inactiveSelectionBgColor = 0xFFC8C8C8;
    this.inactiveSelectionFgColor = 0xFF323232;
    this.caretBlinkInterval = null;
    this.webrtcIpHandlingPolicy = 0;
    this.webrtcUdpMaxPort = 0;
    this.caretBrowsingEnabled = false;
    this.selectionClipboardBufferAvailable = false;
    this.viewSourceLineWrapEnabled = false;
    this.webrtcIpHandlingUrls = null;
    this.webrtcLocalIpsAllowedUrls = null;
    this.userAgentOverride = null;
    this.acceptLanguages = null;
    this.systemFontFamilyName = null;
    this.explicitlyAllowedNetworkPorts = null;
  };
  RendererPreferences.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RendererPreferences.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate RendererPreferences.hinting
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, font_render_params$.Hinting);
    if (err !== validator.validationError.NONE)
        return err;




    // validate RendererPreferences.subpixelRendering
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, font_render_params$.SubpixelRendering);
    if (err !== validator.validationError.NONE)
        return err;









    // validate RendererPreferences.caretBlinkInterval
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;








    // validate RendererPreferences.webrtcIpHandlingPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, webrtc_ip_handling_policy$.WebRtcIpHandlingPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RendererPreferences.webrtcIpHandlingUrls
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(webrtc_ip_handling_url_entry$.WebRtcIpHandlingUrlEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;






    // validate RendererPreferences.webrtcLocalIpsAllowedUrls
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RendererPreferences.userAgentOverride
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, user_agent_metadata$.UserAgentOverride, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RendererPreferences.acceptLanguages
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 72, false)
    if (err !== validator.validationError.NONE)
        return err;





    // validate RendererPreferences.systemFontFamilyName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 80, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate RendererPreferences.explicitlyAllowedNetworkPorts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 2, codec.Uint16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RendererPreferences.encodedSize = codec.kStructHeaderSize + 96;

  RendererPreferences.decode = function(decoder) {
    var packed;
    var val = new RendererPreferences();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.canAcceptLoadDrops = (packed >> 0) & 1 ? true : false;
    val.shouldAntialiasText = (packed >> 1) & 1 ? true : false;
    val.useAutohinter = (packed >> 2) & 1 ? true : false;
    val.useBitmaps = (packed >> 3) & 1 ? true : false;
    val.useSubpixelPositioning = (packed >> 4) & 1 ? true : false;
    val.browserHandlesAllTopLevelRequests = (packed >> 5) & 1 ? true : false;
    val.useCustomColors = (packed >> 6) & 1 ? true : false;
    val.useOverlayScrollbar = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.enableReferrers = (packed >> 0) & 1 ? true : false;
    val.allowCrossOriginAuthPrompt = (packed >> 1) & 1 ? true : false;
    val.enableDoNotTrack = (packed >> 2) & 1 ? true : false;
    val.enableEncryptedMedia = (packed >> 3) & 1 ? true : false;
    val.webrtc_post_quantum_key_agreement_$flag = (packed >> 4) & 1 ? true : false;
    val.webrtc_post_quantum_key_agreement_$value = (packed >> 5) & 1 ? true : false;
    val.sendSubresourceNotification = (packed >> 6) & 1 ? true : false;
    val.pluginFullscreenAllowed = (packed >> 7) & 1 ? true : false;
    val.webrtcUdpMinPort =
        decoder.decodeStruct(codec.Uint16);
    val.hinting =
        decoder.decodeStruct(new codec.Enum(font_render_params$.Hinting));
    val.subpixelRendering =
        decoder.decodeStruct(new codec.Enum(font_render_params$.SubpixelRendering));
    val.focusRingColor =
        decoder.decodeStruct(codec.Uint32);
    val.activeSelectionBgColor =
        decoder.decodeStruct(codec.Uint32);
    val.activeSelectionFgColor =
        decoder.decodeStruct(codec.Uint32);
    val.inactiveSelectionBgColor =
        decoder.decodeStruct(codec.Uint32);
    val.inactiveSelectionFgColor =
        decoder.decodeStruct(codec.Uint32);
    val.caretBlinkInterval =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.webrtcIpHandlingPolicy =
        decoder.decodeStruct(new codec.Enum(webrtc_ip_handling_policy$.WebRtcIpHandlingPolicy));
    val.webrtcUdpMaxPort =
        decoder.decodeStruct(codec.Uint16);
    packed = decoder.readUint8();
    val.caretBrowsingEnabled = (packed >> 0) & 1 ? true : false;
    val.selectionClipboardBufferAvailable = (packed >> 1) & 1 ? true : false;
    val.viewSourceLineWrapEnabled = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    val.webrtcIpHandlingUrls =
        decoder.decodeArrayPointer(new codec.PointerTo(webrtc_ip_handling_url_entry$.WebRtcIpHandlingUrlEntry));
    val.webrtcLocalIpsAllowedUrls =
        decoder.decodeArrayPointer(codec.String);
    val.userAgentOverride =
        decoder.decodeStructPointer(user_agent_metadata$.UserAgentOverride);
    val.acceptLanguages =
        decoder.decodeStruct(codec.String);
    val.systemFontFamilyName =
        decoder.decodeStruct(codec.String);
    val.explicitlyAllowedNetworkPorts =
        decoder.decodeArrayPointer(codec.Uint16);
    return val;
  };

  RendererPreferences.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RendererPreferences.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.canAcceptLoadDrops & 1) << 0
    packed |= (val.shouldAntialiasText & 1) << 1
    packed |= (val.useAutohinter & 1) << 2
    packed |= (val.useBitmaps & 1) << 3
    packed |= (val.useSubpixelPositioning & 1) << 4
    packed |= (val.browserHandlesAllTopLevelRequests & 1) << 5
    packed |= (val.useCustomColors & 1) << 6
    packed |= (val.useOverlayScrollbar & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.enableReferrers & 1) << 0
    packed |= (val.allowCrossOriginAuthPrompt & 1) << 1
    packed |= (val.enableDoNotTrack & 1) << 2
    packed |= (val.enableEncryptedMedia & 1) << 3
    packed |= (val.webrtc_post_quantum_key_agreement_$flag & 1) << 4
    packed |= (val.webrtc_post_quantum_key_agreement_$value & 1) << 5
    packed |= (val.sendSubresourceNotification & 1) << 6
    packed |= (val.pluginFullscreenAllowed & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint16, val.webrtcUdpMinPort);
    encoder.encodeStruct(codec.Int32, val.hinting);
    encoder.encodeStruct(codec.Int32, val.subpixelRendering);
    encoder.encodeStruct(codec.Uint32, val.focusRingColor);
    encoder.encodeStruct(codec.Uint32, val.activeSelectionBgColor);
    encoder.encodeStruct(codec.Uint32, val.activeSelectionFgColor);
    encoder.encodeStruct(codec.Uint32, val.inactiveSelectionBgColor);
    encoder.encodeStruct(codec.Uint32, val.inactiveSelectionFgColor);
    encoder.encodeStructPointer(time$.TimeDelta, val.caretBlinkInterval);
    encoder.encodeStruct(codec.Int32, val.webrtcIpHandlingPolicy);
    encoder.encodeStruct(codec.Uint16, val.webrtcUdpMaxPort);
    packed = 0;
    packed |= (val.caretBrowsingEnabled & 1) << 0
    packed |= (val.selectionClipboardBufferAvailable & 1) << 1
    packed |= (val.viewSourceLineWrapEnabled & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(webrtc_ip_handling_url_entry$.WebRtcIpHandlingUrlEntry), val.webrtcIpHandlingUrls);
    encoder.encodeArrayPointer(codec.String, val.webrtcLocalIpsAllowedUrls);
    encoder.encodeStructPointer(user_agent_metadata$.UserAgentOverride, val.userAgentOverride);
    encoder.encodeStruct(codec.String, val.acceptLanguages);
    encoder.encodeStruct(codec.String, val.systemFontFamilyName);
    encoder.encodeArrayPointer(codec.Uint16, val.explicitlyAllowedNetworkPorts);
  };
  exports.DEFAULT_CARET_BLINK_INTERVAL_IN_MILLISECONDS = DEFAULT_CARET_BLINK_INTERVAL_IN_MILLISECONDS;
  exports.RendererPreferences = RendererPreferences;
})();