// third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerStreamCallbackPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerStreamCallback.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ServiceWorkerStreamCallbackInterface }
 */
blink.mojom.ServiceWorkerStreamCallbackRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerStreamCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerStreamCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerStreamCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onCompleted() {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onAborted() {
    this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerStreamCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerStreamCallbackReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerStreamCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerStreamCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerStreamCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerStreamCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        impl.onCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        impl.onAborted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerStreamCallback = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerStreamCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerStreamCallbackRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerStreamCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerStreamCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerStreamCallbackCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerStreamCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerStreamCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        this.onCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAborted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        this.onAborted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerStreamHandleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerStreamCallback_OnCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerStreamCallback_OnAborted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerStreamHandleSpec.$,
    'ServiceWorkerStreamHandle',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callbackReceiver', 4,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ServiceWorkerStreamCallbackPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ServiceWorkerStreamHandle = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.stream;
    /** @export { !blink.mojom.ServiceWorkerStreamCallbackPendingReceiver } */
    this.callbackReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
    'ServiceWorkerStreamCallback_OnCompleted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ServiceWorkerStreamCallback_OnCompleted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
    'ServiceWorkerStreamCallback_OnAborted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ServiceWorkerStreamCallback_OnAborted_Params = class {
  constructor() {
  }
};

