// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var private_aggregation_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom', '../private_aggregation/private_aggregation_host.mojom.js');
  }
  var url_loader_factory$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_factory.mojom', '../../../../../services/network/public/mojom/url_loader_factory.mojom.js');
  }
  var shared_storage$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_storage.mojom', '../../../../../services/network/public/mojom/shared_storage.mojom.js');
  }
  var shared_storage1$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/shared_storage/shared_storage.mojom', 'shared_storage.mojom.js');
  }
  var web_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom', '../use_counter/metrics/web_feature.mojom.js');
  }
  var cloneable_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/cloneable_message.mojom', '../messaging/cloneable_message.mojom.js');
  }
  var console_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/devtools/console_message.mojom', '../devtools/console_message.mojom.js');
  }
  var interest_group_types$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/interest_group/interest_group_types.mojom', '../interest_group/interest_group_types.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function SharedStorageWorkletPermissionsPolicyState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletPermissionsPolicyState.prototype.initDefaults_ = function() {
    this.privateAggregationAllowed = false;
    this.joinAdInterestGroupAllowed = false;
    this.runAdAuctionAllowed = false;
  };
  SharedStorageWorkletPermissionsPolicyState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletPermissionsPolicyState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  SharedStorageWorkletPermissionsPolicyState.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletPermissionsPolicyState.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletPermissionsPolicyState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.privateAggregationAllowed = (packed >> 0) & 1 ? true : false;
    val.joinAdInterestGroupAllowed = (packed >> 1) & 1 ? true : false;
    val.runAdAuctionAllowed = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedStorageWorkletPermissionsPolicyState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletPermissionsPolicyState.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.privateAggregationAllowed & 1) << 0
    packed |= (val.joinAdInterestGroupAllowed & 1) << 1
    packed |= (val.runAdAuctionAllowed & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SharedStorageKeyAndOrValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageKeyAndOrValue.prototype.initDefaults_ = function() {
    this.key = null;
    this.value = null;
  };
  SharedStorageKeyAndOrValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageKeyAndOrValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageKeyAndOrValue.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageKeyAndOrValue.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageKeyAndOrValue.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageKeyAndOrValue.decode = function(decoder) {
    var packed;
    var val = new SharedStorageKeyAndOrValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(string16$.String16);
    val.value =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageKeyAndOrValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageKeyAndOrValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.key);
    encoder.encodeStructPointer(string16$.String16, val.value);
  };
  function PrivateAggregationOperationDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrivateAggregationOperationDetails.prototype.initDefaults_ = function() {
    this.paHost = new private_aggregation_host$.PrivateAggregationHostPtr();
    this.filteringIdMaxBytes = 0;
  };
  PrivateAggregationOperationDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrivateAggregationOperationDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationOperationDetails.paHost
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PrivateAggregationOperationDetails.encodedSize = codec.kStructHeaderSize + 16;

  PrivateAggregationOperationDetails.decode = function(decoder) {
    var packed;
    var val = new PrivateAggregationOperationDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.paHost =
        decoder.decodeStruct(new codec.Interface(private_aggregation_host$.PrivateAggregationHostPtr));
    val.filteringIdMaxBytes =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PrivateAggregationOperationDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrivateAggregationOperationDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(private_aggregation_host$.PrivateAggregationHostPtr), val.paHost);
    encoder.encodeStruct(codec.Uint32, val.filteringIdMaxBytes);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SharedStorageEntriesListener_DidReadEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageEntriesListener_DidReadEntries_Params.prototype.initDefaults_ = function() {
    this.success = false;
    this.hasMoreEntries = false;
    this.totalQueuedToSend = 0;
    this.errorMessage = null;
    this.entries = null;
  };
  SharedStorageEntriesListener_DidReadEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageEntriesListener_DidReadEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageEntriesListener_DidReadEntries_Params.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageEntriesListener_DidReadEntries_Params.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(SharedStorageKeyAndOrValue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SharedStorageEntriesListener_DidReadEntries_Params.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageEntriesListener_DidReadEntries_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageEntriesListener_DidReadEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    val.hasMoreEntries = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.totalQueuedToSend =
        decoder.decodeStruct(codec.Int32);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(SharedStorageKeyAndOrValue));
    return val;
  };

  SharedStorageEntriesListener_DidReadEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageEntriesListener_DidReadEntries_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    packed |= (val.hasMoreEntries & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.totalQueuedToSend);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeArrayPointer(new codec.PointerTo(SharedStorageKeyAndOrValue), val.entries);
  };
  function SharedStorageWorkletServiceClient_SharedStorageUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.prototype.initDefaults_ = function() {
    this.methodWithOptions = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.methodWithOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageModifierMethodWithOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.methodWithOptions =
        decoder.decodeStructPointer(shared_storage$.SharedStorageModifierMethodWithOptions);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageModifierMethodWithOptions, val.methodWithOptions);
  };
  function SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.prototype.initDefaults_ = function() {
    this.errorMessage = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.prototype.initDefaults_ = function() {
    this.methodsWithOptions = null;
    this.withLock = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.methodsWithOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageBatchUpdateMethodsArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.withLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_storage$.LockName, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.methodsWithOptions =
        decoder.decodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument);
    val.withLock =
        decoder.decodeStructPointer(shared_storage$.LockName);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument, val.methodsWithOptions);
    encoder.encodeStructPointer(shared_storage$.LockName, val.withLock);
  };
  function SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.prototype.initDefaults_ = function() {
    this.errorMessage = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageWorkletServiceClient_SharedStorageGet_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageGet_Params.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageGet_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageGet_Params.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_storage$.SharedStorageKeyArgument, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_SharedStorageGet_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageGet_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(shared_storage$.SharedStorageKeyArgument);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageGet_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_storage$.SharedStorageKeyArgument, val.key);
  };
  function SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.errorMessage = null;
    this.value = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, shared_storage1$.SharedStorageGetStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(shared_storage1$.SharedStorageGetStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStructPointer(string16$.String16, val.value);
  };
  function SharedStorageWorkletServiceClient_SharedStorageKeys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.prototype.initDefaults_ = function() {
    this.listener = new SharedStorageEntriesListenerPtr();
  };
  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageKeys_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageKeys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(new codec.Interface(SharedStorageEntriesListenerPtr));
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageKeys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageKeys_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SharedStorageEntriesListenerPtr), val.listener);
  };
  function SharedStorageWorkletServiceClient_SharedStorageEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.prototype.initDefaults_ = function() {
    this.listener = new SharedStorageEntriesListenerPtr();
    this.valuesOnly = false;
  };
  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_SharedStorageEntries_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(new codec.Interface(SharedStorageEntriesListenerPtr));
    packed = decoder.readUint8();
    val.valuesOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SharedStorageEntriesListenerPtr), val.listener);
    packed = 0;
    packed |= (val.valuesOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SharedStorageWorkletServiceClient_SharedStorageLength_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageLength_Params.prototype.initDefaults_ = function() {
  };
  SharedStorageWorkletServiceClient_SharedStorageLength_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_Params.encodedSize = codec.kStructHeaderSize + 0;

  SharedStorageWorkletServiceClient_SharedStorageLength_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageLength_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageLength_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.length = 0;
    this.errorMessage = null;
  };
  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.length =
        decoder.decodeStruct(codec.Uint32);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.length);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.prototype.initDefaults_ = function() {
  };
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.encodedSize = codec.kStructHeaderSize + 0;

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
    this.bits = 0;
  };
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.bits =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStruct(codec.Double, val.bits);
  };
  function SharedStorageWorkletServiceClient_GetInterestGroups_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_GetInterestGroups_Params.prototype.initDefaults_ = function() {
  };
  SharedStorageWorkletServiceClient_GetInterestGroups_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_Params.encodedSize = codec.kStructHeaderSize + 0;

  SharedStorageWorkletServiceClient_GetInterestGroups_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_GetInterestGroups_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_GetInterestGroups_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, GetInterestGroupsResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(GetInterestGroupsResult);
    return val;
  };

  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(GetInterestGroupsResult, val.result);
  };
  function SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.prototype.initDefaults_ = function() {
    this.logLevel = 0;
    this.message = null;
  };
  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.logLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, console_message$.ConsoleMessageLevel);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.logLevel =
        decoder.decodeStruct(new codec.Enum(console_message$.ConsoleMessageLevel));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.logLevel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  function SharedStorageWorkletServiceClient_RecordUseCounters_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletServiceClient_RecordUseCounters_Params.prototype.initDefaults_ = function() {
    this.features = null;
  };
  SharedStorageWorkletServiceClient_RecordUseCounters_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletServiceClient_RecordUseCounters_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletServiceClient_RecordUseCounters_Params.features
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(web_feature$.WebFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletServiceClient_RecordUseCounters_Params.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletServiceClient_RecordUseCounters_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletServiceClient_RecordUseCounters_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.features =
        decoder.decodeArrayPointer(new codec.Enum(web_feature$.WebFeature));
    return val;
  };

  SharedStorageWorkletServiceClient_RecordUseCounters_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletServiceClient_RecordUseCounters_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(web_feature$.WebFeature), val.features);
  };
  function SharedStorageWorkletService_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_Initialize_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
    this.permissionsPolicyState = null;
    this.embedderContext = null;
  };
  SharedStorageWorkletService_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_Initialize_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_Initialize_Params.permissionsPolicyState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SharedStorageWorkletPermissionsPolicyState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_Initialize_Params.embedderContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_Initialize_Params.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageWorkletService_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.permissionsPolicyState =
        decoder.decodeStructPointer(SharedStorageWorkletPermissionsPolicyState);
    val.embedderContext =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageWorkletService_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.encodeStructPointer(SharedStorageWorkletPermissionsPolicyState, val.permissionsPolicyState);
    encoder.encodeStructPointer(string16$.String16, val.embedderContext);
  };
  function SharedStorageWorkletService_AddModule_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_AddModule_Params.prototype.initDefaults_ = function() {
    this.urlLoaderFactory = new url_loader_factory$.URLLoaderFactoryPtr();
    this.scriptSourceUrl = null;
  };
  SharedStorageWorkletService_AddModule_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_AddModule_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_AddModule_Params.urlLoaderFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_AddModule_Params.scriptSourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_AddModule_Params.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletService_AddModule_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_AddModule_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urlLoaderFactory =
        decoder.decodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr));
    val.scriptSourceUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  SharedStorageWorkletService_AddModule_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_AddModule_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr), val.urlLoaderFactory);
    encoder.encodeStructPointer(url$.Url, val.scriptSourceUrl);
  };
  function SharedStorageWorkletService_AddModule_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_AddModule_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
  };
  SharedStorageWorkletService_AddModule_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_AddModule_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletService_AddModule_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_AddModule_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletService_AddModule_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_AddModule_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletService_AddModule_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_AddModule_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageWorkletService_RunURLSelectionOperation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_RunURLSelectionOperation_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.urls = null;
    this.serializedData = null;
    this.paOperationDetails = null;
  };
  SharedStorageWorkletService_RunURLSelectionOperation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_RunURLSelectionOperation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunURLSelectionOperation_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunURLSelectionOperation_Params.urls
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunURLSelectionOperation_Params.serializedData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, cloneable_message$.CloneableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunURLSelectionOperation_Params.paOperationDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, PrivateAggregationOperationDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_RunURLSelectionOperation_Params.encodedSize = codec.kStructHeaderSize + 32;

  SharedStorageWorkletService_RunURLSelectionOperation_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_RunURLSelectionOperation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.urls =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.serializedData =
        decoder.decodeStructPointer(cloneable_message$.CloneableMessage);
    val.paOperationDetails =
        decoder.decodeStructPointer(PrivateAggregationOperationDetails);
    return val;
  };

  SharedStorageWorkletService_RunURLSelectionOperation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_RunURLSelectionOperation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.urls);
    encoder.encodeStructPointer(cloneable_message$.CloneableMessage, val.serializedData);
    encoder.encodeStructPointer(PrivateAggregationOperationDetails, val.paOperationDetails);
  };
  function SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.index = 0;
    this.errorMessage = null;
  };
  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.index =
        decoder.decodeStruct(codec.Uint32);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.index);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function SharedStorageWorkletService_RunOperation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_RunOperation_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.serializedData = null;
    this.paOperationDetails = null;
  };
  SharedStorageWorkletService_RunOperation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_RunOperation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunOperation_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunOperation_Params.serializedData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, cloneable_message$.CloneableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletService_RunOperation_Params.paOperationDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, PrivateAggregationOperationDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_RunOperation_Params.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageWorkletService_RunOperation_Params.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_RunOperation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.serializedData =
        decoder.decodeStructPointer(cloneable_message$.CloneableMessage);
    val.paOperationDetails =
        decoder.decodeStructPointer(PrivateAggregationOperationDetails);
    return val;
  };

  SharedStorageWorkletService_RunOperation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_RunOperation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(cloneable_message$.CloneableMessage, val.serializedData);
    encoder.encodeStructPointer(PrivateAggregationOperationDetails, val.paOperationDetails);
  };
  function SharedStorageWorkletService_RunOperation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletService_RunOperation_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.errorMessage = null;
  };
  SharedStorageWorkletService_RunOperation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletService_RunOperation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedStorageWorkletService_RunOperation_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletService_RunOperation_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageWorkletService_RunOperation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletService_RunOperation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SharedStorageWorkletService_RunOperation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletService_RunOperation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };

  function GetInterestGroupsResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GetInterestGroupsResult.Tags = {
    errorMessage: 0,
    groups: 1,
  };

  GetInterestGroupsResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GetInterestGroupsResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorMessage",
        "groups",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GetInterestGroupsResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GetInterestGroupsResult.prototype, "errorMessage", {
    get: function() {
      if (this.$tag != GetInterestGroupsResult.Tags.errorMessage) {
        throw new ReferenceError(
            "GetInterestGroupsResult.errorMessage is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetInterestGroupsResult.Tags.errorMessage;
      this.$data = value;
    }
  });
  Object.defineProperty(GetInterestGroupsResult.prototype, "groups", {
    get: function() {
      if (this.$tag != GetInterestGroupsResult.Tags.groups) {
        throw new ReferenceError(
            "GetInterestGroupsResult.groups is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetInterestGroupsResult.Tags.groups;
      this.$data = value;
    }
  });


    GetInterestGroupsResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GetInterestGroupsResult.Tags.errorMessage:
          encoder.encodeStruct(codec.String, val.errorMessage);
          break;
        case GetInterestGroupsResult.Tags.groups:
          encoder.encodeArrayPointer(new codec.PointerTo(interest_group_types$.StorageInterestGroup), val.groups);
          break;
      }
      encoder.align();
    };


    GetInterestGroupsResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GetInterestGroupsResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case GetInterestGroupsResult.Tags.errorMessage:
          result.errorMessage = decoder.decodeStruct(codec.String);
          break;
        case GetInterestGroupsResult.Tags.groups:
          result.groups = decoder.decodeArrayPointer(new codec.PointerTo(interest_group_types$.StorageInterestGroup));
          break;
      }
      decoder.align();

      return result;
    };


    GetInterestGroupsResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GetInterestGroupsResult.Tags.errorMessage:
          

    // validate GetInterestGroupsResult.errorMessage
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GetInterestGroupsResult.Tags.groups:
          

    // validate GetInterestGroupsResult.groups
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(interest_group_types$.StorageInterestGroup), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GetInterestGroupsResult.encodedSize = 16;
  var kSharedStorageEntriesListener_DidReadEntries_Name = 0;

  function SharedStorageEntriesListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedStorageEntriesListener,
                                                   handleOrPtrInfo);
  }

  function SharedStorageEntriesListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedStorageEntriesListener, associatedInterfacePtrInfo);
  }

  SharedStorageEntriesListenerAssociatedPtr.prototype =
      Object.create(SharedStorageEntriesListenerPtr.prototype);
  SharedStorageEntriesListenerAssociatedPtr.prototype.constructor =
      SharedStorageEntriesListenerAssociatedPtr;

  function SharedStorageEntriesListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedStorageEntriesListenerPtr.prototype.didReadEntries = function() {
    return SharedStorageEntriesListenerProxy.prototype.didReadEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageEntriesListenerProxy.prototype.didReadEntries = function(success, errorMessage, entries, hasMoreEntries, totalQueuedToSend) {
    var params_ = new SharedStorageEntriesListener_DidReadEntries_Params();
    params_.success = success;
    params_.errorMessage = errorMessage;
    params_.entries = entries;
    params_.hasMoreEntries = hasMoreEntries;
    params_.totalQueuedToSend = totalQueuedToSend;
    var builder = new codec.MessageV0Builder(
        kSharedStorageEntriesListener_DidReadEntries_Name,
        codec.align(SharedStorageEntriesListener_DidReadEntries_Params.encodedSize));
    builder.encodeStruct(SharedStorageEntriesListener_DidReadEntries_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SharedStorageEntriesListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedStorageEntriesListenerStub.prototype.didReadEntries = function(success, errorMessage, entries, hasMoreEntries, totalQueuedToSend) {
    return this.delegate_ && this.delegate_.didReadEntries && this.delegate_.didReadEntries(success, errorMessage, entries, hasMoreEntries, totalQueuedToSend);
  }

  SharedStorageEntriesListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageEntriesListener_DidReadEntries_Name:
      var params = reader.decodeStruct(SharedStorageEntriesListener_DidReadEntries_Params);
      this.didReadEntries(params.success, params.errorMessage, params.entries, params.hasMoreEntries, params.totalQueuedToSend);
      return true;
    default:
      return false;
    }
  };

  SharedStorageEntriesListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSharedStorageEntriesListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedStorageEntriesListener_DidReadEntries_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageEntriesListener_DidReadEntries_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedStorageEntriesListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SharedStorageEntriesListener = {
    name: 'blink.mojom.SharedStorageEntriesListener',
    kVersion: 0,
    ptrClass: SharedStorageEntriesListenerPtr,
    proxyClass: SharedStorageEntriesListenerProxy,
    stubClass: SharedStorageEntriesListenerStub,
    validateRequest: validateSharedStorageEntriesListenerRequest,
    validateResponse: null,
  };
  SharedStorageEntriesListenerStub.prototype.validator = validateSharedStorageEntriesListenerRequest;
  SharedStorageEntriesListenerProxy.prototype.validator = null;
  var kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name = 0;
  var kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name = 1;
  var kSharedStorageWorkletServiceClient_SharedStorageGet_Name = 2;
  var kSharedStorageWorkletServiceClient_SharedStorageKeys_Name = 3;
  var kSharedStorageWorkletServiceClient_SharedStorageEntries_Name = 4;
  var kSharedStorageWorkletServiceClient_SharedStorageLength_Name = 5;
  var kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name = 6;
  var kSharedStorageWorkletServiceClient_GetInterestGroups_Name = 7;
  var kSharedStorageWorkletServiceClient_DidAddMessageToConsole_Name = 8;
  var kSharedStorageWorkletServiceClient_RecordUseCounters_Name = 9;

  function SharedStorageWorkletServiceClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedStorageWorkletServiceClient,
                                                   handleOrPtrInfo);
  }

  function SharedStorageWorkletServiceClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedStorageWorkletServiceClient, associatedInterfacePtrInfo);
  }

  SharedStorageWorkletServiceClientAssociatedPtr.prototype =
      Object.create(SharedStorageWorkletServiceClientPtr.prototype);
  SharedStorageWorkletServiceClientAssociatedPtr.prototype.constructor =
      SharedStorageWorkletServiceClientAssociatedPtr;

  function SharedStorageWorkletServiceClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageUpdate = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageUpdate = function(methodWithOptions) {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageUpdate_Params();
    params_.methodWithOptions = methodWithOptions;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name,
          codec.align(SharedStorageWorkletServiceClient_SharedStorageUpdate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageUpdate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageBatchUpdate = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageBatchUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageBatchUpdate = function(methodsWithOptions, withLock) {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params();
    params_.methodsWithOptions = methodsWithOptions;
    params_.withLock = withLock;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name,
          codec.align(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageGet = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageGet
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageGet = function(key) {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageGet_Params();
    params_.key = key;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_SharedStorageGet_Name,
          codec.align(SharedStorageWorkletServiceClient_SharedStorageGet_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageGet_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageKeys = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageKeys
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageKeys = function(listener) {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageKeys_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kSharedStorageWorkletServiceClient_SharedStorageKeys_Name,
        codec.align(SharedStorageWorkletServiceClient_SharedStorageKeys_Params.encodedSize));
    builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageKeys_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageEntries = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageEntries = function(listener, valuesOnly) {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageEntries_Params();
    params_.listener = listener;
    params_.valuesOnly = valuesOnly;
    var builder = new codec.MessageV0Builder(
        kSharedStorageWorkletServiceClient_SharedStorageEntries_Name,
        codec.align(SharedStorageWorkletServiceClient_SharedStorageEntries_Params.encodedSize));
    builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageEntries_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageLength = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageLength
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageLength = function() {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageLength_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_SharedStorageLength_Name,
          codec.align(SharedStorageWorkletServiceClient_SharedStorageLength_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageLength_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.sharedStorageRemainingBudget = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.sharedStorageRemainingBudget
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.sharedStorageRemainingBudget = function() {
    var params_ = new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name,
          codec.align(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.getInterestGroups = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.getInterestGroups
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.getInterestGroups = function() {
    var params_ = new SharedStorageWorkletServiceClient_GetInterestGroups_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletServiceClient_GetInterestGroups_Name,
          codec.align(SharedStorageWorkletServiceClient_GetInterestGroups_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletServiceClient_GetInterestGroups_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServiceClientPtr.prototype.didAddMessageToConsole = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.didAddMessageToConsole
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.didAddMessageToConsole = function(logLevel, message) {
    var params_ = new SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params();
    params_.logLevel = logLevel;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kSharedStorageWorkletServiceClient_DidAddMessageToConsole_Name,
        codec.align(SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params.encodedSize));
    builder.encodeStruct(SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SharedStorageWorkletServiceClientPtr.prototype.recordUseCounters = function() {
    return SharedStorageWorkletServiceClientProxy.prototype.recordUseCounters
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceClientProxy.prototype.recordUseCounters = function(features) {
    var params_ = new SharedStorageWorkletServiceClient_RecordUseCounters_Params();
    params_.features = features;
    var builder = new codec.MessageV0Builder(
        kSharedStorageWorkletServiceClient_RecordUseCounters_Name,
        codec.align(SharedStorageWorkletServiceClient_RecordUseCounters_Params.encodedSize));
    builder.encodeStruct(SharedStorageWorkletServiceClient_RecordUseCounters_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SharedStorageWorkletServiceClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageUpdate = function(methodWithOptions) {
    return this.delegate_ && this.delegate_.sharedStorageUpdate && this.delegate_.sharedStorageUpdate(methodWithOptions);
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageBatchUpdate = function(methodsWithOptions, withLock) {
    return this.delegate_ && this.delegate_.sharedStorageBatchUpdate && this.delegate_.sharedStorageBatchUpdate(methodsWithOptions, withLock);
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageGet = function(key) {
    return this.delegate_ && this.delegate_.sharedStorageGet && this.delegate_.sharedStorageGet(key);
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageKeys = function(listener) {
    return this.delegate_ && this.delegate_.sharedStorageKeys && this.delegate_.sharedStorageKeys(listener);
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageEntries = function(listener, valuesOnly) {
    return this.delegate_ && this.delegate_.sharedStorageEntries && this.delegate_.sharedStorageEntries(listener, valuesOnly);
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageLength = function() {
    return this.delegate_ && this.delegate_.sharedStorageLength && this.delegate_.sharedStorageLength();
  }
  SharedStorageWorkletServiceClientStub.prototype.sharedStorageRemainingBudget = function() {
    return this.delegate_ && this.delegate_.sharedStorageRemainingBudget && this.delegate_.sharedStorageRemainingBudget();
  }
  SharedStorageWorkletServiceClientStub.prototype.getInterestGroups = function() {
    return this.delegate_ && this.delegate_.getInterestGroups && this.delegate_.getInterestGroups();
  }
  SharedStorageWorkletServiceClientStub.prototype.didAddMessageToConsole = function(logLevel, message) {
    return this.delegate_ && this.delegate_.didAddMessageToConsole && this.delegate_.didAddMessageToConsole(logLevel, message);
  }
  SharedStorageWorkletServiceClientStub.prototype.recordUseCounters = function(features) {
    return this.delegate_ && this.delegate_.recordUseCounters && this.delegate_.recordUseCounters(features);
  }

  SharedStorageWorkletServiceClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageWorkletServiceClient_SharedStorageKeys_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageKeys_Params);
      this.sharedStorageKeys(params.listener);
      return true;
    case kSharedStorageWorkletServiceClient_SharedStorageEntries_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageEntries_Params);
      this.sharedStorageEntries(params.listener, params.valuesOnly);
      return true;
    case kSharedStorageWorkletServiceClient_DidAddMessageToConsole_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params);
      this.didAddMessageToConsole(params.logLevel, params.message);
      return true;
    case kSharedStorageWorkletServiceClient_RecordUseCounters_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_RecordUseCounters_Params);
      this.recordUseCounters(params.features);
      return true;
    default:
      return false;
    }
  };

  SharedStorageWorkletServiceClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageUpdate_Params);
      this.sharedStorageUpdate(params.methodWithOptions).then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams();
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name,
            codec.align(SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params);
      this.sharedStorageBatchUpdate(params.methodsWithOptions, params.withLock).then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams();
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name,
            codec.align(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletServiceClient_SharedStorageGet_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageGet_Params);
      this.sharedStorageGet(params.key).then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams();
        responseParams.status = response.status;
        responseParams.errorMessage = response.errorMessage;
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_SharedStorageGet_Name,
            codec.align(SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletServiceClient_SharedStorageLength_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageLength_Params);
      this.sharedStorageLength().then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        responseParams.length = response.length;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_SharedStorageLength_Name,
            codec.align(SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params);
      this.sharedStorageRemainingBudget().then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        responseParams.bits = response.bits;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name,
            codec.align(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletServiceClient_GetInterestGroups_Name:
      var params = reader.decodeStruct(SharedStorageWorkletServiceClient_GetInterestGroups_Params);
      this.getInterestGroups().then(function(response) {
        var responseParams =
            new SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletServiceClient_GetInterestGroups_Name,
            codec.align(SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSharedStorageWorkletServiceClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageUpdate_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageGet_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageGet_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageKeys_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageKeys_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageEntries_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageEntries_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageLength_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageLength_Params;
      break;
      case kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params;
      break;
      case kSharedStorageWorkletServiceClient_GetInterestGroups_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletServiceClient_GetInterestGroups_Params;
      break;
      case kSharedStorageWorkletServiceClient_DidAddMessageToConsole_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params;
      break;
      case kSharedStorageWorkletServiceClient_RecordUseCounters_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_RecordUseCounters_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedStorageWorkletServiceClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSharedStorageWorkletServiceClient_SharedStorageUpdate_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams;
        break;
      case kSharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams;
        break;
      case kSharedStorageWorkletServiceClient_SharedStorageGet_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams;
        break;
      case kSharedStorageWorkletServiceClient_SharedStorageLength_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams;
        break;
      case kSharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams;
        break;
      case kSharedStorageWorkletServiceClient_GetInterestGroups_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SharedStorageWorkletServiceClient = {
    name: 'blink.mojom.SharedStorageWorkletServiceClient',
    kVersion: 0,
    ptrClass: SharedStorageWorkletServiceClientPtr,
    proxyClass: SharedStorageWorkletServiceClientProxy,
    stubClass: SharedStorageWorkletServiceClientStub,
    validateRequest: validateSharedStorageWorkletServiceClientRequest,
    validateResponse: validateSharedStorageWorkletServiceClientResponse,
  };
  SharedStorageWorkletServiceClientStub.prototype.validator = validateSharedStorageWorkletServiceClientRequest;
  SharedStorageWorkletServiceClientProxy.prototype.validator = validateSharedStorageWorkletServiceClientResponse;
  var kSharedStorageWorkletService_Initialize_Name = 0;
  var kSharedStorageWorkletService_AddModule_Name = 1;
  var kSharedStorageWorkletService_RunURLSelectionOperation_Name = 2;
  var kSharedStorageWorkletService_RunOperation_Name = 3;

  function SharedStorageWorkletServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedStorageWorkletService,
                                                   handleOrPtrInfo);
  }

  function SharedStorageWorkletServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedStorageWorkletService, associatedInterfacePtrInfo);
  }

  SharedStorageWorkletServiceAssociatedPtr.prototype =
      Object.create(SharedStorageWorkletServicePtr.prototype);
  SharedStorageWorkletServiceAssociatedPtr.prototype.constructor =
      SharedStorageWorkletServiceAssociatedPtr;

  function SharedStorageWorkletServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedStorageWorkletServicePtr.prototype.initialize = function() {
    return SharedStorageWorkletServiceProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceProxy.prototype.initialize = function(client, permissionsPolicyState, embedderContext) {
    var params_ = new SharedStorageWorkletService_Initialize_Params();
    params_.client = client;
    params_.permissionsPolicyState = permissionsPolicyState;
    params_.embedderContext = embedderContext;
    var builder = new codec.MessageV2Builder(
        kSharedStorageWorkletService_Initialize_Name,
        codec.align(SharedStorageWorkletService_Initialize_Params.encodedSize));
    builder.setPayload(SharedStorageWorkletService_Initialize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SharedStorageWorkletServicePtr.prototype.addModule = function() {
    return SharedStorageWorkletServiceProxy.prototype.addModule
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceProxy.prototype.addModule = function(urlLoaderFactory, scriptSourceUrl) {
    var params_ = new SharedStorageWorkletService_AddModule_Params();
    params_.urlLoaderFactory = urlLoaderFactory;
    params_.scriptSourceUrl = scriptSourceUrl;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletService_AddModule_Name,
          codec.align(SharedStorageWorkletService_AddModule_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletService_AddModule_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletService_AddModule_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServicePtr.prototype.runURLSelectionOperation = function() {
    return SharedStorageWorkletServiceProxy.prototype.runURLSelectionOperation
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceProxy.prototype.runURLSelectionOperation = function(name, urls, serializedData, paOperationDetails) {
    var params_ = new SharedStorageWorkletService_RunURLSelectionOperation_Params();
    params_.name = name;
    params_.urls = urls;
    params_.serializedData = serializedData;
    params_.paOperationDetails = paOperationDetails;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletService_RunURLSelectionOperation_Name,
          codec.align(SharedStorageWorkletService_RunURLSelectionOperation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletService_RunURLSelectionOperation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SharedStorageWorkletServicePtr.prototype.runOperation = function() {
    return SharedStorageWorkletServiceProxy.prototype.runOperation
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedStorageWorkletServiceProxy.prototype.runOperation = function(name, serializedData, paOperationDetails) {
    var params_ = new SharedStorageWorkletService_RunOperation_Params();
    params_.name = name;
    params_.serializedData = serializedData;
    params_.paOperationDetails = paOperationDetails;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSharedStorageWorkletService_RunOperation_Name,
          codec.align(SharedStorageWorkletService_RunOperation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SharedStorageWorkletService_RunOperation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SharedStorageWorkletService_RunOperation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SharedStorageWorkletServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedStorageWorkletServiceStub.prototype.initialize = function(client, permissionsPolicyState, embedderContext) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(client, permissionsPolicyState, embedderContext);
  }
  SharedStorageWorkletServiceStub.prototype.addModule = function(urlLoaderFactory, scriptSourceUrl) {
    return this.delegate_ && this.delegate_.addModule && this.delegate_.addModule(urlLoaderFactory, scriptSourceUrl);
  }
  SharedStorageWorkletServiceStub.prototype.runURLSelectionOperation = function(name, urls, serializedData, paOperationDetails) {
    return this.delegate_ && this.delegate_.runURLSelectionOperation && this.delegate_.runURLSelectionOperation(name, urls, serializedData, paOperationDetails);
  }
  SharedStorageWorkletServiceStub.prototype.runOperation = function(name, serializedData, paOperationDetails) {
    return this.delegate_ && this.delegate_.runOperation && this.delegate_.runOperation(name, serializedData, paOperationDetails);
  }

  SharedStorageWorkletServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageWorkletService_Initialize_Name:
      var params = reader.decodeStruct(SharedStorageWorkletService_Initialize_Params);
      this.initialize(params.client, params.permissionsPolicyState, params.embedderContext);
      return true;
    default:
      return false;
    }
  };

  SharedStorageWorkletServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedStorageWorkletService_AddModule_Name:
      var params = reader.decodeStruct(SharedStorageWorkletService_AddModule_Params);
      this.addModule(params.urlLoaderFactory, params.scriptSourceUrl).then(function(response) {
        var responseParams =
            new SharedStorageWorkletService_AddModule_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletService_AddModule_Name,
            codec.align(SharedStorageWorkletService_AddModule_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletService_AddModule_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletService_RunURLSelectionOperation_Name:
      var params = reader.decodeStruct(SharedStorageWorkletService_RunURLSelectionOperation_Params);
      this.runURLSelectionOperation(params.name, params.urls, params.serializedData, params.paOperationDetails).then(function(response) {
        var responseParams =
            new SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        responseParams.index = response.index;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletService_RunURLSelectionOperation_Name,
            codec.align(SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSharedStorageWorkletService_RunOperation_Name:
      var params = reader.decodeStruct(SharedStorageWorkletService_RunOperation_Params);
      this.runOperation(params.name, params.serializedData, params.paOperationDetails).then(function(response) {
        var responseParams =
            new SharedStorageWorkletService_RunOperation_ResponseParams();
        responseParams.success = response.success;
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kSharedStorageWorkletService_RunOperation_Name,
            codec.align(SharedStorageWorkletService_RunOperation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SharedStorageWorkletService_RunOperation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSharedStorageWorkletServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedStorageWorkletService_Initialize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedStorageWorkletService_Initialize_Params;
      break;
      case kSharedStorageWorkletService_AddModule_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletService_AddModule_Params;
      break;
      case kSharedStorageWorkletService_RunURLSelectionOperation_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletService_RunURLSelectionOperation_Params;
      break;
      case kSharedStorageWorkletService_RunOperation_Name:
        if (message.expectsResponse())
          paramsClass = SharedStorageWorkletService_RunOperation_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedStorageWorkletServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSharedStorageWorkletService_AddModule_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletService_AddModule_ResponseParams;
        break;
      case kSharedStorageWorkletService_RunURLSelectionOperation_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams;
        break;
      case kSharedStorageWorkletService_RunOperation_Name:
        if (message.isResponse())
          paramsClass = SharedStorageWorkletService_RunOperation_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SharedStorageWorkletService = {
    name: 'blink.mojom.SharedStorageWorkletService',
    kVersion: 0,
    ptrClass: SharedStorageWorkletServicePtr,
    proxyClass: SharedStorageWorkletServiceProxy,
    stubClass: SharedStorageWorkletServiceStub,
    validateRequest: validateSharedStorageWorkletServiceRequest,
    validateResponse: validateSharedStorageWorkletServiceResponse,
  };
  SharedStorageWorkletServiceStub.prototype.validator = validateSharedStorageWorkletServiceRequest;
  SharedStorageWorkletServiceProxy.prototype.validator = validateSharedStorageWorkletServiceResponse;
  exports.SharedStorageWorkletPermissionsPolicyState = SharedStorageWorkletPermissionsPolicyState;
  exports.SharedStorageKeyAndOrValue = SharedStorageKeyAndOrValue;
  exports.PrivateAggregationOperationDetails = PrivateAggregationOperationDetails;
  exports.GetInterestGroupsResult = GetInterestGroupsResult;
  exports.SharedStorageEntriesListener = SharedStorageEntriesListener;
  exports.SharedStorageEntriesListenerPtr = SharedStorageEntriesListenerPtr;
  exports.SharedStorageEntriesListenerAssociatedPtr = SharedStorageEntriesListenerAssociatedPtr;
  exports.SharedStorageWorkletServiceClient = SharedStorageWorkletServiceClient;
  exports.SharedStorageWorkletServiceClientPtr = SharedStorageWorkletServiceClientPtr;
  exports.SharedStorageWorkletServiceClientAssociatedPtr = SharedStorageWorkletServiceClientAssociatedPtr;
  exports.SharedStorageWorkletService = SharedStorageWorkletService;
  exports.SharedStorageWorkletServicePtr = SharedStorageWorkletServicePtr;
  exports.SharedStorageWorkletServiceAssociatedPtr = SharedStorageWorkletServiceAssociatedPtr;
})();