// third_party/blink/public/mojom/speech/speech_synthesis.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { !number }
 */
export const SPEECH_SYNTHESIS_DEFAULT_RATE = 1.0;


/**
 * @const { !number }
 */
export const SPEECH_SYNTHESIS_DEFAULT_PITCH = 1.0;


/**
 * @const { !number }
 */
export const SPEECH_SYNTHESIS_DEFAULT_VOLUME = 1.0;


/**
 * @const { !number }
 */
export const SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET = -1.0;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SpeechSynthesisErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SpeechSynthesisErrorCode = {
  
  kCancelled: 0,
  kInterrupted: 1,
  kErrorOccurred: 2,
  kNoError: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechSynthesisVoiceListObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SpeechSynthesisVoiceListObserver', scope);
  }
}

/** @interface */
export class SpeechSynthesisVoiceListObserverInterface {
  
  /**
   * @param { !Array<!SpeechSynthesisVoice> } voiceList
   */

  onSetVoiceList(voiceList) {}
}

/**
 * @implements { SpeechSynthesisVoiceListObserverInterface }
 */
export class SpeechSynthesisVoiceListObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechSynthesisVoiceListObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechSynthesisVoiceListObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechSynthesisVoiceListObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!SpeechSynthesisVoice> } voiceList
   */

  onSetVoiceList(
      voiceList) {
    this.proxy.sendMessage(
        0,
        SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        [
          voiceList
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechSynthesisVoiceListObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechSynthesisVoiceListObserverReceiver {
  /**
   * @param {!SpeechSynthesisVoiceListObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechSynthesisVoiceListObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechSynthesisVoiceListObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisVoiceListObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        impl.onSetVoiceList.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechSynthesisVoiceListObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesisVoiceListObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechSynthesisVoiceListObserverRemote}
   */
  static getRemote() {
    let remote = new SpeechSynthesisVoiceListObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechSynthesisVoiceListObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechSynthesisVoiceListObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechSynthesisVoiceListObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisVoiceListObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSetVoiceList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        this.onSetVoiceList.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechSynthesisClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SpeechSynthesisClient', scope);
  }
}

/** @interface */
export class SpeechSynthesisClientInterface {
  
  /**
   */

  onStartedSpeaking() {}
  
  /**
   * @param { !SpeechSynthesisErrorCode } errorCode
   */

  onFinishedSpeaking(errorCode) {}
  
  /**
   */

  onPausedSpeaking() {}
  
  /**
   */

  onResumedSpeaking() {}
  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredWordBoundary(charIndex, charLength) {}
  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredSentenceBoundary(charIndex, charLength) {}
  
  /**
   */

  onEncounteredSpeakingError() {}
}

/**
 * @implements { SpeechSynthesisClientInterface }
 */
export class SpeechSynthesisClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechSynthesisClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechSynthesisClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechSynthesisClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStartedSpeaking() {
    this.proxy.sendMessage(
        0,
        SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !SpeechSynthesisErrorCode } errorCode
   */

  onFinishedSpeaking(
      errorCode) {
    this.proxy.sendMessage(
        1,
        SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        [
          errorCode
        ],
        false);
  }

  
  /**
   */

  onPausedSpeaking() {
    this.proxy.sendMessage(
        2,
        SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onResumedSpeaking() {
    this.proxy.sendMessage(
        3,
        SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredWordBoundary(
      charIndex,
      charLength) {
    this.proxy.sendMessage(
        4,
        SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        [
          charIndex,
          charLength
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredSentenceBoundary(
      charIndex,
      charLength) {
    this.proxy.sendMessage(
        5,
        SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        [
          charIndex,
          charLength
        ],
        false);
  }

  
  /**
   */

  onEncounteredSpeakingError() {
    this.proxy.sendMessage(
        6,
        SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechSynthesisClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechSynthesisClientReceiver {
  /**
   * @param {!SpeechSynthesisClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechSynthesisClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechSynthesisClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        impl.onStartedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        impl.onFinishedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        impl.onPausedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        impl.onResumedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        impl.onEncounteredWordBoundary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        impl.onEncounteredSentenceBoundary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        impl.onEncounteredSpeakingError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechSynthesisClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesisClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechSynthesisClientRemote}
   */
  static getRemote() {
    let remote = new SpeechSynthesisClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechSynthesisClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechSynthesisClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechSynthesisClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStartedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        this.onStartedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFinishedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        this.onFinishedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPausedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        this.onPausedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResumedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        this.onResumedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredWordBoundary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        this.onEncounteredWordBoundary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredSentenceBoundary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        this.onEncounteredSentenceBoundary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredSpeakingError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        this.onEncounteredSpeakingError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechSynthesisPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SpeechSynthesis', scope);
  }
}

/** @interface */
export class SpeechSynthesisInterface {
  
  /**
   * @param { !SpeechSynthesisVoiceListObserverRemote } observer
   */

  addVoiceListObserver(observer) {}
  
  /**
   * @param { !SpeechSynthesisUtterance } utterance
   * @param { !SpeechSynthesisClientRemote } client
   */

  speak(utterance, client) {}
  
  /**
   */

  pause() {}
  
  /**
   */

  resume() {}
  
  /**
   */

  cancel() {}
}

/**
 * @implements { SpeechSynthesisInterface }
 */
export class SpeechSynthesisRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechSynthesisPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechSynthesisPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechSynthesisPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SpeechSynthesisVoiceListObserverRemote } observer
   */

  addVoiceListObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !SpeechSynthesisUtterance } utterance
   * @param { !SpeechSynthesisClientRemote } client
   */

  speak(
      utterance,
      client) {
    this.proxy.sendMessage(
        1,
        SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        [
          utterance,
          client
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        2,
        SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        3,
        SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        4,
        SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechSynthesis
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechSynthesisReceiver {
  /**
   * @param {!SpeechSynthesisInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechSynthesisRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechSynthesisRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        impl.addVoiceListObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        impl.speak.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechSynthesis {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesis";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechSynthesisRemote}
   */
  static getRemote() {
    let remote = new SpeechSynthesisRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechSynthesis
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechSynthesisCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechSynthesisRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechSynthesisRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addVoiceListObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        this.addVoiceListObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speak =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        this.speak.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisUtteranceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisVoiceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesis_AddVoiceListObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesis_Speak_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesis_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesis_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechSynthesis_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SpeechSynthesisUtteranceSpec.$,
    'SpeechSynthesisUtterance',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lang', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'voice', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'volume', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rate', 32,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pitch', 40,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class SpeechSynthesisUtterance {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !string } */
    this.lang;
    /** @type { !string } */
    this.voice;
    /** @type { !number } */
    this.volume;
    /** @type { !number } */
    this.rate;
    /** @type { !number } */
    this.pitch;
  }
}



mojo.internal.Struct(
    SpeechSynthesisVoiceSpec.$,
    'SpeechSynthesisVoice',
    [
      mojo.internal.StructField(
        'voiceUri', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lang', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLocalService', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDefault', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SpeechSynthesisVoice {
  constructor() {
    /** @type { !string } */
    this.voiceUri;
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.lang;
    /** @type { !boolean } */
    this.isLocalService;
    /** @type { !boolean } */
    this.isDefault;
  }
}



mojo.internal.Struct(
    SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
    'SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params',
    [
      mojo.internal.StructField(
        'voiceList', 0,
        0,
        mojo.internal.Array(SpeechSynthesisVoiceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params {
  constructor() {
    /** @type { !Array<!SpeechSynthesisVoice> } */
    this.voiceList;
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnStartedSpeaking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnStartedSpeaking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnFinishedSpeaking_Params',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        SpeechSynthesisErrorCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnFinishedSpeaking_Params {
  constructor() {
    /** @type { !SpeechSynthesisErrorCode } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnPausedSpeaking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnPausedSpeaking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnResumedSpeaking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnResumedSpeaking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredWordBoundary_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'charLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnEncounteredWordBoundary_Params {
  constructor() {
    /** @type { !number } */
    this.charIndex;
    /** @type { !number } */
    this.charLength;
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'charLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params {
  constructor() {
    /** @type { !number } */
    this.charIndex;
    /** @type { !number } */
    this.charLength;
  }
}



mojo.internal.Struct(
    SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredSpeakingError_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesisClient_OnEncounteredSpeakingError_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
    'SpeechSynthesis_AddVoiceListObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(SpeechSynthesisVoiceListObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechSynthesis_AddVoiceListObserver_Params {
  constructor() {
    /** @type { !SpeechSynthesisVoiceListObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    SpeechSynthesis_Speak_ParamsSpec.$,
    'SpeechSynthesis_Speak_Params',
    [
      mojo.internal.StructField(
        'utterance', 0,
        0,
        SpeechSynthesisUtteranceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(SpeechSynthesisClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SpeechSynthesis_Speak_Params {
  constructor() {
    /** @type { !SpeechSynthesisUtterance } */
    this.utterance;
    /** @type { !SpeechSynthesisClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    SpeechSynthesis_Pause_ParamsSpec.$,
    'SpeechSynthesis_Pause_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesis_Pause_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesis_Resume_ParamsSpec.$,
    'SpeechSynthesis_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesis_Resume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechSynthesis_Cancel_ParamsSpec.$,
    'SpeechSynthesis_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechSynthesis_Cancel_Params {
  constructor() {
  }
}

