// third_party/blink/public/mojom/storage_access/storage_access_handle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ByteCount as mojoBase_mojom_ByteCount,
  ByteCountSpec as mojoBase_mojom_ByteCountSpec
} from '../../../../../mojo/public/mojom/base/byte_count.mojom.m.js';

import {
  BlobURLStoreRemote as blink_mojom_BlobURLStoreRemote,
  BlobURLStorePendingReceiver as blink_mojom_BlobURLStorePendingReceiver
} from '../blob/blob_url_store.mojom.m.js';

import {
  BroadcastChannelProviderRemote as blink_mojom_BroadcastChannelProviderRemote,
  BroadcastChannelProviderPendingReceiver as blink_mojom_BroadcastChannelProviderPendingReceiver
} from '../broadcastchannel/broadcast_channel.mojom.m.js';

import {
  CacheStorageRemote as blink_mojom_CacheStorageRemote,
  CacheStoragePendingReceiver as blink_mojom_CacheStoragePendingReceiver
} from '../cache_storage/cache_storage.mojom.m.js';

import {
  FileSystemAccessDirectoryHandleRemote as blink_mojom_FileSystemAccessDirectoryHandleRemote,
  FileSystemAccessDirectoryHandlePendingReceiver as blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver
} from '../file_system_access/file_system_access_directory_handle.mojom.m.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from '../file_system_access/file_system_access_error.mojom.m.js';

import {
  IDBFactoryRemote as blink_mojom_IDBFactoryRemote,
  IDBFactoryPendingReceiver as blink_mojom_IDBFactoryPendingReceiver
} from '../indexeddb/indexeddb.mojom.m.js';

import {
  LockManagerRemote as blink_mojom_LockManagerRemote,
  LockManagerPendingReceiver as blink_mojom_LockManagerPendingReceiver
} from '../locks/lock_manager.mojom.m.js';

import {
  SharedWorkerConnectorRemote as blink_mojom_SharedWorkerConnectorRemote,
  SharedWorkerConnectorPendingReceiver as blink_mojom_SharedWorkerConnectorPendingReceiver
} from '../worker/shared_worker_connector.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StorageAccessHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.StorageAccessHandle', scope);
  }
}

/** @interface */
export class StorageAccessHandleInterface {
  
  /**
   * @param { !blink_mojom_IDBFactoryPendingReceiver } receiver
   */

  bindIndexedDB(receiver) {}
  
  /**
   * @param { !blink_mojom_LockManagerPendingReceiver } receiver
   */

  bindLocks(receiver) {}
  
  /**
   * @param { !blink_mojom_CacheStoragePendingReceiver } receiver
   */

  bindCaches(receiver) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {}
  
  /**
   * @return {!Promise<{
        currentUsage: !mojoBase_mojom_ByteCount,
        currentQuota: !mojoBase_mojom_ByteCount,
        success: !boolean,
   *  }>}
   */

  estimate() {}
  
  /**
   * @param { !Object } receiver
   */

  bindBlobStorage(receiver) {}
  
  /**
   * @param { !Object } receiver
   */

  bindBroadcastChannel(receiver) {}
  
  /**
   * @param { !blink_mojom_SharedWorkerConnectorPendingReceiver } receiver
   */

  bindSharedWorker(receiver) {}
}

/**
 * @implements { StorageAccessHandleInterface }
 */
export class StorageAccessHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StorageAccessHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StorageAccessHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StorageAccessHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_IDBFactoryPendingReceiver } receiver
   */

  bindIndexedDB(
      receiver) {
    this.proxy.sendMessage(
        0,
        StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_LockManagerPendingReceiver } receiver
   */

  bindLocks(
      receiver) {
    this.proxy.sendMessage(
        1,
        StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_CacheStoragePendingReceiver } receiver
   */

  bindCaches(
      receiver) {
    this.proxy.sendMessage(
        2,
        StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {
    return this.proxy.sendMessage(
        3,
        StorageAccessHandle_GetDirectory_ParamsSpec.$,
        StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        currentUsage: !mojoBase_mojom_ByteCount,
        currentQuota: !mojoBase_mojom_ByteCount,
        success: !boolean,
   *  }>}
   */

  estimate() {
    return this.proxy.sendMessage(
        4,
        StorageAccessHandle_Estimate_ParamsSpec.$,
        StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } receiver
   */

  bindBlobStorage(
      receiver) {
    this.proxy.sendMessage(
        5,
        StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !Object } receiver
   */

  bindBroadcastChannel(
      receiver) {
    this.proxy.sendMessage(
        6,
        StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_SharedWorkerConnectorPendingReceiver } receiver
   */

  bindSharedWorker(
      receiver) {
    this.proxy.sendMessage(
        7,
        StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StorageAccessHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StorageAccessHandleReceiver {
  /**
   * @param {!StorageAccessHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StorageAccessHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StorageAccessHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAccessHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        impl.bindIndexedDB.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        impl.bindLocks.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        impl.bindCaches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        StorageAccessHandle_GetDirectory_ParamsSpec.$,
        StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        StorageAccessHandle_Estimate_ParamsSpec.$,
        StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        impl.estimate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        impl.bindBlobStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        impl.bindBroadcastChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        impl.bindSharedWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StorageAccessHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageAccessHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StorageAccessHandleRemote}
   */
  static getRemote() {
    let remote = new StorageAccessHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StorageAccessHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StorageAccessHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StorageAccessHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StorageAccessHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindIndexedDB =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        this.bindIndexedDB.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindLocks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        this.bindLocks.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindCaches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        this.bindCaches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        StorageAccessHandle_GetDirectory_ParamsSpec.$,
        StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.estimate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        StorageAccessHandle_Estimate_ParamsSpec.$,
        StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        this.estimate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindBlobStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        this.bindBlobStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindBroadcastChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        this.bindBroadcastChannel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSharedWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        this.bindSharedWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindIndexedDB_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindLocks_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindCaches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_Estimate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_Estimate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindBlobStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindBroadcastChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageAccessHandle_BindSharedWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
    'StorageAccessHandle_BindIndexedDB_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_IDBFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindIndexedDB_Params {
  constructor() {
    /** @type { !blink_mojom_IDBFactoryPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_BindLocks_ParamsSpec.$,
    'StorageAccessHandle_BindLocks_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_LockManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindLocks_Params {
  constructor() {
    /** @type { !blink_mojom_LockManagerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_BindCaches_ParamsSpec.$,
    'StorageAccessHandle_BindCaches_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_CacheStoragePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindCaches_Params {
  constructor() {
    /** @type { !blink_mojom_CacheStoragePendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_GetDirectory_ParamsSpec.$,
    'StorageAccessHandle_GetDirectory_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class StorageAccessHandle_GetDirectory_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
    'StorageAccessHandle_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StorageAccessHandle_GetDirectory_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_Estimate_ParamsSpec.$,
    'StorageAccessHandle_Estimate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class StorageAccessHandle_Estimate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    StorageAccessHandle_Estimate_ResponseParamsSpec.$,
    'StorageAccessHandle_Estimate_ResponseParams',
    [
      mojo.internal.StructField(
        'currentUsage', 0,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentQuota', 8,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class StorageAccessHandle_Estimate_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_ByteCount } */
    this.currentUsage;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.currentQuota;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
    'StorageAccessHandle_BindBlobStorage_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink_mojom_BlobURLStorePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindBlobStorage_Params {
  constructor() {
    /** @type { !Object } */
    this.receiver;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
    'StorageAccessHandle_BindBroadcastChannel_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink_mojom_BroadcastChannelProviderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindBroadcastChannel_Params {
  constructor() {
    /** @type { !Object } */
    this.receiver;
  }
}



mojo.internal.Struct(
    StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
    'StorageAccessHandle_BindSharedWorker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_SharedWorkerConnectorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StorageAccessHandle_BindSharedWorker_Params {
  constructor() {
    /** @type { !blink_mojom_SharedWorkerConnectorPendingReceiver } */
    this.receiver;
  }
}

