// third_party/blink/public/mojom/timing/resource_timing.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/timing/resource_timing.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var load_timing_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/load_timing_info.mojom', '../../../../../services/network/public/mojom/load_timing_info.mojom.js');
  }
  var service_worker_router_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/service_worker_router_info.mojom', '../../../../../services/network/public/mojom/service_worker_router_info.mojom.js');
  }
  var fetch_api_request$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fetch/fetch_api_request.mojom', '../fetch/fetch_api_request.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var CacheState = {};
  CacheState.kNone = 0;
  CacheState.kLocal = 1;
  CacheState.kValidated = 2;
  CacheState.MIN_VALUE = 0;
  CacheState.MAX_VALUE = 2;

  CacheState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CacheState.toKnownEnumValue = function(value) {
    return value;
  };

  CacheState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ServerTimingInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServerTimingInfo.prototype.initDefaults_ = function() {
    this.name = null;
    this.duration = 0;
    this.description = null;
  };
  ServerTimingInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServerTimingInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServerTimingInfo.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServerTimingInfo.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServerTimingInfo.encodedSize = codec.kStructHeaderSize + 24;

  ServerTimingInfo.decode = function(decoder) {
    var packed;
    var val = new ServerTimingInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.duration =
        decoder.decodeStruct(codec.Double);
    val.description =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServerTimingInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServerTimingInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Double, val.duration);
    encoder.encodeStruct(codec.String, val.description);
  };
  function ResourceTimingInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResourceTimingInfo.prototype.initDefaults_ = function() {
    this.name = null;
    this.startTime = null;
    this.alpnNegotiatedProtocol = null;
    this.connectionInfo = null;
    this.timing = null;
    this.lastRedirectEndTime = null;
    this.responseEnd = null;
    this.cacheState = 0;
    this.didReuseConnection = false;
    this.isSecureTransport = false;
    this.allowTimingDetails = false;
    this.allowNegativeValues = false;
    this.renderBlockingStatus = false;
    this.responseStatus = 0;
    this.encodedBodySize = 0;
    this.decodedBodySize = 0;
    this.serverTiming = null;
    this.contentType = null;
    this.contentEncoding = null;
    this.initiatorUrl = null;
    this.serviceWorkerRouterInfo = null;
    this.serviceWorkerResponseSource = 0;
  };
  ResourceTimingInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResourceTimingInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 136}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.alpnNegotiatedProtocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.connectionInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.timing
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, load_timing_info$.LoadTimingInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.lastRedirectEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.responseEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.cacheState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, CacheState);
    if (err !== validator.validationError.NONE)
        return err;








    // validate ResourceTimingInfo.serverTiming
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 80, 8, new codec.PointerTo(ServerTimingInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ResourceTimingInfo.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.contentEncoding
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 96, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.initiatorUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.serviceWorkerRouterInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, service_worker_router_info$.ServiceWorkerRouterInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResourceTimingInfo.serviceWorkerResponseSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 120, fetch_api$.FetchResponseSource);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResourceTimingInfo.encodedSize = codec.kStructHeaderSize + 128;

  ResourceTimingInfo.decode = function(decoder) {
    var packed;
    var val = new ResourceTimingInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.startTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.alpnNegotiatedProtocol =
        decoder.decodeStruct(codec.String);
    val.connectionInfo =
        decoder.decodeStruct(codec.String);
    val.timing =
        decoder.decodeStructPointer(load_timing_info$.LoadTimingInfo);
    val.lastRedirectEndTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.responseEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.cacheState =
        decoder.decodeStruct(new codec.Enum(CacheState));
    packed = decoder.readUint8();
    val.didReuseConnection = (packed >> 0) & 1 ? true : false;
    val.isSecureTransport = (packed >> 1) & 1 ? true : false;
    val.allowTimingDetails = (packed >> 2) & 1 ? true : false;
    val.allowNegativeValues = (packed >> 3) & 1 ? true : false;
    val.renderBlockingStatus = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    val.responseStatus =
        decoder.decodeStruct(codec.Uint16);
    val.encodedBodySize =
        decoder.decodeStruct(codec.Uint64);
    val.decodedBodySize =
        decoder.decodeStruct(codec.Uint64);
    val.serverTiming =
        decoder.decodeArrayPointer(new codec.PointerTo(ServerTimingInfo));
    val.contentType =
        decoder.decodeStruct(codec.String);
    val.contentEncoding =
        decoder.decodeStruct(codec.String);
    val.initiatorUrl =
        decoder.decodeStructPointer(url$.Url);
    val.serviceWorkerRouterInfo =
        decoder.decodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo);
    val.serviceWorkerResponseSource =
        decoder.decodeStruct(new codec.Enum(fetch_api$.FetchResponseSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResourceTimingInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResourceTimingInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(time$.TimeTicks, val.startTime);
    encoder.encodeStruct(codec.String, val.alpnNegotiatedProtocol);
    encoder.encodeStruct(codec.String, val.connectionInfo);
    encoder.encodeStructPointer(load_timing_info$.LoadTimingInfo, val.timing);
    encoder.encodeStructPointer(time$.TimeTicks, val.lastRedirectEndTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.responseEnd);
    encoder.encodeStruct(codec.Int32, val.cacheState);
    packed = 0;
    packed |= (val.didReuseConnection & 1) << 0
    packed |= (val.isSecureTransport & 1) << 1
    packed |= (val.allowTimingDetails & 1) << 2
    packed |= (val.allowNegativeValues & 1) << 3
    packed |= (val.renderBlockingStatus & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.responseStatus);
    encoder.encodeStruct(codec.Uint64, val.encodedBodySize);
    encoder.encodeStruct(codec.Uint64, val.decodedBodySize);
    encoder.encodeArrayPointer(new codec.PointerTo(ServerTimingInfo), val.serverTiming);
    encoder.encodeStruct(codec.String, val.contentType);
    encoder.encodeStruct(codec.String, val.contentEncoding);
    encoder.encodeStructPointer(url$.Url, val.initiatorUrl);
    encoder.encodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo, val.serviceWorkerRouterInfo);
    encoder.encodeStruct(codec.Int32, val.serviceWorkerResponseSource);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.CacheState = CacheState;
  exports.ServerTimingInfo = ServerTimingInfo;
  exports.ResourceTimingInfo = ResourceTimingInfo;
})();