// third_party/blink/public/mojom/webaudio/audio_context_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioContextManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AudioContextManager', scope);
  }
}

/** @interface */
export class AudioContextManagerInterface {
  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStarted(id) {}
  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStopped(id) {}
  
  /**
   * @param { !number } id
   */

  audioContextCreated(id) {}
  
  /**
   * @param { !number } id
   */

  audioContextClosed(id) {}
}

/**
 * @implements { AudioContextManagerInterface }
 */
export class AudioContextManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioContextManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioContextManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioContextManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStarted(
      id) {
    this.proxy.sendMessage(
        0,
        AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStopped(
      id) {
    this.proxy.sendMessage(
        1,
        AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextCreated(
      id) {
    this.proxy.sendMessage(
        2,
        AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextClosed(
      id) {
    this.proxy.sendMessage(
        3,
        AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioContextManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioContextManagerReceiver {
  /**
   * @param {!AudioContextManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioContextManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioContextManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioContextManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        impl.audioContextAudiblePlaybackStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        impl.audioContextAudiblePlaybackStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        impl.audioContextCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        impl.audioContextClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioContextManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AudioContextManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioContextManagerRemote}
   */
  static getRemote() {
    let remote = new AudioContextManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioContextManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioContextManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioContextManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioContextManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextAudiblePlaybackStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        this.audioContextAudiblePlaybackStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextAudiblePlaybackStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        this.audioContextAudiblePlaybackStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        this.audioContextCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        this.audioContextClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioContextManager_AudioContextCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioContextManager_AudioContextClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
    'AudioContextManager_AudioContextAudiblePlaybackStarted_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioContextManager_AudioContextAudiblePlaybackStarted_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
    'AudioContextManager_AudioContextAudiblePlaybackStopped_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioContextManager_AudioContextAudiblePlaybackStopped_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    AudioContextManager_AudioContextCreated_ParamsSpec.$,
    'AudioContextManager_AudioContextCreated_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioContextManager_AudioContextCreated_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    AudioContextManager_AudioContextClosed_ParamsSpec.$,
    'AudioContextManager_AudioContextClosed_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioContextManager_AudioContextClosed_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}

