// third_party/blink/public/mojom/webid/digital_identity_request.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.Value');




goog.provide('blink.mojom.RequestDigitalIdentityStatus');
goog.provide('blink.mojom.RequestDigitalIdentityStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RequestDigitalIdentityStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RequestDigitalIdentityStatus = {
  
  kSuccess: 0,
  kError: 1,
  kErrorTooManyRequests: 2,
  kErrorCanceled: 3,
  kErrorNoRequests: 4,
  kErrorNoTransientUserActivation: 5,
  kErrorInvalidJson: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



goog.provide('blink.mojom.DigitalIdentityRequest');
goog.provide('blink.mojom.DigitalIdentityRequestReceiver');
goog.provide('blink.mojom.DigitalIdentityRequestCallbackRouter');
goog.provide('blink.mojom.DigitalIdentityRequestInterface');
goog.provide('blink.mojom.DigitalIdentityRequestRemote');
goog.provide('blink.mojom.DigitalIdentityRequestPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DigitalIdentityRequestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DigitalIdentityRequest.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DigitalIdentityRequestInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.DigitalCredentialGetRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !blink.mojom.RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase.mojom.Value,
   *  }>}
   */

  get(digitalCredentialRequests) {}
  
  /**
   * @param { !Array<!blink.mojom.DigitalCredentialCreateRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !blink.mojom.RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase.mojom.Value,
   *  }>}
   */

  create(digitalCredentialRequests) {}
  
  /**
   */

  abort() {}
};

/**
 * @export
 * @implements { blink.mojom.DigitalIdentityRequestInterface }
 */
blink.mojom.DigitalIdentityRequestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DigitalIdentityRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DigitalIdentityRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DigitalIdentityRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.DigitalCredentialGetRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !blink.mojom.RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase.mojom.Value,
   *  }>}
   */

  get(
      digitalCredentialRequests) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.DigitalIdentityRequest_Get_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        [
          digitalCredentialRequests
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.DigitalCredentialCreateRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !blink.mojom.RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase.mojom.Value,
   *  }>}
   */

  create(
      digitalCredentialRequests) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.DigitalIdentityRequest_Create_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        [
          digitalCredentialRequests
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        2,
        blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DigitalIdentityRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DigitalIdentityRequestReceiver = class {
  /**
   * @param {!blink.mojom.DigitalIdentityRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DigitalIdentityRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DigitalIdentityRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DigitalIdentityRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DigitalIdentityRequest_Get_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DigitalIdentityRequest_Create_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        impl.create.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DigitalIdentityRequest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DigitalIdentityRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DigitalIdentityRequestRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DigitalIdentityRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DigitalIdentityRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DigitalIdentityRequestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DigitalIdentityRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DigitalIdentityRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DigitalIdentityRequest_Get_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DigitalIdentityRequest_Create_ParamsSpec.$,
        blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        this.create.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DigitalCredentialGetRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalCredentialGetRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalCredentialCreateRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalCredentialCreateRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalIdentityRequest_Get_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalIdentityRequest_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalIdentityRequest_Create_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalIdentityRequest_Create_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DigitalCredentialGetRequestSpec.$,
    'DigitalCredentialGetRequest',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.DigitalCredentialGetRequest');

/** @record */
blink.mojom.DigitalCredentialGetRequest = class {
  constructor() {
    /** @export { !string } */
    this.protocol;
    /** @export { !mojoBase.mojom.Value } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalCredentialCreateRequestSpec.$,
    'DigitalCredentialCreateRequest',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.DigitalCredentialCreateRequest');

/** @record */
blink.mojom.DigitalCredentialCreateRequest = class {
  constructor() {
    /** @export { !string } */
    this.protocol;
    /** @export { !mojoBase.mojom.Value } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalIdentityRequest_Get_ParamsSpec.$,
    'DigitalIdentityRequest_Get_Params',
    [
      mojo.internal.StructField(
        'digitalCredentialRequests', 0,
        0,
        mojo.internal.Array(blink.mojom.DigitalCredentialGetRequestSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.DigitalIdentityRequest_Get_Params');

/** @record */
blink.mojom.DigitalIdentityRequest_Get_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.DigitalCredentialGetRequest> } */
    this.digitalCredentialRequests;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalIdentityRequest_Get_ResponseParamsSpec.$,
    'DigitalIdentityRequest_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.RequestDigitalIdentityStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocol', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.DigitalIdentityRequest_Get_ResponseParams');

/** @record */
blink.mojom.DigitalIdentityRequest_Get_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.RequestDigitalIdentityStatus } */
    this.status;
    /** @export { (string|undefined) } */
    this.protocol;
    /** @export { (mojoBase.mojom.Value|undefined) } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalIdentityRequest_Create_ParamsSpec.$,
    'DigitalIdentityRequest_Create_Params',
    [
      mojo.internal.StructField(
        'digitalCredentialRequests', 0,
        0,
        mojo.internal.Array(blink.mojom.DigitalCredentialCreateRequestSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.DigitalIdentityRequest_Create_Params');

/** @record */
blink.mojom.DigitalIdentityRequest_Create_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.DigitalCredentialCreateRequest> } */
    this.digitalCredentialRequests;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalIdentityRequest_Create_ResponseParamsSpec.$,
    'DigitalIdentityRequest_Create_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.RequestDigitalIdentityStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocol', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.DigitalIdentityRequest_Create_ResponseParams');

/** @record */
blink.mojom.DigitalIdentityRequest_Create_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.RequestDigitalIdentityStatus } */
    this.status;
    /** @export { (string|undefined) } */
    this.protocol;
    /** @export { (mojoBase.mojom.Value|undefined) } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.DigitalIdentityRequest_Abort_ParamsSpec.$,
    'DigitalIdentityRequest_Abort_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DigitalIdentityRequest_Abort_Params');

/** @record */
blink.mojom.DigitalIdentityRequest_Abort_Params = class {
  constructor() {
  }
};

