// third_party/blink/public/mojom/webid/federated_auth_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  CredentialMediationRequirement as blink_mojom_CredentialMediationRequirement,
  CredentialMediationRequirementSpec as blink_mojom_CredentialMediationRequirementSpec
} from '../credentialmanagement/credential_manager.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RequestTokenStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RequestTokenStatus = {
  
  kSuccess: 0,
  kErrorTooManyRequests: 1,
  kErrorCanceled: 2,
  kError: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RequestUserInfoStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RequestUserInfoStatus = {
  
  kSuccess: 0,
  kError: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DisconnectStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DisconnectStatus = {
  
  kSuccess: 0,
  kErrorTooManyRequests: 1,
  kError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IdpSigninStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IdpSigninStatus = {
  
  kSignedIn: 0,
  kSignedOut: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RpContextSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RpContext = {
  
  kSignIn: 0,
  kSignUp: 1,
  kUse: 2,
  kContinue: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RpModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RpMode = {
  
  kActive: 0,
  kPassive: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RegisterIdpStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RegisterIdpStatus = {
  
  kSuccess: 0,
  kErrorFeatureDisabled: 1,
  kErrorCrossOriginConfig: 2,
  kErrorNoTransientActivation: 3,
  kErrorDeclined: 4,
  kErrorInvalidConfig: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Format = {
  
  kSdJwt: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FederatedAuthRequestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FederatedAuthRequest', scope);
  }
}

/** @interface */
export class FederatedAuthRequestInterface {
  
  /**
   * @param { !Array<!IdentityProviderGetParameters> } idpGetParams
   * @param { !blink_mojom_CredentialMediationRequirement } requirement
   * @return {!Promise<{
        status: !RequestTokenStatus,
        selectedIdentityProviderConfigUrl: ?url_mojom_Url,
        token: ?mojoBase_mojom_Value,
        error: ?TokenError,
        isAutoSelected: !boolean,
   *  }>}
   */

  requestToken(idpGetParams, requirement) {}
  
  /**
   * @param { !IdentityProviderConfig } provider
   * @return {!Promise<{
        status: !RequestUserInfoStatus,
        userInfo: ?Array<!IdentityUserInfo>,
   *  }>}
   */

  requestUserInfo(provider) {}
  
  /**
   */

  cancelTokenRequest() {}
  
  /**
   * @param { ?string } accountId
   * @param { !mojoBase_mojom_Value } token
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  resolveTokenRequest(accountId, token) {}
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !IdpSigninStatus } status
   * @param { ?LoginStatusOptions } options
   * @return {!Promise}
   */

  setIdpSigninStatus(origin, status, options) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        status: !RegisterIdpStatus,
   *  }>}
   */

  registerIdP(url) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unregisterIdP(url) {}
  
  /**
   */

  closeModalDialogView() {}
  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {}
  
  /**
   * @param { !IdentityCredentialDisconnectOptions } options
   * @return {!Promise<{
        status: !DisconnectStatus,
   *  }>}
   */

  disconnect(options) {}
}

/**
 * @implements { FederatedAuthRequestInterface }
 */
export class FederatedAuthRequestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FederatedAuthRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FederatedAuthRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FederatedAuthRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!IdentityProviderGetParameters> } idpGetParams
   * @param { !blink_mojom_CredentialMediationRequirement } requirement
   * @return {!Promise<{
        status: !RequestTokenStatus,
        selectedIdentityProviderConfigUrl: ?url_mojom_Url,
        token: ?mojoBase_mojom_Value,
        error: ?TokenError,
        isAutoSelected: !boolean,
   *  }>}
   */

  requestToken(
      idpGetParams,
      requirement) {
    return this.proxy.sendMessage(
        0,
        FederatedAuthRequest_RequestToken_ParamsSpec.$,
        FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        [
          idpGetParams,
          requirement
        ],
        false);
  }

  
  /**
   * @param { !IdentityProviderConfig } provider
   * @return {!Promise<{
        status: !RequestUserInfoStatus,
        userInfo: ?Array<!IdentityUserInfo>,
   *  }>}
   */

  requestUserInfo(
      provider) {
    return this.proxy.sendMessage(
        1,
        FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        [
          provider
        ],
        false);
  }

  
  /**
   */

  cancelTokenRequest() {
    this.proxy.sendMessage(
        2,
        FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } accountId
   * @param { !mojoBase_mojom_Value } token
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  resolveTokenRequest(
      accountId,
      token) {
    return this.proxy.sendMessage(
        3,
        FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        [
          accountId,
          token
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !IdpSigninStatus } status
   * @param { ?LoginStatusOptions } options
   * @return {!Promise}
   */

  setIdpSigninStatus(
      origin,
      status,
      options) {
    return this.proxy.sendMessage(
        4,
        FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        [
          origin,
          status,
          options
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        status: !RegisterIdpStatus,
   *  }>}
   */

  registerIdP(
      url) {
    return this.proxy.sendMessage(
        5,
        FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unregisterIdP(
      url) {
    return this.proxy.sendMessage(
        6,
        FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   */

  closeModalDialogView() {
    this.proxy.sendMessage(
        7,
        FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {
    return this.proxy.sendMessage(
        8,
        FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !IdentityCredentialDisconnectOptions } options
   * @return {!Promise<{
        status: !DisconnectStatus,
   *  }>}
   */

  disconnect(
      options) {
    return this.proxy.sendMessage(
        9,
        FederatedAuthRequest_Disconnect_ParamsSpec.$,
        FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FederatedAuthRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FederatedAuthRequestReceiver {
  /**
   * @param {!FederatedAuthRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FederatedAuthRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FederatedAuthRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FederatedAuthRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FederatedAuthRequest_RequestToken_ParamsSpec.$,
        FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        impl.requestToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        impl.requestUserInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        impl.cancelTokenRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        impl.resolveTokenRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        impl.setIdpSigninStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        impl.registerIdP.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        impl.unregisterIdP.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        impl.closeModalDialogView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        impl.preventSilentAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        FederatedAuthRequest_Disconnect_ParamsSpec.$,
        FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FederatedAuthRequest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FederatedAuthRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FederatedAuthRequestRemote}
   */
  static getRemote() {
    let remote = new FederatedAuthRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FederatedAuthRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FederatedAuthRequestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FederatedAuthRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FederatedAuthRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FederatedAuthRequest_RequestToken_ParamsSpec.$,
        FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        this.requestToken.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestUserInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        this.requestUserInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelTokenRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        this.cancelTokenRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveTokenRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        this.resolveTokenRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIdpSigninStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        this.setIdpSigninStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerIdP =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        this.registerIdP.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregisterIdP =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        this.unregisterIdP.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeModalDialogView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        this.closeModalDialogView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preventSilentAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        this.preventSilentAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        FederatedAuthRequest_Disconnect_ParamsSpec.$,
        FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentityProviderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentityProviderRequestOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentityCredentialDisconnectOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentityUserInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LoginStatusAccountSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LoginStatusOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentityProviderGetParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TokenErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RequestToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RequestToken_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RequestUserInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_CancelTokenRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_ResolveTokenRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RegisterIdP_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_RegisterIdP_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_UnregisterIdP_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_CloseModalDialogView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_PreventSilentAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_Disconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequest_Disconnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    IdentityProviderConfigSpec.$,
    'IdentityProviderConfig',
    [
      mojo.internal.StructField(
        'configUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fromIdpRegistrationApi', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientId', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IdentityProviderConfig {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.configUrl;
    /** @type { !boolean } */
    this.fromIdpRegistrationApi;
    /** @type { (string|undefined) } */
    this.type;
    /** @type { !string } */
    this.clientId;
  }
}



mojo.internal.Struct(
    IdentityProviderRequestOptionsSpec.$,
    'IdentityProviderRequestOptions',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        IdentityProviderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nonce', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loginHint', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domainHint', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fields', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paramsJson', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'format_$flag', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "format_$value",
          originalFieldName: "format",
        }
      ),
      mojo.internal.StructField(
        'format_$value', 52,
        0,
        FormatSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "format",
        }
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class IdentityProviderRequestOptions {
  constructor() {
    /** @type { !IdentityProviderConfig } */
    this.config;
    /** @type { !string } */
    this.nonce;
    /** @type { !string } */
    this.loginHint;
    /** @type { !string } */
    this.domainHint;
    /** @type { (Array<!string>|undefined) } */
    this.fields;
    /** @type { (string|undefined) } */
    this.paramsJson;
    /** @type { (Format|undefined) } */
    this.format;
  }
}



mojo.internal.Struct(
    IdentityCredentialDisconnectOptionsSpec.$,
    'IdentityCredentialDisconnectOptions',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        IdentityProviderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accountHint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IdentityCredentialDisconnectOptions {
  constructor() {
    /** @type { !IdentityProviderConfig } */
    this.config;
    /** @type { !string } */
    this.accountHint;
  }
}



mojo.internal.Struct(
    IdentityUserInfoSpec.$,
    'IdentityUserInfo',
    [
      mojo.internal.StructField(
        'email', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'givenName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'picture', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class IdentityUserInfo {
  constructor() {
    /** @type { !string } */
    this.email;
    /** @type { !string } */
    this.givenName;
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.picture;
  }
}



mojo.internal.Struct(
    LoginStatusAccountSpec.$,
    'LoginStatusAccount',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'email', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'givenName', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'picture', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class LoginStatusAccount {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.email;
    /** @type { !string } */
    this.name;
    /** @type { (string|undefined) } */
    this.givenName;
    /** @type { (url_mojom_Url|undefined) } */
    this.picture;
  }
}



mojo.internal.Struct(
    LoginStatusOptionsSpec.$,
    'LoginStatusOptions',
    [
      mojo.internal.StructField(
        'accounts', 0,
        0,
        mojo.internal.Array(LoginStatusAccountSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LoginStatusOptions {
  constructor() {
    /** @type { !Array<!LoginStatusAccount> } */
    this.accounts;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.expiration;
  }
}



mojo.internal.Struct(
    IdentityProviderGetParametersSpec.$,
    'IdentityProviderGetParameters',
    [
      mojo.internal.StructField(
        'providers', 0,
        0,
        mojo.internal.Array(IdentityProviderRequestOptionsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        RpContextSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 12,
        0,
        RpModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IdentityProviderGetParameters {
  constructor() {
    /** @type { !Array<!IdentityProviderRequestOptions> } */
    this.providers;
    /** @type { !RpContext } */
    this.context;
    /** @type { !RpMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    TokenErrorSpec.$,
    'TokenError',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TokenError {
  constructor() {
    /** @type { (string|undefined) } */
    this.code;
    /** @type { (string|undefined) } */
    this.url;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RequestToken_ParamsSpec.$,
    'FederatedAuthRequest_RequestToken_Params',
    [
      mojo.internal.StructField(
        'idpGetParams', 0,
        0,
        mojo.internal.Array(IdentityProviderGetParametersSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requirement', 8,
        0,
        blink_mojom_CredentialMediationRequirementSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FederatedAuthRequest_RequestToken_Params {
  constructor() {
    /** @type { !Array<!IdentityProviderGetParameters> } */
    this.idpGetParams;
    /** @type { !blink_mojom_CredentialMediationRequirement } */
    this.requirement;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
    'FederatedAuthRequest_RequestToken_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        RequestTokenStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedIdentityProviderConfigUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 32,
        0,
        TokenErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAutoSelected', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class FederatedAuthRequest_RequestToken_ResponseParams {
  constructor() {
    /** @type { !RequestTokenStatus } */
    this.status;
    /** @type { (url_mojom_Url|undefined) } */
    this.selectedIdentityProviderConfigUrl;
    /** @type { (mojoBase_mojom_Value|undefined) } */
    this.token;
    /** @type { (TokenError|undefined) } */
    this.error;
    /** @type { !boolean } */
    this.isAutoSelected;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
    'FederatedAuthRequest_RequestUserInfo_Params',
    [
      mojo.internal.StructField(
        'provider', 0,
        0,
        IdentityProviderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_RequestUserInfo_Params {
  constructor() {
    /** @type { !IdentityProviderConfig } */
    this.provider;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
    'FederatedAuthRequest_RequestUserInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        RequestUserInfoStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userInfo', 8,
        0,
        mojo.internal.Array(IdentityUserInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FederatedAuthRequest_RequestUserInfo_ResponseParams {
  constructor() {
    /** @type { !RequestUserInfoStatus } */
    this.status;
    /** @type { (Array<!IdentityUserInfo>|undefined) } */
    this.userInfo;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
    'FederatedAuthRequest_CancelTokenRequest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FederatedAuthRequest_CancelTokenRequest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
    'FederatedAuthRequest_ResolveTokenRequest_Params',
    [
      mojo.internal.StructField(
        'accountId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FederatedAuthRequest_ResolveTokenRequest_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.accountId;
    /** @type { !mojoBase_mojom_Value } */
    this.token;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
    'FederatedAuthRequest_ResolveTokenRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_ResolveTokenRequest_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
    'FederatedAuthRequest_SetIdpSigninStatus_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        IdpSigninStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        LoginStatusOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FederatedAuthRequest_SetIdpSigninStatus_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !IdpSigninStatus } */
    this.status;
    /** @type { (LoginStatusOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
    'FederatedAuthRequest_SetIdpSigninStatus_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FederatedAuthRequest_SetIdpSigninStatus_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
    'FederatedAuthRequest_RegisterIdP_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_RegisterIdP_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
    'FederatedAuthRequest_RegisterIdP_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        RegisterIdpStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_RegisterIdP_ResponseParams {
  constructor() {
    /** @type { !RegisterIdpStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
    'FederatedAuthRequest_UnregisterIdP_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_UnregisterIdP_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
    'FederatedAuthRequest_UnregisterIdP_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_UnregisterIdP_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
    'FederatedAuthRequest_CloseModalDialogView_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FederatedAuthRequest_CloseModalDialogView_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
    'FederatedAuthRequest_PreventSilentAccess_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FederatedAuthRequest_PreventSilentAccess_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
    'FederatedAuthRequest_PreventSilentAccess_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FederatedAuthRequest_PreventSilentAccess_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_Disconnect_ParamsSpec.$,
    'FederatedAuthRequest_Disconnect_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        IdentityCredentialDisconnectOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_Disconnect_Params {
  constructor() {
    /** @type { !IdentityCredentialDisconnectOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
    'FederatedAuthRequest_Disconnect_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DisconnectStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequest_Disconnect_ResponseParams {
  constructor() {
    /** @type { !DisconnectStatus } */
    this.status;
  }
}

