// third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  CredentialsMode as network_mojom_CredentialsMode,
  CredentialsModeSpec as network_mojom_CredentialsModeSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  StorageAccessApiStatus as network_mojom_StorageAccessApiStatus,
  StorageAccessApiStatusSpec as network_mojom_StorageAccessApiStatusSpec
} from '../../../../../services/network/public/mojom/storage_access_api.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BlobURLTokenRemote as blink_mojom_BlobURLTokenRemote,
  BlobURLTokenPendingReceiver as blink_mojom_BlobURLTokenPendingReceiver
} from '../blob/blob_url_store.mojom.m.js';

import {
  BrowserInterfaceBrokerRemote as blink_mojom_BrowserInterfaceBrokerRemote,
  BrowserInterfaceBrokerPendingReceiver as blink_mojom_BrowserInterfaceBrokerPendingReceiver
} from '../browser_interface_broker.mojom.m.js';

import {
  BackForwardCacheControllerHostRemote as blink_mojom_BackForwardCacheControllerHostRemote,
  BackForwardCacheControllerHostPendingReceiver as blink_mojom_BackForwardCacheControllerHostPendingReceiver
} from '../frame/back_forward_cache_controller.mojom.m.js';

import {
  ReportingObserverRemote as blink_mojom_ReportingObserverRemote,
  ReportingObserverPendingReceiver as blink_mojom_ReportingObserverPendingReceiver
} from '../frame/reporting_observer.mojom.m.js';

import {
  FetchClientSettingsObject as blink_mojom_FetchClientSettingsObject,
  FetchClientSettingsObjectSpec as blink_mojom_FetchClientSettingsObjectSpec
} from '../loader/fetch_client_settings_object.mojom.m.js';

import {
  URLLoaderFactoryBundle as blink_mojom_URLLoaderFactoryBundle,
  URLLoaderFactoryBundleSpec as blink_mojom_URLLoaderFactoryBundleSpec
} from '../loader/url_loader_factory_bundle.mojom.m.js';

import {
  ControllerServiceWorkerInfo as blink_mojom_ControllerServiceWorkerInfo,
  ControllerServiceWorkerInfoSpec as blink_mojom_ControllerServiceWorkerInfoSpec
} from '../service_worker/controller_service_worker.mojom.m.js';

import {
  ServiceWorkerContainerInfoForClient as blink_mojom_ServiceWorkerContainerInfoForClient,
  ServiceWorkerContainerInfoForClientSpec as blink_mojom_ServiceWorkerContainerInfoForClientSpec
} from '../service_worker/service_worker_container.mojom.m.js';

import {
  DedicatedWorkerToken as blink_mojom_DedicatedWorkerToken,
  DedicatedWorkerTokenSpec as blink_mojom_DedicatedWorkerTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  DedicatedWorkerHostRemote as blink_mojom_DedicatedWorkerHostRemote,
  DedicatedWorkerHostPendingReceiver as blink_mojom_DedicatedWorkerHostPendingReceiver
} from './dedicated_worker_host.mojom.m.js';

import {
  SubresourceLoaderUpdaterRemote as blink_mojom_SubresourceLoaderUpdaterRemote,
  SubresourceLoaderUpdaterPendingReceiver as blink_mojom_SubresourceLoaderUpdaterPendingReceiver
} from './subresource_loader_updater.mojom.m.js';

import {
  WorkerMainScriptLoadParams as blink_mojom_WorkerMainScriptLoadParams,
  WorkerMainScriptLoadParamsSpec as blink_mojom_WorkerMainScriptLoadParamsSpec
} from './worker_main_script_load_params.mojom.m.js';


/**
 * @const { !string }
 */
export const NAVIGATION_DEDICATED_WORKER_SPEC = "navigation:dedicated_worker";




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DedicatedWorkerHostFactoryClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DedicatedWorkerHostFactoryClient', scope);
  }
}

/** @interface */
export class DedicatedWorkerHostFactoryClientInterface {
  
  /**
   * @param { !blink_mojom_BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !blink_mojom_DedicatedWorkerHostRemote } host
   * @param { !url_mojom_Origin } origin
   */

  onWorkerHostCreated(browserInterfaceBroker, host, origin) {}
  
  /**
   * @param { ?blink_mojom_ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink_mojom_WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { !blink_mojom_SubresourceLoaderUpdaterPendingReceiver } subresourceLoaderUpdater
   * @param { ?blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink_mojom_BackForwardCacheControllerHostRemote } backForwardCacheControllerHost
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } dipReportingObserverReceiver
   */

  onScriptLoadStarted(serviceWorkerContainerInfo, mainScriptLoadParams, subresourceLoaderFactories, subresourceLoaderUpdater, controllerInfo, backForwardCacheControllerHost, coepReportingObserverReceiver, dipReportingObserverReceiver) {}
  
  /**
   */

  onScriptLoadStartFailed() {}
}

/**
 * @implements { DedicatedWorkerHostFactoryClientInterface }
 */
export class DedicatedWorkerHostFactoryClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DedicatedWorkerHostFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DedicatedWorkerHostFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DedicatedWorkerHostFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !blink_mojom_DedicatedWorkerHostRemote } host
   * @param { !url_mojom_Origin } origin
   */

  onWorkerHostCreated(
      browserInterfaceBroker,
      host,
      origin) {
    this.proxy.sendMessage(
        0,
        DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        [
          browserInterfaceBroker,
          host,
          origin
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink_mojom_WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { !blink_mojom_SubresourceLoaderUpdaterPendingReceiver } subresourceLoaderUpdater
   * @param { ?blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink_mojom_BackForwardCacheControllerHostRemote } backForwardCacheControllerHost
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } dipReportingObserverReceiver
   */

  onScriptLoadStarted(
      serviceWorkerContainerInfo,
      mainScriptLoadParams,
      subresourceLoaderFactories,
      subresourceLoaderUpdater,
      controllerInfo,
      backForwardCacheControllerHost,
      coepReportingObserverReceiver,
      dipReportingObserverReceiver) {
    this.proxy.sendMessage(
        1,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        [
          serviceWorkerContainerInfo,
          mainScriptLoadParams,
          subresourceLoaderFactories,
          subresourceLoaderUpdater,
          controllerInfo,
          backForwardCacheControllerHost,
          coepReportingObserverReceiver,
          dipReportingObserverReceiver
        ],
        false);
  }

  
  /**
   */

  onScriptLoadStartFailed() {
    this.proxy.sendMessage(
        2,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DedicatedWorkerHostFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DedicatedWorkerHostFactoryClientReceiver {
  /**
   * @param {!DedicatedWorkerHostFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DedicatedWorkerHostFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DedicatedWorkerHostFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DedicatedWorkerHostFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        impl.onWorkerHostCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        impl.onScriptLoadStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        impl.onScriptLoadStartFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DedicatedWorkerHostFactoryClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DedicatedWorkerHostFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DedicatedWorkerHostFactoryClientRemote}
   */
  static getRemote() {
    let remote = new DedicatedWorkerHostFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DedicatedWorkerHostFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DedicatedWorkerHostFactoryClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DedicatedWorkerHostFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DedicatedWorkerHostFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWorkerHostCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        this.onWorkerHostCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        this.onScriptLoadStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadStartFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        this.onScriptLoadStartFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DedicatedWorkerHostFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DedicatedWorkerHostFactory', scope);
  }
}

/** @interface */
export class DedicatedWorkerHostFactoryInterface {
  
  /**
   * @param { !blink_mojom_DedicatedWorkerToken } token
   * @param { !url_mojom_Url } scriptUrl
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @param { ?blink_mojom_BlobURLTokenRemote } blobUrlToken
   * @param { !DedicatedWorkerHostFactoryClientRemote } client
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   */

  createWorkerHostAndStartScriptLoad(token, scriptUrl, credentialsMode, outsideFetchClientSettingsObject, blobUrlToken, client, storageAccessApiStatus) {}
}

/**
 * @implements { DedicatedWorkerHostFactoryInterface }
 */
export class DedicatedWorkerHostFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DedicatedWorkerHostFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DedicatedWorkerHostFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DedicatedWorkerHostFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_DedicatedWorkerToken } token
   * @param { !url_mojom_Url } scriptUrl
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @param { ?blink_mojom_BlobURLTokenRemote } blobUrlToken
   * @param { !DedicatedWorkerHostFactoryClientRemote } client
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   */

  createWorkerHostAndStartScriptLoad(
      token,
      scriptUrl,
      credentialsMode,
      outsideFetchClientSettingsObject,
      blobUrlToken,
      client,
      storageAccessApiStatus) {
    this.proxy.sendMessage(
        0,
        DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        [
          token,
          scriptUrl,
          credentialsMode,
          outsideFetchClientSettingsObject,
          blobUrlToken,
          client,
          storageAccessApiStatus
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DedicatedWorkerHostFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DedicatedWorkerHostFactoryReceiver {
  /**
   * @param {!DedicatedWorkerHostFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DedicatedWorkerHostFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DedicatedWorkerHostFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DedicatedWorkerHostFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        impl.createWorkerHostAndStartScriptLoad.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DedicatedWorkerHostFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DedicatedWorkerHostFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DedicatedWorkerHostFactoryRemote}
   */
  static getRemote() {
    let remote = new DedicatedWorkerHostFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DedicatedWorkerHostFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DedicatedWorkerHostFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DedicatedWorkerHostFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DedicatedWorkerHostFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWorkerHostAndStartScriptLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        this.createWorkerHostAndStartScriptLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params',
    [
      mojo.internal.StructField(
        'browserInterfaceBroker', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BrowserInterfaceBrokerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_DedicatedWorkerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params {
  constructor() {
    /** @type { !blink_mojom_BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @type { !blink_mojom_DedicatedWorkerHostRemote } */
    this.host;
    /** @type { !url_mojom_Origin } */
    this.origin;
  }
}



mojo.internal.Struct(
    DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerContainerInfo', 0,
        0,
        blink_mojom_ServiceWorkerContainerInfoForClientSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 8,
        0,
        blink_mojom_WorkerMainScriptLoadParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 16,
        0,
        blink_mojom_URLLoaderFactoryBundleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoaderUpdater', 24,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_SubresourceLoaderUpdaterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controllerInfo', 32,
        0,
        blink_mojom_ControllerServiceWorkerInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'backForwardCacheControllerHost', 40,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BackForwardCacheControllerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'coepReportingObserverReceiver', 28,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dipReportingObserverReceiver', 48,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params {
  constructor() {
    /** @type { (blink_mojom_ServiceWorkerContainerInfoForClient|undefined) } */
    this.serviceWorkerContainerInfo;
    /** @type { !blink_mojom_WorkerMainScriptLoadParams } */
    this.mainScriptLoadParams;
    /** @type { !blink_mojom_URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @type { !blink_mojom_SubresourceLoaderUpdaterPendingReceiver } */
    this.subresourceLoaderUpdater;
    /** @type { (blink_mojom_ControllerServiceWorkerInfo|undefined) } */
    this.controllerInfo;
    /** @type { !blink_mojom_BackForwardCacheControllerHostRemote } */
    this.backForwardCacheControllerHost;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserverReceiver;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserverReceiver;
  }
}



mojo.internal.Struct(
    DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
    'DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_DedicatedWorkerTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credentialsMode', 16,
        0,
        network_mojom_CredentialsModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 24,
        0,
        blink_mojom_FetchClientSettingsObjectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 32,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobURLTokenRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 40,
        0,
        mojo.internal.InterfaceProxy(DedicatedWorkerHostFactoryClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 20,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params {
  constructor() {
    /** @type { !blink_mojom_DedicatedWorkerToken } */
    this.token;
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
    /** @type { !network_mojom_CredentialsMode } */
    this.credentialsMode;
    /** @type { !blink_mojom_FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
    /** @type { (blink_mojom_BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
    /** @type { !DedicatedWorkerHostFactoryClientRemote } */
    this.client;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.storageAccessApiStatus;
  }
}

