// third_party/blink/public/mojom/worker/shared_worker_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  BrowserInterfaceBrokerRemote as blink_mojom_BrowserInterfaceBrokerRemote,
  BrowserInterfaceBrokerPendingReceiver as blink_mojom_BrowserInterfaceBrokerPendingReceiver
} from '../browser_interface_broker.mojom.m.js';

import {
  CanvasNoiseTokenUpdaterRemote as blink_mojom_CanvasNoiseTokenUpdaterRemote,
  CanvasNoiseTokenUpdaterPendingReceiver as blink_mojom_CanvasNoiseTokenUpdaterPendingReceiver
} from '../fingerprinting_protection/canvas_interventions.mojom.m.js';

import {
  NoiseToken as blink_mojom_NoiseToken,
  NoiseTokenSpec as blink_mojom_NoiseTokenSpec
} from '../fingerprinting_protection/noise_token.mojom.m.js';

import {
  PolicyContainer as blink_mojom_PolicyContainer,
  PolicyContainerSpec as blink_mojom_PolicyContainerSpec
} from '../frame/policy_container.mojom.m.js';

import {
  ReportingObserverRemote as blink_mojom_ReportingObserverRemote,
  ReportingObserverPendingReceiver as blink_mojom_ReportingObserverPendingReceiver
} from '../frame/reporting_observer.mojom.m.js';

import {
  URLLoaderFactoryBundle as blink_mojom_URLLoaderFactoryBundle,
  URLLoaderFactoryBundleSpec as blink_mojom_URLLoaderFactoryBundleSpec
} from '../loader/url_loader_factory_bundle.mojom.m.js';

import {
  RendererPreferenceWatcherRemote as blink_mojom_RendererPreferenceWatcherRemote,
  RendererPreferenceWatcherPendingReceiver as blink_mojom_RendererPreferenceWatcherPendingReceiver
} from '../renderer_preference_watcher.mojom.m.js';

import {
  RendererPreferences as blink_mojom_RendererPreferences,
  RendererPreferencesSpec as blink_mojom_RendererPreferencesSpec
} from '../renderer_preferences.mojom.m.js';

import {
  ControllerServiceWorkerInfo as blink_mojom_ControllerServiceWorkerInfo,
  ControllerServiceWorkerInfoSpec as blink_mojom_ControllerServiceWorkerInfoSpec
} from '../service_worker/controller_service_worker.mojom.m.js';

import {
  ServiceWorkerContainerInfoForClient as blink_mojom_ServiceWorkerContainerInfoForClient,
  ServiceWorkerContainerInfoForClientSpec as blink_mojom_ServiceWorkerContainerInfoForClientSpec
} from '../service_worker/service_worker_container.mojom.m.js';

import {
  StorageKey as blink_mojom_StorageKey,
  StorageKeySpec as blink_mojom_StorageKeySpec
} from '../storage_key/storage_key.mojom.m.js';

import {
  SharedWorkerToken as blink_mojom_SharedWorkerToken,
  SharedWorkerTokenSpec as blink_mojom_SharedWorkerTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  UserAgentMetadata as blink_mojom_UserAgentMetadata,
  UserAgentMetadataSpec as blink_mojom_UserAgentMetadataSpec
} from '../user_agent/user_agent_metadata.mojom.m.js';

import {
  SharedWorkerRemote as blink_mojom_SharedWorkerRemote,
  SharedWorkerPendingReceiver as blink_mojom_SharedWorkerPendingReceiver
} from './shared_worker.mojom.m.js';

import {
  SharedWorkerHostRemote as blink_mojom_SharedWorkerHostRemote,
  SharedWorkerHostPendingReceiver as blink_mojom_SharedWorkerHostPendingReceiver
} from './shared_worker_host.mojom.m.js';

import {
  SharedWorkerInfo as blink_mojom_SharedWorkerInfo,
  SharedWorkerInfoSpec as blink_mojom_SharedWorkerInfoSpec
} from './shared_worker_info.mojom.m.js';

import {
  WorkerContentSettingsProxyRemote as blink_mojom_WorkerContentSettingsProxyRemote,
  WorkerContentSettingsProxyPendingReceiver as blink_mojom_WorkerContentSettingsProxyPendingReceiver
} from './worker_content_settings_proxy.mojom.m.js';

import {
  WorkerMainScriptLoadParams as blink_mojom_WorkerMainScriptLoadParams,
  WorkerMainScriptLoadParamsSpec as blink_mojom_WorkerMainScriptLoadParamsSpec
} from './worker_main_script_load_params.mojom.m.js';


/**
 * @const { !string }
 */
export const NAVIGATION_SHARED_WORKER_SPEC = "navigation:shared_worker";




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedWorkerFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedWorkerFactory', scope);
  }
}

/** @interface */
export class SharedWorkerFactoryInterface {
  
  /**
   * @param { !blink_mojom_SharedWorkerInfo } info
   * @param { !blink_mojom_SharedWorkerToken } token
   * @param { !blink_mojom_StorageKey } constructorKey
   * @param { !url_mojom_Origin } origin
   * @param { !boolean } isConstructorSecureContext
   * @param { !string } userAgent
   * @param { !blink_mojom_UserAgentMetadata } uaMetadata
   * @param { !boolean } pauseOnStart
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsWorkerToken
   * @param { !blink_mojom_RendererPreferences } rendererPreferences
   * @param { !blink_mojom_RendererPreferenceWatcherPendingReceiver } preferenceWatcherReceiver
   * @param { !blink_mojom_WorkerContentSettingsProxyRemote } contentSettings
   * @param { ?blink_mojom_ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink_mojom_WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { ?blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink_mojom_PolicyContainer } policyContainer
   * @param { !blink_mojom_SharedWorkerHostRemote } host
   * @param { !blink_mojom_SharedWorkerPendingReceiver } sharedWorker
   * @param { !blink_mojom_BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !bigint } ukmSourceId
   * @param { !boolean } requireCrossSiteRequestForCookies
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } dipReportingObserverReceiver
   * @param { ?blink_mojom_NoiseToken } canvasNoiseToken
   * @param { !blink_mojom_CanvasNoiseTokenUpdaterPendingReceiver } canvasNoiseTokenObserver
   */

  createSharedWorker(info, token, constructorKey, origin, isConstructorSecureContext, userAgent, uaMetadata, pauseOnStart, devtoolsWorkerToken, rendererPreferences, preferenceWatcherReceiver, contentSettings, serviceWorkerContainerInfo, mainScriptLoadParams, subresourceLoaderFactories, controllerInfo, policyContainer, host, sharedWorker, browserInterfaceBroker, ukmSourceId, requireCrossSiteRequestForCookies, coepReportingObserverReceiver, dipReportingObserverReceiver, canvasNoiseToken, canvasNoiseTokenObserver) {}
}

/**
 * @implements { SharedWorkerFactoryInterface }
 */
export class SharedWorkerFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedWorkerFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedWorkerFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedWorkerFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_SharedWorkerInfo } info
   * @param { !blink_mojom_SharedWorkerToken } token
   * @param { !blink_mojom_StorageKey } constructorKey
   * @param { !url_mojom_Origin } origin
   * @param { !boolean } isConstructorSecureContext
   * @param { !string } userAgent
   * @param { !blink_mojom_UserAgentMetadata } uaMetadata
   * @param { !boolean } pauseOnStart
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsWorkerToken
   * @param { !blink_mojom_RendererPreferences } rendererPreferences
   * @param { !blink_mojom_RendererPreferenceWatcherPendingReceiver } preferenceWatcherReceiver
   * @param { !blink_mojom_WorkerContentSettingsProxyRemote } contentSettings
   * @param { ?blink_mojom_ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink_mojom_WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink_mojom_URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { ?blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink_mojom_PolicyContainer } policyContainer
   * @param { !blink_mojom_SharedWorkerHostRemote } host
   * @param { !blink_mojom_SharedWorkerPendingReceiver } sharedWorker
   * @param { !blink_mojom_BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !bigint } ukmSourceId
   * @param { !boolean } requireCrossSiteRequestForCookies
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink_mojom_ReportingObserverPendingReceiver } dipReportingObserverReceiver
   * @param { ?blink_mojom_NoiseToken } canvasNoiseToken
   * @param { !blink_mojom_CanvasNoiseTokenUpdaterPendingReceiver } canvasNoiseTokenObserver
   */

  createSharedWorker(
      info,
      token,
      constructorKey,
      origin,
      isConstructorSecureContext,
      userAgent,
      uaMetadata,
      pauseOnStart,
      devtoolsWorkerToken,
      rendererPreferences,
      preferenceWatcherReceiver,
      contentSettings,
      serviceWorkerContainerInfo,
      mainScriptLoadParams,
      subresourceLoaderFactories,
      controllerInfo,
      policyContainer,
      host,
      sharedWorker,
      browserInterfaceBroker,
      ukmSourceId,
      requireCrossSiteRequestForCookies,
      coepReportingObserverReceiver,
      dipReportingObserverReceiver,
      canvasNoiseToken,
      canvasNoiseTokenObserver) {
    this.proxy.sendMessage(
        0,
        SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        [
          info,
          token,
          constructorKey,
          origin,
          isConstructorSecureContext,
          userAgent,
          uaMetadata,
          pauseOnStart,
          devtoolsWorkerToken,
          rendererPreferences,
          preferenceWatcherReceiver,
          contentSettings,
          serviceWorkerContainerInfo,
          mainScriptLoadParams,
          subresourceLoaderFactories,
          controllerInfo,
          policyContainer,
          host,
          sharedWorker,
          browserInterfaceBroker,
          ukmSourceId,
          requireCrossSiteRequestForCookies,
          coepReportingObserverReceiver,
          dipReportingObserverReceiver,
          canvasNoiseToken,
          canvasNoiseTokenObserver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedWorkerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedWorkerFactoryReceiver {
  /**
   * @param {!SharedWorkerFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedWorkerFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedWorkerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        impl.createSharedWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedWorkerFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedWorkerFactoryRemote}
   */
  static getRemote() {
    let remote = new SharedWorkerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedWorkerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedWorkerFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedWorkerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSharedWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        this.createSharedWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerFactory_CreateSharedWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
    'SharedWorkerFactory_CreateSharedWorker_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink_mojom_SharedWorkerInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        blink_mojom_SharedWorkerTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'constructorKey', 16,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 24,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isConstructorSecureContext', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userAgent', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uaMetadata', 48,
        0,
        blink_mojom_UserAgentMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pauseOnStart', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 56,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rendererPreferences', 64,
        0,
        blink_mojom_RendererPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferenceWatcherReceiver', 36,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_RendererPreferenceWatcherPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSettings', 72,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_WorkerContentSettingsProxyRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerContainerInfo', 80,
        0,
        blink_mojom_ServiceWorkerContainerInfoForClientSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 88,
        0,
        blink_mojom_WorkerMainScriptLoadParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 96,
        0,
        blink_mojom_URLLoaderFactoryBundleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controllerInfo', 104,
        0,
        blink_mojom_ControllerServiceWorkerInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyContainer', 112,
        0,
        blink_mojom_PolicyContainerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 120,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_SharedWorkerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedWorker', 128,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_SharedWorkerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserInterfaceBroker', 132,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BrowserInterfaceBrokerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ukmSourceId', 144,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireCrossSiteRequestForCookies', 32,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'coepReportingObserverReceiver', 140,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dipReportingObserverReceiver', 152,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canvasNoiseToken', 160,
        0,
        blink_mojom_NoiseTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canvasNoiseTokenObserver', 156,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_CanvasNoiseTokenUpdaterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 176],]);



/**
 * @record
 */
export class SharedWorkerFactory_CreateSharedWorker_Params {
  constructor() {
    /** @type { !blink_mojom_SharedWorkerInfo } */
    this.info;
    /** @type { !blink_mojom_SharedWorkerToken } */
    this.token;
    /** @type { !blink_mojom_StorageKey } */
    this.constructorKey;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !boolean } */
    this.isConstructorSecureContext;
    /** @type { !string } */
    this.userAgent;
    /** @type { !blink_mojom_UserAgentMetadata } */
    this.uaMetadata;
    /** @type { !boolean } */
    this.pauseOnStart;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @type { !blink_mojom_RendererPreferences } */
    this.rendererPreferences;
    /** @type { !blink_mojom_RendererPreferenceWatcherPendingReceiver } */
    this.preferenceWatcherReceiver;
    /** @type { !blink_mojom_WorkerContentSettingsProxyRemote } */
    this.contentSettings;
    /** @type { (blink_mojom_ServiceWorkerContainerInfoForClient|undefined) } */
    this.serviceWorkerContainerInfo;
    /** @type { !blink_mojom_WorkerMainScriptLoadParams } */
    this.mainScriptLoadParams;
    /** @type { !blink_mojom_URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @type { (blink_mojom_ControllerServiceWorkerInfo|undefined) } */
    this.controllerInfo;
    /** @type { !blink_mojom_PolicyContainer } */
    this.policyContainer;
    /** @type { !blink_mojom_SharedWorkerHostRemote } */
    this.host;
    /** @type { !blink_mojom_SharedWorkerPendingReceiver } */
    this.sharedWorker;
    /** @type { !blink_mojom_BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @type { !bigint } */
    this.ukmSourceId;
    /** @type { !boolean } */
    this.requireCrossSiteRequestForCookies;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserverReceiver;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserverReceiver;
    /** @type { (blink_mojom_NoiseToken|undefined) } */
    this.canvasNoiseToken;
    /** @type { !blink_mojom_CanvasNoiseTokenUpdaterPendingReceiver } */
    this.canvasNoiseTokenObserver;
  }
}

