"use strict";
export class WorkerWrapper {
  #workerPromise;
  #disposed;
  #rejectWorkerPromise;
  constructor(workerLocation) {
    this.#workerPromise = new Promise((fulfill, reject) => {
      this.#rejectWorkerPromise = reject;
      const worker = new Worker(workerLocation, { type: "module" });
      worker.onerror = (event) => {
        console.error(`Failed to load worker for ${workerLocation.href}:`, event);
      };
      worker.onmessage = (event) => {
        console.assert(event.data === "workerReady");
        worker.onmessage = null;
        fulfill(worker);
      };
    });
  }
  static fromURL(url) {
    return new WorkerWrapper(url);
  }
  postMessage(message, transfer) {
    void this.#workerPromise.then((worker) => {
      if (!this.#disposed) {
        worker.postMessage(message, transfer ?? []);
      }
    });
  }
  dispose() {
    this.#disposed = true;
    void this.#workerPromise.then((worker) => worker.terminate());
  }
  terminate(immediately = false) {
    if (immediately) {
      this.#rejectWorkerPromise?.(new Error("Worker terminated"));
    }
    this.dispose();
  }
  set onmessage(listener) {
    void this.#workerPromise.then((worker) => {
      worker.onmessage = listener;
    });
  }
  set onerror(listener) {
    void this.#workerPromise.then((worker) => {
      worker.onerror = listener;
    });
  }
}
//# sourceMappingURL=Worker.js.map
