"use strict";
import * as Root from "../../core/root/root.js";
let builtInAiInstance;
let availability = "";
export class BuiltInAi {
  #consoleInsightsSession;
  static async isAvailable() {
    if (!Root.Runtime.hostConfig.devToolsAiPromptApi?.enabled) {
      return false;
    }
    availability = await window.LanguageModel.availability({ expectedOutputs: [{ type: "text", languages: ["en"] }] });
    return availability === "available";
  }
  static cachedIsAvailable() {
    return availability === "available";
  }
  constructor(consoleInsightsSession) {
    this.#consoleInsightsSession = consoleInsightsSession;
  }
  static async instance() {
    if (builtInAiInstance === void 0) {
      if (!await BuiltInAi.isAvailable()) {
        return void 0;
      }
      const consoleInsightsSession = await window.LanguageModel.create({
        initialPrompts: [{
          role: "system",
          content: `
You are an expert web developer. Your goal is to help a human web developer who
is using Chrome DevTools to debug a web site or web app. The Chrome DevTools
console is showing a message which is either an error or a warning. Please help
the user understand the problematic console message.

Your instructions are as follows:
  - Explain the reason why the error or warning is showing up.
  - The explanation has a maximum length of 200 characters. Anything beyond this
    length will be cut off. Make sure that your explanation is at most 200 characters long.
  - Your explanation should not end in the middle of a sentence.
  - Your explanation should consist of a single paragraph only. Do not include any
    headings or code blocks. Only write a single paragraph of text.
  - Your response should be concise and to the point. Avoid lengthy explanations
    or unnecessary details.
          `
        }],
        expectedInputs: [{
          type: "text",
          languages: ["en"]
        }],
        expectedOutputs: [{
          type: "text",
          languages: ["en"]
        }]
      });
      builtInAiInstance = new BuiltInAi(consoleInsightsSession);
    }
    return builtInAiInstance;
  }
  static removeInstance() {
    builtInAiInstance = void 0;
  }
  async *getConsoleInsight(prompt, abortController) {
    const session = await this.#consoleInsightsSession.clone();
    const stream = session.promptStreaming(prompt, {
      signal: abortController.signal
    });
    for await (const chunk of stream) {
      yield chunk;
    }
    session.destroy();
  }
}
//# sourceMappingURL=BuiltInAi.js.map
