"use strict";
import objectValueStyles from "../../ui/legacy/components/object_ui/objectValue.css.js";
import * as UI from "../../ui/legacy/legacy.js";
import accessibilityNodeStyles from "./accessibilityNode.css.js";
import accessibilityPropertiesStyles from "./accessibilityProperties.css.js";
export class AccessibilitySubPane extends UI.View.SimpleView {
  axNode;
  nodeInternal;
  constructor(options) {
    super(options);
    this.registerRequiredCSS(accessibilityPropertiesStyles);
    this.axNode = null;
  }
  setAXNode(_axNode) {
  }
  node() {
    return this.nodeInternal || null;
  }
  setNode(node) {
    this.nodeInternal = node;
  }
  createInfo(textContent, ...classNames) {
    const info = new UI.EmptyWidget.EmptyWidget(textContent);
    if (classNames.length === 0) {
      classNames.push("gray-info-message");
    }
    info.element.classList.add(...classNames, "info-message-overflow");
    return info;
  }
  createTreeOutline() {
    const treeOutline = new UI.TreeOutline.TreeOutlineInShadow();
    treeOutline.registerRequiredCSS(accessibilityNodeStyles, accessibilityPropertiesStyles, objectValueStyles);
    treeOutline.element.classList.add("hidden");
    treeOutline.setHideOverflow(true);
    this.element.appendChild(treeOutline.element);
    return treeOutline;
  }
}
//# sourceMappingURL=AccessibilitySubPane.js.map
