"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var _handleClickEvent;
import * as Lit from "../../../ui/lit/lit.js";
import controlButtonStyles from "./controlButton.css.js";
const { html, Decorators, LitElement } = Lit;
const { customElement, property } = Decorators;
export let ControlButton = class extends LitElement {
  constructor() {
    super();
    __privateAdd(this, _handleClickEvent, (event) => {
      if (this.disabled) {
        event.stopPropagation();
        event.preventDefault();
      }
    });
    this.label = "";
    this.shape = "square";
    this.disabled = false;
  }
  render() {
    return html`
            <style>${controlButtonStyles}</style>
            <button
                @click=${__privateGet(this, _handleClickEvent)}
                .disabled=${this.disabled}
                class="control">
              <div class="icon ${this.shape}"></div>
              <div class="label">${this.label}</div>
            </button>
        `;
  }
};
_handleClickEvent = new WeakMap();
__decorateClass([
  property()
], ControlButton.prototype, "label", 2);
__decorateClass([
  property()
], ControlButton.prototype, "shape", 2);
__decorateClass([
  property({ type: Boolean })
], ControlButton.prototype, "disabled", 2);
ControlButton = __decorateClass([
  customElement("devtools-control-button")
], ControlButton);
//# sourceMappingURL=ControlButton.js.map
