"use strict";
import "../../../ui/components/menus/menus.js";
import * as Platform from "../../../core/platform/platform.js";
import * as Buttons from "../../../ui/components/buttons/buttons.js";
import * as ComponentHelpers from "../../../ui/components/helpers/helpers.js";
import * as UI from "../../../ui/legacy/legacy.js";
import * as Lit from "../../../ui/lit/lit.js";
import * as VisualLogging from "../../../ui/visual_logging/visual_logging.js";
import * as Models from "../models/models.js";
import selectButtonStyles from "./selectButton.css.js";
const { html, Directives: { ifDefined, classMap } } = Lit;
export var Variant = /* @__PURE__ */ ((Variant2) => {
  Variant2["PRIMARY"] = "primary";
  Variant2["OUTLINED"] = "outlined";
  return Variant2;
})(Variant || {});
export class SelectButtonClickEvent extends Event {
  constructor(value) {
    super(SelectButtonClickEvent.eventName, { bubbles: true, composed: true });
    this.value = value;
  }
  static eventName = "selectbuttonclick";
}
export class SelectMenuSelectedEvent extends Event {
  constructor(value) {
    super(SelectMenuSelectedEvent.eventName, { bubbles: true, composed: true });
    this.value = value;
  }
  static eventName = "selectmenuselected";
}
export class SelectButton extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  #props = {
    disabled: false,
    value: "",
    items: [],
    buttonLabel: "",
    groups: [],
    variant: "primary" /* PRIMARY */
  };
  connectedCallback() {
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  get disabled() {
    return this.#props.disabled;
  }
  set disabled(disabled) {
    this.#props.disabled = disabled;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  get items() {
    return this.#props.items;
  }
  set items(items) {
    this.#props.items = items;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  set buttonLabel(buttonLabel) {
    this.#props.buttonLabel = buttonLabel;
  }
  set groups(groups) {
    this.#props.groups = groups;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  get value() {
    return this.#props.value;
  }
  set value(value) {
    this.#props.value = value;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  get variant() {
    return this.#props.variant;
  }
  set variant(variant) {
    this.#props.variant = variant;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  set action(value) {
    this.#props.action = value;
    void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
  }
  #handleClick(ev) {
    ev.stopPropagation();
    this.dispatchEvent(new SelectButtonClickEvent(this.#props.value));
  }
  #handleSelectMenuSelect(evt) {
    if (evt.target instanceof HTMLSelectElement) {
      this.dispatchEvent(new SelectMenuSelectedEvent(evt.target.value));
      void ComponentHelpers.ScheduledRender.scheduleRender(this, this.#render);
    }
  }
  #renderSelectItem(item, selectedItem) {
    const selected = item.value === selectedItem.value;
    return html`
      <option
      .title=${item.label()}
      value=${item.value}
      ?selected=${selected}
      jslog=${VisualLogging.item(Platform.StringUtilities.toKebabCase(item.value)).track({ click: true })}
      >${selected && item.buttonLabel ? item.buttonLabel() : item.label()}</option>
    `;
  }
  #renderSelectGroup(group, selectedItem) {
    return html`
      <optgroup label=${group.name}>
        ${group.items.map((item) => this.#renderSelectItem(item, selectedItem))}
      </optgroup>
    `;
  }
  #getTitle(label) {
    return this.#props.action ? Models.Tooltip.getTooltipForActions(label, this.#props.action) : "";
  }
  #render = () => {
    const hasGroups = Boolean(this.#props.groups.length);
    const items = hasGroups ? this.#props.groups.flatMap((group) => group.items) : this.#props.items;
    const selectedItem = items.find((item) => item.value === this.#props.value) || items[0];
    if (!selectedItem) {
      return;
    }
    const classes = {
      primary: this.#props.variant === "primary" /* PRIMARY */,
      secondary: this.#props.variant === "outlined" /* OUTLINED */
    };
    const buttonVariant = this.#props.variant === "outlined" /* OUTLINED */ ? Buttons.Button.Variant.OUTLINED : Buttons.Button.Variant.PRIMARY;
    const menuLabel = selectedItem.buttonLabel ? selectedItem.buttonLabel() : selectedItem.label();
    Lit.render(
      html` <style>
          ${UI.inspectorCommonStyles}
        </style>
        <style>
          ${selectButtonStyles}
        </style>
        <div
          class="select-button"
          title=${ifDefined(this.#getTitle(menuLabel))}
        >
          <label>
            ${this.#props.groups.length > 1 ? html`
                  <div
                    class="groups-label"
                    >${this.#props.groups.map((group) => {
        return group.name;
      }).join(" & ")}</div>` : Lit.nothing}
            <select
              class=${classMap(classes)}
              ?disabled=${this.#props.disabled}
              jslog=${VisualLogging.dropDown("network-conditions").track({
        change: true
      })}
              @change=${this.#handleSelectMenuSelect}
            >
              ${hasGroups ? this.#props.groups.map(
        (group) => this.#renderSelectGroup(group, selectedItem)
      ) : this.#props.items.map(
        (item) => this.#renderSelectItem(item, selectedItem)
      )}
            </select>
          </label>
          ${selectedItem ? html` <devtools-button
                .disabled=${this.#props.disabled}
                .variant=${buttonVariant}
                .iconName=${selectedItem.buttonIconName}
                @click=${this.#handleClick}
              >
                ${this.#props.buttonLabel}
              </devtools-button>` : ""}
        </div>`,
      this.#shadow,
      { host: this }
    );
  };
}
customElements.define(
  "devtools-select-button",
  SelectButton
);
//# sourceMappingURL=SelectButton.js.map
