// gen/third_party/devtools-frontend/src/front_end/third_party/third-party-web/lib/nostats-subset.js
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var require_create_entity_finder_api = __commonJS({
  "package/lib/create-entity-finder-api.js"(exports, module) {
    "use strict";
    var DOMAIN_IN_URL_REGEX = /:\/\/(\S*?)(:\d+)?(\/|$)/;
    var DOMAIN_CHARACTERS = /([a-z0-9.-]+\.[a-z0-9]+|localhost)/i;
    var IP_REGEX = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    var ROOT_DOMAIN_REGEX = /[^.]+\.([^.]+|(gov|com|co|ne)\.\w{2})$/i;
    function getDomainFromOriginOrURL(originOrURL) {
      if (typeof originOrURL !== "string") return null;
      if (originOrURL.length > 1e4 || originOrURL.startsWith("data:")) return null;
      if (DOMAIN_IN_URL_REGEX.test(originOrURL)) return originOrURL.match(DOMAIN_IN_URL_REGEX)[1];
      if (DOMAIN_CHARACTERS.test(originOrURL)) return originOrURL.match(DOMAIN_CHARACTERS)[0];
      return null;
    }
    function getRootDomain(originOrURL) {
      const domain = getDomainFromOriginOrURL(originOrURL);
      if (!domain) return null;
      if (IP_REGEX.test(domain)) return domain;
      const match = domain.match(ROOT_DOMAIN_REGEX);
      return match && match[0] || domain;
    }
    function sliceSubdomainFromDomain(domain, rootDomain) {
      if (domain.length <= rootDomain.length) return domain;
      return domain.split(".").slice(1).join(".");
    }
    function getEntityInDataset(entityByDomain, entityBySubDomain, entityByRootDomain, originOrURL) {
      const domain = getDomainFromOriginOrURL(originOrURL);
      const rootDomain = getRootDomain(domain);
      if (!domain || !rootDomain) return void 0;
      if (entityByDomain.has(domain)) return entityByDomain.get(domain);
      for (let subdomain = domain; subdomain.length > rootDomain.length; subdomain = sliceSubdomainFromDomain(subdomain, rootDomain)) {
        if (entityBySubDomain.has(subdomain)) return entityBySubDomain.get(subdomain);
      }
      if (entityByRootDomain.has(rootDomain)) return entityByRootDomain.get(rootDomain);
      return void 0;
    }
    function getProductInDataset(entityByDomain, entityBySubDomain, entityByRootDomain, originOrURL) {
      const entity = getEntityInDataset(
        entityByDomain,
        entityBySubDomain,
        entityByRootDomain,
        originOrURL
      );
      const products = entity && entity.products;
      if (!products) return void 0;
      if (typeof originOrURL !== "string") return void 0;
      for (const product of products) {
        for (const pattern of product.urlPatterns) {
          if (pattern instanceof RegExp && pattern.test(originOrURL)) return product;
          if (typeof pattern === "string" && originOrURL.includes(pattern)) return product;
        }
      }
      return void 0;
    }
    function cloneEntities(entities) {
      return entities.map((entity_) => {
        const entity = {
          company: entity_.name,
          categories: [entity_.category],
          ...entity_
        };
        const products = (entity_.products || []).map((product) => ({
          company: entity.company,
          category: entity.category,
          categories: [entity.category],
          facades: [],
          ...product,
          urlPatterns: (product.urlPatterns || []).map(
            (s) => s.startsWith("REGEXP:") ? new RegExp(s.slice("REGEXP:".length)) : s
          )
        }));
        entity.products = products;
        return entity;
      });
    }
    function createAPIFromDataset(entities_) {
      const entities = cloneEntities(entities_);
      const entityByDomain = /* @__PURE__ */ new Map();
      const entityByRootDomain = /* @__PURE__ */ new Map();
      const entityBySubDomain = /* @__PURE__ */ new Map();
      for (const entity of entities) {
        entity.totalExecutionTime = Number(entity.totalExecutionTime) || 0;
        entity.totalOccurrences = Number(entity.totalOccurrences) || 0;
        entity.averageExecutionTime = entity.totalExecutionTime / entity.totalOccurrences;
        for (const domain of entity.domains) {
          if (entityByDomain.has(domain)) {
            const duplicate = entityByDomain.get(domain);
            throw new Error(`Duplicate domain ${domain} (${entity.name} and ${duplicate.name})`);
          }
          entityByDomain.set(domain, entity);
          const rootDomain = getRootDomain(domain);
          if (domain.startsWith("*.")) {
            const wildcardDomain = domain.slice(2);
            if (wildcardDomain === rootDomain) entityByRootDomain.set(rootDomain, entity);
            else entityBySubDomain.set(wildcardDomain, entity);
          }
        }
      }
      for (const [rootDomain, entity] of entityByRootDomain.entries()) {
        if (!entity) entityByRootDomain.delete(rootDomain);
      }
      const getEntity = getEntityInDataset.bind(
        null,
        entityByDomain,
        entityBySubDomain,
        entityByRootDomain
      );
      const getProduct = getProductInDataset.bind(
        null,
        entityByDomain,
        entityBySubDomain,
        entityByRootDomain
      );
      return { getEntity, getProduct, getRootDomain, entities };
    }
    module.exports = { createAPIFromDataset };
  }
});
var require_entities_nostats = __commonJS({
  "package/dist/entities-nostats.json"(exports, module) {
    module.exports = [{ name: "Google/Doubleclick Ads", company: "Google", homepage: "https://marketingplatform.google.com/about/enterprise/", category: "ad", domains: ["adservice.google.com", "adservice.google.com.au", "adservice.google.com.sg", "adservice.google.com.br", "adservice.google.com.ua", "adservice.google.co.uk", "adservice.google.co.jp", "adservice.google.co.in", "adservice.google.co.kr", "adservice.google.co.id", "adservice.google.co.nz", "adservice.google.ie", "adservice.google.se", "adservice.google.de", "adservice.google.ca", "adservice.google.be", "adservice.google.es", "adservice.google.ch", "adservice.google.fr", "adservice.google.nl", "*.googleadservices.com", "*.googlesyndication.com", "*.googletagservices.com", "*.2mdn.net", "*.doubleclick.net"] }, { name: "Facebook", homepage: "https://www.facebook.com", category: "social", domains: ["*.facebook.com", "*.atlassbx.com", "*.fbsbx.com", "fbcdn-photos-e-a.akamaihd.net", "*.facebook.net", "*.fbcdn.net"], products: [{ name: "Facebook Messenger Customer Chat", urlPatterns: ["REGEXP:connect\\.facebook\\.net\\/.*\\/sdk\\/xfbml\\.customerchat\\.js"], facades: [{ name: "React Live Chat Loader", repo: "https://github.com/calibreapp/react-live-chat-loader" }] }] }, { name: "Instagram", homepage: "https://www.instagram.com", category: "social", domains: ["*.cdninstagram.com", "*.instagram.com"] }, { name: "Google CDN", company: "Google", homepage: "https://developers.google.com/speed/libraries/", category: "cdn", domains: ["ajax.googleapis.com", "commondatastorage.googleapis.com", "www.gstatic.com", "ssl.gstatic.com"] }, { name: "Google Maps", company: "Google", homepage: "https://www.google.com/maps", category: "utility", domains: ["maps.google.com", "maps-api-ssl.google.com", "maps.googleapis.com", "mts.googleapis.com", "mt.googleapis.com", "mt0.googleapis.com", "mt1.googleapis.com", "mt2.googleapis.com", "mt3.googleapis.com", "khm0.googleapis.com", "khm1.googleapis.com", "khms.googleapis.com", "khms1.googleapis.com", "khms2.googleapis.com", "maps.gstatic.com"] }, { name: "Other Google APIs/SDKs", company: "Google", homepage: "https://developers.google.com/apis-explorer/#p/", category: "utility", domains: ["accounts.google.com", "apis.google.com", "calendar.google.com", "clients2.google.com", "cse.google.com", "news.google.com", "pay.google.com", "payments.google.com", "play.google.com", "smartlock.google.com", "www.google.com", "www.google.de", "www.google.co.jp", "www.google.com.au", "www.google.co.uk", "www.google.ie", "www.google.com.sg", "www.google.co.in", "www.google.com.br", "www.google.ca", "www.google.co.kr", "www.google.co.nz", "www.google.co.id", "www.google.fr", "www.google.be", "www.google.com.ua", "www.google.nl", "www.google.ru", "www.google.se", "www.googleapis.com", "imasdk.googleapis.com", "storage.googleapis.com", "translate.googleapis.com", "translate.google.com", "translate-pa.googleapis.com", "lh3.googleusercontent.com", "jnn-pa.googleapis.com", "csi.gstatic.com"] }, { name: "Firebase", homepage: "https://developers.google.com/apis-explorer/#p/", category: "utility", domains: ["firebasestorage.googleapis.com", "firestore.googleapis.com", "firebaseinstallations.googleapis.com", "firebase.googleapis.com", "firebaseremoteconfig.googleapis.com"] }, { name: "Google Analytics", company: "Google", homepage: "https://marketingplatform.google.com/about/analytics/", category: "analytics", domains: ["*.google-analytics.com", "*.urchin.com", "analytics.google.com"] }, { name: "Google Optimize", company: "Google", homepage: "https://marketingplatform.google.com/about/optimize/", category: "analytics", domains: ["www.googleoptimize.com"] }, { name: "Google AMP", company: "Google", homepage: "https://github.com/google/amp-client-id-library", category: "analytics", domains: ["ampcid.google.com"] }, { name: "Google Tag Manager", company: "Google", homepage: "https://marketingplatform.google.com/about/tag-manager/", category: "tag-manager", domains: ["*.googletagmanager.com"] }, { name: "Google Fonts", company: "Google", homepage: "https://fonts.google.com/", category: "cdn", domains: ["fonts.googleapis.com", "fonts.gstatic.com"] }, { name: "Adobe TypeKit", company: "Adobe", homepage: "https://fonts.adobe.com/", category: "cdn", domains: ["*.typekit.com", "*.typekit.net"] }, { name: "YouTube", homepage: "https://youtube.com", category: "video", domains: ["*.youtube.com", "*.ggpht.com", "*.youtube-nocookie.com", "*.ytimg.com"], products: [{ name: "YouTube Embedded Player", urlPatterns: ["youtube.com/embed/"], facades: [{ name: "Lite YouTube", repo: "https://github.com/paulirish/lite-youtube-embed" }, { name: "Ngx Lite Video", repo: "https://github.com/karim-mamdouh/ngx-lite-video" }] }] }, { name: "Twitter", homepage: "https://twitter.com", category: "social", domains: ["*.vine.co", "*.twimg.com", "*.twitpic.com", "platform.twitter.com", "syndication.twitter.com"] }, { name: "AddThis", homepage: "https://www.addthis.com/", category: "social", domains: ["*.addthis.com", "*.addthiscdn.com", "*.addthisedge.com"] }, { name: "AddToAny", homepage: "https://www.addtoany.com/", category: "social", domains: ["*.addtoany.com"] }, { name: "Akamai", homepage: "https://www.akamai.com/", category: "cdn", domains: ["23.62.3.183", "*.akamaitechnologies.com", "*.akamaitechnologies.fr", "*.akamai.net", "*.akamaiedge.net", "*.akamaihd.net", "*.akamaized.net", "*.edgefcs.net", "*.edgekey.net", "edgesuite.net", "*.srip.net"] }, { name: "Blogger", homepage: "https://www.blogger.com/", category: "hosting", domains: ["*.blogblog.com", "*.blogger.com", "*.blogspot.com", "images-blogger-opensocial.googleusercontent.com"] }, { name: "Gravatar", homepage: "https://en.gravatar.com/", category: "social", domains: ["*.gravatar.com"] }, { name: "Yandex Metrica", company: "Yandex", homepage: "https://metrica.yandex.com/about?", category: "analytics", domains: ["mc.yandex.ru", "mc.yandex.com", "d31j93rd8oukbv.cloudfront.net"] }, { name: "Hotjar", homepage: "https://www.hotjar.com/", category: "analytics", domains: ["*.hotjar.com", "*.hotjar.io"] }, { name: "Baidu Analytics", homepage: "https://tongji.baidu.com/web/welcome/login", category: "analytics", domains: ["hm.baidu.com", "hmcdn.baidu.com"] }, { name: "Insider", homepage: "", category: "analytics", domains: ["*.useinsider.com"] }, { name: "Adobe Experience Cloud", company: "Adobe", homepage: "", category: "analytics", domains: ["*.2o7.net", "du8783wkf05yr.cloudfront.net", "*.hitbox.com", "*.imageg.net", "*.nedstat.com", "*.omtrdc.net"] }, { name: "Adobe Tag Manager", company: "Adobe", homepage: "https://www.adobe.com/experience-platform/", category: "tag-manager", domains: ["*.adobedtm.com", "*.demdex.net", "*.everesttech.net", "sstats.adobe.com", "hbrt.adobe.com"] }, { name: "jQuery CDN", homepage: "https://code.jquery.com/", category: "cdn", domains: ["*.jquery.com"] }, { name: "Cloudflare CDN", homepage: "https://cdnjs.com/", category: "cdn", domains: ["cdnjs.cloudflare.com", "amp.cloudflare.com"] }, { name: "Cloudflare", homepage: "https://www.cloudflare.com/website-optimization/", category: "utility", domains: ["ajax.cloudflare.com", "*.nel.cloudflare.com", "static.cloudflareinsights.com"] }, { name: "WordPress", company: "Automattic", homepage: "https://wp.com/", category: "hosting", domains: ["*.wordpress.com", "s0.wp.com", "s2.wp.com", "*.w.org", "c0.wp.com", "s1.wp.com", "i0.wp.com", "i1.wp.com", "i2.wp.com", "widgets.wp.com"] }, { name: "WordPress Site Stats", company: "Automattic", homepage: "https://wp.com/", category: "analytics", domains: ["pixel.wp.com", "stats.wp.com"] }, { name: "Hatena Blog", homepage: "https://hatenablog.com/", category: "hosting", domains: ["*.st-hatena.com", "*.hatena.ne.jp"] }, { name: "Shopify", homepage: "https://www.shopify.com/", category: "hosting", domains: ["*.shopify.com", "*.shopifyapps.com", "*.shopifycdn.com", "*.shopifysvc.com"] }, { name: "Dealer", homepage: "https://www.dealer.com/", category: "hosting", domains: ["*.dealer.com"] }, { name: "PIXNET", homepage: "https://www.pixnet.net/", category: "social", domains: ["*.pixfs.net", "*.pixnet.net"] }, { name: "Moat", homepage: "https://moat.com/", category: "ad", domains: ["*.moatads.com", "*.moatpixel.com"] }, { name: "33 Across", homepage: "https://33across.com/", category: "ad", domains: ["*.33across.com"] }, { name: "OpenX", homepage: "https://www.openx.com/", category: "ad", domains: ["*.deliverimp.com", "*.openxadexchange.com", "*.servedbyopenx.com", "*.jump-time.net", "*.openx.net", "*.openxcdn.net"] }, { name: "Amazon Ads", homepage: "https://ad.amazon.com/", category: "ad", domains: ["*.amazon-adsystem.com"] }, { name: "Rubicon Project", homepage: "https://rubiconproject.com/", category: "ad", domains: ["*.rubiconproject.com", "*.chango.com", "*.fimserve.com"] }, { name: "The Trade Desk", homepage: "https://www.thetradedesk.com/", category: "ad", domains: ["*.adsrvr.org", "d1eoo1tco6rr5e.cloudfront.net"] }, { name: "Bidswitch", homepage: "https://www.bidswitch.com/", category: "ad", domains: ["*.bidswitch.net"] }, { name: "LiveRamp IdentityLink", homepage: "https://liveramp.com/discover-identitylink/", category: "analytics", domains: ["*.circulate.com", "*.rlcdn.com"] }, { name: "Drawbridge", homepage: "https://www.drawbridge.com/", category: "ad", domains: ["*.adsymptotic.com"] }, { name: "AOL / Oath / Verizon Media", homepage: "https://www.oath.com/", category: "ad", domains: ["*.advertising.com", "*.aol.com", "*.aolcdn.com", "*.blogsmithmedia.com", "*.oath.com", "*.aol.net", "*.tacoda.net", "*.aol.co.uk"] }, { name: "Xaxis", homepage: "https://www.xaxis.com/", category: "ad", domains: ["*.247realmedia.com", "*.mookie1.com", "*.gmads.net"] }, { name: "Freshdesk", company: "Freshworks", homepage: "https://freshdesk.com/", category: "customer-success", domains: ["d36mpcpuzc4ztk.cloudfront.net"] }, { name: "Help Scout", homepage: "https://www.helpscout.net/", category: "customer-success", domains: ["djtflbt20bdde.cloudfront.net", "*.helpscout.net"], products: [{ name: "Help Scout Beacon", urlPatterns: ["beacon-v2.helpscout.net"], facades: [{ name: "React Live Chat Loader", repo: "https://github.com/calibreapp/react-live-chat-loader" }] }] }, { name: "Alexa", homepage: "https://www.alexa.com/", category: "analytics", domains: ["*.alexametrics.com", "d31qbv1cthcecs.cloudfront.net"] }, { name: "OneSignal", homepage: "https://onesignal.com/", category: "utility", domains: ["*.onesignal.com"] }, { name: "Lucky Orange", homepage: "https://www.luckyorange.com/", category: "analytics", domains: ["*.luckyorange.com", "d10lpsik1i8c69.cloudfront.net", "*.luckyorange.net"] }, { name: "Crazy Egg", homepage: "https://www.crazyegg.com/", category: "analytics", domains: ["*.cetrk.com", "*.crazyegg.com", "dnn506yrbagrg.cloudfront.net"] }, { name: "Hello Bar", homepage: "https://www.hellobar.com/", category: "marketing", domains: ["*.hellobar.com"] }, { name: "Yandex Ads", company: "Yandex", homepage: "https://yandex.com/adv/", category: "ad", domains: ["an.yandex.ru"] }, { name: "Salesforce", homepage: "https://www.salesforce.com/products/marketing-cloud/", category: "analytics", domains: ["*.krxd.net"] }, { name: "Salesforce Commerce Cloud", homepage: "https://www.salesforce.com/products/commerce-cloud/overview/", category: "hosting", domains: ["*.cquotient.com", "*.demandware.net", "demandware.edgesuite.net"] }, { name: "Optimizely", homepage: "https://www.optimizely.com/", category: "analytics", domains: ["*.optimizely.com"] }, { name: "LiveChat", homepage: "https://www.livechat.com/", category: "customer-success", domains: ["*.livechatinc.com", "*.livechat.com", "*.livechat-static.com"] }, { name: "VK", homepage: "https://vk.com/", category: "social", domains: ["*.vk.com"] }, { name: "Tumblr", homepage: "https://tumblr.com/", category: "social", domains: ["*.tumblr.com"] }, { name: "Wistia", homepage: "https://wistia.com/", category: "video", domains: ["*.wistia.com", "embedwistia-a.akamaihd.net", "*.wistia.net"] }, { name: "Brightcove", homepage: "https://www.brightcove.com/en/", category: "video", domains: ["*.brightcove.com", "*.brightcove.net", "*.zencdn.net"] }, { name: "JSDelivr CDN", homepage: "https://www.jsdelivr.com/", category: "cdn", domains: ["*.jsdelivr.net"] }, { name: "Sumo", homepage: "https://sumo.com/", category: "marketing", domains: ["*.sumo.com", "*.sumome.com", "sumo.b-cdn.net"] }, { name: "Vimeo", homepage: "https://vimeo.com/", category: "video", domains: ["*.vimeo.com", "*.vimeocdn.com"], products: [{ name: "Vimeo Embedded Player", urlPatterns: ["player.vimeo.com/video/"], facades: [{ name: "Lite Vimeo", repo: "https://github.com/slightlyoff/lite-vimeo" }, { name: "Lite Vimeo Embed", repo: "https://github.com/luwes/lite-vimeo-embed" }, { name: "Ngx Lite Video", repo: "https://github.com/karim-mamdouh/ngx-lite-video" }] }] }, { name: "Disqus", homepage: "https://disqus.com/", category: "social", domains: ["*.disqus.com", "*.disquscdn.com"] }, { name: "Yandex APIs", company: "Yandex", homepage: "https://yandex.ru/", category: "utility", domains: ["api-maps.yandex.ru", "money.yandex.ru"] }, { name: "Yandex CDN", company: "Yandex", homepage: "https://yandex.ru/", category: "cdn", domains: ["*.yandex.st", "*.yastatic.net"] }, { name: "Integral Ad Science", homepage: "https://integralads.com/uk/", category: "ad", domains: ["*.adsafeprotected.com", "*.iasds01.com"] }, { name: "Tealium", homepage: "https://tealium.com/", category: "tag-manager", domains: ["*.aniview.com", "*.delvenetworks.com", "*.limelight.com", "*.tiqcdn.com", "*.llnwd.net", "*.tealiumiq.com"] }, { name: "Pubmatic", homepage: "https://pubmatic.com/", category: "ad", domains: ["*.pubmatic.com"] }, { name: "Olark", homepage: "https://www.olark.com/", category: "customer-success", domains: ["*.olark.com"] }, { name: "Tawk.to", homepage: "https://www.tawk.to/", category: "customer-success", domains: ["*.tawk.to"] }, { name: "OptinMonster", homepage: "https://optinmonster.com/", category: "marketing", domains: ["*.opmnstr.com", "*.optmnstr.com", "*.optmstr.com"] }, { name: "ZenDesk", homepage: "https://zendesk.com/", category: "customer-success", domains: ["*.zdassets.com", "*.zendesk.com", "*.zopim.com"] }, { name: "Pusher", homepage: "https://pusher.com/", category: "utility", domains: ["*.pusher.com", "*.pusherapp.com"] }, { name: "Drift", homepage: "https://www.drift.com/", category: "marketing", domains: ["*.drift.com", "*.driftt.com"], products: [{ name: "Drift Live Chat", urlPatterns: ["REGEXP:js\\.driftt\\.com\\/include\\/.*\\/.*\\.js"], facades: [{ name: "React Live Chat Loader", repo: "https://github.com/calibreapp/react-live-chat-loader" }] }] }, { name: "Sentry", homepage: "https://sentry.io/", category: "utility", domains: ["*.getsentry.com", "*.ravenjs.com", "*.sentry-cdn.com", "*.sentry.io"] }, { name: "Amazon Web Services", homepage: "https://aws.amazon.com/s3/", category: "other", domains: ["*.amazon.com", "*.amazonaws.com", "*.amazonwebapps.com", "*.amazonwebservices.com", "*.elasticbeanstalk.com", "*.images-amazon.com", "*.amazon.co.uk"] }, { name: "Amazon Pay", homepage: "https://pay.amazon.com", category: "utility", domains: ["payments.amazon.com", "*.payments-amazon.com"] }, { name: "Media.net", homepage: "https://www.media.net/", category: "ad", domains: ["*.media.net", "*.mnet-ad.net"] }, { name: "Yahoo!", homepage: "https://www.yahoo.com/", category: "ad", domains: ["*.bluelithium.com", "*.hostingprod.com", "*.lexity.com", "*.yahoo.com", "*.yahooapis.com", "*.yimg.com", "*.zenfs.com", "*.yahoo.net"] }, { name: "Adroll", homepage: "https://www.adroll.com/", category: "ad", domains: ["*.adroll.com"] }, { name: "Twitch", homepage: "https://twitch.tv/", category: "video", domains: ["*.twitch.tv"] }, { name: "Taboola", homepage: "https://www.taboola.com/", category: "ad", domains: ["*.taboola.com", "*.taboolasyndication.com"] }, { name: "Sizmek", homepage: "https://www.sizmek.com/", category: "ad", domains: ["*.serving-sys.com", "*.peer39.net"] }, { name: "Scorecard Research", homepage: "https://www.scorecardresearch.com/", category: "ad", domains: ["*.scorecardresearch.com"] }, { name: "Criteo", homepage: "https://www.criteo.com/", category: "ad", domains: ["*.criteo.com", "*.emailretargeting.com", "*.criteo.net"] }, { name: "Segment", homepage: "https://segment.com/", category: "analytics", domains: ["*.segment.com", "*.segment.io"] }, { name: "ShareThis", homepage: "https://www.sharethis.com/", category: "social", domains: ["*.sharethis.com"] }, { name: "Distil Networks", homepage: "https://www.distilnetworks.com/", category: "utility", domains: ["*.areyouahuman.com"] }, { name: "Connexity", homepage: "https://connexity.com/", category: "analytics", domains: ["*.connexity.net"] }, { name: "Popads", homepage: "https://www.popads.net/", category: "ad", domains: ["*.popads.net"] }, { name: "CreateJS CDN", homepage: "https://code.createjs.com/", category: "cdn", domains: ["*.createjs.com"] }, { name: "Squarespace", homepage: "https://www.squarespace.com/", category: "hosting", domains: ["*.squarespace.com"] }, { name: "Media Math", homepage: "https://www.mediamath.com/", category: "ad", domains: ["*.mathads.com", "*.mathtag.com"] }, { name: "Mixpanel", homepage: "https://mixpanel.com/", category: "analytics", domains: ["*.mixpanel.com", "*.mxpnl.com"] }, { name: "FontAwesome CDN", homepage: "https://fontawesome.com/", category: "cdn", domains: ["*.fontawesome.com"] }, { name: "Hubspot", homepage: "https://hubspot.com/", category: "marketing", domains: ["*.hs-scripts.com", "*.hubspot.com", "*.leadin.com", "*.hs-analytics.net", "*.hscollectedforms.net", "*.hscta.net", "*.hsforms.net", "*.hsleadflows.net", "*.hsstatic.net", "*.hubspot.net", "*.hsforms.com", "*.hs-banner.com", "*.hs-embed-reporting.com", "*.hs-growth-metrics.com", "*.hs-data.com", "*.hsadspixel.net", "*.hubapi.com"] }, { name: "Mailchimp", homepage: "https://mailchimp.com/", category: "marketing", domains: ["*.chimpstatic.com", "*.list-manage.com", "*.mailchimp.com"] }, { name: "MGID", homepage: "https://www.mgid.com/", category: "ad", domains: ["*.mgid.com", "*.dt07.net"] }, { name: "Stripe", homepage: "https://stripe.com", category: "utility", domains: ["*.stripe.com", "*.stripecdn.com", "*.stripe.network"] }, { name: "PayPal", homepage: "https://paypal.com", category: "utility", domains: ["*.paypal.com", "*.paypalobjects.com"] }, { name: "Market GID", homepage: "https://www.marketgid.com/", category: "ad", domains: ["*.marketgid.com"] }, { name: "Pinterest", homepage: "https://pinterest.com/", category: "social", domains: ["*.pinimg.com", "*.pinterest.com"] }, { name: "New Relic", homepage: "https://newrelic.com/", category: "utility", domains: ["*.newrelic.com", "*.nr-data.net"] }, { name: "AppDynamics", homepage: "https://www.appdynamics.com/", category: "utility", domains: ["*.appdynamics.com", "*.eum-appdynamics.com", "d3tjaysgumg9lf.cloudfront.net"] }, { name: "Parking Crew", homepage: "https://parkingcrew.net/", category: "other", domains: ["d1lxhc4jvstzrp.cloudfront.net", "*.parkingcrew.net"] }, { name: "WordAds", company: "Automattic", homepage: "https://wordads.co/", category: "ad", domains: ["*.pubmine.com"] }, { name: "AppNexus", homepage: "https://www.appnexus.com/", category: "ad", domains: ["*.adnxs.com", "*.ctasnet.com", "*.adrdgt.com"] }, { name: "Histats", homepage: "https://www.histats.com/", category: "analytics", domains: ["*.histats.com"] }, { name: "DoubleVerify", homepage: "https://www.doubleverify.com/", category: "ad", domains: ["*.doubleverify.com", "*.dvtps.com", "*.iqfp1.com"] }, { name: "Mediavine", homepage: "https://www.mediavine.com/", category: "ad", domains: ["*.mediavine.com"] }, { name: "Wix", homepage: "https://www.wix.com/", category: "hosting", domains: ["*.parastorage.com", "*.wix.com", "*.wixstatic.com", "*.wixapps.net"] }, { name: "Webflow", homepage: "https://webflow.com/", category: "hosting", domains: ["*.uploads-ssl.webflow.com", "*.assets-global.website-files.com", "*.assets.website-files.com"] }, { name: "Weebly", homepage: "https://www.weebly.com/", category: "hosting", domains: ["*.editmysite.com"] }, { name: "LinkedIn", homepage: "https://www.linkedin.com/", category: "social", domains: ["*.bizographics.com", "platform.linkedin.com", "*.slideshare.com", "*.slidesharecdn.com", "*.oribi.io"] }, { name: "LinkedIn Ads", category: "ad", domains: ["*.licdn.com", "*.ads.linkedin.com", "ads.linkedin.com", "www.linkedin.com"] }, { name: "Vox Media", homepage: "https://www.voxmedia.com/", category: "content", domains: ["*.vox-cdn.com", "*.voxmedia.com"] }, { name: "Hotmart", homepage: "https://www.hotmart.com/", category: "content", domains: ["*.hotmart.com"] }, { name: "SoundCloud", homepage: "https://www.soundcloud.com/", category: "content", domains: ["*.sndcdn.com", "*.soundcloud.com", "*.stratus.sc"] }, { name: "Spotify", homepage: "https://www.spotify.com/", category: "content", domains: ["*.scdn.co", "*.spotify.com"] }, { name: "AMP", homepage: "https://amp.dev/", category: "content", domains: ["*.ampproject.org"] }, { name: "Beeketing", homepage: "https://beeketing.com/", category: "marketing", domains: ["*.beeketing.com"] }, { name: "Albacross", homepage: "https://albacross.com/", category: "marketing", domains: ["*.albacross.com"] }, { name: "TrafficJunky", homepage: "https://www.trafficjunky.com/", category: "ad", domains: ["*.contentabc.com", "*.trafficjunky.net"] }, { name: "Bootstrap CDN", homepage: "https://www.bootstrapcdn.com/", category: "cdn", domains: ["*.bootstrapcdn.com"] }, { name: "Shareaholic", homepage: "https://www.shareaholic.com/", category: "social", domains: ["*.shareaholic.com", "dsms0mj1bbhn4.cloudfront.net"] }, { name: "Snowplow", homepage: "https://snowplowanalytics.com/", category: "analytics", domains: ["d32hwlnfiv2gyn.cloudfront.net"] }, { name: "RD Station", homepage: "https://www.rdstation.com/en/", category: "marketing", domains: ["d335luupugsy2.cloudfront.net"] }, { name: "Jivochat", homepage: "https://www.jivochat.com/", category: "customer-success", domains: ["*.jivosite.com"] }, { name: "Listrak", homepage: "https://www.listrak.com/", category: "marketing", domains: ["*.listrak.com", "*.listrakbi.com"] }, { name: "Ontame", homepage: "https://www.ontame.io", category: "analytics", domains: ["*.ontame.io"] }, { name: "Ipify", homepage: "https://www.ipify.org", category: "utility", domains: ["*.ipify.org"] }, { name: "Ensighten", homepage: "https://www.ensighten.com/", category: "tag-manager", domains: ["*.ensighten.com"] }, { name: "EpiServer", homepage: "https://www.episerver.com", category: "content", domains: ["*.episerver.net"] }, { name: "mPulse", homepage: "https://developer.akamai.com/akamai-mpulse", category: "analytics", domains: ["*.akstat.io", "*.go-mpulse.net", "*.mpulse.net", "*.mpstat.us"] }, { name: "Pingdom RUM", homepage: "https://www.pingdom.com/product/performance-monitoring/", category: "analytics", domains: ["*.pingdom.net"] }, { name: "SpeedCurve RUM", company: "SpeedCurve", homepage: "https://www.speedcurve.com/features/performance-monitoring/", category: "analytics", domains: ["*.speedcurve.com"] }, { name: "Radar", company: "Cedexis", homepage: "https://www.cedexis.com/radar/", category: "analytics", domains: ["*.cedexis-test.com", "*.cedexis.com", "*.cmdolb.com", "cedexis.leasewebcdn.com", "*.cedexis-radar.net", "*.cedexis.net", "cedexis-test01.insnw.net", "cedexisakamaitest.azureedge.net", "cedexispub.cdnetworks.net", "cs600.wac.alphacdn.net", "cs600.wpc.edgecastdns.net", "global2.cmdolb.com", "img-cedexis.mncdn.com", "a-cedexis.msedge.net", "zn3vgszfh.fastestcdn.net"] }, { name: "Byside", homepage: "https://byside.com", category: "analytics", domains: ["*.byside.com"] }, { name: "VWO", homepage: "https://vwo.com", category: "analytics", domains: ["*.vwo.com", "*.visualwebsiteoptimizer.com", "d5phz18u4wuww.cloudfront.net", "*.wingify.com"] }, { name: "Bing Ads", homepage: "https://bingads.microsoft.com", category: "ad", domains: ["*.bing.com", "*.microsoft.com", "*.msn.com", "*.s-msft.com", "*.s-msn.com", "*.msads.net", "*.msecnd.net"] }, { name: "GoSquared", homepage: "https://www.gosquared.com", category: "analytics", domains: ["*.gosquared.com", "d1l6p2sc9645hc.cloudfront.net"] }, { name: "Usabilla", homepage: "https://usabilla.com", category: "analytics", domains: ["*.usabilla.com", "d6tizftlrpuof.cloudfront.net"] }, { name: "Fastly Insights", homepage: "https://insights.fastlylabs.com", category: "analytics", domains: ["*.fastly-insights.com"] }, { name: "Visual IQ", homepage: "https://www.visualiq.com", category: "analytics", domains: ["*.myvisualiq.net"] }, { name: "Snapchat", homepage: "https://www.snapchat.com", category: "analytics", domains: ["*.snapchat.com", "*.sc-static.net"] }, { name: "Atlas Solutions", homepage: "https://atlassolutions.com", category: "analytics", domains: ["*.atdmt.com"] }, { name: "Quantcast", homepage: "https://www.quantcast.com", category: "analytics", domains: ["*.brtstats.com", "*.quantcount.com", "*.quantserve.com", "*.semantictec.com", "*.ntv.io"] }, { name: "Spiceworks", homepage: "https://www.spiceworks.com", category: "analytics", domains: ["*.spiceworks.com"] }, { name: "Marketo", homepage: "https://www.marketo.com", category: "analytics", domains: ["*.marketo.com", "*.mktoresp.com", "*.marketo.net"] }, { name: "Intercom", homepage: "https://www.intercom.com", category: "customer-success", domains: ["*.intercomcdn.com", "*.intercom.io"], products: [{ name: "Intercom Widget", urlPatterns: ["widget.intercom.io", "js.intercomcdn.com/shim.latest.js"], facades: [{ name: "React Live Chat Loader", repo: "https://github.com/calibreapp/react-live-chat-loader" }, { name: "Intercom Facade", repo: "https://github.com/danielbachhuber/intercom-facade/" }] }] }, { name: "Unpkg", homepage: "https://unpkg.com", category: "cdn", domains: ["*.unpkg.com", "*.npmcdn.com"] }, { name: "ReadSpeaker", homepage: "https://www.readspeaker.com", category: "other", domains: ["*.readspeaker.com"] }, { name: "Browsealoud", homepage: "https://www.texthelp.com/en-gb/products/browsealoud/", category: "other", domains: ["*.browsealoud.com", "*.texthelp.com"] }, { name: "15gifts", category: "customer-success", domains: ["*.15gifts.com", "*.primefuse.com"] }, { name: "1xRUN", category: "utility", domains: ["*.1xrun.com"] }, { name: "2AdPro Media Solutions", category: "ad", domains: ["*.2adpro.com"] }, { name: "301 Digital Media", category: "content", domains: ["*.301ads.com", "*.301network.com"] }, { name: "360 picnic platform", company: "MediaV", category: "ad", domains: ["*.mediav.com"] }, { name: "365 Media Group", category: "content", domains: ["*.365dm.com"] }, { name: "365 Tech Services", category: "hosting", domains: ["*.365webservices.co.uk"] }, { name: "3D Issue", category: "utility", domains: ["*.3dissue.com", "*.pressjack.com"] }, { name: "47Line Technologies", category: "other", domains: ["*.pejs.net"] }, { name: "4finance", category: "utility", domains: ["*.4finance.com"] }, { name: "5miles", category: "content", domains: ["*.5milesapp.com"] }, { name: "77Tool", company: "77Agency", category: "analytics", domains: ["*.77tracking.com"] }, { name: "9xb", category: "ad", domains: ["*.9xb.com"] }, { name: "@UK", category: "hosting", domains: ["*.uk-plc.net"] }, { name: "A Perfect Pocket", category: "hosting", domains: ["*.aperfectpocketdata.com"] }, { name: "A-FIS PTE", category: "analytics", domains: ["*.websta.me"] }, { name: "AB Tasty", homepage: "https://www.abtasty.com/", category: "analytics", domains: ["*.abtasty.com", "d1447tq2m68ekg.cloudfront.net"] }, { name: "ABA RESEARCH", category: "analytics", domains: ["*.abaresearch.uk", "qmodal.azurewebsites.net"] }, { name: "ADMIZED", category: "ad", domains: ["*.admized.com"] }, { name: "ADNOLOGIES", category: "ad", domains: ["*.heias.com"] }, { name: "ADventori", category: "ad", domains: ["*.adventori.com"] }, { name: "AI Media Group", category: "ad", domains: ["*.aimediagroup.com"] }, { name: "AIR.TV", category: "ad", domains: ["*.air.tv"] }, { name: "AKQA", category: "ad", domains: ["*.srtk.net"] }, { name: "AOL ad", company: "AOL", category: "ad", domains: ["*.atwola.com"] }, { name: "AOL On", company: "AOL", category: "content", domains: ["*.5min.com"] }, { name: "AOL Sponsored Listiings", company: "AOL", category: "ad", domains: ["*.adsonar.com"] }, { name: "APSIS Lead", company: "APSIS International AB", category: "ad", domains: ["*.prospecteye.com"] }, { name: "APSIS Profile Cloud", company: "APSIS", category: "analytics", domains: ["*.innomdc.com"] }, { name: "APSIS Forms", company: "APSIS", category: "other", domains: ["*.apsisforms.com"] }, { name: "ARENA", company: "Altitude", category: "ad", domains: ["*.altitude-arena.com"] }, { name: "ARM", category: "analytics", domains: ["*.tag4arm.com"] }, { name: "ASAPP", category: "other", domains: ["*.asapp.com"] }, { name: "ASP", category: "hosting", domains: ["*.goshowoff.com"] }, { name: "AT Internet", category: "analytics", domains: ["*.ati-host.net"] }, { name: "ATTRAQT", category: "utility", domains: ["*.attraqt.com", "*.locayta.com"] }, { name: "AVANSER", category: "analytics", domains: ["*.avanser.com.au"] }, { name: "AVG", company: "AVG Technologies", category: "utility", domains: ["*.avg.com"] }, { name: "AWeber", category: "ad", domains: ["*.aweber.com"] }, { name: "AXS", category: "content", domains: ["*.axs.com"] }, { name: "Accentuate", company: "Accentuate Digital", category: "utility", homepage: "https://www.accentuate.io/", domains: ["*.accentuate.io"] }, { name: "Accenture", category: "analytics", domains: ["*.tmvtp.com"] }, { name: "Accord Holdings", category: "ad", domains: ["*.agcdn.com"] }, { name: "Accordant Media", category: "ad", domains: ["*.a3cloud.net"] }, { name: "Account Kit", category: "other", domains: ["*.accountkit.com"] }, { name: "Accuen Media (Omnicom Media Group)", category: "content", domains: ["*.p-td.com"] }, { name: "Accuweather", category: "content", domains: ["*.accuweather.com"] }, { name: "Acquisio", category: "ad", domains: ["*.acq.io"] }, { name: "Act-On Software", category: "marketing", domains: ["*.actonsoftware.com"] }, { name: "ActBlue", category: "other", domains: ["*.actblue.com"] }, { name: "Active Agent", category: "ad", domains: ["*.active-agent.com"] }, { name: "ActiveCampaign", category: "ad", domains: ["*.trackcmp.net", "app-us1.com", "*.app-us1.com"] }, { name: "AcuityAds", category: "ad", domains: ["*.acuityplatform.com"] }, { name: "Acxiom", category: "ad", domains: ["*.acxiom-online.com", "*.acxiomapac.com", "*.delivery.net"] }, { name: "Ad4Screen", category: "ad", domains: ["*.a4.tl"] }, { name: "Ad6Media", category: "ad", domains: ["*.ad6media.fr"] }, { name: "AdCurve", category: "ad", domains: ["*.shop2market.com"] }, { name: "AdEasy", category: "ad", domains: ["*.adeasy.ru"] }, { name: "AdExtent", category: "ad", domains: ["*.adextent.com"] }, { name: "AdForge Edge", company: "AdForge", category: "ad", domains: ["*.adforgeinc.com"] }, { name: "AdGear", company: "Samsung Electronics", category: "ad", domains: ["*.adgear.com", "*.adgrx.com"] }, { name: "AdInMedia", category: "ad", domains: ["*.fastapi.net"] }, { name: "AdJug", category: "ad", domains: ["*.adjug.com"] }, { name: "AdMatic", category: "ad", domains: ["*.admatic.com.tr"] }, { name: "AdMedia", category: "ad", domains: ["*.admedia.com"] }, { name: "AdRecover", category: "ad", domains: ["*.adrecover.com"] }, { name: "AdRiver", category: "ad", domains: ["*.adriver.ru"] }, { name: "AdSniper", category: "ad", domains: ["*.adsniper.ru", "*.sniperlog.ru"] }, { name: "AdSpeed", category: "ad", domains: ["*.adspeed.net"] }, { name: "AdSpruce", category: "ad", domains: ["*.adspruce.com"] }, { name: "AdSupply", category: "ad", domains: ["*.doublepimp.com"] }, { name: "AdTheorent", category: "ad", domains: ["*.adentifi.com"] }, { name: "AdThink AudienceInsights", company: "AdThink Media", category: "analytics", domains: ["*.audienceinsights.net"] }, { name: "AdTrue", company: "FPT AdTrue", category: "ad", domains: ["*.adtrue.com"] }, { name: "AdYapper", category: "ad", domains: ["*.adyapper.com"] }, { name: "Adacado", category: "ad", domains: ["*.adacado.com"] }, { name: "Adap.tv", category: "ad", domains: ["*.adap.tv"] }, { name: "Adapt Services", category: "hosting", domains: ["*.adcmps.com"] }, { name: "Adaptive Web", category: "hosting", domains: ["*.adaptive.co.uk"] }, { name: "Adara Media", category: "ad", domains: ["*.yieldoptimizer.com"] }, { name: "Adblade", category: "ad", domains: ["*.adblade.com"] }, { name: "Adbrain", category: "ad", domains: ["*.adbrn.com"] }, { name: "AddEvent", category: "utility", domains: ["*.addevent.com"] }, { name: "AddShoppers", category: "social", domains: ["*.addshoppers.com", "d3rr3d0n31t48m.cloudfront.net", "*.shop.pe"] }, { name: "AddThisEvent", category: "hosting", domains: ["*.addthisevent.com"] }, { name: "Addoox MetaNetwork", company: "Addoox", category: "ad", domains: ["*.metanetwork.net"] }, { name: "Addvantage Media", category: "ad", domains: ["*.addvantagemedia.com", "*.simplytechnology.net"] }, { name: "AD EBis", category: "analytics", homepage: "https://www.ebis.ne.jp/", domains: ["*.ebis.ne.jp"] }, { name: "Adecs", category: "customer-success", domains: ["*.adecs.co.uk"] }, { name: "Adelphic", category: "ad", domains: ["*.ipredictive.com"] }, { name: "Adestra", category: "ad", domains: ["*.adestra.com", "*.msgfocus.com"] }, { name: "Adform", category: "ad", domains: ["*.adform.net", "*.adformdsp.net"] }, { name: "Adkontekst", category: "ad", domains: ["*.adkontekst.pl"] }, { name: "Adlead", category: "ad", domains: ["*.webelapp.com"] }, { name: "Adledge", category: "utility", domains: ["*.adledge.com"] }, { name: "Adloox", category: "ad", domains: ["*.adlooxtracking.com"] }, { name: "Adlux", category: "ad", domains: ["*.adlux.com"] }, { name: "Admedo", category: "ad", domains: ["*.a8723.com", "*.adizio.com", "*.admedo.com"] }, { name: "Admeta", company: "Wideorbit", category: "ad", domains: ["*.atemda.com"] }, { name: "Admetrics", company: "Next Tuesday", category: "analytics", domains: ["*.nt.vc"] }, { name: "Admiral", category: "ad", domains: ["*.unknowntray.com"] }, { name: "Admitad", category: "ad", domains: ["*.lenmit.com"] }, { name: "Admixer for Publishers", company: "Admixer", category: "ad", domains: ["*.admixer.net"] }, { name: "Adnium", category: "ad", domains: ["*.adnium.com"] }, { name: "Adnostic", company: "Dennis Publishing", category: "ad", domains: ["*.adnostic.co.uk"] }, { name: "Adobe Marketing Cloud", company: "Adobe Systems", category: "ad", domains: ["*.adobetag.com"] }, { name: "Adobe Scene7", company: "Adobe Systems", category: "content", domains: ["wwwimages.adobe.com", "*.scene7.com", "*.everestads.net", "*.everestjs.net"] }, { name: "Adobe Systems", category: "content", domains: ["adobe.com", "www.adobe.com"] }, { name: "Adobe Business Catalyst", homepage: "https://www.businesscatalyst.com/", category: "hosting", domains: ["*.businesscatalyst.com"] }, { name: "Adocean", company: "Gemius", category: "ad", domains: ["*.adocean.pl"] }, { name: "Adometry", company: "Google", category: "ad", domains: ["*.dmtry.com"] }, { name: "Adomik", category: "analytics", domains: ["*.adomik.com"] }, { name: "Adotmob", category: "ad", domains: ["*.adotmob.com"] }, { name: "Adrian Quevedo", category: "hosting", domains: ["*.adrianquevedo.com"] }, { name: "Adroit Digital Solutions", category: "ad", domains: ["*.imiclk.com", "*.abmr.net"] }, { name: "AdsNative", category: "ad", domains: ["*.adsnative.com"] }, { name: "AdsWizz", category: "ad", domains: ["*.adswizz.com"] }, { name: "Adscale", category: "ad", domains: ["*.adscale.de"] }, { name: "Adschoom", company: "JSWeb Production", category: "ad", domains: ["*.adschoom.com"] }, { name: "Adscience", category: "ad", domains: ["*.adscience.nl"] }, { name: "Adsiduous", category: "ad", domains: ["*.adsiduous.com"] }, { name: "Adsty", category: "ad", domains: ["*.adx1.com"] }, { name: "Adtech (AOL)", category: "ad", domains: ["*.adtechus.com"] }, { name: "Adtegrity", category: "ad", domains: ["*.adtpix.com"] }, { name: "Adthink", company: "Adthink Media", category: "ad", domains: ["*.adxcore.com", "*.dcoengine.com"] }, { name: "AdultWebmasterEmpire.Com", category: "ad", domains: ["*.awempire.com"] }, { name: "Adunity", category: "ad", domains: ["*.adunity.com"] }, { name: "Advance Magazine Group", category: "content", domains: ["*.condenastdigital.com", "*.condenet.com", "*.condenast.co.uk"] }, { name: "Adverline Board", company: "Adverline", category: "ad", domains: ["*.adverline.com", "*.adnext.fr"] }, { name: "AdvertServe", category: "ad", domains: ["*.advertserve.com"] }, { name: "Advolution", category: "utility", domains: ["*.advolution.de"] }, { name: "Adwise", category: "ad", domains: ["*.adwise.bg"] }, { name: "Adyen", category: "utility", domains: ["*.adyen.com"] }, { name: "Adyoulike", category: "ad", domains: ["*.adyoulike.com", "*.omnitagjs.com", "*.adyoulike.net"] }, { name: "Adzerk", category: "ad", domains: ["*.adzerk.net"] }, { name: "Adzip", company: "Adbox Digital", category: "ad", domains: ["*.adzip.co"] }, { name: "AerServ", category: "ad", domains: ["*.aerserv.com"] }, { name: "Affectv", category: "ad", domains: ["*.affectv.com", "*.affec.tv"] }, { name: "Affiliate Window", company: "Digital Window", category: "ad", domains: ["*.dwin1.com"] }, { name: "Affiliatly", category: "ad", domains: ["*.affiliatly.com"] }, { name: "Affino", category: "ad", domains: ["affino.com"] }, { name: "Affirm", category: "utility", domains: ["*.affirm.com"] }, { name: "Afterpay", company: "Block", category: "utility", homepage: "https://www.afterpay.com/", domains: ["*.afterpay.com"] }, { name: "Agenda Media", category: "ad", domains: ["*.agendamedia.co.uk"] }, { name: "Aggregate Knowledge", company: "Neustar", category: "ad", domains: ["*.agkn.com"] }, { name: "AgilOne", category: "marketing", domains: ["*.agilone.com"] }, { name: "Agility", category: "hosting", domains: ["*.agilitycms.com"] }, { name: "Ahalogy", category: "social", domains: ["*.ahalogy.com"] }, { name: "Aheadworks", category: "utility", domains: ["*.aheadworks.com"] }, { name: "AirPR", category: "analytics", domains: ["*.airpr.com"] }, { name: "Aira", category: "ad", domains: ["*.aira.net"] }, { name: "Airport Parking and Hotels", category: "content", domains: ["*.aph.com"] }, { name: "Akanoo", category: "analytics", domains: ["*.akanoo.com"] }, { name: "Alchemy", company: "AndBeyond.Media", category: "ad", domains: ["*.andbeyond.media"] }, { name: "AlephD", company: "AOL", category: "ad", domains: ["*.alephd.com"] }, { name: "AliveChat", company: "AYU Technology Solutions", category: "customer-success", domains: ["*.websitealive.com", "*.websitealive7.com"] }, { name: "All Access", category: "other", domains: ["*.allaccess.com.ph"] }, { name: "Alliance for Audited Media", category: "ad", domains: ["*.aamsitecertifier.com"] }, { name: "Allyde", category: "marketing", domains: ["*.mautic.com"] }, { name: "AlphaSSL", category: "utility", domains: ["*.alphassl.com"] }, { name: "Altitude", category: "ad", domains: ["*.altitudeplatform.com"] }, { name: "Altocloud", category: "analytics", domains: ["*.altocloud.com"] }, { name: "Amadeus", category: "content", domains: ["*.e-travel.com"] }, { name: "Amazon CloudFront", company: "Amazon", category: "utility", domains: ["cloudfront.net"] }, { name: "Ambassador", category: "ad", domains: ["*.getambassador.com"] }, { name: "Ambient", company: "Ericcson", category: "other", domains: ["*.adnetwork.vn", "*.ambientplatform.vn"] }, { name: "Amelia Communication", category: "hosting", domains: ["*.sara.media"] }, { name: "Amobee", category: "marketing", domains: ["*.amgdgt.com", "*.kontera.com"] }, { name: "Amplience", category: "marketing", domains: ["*.10cms.com", "*.amplience.com", "*.amplience.net", "*.bigcontent.io", "*.adis.ws"] }, { name: "Amplitude Mobile Analytics", company: "Amplitude", category: "analytics", domains: ["*.amplitude.com", "d24n15hnbwhuhn.cloudfront.net"] }, { name: "Anametrix", company: "Ensighten", category: "analytics", domains: ["*.anametrix.com"] }, { name: "Ancora Platform", company: "Ancora Media Solutions", category: "ad", domains: ["*.ancoraplatform.com"] }, { name: "Anedot", category: "other", domains: ["*.anedot.com"] }, { name: "AnimateJS", category: "utility", domains: ["*.animatedjs.com"] }, { name: "AnswerDash", category: "customer-success", domains: ["*.answerdash.com"] }, { name: "Answers", category: "analytics", domains: ["*.answcdn.com", "*.answers.com", "*.dsply.com"] }, { name: "Apester", category: "analytics", domains: ["*.apester.com", "*.qmerce.com"] }, { name: "Apligraf SmartWeb", company: "Apligraf", category: "utility", domains: ["*.apligraf.com.br"] }, { name: "Appier", category: "ad", domains: ["*.appier.net"] }, { name: "Appsolute", category: "utility", homepage: "https://appsolute.us/", domains: ["dropahint.love"] }, { name: "Apptus eSales", company: "Apptus", category: "analytics", domains: ["*.apptus.com"] }, { name: "Arbor", company: "LiveRamp", category: "other", domains: ["*.pippio.com"] }, { name: "Ardent Creative", category: "hosting", domains: ["*.ardentcreative.co.uk"] }, { name: "Arnold Clark Automobiles", category: "content", domains: ["*.arnoldclark.com"] }, { name: "Atom Content Marketing", category: "content", domains: ["*.atomvault.net"] }, { name: "Atom Data", category: "other", domains: ["*.atomdata.io"] }, { name: "Attribution", category: "ad", domains: ["*.attributionapp.com"] }, { name: "Audience 360", company: "Datapoint Media", category: "ad", domains: ["*.dpmsrv.com"] }, { name: "Audience Science", category: "ad", domains: ["*.revsci.net"] }, { name: "AudienceSearch", company: "Intimate Merger", category: "ad", domains: ["*.im-apps.net"] }, { name: "Auditorius", category: "ad", domains: ["*.audtd.com"] }, { name: "Augur", category: "analytics", domains: ["*.augur.io"] }, { name: "Auto Link Maker", company: "Apple", category: "ad", domains: ["*.apple.com"] }, { name: "Autopilot", category: "ad", domains: ["*.autopilothq.com"] }, { name: "Avail", company: "RichRelevance", category: "ad", domains: ["*.avail.net"] }, { name: "AvantLink", category: "ad", domains: ["*.avmws.com"] }, { name: "Avco Systems", category: "utility", domains: ["*.avcosystems.com"] }, { name: "Avid Media", category: "customer-success", domains: ["*.adspdbl.com", "*.metadsp.co.uk"] }, { name: "Avocet Systems", category: "ad", domains: ["*.avocet.io", "ads.avct.cloud"] }, { name: "Avora", category: "analytics", domains: ["*.truedash.com"] }, { name: "Azure Traffic Manager", company: "Microsoft", category: "other", domains: ["*.gateway.net", "*.trafficmanager.net"] }, { name: "Azure Web Services", company: "Microsoft", category: "cdn", domains: ["*.azurewebsites.net", "*.azureedge.net", "*.msedge.net", "*.windows.net"] }, { name: "BAM", category: "analytics", domains: ["*.bam-x.com"] }, { name: "Baifendian Technology", category: "marketing", domains: ["*.baifendian.com"] }, { name: "Bankrate", category: "utility", domains: ["*.bankrate.com"] }, { name: "BannerFlow", company: "Nordic Factory Solutions", category: "ad", domains: ["*.bannerflow.com"] }, { name: "Barclaycard SmartPay", company: "Barclaycard", category: "utility", domains: ["*.barclaycardsmartpay.com"] }, { name: "Barilliance", category: "analytics", domains: ["*.barilliance.net", "dn3y71tq7jf07.cloudfront.net"] }, { name: "Barnebys", category: "other", domains: ["*.barnebys.com"] }, { name: "Basis", company: "Basis Technologies", category: "ad", homepage: "https://basis.net/", domains: ["*.basis.net"] }, { name: "Batch Media", category: "ad", domains: ["*.t4ft.de"] }, { name: "Bauer Consumer Media", category: "content", domains: ["*.bauercdn.com", "*.greatmagazines.co.uk"] }, { name: "Baynote", category: "analytics", domains: ["*.baynote.net"] }, { name: "Bazaarvoice", category: "analytics", domains: ["*.bazaarvoice.com", "*.feedmagnet.com"] }, { name: "Beachfront Media", category: "ad", domains: ["*.bfmio.com"] }, { name: "BeamPulse", category: "analytics", domains: ["*.beampulse.com"] }, { name: "Beeswax", category: "ad", domains: ["*.bidr.io"] }, { name: "Beetailer", category: "social", domains: ["*.beetailer.com"] }, { name: "Best Of Media S.A.", category: "content", domains: ["*.servebom.com"] }, { name: "Bet365", category: "ad", domains: ["*.bet365affiliates.com"] }, { name: "Betfair", category: "other", domains: ["*.cdnbf.net"] }, { name: "Betgenius", company: "Genius Sports", category: "content", domains: ["*.connextra.com"] }, { name: "Better Banners", category: "ad", domains: ["*.betterbannerscloud.com"] }, { name: "Better Business Bureau", category: "analytics", domains: ["*.bbb.org"] }, { name: "Between Digital", category: "ad", domains: ["*.betweendigital.com"] }, { name: "BidTheatre", category: "ad", domains: ["*.bidtheatre.com"] }, { name: "Bidtellect", category: "ad", domains: ["*.bttrack.com"] }, { name: "Bigcommerce", category: "marketing", domains: ["*.bigcommerce.com"] }, { name: "BitGravity", company: "Tata Communications", category: "content", domains: ["*.bitgravity.com"] }, { name: "Bitly", category: "utility", domains: ["*.bitly.com", "*.lemde.fr", "*.bit.ly"] }, { name: "Bizible", category: "ad", domains: ["*.bizible.com", "*.bizibly.com"] }, { name: "Bizrate", category: "analytics", domains: ["*.bizrate.com"] }, { name: "BlastCasta", category: "social", domains: ["*.poweringnews.com"] }, { name: "Blindado", category: "utility", domains: ["*.siteblindado.com"] }, { name: "Blis", category: "ad", domains: ["*.blismedia.com"] }, { name: "Blogg.se", category: "hosting", domains: ["*.cdnme.se", "*.publishme.se"] }, { name: "BloomReach", category: "ad", domains: ["*.brcdn.com", "*.brsrvr.com", "*.brsvr.com"] }, { name: "Bloomberg", category: "content", domains: ["*.gotraffic.net"] }, { name: "Shop Logic", company: "BloomReach", category: "marketing", domains: ["*.goshoplogic.com"] }, { name: "Blue State Digital", category: "ad", domains: ["*.bsd.net"] }, { name: "Blue Triangle Technologies", category: "analytics", domains: ["*.btttag.com"] }, { name: "BlueCava", category: "ad", domains: ["*.bluecava.com"] }, { name: "BlueKai", company: "Oracle", category: "ad", domains: ["*.bkrtx.com", "*.bluekai.com"] }, { name: "Bluecore", category: "analytics", domains: ["*.bluecore.com"] }, { name: "Bluegg", category: "hosting", domains: ["d1va5oqn59yrvt.cloudfront.net"] }, { name: "Bold Commerce", category: "utility", domains: ["*.shappify-cdn.com", "*.shappify.com", "*.boldapps.net"] }, { name: "BoldChat", company: "LogMeIn", category: "customer-success", domains: ["*.boldchat.com"] }, { name: "Bombora", category: "ad", domains: ["*.mlno6.com"] }, { name: "Bonnier", category: "content", domains: ["*.bonniercorp.com"] }, { name: "Bookatable", category: "content", domains: ["*.bookatable.com", "*.livebookings.com"] }, { name: "Booking.com", category: "content", domains: ["*.bstatic.com"] }, { name: "Boomtrain", category: "ad", domains: ["*.boomtrain.com", "*.boomtrain.net"] }, { name: "BoostSuite", category: "ad", domains: ["*.poweredbyeden.com"] }, { name: "Boostable", category: "ad", domains: ["*.boostable.com"] }, { name: "Bootstrap Chinese network", category: "cdn", domains: ["*.bootcss.com"] }, { name: "Booxscale", category: "ad", domains: ["*.booxscale.com"] }, { name: "Borderfree", company: "pitney bowes", category: "utility", domains: ["*.borderfree.com", "*.fiftyone.com"] }, { name: "BowNow", category: "analytics", homepage: "https://bow-now.jp/", domains: ["*.bownow.jp"] }, { name: "Box", category: "hosting", domains: ["*.box.com"] }, { name: "Boxever", category: "analytics", domains: ["*.boxever.com"] }, { name: "Braintree Payments", company: "Paypal", category: "utility", domains: ["*.braintreegateway.com"] }, { name: "Branch Metrics", category: "ad", domains: ["*.branch.io", "*.app.link"] }, { name: "Brand Finance", category: "other", domains: ["*.brandirectory.com"] }, { name: "Brand View", category: "analytics", domains: ["*.brandview.com"] }, { name: "Brandscreen", category: "ad", domains: ["*.rtbidder.net"] }, { name: "BridgeTrack", company: "Sapient", category: "ad", domains: ["*.bridgetrack.com"] }, { name: "BrightRoll", company: "Yahoo!", category: "ad", domains: ["*.btrll.com"] }, { name: "BrightTag / Signal", company: "Signal", homepage: "https://www.signal.co", category: "tag-manager", domains: ["*.btstatic.com", "*.thebrighttag.com"] }, { name: "Brightcove ZenCoder", company: "Brightcove", category: "other", domains: ["*.zencoder.net"] }, { name: "Bronto Software", category: "marketing", domains: ["*.bm23.com", "*.bronto.com", "*.brontops.com"] }, { name: "Browser-Update.org", category: "other", domains: ["*.browser-update.org"] }, { name: "Buffer", category: "social", domains: ["*.bufferapp.com"] }, { name: "Bugsnag", category: "utility", domains: ["*.bugsnag.com", "d2wy8f7a9ursnm.cloudfront.net"] }, { name: "Burst Media", category: "ad", domains: ["*.burstnet.com", "*.1rx.io"] }, { name: "Burt", category: "analytics", domains: ["*.richmetrics.com", "*.burt.io"] }, { name: "Business Message", category: "ad", domains: ["*.message-business.com"] }, { name: "Business Week", company: "Bloomberg", category: "social", domains: ["*.bwbx.io"] }, { name: "Buto", company: "Big Button", category: "ad", domains: ["*.buto.tv"] }, { name: "Button", category: "ad", domains: ["*.btncdn.com"] }, { name: "BuySellAds", category: "ad", domains: ["*.buysellads.com", "*.buysellads.net"] }, { name: "BuySight (AOL)", category: "ad", domains: ["*.pulsemgr.com"] }, { name: "Buyapowa", category: "ad", domains: ["*.co-buying.com"] }, { name: "BuzzFeed", category: "social", domains: ["*.buzzfed.com", "*.buzzfeed.com"] }, { name: "C1X", category: "ad", domains: ["*.c1exchange.com"] }, { name: "C3 Metrics", category: "analytics", domains: ["*.c3tag.com"] }, { name: "CANDDi", company: "Campaign and Digital Intelligence", category: "ad", domains: ["*.canddi.com"] }, { name: "CCM benchmark Group", category: "social", domains: ["*.ccm2.net"] }, { name: "CD Networks", category: "utility", domains: ["*.gccdn.net"] }, { name: "CDN Planet", category: "analytics", domains: ["*.cdnplanet.com"] }, { name: "InAuth", category: "utility", homepage: "https://www.inauth.com/", domains: ["*.cdn-net.com"] }, { name: "CJ Affiliate", company: "Conversant", category: "ad", domains: ["*.cj.com", "*.dpbolvw.net"] }, { name: "CJ Affiliate by Conversant", company: "Conversant", category: "ad", domains: ["*.ftjcfx.com"] }, { name: "CNBC", category: "content", domains: ["*.cnbc.com"] }, { name: "CNET Content Solutions", company: "CBS Interactive", category: "content", domains: ["*.cnetcontent.com"] }, { name: "CPEx", category: "content", domains: ["*.cpex.cz"] }, { name: "CPXi", category: "ad", domains: ["*.cpxinteractive.com"] }, { name: "CUBED Attribution", company: "CUBED", category: "ad", domains: ["*.withcubed.com"] }, { name: "Cachefly", category: "utility", domains: ["*.cachefly.net"] }, { name: "Calendly", category: "other", domains: ["*.calendly.com"] }, { name: "CallRail", category: "analytics", domains: ["*.callrail.com"] }, { name: "CallTrackingMetrics", category: "analytics", domains: ["*.tctm.co"] }, { name: "Canned Banners", category: "ad", domains: ["*.cannedbanners.com"] }, { name: "Canopy Labs", category: "analytics", domains: ["*.canopylabs.com"] }, { name: "Capita", category: "utility", domains: ["*.crcom.co.uk"] }, { name: "Captify Media", category: "ad", domains: ["*.cpx.to"] }, { name: "Captiify", category: "ad", domains: ["*.captifymedia.com"] }, { name: "Captivate Ai", category: "ad", domains: ["*.captivate.ai"] }, { name: "Captora", category: "marketing", domains: ["*.captora.com"] }, { name: "Carcloud", category: "other", domains: ["*.carcloud.co.uk"] }, { name: "Cardlytics", category: "ad", domains: ["*.cardlytics.com"] }, { name: "Cardosa Enterprises", category: "analytics", domains: ["*.y-track.com"] }, { name: "Caspian Media", category: "ad", domains: ["*.caspianmedia.com"] }, { name: "Cast", category: "utility", domains: ["*.cast.rocks"] }, { name: "Catch", category: "other", domains: ["*.getcatch.com"] }, { name: "Cavisson", category: "analytics", domains: ["*.cavisson.com"] }, { name: "Cedato", category: "ad", domains: ["*.algovid.com", "*.vdoserv.com"] }, { name: "Celebrus Technologies", category: "analytics", domains: ["*.celebrus.com"] }, { name: "Celtra", category: "ad", domains: ["*.celtra.com"] }, { name: "Centro", category: "ad", domains: ["*.brand-server.com"] }, { name: "Ceros", category: "other", domains: ["ceros.com", "view.ceros.com"] }, { name: "Ceros Analytics", company: "Ceros", category: "analytics", domains: ["api.ceros.com"] }, { name: "Certona", category: "analytics", domains: ["*.certona.net"] }, { name: "Certum", category: "utility", domains: ["*.ocsp-certum.com", "*.certum.pl"] }, { name: "Cgrdirect", category: "other", domains: ["*.cgrdirect.co.uk"] }, { name: "Channel 5 Media", category: "ad", domains: ["*.five.tv"] }, { name: "Channel.me", category: "customer-success", domains: ["*.channel.me"] }, { name: "ChannelAdvisor", category: "ad", domains: ["*.channeladvisor.com", "*.searchmarketing.com"] }, { name: "ChannelApe", company: "ChannelApe", category: "other", homepage: "https://www.channelape.com/", domains: ["*.channelape.com"] }, { name: "Chargeads Oscar", company: "Chargeads", category: "ad", domains: ["*.chargeads.com"] }, { name: "Charities Aid Foundation", category: "utility", domains: ["*.cafonline.org"] }, { name: "Chartbeat", category: "analytics", domains: ["*.chartbeat.com", "*.chartbeat.net"] }, { name: "Cheapflights Media", company: "Momondo", category: "content", domains: ["*.momondo.net"] }, { name: "CheckM8", category: "ad", domains: ["*.checkm8.com"] }, { name: "CheckRate", company: "FreeStart", category: "utility", domains: ["*.checkrate.co.uk"] }, { name: "Checkfront", category: "other", domains: ["*.checkfront.com", "dcg3jth5savst.cloudfront.net"] }, { name: "CheetahMail", company: "Experian", category: "ad", domains: ["*.chtah.com"] }, { name: "Chitika", category: "ad", domains: ["*.chitika.net"] }, { name: "ChoiceStream", category: "ad", domains: ["*.choicestream.com"] }, { name: "Cint", category: "social", domains: ["*.cint.com"] }, { name: "Civic", category: "hosting", domains: ["*.civiccomputing.com"] }, { name: "ClearRise", category: "customer-success", domains: ["*.clearrise.com"] }, { name: "Clearstream", category: "ad", domains: ["*.clrstm.com"] }, { name: "Clerk.io ApS", category: "analytics", domains: ["*.clerk.io"] }, { name: "CleverDATA", category: "ad", domains: ["*.1dmp.io"] }, { name: "CleverTap", category: "analytics", domains: ["d2r1yp2w7bby2u.cloudfront.net"] }, { name: "Click Density", category: "analytics", domains: ["*.clickdensity.com"] }, { name: "Click4Assistance", category: "customer-success", domains: ["*.click4assistance.co.uk"] }, { name: "ClickDesk", category: "customer-success", domains: ["*.clickdesk.com", "d1gwclp1pmzk26.cloudfront.net"] }, { name: "ClickDimensions", category: "ad", domains: ["*.clickdimensions.com"] }, { name: "Clickadu (Winner Solutions)", category: "ad", domains: ["*.clickadu.com"] }, { name: "Clickagy Audience Lab", company: "Clickagy", category: "ad", domains: ["*.clickagy.com"] }, { name: "Clickio", category: "ad", domains: [] }, { name: "Clicktale", category: "analytics", domains: ["*.cdngc.net", "*.clicktale.net"] }, { name: "Clicktripz", category: "content", domains: ["*.clicktripz.com"] }, { name: "Clik.com Websites", category: "content", domains: ["*.clikpic.com"] }, { name: "Cloud Technologies", category: "ad", domains: ["*.behavioralengine.com", "*.behavioralmailing.com"] }, { name: "Cloud-A", category: "other", domains: ["*.bulkstorage.ca"] }, { name: "Cloud.typography", company: "Hoefler &amp; Co", category: "cdn", domains: ["*.typography.com"] }, { name: "CloudSponge", category: "ad", domains: ["*.cloudsponge.com"] }, { name: "CloudVPS", category: "other", domains: ["*.adoftheyear.com", "*.objectstore.eu"] }, { name: "Cloudinary", category: "content", domains: ["*.cloudinary.com"] }, { name: "Cloudqp", company: "Cloudwp", category: "other", domains: ["*.cloudwp.io"] }, { name: "Cludo", category: "utility", domains: ["*.cludo.com"] }, { name: "Cognesia", category: "marketing", domains: ["*.intelli-direct.com"] }, { name: "CogoCast", company: "Cogo Labs", category: "ad", domains: ["*.cogocast.net"] }, { name: "Colbenson", category: "utility", domains: ["*.colbenson.com"] }, { name: "Collective", category: "ad", domains: ["*.collective-media.net"] }, { name: "Com Laude", category: "other", domains: ["*.gdimg.net"] }, { name: "Comm100", category: "customer-success", domains: ["*.comm100.com"] }, { name: "CommerceHub", category: "marketing", domains: ["*.mercent.com"] }, { name: "Commission Factory", category: "ad", domains: ["*.cfjump.com"] }, { name: "Communicator", category: "ad", domains: ["*.communicatorcorp.com", "*.communicatoremail.com"] }, { name: "Comodo", category: "utility", domains: ["*.comodo.com", "*.trust-provider.com", "*.trustlogo.com", "*.usertrust.com", "*.comodo.net"] }, { name: "Comodo Certificate Authority", company: "Comodo", category: "utility", domains: ["crt.comodoca.com", "*.comodoca4.com", "ocsp.comodoca.com", "ocsp.usertrust.com", "crt.usertrust.com"] }, { name: "Compete", company: "Millwood Brown Digital", category: "analytics", domains: ["*.c-col.com", "*.compete.com"] }, { name: "Compuware", category: "analytics", domains: ["*.axf8.net"] }, { name: "Conductrics", category: "analytics", domains: ["*.conductrics.com"] }, { name: "Confirmit", category: "analytics", domains: ["*.confirmit.com"] }, { name: "Connatix", category: "ad", domains: ["*.connatix.com"] }, { name: "Connect Events", category: "hosting", domains: ["*.connectevents.com.au"] }, { name: "Constant Contact", category: "ad", domains: ["*.ctctcdn.com"] }, { name: "Constructor.io", category: "utility", domains: ["*.cnstrc.com"] }, { name: "Contabo", category: "hosting", domains: ["185.2.100.179"] }, { name: "Content Media Corporation", category: "content", domains: ["*.contentmedia.eu"] }, { name: "ContentSquare", category: "analytics", domains: ["d1m6l9dfulcyw7.cloudfront.net", "*.content-square.net", "*.contentsquare.net"] }, { name: "ContextWeb", category: "ad", domains: ["*.contextweb.com"] }, { name: "Continental Exchange Solutions", category: "utility", domains: ["*.hifx.com"] }, { name: "Converge-Digital", category: "ad", domains: ["*.converge-digital.com"] }, { name: "Conversant", category: "analytics", domains: ["*.dotomi.com", "*.dtmpub.com", "*.emjcd.com", "mediaplex.com", "*.tqlkg.com", "*.fastclick.net"] }, { name: "Conversant Ad Server", company: "Conversant", category: "ad", domains: ["adfarm.mediaplex.com", "*.mediaplex.com"] }, { name: "Conversant Tag Manager", company: "Conversant", category: "tag-manager", domains: ["*.mplxtms.com"] }, { name: "Conversio", category: "ad", domains: ["*.conversio.com"] }, { name: "Conversion Labs", category: "ad", domains: ["*.net.pl"] }, { name: "Conversion Logic", category: "ad", domains: ["*.conversionlogic.net"] }, { name: "Convert Insights", category: "analytics", domains: ["*.convertexperiments.com"] }, { name: "ConvertMedia", category: "ad", domains: ["*.admailtiser.com", "*.basebanner.com", "*.cmbestsrv.com", "*.vidfuture.com", "*.zorosrv.com"] }, { name: "Convertro", category: "ad", domains: ["*.convertro.com"] }, { name: "Conviva", category: "content", domains: ["*.conviva.com"] }, { name: "Cookie Reports", category: "utility", domains: ["*.cookiereports.com"] }, { name: "Cookie-Script.com", category: "utility", domains: ["*.cookie-script.com"] }, { name: "CookieQ", company: "Baycloud Systems", category: "utility", domains: ["*.cookieq.com"] }, { name: "CoolaData", category: "analytics", domains: ["*.cooladata.com"] }, { name: "CopperEgg", category: "analytics", domains: ["*.copperegg.com", "d2vig74li2resi.cloudfront.net"] }, { name: "Council ad Network", category: "ad", domains: ["*.counciladvertising.net"] }, { name: "Covert Pics", category: "content", domains: ["*.covet.pics"] }, { name: "Cox Digital Solutions", category: "ad", domains: ["*.afy11.net"] }, { name: "Creafi Online Media", category: "ad", domains: ["*.creafi-online-media.com"] }, { name: "Creators", category: "content", domains: ["*.creators.co"] }, { name: "Crimson Hexagon Analytics", company: "Crimson Hexagon", category: "analytics", domains: ["*.hexagon-analytics.com"] }, { name: "Crimtan", category: "ad", domains: ["*.ctnsnet.com"] }, { name: "Cross Pixel Media", category: "ad", domains: ["*.crsspxl.com"] }, { name: "Crosswise", category: "ad", domains: ["*.univide.com"] }, { name: "Crowd Control", company: "Lotame", category: "ad", domains: ["*.crwdcntrl.net"] }, { name: "Crowd Ignite", category: "ad", domains: ["*.crowdignite.com"] }, { name: "CrowdTwist", category: "ad", domains: ["*.crowdtwist.com"] }, { name: "Crowdskout", category: "ad", domains: ["*.crowdskout.com"] }, { name: "Crowdynews", category: "social", domains: ["*.breakingburner.com"] }, { name: "Curalate", category: "marketing", domains: ["*.curalate.com", "d116tqlcqfmz3v.cloudfront.net"] }, { name: "Customer Acquisition Cloud", company: "[24]7", category: "ad", domains: ["*.campanja.com"] }, { name: "Customer.io", category: "ad", domains: ["*.customer.io"] }, { name: "Custora", category: "analytics", domains: ["*.custora.com"] }, { name: "Cxense", category: "ad", domains: ["*.cxense.com", "*.cxpublic.com", "*.emediate.dk", "*.emediate.eu"] }, { name: "CyberKnight", company: "Namogoo", category: "utility", domains: ["*.namogoo.com"] }, { name: "CyberSource (Visa)", category: "utility", domains: ["*.authorize.net"] }, { name: "Cybernet Quest", category: "analytics", domains: ["*.cqcounter.com"] }, { name: "D.A. Consortium", category: "ad", domains: ["*.eff1.net"] }, { name: "D4t4 Solutions", category: "analytics", domains: ["*.u5e.com"] }, { name: "DCSL Software", category: "hosting", domains: ["*.dcslsoftware.com"] }, { name: "DMG Media", category: "content", domains: ["*.mol.im", "*.and.co.uk", "*.anm.co.uk", "*.dailymail.co.uk"] }, { name: "DTSCOUT", category: "ad", domains: ["*.dtscout.com"] }, { name: "Dailykarma", category: "utility", homepage: "https://www.dailykarma.com/", domains: ["*.dailykarma.io"] }, { name: "Dailymotion", category: "content", domains: ["*.dailymotion.com", "*.dmxleo.com", "*.dm.gg", "*.pxlad.io", "*.dmcdn.net", "*.sublimevideo.net"] }, { name: "Dash Hudson", company: "Dash Hudson", category: "content", domains: ["*.dashhudson.com"] }, { name: "Datacamp", category: "utility", domains: ["*.cdn77.org"] }, { name: "Datalicious", category: "tag-manager", domains: ["*.supert.ag", "*.optimahub.com"] }, { name: "Datalogix", category: "ad", domains: ["*.nexac.com"] }, { name: "Datawrapper", category: "utility", domains: ["*.datawrapper.de", "*.dwcdn.net"] }, { name: "Dataxu", category: "marketing", domains: ["*.w55c.net"] }, { name: "DatoCMS", homepage: "https://www.datocms.com/", category: "content", domains: ["*.datocms-assets.com"] }, { name: "Datonics", category: "ad", domains: ["*.pro-market.net"] }, { name: "Dealtime", category: "content", domains: ["*.dealtime.com"] }, { name: "Debenhams Geo Location", company: "Debenhams", category: "utility", domains: ["176.74.183.134"] }, { name: "Decibel Insight", category: "analytics", domains: ["*.decibelinsight.net"] }, { name: "Deep Forest Media", company: "Rakuten", category: "ad", domains: ["*.dpclk.com"] }, { name: "DeepIntent", category: "ad", domains: ["*.deepintent.com"] }, { name: "Delicious Media", category: "social", domains: ["*.delicious.com"] }, { name: "Delineo", category: "ad", domains: ["*.delineo.com"] }, { name: "Delta Projects AB", category: "ad", domains: ["*.de17a.com"] }, { name: "Demand Media", category: "content", domains: ["*.dmtracker.com"] }, { name: "DemandBase", category: "marketing", domains: ["*.demandbase.com"] }, { name: "DemandJump", category: "analytics", domains: ["*.demandjump.com"] }, { name: "Dennis Publishing", category: "content", domains: ["*.alphr.com"] }, { name: "Devatics", category: "analytics", domains: ["*.devatics.com", "*.devatics.io"] }, { name: "Developer Media", category: "ad", domains: ["*.developermedia.com"] }, { name: "DialogTech", category: "ad", domains: ["*.dialogtech.com"] }, { name: "DialogTech SourceTrak", company: "DialogTech", category: "ad", domains: ["d31y97ze264gaa.cloudfront.net"] }, { name: "DigiCert", category: "utility", domains: ["*.digicert.com"] }, { name: "Digioh", category: "ad", domains: ["*.lightboxcdn.com"] }, { name: "Digital Look", category: "content", domains: ["*.digitallook.com"] }, { name: "Digital Media Exchange", company: "NDN", category: "content", domains: ["*.newsinc.com"] }, { name: "Digital Millennium Copyright Act Services", category: "utility", domains: ["*.dmca.com"] }, { name: "Digital Ocean", category: "other", domains: ["95.85.62.56"] }, { name: "Digital Remedy", category: "ad", domains: ["*.consumedmedia.com"] }, { name: "Digital Window", category: "ad", domains: ["*.awin1.com", "*.zenaps.com"] }, { name: "DigitalScirocco", category: "analytics", domains: ["*.digitalscirocco.net"] }, { name: "Digitial Point", category: "utility", domains: ["*.dpstatic.com"] }, { name: "Diligent (Adnetik)", category: "ad", domains: ["*.wtp101.com"] }, { name: "Directed Edge", category: "social", domains: ["*.directededge.com"] }, { name: "Distribute Travel", category: "ad", domains: ["*.dtrck.net"] }, { name: "District M", category: "ad", domains: ["*.districtm.io"] }, { name: "DistroScale", category: "ad", domains: ["*.jsrdn.com"] }, { name: "Divido", category: "utility", domains: ["*.divido.com"] }, { name: "Dow Jones", category: "content", domains: ["*.dowjones.com", "*.dowjoneson.com"] }, { name: "Drifty Co", category: "utility", domains: ["*.onicframework.com"] }, { name: "Drip", company: "The Numa Group", category: "ad", domains: ["*.getdrip.com"] }, { name: "Dropbox", category: "utility", domains: ["*.dropboxusercontent.com"] }, { name: "Dyn Real User Monitoring", company: "Dyn", category: "analytics", domains: ["*.jisusaiche.biz", "*.dynapis.com", "*.jisusaiche.com", "*.dynapis.info"] }, { name: "DynAdmic", category: "ad", domains: ["*.dyntrk.com"] }, { name: "Dynamic Converter", category: "utility", domains: ["*.dynamicconverter.com"] }, { name: "Dynamic Dummy Image Generator", company: "Open Source", category: "utility", domains: ["*.dummyimage.com"] }, { name: "Dynamic Logic", category: "ad", domains: ["*.dl-rms.com", "*.questionmarket.com"] }, { name: "Dynamic Yield", category: "customer-success", domains: ["*.dynamicyield.com"] }, { name: "Dynatrace", category: "analytics", domains: ["*.ruxit.com", "js-cdn.dynatrace.com"] }, { name: "ec-concier", homepage: "https://ec-concier.com/", category: "marketing", domains: ["*.ec-concier.com"] }, { name: "ECT News Network", category: "content", domains: ["*.ectnews.com"] }, { name: "ELITechGroup", category: "analytics", domains: ["*.elitechnology.com"] }, { name: "EMAP", category: "content", domains: ["*.emap.com"] }, { name: "EMedia Solutions", category: "ad", domains: ["*.e-shots.eu"] }, { name: "EQ works", category: "ad", domains: ["*.eqads.com"] }, { name: "ESV Digital", category: "analytics", domains: ["*.esearchvision.com"] }, { name: "Ebiquity", category: "analytics", domains: ["*.ebiquitymedia.com"] }, { name: "Eco Rebates", category: "ad", domains: ["*.ecorebates.com"] }, { name: "Ecwid", category: "hosting", domains: ["*.ecwid.com", "*.shopsettings.com", "d3fi9i0jj23cau.cloudfront.net", "d3j0zfs7paavns.cloudfront.net"] }, { name: "Edge Web Fonts", company: "Adobe Systems", category: "cdn", domains: ["*.edgefonts.net"] }, { name: "Edition Digital", category: "ad", domains: ["*.editiondigital.com"] }, { name: "Edot Web Technologies", category: "hosting", domains: ["*.edot.co.za"] }, { name: "Effective Measure", category: "ad", domains: ["*.effectivemeasure.net"] }, { name: "Effiliation sa", category: "ad", domains: ["*.effiliation.com"] }, { name: "Ekm Systems", category: "analytics", domains: ["*.ekmsecure.com", "*.ekmpinpoint.co.uk"] }, { name: "Elastera", category: "hosting", domains: ["*.elastera.net"] }, { name: "Elastic Ad", category: "ad", domains: ["*.elasticad.net"] }, { name: "Elastic Load Balancing", company: "Amazon Web Services", category: "hosting", domains: ["*.105app.com"] }, { name: "Elecard StreamEye", company: "Elecard", category: "other", domains: ["*.streameye.net"] }, { name: "Elevate", company: "Elevate Technology Solutions", category: "utility", domains: ["*.elevaate.technology"] }, { name: "Elicit", category: "utility", domains: ["*.elicitapp.com"] }, { name: "Elogia", category: "ad", domains: ["*.elogia.net"] }, { name: "Email Attitude", company: "1000mercis", category: "ad", domains: ["*.email-attitude.com"] }, { name: "EmailCenter", category: "ad", domains: ["*.emailcenteruk.com"] }, { name: "Embedly", category: "content", domains: ["*.embedly.com", "*.embed.ly"] }, { name: "EmpathyBroker Site Search", company: "EmpathyBroker", category: "utility", domains: ["*.empathybroker.com"] }, { name: "Enfusen", category: "analytics", domains: ["*.enfusen.com"] }, { name: "Engadget", company: "Engadget (AOL)", category: "content", domains: ["*.gdgt.com"] }, { name: "Engagio", category: "marketing", domains: ["*.engagio.com"] }, { name: "Ensighten Manage", company: "Ensighten", category: "tag-manager", domains: ["*.levexis.com"] }, { name: "EntityLink", category: "other", domains: ["*.entitytag.co.uk"] }, { name: "Entrust Datacard", category: "utility", domains: ["*.entrust.com", "*.entrust.net"] }, { name: "Equiniti", category: "utility", domains: ["*.equiniti.com"] }, { name: "Errorception", category: "utility", domains: ["*.errorception.com"] }, { name: "Esri ArcGIS", company: "Esri", category: "utility", domains: ["*.arcgis.com", "*.arcgisonline.com"] }, { name: "Ethnio", category: "analytics", domains: ["*.ethn.io"] }, { name: "Eulerian Technologies", category: "ad", domains: ["*.eolcdn.com"] }, { name: "Euroland", category: "utility", domains: ["*.euroland.com"] }, { name: "European Interactive Digital ad Alli", category: "utility", domains: ["*.edaa.eu"] }, { name: "Eventbrite", category: "hosting", domains: ["*.evbuc.com", "*.eventbrite.co.uk"] }, { name: "Everflow", category: "analytics", domains: ["*.tp88trk.com"] }, { name: "Evergage", category: "analytics", domains: ["*.evergage.com", "*.evgnet.com"] }, { name: "Everquote", category: "content", domains: ["*.evq1.com"] }, { name: "Everyday Health", category: "ad", domains: ["*.agoramedia.com"] }, { name: "Evidon", category: "analytics", domains: ["*.evidon.com"] }, { name: "Evolve Media", category: "content", domains: ["*.evolvemediallc.com"] }, { name: "Exactag", category: "ad", domains: ["*.exactag.com"] }, { name: "ExoClick", category: "ad", domains: ["*.exoclick.com"] }, { name: "Expedia", category: "content", domains: ["*.travel-assets.com", "*.trvl-media.com", "*.trvl-px.com", "*.uciservice.com"] }, { name: "Expedia Australia", company: "Expedia", category: "content", domains: ["*.expedia.com.au"] }, { name: "Expedia Canada", company: "Expedia", category: "content", domains: ["*.expedia.ca"] }, { name: "Expedia France", company: "Expedia", category: "content", domains: ["*.expedia.fr"] }, { name: "Expedia Germany", company: "Expedia", category: "content", domains: ["*.expedia.de"] }, { name: "Expedia Italy", company: "Expedia", category: "content", domains: ["*.expedia.it"] }, { name: "Expedia Japan", company: "Expedia", category: "content", domains: ["*.expedia.co.jp"] }, { name: "Expedia USA", company: "Expedia", category: "content", domains: ["*.expedia.com"] }, { name: "Expedia United Kingdom", company: "Expedia", category: "content", domains: ["*.expedia.co.uk"] }, { name: "Experian", category: "utility", domains: ["*.audienceiq.com", "*.experian.com", "*.experianmarketingservices.digital"] }, { name: "Experian Cross-Channel Marketing Platform", company: "Experian", category: "marketing", domains: ["*.eccmp.com", "*.ccmp.eu"] }, { name: "Exponea", category: "analytics", domains: ["*.exponea.com"] }, { name: "Exponential Interactive", category: "ad", domains: ["*.exponential.com"] }, { name: "Extensis WebInk", category: "cdn", domains: ["*.webink.com"] }, { name: "Extole", category: "ad", domains: ["*.extole.com", "*.extole.io"] }, { name: "Ey-Seren", category: "analytics", domains: ["*.webabacus.com"] }, { name: "EyeView", category: "ad", domains: ["*.eyeviewads.com"] }, { name: "Eyeota", category: "ad", domains: ["*.eyeota.net"] }, { name: "Ezakus Pretargeting", company: "Ezakus", category: "ad", domains: ["*.ezakus.net"] }, { name: "Ezoic", category: "analytics", domains: ["*.ezoic.net"] }, { name: "FLXone", company: "Teradata", category: "ad", domains: ["*.pangolin.blue", "*.flx1.com", "d2hlpp31teaww3.cloudfront.net", "*.flxpxl.com"] }, { name: "Fairfax Media", category: "content", domains: ["ads.fairfax.com.au", "resources.fairfax.com.au"] }, { name: "Fairfax Media Analtics", company: "Fairfax Media", category: "analytics", domains: ["analytics.fairfax.com.au"] }, { name: "Falk Technologies", category: "ad", domains: ["*.angsrvr.com"] }, { name: "Fanplayr", category: "analytics", domains: ["*.fanplayr.com", "d38nbbai6u794i.cloudfront.net"] }, { name: "Fast Thinking", company: "NE Marketing", category: "marketing", domains: ["*.fast-thinking.co.uk"] }, { name: "Fastest Forward", category: "analytics", domains: ["*.gaug.es"] }, { name: "Fastly", category: "utility", domains: ["*.fastly.net"] }, { name: "Feedbackify", company: "InsideMetrics", category: "analytics", domains: ["*.feedbackify.com"] }, { name: "Feefo.com", company: "Feefo", category: "analytics", domains: ["*.feefo.com"] }, { name: "Fidelity Media", category: "ad", domains: ["*.fidelity-media.com"] }, { name: "Filestack", category: "content", domains: ["*.filepicker.io"] }, { name: "Finsbury Media", category: "ad", domains: ["*.finsburymedia.com"] }, { name: "Firepush", category: "utility", domains: ["*.firepush.io"] }, { name: "FirstImpression", category: "ad", domains: ["*.firstimpression.io"] }, { name: "Fit Analytics", category: "other", domains: ["*.fitanalytics.com"] }, { name: "Fits Me", category: "analytics", domains: ["*.fits.me"] }, { name: "Fivetran", category: "analytics", domains: ["*.fivetran.com"] }, { name: "FlexShopper", category: "utility", domains: ["*.flexshopper.com"] }, { name: "Flickr", category: "content", domains: ["*.flickr.com", "*.staticflickr.com"] }, { name: "Flipboard", category: "social", domains: ["*.flipboard.com"] }, { name: "Flipdesk", category: "customer-success", homepage: "https://flipdesk.jp/", domains: ["*.flipdesk.jp"] }, { name: "Flipp", category: "analytics", domains: ["*.wishabi.com", "d2e0sxz09bo7k2.cloudfront.net", "*.wishabi.net"] }, { name: "Flite", category: "ad", domains: ["*.flite.com"] }, { name: "Flixmedia", category: "analytics", domains: ["*.flix360.com", "*.flixcar.com", "*.flixfacts.com", "*.flixsyndication.net", "*.flixfacts.co.uk"] }, { name: "Flockler", category: "ad", domains: ["*.flockler.com"] }, { name: "Flowplayer", category: "content", domains: ["*.flowplayer.org"] }, { name: "Flowzymes Ky", category: "cdn", domains: ["*.jquerytools.org"] }, { name: "Fomo", category: "ad", domains: ["*.notifyapp.io"] }, { name: "Fonecall", category: "analytics", domains: ["*.web-call-analytics.com"] }, { name: "Fontdeck", category: "cdn", domains: ["*.fontdeck.com"] }, { name: "Foodity Technologies", category: "ad", domains: ["*.foodity.com"] }, { name: "Force24", category: "ad", domains: ["*.force24.co.uk"] }, { name: "ForeSee", company: "Answers", category: "analytics", domains: ["*.4seeresults.com", "*.answerscloud.com", "*.foresee.com", "*.foreseeresults.com"] }, { name: "Forensiq", category: "utility", domains: ["*.fqtag.com"] }, { name: "Fort Awesome", category: "cdn", domains: ["*.fortawesome.com"] }, { name: "Forter", category: "utility", domains: ["*.forter.com"] }, { name: "Forward Internet Group", category: "hosting", domains: ["*.f3d.io"] }, { name: "Forward3D", category: "ad", domains: ["*.forward3d.com"] }, { name: "Fospha", category: "analytics", domains: ["*.fospha.com"] }, { name: "Foursixty", category: "customer-success", domains: ["*.foursixty.com"] }, { name: "FoxyCart", category: "utility", domains: ["*.foxycart.com"] }, { name: "Fraudlogix", category: "utility", domains: ["*.yabidos.com"] }, { name: "FreakOut", category: "ad", domains: ["*.fout.jp"] }, { name: "Freespee", category: "customer-success", domains: ["*.freespee.com"] }, { name: "Freetobook", category: "content", domains: ["*.freetobook.com"] }, { name: "Fresh 8 Gaming", category: "ad", domains: ["*.fresh8.co"] }, { name: "Fresh Relevance", category: "analytics", domains: ["*.freshrelevance.com", "*.cloudfront.ne", "d1y9qtn9cuc3xw.cloudfront.net", "d81mfvml8p5ml.cloudfront.net", "dkpklk99llpj0.cloudfront.net"] }, { name: "Friendbuy", category: "ad", domains: ["*.friendbuy.com", "djnf6e5yyirys.cloudfront.net"] }, { name: "Frienefit", category: "ad", domains: ["*.frienefit.com"] }, { name: "FuelX", category: "ad", domains: ["*.fuelx.com"] }, { name: "Full Circle Studies", category: "analytics", domains: ["*.securestudies.com"] }, { name: "FullStory", category: "analytics", domains: ["*.fullstory.com"] }, { name: "Fyber", category: "ad", domains: ["*.fyber.com"] }, { name: "G-Forces Web Management", category: "hosting", domains: ["*.gforcesinternal.co.uk"] }, { name: "G4 Native", company: "Gravity4", category: "ad", domains: ["*.triggit.com"] }, { name: "GET ME IN!  (TicketMaster)", category: "content", domains: ["*.getmein.com"] }, { name: "GIPHY", category: "content", domains: ["*.giphy.com"] }, { name: "GainCloud", company: "GainCloud Systems", category: "other", domains: ["*.egaincloud.net"] }, { name: "Gath Adams", category: "content", domains: ["*.iwantthatflight.com.au"] }, { name: "Gecko Tribe", category: "social", domains: ["*.geckotribe.com"] }, { name: "Gemius", category: "ad", domains: ["*.gemius.pl"] }, { name: "Genesis Media", category: "ad", domains: ["*.bzgint.com", "*.genesismedia.com", "*.genesismediaus.com"] }, { name: "Genie Ventures", category: "ad", domains: ["*.genieventures.co.uk"] }, { name: "Geniee", category: "ad", domains: ["*.href.asia", "*.genieessp.jp", "*.genieesspv.jp", "*.gssprt.jp"] }, { name: "Geniuslink", category: "analytics", domains: ["*.geni.us"] }, { name: "GeoRiot", category: "other", domains: ["*.georiot.com"] }, { name: "GeoTrust", category: "utility", domains: ["*.geotrust.com"] }, { name: "Geoplugin", category: "utility", domains: ["*.geoplugin.com", "*.geoplugin.net"] }, { name: "Georeferencer", company: "Klokan Technologies", category: "utility", domains: ["*.georeferencer.com"] }, { name: "GetIntent RTBSuite", company: "GetIntent", category: "ad", domains: ["*.adhigh.net"] }, { name: "GetResponse", category: "ad", domains: ["*.getresponse.com"] }, { name: "GetSiteControl", company: "GetWebCraft", category: "utility", domains: ["*.getsitecontrol.com"] }, { name: "GetSocial", category: "social", domains: ["*.getsocial.io"] }, { name: "Getty Images", category: "content", domains: ["*.gettyimages.com", "*.gettyimages.co.uk"] }, { name: "Gfycat", company: "Gycat", category: "utility", domains: ["*.gfycat.com"] }, { name: "Ghostery Enterprise", company: "Ghostery", category: "marketing", domains: ["*.betrad.com"] }, { name: "Giant Media", category: "ad", domains: ["*.videostat.com"] }, { name: "Gigya", category: "analytics", domains: ["*.gigya.com"] }, { name: "GitHub", category: "utility", domains: ["*.github.com", "*.githubusercontent.com", "*.github.io", "*.rawgit.com"] }, { name: "Gladly", company: "Gladly", homepage: "https://www.gladly.com/", category: "customer-success", domains: ["*.gladly.com"] }, { name: "Glassdoor", category: "content", domains: ["*.glassdoor.com"] }, { name: "Gleam", category: "marketing", domains: ["*.gleam.io"] }, { name: "Global Digital Markets", category: "ad", domains: ["*.gdmdigital.com"] }, { name: "Global-e", category: "hosting", domains: ["*.global-e.com"] }, { name: "GlobalSign", category: "utility", domains: ["*.globalsign.com", "*.globalsign.net"] }, { name: "GlobalWebIndex", category: "analytics", domains: ["*.globalwebindex.net"] }, { name: "Globase International", category: "ad", domains: ["*.globase.com"] }, { name: "GoDataFeed", category: "other", domains: ["*.godatafeed.com"] }, { name: "Google APIs", company: "Google", category: "utility", domains: ["googleapis.com"] }, { name: "Google Ad Block Detection", company: "Google", category: "ad", domains: ["*.0emn.com", "*.0fmm.com"] }, { name: "Google Analytics Experiments", company: "Google", category: "analytics", domains: ["*.gexperiments1.com"] }, { name: "Google DoubleClick Ad Exchange", company: "Google", category: "ad", domains: ["*.admeld.com"] }, { name: "Google IPV6 Metrics", company: "Google", category: "analytics", domains: ["*.ipv6test.net"] }, { name: "Google Plus", company: "Google", category: "social", domains: ["plus.google.com"] }, { name: "Google Trusted Stores", company: "Google", category: "utility", domains: ["*.googlecommerce.com"] }, { name: "Google Video", company: "Google", category: "content", domains: ["*.googlevideo.com"] }, { name: "Google reCAPTCHA", company: "Google", category: "utility", domains: ["*.recaptcha.net"] }, { name: "GovMetric", company: "ROL Solutions", category: "analytics", domains: ["*.govmetric.com"] }, { name: "Granify", category: "analytics", domains: ["*.granify.com"] }, { name: "Grapeshot", category: "ad", domains: ["*.gscontxt.net", "*.grapeshot.co.uk"] }, { name: "Gravity (AOL)", category: "analytics", domains: ["*.grvcdn.com"] }, { name: "Groovy Gecko", category: "content", domains: ["*.ggwebcast.com", "*.groovygecko.net"] }, { name: "GroupM", category: "ad", domains: ["*.qservz.com"] }, { name: "Guardian Media", category: "ad", domains: ["*.theguardian.com", "*.guardian.co.uk"] }, { name: "GumGum", category: "ad", domains: ["*.gumgum.com"] }, { name: "Gumtree", category: "content", domains: ["*.gumtree.com"] }, { name: "H264 Codec", company: "Cisco", category: "other", domains: ["*.openh264.org"] }, { name: "HERE", category: "analytics", domains: ["*.medio.com"] }, { name: "HP Optimost", company: "Hewlett-Packard Development Company", category: "marketing", domains: ["*.hp.com", "d2uncb19xzxhzx.cloudfront.net"] }, { name: "Has Offers", company: "TUNE", category: "ad", domains: ["*.go2cloud.org"] }, { name: "Hawk Search", category: "utility", domains: ["*.hawksearch.com"] }, { name: "Haymarket Media Group", category: "content", domains: ["*.brandrepublic.com", "*.hbpl.co.uk"] }, { name: "Heap", category: "analytics", domains: ["*.heapanalytics.com"] }, { name: "Hearst Communications", category: "content", domains: ["*.h-cdn.co", "*.hearstdigital.com", "*.hearstlabs.com", "*.hearst.io", "*.cdnds.net"] }, { name: "Heatmap", category: "analytics", domains: ["*.heatmap.it"] }, { name: "Heroku", category: "other", domains: ["*.herokuapp.com"] }, { name: "Hexton", category: "utility", domains: ["*.hextom.com"] }, { name: "Hibernia Networks", category: "utility", domains: ["*.hiberniacdn.com"] }, { name: "High Impact Media", category: "ad", domains: ["*.reactx.com"] }, { name: "Highcharts", category: "utility", domains: ["*.highcharts.com"] }, { name: "Highwinds", category: "utility", domains: ["*.hwcdn.net"] }, { name: "HitsLink", category: "analytics", domains: ["*.hitslink.com"] }, { name: "Hola Networks", category: "other", domains: ["*.h-cdn.com"] }, { name: "Hootsuite", category: "analytics", domains: ["*.hootsuite.com"] }, { name: "HotUKDeals", category: "analytics", domains: ["*.hotukdeals.com"] }, { name: "HotWords", company: "Media Response Group", category: "ad", domains: ["*.hotwords.com.br"] }, { name: "HotelsCombined", category: "content", domains: ["*.datahc.com"] }, { name: "Hoverr", category: "ad", domains: ["*.hoverr.media"] }, { name: "Hull.js", category: "utility", domains: ["*.hull.io", "*.hullapp.io"] }, { name: "Hupso Website Analyzer", company: "Hupso", category: "analytics", domains: ["*.hupso.com"] }, { name: "I-Behavior", company: "WPP", category: "ad", domains: ["*.ib-ibi.com"] }, { name: "i-mobile", company: "i-mobile", category: "ad", domains: ["*.i-mobile.co.jp"] }, { name: "IBM Digital Analytics", company: "IBM", category: "analytics", domains: ["*.cmcore.com", "coremetrics.com", "data.coremetrics.com", "data.de.coremetrics.com", "libs.de.coremetrics.com", "tmscdn.de.coremetrics.com", "iocdn.coremetrics.com", "libs.coremetrics.com", "tmscdn.coremetrics.com", "*.s81c.com", "*.unica.com", "*.coremetrics.eu"] }, { name: "IBM Digital Data Exchange", company: "IBM", category: "tag-manager", domains: ["tagmanager.coremetrics.com"] }, { name: "IBM Tealeaf", company: "IBM", category: "analytics", domains: ["*.ibmcloud.com"] }, { name: "IBM Acoustic Campaign", company: "IBM", category: "analytics", domains: ["www.sc.pages01.net", "www.sc.pages02.net", "www.sc.pages03.net", "www.sc.pages04.net", "www.sc.pages05.net", "www.sc.pages06.net", "www.sc.pages07.net", "www.sc.pages08.net", "www.sc.pages09.net", "www.sc.pagesA.net"] }, { name: "ICF Technology", category: "content", domains: ["*.camads.net"] }, { name: "IFDNRG", category: "hosting", domains: ["*.ifdnrg.com"] }, { name: "IMRG", category: "analytics", domains: ["*.peermap.com", "*.imrg.org"] }, { name: "IPONWEB", category: "ad", domains: ["*.company-target.com", "*.liadm.com", "*.iponweb.net", "*.p161.net"] }, { name: "IQ Mobile", category: "utility", domains: ["*.iqm.cc"] }, { name: "IS Group", category: "hosting", domains: ["*.creative-serving.com"] }, { name: "IT Dienstleistungen Tim Prinzkosky", category: "utility", domains: ["*.flaticons.net"] }, { name: "IXI Digital", company: "Equifax", category: "ad", domains: ["*.ixiaa.com"] }, { name: "IcoMoon", category: "cdn", domains: ["d19ayerf5ehaab.cloudfront.net", "d1azc1qln24ryf.cloudfront.net"] }, { name: "IdenTrust", category: "utility", domains: ["*.identrust.com"] }, { name: "Ido", category: "customer-success", domains: ["*.idio.co"] }, { name: "Ignition One", category: "marketing", domains: ["*.searchignite.com"] }, { name: "ImageShack", category: "content", domains: ["*.yfrog.com"] }, { name: "Imagen Studio", category: "utility", domains: ["*.telephonesky.com"] }, { name: "Imagini Holdings", category: "ad", domains: ["*.vdna-assets.com"] }, { name: "Img Safe", category: "content", domains: ["*.imgsafe.org"] }, { name: "Imgur", category: "utility", domains: ["*.imgur.com"] }, { name: "Impact Radius", category: "ad", domains: ["*.impactradius-event.com", "*.impactradius-go.com", "*.7eer.net", "d3cxv97fi8q177.cloudfront.net", "*.evyy.net", "*.ojrq.net", "utt.impactcdn.com", "*.sjv.io"] }, { name: "Improve Digital", category: "ad", domains: ["*.360yield.com"] }, { name: "Improvely", category: "analytics", domains: ["*.iljmp.com"] }, { name: "InMobi", category: "ad", domains: ["*.inmobi.com"] }, { name: "InSkin Media", category: "ad", domains: ["*.inskinad.com", "*.inskinmedia.com"] }, { name: "Inbenta", category: "customer-success", domains: ["*.inbenta.com"] }, { name: "Incisive Media", category: "content", domains: ["*.incisivemedia.com"] }, { name: "Indeed", category: "content", domains: ["*.indeed.com"] }, { name: "Index Exchange", company: "WPP", category: "ad", domains: ["*.casalemedia.com", "*.indexww.com"] }, { name: "Indoona", category: "other", domains: ["*.indoona.com"] }, { name: "Infectious Media", category: "ad", domains: ["*.impdesk.com", "*.impressiondesk.com", "*.inmz.net"] }, { name: "Inference Mobile", category: "ad", domains: ["*.inferencemobile.com"] }, { name: "Infinity Tracking", category: "analytics", domains: ["*.infinity-tracking.net"] }, { name: "Infoline", category: "analytics", domains: ["*.ioam.de"] }, { name: "Infolinks", category: "ad", domains: ["*.infolinks.com"] }, { name: "Infopark", category: "hosting", domains: ["*.scrvt.com"] }, { name: "Infusionsoft", category: "ad", domains: ["*.infusionsoft.com"] }, { name: "Ink", category: "ad", domains: ["*.inktad.com"] }, { name: "Inktel Contact Center Solutions", company: "Inktel", category: "customer-success", domains: ["*.inktel.com"] }, { name: "Inneractive", category: "ad", domains: ["*.inner-active.mobi"] }, { name: "Innovid", category: "ad", homepage: "https://www.innovid.com/", domains: ["*.innovid.com"] }, { name: "Insight Express", category: "analytics", domains: ["*.insightexpressai.com"] }, { name: "Insipio", category: "other", domains: ["*.insipio.com"] }, { name: "Inspectlet", category: "analytics", domains: ["*.inspectlet.com"] }, { name: "Instansive", category: "utility", domains: ["*.instansive.com"] }, { name: "Instart", homepage: "https://www.instart.com/", category: "utility", domains: ["*.insnw.net"] }, { name: "Instembedder", category: "content", domains: ["*.instaembedder.com"] }, { name: "Instinctive", category: "ad", domains: ["*.instinctiveads.com"] }, { name: "Intelligent Reach", category: "ad", domains: ["*.ist-track.com"] }, { name: "Intent HQ", category: "analytics", domains: ["*.intenthq.com"] }, { name: "Intent IQ", category: "ad", domains: ["*.intentiq.com"] }, { name: "Intercept Interactive", category: "ad", domains: ["*.undertone.com"] }, { name: "Interest Graph", company: "AOL", category: "ad", domains: ["*.gravity.com"] }, { name: "Internet Brands", category: "content", domains: ["*.ibpxl.com"] }, { name: "Interpublic Group", category: "ad", domains: ["*.mbww.com"] }, { name: "Interstate", category: "analytics", domains: ["*.interstateanalytics.com"] }, { name: "Interview", category: "analytics", domains: ["*.efm.me"] }, { name: "Intilery", category: "customer-success", domains: ["*.intilery-analytics.com"] }, { name: "Investis", category: "utility", domains: ["*.investis.com"] }, { name: "Investis Flife", category: "hosting", domains: ["*.quartalflife.com"] }, { name: "Invodo", category: "ad", domains: ["*.invodo.com"] }, { name: "iSite", category: "analytics", domains: ["*.isitetv.com"] }, { name: "Issue", category: "content", domains: ["*.issue.by"] }, { name: "J.D. Williams & Co", category: "content", domains: ["*.drct2u.com"] }, { name: "Janrain", category: "analytics", domains: ["*.janrain.com", "*.janrainbackplane.com", "*.rpxnow.com", "d3hmp0045zy3cs.cloudfront.net"] }, { name: "Jellyfish", category: "ad", domains: ["*.jellyfish.net"] }, { name: "JetStream", category: "content", domains: ["*.xlcdn.com"] }, { name: "JingDong", category: "content", domains: ["*.3.com", "*.jd.com"] }, { name: "Jivox", category: "ad", domains: ["*.jivox.com"] }, { name: "Jobvite", category: "content", domains: ["*.jobvite.com"] }, { name: "Johnston Press", category: "content", domains: ["*.johnstonpress.co.uk", "*.jpress.co.uk"] }, { name: "Join the Dots (Research)", category: "social", domains: ["*.jtdiscuss.com"] }, { name: "JotForm", category: "utility", domains: ["*.jotformpro.com"] }, { name: "JuicyAds", category: "ad", domains: ["*.juicyads.com"] }, { name: "JustPremium", category: "ad", domains: ["*.net.net"] }, { name: "JustPremium Ads", company: "JustPremium", category: "ad", domains: ["*.justpremium.com"] }, { name: "JustUno", category: "ad", domains: ["*.justuno.com", "d2j3qa5nc37287.cloudfront.net"] }, { name: "KINX (Korea Internet Neutral eXchange)", category: "other", domains: ["*.kinxcdn.com"] }, { name: "KISSmetrics", category: "analytics", domains: ["*.kissmetrics.com", "doug1izaerwt3.cloudfront.net", "dsyszv14g9ymi.cloudfront.net"] }, { name: "Kaizen Platform", category: "analytics", domains: ["*.kaizenplatform.net"] }, { name: "Kakao", category: "social", domains: ["*.daum.net", "*.daumcdn.net"] }, { name: "Kaltura Video Platform", company: "Kaltura", category: "content", domains: ["*.kaltura.com"] }, { name: "Kameleoon", homepage: "https://www.kameleoon.com/", category: "analytics", domains: ["*.kameleoon.com", "*.kameleoon.eu", "*.kameleoon.io"] }, { name: "Kampyle", category: "analytics", domains: ["*.kampyle.com"] }, { name: "Kantar", category: "analytics", domains: ["*.sesamestats.com"] }, { name: "Kargo", category: "marketing", domains: ["*.kargo.com"] }, { name: "KARTE", company: "Plaid", homepage: "https://karte.io/", category: "marketing", domains: ["*.karte.io"] }, { name: "Kauli", category: "ad", domains: ["*.kau.li"] }, { name: "Keen", company: "Keen", homepage: "https://keen.io/", category: "analytics", domains: ["*.keen.io", "d26b395fwzu5fz.cloudfront.net"] }, { name: "Kelkoo", category: "hosting", domains: ["*.kelkoo.com"] }, { name: "Kenshoo", category: "marketing", domains: ["*.xg4ken.com"] }, { name: "Key CDN", category: "utility", domains: ["*.kxcdn.com"] }, { name: "Keynote", company: "Dynatrace", category: "analytics", domains: ["*.keynote.com"] }, { name: "Keywee", category: "ad", domains: ["*.keywee.co"] }, { name: "Kiosked", category: "ad", domains: ["*.kiosked.com"] }, { name: "Klarna", category: "utility", domains: ["*.klarna.com"] }, { name: "Klaviyo", category: "ad", domains: ["*.klaviyo.com"] }, { name: "Klevu Search", company: "Klevu", category: "utility", domains: ["*.klevu.com"] }, { name: "Klick2Contact", category: "customer-success", domains: ["*.klick2contact.com"] }, { name: "Knight Lab", company: "Northwestern University", category: "utility", domains: ["*.knightlab.com"] }, { name: "Kodajo", category: "other", domains: ["*.kodajo.com"] }, { name: "Komoona", category: "ad", domains: ["*.komoona.com"] }, { name: "Korrelate", company: "JD Power", category: "analytics", domains: ["*.korrelate.net"] }, { name: "LKQD", category: "ad", domains: ["*.lkqd.net"] }, { name: "Layer0", category: "cdn", domains: ["*.layer0.co"] }, { name: "Layershift", category: "hosting", domains: ["109.109.138.174"] }, { name: "Lead Forensics", category: "ad", domains: ["*.200summit.com", "*.baw5tracker.com", "*.business-path-55.com", "*.bux1le001.com", "*.central-core-7.com", "*.direct-azr-78.com", "*.explore-123.com", "*.forensics1000.com", "*.gldsta-02-or.com", "*.green-bloc9.com", "*.lansrv040.com", "*.lead-123.com", "*.leadforensics.com", "*.mavic852.com", "*.mon-com-net.com", "*.peak-ip-54.com", "*.snta0034.com", "*.svr-prc-01.com", "*.syntace-094.com", "*.tghbn12.com", "*.trail-web.com", "*.web-01-gbl.com", "*.web-cntr-07.com", "*.trackdiscovery.net"] }, { name: "Lead Intelligence", company: "Magnetise Solutions", category: "ad", domains: ["*.leadintelligence.co.uk"] }, { name: "LeadLander", category: "analytics", domains: ["*.formalyzer.com", "*.trackalyzer.com"] }, { name: "Leaflet", category: "utility", domains: ["*.leafletjs.com"] }, { name: "LeasdBoxer", company: "LeadBoxer", category: "ad", domains: ["*.leadboxer.com"] }, { name: "LeaseWeb", homepage: "https://www.leaseweb.com/", category: "cdn", domains: ["*.lswcdn.net", "*.leasewebcdn.com"] }, { name: "Leboncoin", category: "content", domains: ["*.leboncoin.fr"] }, { name: "Lengow", category: "hosting", domains: ["*.lengow.com"] }, { name: "Lessbuttons", category: "social", domains: ["*.lessbuttons.com"] }, { name: "Letter Press", category: "ad", domains: ["*.getletterpress.com"] }, { name: "Level 3 Communications", category: "utility", domains: ["footprint.net"] }, { name: "Level3", category: "other", domains: ["secure.footprint.net"] }, { name: "Lifestreet Media", category: "social", domains: ["*.lfstmedia.com"] }, { name: "LiftSuggest", category: "analytics", domains: ["d2blwevgjs7yom.cloudfront.net"] }, { name: "Ligatus", category: "ad", domains: ["*.ligadx.com"] }, { name: "LightStep", category: "analytics", domains: ["*.lightstep.com"] }, { name: "LightWidget", category: "utility", domains: ["*.lightwidget.com"] }, { name: "Likelihood", company: "LIkeihood", category: "hosting", domains: ["*.likelihood.com"] }, { name: "LikeShop", company: "Dash Hudson", category: "content", domains: ["likeshop.me"] }, { name: "LINE Corporation", category: "ad", domains: ["*.line-scdn.net", "*.line.me"] }, { name: "Linkcious", category: "analytics", domains: ["*.linkcious.com"] }, { name: "Linking Mobile", category: "ad", domains: ["*.linkingmobile.com"] }, { name: "LittleData", category: "analytics", homepage: "https://www.littledata.io/", domains: ["*.littledata.io"] }, { name: "LiveBurst", category: "ad", domains: ["*.liveburst.com"] }, { name: "LiveClicker", category: "ad", domains: ["*.liveclicker.net"] }, { name: "LiveHelpNow", category: "customer-success", domains: ["*.livehelpnow.net"] }, { name: "LiveInternet", category: "analytics", domains: ["*.yadro.ru"] }, { name: "LiveJournal", category: "social", domains: ["*.livejournal.com", "*.livejournal.net"] }, { name: "LivePerson", category: "customer-success", homepage: "https://www.liveperson.com/", domains: ["*.liveperson.com", "*.look.io", "*.liveperson.net", "*.lpsnmedia.net"] }, { name: "LiveRail", company: "Facebook", category: "ad", domains: ["*.liverail.com", "*.lrcdn.net"] }, { name: "LiveTex", category: "customer-success", domains: ["*.livetex.ru"] }, { name: "Livefyre", category: "content", domains: ["*.fyre.co", "*.livefyre.com"] }, { name: "Living Map Company", category: "utility", domains: ["*.livingmap.com"] }, { name: "Local World", category: "content", domains: ["*.thelocalpeople.co.uk"] }, { name: "LockerDome", category: "analytics", domains: ["*.lockerdome.com"] }, { name: "Logentries", company: "Rapid", category: "utility", domains: ["*.logentries.com"] }, { name: "Logicalis", category: "analytics", domains: ["*.trovus.co.uk"] }, { name: "LoginRadius", company: "LoginRadius", homepage: "https://www.loginradius.com/", category: "ad", domains: ["*.loginradius.com", "*.lrcontent.com"] }, { name: "LongTail Ad Solutions", category: "ad", domains: ["*.jwpcdn.com", "*.jwplatform.com", "*.jwplayer.com", "*.jwpltx.com", "*.jwpsrv.com", "*.longtailvideo.com"] }, { name: "Loop Commerce", category: "other", domains: ["*.loopassets.net"] }, { name: "Loop11", category: "analytics", domains: ["*.loop11.com"] }, { name: "LoopMe", category: "ad", domains: ["*.loopme.biz", "*.loopme.com", "*.vntsm.com", "*.loopme.me"] }, { name: "Looper", category: "content", domains: ["*.looper.com"] }, { name: "Loyalty Point", category: "ad", domains: ["*.loyaltypoint.pl"] }, { name: "LoyaltyLion", category: "ad", domains: ["*.loyaltylion.com", "*.loyaltylion.net", "dg1f2pfrgjxdq.cloudfront.net"] }, { name: "Luma Tag", category: "analytics", domains: ["*.lumatag.co.uk"] }, { name: "Lumesse", category: "content", domains: ["*.recruitmentplatform.com"] }, { name: "Luminate", category: "ad", domains: ["*.luminate.com"] }, { name: "Lynchpin Analytics", category: "analytics", domains: ["*.lypn.net"] }, { name: "Lyris", category: "ad", domains: ["*.clicktracks.com"] }, { name: "Lytics", category: "ad", domains: ["*.lytics.io"] }, { name: "MEC WebTrack", company: "MEC", category: "ad", domains: ["*.e-webtrack.net"] }, { name: "MECLABS Institute", category: "analytics", domains: ["*.meclabs.com", "*.meclabsdata.com"] }, { name: "MLveda", category: "utility", domains: ["*.mlveda.com"] }, { name: "Macromill", company: "Macromill", category: "analytics", homepage: "https://group.macromill.com/", domains: ["*.macromill.com"] }, { name: "Macropod BugHerd", company: "Macropod", category: "utility", domains: ["*.bugherd.com"] }, { name: "Madison Logic", category: "marketing", domains: ["*.ml314.com"] }, { name: "Madmetrics", company: "Keyade", category: "analytics", domains: ["*.keyade.com"] }, { name: "Magnetic", category: "ad", domains: ["*.domdex.com", "d3ezl4ajpp2zy8.cloudfront.net"] }, { name: "Magnetic Platform", company: "Magnetic", category: "ad", domains: ["*.magnetic.is"] }, { name: "MailMunch", category: "ad", domains: ["*.mailmunch.co"] }, { name: "MailPlus", category: "ad", domains: ["*.mailplus.nl"] }, { name: "Mapbox", category: "utility", domains: ["*.mapbox.com"] }, { name: "Maptive", category: "utility", domains: ["*.maptive.com"] }, { name: "Marcaria.com", category: "other", domains: ["*.gooo.al"] }, { name: "Marchex", category: "analytics", domains: ["*.voicestar.com", "*.marchex.io"] }, { name: "Mark and Mini", category: "ad", domains: ["*.markandmini.com"] }, { name: "Marker", category: "utility", domains: ["*.marker.io"] }, { name: "Marketing Dashboards", company: "GroupM", category: "analytics", domains: ["*.m-decision.com"] }, { name: "Marketizator", category: "analytics", domains: ["*.marketizator.com"] }, { name: "Marketplace Web Service", company: "Amazon", category: "other", domains: ["*.ssl-images-amazon.com"] }, { name: "Mashable", category: "social", domains: ["*.mshcdn.com"] }, { name: "MatchWork", category: "utility", domains: ["*.matchwork.com"] }, { name: "MathJax", category: "utility", domains: ["*.mathjax.org"] }, { name: "Mather Economics", category: "analytics", domains: ["*.matheranalytics.com"] }, { name: "MaxCDN Enterprise", company: "MaxCDN", category: "utility", domains: ["*.netdna-cdn.com", "*.netdna-ssl.com"] }, { name: "MaxMind", category: "utility", domains: ["*.maxmind.com"] }, { name: "MaxPoint Interactive", category: "ad", domains: ["*.mxptint.net"] }, { name: "Maxsi", category: "analytics", domains: ["*.evisitanalyst.com"] }, { name: "Maxymiser", category: "analytics", domains: ["*.maxymiser.net, maxymiser.hs.llnwd.net"] }, { name: "McAffee", category: "utility", domains: ["*.mcafeesecure.com", "*.scanalert.com"] }, { name: "Measured", category: "analytics", domains: ["*.measured.com"], homepage: "https://www.measured.com/" }, { name: "Media IQ", category: "analytics", domains: ["*.mediaiqdigital.com"] }, { name: "Media Management Technologies", category: "ad", domains: ["*.speedshiftmedia.com"] }, { name: "Media Temple", category: "hosting", domains: ["*.goodlayers2.com"] }, { name: "Mediabong", category: "ad", domains: ["*.mediabong.net"] }, { name: "Mediahawk", category: "analytics", domains: ["*.mediahawk.co.uk"] }, { name: "Mediahub", category: "ad", domains: ["*.hubverifyandoptimize.com", "*.projectwatchtower.com"] }, { name: "Mediasyndicator", category: "ad", domains: ["*.creativesyndicator.com"] }, { name: "Medium", category: "content", domains: ["*.medium.com"] }, { name: "Meetrics", category: "ad", domains: ["*.de.com", "*.meetrics.net", "*.mxcdn.net"] }, { name: "Mega", company: "Mega Information Technology", category: "other", domains: ["*.mgcdn.com"] }, { name: "Melt", category: "ad", domains: ["*.meltdsp.com", "*.mesp.com"] }, { name: "Meltwater Group", category: "customer-success", domains: ["*.meltwaternews.com"] }, { name: "Meme", category: "ad", domains: ["*.viewwonder.com"] }, { name: "MentAd", category: "ad", domains: ["*.mentad.com"] }, { name: "Mention Me", category: "ad", domains: ["*.mention-me.com"] }, { name: "Merchant Equipment Store", category: "utility", domains: ["*.merchantequip.com"] }, { name: "Merchenta", category: "customer-success", domains: ["*.merchenta.com"] }, { name: "Merkle Digital Data Exchange", company: "Merkle", category: "ad", domains: ["*.brilig.com"] }, { name: "Merkle Paid Search", company: "Merkle", category: "ad", domains: ["*.rkdms.com"] }, { name: "Met Office", category: "content", domains: ["*.metoffice.gov.uk"] }, { name: "Meta Broadcast", category: "social", domains: ["*.metabroadcast.com"] }, { name: "Michael Associates", category: "ad", domains: ["*.checktestsite.com"] }, { name: "Michelin", category: "content", domains: ["*.viamichelin.com"] }, { name: "Microad", category: "ad", domains: ["*.microad.jp"] }, { name: "Microsoft Certificate Services", company: "Microsoft", category: "utility", domains: ["*.msocsp.com"] }, { name: "Microsoft Hosted Libs", company: "Microsoft", category: "cdn", domains: ["*.aspnetcdn.com"] }, { name: "Microsoft XBox Live", company: "Microsoft", category: "marketing", domains: ["*.xboxlive.com"] }, { name: "Mightypop", category: "ad", domains: ["*.mightypop.ca"] }, { name: "Mika Tuupola", category: "utility", domains: ["*.appelsiini.net"] }, { name: "Millennial Media", category: "ad", domains: ["*.jumptap.com"] }, { name: "Mirror Image Internet", category: "utility", domains: ["*.miisolutions.net"] }, { name: "Mobify", category: "utility", domains: ["*.mobify.com", "*.mobify.net"] }, { name: "Mobile Nations", category: "social", domains: ["*.mobilenations.com"] }, { name: "Mobivate", category: "ad", domains: ["*.mobivatebulksms.com"] }, { name: "Momondo", category: "content", domains: ["*.momondo.dk"] }, { name: "Momondo Group", category: "content", domains: ["*.momondogrouo.com", "*.momondogroup.com"] }, { name: "Monarch Ads", category: "ad", domains: ["*.monarchads.com"] }, { name: "Monetate", category: "analytics", domains: ["*.monetate.net"] }, { name: "MonetizeMore", category: "ad", domains: ["*.m2.ai"] }, { name: "Monitor", company: "Econda", category: "analytics", domains: ["*.econda-monitor.de"] }, { name: "Monkey Frog Media", category: "content", domains: ["*.monkeyfrogmedia.com"] }, { name: "Monotype", category: "cdn", domains: ["*.fonts.com", "*.fonts.net"] }, { name: "Moore-Wilson", category: "ad", domains: ["*.mwdev.co.uk"] }, { name: "Moovweb", category: "utility", domains: ["*.moovweb.net"] }, { name: "Mopinion", category: "analytics", domains: ["*.mopinion.com"] }, { name: "MotionPoint", category: "other", domains: ["*.convertlanguage.com"] }, { name: "Mouse3K", category: "analytics", domains: ["*.mouse3k.com"] }, { name: "MouseStats", category: "analytics", domains: ["*.mousestats.com"] }, { name: "Mouseflow", homepage: "https://mouseflow.com/", category: "analytics", domains: ["*.mouseflow.com"] }, { name: "Movable Ink", category: "analytics", domains: ["*.micpn.com"] }, { name: "MovingIMAGE24", category: "content", domains: ["*.edge-cdn.net"] }, { name: "Moxielinks", category: "ad", domains: ["*.moxielinks.com"] }, { name: "Moz Recommended Companies", company: "Moz", category: "analytics", domains: ["d2eeipcrcdle6.cloudfront.net"] }, { name: "Mozilla", category: "utility", domains: ["*.mozilla.org"] }, { name: "Multiview", category: "content", domains: ["*.multiview.com", "*.track-mv.com"] }, { name: "Mux", category: "analytics", domains: ["*.litix.io"] }, { name: "MyAds", company: "MyBuys", category: "analytics", domains: ["*.veruta.com"] }, { name: "MyBuys", category: "analytics", domains: ["*.mybuys.com"] }, { name: "MyFonts", category: "cdn", domains: ["*.myfonts.net"] }, { name: "MyRegistry", category: "other", domains: ["*.myregistry.com"] }, { name: "MySpace", company: "Specific Media", category: "social", domains: ["*.myspace.com"] }, { name: "Mynewsdesk", category: "utility", domains: ["*.mynewsdesk.com"] }, { name: "NAVIS", category: "content", domains: ["*.navistechnologies.info"] }, { name: "NCC Group Real User Monitoring", company: "NCC Group", category: "analytics", domains: ["*.nccgroup-webperf.com"] }, { name: "NEORY Marketing Cloud", company: "NEORY", category: "marketing", domains: ["*.ad-srv.net"] }, { name: "Nanigans", category: "ad", domains: ["*.nanigans.com"] }, { name: "Nano Interactive", category: "ad", domains: ["*.audiencemanager.de"] }, { name: "Nanorep", company: "Nanorep Technologies", category: "customer-success", domains: ["*.nanorep.com"] }, { name: "Narrative", category: "ad", domains: ["*.narrative.io"] }, { name: "Native Ads", category: "ad", domains: ["*.nativeads.com"] }, { name: "Nativo", category: "ad", domains: ["*.postrelease.com"] }, { name: "Navegg", category: "ad", domains: ["*.navdmp.com"] }, { name: "NaviStone", category: "ad", domains: ["*.murdoog.com"] }, { name: "Naytev", category: "analytics", domains: ["*.naytev.com"] }, { name: "Needle", category: "analytics", domains: ["*.needle.com"] }, { name: "Neiman Marcus", category: "content", domains: ["*.ctscdn.com"] }, { name: "Nend", category: "ad", domains: ["*.nend.net"] }, { name: "Neodata", category: "ad", domains: ["*.neodatagroup.com"] }, { name: "Net Applications", category: "analytics", domains: ["*.hitsprocessor.com"] }, { name: "Net Reviews", category: "analytics", domains: ["*.avis-verifies.com"] }, { name: "NetAffiliation", company: "Kwanco", category: "ad", domains: ["*.metaffiliation.com"] }, { name: "NetDirector", company: "G-Forces Web Management", category: "other", domains: ["*.netdirector.co.uk"] }, { name: "NetFlix", category: "content", domains: ["*.nflxext.com", "*.nflximg.net"] }, { name: "Nielsen NetRatings SiteCensus", company: "The Nielsen Company", homepage: "http://www.nielsen-online.com/intlpage.html", category: "analytics", domains: ["*.imrworldwide.com"] }, { name: "NetSeer", category: "ad", domains: ["*.netseer.com", "*.ns-cdn.com"] }, { name: "NetShelter", company: "Ziff Davis Tech", category: "ad", domains: ["*.netshelter.net"] }, { name: "Netmining", company: "Ignition One", category: "ad", domains: ["*.netmng.com"] }, { name: "Netop", category: "customer-success", domains: ["*.netop.com"] }, { name: "Network Solutions", category: "utility", domains: ["*.netsolssl.com", "*.networksolutions.com"] }, { name: "Neustar AdAdvisor", company: "Neustar", category: "ad", domains: ["*.adadvisor.net"] }, { name: "New Approach Media", category: "ad", domains: ["*.newapproachmedia.co.uk"] }, { name: "NewShareCounts", category: "social", domains: ["*.newsharecounts.com"] }, { name: "News", category: "social", domains: ["*.news.com.au", "*.newsanalytics.com.au", "*.newsapi.com.au", "*.newscdn.com.au", "*.newsdata.com.au", "*.newsdiscover.com.au", "*.news-static.com"] }, { name: "Newsquest", category: "content", domains: ["*.newsquestdigital.co.uk"] }, { name: "Newzulu", category: "content", domains: ["*.filemobile.com", "*.projects.fm"] }, { name: "Nexcess.Net", category: "hosting", domains: ["*.nexcesscdn.net"] }, { name: "Nexstar Media Group", category: "ad", domains: ["*.yashi.com"] }, { name: "NextPerf", company: "Rakuten Marketing", category: "ad", domains: ["*.nxtck.com"] }, { name: "Nine.com.au", company: "Nine Digital", category: "content", domains: ["*.9msn.com.au"] }, { name: "NitroSell", category: "hosting", domains: ["*.nitrosell.com"] }, { name: "Nochex", category: "utility", domains: ["*.nochex.com"] }, { name: "Northern &amp; Shell Media Group", category: "content", domains: ["*.northernandshell.co.uk"] }, { name: "Nosto", category: "analytics", domains: ["*.nosto.com"] }, { name: "Now Interact", category: "analytics", domains: ["*.nowinteract.com"] }, { name: "Numberly", company: "1000mercis", category: "ad", domains: ["*.mmtro.com", "*.nzaza.com"] }, { name: "NyaConcepts", category: "analytics", domains: ["*.xclusive.ly"] }, { name: "O2", category: "other", domains: ["*.o2.co.uk"] }, { name: "GoDaddy", homepage: "https://www.godaddy.com/", category: "utility", domains: ["*.godaddy.com", "*.wsimg.com"] }, { name: "ObjectPlanet", category: "analytics", domains: ["*.easypolls.net"] }, { name: "OhMyAd", category: "ad", domains: ["*.ohmyad.co"] }, { name: "Okas Concepts", category: "utility", domains: ["*.okasconcepts.com"] }, { name: "Okta", category: "analytics", domains: ["*.okta.com"] }, { name: "Olapic", category: "content", domains: ["*.photorank.me"] }, { name: "Ometria", category: "analytics", domains: ["*.ometria.com"] }, { name: "Omniconvert", category: "analytics", domains: ["*.omniconvert.com", "d2tgfbvjf3q6hn.cloudfront.net", "d3vbj265bmdenw.cloudfront.net"] }, { name: "Omniroot", company: "Verizon", category: "utility", domains: ["*.omniroot.com"] }, { name: "OnAudience", company: "Cloud Technologies", category: "ad", domains: ["*.onaudience.com"] }, { name: "OnScroll", category: "ad", domains: ["*.onscroll.com"] }, { name: "OnState", category: "ad", domains: ["*.onstate.co.uk"] }, { name: "OnYourMap", category: "utility", domains: ["*.onyourmap.com"] }, { name: "One by AOL", company: "AOL", category: "ad", domains: ["*.adtechjp.com", "*.adtech.de"] }, { name: "One by AOL:Mobile", company: "AOL", category: "ad", domains: ["*.nexage.com"] }, { name: "OneAll", category: "analytics", domains: ["*.oneall.com"] }, { name: "OneSoon", category: "analytics", domains: ["*.adalyser.com"] }, { name: "OneTag", category: "ad", domains: ["*.onetag-sys.com"] }, { name: "Onet", category: "ad", domains: ["*.onet.pl"] }, { name: "Online Rewards", company: "Mastercard", category: "ad", domains: ["*.loyaltygateway.com"] }, { name: "Online republic", category: "content", domains: ["*.imallcdn.net"] }, { name: "Ooyala", category: "ad", domains: ["*.ooyala.com"] }, { name: "OpenTable", company: "Priceline Group", category: "content", domains: ["*.opentable.com", "*.opentable.co.uk", "*.toptable.co.uk"] }, { name: "OpenX Ad Exchange", company: "OpenX Technologies", category: "ad", domains: ["*.liftdna.com"] }, { name: "Opinion Stage", category: "analytics", domains: ["*.opinionstage.com"] }, { name: "OpinionBar", category: "analytics", domains: ["*.opinionbar.com"] }, { name: "Opta", company: "Perform Group", category: "content", domains: ["*.opta.net"] }, { name: "OptiMonk", category: "ad", domains: ["*.optimonk.com"] }, { name: "Optilead", category: "analytics", domains: ["*.dyn-img.com", "*.leadcall.co.uk", "*.optilead.co.uk"] }, { name: "Optimatic", category: "ad", domains: ["*.optimatic.com"] }, { name: "Optimise Media Group", category: "utility", domains: ["*.omguk.com"] }, { name: "Optimost", company: "OpenText", category: "ad", domains: ["*.optimost.com"] }, { name: "Optimove", company: "Mobius Solutions", category: "analytics", domains: ["*.optimove.net"] }, { name: "Optorb", category: "ad", domains: ["*.optorb.com"] }, { name: "Oracle", category: "marketing", domains: ["*.custhelp.com", "*.eloqua.com", "*.en25.com", "*.estara.com", "*.instantservice.com"] }, { name: "Oracle Recommendations On Demand", company: "Oracle", category: "analytics", domains: ["*.atgsvcs.com"] }, { name: "Oracle Responsys", company: "Oracle", category: "marketing", domains: ["*.adrsp.net", "*.responsys.net"] }, { name: "Order Security-VOID", company: "Order Security", category: "analytics", domains: ["*.order-security.com"] }, { name: "Oriel", category: "ad", domains: ["*.oriel.io"] }, { name: "Outbrain", homepage: "https://www.outbrain.com/", category: "ad", domains: ["*.outbrain.com", "*.outbrainimg.com", "*.visualrevenue.com"] }, { name: "OverStream", company: "Coull", category: "ad", domains: ["*.coull.com"] }, { name: "Overdrive", category: "content", domains: ["*.contentreserve.com"] }, { name: "Overstock", category: "utility", domains: ["*.ostkcdn.com"] }, { name: "OwnerIQ", category: "ad", domains: ["*.owneriq.net"] }, { name: "OzCart", category: "utility", domains: ["*.ozcart.com.au"] }, { name: "Ozone Media", category: "ad", domains: ["*.adadyn.com"] }, { name: "Loqate", company: "Loqate", category: "other", domains: ["*.pcapredict.com", "*.postcodeanywhere.co.uk"] }, { name: "PEER 1 Hosting", category: "hosting", domains: ["*.peer1.com"] }, { name: "PERFORM", category: "content", domains: ["*.performgroup.com"] }, { name: "PICnet", category: "hosting", domains: ["*.nonprofitsoapbox.com"] }, { name: "Pacnet", company: "Telstra", category: "other", domains: ["*.cdndelivery.net"] }, { name: "Pagefair", category: "ad", domains: ["*.pagefair.com", "*.pagefair.net"] }, { name: "Pagely", category: "other", domains: ["*.optnmstr.com"] }, { name: "Pagesuite", category: "ad", domains: ["*.pagesuite-professional.co.uk"] }, { name: "Pardot", category: "marketing", domains: ["*.pardot.com"] }, { name: "Parse.ly", category: "analytics", domains: ["*.parsely.com", "d1z2jf7jlzjs58.cloudfront.net"] }, { name: "Pay per Click", company: "Eysys", category: "ad", domains: ["*.eysys.com"] }, { name: "PayPal Ads", category: "ad", domains: ["*.where.com"] }, { name: "Peaks & Pies", category: "analytics", domains: ["*.bunchbox.co"] }, { name: "PebblePost", category: "ad", domains: ["*.pbbl.co"] }, { name: "Peerius", category: "analytics", domains: ["*.peerius.com"] }, { name: "Peermap", company: "IMRG", category: "analytics", domains: ["peermapcontent.affino.com"] }, { name: "Penske Media", category: "content", domains: ["*.pmc.com"] }, { name: "Penton", category: "utility", domains: ["*.pisces-penton.com"] }, { name: "Pepper", category: "ad", domains: ["*.peppercorp.com"] }, { name: "Perfect Audience", company: "Marin Software", category: "ad", domains: ["*.prfct.co", "*.marinsm.com", "*.perfectaudience.com"] }, { name: "Perfect Market", category: "ad", domains: ["*.perfectmarket.com"] }, { name: "Perfect Privacy", category: "other", domains: ["*.suitesmart.com"] }, { name: "Perform Group", category: "content", domains: ["*.performfeeds.com", "*.premiumtv.co.uk"] }, { name: "Performio", category: "ad", domains: ["*.performax.cz"] }, { name: "PerimeterX Bot Defender", company: "PerimeterX", category: "utility", domains: ["*.perimeterx.net", "*.pxi.pub"] }, { name: "Periscope", category: "content", domains: ["*.periscope.tv"] }, { name: "Permutive", category: "ad", domains: ["*.permutive.com", "d3alqb8vzo7fun.cloudfront.net"] }, { name: "Petametrics", category: "analytics", domains: ["*.petametrics.com"] }, { name: "PhotoBucket", category: "content", domains: ["*.photobucket.com"] }, { name: "Picreel", category: "analytics", domains: ["*.pcrl.co", "*.picreel.com"] }, { name: "Pictela (AOL)", category: "analytics", domains: ["*.pictela.net"] }, { name: "PistonHeads", category: "social", domains: ["*.pistonheads.com"] }, { name: "Piwik", category: "analytics", domains: ["*.drtvtracker.com", "*.piwikpro.com", "*.raac33.net"] }, { name: "Pixalate", category: "utility", domains: ["*.adrta.com"] }, { name: "Pixlee", category: "social", domains: ["*.pixlee.com"] }, { name: "Placed", category: "analytics", domains: ["*.placed.com"] }, { name: "Planning-inc", category: "analytics", domains: ["*.planning-inc.co.uk"] }, { name: "PlayAd Media Group", category: "ad", domains: ["*.youplay.se"] }, { name: "Playbuzz", category: "hosting", domains: ["*.playbuzz.com"] }, { name: "Pleenq", category: "ad", domains: ["*.pleenq.com"] }, { name: "Plentific", category: "content", domains: ["*.plentific.com"] }, { name: "PluginDetect", category: "other", domains: ["dtlilztwypawv.cloudfront.net"] }, { name: "Po.st", company: "RadiumOne", category: "utility", domains: ["*.po.st"] }, { name: "Pointpin", category: "utility", domains: ["*.pointp.in"] }, { name: "Pointroll (Garnett)", category: "ad", domains: ["*.pointroll.com"] }, { name: "Polar", homepage: "https://polar.me/", category: "ad", domains: ["*.polarmobile.ca", "*.mediaeverywhere.com", "*.mediavoice.com", "*.plrsrvcs.com", "*.polarcdn-engine.com", "*.polarcdn-meraxes.com", "*.polarcdn-pentos.com", "*.polarcdn-static.com", "*.polarcdn-terrax.com", "*.polarcdn.com", "*.polarmobile.com", "*.poweredbypolar.com", "*.mediaconductor.me", "*.polaracademy.me"] }, { name: "PollDaddy (Automattic)", category: "ad", domains: ["static.polldaddy.com", "*.poll.fm"] }, { name: "Polldaddy", company: "Automattic", category: "analytics", domains: ["polldaddy.com", "*.polldaddy.com"] }, { name: "Polyfill service", company: "Polyfill.io", category: "other", domains: ["*.polyfill.io"] }, { name: "MegaPopAds", category: "ad", domains: ["*.megapopads.com"] }, { name: "Populis", category: "ad", domains: ["*.populisengage.com"] }, { name: "Postimage.org", category: "content", domains: ["*.postimg.org"] }, { name: "PowerFront", category: "hosting", domains: ["*.inside-graph.com"] }, { name: "PowerReviews", category: "analytics", domains: ["*.powerreviews.com"] }, { name: "Powerlinks.com", category: "ad", domains: ["*.powerlinks.com"] }, { name: "Press+", category: "ad", domains: ["*.pipol.com", "*.ppjol.com", "*.ppjol.net"] }, { name: "PressArea", category: "utility", domains: ["*.pressarea.com"] }, { name: "Pretio Interactive", category: "ad", domains: ["*.pretio.in"] }, { name: "Prezi", category: "utility", domains: ["*.prezi.com"] }, { name: "PriceGrabber", category: "content", domains: ["*.pgcdn.com", "*.pricegrabber.com"] }, { name: "PriceRunner", category: "content", domains: ["*.pricerunner.com"] }, { name: "PrintFriendly", category: "utility", domains: ["*.printfriendly.com"] }, { name: "Privy", category: "ad", domains: ["*.privy.com", "*.privymktg.com"] }, { name: "Proclivity Media", category: "analytics", domains: ["*.pswec.com"] }, { name: "Profitshare", category: "ad", domains: ["*.profitshare.ro"] }, { name: "Programattik", category: "ad", domains: ["*.programattik.com"] }, { name: "Proper Media", category: "content", domains: ["*.proper.io"] }, { name: "Property Week", category: "content", domains: ["*.propertyweek.com"] }, { name: "Provide Support", category: "customer-success", domains: ["*.providesupport.com"] }, { name: "Proweb Uk", category: "hosting", domains: ["*.proweb.net"] }, { name: "Proximic (ComScore)", category: "ad", domains: ["*.proximic.com"] }, { name: "Psyma", category: "ad", domains: ["*.psyma.com"] }, { name: "PubFactory", company: "Safari Books Online", category: "content", domains: ["*.pubfactory.com"] }, { name: "PubNation", category: "ad", domains: ["*.pubnation.com"] }, { name: "Publicidad.net", category: "ad", domains: ["*.publicidad.tv"] }, { name: "PublishThis", company: "Ultra Unlimited", category: "ad", domains: ["*.publishthis.com"] }, { name: "Pulse Insights", category: "analytics", domains: ["*.pulseinsights.com"] }, { name: "Pulsepoint", category: "marketing", domains: ["*.displaymarketplace.com"] }, { name: "Purch", category: "ad", domains: ["*.bestofmedia.com", "*.purch.com"] }, { name: "Pure Chat", category: "customer-success", domains: ["*.purechat.com"] }, { name: "PushCrew", category: "ad", domains: ["*.pushcrew.com"] }, { name: "Q1Media", category: "ad", domains: ["*.q1media.com", "*.q1mediahydraplatform.com"] }, { name: "Qbase Software Development", category: "hosting", domains: ["*.smartwebportal.co.uk"] }, { name: "Qeryz", category: "analytics", domains: ["*.qeryz.com"] }, { name: "Qode Interactive", category: "hosting", domains: ["*.qodeinteractive.com"] }, { name: "Qrius", category: "social", domains: ["*.qrius.me"] }, { name: "Qualaroo", category: "analytics", domains: ["*.qualaroo.com"] }, { name: "Qualtrics", category: "analytics", domains: ["*.qualtrics.com"] }, { name: "Qubit", company: "Qubit", category: "analytics", domains: ["*.qubit.com", "*.qutics.com", "d3c3cq33003psk.cloudfront.net", "*.goqubit.com", "*.qubitproducts.com"] }, { name: "Qubit Deliver", company: "Qubit", category: "analytics", domains: ["d1m54pdnjzjnhe.cloudfront.net", "d22rutvoghj3db.cloudfront.net", "dd6zx4ibq538k.cloudfront.net"] }, { name: "QuestionPro", category: "analytics", domains: ["*.questionpro.com"] }, { name: "Queue-it", category: "other", domains: ["*.queue-it.net"] }, { name: "QuinStreet", category: "ad", domains: ["*.Quinstreet.com", "*.b2btechleadform.com", "*.qnsr.com", "*.qsstats.com"] }, { name: "QuoVadis", category: "utility", domains: ["*.quovadisglobal.com"] }, { name: "Qzzr", category: "analytics", domains: ["*.movementventures.com", "*.qzzr.com"] }, { name: "RapidAPI", category: "utility", domains: ["*.rapidapi.com"] }, { name: "RCS Media Group", category: "ad", domains: ["*.rcsadv.it"] }, { name: "REVIVVE", category: "ad", domains: ["*.revivve.com"] }, { name: "RSSinclude", category: "social", domains: ["*.rssinclude.com"] }, { name: "RTB House AdPilot", company: "RTB House", category: "ad", domains: ["*.erne.co", "*.creativecdn.com"] }, { name: "RTB Media", category: "ad", domains: ["*.rtb-media.me"] }, { name: "RUN", category: "ad", domains: ["*.runadtag.com", "*.rundsp.com"] }, { name: "Rackspace", category: "hosting", domains: ["*.rackcdn.com", "*.rackspacecloud.com", "*.raxcdn.com", "*.websitetestlink.com"] }, { name: "RadiumOne", category: "ad", domains: ["*.gwallet.com", "*.r1-cdn.net"] }, { name: "Rakuten DC Storm", company: "Rakuten", category: "analytics", domains: ["*.dc-storm.com", "*.h4k5.com", "*.stormiq.com"] }, { name: "Rakuten LinkShare", company: "Rakuten", category: "ad", domains: ["*.linksynergy.com"] }, { name: "Rakuten Marketing", company: "Rakuten", category: "ad", domains: ["*.rakuten-static.com", "*.rmtag.com", "tag.rmp.rakuten.com"] }, { name: "Rakuten MediaForge", company: "Rakuten", category: "ad", domains: ["*.mediaforge.com"] }, { name: "Rambler", company: "Rambler & Co", category: "utility", domains: ["*.rambler.ru"] }, { name: "Ranker", category: "content", domains: ["*.ranker.com", "*.rnkr-static.com"] }, { name: "Ravelin", category: "utility", domains: ["*.ravelin.com"] }, { name: "Raygun", category: "utility", domains: ["*.raygun.io", "*.rapidzebra.io"] }, { name: "ReCollect", category: "utility", domains: ["*.recollect.net"] }, { name: "ReSRC", category: "utility", domains: ["*.resrc.it"] }, { name: "ReTargeter", category: "ad", domains: ["*.retargeter.com"] }, { name: "Reach Group", category: "ad", domains: ["*.redintelligence.net"] }, { name: "ReachDynamics", category: "ad", domains: ["*.rdcdn.com"] }, { name: "ReachForce", category: "ad", domains: ["*.reachforce.com"] }, { name: "ReachLocal", category: "ad", domains: ["*.rtrk.co.nz"] }, { name: "ReachMee", category: "content", domains: ["*.reachmee.com"] }, { name: "Reactful", category: "analytics", domains: ["*.reactful.com"] }, { name: "Realtime", company: "internet business technologies", category: "utility", domains: ["*.realtime.co"] }, { name: "Realtime Media (Brian Communications)", category: "ad", domains: ["*.rtm.com"] }, { name: "Realtime Targeting", category: "ad", domains: ["*.idtargeting.com"] }, { name: "Realytics", category: "analytics", domains: ["dcniko1cv0rz.cloudfront.net", "*.realytics.net"] }, { name: "RebelMouse", category: "ad", domains: ["*.rebelmouse.com", "*.rbl.ms"] }, { name: "Receiptful", category: "utility", domains: ["*.receiptful.com"] }, { name: "Recite Me", category: "other", domains: ["*.reciteme.com"] }, { name: "RecoBell", category: "analytics", domains: ["*.recobell.io"] }, { name: "Recommend", category: "analytics", domains: ["*.recommend.pro"] }, { name: "Red Eye International", category: "ad", domains: ["*.pajmc.com"] }, { name: "Redfish Group", category: "ad", domains: ["*.wmps.com"] }, { name: "Reevoo", category: "analytics", domains: ["*.reevoo.com"] }, { name: "Refersion", category: "ad", domains: ["*.refersion.com"] }, { name: "Refined Ads", category: "ad", domains: ["*.refinedads.com"] }, { name: "Reflektion", category: "analytics", domains: ["*.reflektion.com", "d26opx5dl8t69i.cloudfront.net"] }, { name: "Reflow", company: "Scenestealer", category: "ad", domains: ["*.reflow.tv"] }, { name: "Reklama", category: "ad", domains: ["*.o2.pl", "*.wp.pl"] }, { name: "Relevad ReleStar", company: "Relevad", category: "ad", domains: ["*.relestar.com"] }, { name: "Remarketing Pixel", company: "Adsterra Network", category: "ad", domains: ["*.datadbs.com", "*.remarketingpixel.com"] }, { name: "Remintrex", company: "SmartUp Venture", category: "ad", domains: ["*.remintrex.com"] }, { name: "Republer", category: "ad", domains: ["*.republer.com"] }, { name: "Research Now", category: "analytics", domains: ["*.researchgnow.com", "*.researchnow.com"] }, { name: "Research Online", company: "Skills Development Scotland", category: "content", domains: ["*.researchonline.org.uk"] }, { name: "Resonance Insights", category: "analytics", domains: ["*.res-x.com"] }, { name: "Resonate Networks", category: "analytics", domains: ["*.reson8.com"] }, { name: "Response Team", category: "ad", domains: ["*.i-transactads.com"] }, { name: "ResponseTap", category: "analytics", domains: ["*.adinsight.com", "*.responsetap.com"] }, { name: "ResponsiveVoice", category: "other", domains: ["*.responsivevoice.org"] }, { name: "Retention Science", category: "ad", domains: ["*.retentionscience.com", "d1stxfv94hrhia.cloudfront.net"] }, { name: "Revcontent", category: "content", domains: ["*.revcontent.com"] }, { name: "Revee", category: "ad", domains: ["*.revee.com"] }, { name: "Revenue Conduit", category: "utility", domains: ["*.revenueconduit.com"] }, { name: "RevenueMantra", category: "ad", domains: ["*.revenuemantra.com"] }, { name: "Reviews.co.uk", category: "analytics", domains: ["*.reviews.co.uk"] }, { name: "Reviews.io", category: "analytics", domains: ["*.reviews.io"] }, { name: "Revolver Maps", category: "analytics", domains: ["*.revolvermaps.com"] }, { name: "Revv", category: "utility", domains: ["*.revv.co"] }, { name: "RichRelevance", category: "analytics", domains: ["*.richrelevance.com"] }, { name: "RightNow Service Cloud", company: "Oracle", category: "customer-success", domains: ["*.rightnowtech.com", "*.rnengage.com"] }, { name: "Rightster", category: "ad", domains: ["*.ads-creativesyndicator.com"] }, { name: "Riskified", category: "utility", domains: ["*.riskified.com"] }, { name: "Rockerbox", category: "analytics", homepage: "https://www.rockerbox.com/", domains: ["getrockerbox.com"] }, { name: "Rocket Fuel", category: "ad", domains: ["*.rfihub.com", "*.ru4.com", "*.rfihub.net", "*.ad1x.com"] }, { name: "Rollbar", category: "utility", domains: ["*.rollbar.com", "d37gvrvc0wt4s1.cloudfront.net"] }, { name: "RomanCart", category: "utility", domains: ["*.romancart.com"] }, { name: "Rondavu", category: "ad", domains: ["*.rondavu.com"] }, { name: "Roomkey", category: "content", domains: ["*.roomkey.com"] }, { name: "Roost", category: "utility", domains: ["*.goroost.com"] }, { name: "Roxot", category: "ad", domains: ["*.rxthdr.com"] }, { name: "Roxr Software", category: "analytics", domains: ["*.getclicky.com"] }, { name: "Rtoaster", company: "Brainpad", homepage: "https://www.brainpad.co.jp/rtoaster/", category: "marketing", domains: ["*.rtoaster.jp"] }, { name: "Rubikloud.com", category: "analytics", domains: ["*.rubikloud.com"] }, { name: "Ruler Analytics", company: "Ruler", category: "analytics", domains: ["*.nyltx.com", "*.ruleranalytics.com"] }, { name: "Runner", company: "Rambler & Co", category: "content", domains: ["*.begun.ru"] }, { name: "S4M", category: "ad", domains: ["*.sam4m.com"] }, { name: "SAP Hybris Marketing Convert", company: "SAP", category: "ad", domains: ["*.seewhy.com"] }, { name: "SAS Institute", category: "ad", domains: ["*.aimatch.com", "*.sas.com"] }, { name: "SATORI", homepage: "https://satori.marketing/", category: "marketing", domains: ["satori.segs.jp"] }, { name: "SC ShopMania Net SRL", category: "content", domains: ["*.shopmania.com"] }, { name: "SDL Media Manager", company: "SDL", category: "other", domains: ["*.sdlmedia.com"] }, { name: "SFR", category: "other", domains: ["*.sfr.fr"] }, { name: "SLI Systems", category: "utility", domains: ["*.resultslist.com", "*.resultspage.com", "*.sli-spark.com"] }, { name: "SMARTASSISTANT", company: "Smart Information Systems", category: "customer-success", domains: ["*.smartassistant.com"] }, { name: "SMARTSTREAM.TV", category: "ad", domains: ["*.smartstream.tv"] }, { name: "SPX", company: "Smaato", category: "ad", domains: ["*.smaato.net"] }, { name: "Sabio", category: "customer-success", domains: ["*.sabio.co.uk"] }, { name: "Sailthru", category: "analytics", domains: ["*.sail-horizon.com", "*.sail-personalize.com", "*.sail-track.com"] }, { name: "Sailthru Sightlines", company: "Sailthru", category: "marketing", domains: ["*.sailthru.com"] }, { name: "Sajari Pty", category: "utility", domains: ["*.sajari.com"] }, { name: "SaleCycle", category: "ad", domains: ["*.salecycle.com", "d16fk4ms6rqz1v.cloudfront.net", "d22j4fzzszoii2.cloudfront.net", "d30ke5tqu2tkyx.cloudfront.net", "dn1i8v75r669j.cloudfront.net"] }, { name: "Salesforce Live Agent", company: "Salesforce.com", category: "customer-success", domains: ["*.salesforceliveagent.com"] }, { name: "Salesforce.com", category: "ad", domains: ["*.force.com", "*.salesforce.com"] }, { name: "Samba TV", company: "Samba", category: "content", domains: ["*.samba.tv"] }, { name: "Samplicio.us", category: "analytics", domains: ["*.samplicio.us"] }, { name: "Say Media", category: "ad", domains: ["*.saymedia.com"] }, { name: "Scenario", category: "analytics", domains: ["*.getscenario.com"] }, { name: "Schuh (image shard)", company: "Schuh", category: "other", domains: ["d2ob0iztsaxy5v.cloudfront.net"] }, { name: "Science Rockstars", category: "analytics", domains: ["*.persuasionapi.com"] }, { name: "ScientiaMobile", category: "analytics", domains: ["*.wurflcloud.com", "*.wurfl.io"] }, { name: "Scoota", category: "ad", domains: ["*.rockabox.co", "*.scoota.co", "d31i2625d5nv27.cloudfront.net", "dyjnzf8evxrp2.cloudfront.net"] }, { name: "ScribbleLive", category: "ad", domains: ["*.scribblelive.com"] }, { name: "SearchForce", category: "ad", domains: ["*.searchforce.net"] }, { name: "SearchSpring", category: "utility", domains: ["*.searchspring.net"] }, { name: "Searchanise", category: "analytics", domains: ["*.searchanise.com"] }, { name: "Sears Holdings", category: "content", domains: ["*.shld.net"] }, { name: "Secomapp", category: "utility", domains: ["*.secomapp.com"] }, { name: "SecuredVisit", company: "4Cite Marketing", category: "ad", domains: ["*.securedvisit.com"] }, { name: "SecurityMetrics", category: "utility", domains: ["*.securitymetrics.com"] }, { name: "Segmento", category: "ad", domains: ["*.rutarget.ru"] }, { name: "Segmint", category: "analytics", domains: ["*.segmint.net"] }, { name: "Sekindo", category: "content", domains: ["*.sekindo.com"] }, { name: "Seldon", category: "analytics", domains: ["*.rummblelabs.com"] }, { name: "SelectMedia International", category: "content", domains: ["*.selectmedia.asia"] }, { name: "Selligent", category: "ad", domains: ["*.emsecure.net", "*.slgnt.eu", "targetemsecure.blob.core.windows.net"] }, { name: "Sellpoints", category: "analytics", domains: ["*.sellpoints.com"] }, { name: "Semantics3", category: "analytics", domains: ["*.hits.io"] }, { name: "Semasio", category: "analytics", domains: ["*.semasio.net"] }, { name: "Semcasting Site Visitor Attribution", company: "Semcasting", category: "ad", domains: ["*.smartzonessva.com"] }, { name: "Sentifi", category: "social", domains: ["*.sentifi.com"] }, { name: "ServMetric", category: "analytics", domains: ["*.servmetric.com"] }, { name: "ServiceSource International", category: "marketing", domains: ["*.scoutanalytics.net"] }, { name: "ServiceTick", category: "analytics", domains: ["*.servicetick.com"] }, { name: "Servo", company: "Xervo", category: "hosting", domains: ["*.onmodulus.net"] }, { name: "SessionCam", company: "ServiceTick", category: "analytics", domains: ["*.sessioncam.com", "d2oh4tlt9mrke9.cloudfront.net"] }, { name: "Seznam", category: "utility", domains: ["*.imedia.cz"] }, { name: "Sharethrough", category: "ad", domains: ["*.sharethrough.com"] }, { name: "SharpSpring", category: "marketing", domains: ["*.sharpspring.com", "*.marketingautomation.services"] }, { name: "ShopRunner", category: "content", domains: ["*.shoprunner.com", "*.s-9.us"] }, { name: "ShopStorm", category: "utility", domains: ["*.shopstorm.com"] }, { name: "Shopatron", category: "hosting", domains: ["*.shopatron.com"] }, { name: "Shopgate", category: "utility", domains: ["*.shopgate.com"] }, { name: "ShopiMind", company: "ShopIMind", category: "ad", domains: ["*.shopimind.com"] }, { name: "Shopkeeper Tools", category: "utility", domains: ["*.shopkeepertools.com"] }, { name: "Sidecar", category: "other", domains: ["*.getsidecar.com", "d3v27wwd40f0xu.cloudfront.net"] }, { name: "Sidereel", category: "analytics", domains: ["*.sidereel.com"] }, { name: "Sift Science", category: "utility", domains: ["*.siftscience.com"] }, { name: "Signal", category: "tag-manager", domains: ["*.sitetagger.co.uk"] }, { name: "Signyfyd", category: "utility", domains: ["*.signifyd.com"] }, { name: "Silktide", category: "hosting", domains: ["*.silktide.com"] }, { name: "Silverpop", company: "IBM", category: "ad", domains: ["*.mkt912.com", "*.mkt922.com", "*.mkt932.com", "*.mkt941.com", "*.mkt51.net", "*.mkt61.net", "*.pages01.net", "*.pages02.net", "*.pages03.net", "*.pages04.net", "*.pages05.net"] }, { name: "Simplaex", category: "marketing", domains: ["*.simplaex.net"] }, { name: "SimpleReach", category: "analytics", domains: ["*.simplereach.com", "d8rk54i4mohrb.cloudfront.net"] }, { name: "Simplestream", category: "content", domains: ["*.simplestream.com"] }, { name: "Simpli.fi", category: "ad", domains: ["*.simpli.fi"] }, { name: "Simplicity Marketing", category: "ad", domains: ["*.flashtalking.com"] }, { name: "SinnerSchrader Deutschland", category: "ad", domains: ["*.s2Betrieb.de"] }, { name: "Sirv", category: "other", domains: ["*.sirv.com"] }, { name: "Site Meter", category: "analytics", domains: ["*.sitemeter.com"] }, { name: "Site24x7 Real User Monitoring", company: "Site24x7", category: "analytics", domains: ["*.site24x7rum.com"] }, { name: "SiteGainer", category: "analytics", domains: ["*.sitegainer.com", "d191y0yd6d0jy4.cloudfront.net"] }, { name: "SiteScout", company: "Centro", category: "ad", domains: ["*.pixel.ad", "*.sitescout.com"] }, { name: "Siteimprove", category: "utility", domains: ["*.siteimprove.com", "*.siteimproveanalytics.com"] }, { name: "Six Degrees Group", category: "hosting", domains: ["*.fstech.co.uk"] }, { name: "Skimbit", category: "ad", domains: ["*.redirectingat.com", "*.skimresources.com", "*.skimresources.net"] }, { name: "Skimlinks", category: "ad", domains: ["*.skimlinks.com"] }, { name: "SkyGlue Technology", category: "analytics", domains: ["*.skyglue.com"] }, { name: "SkyScanner", category: "content", domains: ["*.skyscanner.net"] }, { name: "Skybet", company: "Bonne Terre t/a Sky Vegas (Sky)", category: "other", domains: ["*.skybet.com"] }, { name: "Skype", category: "other", domains: ["*.skype.com"] }, { name: "Slate Group", category: "content", domains: ["*.cdnslate.com"] }, { name: "SlimCut Media Outstream", company: "SlimCut Media", category: "ad", domains: ["*.freeskreen.com"] }, { name: "Smart Insight Tracking", company: "Emarsys", category: "analytics", domains: ["*.scarabresearch.com"] }, { name: "Smart AdServer", category: "ad", domains: ["*.01net.com", "*.sascdn.com", "*.sasqos.com", "*.smartadserver.com"] }, { name: "SmartFocus", category: "analytics", domains: ["*.emv2.com", "*.emv3.com", "*.predictiveintent.com", "*.smartfocus.com", "*.themessagecloud.com"] }, { name: "Smarter Click", category: "ad", domains: ["*.smct.co", "*.smarterclick.co.uk"] }, { name: "SmarterHQ", category: "analytics", domains: ["*.smarterhq.io", "d1n00d49gkbray.cloudfront.net", "*.smarterremarketer.net"] }, { name: "Smarttools", category: "customer-success", domains: ["*.smartertrack.com"] }, { name: "Smartzer", category: "ad", domains: ["*.smartzer.com"] }, { name: "Snack Media", category: "content", domains: ["*.snack-media.com"] }, { name: "Snacktools", category: "ad", domains: ["*.bannersnack.com"] }, { name: "SnapEngage", category: "customer-success", domains: ["*.snapengage.com"] }, { name: "SnapWidget", category: "content", domains: ["*.snapwidget.com"] }, { name: "Soasta", category: "analytics", domains: ["*.lognormal.net"] }, { name: "SociableLabs", category: "ad", domains: ["*.sociablelabs.net", "*.sociablelabs.com"] }, { name: "Social Annex", category: "customer-success", domains: ["*.socialannex.com"] }, { name: "SocialShopWave", category: "social", domains: ["*.socialshopwave.com"] }, { name: "Socialphotos", category: "social", domains: ["*.slpht.com"] }, { name: "Sociomantic Labs", company: "DunnHumby", category: "ad", domains: ["*.sociomantic.com"] }, { name: "SodaHead", category: "analytics", domains: ["*.sodahead.com"] }, { name: "Softwebzone", category: "hosting", domains: ["*.softwebzone.com"] }, { name: "Sojern", category: "marketing", domains: ["*.sojern.com"] }, { name: "Sokrati", category: "marketing", domains: ["*.sokrati.com"] }, { name: "Sonobi", category: "ad", domains: ["*.sonobi.com"] }, { name: "Sooqr Search", company: "Sooqr", category: "utility", domains: ["*.sooqr.com"] }, { name: "Sophus3", category: "analytics", domains: ["*.s3ae.com", "*.sophus3.com"] }, { name: "Sorenson Media", category: "content", domains: ["*.sorensonmedia.com"] }, { name: "Sortable", category: "ad", domains: ["*.deployads.com"] }, { name: "Sotic", category: "hosting", domains: ["*.sotic.net", "*.soticservers.net"] }, { name: "Soundest", category: "ad", domains: ["*.soundestlink.com", "*.soundest.net"] }, { name: "Sourcepoint", category: "ad", domains: ["*.decenthat.com", "*.fallingfalcon.com", "*.summerhamster.com", "d2lv4zbk7v5f93.cloudfront.net", "d3qxwzhswv93jk.cloudfront.net"] }, { name: "SourceKnowledge", homepage: "https://www.sourceknowledge.com", category: "ad", domains: ["*.provenpixel.com"] }, { name: "SpaceNet", category: "hosting", domains: ["*.nmm.de"] }, { name: "Sparkflow", company: "Intercept Interactive", category: "ad", domains: ["*.sparkflow.net"] }, { name: "Specific Media", category: "ad", domains: ["*.specificmedia.com", "*.adviva.net", "*.specificclick.net"] }, { name: "Spicy", company: "Data-Centric Alliance", category: "ad", domains: ["*.sspicy.ru"] }, { name: "Spoke", category: "customer-success", domains: ["*.121d8.com"] }, { name: "Spongecell", category: "ad", domains: ["*.spongecell.com"] }, { name: "Spot.IM", category: "social", domains: ["*.spot.im", "*.spotim.market"] }, { name: "SpotXchange", category: "ad", domains: ["*.spotxcdn.com", "*.spotxchange.com", "*.spotx.tv"] }, { name: "SpringServer", category: "ad", domains: ["*.springserve.com"] }, { name: "Spylight", category: "other", domains: ["*.spylight.com"] }, { name: "SreamAMG", company: "StreamAMG", category: "other", domains: ["*.streamamg.com"] }, { name: "StackAdapt", category: "ad", domains: ["*.stackadapt.com"] }, { name: "StackExchange", category: "social", domains: ["*.sstatic.net"] }, { name: "Stackla PTY", category: "social", domains: ["*.stackla.com"] }, { name: "Stailamedia", category: "ad", domains: ["*.stailamedia.com"] }, { name: "Stamped.io", category: "analytics", domains: ["*.stamped.io"] }, { name: "Starfield Services Root Certificate Authority", company: "Starfield Technologies", category: "utility", domains: ["*.starfieldtech.com", "ss2.us", "*.ss2.us"] }, { name: "Starfield Technologies", category: "utility", domains: ["*.websiteprotection.com"] }, { name: "StatCounter", category: "analytics", domains: ["*.statcounter.com"] }, { name: "Statful", category: "analytics", domains: ["*.statful.com"] }, { name: "Steelhouse", category: "ad", domains: ["*.steelhousemedia.com"] }, { name: "Steepto", category: "ad", domains: ["*.steepto.com"] }, { name: "StellaService", category: "analytics", domains: ["*.stellaservice.com"] }, { name: "StickyADS.tv", category: "ad", domains: ["*.stickyadstv.com"] }, { name: "STINGRAY", company: "FlexOne", category: "ad", domains: ["*.impact-ad.jp"] }, { name: "Storify", company: "Adobe Systems", category: "social", domains: ["*.storify.com"] }, { name: "Storm Tag Manager", company: "Rakuten", category: "tag-manager", domains: ["*.stormcontainertag.com"] }, { name: "Storygize", category: "ad", domains: ["*.storygize.net"] }, { name: "Strands", category: "utility", domains: ["*.strands.com"] }, { name: "StreamRail", category: "ad", domains: ["*.streamrail.com", "*.streamrail.net"] }, { name: "StrikeAd", category: "ad", domains: ["*.strikead.com"] }, { name: "Struq", company: "Quantcast", category: "ad", domains: ["*.struq.com"] }, { name: "Str\xC3\xB6er Digital Media", category: "ad", domains: ["*.stroeerdigitalmedia.de"] }, { name: "StumbleUpon", category: "content", domains: ["*.stumble-upon.com", "*.stumbleupon.com"] }, { name: "Sub2 Technologies", category: "analytics", domains: ["*.sub2tech.com"] }, { name: "SublimeSkinz", category: "ad", domains: ["*.ayads.co"] }, { name: "Sumo Logic", category: "utility", domains: ["*.sumologic.com"] }, { name: "Sunday Times Driving", category: "content", domains: ["*.driving.co.uk"] }, { name: "SundaySky", category: "ad", domains: ["*.sundaysky.com", "dds6m601du5ji.cloudfront.net"] }, { name: "Sunrise Integration", category: "utility", domains: ["*.sunriseintegration.com"] }, { name: "Supertool Network Technology", category: "analytics", domains: ["*.miaozhen.com"] }, { name: "Survata", category: "analytics", domains: ["*.survata.com"] }, { name: "SurveyGizmo", category: "analytics", domains: ["*.surveygizmo.eu"] }, { name: "SurveyMonkey", category: "analytics", domains: ["*.surveymonkey.com"] }, { name: "Survicate", category: "analytics", domains: ["*.survicate.com"] }, { name: "Sweet Tooth", category: "ad", domains: ["*.sweettooth.io"] }, { name: "Swiftype", category: "utility", domains: ["*.swiftype.com", "*.swiftypecdn.com"] }, { name: "Switch Concepts", category: "ad", domains: ["*.switchadhub.com"] }, { name: "SwitchAds", company: "Switch Concepts", category: "ad", domains: ["*.switchads.com"] }, { name: "Swogo", category: "analytics", domains: ["*.xsellapp.com"] }, { name: "Swoop", category: "ad", domains: ["*.swoop.com"] }, { name: "Symantec", category: "utility", domains: ["*.norton.com", "*.symantec.com", "*.symcb.com", "*.symcd.com"] }, { name: "Syncapse", category: "social", domains: ["*.clickable.net"] }, { name: "Synergetic", category: "ad", domains: ["*.synergetic.ag"] }, { name: "Synthetix", category: "customer-success", domains: ["*.syn-finity.com", "*.synthetix-ec1.com", "*.synthetix.com"] }, { name: "Syte", category: "other", domains: ["*.syteapi.com"] }, { name: "TINT", category: "content", domains: ["*.71n7.com", "d33w9bm0n1egwm.cloudfront.net", "d36hc0p18k1aoc.cloudfront.net", "d3l7tj34e9fc43.cloudfront.net"] }, { name: "TNS (Kantar Group)", category: "analytics", domains: ["*.tns-counter.ru"] }, { name: "TRUSTe", category: "utility", domains: ["*.truste.com"] }, { name: "TV Genius", company: "Ericcson Media Services", category: "content", domains: ["*.tvgenius.net"] }, { name: "TVSquared", category: "ad", domains: ["*.tvsquared.com"] }, { name: "TVTY", category: "ad", domains: ["*.distribeo.com", "*.ogigl.com"] }, { name: "Tactics bvba", category: "hosting", domains: ["*.influid.co"] }, { name: "Tag Inspector", company: "InfoTrust", category: "analytics", domains: ["d22xmn10vbouk4.cloudfront.net"] }, { name: "TagCommander", category: "tag-manager", domains: ["*.commander1.com", "*.tagcommander.com"] }, { name: "Tagboard", category: "social", domains: ["*.tagboard.com"] }, { name: "Taggstar", company: "Taggstar UK", category: "ad", domains: ["*.taggstar.com"] }, { name: "Tail Target", company: "Tail", category: "ad", domains: ["*.tailtarget.com"] }, { name: "Tailored", category: "other", domains: ["d24qm7bu56swjs.cloudfront.net", "dw3vahmen1rfy.cloudfront.net", "*.tailored.to"] }, { name: "Taleo Enterprise Cloud Service", company: "Oracle", category: "content", domains: ["*.taleo.net"] }, { name: "Talkable", category: "ad", domains: ["*.talkable.com", "d2jjzw81hqbuqv.cloudfront.net"] }, { name: "TapSense", category: "ad", domains: ["*.tapsense.com"] }, { name: "Tapad", category: "ad", domains: ["*.tapad.com"] }, { name: "Teads", category: "ad", domains: ["*.teads.tv"] }, { name: "Team Internet Tonic", company: "Team Internet", category: "ad", domains: ["*.dntrax.com"] }, { name: "TechTarget", category: "content", domains: ["*.techtarget.com", "*.ttgtmedia.com"] }, { name: "Technorati", company: "Synacor", category: "ad", domains: ["*.technoratimedia.com"] }, { name: "Teedhaze", category: "content", domains: ["*.fuel451.com"] }, { name: "Tell Apart", category: "analytics", domains: ["*.tellapart.com", "*.tellaparts.com"] }, { name: "Tencent", category: "content", domains: ["*.qq.com", "*.ywxi.net"] }, { name: "Thanx Media", category: "utility", domains: ["*.hawksearch.info"] }, { name: "Thawte", category: "utility", domains: ["*.thawte.com"] }, { name: "Thesis", category: "analytics", homepage: "https://www.thesistesting.com/", domains: ["*.ttsep.com"] }, { name: "The AA", category: "ad", domains: ["*.adstheaa.com"] }, { name: "The ADEX", category: "ad", domains: ["*.theadex.com"] }, { name: "The Best Day", category: "social", domains: ["*.thebestday.com"] }, { name: "The Filter", company: "Exabre", category: "analytics", domains: ["*.thefilter.com"] }, { name: "The Guardian", category: "analytics", domains: ["*.ophan.co.uk"] }, { name: "The Hut Group", category: "content", domains: ["*.thcdn.com"] }, { name: "The Numa Group", category: "other", domains: ["*.hittail.com"] }, { name: "The Publisher Desk", category: "ad", domains: ["*.206ads.com", "*.publisherdesk.com"] }, { name: "The Sydney Morning Herald", company: "Fairfax Media", category: "content", domains: ["*.smh.com.au"] }, { name: "The Wall Street Jounal", category: "content", domains: ["*.wsj.net"] }, { name: "The Wall Street Journal", category: "content", domains: ["*.marketwatch.com"] }, { name: "TheFind", category: "content", domains: ["*.thefind.com"] }, { name: "Thinglink", category: "utility", domains: ["*.thinglink.com"] }, { name: "Thirdpresence", category: "ad", domains: ["*.thirdpresence.com"] }, { name: "ThreatMetrix", category: "utility", domains: ["*.online-metrix.net"] }, { name: "Throtle", homepage: "https://throtle.io/", category: "analytics", domains: ["*.thrtle.com", "*.v12group.com"] }, { name: "TicketMaster", category: "content", domains: ["*.t-x.io", "*.tmcs.net"] }, { name: "TikTok", company: "ByteDance Ltd", homepage: "https://www.tiktok.com/en/", category: "social", domains: ["*.tiktok.com", "*.ipstatp.com"] }, { name: "Tidio Live Chat", company: "Tidio", homepage: "https://www.tidiochat.com/en/", category: "customer-success", domains: ["*.tidiochat.com"] }, { name: "Tiledesk Live Chat", company: "Tiledesk SRL", homepage: "https://www.tiledesk.com/", category: "customer-success", domains: ["*.tiledesk.com"] }, { name: "Time", category: "content", domains: ["*.timeinc.net"] }, { name: "Time2Perf", category: "ad", domains: ["*.time2perf.com"] }, { name: "TinyURL", category: "utility", domains: ["*.tinyurl.com"] }, { name: "Tivo", category: "analytics", domains: ["*.rovicorp.com"] }, { name: "Tom&Co", category: "hosting", domains: ["*.tomandco.uk"] }, { name: "Toms Native Ads", company: "Purch", category: "ad", domains: ["*.natoms.com"] }, { name: "ToneMedia", category: "ad", domains: ["*.clickfuse.com"] }, { name: "Tonic", company: "Team Internet", category: "ad", domains: ["*.dntx.com"] }, { name: "Touch Commerce", category: "customer-success", domains: ["*.inq.com", "*.touchcommerce.com"] }, { name: "ToutApp", category: "ad", domains: ["*.toutapp.com"] }, { name: "TraceView", company: "Solarwinds", category: "analytics", domains: ["*.tracelytics.com", "d2gfdmu30u15x7.cloudfront.net"] }, { name: "TrackJS", category: "analytics", domains: ["*.trackjs.com", "d2zah9y47r7bi2.cloudfront.net"] }, { name: "Tradedoubler", category: "ad", domains: ["*.pvnsolutions.com", "*.tradedoubler.com"] }, { name: "Tradelab", category: "ad", domains: ["*.tradelab.fr"] }, { name: "TrafficFactory", category: "ad", domains: ["*.trafficfactory.biz"] }, { name: "TrafficHunt", category: "ad", domains: ["*.traffichunt.com"] }, { name: "TrafficStars", category: "ad", domains: ["*.trafficstars.com", "*.tsyndicate.com"] }, { name: "Transifex", category: "utility", domains: ["*.transifex.com"] }, { name: "Travelex", category: "utility", domains: ["*.travelex.net", "*.travelex.co.uk"] }, { name: "Travelocity Canada", company: "Travelocity", category: "content", domains: ["*.travelocity.ca"] }, { name: "Travelocity USA", company: "Travelocity", category: "content", domains: ["*.travelocity.com"] }, { name: "Travelzoo", category: "content", domains: ["*.travelzoo.com"] }, { name: "Treasure Data", category: "analytics", domains: ["*.treasuredata.com"] }, { name: "Tremor Video", category: "ad", domains: ["*.tremorhub.com", "*.videohub.tv"] }, { name: "Trialfire", category: "analytics", domains: ["*.trialfire.com"] }, { name: "Tribal Fusion", company: "Exponential Interactive", category: "ad", domains: ["*.tribalfusion.com"] }, { name: "Triblio", category: "marketing", domains: ["*.tribl.io"] }, { name: "Triggered Messaging", company: "Fresh Relevance", category: "ad", domains: ["*.triggeredmessaging.com"] }, { name: "Trinity Mirror", category: "content", domains: ["*.mirror.co.uk"] }, { name: "Trinity Mirror Digital Media", category: "social", domains: ["*.tm-aws.com", "*.icnetwork.co.uk"] }, { name: "TripAdvisor", category: "content", domains: ["*.jscache.com", "*.tacdn.com", "*.tamgrt.com", "*.tripadvisor.com", "*.viator.com", "*.tripadvisor.co.uk"] }, { name: "TripleLift", category: "ad", domains: ["*.3lift.com"] }, { name: "Tru Optik", category: "ad", domains: ["*.truoptik.com"] }, { name: "TruConversion", category: "analytics", domains: ["*.truconversion.com"] }, { name: "Trueffect", category: "marketing", domains: ["*.adlegend.com"] }, { name: "Truefit", category: "analytics", domains: ["*.truefitcorp.com"] }, { name: "Trust Guard", category: "utility", domains: ["*.trust-guard.com"] }, { name: "Trust Pilot", category: "analytics", domains: ["*.trustpilot.com"] }, { name: "Amazon Trust Services", company: "Amazon", category: "utility", domains: ["*.amazontrust.com", "o.ss2.us"] }, { name: "Google Trust Services", company: "Google", category: "utility", domains: ["*.pki.goog"] }, { name: "Let's Encrypt", homepage: "https://letsencrypt.org/", category: "utility", domains: ["*.letsencrypt.org"] }, { name: "TrustX", category: "ad", domains: ["*.trustx.org"] }, { name: "Trusted Shops", category: "utility", domains: ["*.trustedshops.com"] }, { name: "Trustev", company: "TransUnion", category: "utility", domains: ["*.trustev.com"] }, { name: "Trustwave", category: "utility", domains: ["*.trustwave.com"] }, { name: "Tryzens TradeState", company: "Tryzens", category: "analytics", domains: ["*.tryzens-analytics.com"] }, { name: "TubeMogul", category: "ad", domains: ["*.tubemogul.com"] }, { name: "Turn", category: "ad", domains: ["*.turn.com"] }, { name: "Tutorialize", category: "customer-success", domains: ["*.tutorialize.me"] }, { name: "Twenga", category: "content", domains: ["*.twenga.fr", "*.c4tw.net", "*.twenga.co.uk"] }, { name: "Twitframe", company: "Superblock", category: "utility", domains: ["*.twitframe.com"] }, { name: "Twitter Online Conversion Tracking", company: "Twitter", category: "ad", domains: ["*.ads-twitter.com", "analytics.twitter.com"] }, { name: "Twitter Short URL", company: "Twitter", category: "social", domains: ["*.t.co"] }, { name: "Twyn Group", category: "ad", domains: ["*.twyn.com"] }, { name: "Tynt", company: "33 Across", category: "ad", domains: ["*.tynt.com"] }, { name: "Typepad", category: "hosting", domains: ["*.typepad.com"] }, { name: "TyrbooBytes", category: "utility", domains: ["*.turbobytes.net"] }, { name: "UPS i-parcel", company: "UPS", category: "other", domains: ["*.i-parcel.com"] }, { name: "US Media Consulting", category: "ad", domains: ["*.mediade.sk"] }, { name: "Ubertags", category: "tag-manager", domains: ["*.ubertags.com"] }, { name: "Umbel", category: "analytics", domains: ["*.umbel.com"] }, { name: "Unanimis", company: "Switch", category: "ad", domains: ["*.unanimis.co.uk"] }, { name: "Unbounce", category: "ad", domains: ["*.ubembed.com", "*.unbounce.com", "d2xxq4ijfwetlm.cloudfront.net", "d9hhrg4mnvzow.cloudfront.net"] }, { name: "Underdog Media", category: "ad", domains: ["*.underdog.media", "*.udmserve.net"] }, { name: "Understand Digital", category: "ad", domains: ["*.redirecting2.net"] }, { name: "Undertone", company: "Perion", category: "ad", domains: ["*.legolas-media.com"] }, { name: "Unidays", category: "ad", domains: ["*.myunidays.com", "*.unidays.world"] }, { name: "Uniqodo", category: "ad", domains: ["*.uniqodo.com"] }, { name: "Unite", category: "ad", domains: ["*.uadx.com"] }, { name: "United Card Services", category: "utility", domains: ["*.ucs.su"] }, { name: "United Internet", category: "hosting", domains: ["*.uicdn.com"] }, { name: "United Internet Media", category: "ad", domains: ["*.ui-portal.de"] }, { name: "United Internet Media AG", category: "hosting", domains: ["*.tifbs.net", "*.uicdn.net", "*.uimserv.net"] }, { name: "Unknown", category: "other", domains: [] }, { name: "Unruly Media", category: "ad", domains: ["*.unrulymedia.com"] }, { name: "UpBuild", category: "ad", domains: ["*.upbuild.io"] }, { name: "UpSellit", category: "analytics", domains: ["*.upsellit.com"] }, { name: "Upland Software", category: "hosting", domains: ["*.clickability.com"] }, { name: "Airship", category: "marketing", domains: ["*.urbanairship.com", "*.aswpsdkus.com"] }, { name: "UsabilityTools", category: "analytics", domains: ["*.usabilitytools.com"] }, { name: "Usablenet.net", category: "utility", domains: ["*.usablenet.net"] }, { name: "Use It Better", category: "analytics", domains: ["*.useitbetter.com"] }, { name: "User Replay", category: "analytics", domains: ["*.userreplay.net"] }, { name: "UserReport", category: "analytics", domains: ["*.userreport.com"] }, { name: "Userneeds", category: "analytics", domains: ["*.userneeds.dk"] }, { name: "Userzoom", category: "analytics", domains: ["*.userzoom.com"] }, { name: "V12 Retail Finance", category: "utility", domains: ["*.v12finance.com"] }, { name: "Vacaciones eDreams", category: "content", domains: ["*.odistatic.net"] }, { name: "Varick Media Management", category: "ad", domains: ["*.vmmpxl.com"] }, { name: "Vdopia Chocolate", company: "Vdopia", category: "ad", domains: ["*.vdopia.com"] }, { name: "Ve", company: "Ve", homepage: "https://www.ve.com/", category: "marketing", domains: ["*.veinteractive.com", "*.ve.com"] }, { name: "Ve Interactive", company: "Ve", category: "ad", domains: ["*.vepxl1.net", "*.adgenie.co.uk"] }, { name: "Vee24", category: "customer-success", domains: ["*.vee24.com"] }, { name: "Veeseo", category: "content", domains: ["*.veeseo.com"] }, { name: "Venatus Media", category: "marketing", domains: ["*.alcvid.com", "*.venatusmedia.com"] }, { name: "Veoxa", category: "ad", domains: ["*.veoxa.com"] }, { name: "Vergic AB", category: "customer-success", domains: ["*.psplugin.com"] }, { name: "Vergic Engage Platform", company: "Vergic", category: "customer-success", domains: ["*.vergic.com"] }, { name: "Verisign (Symantec)", category: "utility", domains: ["*.verisign.com"] }, { name: "Verizon", category: "utility", domains: ["*.public-trust.com"] }, { name: "Verizon Digital Media CDN", homepage: "https://www.verizondigitalmedia.com/", category: "cdn", domains: ["*.edgecastcdn.net", "*.edgecastdns.net"] }, { name: "Verizon Uplynk", company: "Verizon", category: "content", domains: ["*.uplynk.com"] }, { name: "Vero", company: "Semblance", category: "ad", domains: ["*.getvero.com", "d3qxef4rp70elm.cloudfront.net"] }, { name: "VertaMedia", category: "ad", domains: ["*.vertamedia.com"] }, { name: "Vertical Mass", category: "ad", domains: ["*.vmweb.net"] }, { name: "Vestorly", category: "ad", domains: ["*.oodalab.com"] }, { name: "Vextras", category: "other", domains: ["*.vextras.com"] }, { name: "Viacom", category: "content", domains: ["*.mtvnservices.com"] }, { name: "Vibrant Media", category: "ad", domains: ["*.intellitxt.com", "*.picadmedia.com"] }, { name: "VidPulse", category: "analytics", domains: ["*.vidpulse.com"] }, { name: "Video Media Groep", category: "ad", domains: ["*.vmg.host", "*.inpagevideo.nl"] }, { name: "VideoHub", company: "Tremor Video", category: "ad", domains: ["*.scanscout.com"] }, { name: "Videology", category: "ad", domains: ["*.tidaltv.com"] }, { name: "Vidible", category: "ad", domains: ["*.vidible.tv"] }, { name: "VigLink", category: "ad", domains: ["*.viglink.com"] }, { name: "Vindico", company: "Viant", category: "ad", domains: ["*.vindicosuite.com"] }, { name: "Viocorp International", category: "content", domains: ["*.vioapi.com"] }, { name: "ViralNinjas", category: "ad", domains: ["*.viralninjas.com"] }, { name: "Virool", category: "ad", domains: ["*.virool.com"] }, { name: "Virtual Earth", company: "Microsoft", category: "utility", domains: ["*.virtualearth.net"] }, { name: "Visely", company: "Visely", category: "other", homepage: "https://visely.io/", domains: ["*.visely.io"] }, { name: "VisScore", category: "analytics", domains: ["*.visscore.com", "d2hkbi3gan6yg6.cloudfront.net"] }, { name: "Visible Measures", category: "ad", domains: ["*.visiblemeasures.com"] }, { name: "Visual Studio", company: "Microsoft", category: "utility", domains: ["*.visualstudio.com"] }, { name: "VisualDNA", category: "ad", domains: ["*.visualdna.com"] }, { name: "VisualVisitor", category: "ad", domains: ["*.id-visitors.com"] }, { name: "Vivocha S.p.A", category: "customer-success", domains: ["*.vivocha.com"] }, { name: "Vizu (Nielsen)", category: "analytics", domains: ["*.vizu.com"] }, { name: "Vizury", category: "ad", domains: ["*.vizury.com"] }, { name: "VoiceFive", category: "analytics", domains: ["*.voicefive.com"] }, { name: "Volvelle", company: "Optomaton", category: "ad", domains: ["*.volvelle.tech"] }, { name: "VouchedFor", category: "analytics", domains: ["*.vouchedfor.co.uk"] }, { name: "WARPCACHE", category: "utility", domains: ["*.warpcache.net"] }, { name: "WISHLIST", company: "Shopapps", category: "social", domains: ["*.shopapps.in"] }, { name: "WP Engine", category: "hosting", domains: ["*.wpengine.com"] }, { name: "WalkMe", category: "customer-success", domains: ["*.walkme.com"] }, { name: "Watching That", category: "other", domains: ["*.watchingthat.com"] }, { name: "Wayfair", category: "analytics", domains: ["*.wayfair.com"] }, { name: "Web CEO", category: "other", domains: ["*.websiteceo.com"] }, { name: "Web Dissector", company: "Beijing Gridsum Technologies", category: "analytics", domains: ["*.gridsumdissector.com", "*.webdissector.com"] }, { name: "Web Forensics", category: "analytics", domains: ["*.webforensics.co.uk"] }, { name: "Web Security and Performance", company: "NCC Group", category: "utility", domains: ["*.nccgroup.trust"] }, { name: "WebEngage", category: "customer-success", domains: ["*.webengage.co", "*.webengage.com", "d23nd6ymopvz52.cloudfront.net", "d3701cc9l7v9a6.cloudfront.net"] }, { name: "WebInsight", company: "dotMailer", category: "analytics", domains: ["*.trackedlink.net", "*.trackedweb.net"] }, { name: "WebPageOne Solutions", category: "other", domains: ["*.webpageone.com"] }, { name: "WebSpectator", category: "ad", domains: ["*.webspectator.com"] }, { name: "WebTuna", company: "Application Performance", category: "analytics", domains: ["*.webtuna.com"] }, { name: "WebVideoCore", company: "StreamingVideoProvider", category: "content", domains: ["*.webvideocore.net"] }, { name: "WebWombat", category: "utility", domains: ["*.ic.com.au"] }, { name: "Webcollage", category: "customer-success", domains: ["*.webcollage.net"] }, { name: "Webcore", category: "ad", domains: ["*.onefeed.co.uk"] }, { name: "Webkul", company: "Webkul Software", category: "utility", domains: ["*.webkul.com"] }, { name: "Webmarked", category: "utility", domains: ["*.webmarked.net"] }, { name: "Weborama", category: "ad", domains: ["*.weborama.com", "*.weborama.fr"] }, { name: "WebpageFX", category: "ad", domains: ["*.leadmanagerfx.com"] }, { name: "Webphone", company: "IP WEB SERVICES", category: "customer-success", domains: ["*.webphone.net"] }, { name: "Webselect selectcommerce", company: "Webselect Internet", category: "hosting", domains: ["*.webselect.net"] }, { name: "Webthinking", category: "hosting", domains: ["*.webthinking.co.uk"] }, { name: "Webtrekk", category: "analytics", domains: ["*.wbtrk.net", "*.webtrekk-asia.net", "*.webtrekk.net", "*.wt-eu02.net", "*.wt-safetag.com"] }, { name: "Webtrends", category: "analytics", domains: ["*.webtrends.com", "*.webtrendslive.com", "d1q62gfb8siqnm.cloudfront.net"] }, { name: "Webtype", category: "cdn", domains: ["*.webtype.com"] }, { name: "White Ops", category: "utility", domains: ["*.acexedge.com", "*.tagsrvcs.com"] }, { name: "Whitespace", category: "ad", domains: ["*.whitespacers.com"] }, { name: "WhosOn Live Chat Software", category: "customer-success", domains: ["*.whoson.com"] }, { name: "Wibbitz", category: "other", domains: ["*.wibbitz.com"] }, { name: "Wide Area Communications", category: "hosting", domains: ["*.widearea.co.uk"] }, { name: "WideOrbit", category: "marketing", domains: ["*.admaym.com"] }, { name: "William Reed", category: "content", domains: ["*.wrbm.com"] }, { name: "WillyFogg.com", category: "content", domains: ["*.willyfogg.com"] }, { name: "Windows", company: "Microsoft", category: "utility", domains: ["*.windowsupdate.com"] }, { name: "WisePops", category: "utility", domains: ["*.wisepops.com"] }, { name: "Wishlist King", company: "Appmate", category: "other", homepage: "https://appmate.io/", domains: ["*.appmate.io"] }, { name: "Wishpond Technologies", category: "marketing", domains: ["*.wishpond.com", "*.wishpond.net"] }, { name: "WizRocket Technologies", category: "analytics", domains: ["*.wzrkt.com"] }, { name: "Woopra", category: "analytics", domains: ["*.woopra.com"] }, { name: "Woosmap", category: "utility", domains: ["*.woosmap.com"] }, { name: "WorkCast", category: "hosting", domains: ["*.workcast.net"] }, { name: "World News Media", category: "content", domains: ["*.wnmedia.co.uk"] }, { name: "Worldpay", category: "utility", domains: ["*.worldpay.com"] }, { name: "Wow Analytics", category: "analytics", domains: ["*.wowanalytics.co.uk"] }, { name: "Wowcher", category: "ad", domains: ["*.wowcher.co.uk"] }, { name: "Wufoo", category: "utility", domains: ["*.wufoo.com"] }, { name: "Wunderkind", category: "marketing", homepage: "https://www.wunderkind.co/", domains: ["*.bounceexchange.com", "*.bouncex.net", "*.wknd.ai", "*.cdnbasket.net", "*.cdnwidget.com"] }, { name: "Wyng", category: "ad", domains: ["*.offerpop.com"] }, { name: "XMLSHOP", category: "hosting", domains: ["*.xmlshop.biz"] }, { name: "XiTi", company: "AT Internet", category: "analytics", domains: ["*.xiti.com", "*.aticdn.net"], homepage: "https://www.atinternet.com/en/" }, { name: "YUDU", category: "content", domains: ["*.yudu.com"] }, { name: "Yahoo! Ad Exchange", company: "Yahoo!", category: "ad", domains: ["*.yieldmanager.com", "*.browsiprod.com"] }, { name: "Yahoo! JAPAN Ads", company: "Yahoo! JAPAN", category: "ad", homepage: "https://marketing.yahoo.co.jp/service/yahooads/", domains: ["yads.c.yimg.jp", "s.yimg.jp", "b92.yahoo.co.jp"] }, { name: "Yahoo! Tag Manager", company: "Yahoo! JAPAN", category: "tag-manager", homepage: "https://marketing.yahoo.co.jp/service/tagmanager/", domains: ["*.yjtag.jp"] }, { name: "Yahoo! Small Business", company: "Yahoo!", category: "hosting", domains: ["*.aabacosmallbusiness.com"] }, { name: "Yellow Robot", category: "ad", domains: ["*.backinstock.org"] }, { name: "YieldPartners", category: "ad", domains: ["*.yieldpartners.com"] }, { name: "Yieldbot", category: "ad", domains: ["*.yldbt.com"] }, { name: "Yieldify", category: "ad", domains: ["*.yieldify.com", "*.yieldifylabs.com", "d33wq5gej88ld6.cloudfront.net", "dwmvwp56lzq5t.cloudfront.net"] }, { name: "Yieldlab", category: "ad", domains: ["*.yieldlab.net"] }, { name: "Yieldmo", category: "ad", domains: ["*.yieldmo.com"] }, { name: "Yieldr", category: "ad", domains: ["*.254a.com"] }, { name: "Yo", category: "utility", domains: ["*.yopify.com"] }, { name: "YoYo", category: "utility", domains: ["*.goadservices.com"] }, { name: "Yotpo", homepage: "https://www.yotpo.com/", category: "marketing", domains: ["*.yotpo.com", "*.swellrewards.com"] }, { name: "Yottaa", category: "hosting", domains: ["*.yottaa.com", "*.yottaa.net"] }, { name: "YourAmigo", category: "utility", domains: ["*.youramigo.com"] }, { name: "YuMe", category: "ad", domains: ["*.yume.com", "*.yumenetworks.com"] }, { name: "Yummley", category: "other", domains: ["*.yummly.com"] }, { name: "ZEDO", category: "ad", domains: ["*.zedo.com"] }, { name: "Zafu", category: "analytics", domains: ["*.zafu.com"] }, { name: "Zaius", category: "ad", domains: ["*.zaius.com"] }, { name: "Zamplus ad", category: "ad", domains: ["*.zampda.net"] }, { name: "Zanox", category: "ad", domains: ["*.zanox.com", "*.zanox.ws"] }, { name: "Zapper", category: "utility", domains: ["*.zapper.com"] }, { name: "Zarget", category: "analytics", domains: ["*.zarget.com"] }, { name: "Zemanta", category: "ad", domains: ["*.zemanta.com"] }, { name: "Zen Internet", category: "other", domains: ["*.zyen.com"] }, { name: "Zenovia Digital Exchange", category: "ad", domains: ["*.rhythmxchange.com", "*.zenoviaexchange.com"] }, { name: "ZergNet", category: "content", domains: ["*.zergnet.com"] }, { name: "Zerogrey", category: "hosting", domains: ["*.zerogrey.com"] }, { name: "Ziff Davis Tech", category: "ad", domains: ["*.adziff.com", "*.zdbb.net"] }, { name: "Zmags", category: "marketing", domains: ["*.zmags.com"] }, { name: "Zolando", category: "content", domains: ["*.ztat.net"] }, { name: "Zoover", category: "analytics", domains: ["*.zoover.nl", "*.zoover.co.uk"] }, { name: "Zopim", category: "customer-success", domains: ["*.zopim.io"] }, { name: "[24]7", category: "customer-success", domains: ["*.247-inc.net", "*.247inc.net", "d1af033869koo7.cloudfront.net"] }, { name: "adKernel", category: "ad", domains: ["*.adkernel.com"] }, { name: "adMarketplace", company: "AMPexchange", category: "ad", domains: ["*.ampxchange.com", "*.admarketplace.net"] }, { name: "addtocalendar", category: "utility", domains: ["*.addtocalendar.com"] }, { name: "adnanny", category: "ad", domains: ["*.adserver01.de"] }, { name: "affilinet", category: "ad", domains: ["*.reussissonsensemble.fr", "*.successfultogether.co.uk"] }, { name: "audioBoom", category: "social", domains: ["*.audioboom.com", "*.audioboo.fm"] }, { name: "bPay by Barclaycard", company: "Barclays Bank", category: "utility", domains: ["*.bpay.co.uk"] }, { name: "bRealTime", category: "ad", domains: ["*.brealtime.com"] }, { name: "bd4travel", category: "analytics", domains: ["*.bd4travel.com"] }, { name: "bizinformation-VOID", company: "bizinformation", category: "analytics", domains: ["*.bizinformation.org"] }, { name: "carrot", category: "social", domains: ["*.sharebutton.co"] }, { name: "cloudIQ", category: "analytics", domains: ["*.cloud-iq.com"] }, { name: "comScore", category: "analytics", domains: ["*.adxpose.com", "*.comscore.com", "*.sitestat.com", "*.zqtk.net"] }, { name: "content.ad", category: "ad", domains: ["*.content.ad"] }, { name: "d3 Media", company: "d3 Technologies", category: "other", domains: ["*.d3sv.net"] }, { name: "dexiMEDIA", category: "ad", domains: ["*.deximedia.com"] }, { name: "dianomi", category: "ad", domains: ["*.dianomi.com", "*.dianomioffers.co.uk"] }, { name: "donReach", category: "social", domains: ["*.donreach.com"] }, { name: "dotMailer", category: "ad", domains: ["*.dmtrk.com", "*.dotmailer.com", "*.emlfiles.com"] }, { name: "dotMailer Surveys", company: "dotMailer", category: "analytics", domains: ["*.dotmailer-surveys.com"] }, { name: "dstillery", category: "ad", domains: ["*.dstillery.com", "*.media6degrees.com"] }, { name: "eBay", category: "ad", domains: ["*.ebay.com", "*.ebayimg.com", "*.fetchback.com"] }, { name: "eBay Enterprise", category: "hosting", domains: ["*.csdata1.com", "*.gsipartners.com"] }, { name: "eBuzzing", company: "Teads Managed Services", category: "ad", domains: ["*.ebz.io"] }, { name: "eDigital Research", category: "customer-success", domains: ["*.edigitalresearch.com", "*.edigitalsurvey.com", "*.edrcdn.com", "*.ecustomeropinions.com"] }, { name: "eGain", category: "analytics", domains: ["*.analytics-egain.com", "*.egain.com"] }, { name: "eHost", category: "hosting", domains: ["*.ehosts.net"] }, { name: "eKomi", category: "analytics", domains: ["*.ekomi.com", "*.ekomi.de"] }, { name: "eWAY", company: "Web Active Pty", category: "utility", domains: ["*.eway.com.au"] }, { name: "eXTReMe digital", category: "analytics", domains: ["*.extreme-dm.com"] }, { name: "eXelate", category: "ad", domains: ["*.exelator.com"] }, { name: "ecommercefeed.net", category: "marketing", domains: ["*.ecommercefeed.net"] }, { name: "engage:BDR", category: "ad", domains: ["*.bnmla.com", "*.ebdr3.com"] }, { name: "epago", category: "ad", domains: ["*.adaos-ads.net"] }, { name: "epoq internet services", category: "analytics", domains: ["*.epoq.de"] }, { name: "etouches", category: "hosting", domains: ["*.etouches.com"] }, { name: "etracker", category: "analytics", domains: ["*.etracker.com", "*.etracker.de"] }, { name: "everestads.com", category: "content", domains: ["*.verestads.net"] }, { name: "exebid.DCA", company: "Data-Centric Alliance", category: "ad", domains: ["*.exe.bid"] }, { name: "eyeReturn Marketing", category: "marketing", domains: ["*.eyereturn.com"] }, { name: "feedoptimise", category: "hosting", domains: ["*.feedoptimise.com", "d1w78njrm56n7g.cloudfront.net"] }, { name: "fifty-five", category: "ad", domains: ["*.55labs.com"] }, { name: "fluct", category: "ad", domains: ["*.adingo.jp"] }, { name: "freegeoip.net", company: "(community-funded)", category: "utility", domains: ["*.freegeoip.net"] }, { name: "freewheel.tv", category: "content", domains: ["*.fwmrm.net"] }, { name: "gnatta", category: "customer-success", domains: ["*.gnatta.com"] }, { name: "home.pl", category: "hosting", domains: ["*.nscontext.eu"] }, { name: "hyfn", category: "ad", domains: ["*.hyfn.com"] }, { name: "iAdvize SAS", category: "customer-success", domains: ["*.iadvize.com"] }, { name: "iBillboard", category: "ad", domains: ["*.ibillboard.com"] }, { name: "iCrossing", category: "ad", domains: ["*.ic-live.com"] }, { name: "iFactory", company: "RDW Group", category: "hosting", domains: ["*.ifactory.com"] }, { name: "iGoDigital", category: "analytics", domains: ["*.igodigital.com"] }, { name: "iJento", company: "Fopsha", category: "ad", domains: ["*.ijento.com"] }, { name: "iPage", category: "hosting", domains: ["*.ipage.com"] }, { name: "iPerceptions", category: "customer-success", domains: ["*.iperceptions.com"] }, { name: "iTunes", company: "Apple", category: "content", domains: ["*.mzstatic.com"] }, { name: "imgix", company: "Zebrafish Labs", category: "utility", domains: ["*.imgix.net"] }, { name: "infogr.am", category: "utility", domains: ["*.infogr.am", "*.jifo.co"] }, { name: "iotec", category: "analytics", domains: ["*.dsp.io"] }, { name: "iovation", category: "utility", domains: ["*.iesnare.com"] }, { name: "ipinfo.io", category: "utility", domains: ["*.ipinfo.io"] }, { name: "issuu", category: "content", domains: ["*.issuu.com", "*.isu.pub"] }, { name: "iubenda", category: "utility", domains: ["*.iubenda.com"] }, { name: "j2 Cloud Services", category: "ad", domains: ["*.campaigner.com"] }, { name: "jsonip.com", category: "analytics", domains: ["*.jsonip.com"] }, { name: "linkpulse", category: "analytics", domains: ["*.lp4.io"] }, { name: "loGo_net", category: "analytics", domains: ["*.logo-net.co.uk"] }, { name: "mainADV", category: "ad", domains: ["*.httptrack.com", "*.solocpm.com"] }, { name: "mbr targeting", category: "ad", domains: ["*.m6r.eu"] }, { name: "media.ventive", category: "ad", domains: ["*.contentspread.net"] }, { name: "metrigo", category: "ad", domains: ["*.metrigo.com"] }, { name: "minicabit.com", category: "content", domains: ["*.minicabit.com"] }, { name: "mobiManage", category: "hosting", domains: ["*.mobimanage.com"] }, { name: "moving-pictures", category: "other", domains: ["*.moving-pictures.biz", "*.v6-moving-pictures.com", "*.vtstat.com", "*.moving-pictures.de"] }, { name: "my6sense", category: "ad", domains: ["*.mynativeplatform.com"] }, { name: "myThings", category: "ad", domains: ["*.mythings.com", "*.mythingsmedia.net"] }, { name: "mymovies", category: "content", domains: ["*.mymovies.net"] }, { name: "nRelate-VOID", company: "nRelate", category: "content", domains: ["*.nrelate.com"] }, { name: "nToklo", category: "analytics", domains: ["*.ntoklo.com"] }, { name: "neXeps", category: "ad", domains: ["*.nexeps.com"] }, { name: "ninemsn Pty.", category: "utility", domains: ["*.ninemsn.com.au"] }, { name: "nugg.ad", category: "ad", domains: ["*.nuggad.net"] }, { name: "numero interactive", company: "numero", category: "ad", domains: ["*.numerointeractive.com"] }, { name: "optMD", company: "Optimax Media Delivery", category: "ad", domains: ["*.optmd.com"] }, { name: "otracking.com", category: "analytics", domains: ["*.otracking.com"] }, { name: "paysafecard", company: "Paysafe Group", category: "utility", domains: ["*.paysafecard.com"] }, { name: "piano", category: "ad", domains: ["*.npttech.com", "*.tinypass.com"] }, { name: "piclike", category: "ad", domains: ["*.piclike.us"] }, { name: "placehold.it", category: "utility", domains: ["*.placehold.it"] }, { name: "plista", category: "ad", domains: ["*.plista.com"] }, { name: "prebid.org", category: "utility", domains: ["*.prebid.org"] }, { name: "reEmbed", category: "other", domains: ["*.reembed.com"] }, { name: "reddit", category: "social", domains: ["*.reddit.com", "*.redditstatic.com"] }, { name: "rewardStyle.com", category: "ad", domains: ["*.rewardstyle.com"] }, { name: "rss2json", category: "utility", domains: ["*.rss2json.com"] }, { name: "sage Pay", company: "Sage Pay Europe", category: "utility", domains: ["*.sagepay.com"] }, { name: "section.io", category: "utility", domains: ["*.squixa.net"] }, { name: "smartclip", category: "ad", domains: ["*.smartclip.net"] }, { name: "sovrn", category: "ad", domains: ["*.lijit.com"] }, { name: "stackpile.io", company: "StackPile", category: "tag-manager", domains: ["*.stackpile.io"] }, { name: "template-help.com", category: "hosting", domains: ["*.template-help.com"] }, { name: "test", company: "test only", category: "other", domains: ["*.testtesttest.com"] }, { name: "trueAnthem", category: "social", domains: ["*.tru.am"] }, { name: "tweetmeme-VOID", company: "tweetmeme", category: "analytics", domains: ["*.tweetmeme.com"] }, { name: "uLogin", category: "other", domains: ["*.ulogin.ru"] }, { name: "uLogix", category: "ad", domains: ["*.ulogix.ru"] }, { name: "ucfunnel ucX", company: "ucfunnel", category: "ad", domains: ["*.aralego.com"] }, { name: "up-value", category: "ad", domains: ["*.up-value.de"] }, { name: "wywy", category: "ad", domains: ["*.wywy.com", "*.wywyuserservice.com"] }, { name: "CDK Dealer Management", company: "CDK Global", homepage: "https://www.cdkglobal.com/us", category: "hosting", domains: ["*.assets-cdk.com"] }, { name: "fam", company: "Fing Co Ltd.", homepage: "http://admin.fam-ad.com/report/", category: "ad", domains: ["*.fam-ad.com"] }, { name: "zypmedia", category: "ad", domains: ["*.extend.tv"] }, { name: "codigo", homepage: "https://www.codigo.se", category: "analytics", domains: ["*.codigo.se"] }, { name: "Playground", homepage: "https://playground.xyz", category: "ad", domains: ["*.playground.xyz"] }, { name: "RAM", homepage: "https://www2.rampanel.com/", category: "analytics", domains: ["*.rampanel.com"] }, { name: "Adition", homepage: "https://www.adition.com", category: "ad", domains: ["*.adition.com"] }, { name: "Widespace", homepage: "https://www.widespace.com", category: "ad", domains: ["*.widespace.com"] }, { name: "Colpirio", homepage: "https://www.widespace.com", category: "analytics", domains: ["*.colpirio.com"] }, { name: "Brandmetrics", homepage: "https://www.brandmetrics.com", category: "analytics", domains: ["*.brandmetrics.com"] }, { name: "EasyAd", homepage: "https://web.easy-ads.com/", category: "ad", domains: ["*.easy-ads.com"] }, { name: "Glimr", homepage: "https://glimr.io/", category: "analytics", domains: ["*.glimr.io"] }, { name: "Webtreck", homepage: "https://www.webtrekk.com/en/home/", category: "analytics", domains: ["*.wcfbc.net"] }, { name: "DigiTrust", homepage: "http://www.digitru.st/", category: "analytics", domains: ["*.digitru.st"] }, { name: "Kantar Sifo", homepage: "https://www.kantarsifo.se", category: "analytics", domains: ["*.research-int.se"] }, { name: "Concert", homepage: "https://concert.io/", category: "ad", domains: ["*.concert.io"] }, { name: "Emerse", homepage: "https://www.emerse.com/", category: "ad", domains: ["*.emerse.com"] }, { name: "Iterate", homepage: "https://iteratehq.com/", category: "analytics", domains: ["*.iteratehq.com"] }, { name: "Cookiebot", homepage: "https://www.cookiebot.com/", category: "utility", domains: ["*.cookiebot.com"] }, { name: "Netlify", homepage: "https://www.netlify.com/", category: "utility", domains: ["*.netlify.com", "*.netlifyusercontent.com"] }, { name: "Scroll", homepage: "https://scroll.com/", category: "utility", domains: ["*.scroll.com"] }, { name: "Consumable", homepage: "https://consumable.com/", category: "ad", domains: ["*.serverbid.com"] }, { name: "DMD Marketing", homepage: "https://www.dmdconnects.com/", category: "ad", domains: ["*.medtargetsystem.com"] }, { name: "Catchpoint", homepage: "https://www.catchpoint.com/", category: "analytics", domains: ["*.3gl.net", "*.3genlabs.net"] }, { name: "Terminus", homepage: "https://terminus.com/", category: "ad", domains: ["*.terminus.services"] }, { name: "Acceptable Ads", homepage: "https://acceptableads.com/", category: "ad", domains: ["*.aaxads.com", "*.aaxdetect.com"] }, { name: "ClearBrain", homepage: "https://www.clearbrain.com/", category: "analytics", domains: ["*.clearbrain.com"] }, { name: "Optanon", homepage: "https://www.cookielaw.org/", category: "consent-provider", domains: ["*.onetrust.com", "*.cookielaw.org"] }, { name: "TrustArc", homepage: "https://www.trustarc.com/", category: "utility", domains: ["*.trustarc.com"] }, { name: "iSpot.tv", homepage: "https://www.ispot.tv/", category: "ad", domains: ["*.ispot.tv"] }, { name: "RevJet", homepage: "https://www.revjet.com/", category: "ad", domains: ["*.revjet.com"] }, { name: "atlasRTX", homepage: "https://www.atlasrtx.com/", category: "customer-success", domains: ["*.atlasrtx.com"] }, { name: "ContactAtOnce", homepage: "https://www.contactatonce.com/", category: "customer-success", domains: ["*.contactatonce.com"] }, { name: "Algolia", homepage: "https://www.algolia.com/", category: "utility", domains: ["*.algolianet.com", "*.algolia.net", "*.algolia.io"] }, { name: "EMX Digital", homepage: "https://emxdigital.com", category: "ad", domains: ["*.emxdgt.com"] }, { name: "Moxie", homepage: "https://www.gomoxie.com/", category: "utility", domains: ["*.gomoxie.solutions"] }, { name: "Scripps Network Digital", homepage: "https://www.scrippsnetworksdigital.com/", category: "ad", domains: ["*.snidigital.com"] }, { name: "TurnTo", homepage: "https://www.turntonetworks.com/", category: "utility", domains: ["*.turnto.com"] }, { name: "Quantum Metric", homepage: "https://www.quantummetric.com/", category: "analytics", domains: ["*.quantummetric.com"] }, { name: "Carbon Ads", homepage: "https://www.carbonads.net/", category: "ad", domains: ["*.carbonads.net", "*.carbonads.com"] }, { name: "Ably", homepage: "https://www.ably.io/", category: "utility", domains: ["*.ably.io"] }, { name: "Sectigo", homepage: "https://sectigo.com/", category: "utility", domains: ["*.sectigo.com"] }, { name: "Specless", homepage: "https://gospecless.com/", category: "ad", domains: ["*.specless.tech"] }, { name: "Loggly", homepage: "https://www.loggly.com/", category: "analytics", domains: ["*.loggly.com", "d9jmv9u00p0mv.cloudfront.net"] }, { name: "Intent Media", homepage: "https://intent.com/", category: "ad", domains: ["*.intentmedia.net"] }, { name: "Supership", homepage: "https://supership.jp/", category: "ad", domains: ["*.socdm.com"] }, { name: "F@N Communications", homepage: "https://www.fancs.com/", category: "ad", domains: ["*.ladsp.com"] }, { name: "Vidyard", homepage: "https://www.vidyard.com/", category: "utility", domains: ["*.vidyard.com"] }, { name: "RapidSSL", homepage: "https://www.rapidssl.com/", category: "utility", domains: ["*.rapidssl.com"] }, { name: "Coherent Path", homepage: "https://coherentpath.com/", category: "utility", domains: ["*.coherentpath.com"] }, { name: "Attentive", homepage: "https://attentivemobile.com/", category: "ad", domains: ["*.attn.tv", "*.attentivemobile.com"] }, { name: "emetriq", homepage: "https://www.emetriq.com/", category: "ad", domains: ["*.emetriq.de", "*.xplosion.de"] }, { name: "Bonzai", homepage: "https://www.bonzai.co/", category: "ad", domains: ["*.bonzai.co"] }, { name: "Freshchat", homepage: "https://www.freshworks.com/live-chat-software/", category: "customer-success", domains: ["*.freshchat.com", "*.freshworksapi.com"], products: [{ name: "Freshdesk Messaging", urlPatterns: ["wchat.freshchat.com"], facades: [{ name: "Freshdesk Messaging (formerly Freshchat) Facade", repo: "https://github.com/coliff/freshdesk-messaging-facade/" }] }] }, { name: "Contentful", homepage: "https://www.contentful.com/", category: "utility", domains: ["*.contentful.com"] }, { name: "PureCars", homepage: "https://www.purecars.com/", category: "marketing", domains: ["*.purecars.com"] }, { name: "Tray Commerce", homepage: "https://www.tray.com.br/", category: "marketing", domains: ["*.tcdn.com.br"] }, { name: "AdScore", homepage: "https://www.adscore.com/", category: "ad", domains: ["*.adsco.re"] }, { name: "WebsiteBuilder.com", homepage: "https://www.websitebuilder.com", category: "hosting", domains: ["*.mywebsitebuilder.com"] }, { name: "mParticle", homepage: "https://www.mparticle.com/", category: "utility", domains: ["*.mparticle.com"] }, { name: "Ada", homepage: "https://www.ada.support/", category: "customer-success", domains: ["*.ada.support"] }, { name: "Quora Ads", homepage: "https://www.quora.com/business/", category: "ad", domains: ["*.quora.com"] }, { name: "Auth0", homepage: "https://auth0.com/", category: "utility", domains: ["*.auth0.com"] }, { name: "Bridgewell DSP", homepage: "https://www.bridgewell.com/", category: "ad", domains: ["*.scupio.com"] }, { name: "Wicked Reports", homepage: "https://www.wickedreports.com/", category: "marketing", domains: ["*.wickedreports.com"] }, { name: "Jaywing", homepage: "https://jaywing.com/", category: "marketing", domains: ["*.jaywing.com"] }, { name: "Holimetrix", homepage: "https://u360.d-bi.fr/", category: "marketing", domains: ["*.d-bi.fr"] }, { name: "iZooto", homepage: "https://www.izooto.com", category: "marketing", domains: ["*.izooto.com"] }, { name: "Ordergroove", homepage: "https://www.ordergroove.com/", category: "marketing", domains: ["*.ordergroove.com"] }, { name: "PageSense", homepage: "https://www.zoho.com/pagesense/", category: "analytics", domains: ["*.pagesense.io"] }, { name: "Vizzit", homepage: "https://www.vizzit.se", category: "analytics", domains: ["*.vizzit.se"] }, { name: "Click Guardian", homepage: "https://www.clickguardian.co.uk/", category: "ad", domains: ["*.clickguardian.app", "*.clickguardian.co.uk"] }, { name: "Smartsupp", company: "Smartsupp.com", homepage: "https://www.smartsupp.com", category: "customer-success", domains: ["*.smartsuppchat.com", "*.smartsupp.com", "smartsupp-widget-161959.c.cdn77.org", "*.smartsuppcdn.com"] }, { name: "Smartlook", company: "Smartsupp.com", homepage: "https://www.smartlook.com/", category: "analytics", domains: ["*.smartlook.com"] }, { name: "Luigis Box", company: "Luigis Box", homepage: "https://www.luigisbox.com/", category: "utility", domains: ["*.luigisbox.com"] }, { name: "Targito", company: "VIVmail.cz", homepage: "https://www.targito.com", category: "marketing", domains: ["*.targito.com"] }, { name: "Foxentry", company: "AVANTRO", homepage: "https://foxentry.cz/", category: "utility", domains: ["*.foxentry.cz"] }, { name: "Pendo", homepage: "https://www.pendo.io", category: "analytics", domains: ["*.pendo.io"] }, { name: "Braze", homepage: "https://www.braze.com", category: "analytics", domains: ["*.appboycdn.com"] }, { name: "Usersnap", homepage: "https://usersnap.com", category: "customer-success", domains: ["*.usersnap.com"] }, { name: "Rewardful", homepage: "https://www.getrewardful.com", category: "analytics", domains: ["*.wdfl.co"] }, { name: "Launch Darkly", homepage: "https://launchdarkly.com", category: "utility", domains: ["*.launchdarkly.com"] }, { name: "Statuspage", company: "Atlassian", homepage: "https://www.statuspage.io", category: "utility", domains: ["*.statuspage.io"] }, { name: "HyperInzerce", homepage: "https://hyperinzerce.cz", category: "ad", domains: ["*.hyperinzerce.cz"] }, { name: "POWr", homepage: "https://www.powr.io", category: "utility", domains: ["*.powr.io"] }, { name: "Coral", company: "Coral", homepage: "https://coralproject.net", category: "content", domains: ["*.coral.coralproject.net"] }, { name: "Bolt", homepage: "https://www.bolt.com/", category: "utility", domains: ["*.bolt.com"] }, { name: "Judge.me", homepage: "https://judge.me/", category: "marketing", domains: ["*.judge.me"] }, { name: "Tilda", homepage: "https://tilda.cc/", category: "hosting", domains: ["*.tildacdn.com"] }, { name: "SalesLoft", homepage: "https://salesloft.com/", category: "marketing", domains: ["*.salesloft.com"] }, { name: "Accessibe Accessibility Overlay", company: "Accessibe", homepage: "https://accessibe.com/", category: "utility", domains: ["*.accessibe.com", "*.acsbapp.com", "*.acsbap.com"] }, { name: "Builder", homepage: "https://www.builder.io/", category: "hosting", domains: ["*.builder.io"] }, { name: "Pepperjam", homepage: "https://www.pepperjam.com/", category: "marketing", domains: ["*.pepperjam.com", "*.affiliatetechnology.com"] }, { name: "Reach", homepage: "https://withreach.com/", category: "utility", domains: ["*.gointerpay.net"] }, { name: "Chameleon", homepage: "https://www.trychameleon.com/", category: "marketing", domains: ["*.trychameleon.com"] }, { name: "Matomo", company: "InnoCraft", homepage: "https://matomo.org/", category: "analytics", domains: ["*.matomo.cloud"] }, { name: "Segmanta", homepage: "https://segmanta.com/", category: "marketing", domains: ["*.segmanta.com"] }, { name: "Podsights", homepage: "https://podsights.com/", category: "marketing", domains: ["*.pdst.fm", "us-central1-adaptive-growth.cloudfunctions.net"] }, { name: "Chatwoot", homepage: "https://www.chatwoot.com/", category: "customer-success", domains: ["*.chatwoot.com"] }, { name: "Crisp", homepage: "https://crisp.chat/", category: "customer-success", domains: ["*.crisp.chat"] }, { name: "Admiral CMP", homepage: "https://www.getadmiral.com", category: "consent-provider", domains: ["admiral.mgr.consensu.org", "*.admiral.mgr.consensu.org"] }, { name: "Adnuntius CMP", homepage: "https://adnuntius.com", category: "consent-provider", domains: ["adnuntiusconsent.mgr.consensu.org", "*.adnuntiusconsent.mgr.consensu.org"] }, { name: "Clickio CMP", homepage: "https://clickio.com", category: "consent-provider", domains: ["clickio.mgr.consensu.org", "*.clickio.mgr.consensu.org"] }, { name: "AppConsent CMP", homepage: "https://appconsent.io/en", category: "consent-provider", domains: ["appconsent.mgr.consensu.org", "*.appconsent.mgr.consensu.org"] }, { name: "DMG Media CMP", homepage: "https://www.dmgmedia.co.uk", category: "consent-provider", domains: ["dmgmedia.mgr.consensu.org", "*.dmgmedia.mgr.consensu.org"] }, { name: "Axel Springer CMP", homepage: "https://www.axelspringer.com", category: "consent-provider", domains: ["axelspringer.mgr.consensu.org", "*.axelspringer.mgr.consensu.org"] }, { name: "Bedrock CMP", homepage: "https://www.bedrockstreaming.com", category: "consent-provider", domains: ["bedrock.mgr.consensu.org", "*.bedrock.mgr.consensu.org"] }, { name: "BMIND CMP", homepage: "https://www.bmind.es", category: "consent-provider", domains: ["bmind.mgr.consensu.org", "*.bmind.mgr.consensu.org"] }, { name: "Borlabs CMP", homepage: "https://borlabs.io", category: "consent-provider", domains: ["borlabs.mgr.consensu.org", "*.borlabs.mgr.consensu.org"] }, { name: "Civic CMP", homepage: "https://www.civicuk.com", category: "consent-provider", domains: ["cookiecontrol.mgr.consensu.org", "*.cookiecontrol.mgr.consensu.org"] }, { name: "Commanders Act CMP", homepage: "https://www.commandersact.com", category: "consent-provider", domains: ["commandersact.mgr.consensu.org", "*.commandersact.mgr.consensu.org"] }, { name: "Complianz CMP", homepage: "https://complianz.io/", category: "consent-provider", domains: ["complianz.mgr.consensu.org", "*.complianz.mgr.consensu.org"] }, { name: "Consent Desk CMP", homepage: "https://www.consentdesk.com/", category: "consent-provider", domains: ["consentdesk.mgr.consensu.org", "*.consentdesk.mgr.consensu.org"] }, { name: "Consent Manager CMP", homepage: "https://consentmanager.net", category: "consent-provider", domains: ["consentmanager.mgr.consensu.org", "*.consentmanager.mgr.consensu.org"] }, { name: "Conversant CMP", homepage: "https://www.conversantmedia.eu/", category: "consent-provider", domains: ["conversant.mgr.consensu.org", "*.conversant.mgr.consensu.org"] }, { name: "Cookie Information CMP", homepage: "https://www.cookieinformation.com/", category: "consent-provider", domains: ["cookieinformation.mgr.consensu.org", "*.cookieinformation.mgr.consensu.org"] }, { name: "Cookiebot CMP", homepage: "https://www.cookiebot.com", category: "consent-provider", domains: ["cookiebot.mgr.consensu.org", "*.cookiebot.mgr.consensu.org"] }, { name: "Truendo CMP", homepage: "https://truendo.com/", category: "consent-provider", domains: ["truendo.mgr.consensu.org", "*.truendo.mgr.consensu.org"] }, { name: "Dentsu CMP", homepage: "https://www.dentsuaegisnetwork.de/", category: "consent-provider", domains: ["dan.mgr.consensu.org", "*.dan.mgr.consensu.org"] }, { name: "Didomi CMP", homepage: "https://www.didomi.io/en/", category: "consent-provider", domains: ["didomi.mgr.consensu.org", "*.didomi.mgr.consensu.org"] }, { name: "Ensighten CMP", homepage: "https://www.ensighten.com/", category: "consent-provider", domains: ["ensighten.mgr.consensu.org", "*.ensighten.mgr.consensu.org"] }, { name: "Evidon CMP", homepage: "https://evidon.com", category: "consent-provider", domains: ["evidon.mgr.consensu.org", "*.evidon.mgr.consensu.org"] }, { name: "Ezoic CMP", homepage: "https://www.ezoic.com/", category: "consent-provider", domains: ["ezoic.mgr.consensu.org", "*.ezoic.mgr.consensu.org"] }, { name: "Gemius CMP", homepage: "https://www.gemius.com", category: "consent-provider", domains: ["gemius.mgr.consensu.org", "*.gemius.mgr.consensu.org"] }, { name: "NitroPay CMP", homepage: "https://nitropay.com/", category: "consent-provider", domains: ["nitropay.mgr.consensu.org", "*.nitropay.mgr.consensu.org"] }, { name: "Google FundingChoices", homepage: "https://fundingchoices.google.com/start/", category: "consent-provider", domains: ["fundingchoices.mgr.consensu.org", "*.fundingchoices.mgr.consensu.org", "fundingchoicesmessages.google.com", "*.fundingchoicesmessages.google.com"] }, { name: "Gravito CMP", homepage: "https://www.gravito.net/", category: "consent-provider", domains: ["gravito.mgr.consensu.org", "*.gravito.mgr.consensu.org"] }, { name: "ID Ward CMP", homepage: "https://id-ward.com/enterprise", category: "consent-provider", domains: ["idward.mgr.consensu.org", "*.idward.mgr.consensu.org"] }, { name: "iubenda CMP", homepage: "https://www.iubenda.com", category: "consent-provider", domains: ["iubenda.mgr.consensu.org", "*.iubenda.mgr.consensu.org"] }, { name: "Jump CMP", homepage: "https://jumpgroup.it/", category: "consent-provider", domains: ["avacy.mgr.consensu.org", "*.avacy.mgr.consensu.org"] }, { name: "LiveRamp CMP", homepage: "https://liveramp.com/", category: "consent-provider", domains: ["faktor.mgr.consensu.org", "*.faktor.mgr.consensu.org"] }, { name: "Madvertise CMP", homepage: "https://madvertise.com/en/", category: "consent-provider", domains: ["madvertise.mgr.consensu.org", "*.madvertise.mgr.consensu.org"] }, { name: "Mairdumont Netletic CMP", homepage: "https://www.mairdumont-netletix.com/", category: "consent-provider", domains: ["mdnxmp.mgr.consensu.org", "*.mdnxmp.mgr.consensu.org"] }, { name: "Marfeel CMP", homepage: "https://www.marfeel.com/", category: "consent-provider", domains: ["marfeel.mgr.consensu.org", "*.marfeel.mgr.consensu.org"] }, { name: "Mediavine CMP", homepage: "https://www.mediavine.com/", category: "consent-provider", domains: ["mediavine.mgr.consensu.org", "*.mediavine.mgr.consensu.org"] }, { name: "ConsentServe CMP", homepage: "https://www.consentserve.com/", category: "consent-provider", domains: ["consentserve.mgr.consensu.org", "*.consentserve.mgr.consensu.org"] }, { name: "Next14 CMP", homepage: "https://www.next14.com/", category: "consent-provider", domains: ["next14.mgr.consensu.org", "*.next14.mgr.consensu.org"] }, { name: "AdRoll CMP", homepage: "https://www.adroll.com/", category: "consent-provider", domains: ["adroll.mgr.consensu.org", "*.adroll.mgr.consensu.org"] }, { name: "Ogury CMP", homepage: "https://www.ogury.com/", category: "consent-provider", domains: ["ogury.mgr.consensu.org", "*.ogury.mgr.consensu.org"] }, { name: "OneTag CMP", homepage: "https://onetag.net", category: "consent-provider", domains: ["onetag.mgr.consensu.org", "*.onetag.mgr.consensu.org"] }, { name: "OneTrust CMP", homepage: "https://onetrust.com", category: "consent-provider", domains: ["onetrust.mgr.consensu.org", "*.onetrust.mgr.consensu.org"] }, { name: "optAd360 CMP", homepage: "https://www.optad360.com/", category: "consent-provider", domains: ["optad360.mgr.consensu.org", "*.optad360.mgr.consensu.org"] }, { name: "Osano CMP", homepage: "https://www.osano.com", category: "consent-provider", domains: ["osano.mgr.consensu.org", "*.osano.mgr.consensu.org"] }, { name: "Playwire CMP", homepage: "https://www.playwire.com", category: "consent-provider", domains: ["playwire.mgr.consensu.org", "*.playwire.mgr.consensu.org"] }, { name: "Pulselive CMP", homepage: "https://www.pulselive.com", category: "consent-provider", domains: ["pulselive.mgr.consensu.org", "*.pulselive.mgr.consensu.org"] }, { name: "Quantcast Choice", homepage: "https://quantcast.com", category: "consent-provider", domains: ["quantcast.mgr.consensu.org", "*.quantcast.mgr.consensu.org"] }, { name: "RCS Pubblicita CMP", homepage: "http://www.rcspubblicita.it/site/home.html", category: "consent-provider", domains: ["rcsmediagroup.mgr.consensu.org", "*.rcsmediagroup.mgr.consensu.org"] }, { name: "Rich Audience CMP", homepage: "https://richaudience.com", category: "consent-provider", domains: ["richaudience.mgr.consensu.org", "*.richaudience.mgr.consensu.org"] }, { name: "Ringier Axel Springer CMP", homepage: "https://www.ringieraxelspringer.pl/en/home/", category: "consent-provider", domains: ["rasp.mgr.consensu.org", "*.rasp.mgr.consensu.org"] }, { name: "Secure Privacy CMP", homepage: "https://secureprivacy.ai/", category: "consent-provider", domains: ["secureprivacy.mgr.consensu.org", "*.secureprivacy.mgr.consensu.org"] }, { name: "Securiti CMP", homepage: "https://securiti.ai/", category: "consent-provider", domains: ["securiti.mgr.consensu.org", "*.securiti.mgr.consensu.org"] }, { name: "Seznam.cz CMP", homepage: "https://www.seznam.cz/", category: "consent-provider", domains: ["seznam.mgr.consensu.org", "*.seznam.mgr.consensu.org"] }, { name: "ShareThis CMP", homepage: "https://sharethis.com", category: "consent-provider", domains: ["sharethis.mgr.consensu.org", "*.sharethis.mgr.consensu.org"] }, { name: "ShinyStat CMP", homepage: "https://www.shinystat.com", category: "consent-provider", domains: ["shinystat.mgr.consensu.org", "*.shinystat.mgr.consensu.org"] }, { name: "Sibbo CMP", homepage: "https://sibboventures.com/en/", category: "consent-provider", domains: ["sibboventures.mgr.consensu.org", "*.sibboventures.mgr.consensu.org"] }, { name: "Singlespot CMP", homepage: "https://www.singlespot.com/en", category: "consent-provider", domains: ["singlespot.mgr.consensu.org", "*.singlespot.mgr.consensu.org"] }, { name: "Sirdata CMP", homepage: "https://www.sirdata.com", category: "consent-provider", domains: ["sddan.mgr.consensu.org", "*.sddan.mgr.consensu.org"] }, { name: "Snigel CMP", homepage: "https://snigel.com", category: "consent-provider", domains: ["snigelweb.mgr.consensu.org", "*.snigelweb.mgr.consensu.org"] }, { name: "Sourcepoint CMP", homepage: "https://sourcepoint.com", category: "consent-provider", domains: ["sourcepoint.mgr.consensu.org", "*.sourcepoint.mgr.consensu.org"] }, { name: "Pubtech CMP", homepage: "https://www.pubtech.ai/", category: "consent-provider", domains: ["pubtech.mgr.consensu.org", "*.pubtech.mgr.consensu.org"] }, { name: "AdMetrics Pro CMP", homepage: "https://admetricspro.com", category: "consent-provider", domains: ["cmp.mgr.consensu.org", "*.cmp.mgr.consensu.org"] }, { name: "Traffective CMP", homepage: "https://traffective.com", category: "consent-provider", domains: ["traffective.mgr.consensu.org", "*.traffective.mgr.consensu.org"] }, { name: "UniConsent CMP", homepage: "https://www.uniconsent.com", category: "consent-provider", domains: ["uniconsent.mgr.consensu.org", "*.uniconsent.mgr.consensu.org", "cmp.uniconsent.com", "*.uniconsent.com"] }, { name: "TrustArc CMP", homepage: "https://trustarc.com/", category: "consent-provider", domains: ["trustarc.mgr.consensu.org", "*.trustarc.mgr.consensu.org"] }, { name: "Usercentrics CMP", homepage: "https://usercentrics.com", category: "consent-provider", domains: ["usercentrics.mgr.consensu.org", "*.usercentrics.mgr.consensu.org", "*.usercentrics.eu", "*.services.usercentrics.eu"] }, { name: "WebAds CMP", homepage: "https://www.webads.nl/", category: "consent-provider", domains: ["webads.mgr.consensu.org", "*.webads.mgr.consensu.org"] }, { name: "Trustcommander", company: "Commandersact", homepage: "https://www.commandersact.com", category: "consent-provider", domains: ["*.trustcommander.net"] }, { name: "Hubvisor", homepage: "https://www.hubvisor.io", category: "ad", domains: ["*.hubvisor.io"] }, { name: "Castle", homepage: "https://castle.io", category: "utility", domains: ["*.castle.io", "d2t77mnxyo7adj.cloudfront.net"] }, { name: "Wigzo", homepage: "https://www.wigzo.com/", category: "marketing", domains: ["*.wigzo.com", "*.wigzopush.com"] }, { name: "Convertful", homepage: "https://convertful.com/", category: "marketing", domains: ["*.convertful.com"] }, { name: "OpenLink", company: "MediaWallah", homepage: "https://www.mediawallah.com/", category: "ad", domains: ["*.mediawallahscript.com"] }, { name: "TPMN", company: "TPMN", homepage: "http://tpmn.io/", category: "ad", domains: ["*.tpmn.co.kr"] }, { name: "HERO", company: "Klarna", homepage: "https://www.usehero.com/", category: "customer-success", domains: ["*.usehero.com"] }, { name: "Zync", company: "Zeta Global", homepage: "https://zetaglobal.com/", category: "marketing", domains: ["*.rezync.com"] }, { name: "AdFuel Video", company: "AdFuel", homepage: "https://goadfuel.com/", category: "ad", domains: ["*.videoplayerhub.com"] }, { name: "Prefix Box AI Search", company: "Prefix Box", homepage: "https://www.prefixbox.com/", category: "utility", domains: ["*.prefixbox.com"] }, { name: "SpeedSize Service Worker", company: "SpeedSize", homepage: "https://speedsize.com/", category: "utility", domains: ["di6367dava8ow.cloudfront.net", "d2d22nphq0yz8t.cloudfront.net"] }, { name: "Vonage Video API", company: "Vonage", homepage: "https://www.vonage.com/communications-apis/video/", category: "video", domains: ["*.opentok.com"] }, { name: "Checkout.com", company: "Checkout.com", homepage: "https://www.checkout.com", category: "utility", domains: ["*.checkout.com"] }, { name: "Noibu", company: "Noibu", homepage: "https://www.noibu.com", category: "utility", domains: ["*.noibu.com"] }, { name: "Clarity", company: "Microsoft", homepage: "https://clarity.microsoft.com/", category: "utility", domains: ["*.clarity.ms"] }, { name: "goinstore", company: "Emplifi", homepage: "https://goinstore.com/", category: "customer-success", domains: ["*.goinstore.com"] }, { name: "SegmentStream", company: "SegmentStream", homepage: "https://segmentstream.com/", category: "marketing", domains: ["*.segmentstream.com"] }, { name: "Amazon Associates", company: "Amazon", homepage: "https://affiliate-program.amazon.co.uk/", category: "marketing", domains: ["*.associates-amazon.com"] }, { name: "DotMetrics", company: "Ipsos", homepage: "https://www.dotmetrics.net/", category: "analytics", domains: ["*.dotmetrics.net"] }, { name: "Truffle Bid", company: "Truffle", homepage: "https://truffle.bid/", category: "ad", domains: ["*.truffle.bid"] }, { name: "Hybrid", company: "Hybrid", homepage: "https://hybrid.ai/", category: "ad", domains: ["*.hybrid.ai"] }, { name: "AdMan Media", company: "AdMan", homepage: "https://admanmedia.com/", category: "video", domains: ["*.admanmedia.com"] }, { name: "ID5 Identity Cloud", company: "ID5", homepage: "https://id5.io/", category: "ad", domains: ["id5-sync.com", "*.id5-sync.com"] }, { name: "Audience Rate", company: "Audience Rate Limited", homepage: "https://www.audiencerate.com/", category: "ad", domains: ["*.audrte.com"] }, { name: "Seedtag", company: "Seedtag Advertising", homepage: "https://www.seedtag.com/", category: "ad", domains: ["*.seedtag.com"] }, { name: "IVI", company: "IVI Technologies", homepage: "http://ivitechnologies.com/", category: "ad", domains: ["*.ivitrack.com"] }, { name: "Sportradar", company: "Sportradar", homepage: "https://www.sportradar.com/", category: "ad", domains: ["*.sportradarserving.com"] }, { name: "ZEOTAP", company: "ZEOTAP", homepage: "https://zeotap.com/", category: "ad", domains: ["*.zeotap.com"] }, { name: "Web Content Assessor", company: "TMT Digital", homepage: "https://mediatrust.com/", category: "ad", domains: ["*.webcontentassessor.com"] }, { name: "Genie", company: "Media Force", homepage: "https://hellogenie.com/", category: "ad", domains: ["*.mfadsrvr.com"] }, { name: "mediarithmics", company: "mediarithmics", homepage: "https://www.mediarithmics.com/", category: "ad", domains: ["*.mediarithmics.com"] }, { name: "Ozone Project", company: "The Ozone Project", homepage: "https://www.ozoneproject.com/", category: "ad", domains: ["*.the-ozone-project.com"] }, { name: "FiftyAurora", company: "Fifty", homepage: "https://fifty.io/", category: "ad", domains: ["*.fiftyt.com"] }, { name: "smadex", company: "entravision", homepage: "https://smadex.com/", category: "ad", domains: ["*.smadex.com"] }, { name: "AWX", company: "Trinity Mirror", category: "ad", domains: ["*.tm-awx.com"] }, { name: "XPO", company: "Knorex", category: "ad", homepage: "https://www.knorex.com/", domains: ["*.brand-display.com"] }, { name: "Viafoura", company: "Viafoura", category: "ad", homepage: "https://viafoura.com/", domains: ["*.viafoura.co", "*.viafoura.net"] }, { name: "Adnami", company: "Adnami", category: "ad", homepage: "https://www.adnami.io/", domains: ["*.adnami.io"] }, { name: "LiveRamp Privacy Manager", company: "LiveRamp", category: "ad", homepage: "https://liveramp.com/privacy-legal-compliance/", domains: ["*.privacymanager.io"] }, { name: "Onfocus", company: "Onfocus SAS", category: "ad", domains: ["*.4dex.io"] }, { name: "viewTag", company: "Advanced Store", category: "ad", domains: ["*.ad4m.at"] }, { name: "MRP Prelytics", company: "Market Resource Partners", category: "ad", homepage: "https://www.mrpfd.com/", domains: ["*.mrpdata.net"] }, { name: "iPROM", company: "iPROM", category: "ad", homepage: "https://iprom.eu/", domains: ["*.iprom.net"] }, { name: "Plausible", company: "Plausible", homepage: "https://plausible.io/", category: "analytics", domains: ["*.plausible.io"] }, { name: "Micro Analytics", company: "Micro Analytics", homepage: "https://microanalytics.io/", category: "analytics", domains: ["padmin.microanalytics.io", "www.microanalytics.io", "dev.microanalytics.io", "status.microanalytics.io"] }, { name: "Scale8", company: "Scale8", homepage: "https://scale8.com/", category: "analytics", domains: ["www.scale8.com", "api-dev.scale8.com", "cdn.scale8.com", "ui.scale8.com"] }, { name: "Cabin", company: "Cabin", homepage: "https://withcabin.com/", category: "analytics", domains: ["*.withcabin.com"] }, { name: "Appcues", company: "Appcues", homepage: "https://www.appcues.com/", category: "analytics", domains: ["*.appcues.com"] }, { name: "Fathom Analytics", company: "Fathom", homepage: "https://usefathom.com/", category: "analytics", domains: ["*.usefathom.com"] }, { name: "Clearbit", company: "Clearbit", homepage: "https://clearbit.com/", category: "analytics", domains: ["*.clearbitjs.com", "*.clearbitscripts.com", "*.clearbit.com"] }, { name: "G2", company: "G2", homepage: "https://www.g2.com/", category: "utility", domains: ["*.g2.com", "*.g2crowd.com"] }, { name: "Navu", company: "Navu", homepage: "https://navu.co/", category: "ad", domains: ["*.navu.co"] }, { name: "InZynk", company: "InZynk", homepage: "https://inzynk.com/", category: "ad", domains: ["*.inzynk.com", "*.inzynk.io"] }, { name: "Integrate", company: "Integrate", homepage: "https://www.integrate.com/", category: "ad", domains: ["*.integrate.com", "*.listenloop.com"] }, { name: "Ad Lightning", company: "Boltive", homepage: "https://www.adlightning.com/", category: "ad", domains: ["*.adlightning.com"] }, { name: "GeoEdge", company: "GeoEdge", homepage: "https://www.geoedge.com/", category: "ad", domains: ["*.geoedge.com", "*.geoedge.be"] }, { name: "Doofinder", company: "Doofinder", homepage: "https://www.doofinder.com/", category: "utility", domains: ["cdn.doofinder.com"] }, { name: "Revlifter", company: "Revlifter", homepage: "https://www.revlifter.com/", category: "utility", domains: ["assets.revlifter.com"] }, { name: "Didomi", company: "Didomi", homepage: "https://www.didomi.io/", category: "consent-provider", domains: ["sdk.privacy-center.org", "api.privacy-center.org"] }, { name: "Pubperf Analytics", company: "Pubperf", homepage: "https://www.pubperf.com/", category: "analytics", domains: ["*.pubperf.com"] }];
  }
});
var require_nostats = __commonJS({
  "package/lib/subsets/nostats.js"(exports, module) {
    "use strict";
    var { createAPIFromDataset } = require_create_entity_finder_api();
    var entities = require_entities_nostats();
    module.exports = createAPIFromDataset(entities);
  }
});
var require_nostats_subset = __commonJS({
  "package/nostats-subset.js"(exports, module) {
    module.exports = require_nostats();
  }
});
var nostats_subset_default = require_nostats_subset();
export {
  nostats_subset_default as ThirdPartyWeb
};
//# sourceMappingURL=third-party-web.js.map
