"use strict";
import "../../legacy/legacy.js";
import { html, render } from "../../lit/lit.js";
import * as VisualLogging from "../../visual_logging/visual_logging.js";
import markdownLinkStyles from "./markdownLink.css.js";
import { getMarkdownLink } from "./MarkdownLinksMap.js";
export class MarkdownLink extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  #linkText = "";
  #linkUrl = "";
  set data(data) {
    const { key, title } = data;
    const markdownLink = getMarkdownLink(key);
    this.#linkText = title;
    this.#linkUrl = markdownLink;
    this.#render();
  }
  #render() {
    const output = html`
      <style>${markdownLinkStyles}</style>
      <x-link class="devtools-link" href=${this.#linkUrl} jslog=${VisualLogging.link().track({ click: true })}
      >${this.#linkText}</x-link>`;
    render(output, this.#shadow, { host: this });
  }
}
customElements.define("devtools-markdown-link", MarkdownLink);
//# sourceMappingURL=MarkdownLink.js.map
