/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import"../polymer/polymer_bundled.min.js";import{dom}from"../polymer/polymer_bundled.min.js";var lastTouchPosition={pageX:0,pageY:0};var lastRootTarget=null;var lastScrollableNodes=[];var scrollEvents=["wheel","mousewheel","DOMMouseScroll","touchstart","touchmove"];var _boundScrollHandler;var currentLockingElement;`TODO(modulizer): A namespace named Polymer.IronScrollManager was\ndeclared here. The surrounding comments should be reviewed,\nand this string can then be deleted`;export{currentLockingElement};export function elementIsScrollLocked(element){var lockingElement=currentLockingElement;if(lockingElement===undefined){return false}var scrollLocked;if(_hasCachedLockedElement(element)){return true}if(_hasCachedUnlockedElement(element)){return false}scrollLocked=!!lockingElement&&lockingElement!==element&&!_composedTreeContains(lockingElement,element);if(scrollLocked){_lockedElementCache.push(element)}else{_unlockedElementCache.push(element)}return scrollLocked}export function pushScrollLock(element){if(_lockingElements.indexOf(element)>=0){return}if(_lockingElements.length===0){_lockScrollInteractions()}_lockingElements.push(element);currentLockingElement=_lockingElements[_lockingElements.length-1];_lockedElementCache=[];_unlockedElementCache=[]}export function removeScrollLock(element){var index=_lockingElements.indexOf(element);if(index===-1){return}_lockingElements.splice(index,1);currentLockingElement=_lockingElements[_lockingElements.length-1];_lockedElementCache=[];_unlockedElementCache=[];if(_lockingElements.length===0){_unlockScrollInteractions()}}export const _lockingElements=[];export let _lockedElementCache=null;export let _unlockedElementCache=null;export function _hasCachedLockedElement(element){return _lockedElementCache.indexOf(element)>-1}export function _hasCachedUnlockedElement(element){return _unlockedElementCache.indexOf(element)>-1}export function _composedTreeContains(element,child){var contentElements;var distributedNodes;var contentIndex;var nodeIndex;if(element.contains(child)){return true}contentElements=dom(element).querySelectorAll("content,slot");for(contentIndex=0;contentIndex<contentElements.length;++contentIndex){distributedNodes=dom(contentElements[contentIndex]).getDistributedNodes();for(nodeIndex=0;nodeIndex<distributedNodes.length;++nodeIndex){if(distributedNodes[nodeIndex].nodeType!==Node.ELEMENT_NODE)continue;if(_composedTreeContains(distributedNodes[nodeIndex],child)){return true}}}return false}export function _scrollInteractionHandler(event){if(event.cancelable&&_shouldPreventScrolling(event)){event.preventDefault()}if(event.targetTouches){var touch=event.targetTouches[0];lastTouchPosition.pageX=touch.pageX;lastTouchPosition.pageY=touch.pageY}}export{_boundScrollHandler};export function _lockScrollInteractions(){_boundScrollHandler=_boundScrollHandler||_scrollInteractionHandler.bind(undefined);for(var i=0,l=scrollEvents.length;i<l;i++){document.addEventListener(scrollEvents[i],_boundScrollHandler,{capture:true,passive:false})}}export function _unlockScrollInteractions(){for(var i=0,l=scrollEvents.length;i<l;i++){document.removeEventListener(scrollEvents[i],_boundScrollHandler,{capture:true,passive:false})}}export function _shouldPreventScrolling(event){var target=dom(event).rootTarget;if(event.type!=="touchmove"&&lastRootTarget!==target){lastRootTarget=target;lastScrollableNodes=_getScrollableNodes(dom(event).path)}if(!lastScrollableNodes.length){return true}if(event.type==="touchstart"){return false}var info=_getScrollInfo(event);return!_getScrollingNode(lastScrollableNodes,info.deltaX,info.deltaY)}export function _getScrollableNodes(nodes){var scrollables=[];var lockingIndex=nodes.indexOf(currentLockingElement);for(var i=0;i<=lockingIndex;i++){if(nodes[i].nodeType!==Node.ELEMENT_NODE){continue}var node=nodes[i];var style=node.style;if(style.overflow!=="scroll"&&style.overflow!=="auto"){style=window.getComputedStyle(node)}if(style.overflow==="scroll"||style.overflow==="auto"){scrollables.push(node)}}return scrollables}export function _getScrollingNode(nodes,deltaX,deltaY){if(!deltaX&&!deltaY){return}var verticalScroll=Math.abs(deltaY)>=Math.abs(deltaX);for(var i=0;i<nodes.length;i++){var node=nodes[i];var canScroll=false;if(verticalScroll){canScroll=deltaY<0?node.scrollTop>0:node.scrollTop<node.scrollHeight-node.clientHeight}else{canScroll=deltaX<0?node.scrollLeft>0:node.scrollLeft<node.scrollWidth-node.clientWidth}if(canScroll){return node}}}export function _getScrollInfo(event){var info={deltaX:event.deltaX,deltaY:event.deltaY};if("deltaX"in event){}else if("wheelDeltaX"in event&&"wheelDeltaY"in event){info.deltaX=-event.wheelDeltaX;info.deltaY=-event.wheelDeltaY}else if("wheelDelta"in event){info.deltaX=0;info.deltaY=-event.wheelDelta}else if("axis"in event){info.deltaX=event.axis===1?event.detail:0;info.deltaY=event.axis===2?event.detail:0}else if(event.targetTouches){var touch=event.targetTouches[0];info.deltaX=lastTouchPosition.pageX-touch.pageX;info.deltaY=lastTouchPosition.pageY-touch.pageY}return info}